import { readdir } from "node:fs/promises";

import { build_protocol } from "./build_protocol.ts";

const files = await readdir(`${import.meta.dir}/../protocols`);
const interfaces = await Promise.all(
  files.map(async (file) => {
    return build_protocol(file);
  })
);

let out_file = `/** This file has been generated by \`task generate-protocol\`  */
import { Sender } from "../Sender.ts";
import { Debug_Send_Message } from "../Send_Message.ts";
import { Object_ID, File_Descriptor, UInt32, Int32, Fixed, version } from "../wayland_types.ts";
import {DecodeState_Data} from "../Decode_State.ts";
import { Wayland_Client } from "../Wayland_Client.ts";
import {wayland_debug_time_only, show_wayland_surface_and_buffer} from "../debug.ts" with {type: "macro"};
import {Global_Ids} from "../GlobalObjects.ts";

export let debug_statement = 0;

`;
for (const int of interfaces) {
  out_file += int;
}

// const file_split = Bun.argv[2].split("/");
// const file_name = file_split[file_split.length - 1];

Bun.write(`${process.env["OUT_DIR"]}/wayland.xml.ts`, out_file);
