CREATE TABLE graph_theme (
        graphthemeid            number(20)              DEFAULT '0'     NOT NULL,
        description             nvarchar2(64)           DEFAULT ''      ,
        theme           nvarchar2(64)           DEFAULT ''      ,
        backgroundcolor         nvarchar2(6)            DEFAULT 'F0F0F0'        ,
        graphcolor              nvarchar2(6)            DEFAULT 'FFFFFF'        ,
        graphbordercolor                nvarchar2(6)            DEFAULT '222222'        ,
        gridcolor               nvarchar2(6)            DEFAULT 'CCCCCC'        ,
        maingridcolor           nvarchar2(6)            DEFAULT 'AAAAAA'        ,
        gridbordercolor         nvarchar2(6)            DEFAULT '000000'        ,
        textcolor               nvarchar2(6)            DEFAULT '202020'        ,
        highlightcolor          nvarchar2(6)            DEFAULT 'AA4444'        ,
        leftpercentilecolor             nvarchar2(6)            DEFAULT '11CC11'        ,
        rightpercentilecolor            nvarchar2(6)            DEFAULT 'CC1111'        ,
        noneworktimecolor               nvarchar2(6)            DEFAULT 'E0E0E0'        ,
        gridview                number(10)              DEFAULT 1       NOT NULL,
        legendview              number(10)              DEFAULT 1       NOT NULL,
        PRIMARY KEY (graphthemeid)
);
CREATE INDEX graph_theme_1 on graph_theme (description);
CREATE INDEX graph_theme_2 on graph_theme (theme);

INSERT INTO graph_theme VALUES (1,'Original Blue','css_ob.css','F0F0F0','FFFFFF','333333','CCCCCC','AAAAAA','000000','222222','AA4444','11CC11','CC1111','E0E0E0',1,1);
INSERT INTO graph_theme VALUES (2,'Black & Blue','css_bb.css','333333','0A0A0A','888888','222222','4F4F4F','EFEFEF','0088FF','CC4444','1111FF','FF1111','1F1F1F',1,1);
