CREATE PROCEDURE zbx_drop_indexes()
LANGUAGE SQL
BEGIN
	DECLARE idx_exists INTEGER;

	SELECT COUNT(*) INTO idx_exists FROM SYSCAT.INDEXES WHERE INDNAME='NODE_CKSUM_1';
	IF idx_exists > 0 THEN
		DROP INDEX NODE_CKSUM_1;
	END IF;

	SELECT COUNT(*) INTO idx_exists FROM SYSCAT.INDEXES WHERE INDNAME='NODE_CKSUM_CKSUM_1';
	IF idx_exists > 0 THEN
		DROP INDEX NODE_CKSUM_CKSUM_1;
	END IF;
END
/
CALL zbx_drop_indexes()
/
DROP PROCEDURE zbx_drop_indexes
/
ALTER TABLE node_cksum ALTER COLUMN nodeid SET WITH DEFAULT NULL
/
REORG TABLE node_cksum
/
ALTER TABLE node_cksum ALTER COLUMN recordid SET WITH DEFAULT NULL
/
REORG TABLE node_cksum
/
DELETE FROM node_cksum WHERE NOT nodeid IN (SELECT nodeid FROM nodes)
/
ALTER TABLE node_cksum ADD CONSTRAINT c_node_cksum_1 FOREIGN KEY (nodeid) REFERENCES nodes (nodeid) ON DELETE CASCADE
/
