Keeping the API documentation, JS Library, and Typescript definition aligned is tricky.

# Process Explained
Currently, here are the pieces involved in generating docs and definitions:

## API docs are generated from the `typedoc` command in the `gulpfile.js`
It contains the list of files that we expose for external use

Just run `gulp typedoc` to create the docs.

Docs are also automatically generated when `npm version` is run.

## Typescript definitions are generated via tsconfig.json
We set declarations to true to cause definitions to be generated.

We set stripInternals to true to cause certain files to be ignored.

Typescript definitions currently are generated by default for all classes.
This is because there are lots of inter-dependencies, and it is difficult to selectively
generate definitions at this time.

We hope this becomes easier as typescript goes forward. Things that would help:

* Excluding private methods
* Deriving declarations from index.ts or other entry-point
* Simpler tsd dependency management

Right now, this is a struggle.

# Ongoing Care and Feeding
When adding new top-level classes that are meant to be exposed, they must:

## Be added to the list of classes in index.ts
This is then compiled down to index.d.ts and index.js

## Be added to the list of files in the typedoc task in Gulpfile.js
This is to ensure they are generated as part of the API docs