---
id: videos
title: Videos
permalink: videos.html
prev: thinking-in-react.html
next: complementary-tools.html
---

### Rethinking best practices - JSConf.eu

<iframe width="650" height="315" src="//www.youtube.com/embed/x7cQ3mrcKaY" frameborder="0" allowfullscreen></iframe>

"At Facebook and Instagram, we’re trying to push the limits of what’s possible on the web with React. My talk will start with a brief introduction to the framework, and then dive into three controversial topics: Throwing out the notion of templates and building views with JavaScript, “re-rendering” your entire application when your data changes, and a lightweight implementation of the DOM and events." -- [Pete Hunt](http://www.petehunt.net/)


### Thinking in react - tagtree.tv

A [tagtree.tv](http://tagtree.tv/) video conveying the principles of [Thinking in React](/react/docs/thinking-in-react.html) while building a simple app
<figure>[![](/react/img/docs/thinking-in-react-tagtree.png)](http://tagtree.tv/thinking-in-react)</figure>


### Secrets of the Virtual DOM - MtnWest JS

<iframe width="560" height="315" src="//www.youtube.com/embed/h3KksH8gfcQ" frameborder="0" allowfullscreen></iframe>

"In this talk I’ll be discussing why we built a virtual DOM, how it compares to other systems, and its relevance to the future of browser technologies." -- [Pete Hunt](http://www.petehunt.net/)


### Going big with React ###

"On paper, all those JS frameworks look promising: clean implementations, quick code design, flawless execution. But what happens when you stress test Javascript? What happens when you throw 6 megabytes of code at it? In this talk, we'll investigate how React performs in a high stress situation, and how it has helped our team build safe code on a massive scale."
<figure>[![](https://i.vimeocdn.com/video/481670116_650.jpg)](https://skillsmatter.com/skillscasts/5429-going-big-with-react#video)</figure>


### CodeWinds

[Pete Hunt](http://www.petehunt.net/) talked with [Jeff Barczewski](http://jeff.barczewski.com/) about React in CodeWinds Episode 4.
<figure>[![](/react/img/docs/codewinds-004.png)](http://codewinds.com/4)</figure>

<table width="100%"><tr><td>
02:08 - What is React and why use it?<br />
03:08 - The symbiotic relationship of ClojureScript and React<br />
04:54 - The history of React and why it was created<br />
09:43 - Updating web page with React without using data binding<br />
13:11 - Using the virtual DOM to change the browser DOM<br />
13:57 - Programming with React, render targets HTML, canvas, other<br />
16:45 - Working with designers. Contrasted with Ember and AngularJS<br />
21:45 - JSX Compiler bridging HTML and React javascript<br />
23:50 - Autobuilding JSX and in browser tools for React<br />
24:50 - Tips and tricks to working with React, getting started<br />
</td><td>
27:17 - Rendering HTML on the server with Node.js. Rendering backends<br />
29:20 - React evolved through survival of the fittest at Facebook<br />
30:15 - Ideas for having state on server and client, using web sockets.<br />
32:05 - React-multiuser - distributed shared mutable state using Firebase<br />
33:03 - Better debugging with React using the state transitions, replaying events<br />
34:08 - Differences from Web Components<br />
34:25 - Notable companies using React<br />
35:16 - Could a React backend plugin be created to target PDF?<br />
36:30 - Future of React, what's next?<br />
39:38 - Contributing and getting help<br />
</td></tr></table>

[Read the episode notes](http://codewinds.com/4)


### JavaScript Jabber

[Pete Hunt](http://www.petehunt.net/) and [Jordan Walke](https://github.com/jordwalke) talked about React in JavaScript Jabber 73.
<figure>[![](/react/img/docs/javascript-jabber.png)](http://javascriptjabber.com/073-jsj-react-with-pete-hunt-and-jordan-walke/#content)</figure>

<table width="100%"><tr><td>
01:34 – Pete Hunt Introduction<br />
02:45 – Jordan Walke Introduction<br />
04:15 – React<br />
06:38 – 60 Frames Per Second<br />
09:34 – Data Binding<br />
12:31 – Performance<br />
17:39 – Diffing Algorithm<br />
19:36 – DOM Manipulation
</td><td>
23:06 – Supporting node.js<br />
24:03 – rendr<br />
26:02 – JSX<br />
30:31 – requestAnimationFrame<br />
34:15 – React and Applications<br />
38:12 – React Users Khan Academy<br />
39:53 – Making it work
</td></tr></table>

[Read the full transcript](http://javascriptjabber.com/073-jsj-react-with-pete-hunt-and-jordan-walke/)

### Introduction to React.js - Facebook Seattle

<iframe width="650" height="315" src="//www.youtube.com/embed/XxVg_s8xAms" frameborder="0" allowfullscreen></iframe>

By [Tom Occhino](http://tomocchino.com/) and [Jordan Walke](https://github.com/jordwalke)

### Developing User Interfaces With React - Super VanJS

<iframe width="650" height="315" src="//www.youtube.com/embed/1OeXsL5mr4g" frameborder="0" allowfullscreen></iframe>

By [Steven Luscher](https://github.com/steveluscher)

### Introduction to React - LAWebSpeed meetup

<iframe width="650" height="315" src="//www.youtube.com/embed/SMMRJif5QW0" frameborder="0" allowfullscreen></iframe>

by [Stoyan Stefanov](http://www.phpied.com/)

### React, or how to make life simpler - FrontEnd Dev Conf '14

<iframe width="560" height="315" src="//www.youtube.com/embed/YJNUK0EA_Jo" frameborder="0" allowfullscreen></iframe>

**In Russian** by [Alexander Solovyov](http://solovyov.net/)

### "Functional DOM programming" - Meteor DevShop 11

<iframe width="650" height="315" src="//www.youtube.com/embed/qqVbr_LaCIo" frameborder="0" allowfullscreen></iframe>

### "Rethinking Web App Development at Facebook" - Facebook F8 Conference 2014

<iframe width="650" height="315" src="//www.youtube.com/embed/nYkdrAPrdcw" frameborder="0" allowfullscreen></iframe>

### React and Flux: Building Applications with a Unidirectional Data Flow - Forward JS 2014

<iframe width="650" height="315" src="//www.youtube.com/embed/i__969noyAM" frameborder="0" allowfullscreen></iframe>

Facebook engineers [Bill Fisher](http://twitter.com/fisherwebdev) and [Jing Chen](http://twitter.com/jingc) talk about Flux and React, and how using an application architecture with a unidirectional data flow cleans up a lot of their code.
