---
id: clone-with-props
title: Cloning Components
permalink: clone-with-props.html
prev: test-utils.html
next: update.html
---

In rare situations a component may want to change the props of a component that it doesn't own (like changing the `className` of a component passed as `this.props.children`). Other times it may want to make multiple copies of a component passed to it. `cloneWithProps()` makes this possible.

#### `ReactComponent React.addons.cloneWithProps(ReactComponent component, object? extraProps)`

Do a shallow copy of `component` and merge any props provided by `extraProps`. The `className` and `style` props will be merged intelligently.

> Note:
>
> `cloneWithProps` does not transfer `key` to the cloned component. If you wish to preserve the key, add it to the `extraProps` object:
> ```js
> var clonedComponent = cloneWithProps(originalComponent, { key : originalComponent.key });
> ```
> `ref` is similarly not preserved.
