---
id: perf
title: Performance Tools
permalink: perf.html
prev: pure-render-mixin.html
---

React is usually quite fast out of the box. However, in situations where you need to squeeze every ounce of performance out of your app, it provides a [shouldComponentUpdate](/react/docs/component-specs.html#updating-shouldcomponentupdate) hook where you can add optimization hints to React's diff algorithm.

In addition to giving you an overview of your app's overall performance, ReactPerf is a profiling tool that tells you exactly where you need to put these hooks.

> Note:
>
> The dev build of React is slower than the prod build, due to all the extra logic for providing, for example, React's friendly console warnings (stripped away in the prod build). Therefore, the profiler only serves to indicate the _relatively_ expensive parts of your app.

## General API

The `Perf` object documented here is exposed as `React.addons.Perf` when using the `react-with-addons.js` build in development mode.

### `Perf.start()` and `Perf.stop()`
Start/stop the measurement. The React operations in-between are recorded for analyses below. Operations that took an insignificant amount of time are ignored.

### `Perf.printInclusive(measurements)`
Prints the overall time taken. If no argument's passed, defaults to all the measurements from the last recording. This prints a nicely formatted table in the console, like so:

![](/react/img/docs/perf-inclusive.png)

### `Perf.printExclusive(measurements)`
"Exclusive" times don't include the times taken to mount the components: processing props, `getInitialState`, call `componentWillMount` and `componentDidMount`, etc.

![](/react/img/docs/perf-exclusive.png)

### `Perf.printWasted(measurements)`

**The most useful part of the profiler**.

"Wasted" time is spent on components that didn't actually render anything, e.g. the render stayed the same, so the DOM wasn't touched.

![](/react/img/docs/perf-wasted.png)

### `Perf.printDOM(measurements)`
Prints the underlying DOM manipulations, e.g. "set innerHTML" and "remove".

![](/react/img/docs/perf-dom.png)

## Advanced API

The above print methods use `Perf.getLastMeasurements()` to pretty-print the result.

### `Perf.getLastMeasurements()`
Get the measurements array from the last start-stop session. The array contains objects, each of which looks like this:

```js
{
  // The term "inclusive" and "exclusive" are explained below
  "exclusive": {},
  // '.0.0' is the React ID of the node
  "inclusive": {".0.0": 0.0670000008540228, ".0": 0.3259999939473346},
  "render": {".0": 0.036999990697950125, ".0.0": 0.010000003385357559},
  // Number of instances
  "counts": {".0": 1, ".0.0": 1},
  // DOM touches
  "writes": {},
  // Extra debugging info
  "displayNames": {
    ".0": {"current": "App", "owner": "<root>"},
    ".0.0": {"current": "Box", "owner": "App"}
  },
  "totalTime": 0.48499999684281647
}
```
