---
id: clone-with-props
title: Cloning Components
permalink: clone-with-props.html
prev: test-utils.html
next: update.html
---

In rare situations a component may want to change the props of a component that it doesn't own (like changing the `className` of a component passed as `this.props.children`). Other times it may want to make multiple copies of a component passed to it. `cloneWithProps()` makes this possible.

#### `ReactComponent React.addons.cloneWithProps(ReactComponent component, object? extraProps)`

Do a shallow copy of `component` and merge any props provided by `extraProps`. Props are merged in the same manner as [`transferPropsTo()`](/react/docs/component-api.html#transferpropsto), so props like `className` will be merged intelligently.

> Note:
>
> `cloneWithProps` does not transfer the `key` prop to the cloned component. If you wish to preserve the key, add it to the `extraProps` object:
> ```js
> var clonedComponent = cloneWithProps(originalComponent, { key : originalComponent.props.key });
> ```
> `ref` is another prop that is not preserved either.
