---
id: getting-started
title: Getting Started
next: tutorial.html
redirect_from: "docs/index.html"
---

## JSFiddle

The easiest way to start hacking on React is using the following JSFiddle Hello World examples:

 * **[React JSFiddle](http://jsfiddle.net/vjeux/kb3gN/)**
 * [React JSFiddle without JSX](http://jsfiddle.net/vjeux/VkebS/)

## Starter Kit

Download the starter kit to get started.

<div class="buttons-unit downloads">
  <a href="/react/downloads/react-{{site.react_version}}.zip" class="button">
    Download Starter Kit {{site.react_version}}
  </a>
</div>

In the root directory of the starter kit, create a `helloworld.html` with the following contents.

```html
<!DOCTYPE html>
<html>
  <head>
    <script src="build/react.js"></script>
    <script src="build/JSXTransformer.js"></script>
  </head>
  <body>
    <div id="example"></div>
    <script type="text/jsx">
      /** @jsx React.DOM */
      React.renderComponent(
        <h1>Hello, world!</h1>,
        document.getElementById('example')
      );
    </script>
  </body>
</html>
```

The XML syntax inside of JavaScript is called JSX; check out the [JSX syntax](/react/docs/jsx-in-depth.html) to learn more about it. In order to translate it to vanilla JavaScript we use `<script type="text/jsx">` and include `JSXTransformer.js` to actually perform the transformation in the browser.

### Separate File

Your React JSX code can live in a separate file. Create the following `src/helloworld.js`.

```javascript
/** @jsx React.DOM */
React.renderComponent(
  <h1>Hello, world!</h1>,
  document.getElementById('example')
);
```

> Note:
>
> ```/** @jsx React.DOM */``` is *required*. The comment parser is very strict right now; in order for it to pick up the `@jsx` modifier, two conditions are required. The `@jsx` comment block must be the first comment on the file. The comment must start with `/**` (`/*` and `//` will not work). If the parser can't find the `@jsx` comment, it will output the file without transforming it.


Then reference it from `helloworld.html`:

```html{10}
<script type="text/jsx" src="src/helloworld.js"></script>
```

### Offline Transform

First install the command-line tools (requires [npm](http://npmjs.org/)):

```
npm install -g react-tools
```

Then, translate your `src/helloworld.js` file to plain JavaScript:

```
jsx --watch src/ build/

```

The file `build/helloworld.js` is autogenerated whenever you make a change.

```javascript{3}
/** @jsx React.DOM */
React.renderComponent(
  React.DOM.h1(null, 'Hello, world!'),
  document.getElementById('example')
);
```


Update your HTML file as below:

```html{6,10}
<!DOCTYPE html>
<html>
  <head>
    <title>Hello React!</title>
    <script src="build/react.js"></script>
    <!-- No need for JSXTransformer! -->
  </head>
  <body>
    <div id="example"></div>
    <script src="build/helloworld.js"></script>
  </body>
</html>
```

## Want CommonJS?

If you want to use React with [browserify](http://browserify.org/), [webpack](http://webpack.github.io/), or another CommonJS-compatible module system, just use the [`react` npm package](https://www.npmjs.org/package/react). In addition, the `jsx` build tool can be integrated into most packaging systems (not just CommonJS) quite easily.

## Next Steps

Check out [the tutorial](/react/docs/tutorial.html) and the other examples in the starter kit's `examples` directory to learn more. Good luck, and welcome!
