---
title: The Road to 1.0
author: Paul O'Shannessy
---

When we launched React last spring, we purposefully decided not to call it 1.0. It was production ready, but we had plans to evolve APIs and behavior as we saw how people were using React, both internally and externally. We've learned a lot over the past 9 months and we've thought a lot about what 1.0 will mean for React. A couple weeks ago, I outlined [several projects][projects] that we have planned to take us to 1.0 and beyond. Today I'm writing a bit more about them to give our users a better insight into our plans.

Our primary goal with 1.0 is to clarify our messaging and converge on an API that is aligned with our goals. In order to do that, we want to clean up bad patterns we've seen in use and really help enable developers write good code.

## Descriptors

The first part of this is what we're calling "descriptors". I talked about this briefly in our [v0.10 announcements][v0.10]. The goal here is to separate our virtual DOM representation from our use of it. Simply, this means the return value of a component (e.g. `React.DOM.div()`, `MyComponent()`) will be a simple object containing the information React needs to render. Currently the object returned is actually linked to React's internal representation of the component and even directly to the DOM element. This has enabled some bad patterns that are quite contrary to how we want people to use React. That's our failure.

We added some warnings in v0.9 to start migrating some of these bad patterns. With v0.10 we'll catch more. You'll see more on this soon as we expect to ship v0.11 with descriptors.

## API Cleanup

This is really connected to everything. We want to keep the API as simple as possible and help developers [fall into the pit of success][pitofsuccess]. Enabling bad patterns with bad APIs is not success.

## ES6

Before we even launched React publicly, members of the team were talking about how we could leverage ES6, namely classes, to improve the experience of creating React components. Calling `React.createClass(...)` isn't great. We don't quite have the right answer here yet, but we're close. We want to make sure we make this as simple as possible. It could look like this:

```js
class MyComponent extends React.Component {
  render() {
    ...
  }
}
```

There are other features of ES6 we're already using in core. I'm sure we'll see more of that. The `jsx` executable we ship with `react-tools` already supports transforming many parts of ES6 into code that will run on older browsers.

## Context

While we haven't documented `context`, it exists in some form in React already. It exists as a way to pass values through a tree without having to use props at every single point. We've seen this need crop up time and time again, so we want to make this as easy as possible. It's use has performance tradeoffs, and there are known weaknesses in our implementation, so we want to make sure this is a solid feature.

## Addons

As you may know, we ship a separate build of React with some extra features we called "addons". While this has served us fine, it's not great for our users. It's made testing harder, but also results in more cache misses for people using a CDN. The problem we face is that many of these "addons" need access to parts of React that we don't expose publicly. Our goal is to ship each addon on its own and let each hook into React as needed. This would also allow others to write and distribute "addons".

## Browser Support

As much as we'd all like to stop supporting older browsers, it's not always possible. Facebook still supports IE8. While React won't support IE8 forever, our goal is to have 1.0 support IE8. Hopefully we can continue to abstract some of these rough parts.

## Animations

Finding a way to define animations in a declarative way is a hard problem. We've been exploring the space for a long time. We've introduced some half-measures to alleviate some use cases, but the larger problem remains. While we'd like to make this a part of 1.0, realistically we don't think we'll have a good solution in place.

## Miscellaneous

There are several other things I listed on [our projects page][projects] that we're tracking. Some of them are internals and have no obvious outward effect (improve tests, repo separation, updated test runner). I encourage you to take a look.

[v0.10]: http://facebook.github.io/react/blog/2014/03/21/react-v0.10.html
[pitofsuccess]: http://blog.codinghorror.com/falling-into-the-pit-of-success/
[projects]: https://github.com/facebook/react/wiki/Projects
