---
id: test-utils
title: Test Utilities
layout: docs
permalink: test-utils.html
prev: class-name-manipulation.html
next: clone-with-props.html
---

`React.addons.TestUtils` makes it easy to test React components in the testing framework of your choice (we use [Jest](http://facebook.github.io/jest/)).

### Simulate

```javascript
Simulate.{eventName}(DOMElement element, object eventData)
```

Simulate an event dispatch on a DOM node with optional `eventData` event data. **This is possibly the single most useful utility in `ReactTestUtils`.**

Example usage:

```javascript
var node = this.refs.input.getDOMNode();
React.addons.TestUtils.Simulate.click(node);
React.addons.TestUtils.Simulate.change(node);
React.addons.TestUtils.Simulate.keyDown(node, {key: "Enter"});
```

`Simulate` has a method for every event that React understands.

### renderIntoDocument

```javascript
ReactComponent renderIntoDocument(ReactComponent instance)
```

Render a component into a detached DOM node in the document. **This function requires a DOM.**

### mockComponent

```javascript
object mockComponent(function componentClass, string? tagName)
```

Pass a mocked component module to this method to augment it with useful methods that allow it to be used as a dummy React component. Instead of rendering as usual, the component will become a simple `<div>` (or other tag if `mockTagName` is provided) containing any provided children.

### isComponentOfType

```javascript
boolean isComponentOfType(ReactComponent instance, function componentClass)
```

Returns true if `instance` is an instance of a React `componentClass`.

### isDOMComponent

```javascript
boolean isDOMComponent(ReactComponent instance)
```

Returns true if `instance` is a DOM component (such as a `<div>` or `<span>`).

### isCompositeComponent

```javascript
boolean isCompositeComponent(ReactComponent instance)`
```

Returns true if `instance` is a composite component (created with `React.createClass()`)

### isCompositeComponentWithType

```javascript
boolean isCompositeComponentWithType(ReactComponent instance, function componentClass)
```

The combination of `isComponentOfType()` and `isCompositeComponent()`.

### isTextComponent

```javascript
boolean isTextComponent(ReactComponent instance)
```

Returns true if `instance` is a plain text component.

### findAllInRenderedTree

```javascript
array findAllInRenderedTree(ReactComponent tree, function test)
```

Traverse all components in `tree` and accumulate all components where `test(component)` is true. This is not that useful on its own, but it's used as a primitive for other test utils.

### scryRenderedDOMComponentsWithClass

```javascript
array scryRenderedDOMComponentsWithClass(ReactComponent tree, string className)
```

Finds all instance of components in the rendered tree that are DOM components with the class name matching `className`.

### findRenderedDOMComponentWithClass

```javascript
ReactComponent findRenderedDOMComponentWithClass(ReactComponent tree, string className)
```

Like `scryRenderedDOMComponentsWithClass()` but expects there to be one result, and returns that one result, or throws exception if there is any other number of matches besides one.

### scryRenderedDOMComponentsWithTag

```javascript
array scryRenderedDOMComponentsWithTag(ReactComponent tree, string tagName)
```

Finds all instance of components in the rendered tree that are DOM components with the tag name matching `tagName`.

### findRenderedDOMComponentWithTag

```javascript
ReactComponent findRenderedDOMComponentWithTag(ReactComponent tree, string tagName)
```

Like `scryRenderedDOMComponentsWithTag()` but expects there to be one result, and returns that one result, or throws exception if there is any other number of matches besides one.

### scryRenderedComponentsWithType

```javascript
array scryRenderedComponentsWithType(ReactComponent tree, function componentClass)
```

Finds all instances of components with type equal to `componentClass`.

### findRenderedComponentWithType

```javascript
ReactComponent findRenderedComponentWithType(ReactComponent tree, function componentClass)
```

Same as `scryRenderedComponentsWithType()` but expects there to be one result and returns that one result, or throws exception if there is any other number of matches besides one.
