---
id: class-name-manipulation
title: Class Name Manipulation
layout: docs
permalink: class-name-manipulation.html
prev: two-way-binding-helpers.html
next: test-utils.html
---

`classSet()` is a neat utility for easily manipulating the DOM `class` string.

Here's a common scenario and its solution without `classSet()`:

```javascript
// inside some `<Message />` React component
render: function() {
  var classString = 'message';
  if (this.props.isImportant) {
    classString += ' message-important';
  }
  if (this.props.isRead) {
    classString += ' message-read';
  }
  // 'message message-important message-read'
  return <div className={classString}>Great, I'll be there.</div>;
}
```

This can quickly get tedious, as assigning class name strings can be hard to read and error-prone. `classSet()` solves this problem:

```javascript
render: function() {
  var cx = React.addons.classSet;
  var classes = cx({
    'message': true,
    'message-important': this.props.isImportant,
    'message-read': this.props.isRead
  });
  // same final string, but much cleaner
  return <div className={classes}>Great, I'll be there.</div>;
}
```

When using `classSet()`, pass an object with keys of the CSS class names you might or might not need. Truthy values will result in the key being a part of the resulting string.

No more hacky string concatenations!
