---
id: why-react-zh-CN
title: 为什么使用 React?
layout: docs
permalink: why-react-zh-CN.html
next: displaying-data.html
---

React 是一个 Facebook 和 Instagram 用来创建用户界面的 JavaScript 库。很人多认为 React 是 **[MVC](http://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller)** 中的 **V**（视图）。

我们创造 React 是为了解决一个问题：**构建随着时间数据不断变化的大规模应用程序**。为了达到这个目标，React 采用下面两个主要的思想。

### 简单

仅仅只要表达出你的应用程序在任一个时间点应该长的样子，然后当底层的数据变了，React 会自动处理所有用户界面的更新。

### 表达能力 (Declarative)

当数据变化了，React 概念上是类似点击了更新的按钮，但仅会更新变化的部分。

## 构建可组合的组件

React 都是关于构建可复用的组件。事实上，通过 React 你*唯一*要做的事情就是构建组件。得益于其良好的封装性，组件使代码复用、测试和关注分离（separation of concerns）更加简单。

## 给它5分钟的时间

React挑战了很多传统的知识，第一眼看上去可能很多想法有点疯狂。当你阅读这篇指南，请[给它5分钟的时间](http://37signals.com/svn/posts/3124-give-it-five-minutes)；那些疯狂的想法已经帮助 Facebook 和 Instagram 从里到外创建了上千的组件了。

## 了解更多

你可以从这篇[博客](http://facebook.github.io/react/blog/2013/06/05/why-react.html)了解更多我们创造 React 的动机。


