---
id: why-react
title: Why React?
layout: docs
permalink: why-react.html
next: displaying-data.html
---
React is a JavaScript library for creating user interfaces by Facebook and Instagram. Many people choose to think of React as the **V** in **[MVC](http://en.wikipedia.org/wiki/Model%E2%80%93view%E2%80%93controller)**.

We built React to solve one problem: **building large applications with data that changes over time**. To do this, React uses two main ideas.

### Simple

Simply express how your app should look at any given point in time, and React will automatically manage all UI updates when your underlying data changes.

### Declarative

When the data changes, React conceptually hits the "refresh" button, and knows to only update the changed parts.

## Build Composable Components

React is all about building reusable components. In fact, with React the *only* thing you do is build components. Since they're so encapsulated, components make code reuse, testing, and separation of concerns easy.

## Give It Five Minutes

React challenges a lot of conventional wisdom, and at first glance some of the ideas may seem crazy. [Give it five minutes](http://37signals.com/svn/posts/3124-give-it-five-minutes) while reading this guide; those crazy ideas have worked for building thousands of components both inside and outside of Facebook and Instagram.

## Learn More

You can learn more about our motivations behind building React in [this blog post](http://facebook.github.io/react/blog/2013/06/05/why-react.html).
