---
title: "React v0.5.2, v0.4.2"
layout: post
author: Paul O'Shannessy
---

Today we're releasing an update to address a potential XSS vulnerability that can	 arise when using user data as a `key`. Typically "safe" data is used for a `key`, for example, an id from your database, or a unique hash. However there are cases where it may be reasonable to use user generated content. A carefully crafted piece of content could result in arbitrary JS execution. While we make a very concerted effort to ensure all text is escaped before inserting it into the DOM, we missed one case. Immediately following the discovery of this vulnerability, we performed an audit to ensure we this was the only such vulnerability.

This only affects v0.5.x and v0.4.x. Versions in the 0.3.x family are unaffected.

Updated versions are available for immediate download via npm, bower, and on our [download page][download].

We take security very seriously at Facebook. For most of our products, users don't need to know that a security issue has been fixed. But with libraries like React, we need to make sure developers using React have access to fixes to keep their users safe.

While we've encouraged responsible disclosure as part of [Facebook's whitehat bounty program][bounty] since we launched, we don't have a good process for notifying our users. Hopefully we don't need to use it, but moving forward we'll set up a little bit more process to ensure the safety of our users. Ember.js has [an excellent policy][ember] which we may use as our model.

You can learn more about the vulnerability discussed here: [CVE-2013-7035][cve].

[download]: http://facebook.github.io/react/downloads.html
[bounty]: https://www.facebook.com/whitehat/
[ember]: http://emberjs.com/security/
[cve]: https://groups.google.com/forum/#!topic/reactjs/OIqxlB2aGfU

