# -*- coding: utf-8 -*-

from setuptools import setup, find_packages

with open("README.rst", "rb") as readme_file:
    doclines = readme_file.read().split("\n")

with open("requirements.txt", "rb") as requires_file:
    requires = requires_file.read().split()

with open("VERSION", "rb") as version_file:
    version = version_file.read().strip()

setup(
    name='sphinxcontrib-bibtex',
    version=version,
    url='http://bitbucket.org/birkenfeld/sphinx-contrib',
    download_url='http://pypi.python.org/pypi/sphinxcontrib-bibtex',
    license='BSD',
    author='Matthias C. M. Troffaes',
    author_email='matthias.troffaes@gmail.com',
    description=doclines[0],
    long_description="\n".join(doclines[2:]),
    zip_safe=False,
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Console',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Documentation',
        'Topic :: Utilities',
    ],
    platforms='any',
    packages=find_packages(),
    include_package_data=True,
    install_requires=requires,
    namespace_packages=['sphinxcontrib'],
)
