// Copyright 2017 The TensorFlow Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// DO NOT EDIT
// This file was machine generated by github.com/tensorflow/tensorflow/tensorflow/go/genop/internal
//
// WARNING: This generation of wrapper function for TensorFlow ops is in an
// experimental state. The generated API can change without notice.

package op

import tf "github.com/tensorflow/tensorflow/tensorflow/go"

// optionalAttr is an intentionally un-exported type to hide
// details of how optional attributes to operations are implemented.
type optionalAttr map[string]interface{}

func makeOutputList(op *tf.Operation, start int, output string) ([]tf.Output, int, error) {
	size, err := op.OutputListSize(output)
	if err != nil {
		return nil, start, err
	}
	list := make([]tf.Output, size)
	for i := 0; i < size; i++ {
		list[i] = op.Output(start + i)
	}
	return list, start + size, nil
}

// FakeQuantWithMinMaxVarsPerChannelGradientAttr is an optional argument to FakeQuantWithMinMaxVarsPerChannelGradient.
type FakeQuantWithMinMaxVarsPerChannelGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsPerChannelGradientNumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization; between 2 and 16, inclusive.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsPerChannelGradientNumBits(value int64) FakeQuantWithMinMaxVarsPerChannelGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsPerChannelGradientNarrowRange sets the optional narrow_range attribute to value.
//
// value: Whether to quantize into 2^num_bits - 1 distinct values.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsPerChannelGradientNarrowRange(value bool) FakeQuantWithMinMaxVarsPerChannelGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxVarsPerChannel operation.
//
// Arguments:
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxVars operation,
// shape one of: `[d]`, `[b, d]`,  `[b, h, w, d]`.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxVars operation, shape
//   same as `gradients`.
// min, max: Quantization interval, floats of shape `[d]`.
//
//
//
// Returns Backpropagated gradients w.r.t. inputs, shape same as
// `inputs`:
//   `gradients * (inputs >= min && inputs <= max)`.Backpropagated gradients w.r.t. min parameter, shape `[d]`:
// `sum_per_d(gradients * (inputs < min))`.Backpropagated gradients w.r.t. max parameter, shape `[d]`:
// `sum_per_d(gradients * (inputs > max))`.
func FakeQuantWithMinMaxVarsPerChannelGradient(scope *Scope, gradients tf.Output, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsPerChannelGradientAttr) (backprops_wrt_input tf.Output, backprop_wrt_min tf.Output, backprop_wrt_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsPerChannelGradient",
		Input: []tf.Input{
			gradients, inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// FakeQuantWithMinMaxVarsPerChannelAttr is an optional argument to FakeQuantWithMinMaxVarsPerChannel.
type FakeQuantWithMinMaxVarsPerChannelAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsPerChannelNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsPerChannelNumBits(value int64) FakeQuantWithMinMaxVarsPerChannelAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsPerChannelNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsPerChannelNarrowRange(value bool) FakeQuantWithMinMaxVarsPerChannelAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor of type float and one of the shapes: `[d]`,
//
// `[b, d]` `[b, h, w, d]` via per-channel floats `min` and `max` of shape `[d]`
// to 'outputs' tensor of same shape as `inputs`.
//
// `[min; max]` define the clamping range for the `inputs` data.
// `inputs` values are quantized into the quantization range (`[0; 2^num_bits - 1]`
// when `narrow_range` is false and `[1; 2^num_bits - 1]` when it is true) and
// then de-quantized and output as floats in `[min; max]` interval.
// `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
// If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// This operation has a gradient and thus allows for training `min` and `max`
// values.
func FakeQuantWithMinMaxVarsPerChannel(scope *Scope, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsPerChannelAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsPerChannel",
		Input: []tf.Input{
			inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Subtracts sparse `updates` from an existing tensor according to `indices`.
//
// This operation creates a new tensor by subtracting sparse `updates` from the
// passed in `tensor`.
// This operation is very similar to `tf.scatter_nd_sub`, except that the updates
// are subtracted from an existing tensor (as opposed to a variable). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `shape`.  The last dimension of `indices` can be at most the rank of `shape`:
//
//     indices.shape[-1] <= shape.rank
//
// The last dimension of `indices` corresponds to indices into elements
// (if `indices.shape[-1] = shape.rank`) or slices
// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
// `shape`.  `updates` is a tensor with shape
//
//     indices.shape[:-1] + shape[indices.shape[-1]:]
//
// The simplest form of tensor_scatter_sub is to subtract individual elements
// from a tensor by index. For example, say we want to insert 4 scattered elements
// in a rank-1 tensor with 8 elements.
//
// In Python, this scatter subtract operation would look like this:
//
// ```python
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     tensor = tf.ones([8], dtype=tf.int32)
//     updated = tf.tensor_scatter_sub(tensor, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(scatter))
// ```
//
// The resulting tensor would look like this:
//
//     [1, -10, 1, -9, -8, 1, 1, -11]
//
// We can also, insert entire slices of a higher rank tensor all at once. For
// example, if we wanted to insert two slices in the first dimension of a
// rank-3 tensor with two matrices of new values.
//
// In Python, this scatter add operation would look like this:
//
// ```python
//     indices = tf.constant([[0], [2]])
//     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]],
//                            [[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]]])
//     tensor = tf.ones([4, 4, 4])
//     updated = tf.tensor_scatter_sub(tensor, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(scatter))
// ```
//
// The resulting tensor would look like this:
//
//     [[[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
//      [[-4, -4, -4, -4], [-5, -5, -5, -5], [-6, -6, -6, -6], [-7, -7, -7, -7]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, the index is ignored.
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor copied from tensor and updates subtracted according to the indices.
func TensorScatterSub(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterSub",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LowerBoundAttr is an optional argument to LowerBound.
type LowerBoundAttr func(optionalAttr)

// LowerBoundOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func LowerBoundOutType(value tf.DataType) LowerBoundAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Applies lower_bound(sorted_search_values, values) along each row.
//
// Each set of rows with the same index in (sorted_inputs, values) is treated
// independently.  The resulting row is the equivalent of calling
// `np.searchsorted(sorted_inputs, values, side='left')`.
//
// The result is not a global index to the entire
// `Tensor`, but rather just the index in the last dimension.
//
// A 2-D example:
//   sorted_sequence = [[0, 3, 9, 9, 10],
//                      [1, 2, 3, 4, 5]]
//   values = [[2, 4, 9],
//             [0, 2, 6]]
//
//   result = LowerBound(sorted_sequence, values)
//
//   result == [[1, 2, 2],
//              [0, 1, 5]]
//
// Arguments:
//	sorted_inputs: 2-D Tensor where each row is ordered.
//	values: 2-D Tensor with the same numbers of rows as `sorted_search_values`. Contains
// the values that will be searched for in `sorted_search_values`.
//
// Returns A `Tensor` with the same shape as `values`.  It contains the first scalar index
// into the last dimension where values can be inserted without changing the
// ordered property.
func LowerBound(scope *Scope, sorted_inputs tf.Output, values tf.Output, optional ...LowerBoundAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LowerBound",
		Input: []tf.Input{
			sorted_inputs, values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UpperBoundAttr is an optional argument to UpperBound.
type UpperBoundAttr func(optionalAttr)

// UpperBoundOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func UpperBoundOutType(value tf.DataType) UpperBoundAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Applies upper_bound(sorted_search_values, values) along each row.
//
// Each set of rows with the same index in (sorted_inputs, values) is treated
// independently.  The resulting row is the equivalent of calling
// `np.searchsorted(sorted_inputs, values, side='right')`.
//
// The result is not a global index to the entire
// `Tensor`, but rather just the index in the last dimension.
//
// A 2-D example:
//   sorted_sequence = [[0, 3, 9, 9, 10],
//                      [1, 2, 3, 4, 5]]
//   values = [[2, 4, 9],
//             [0, 2, 6]]
//
//   result = UpperBound(sorted_sequence, values)
//
//   result == [[1, 2, 4],
//              [0, 2, 5]]
//
// Arguments:
//	sorted_inputs: 2-D Tensor where each row is ordered.
//	values: 2-D Tensor with the same numbers of rows as `sorted_search_values`. Contains
// the values that will be searched for in `sorted_search_values`.
//
// Returns A `Tensor` with the same shape as `values`.  It contains the last scalar index
// into the last dimension where values can be inserted without changing the
// ordered property.
func UpperBound(scope *Scope, sorted_inputs tf.Output, values tf.Output, optional ...UpperBoundAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UpperBound",
		Input: []tf.Input{
			sorted_inputs, values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reshapes a quantized tensor as per the Reshape op.
//
// ```
//
// Arguments:
//
//	shape: Defines the shape of the output tensor.
//	input_min: The minimum value of the input.
//	input_max: The maximum value of the input.
//
// Returns This value is copied from input_min.This value is copied from input_max.
func QuantizedReshape(scope *Scope, tensor tf.Output, shape tf.Output, input_min tf.Output, input_max tf.Output) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "QuantizedReshape",
		Input: []tf.Input{
			tensor, shape, input_min, input_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DequantizeAttr is an optional argument to Dequantize.
type DequantizeAttr func(optionalAttr)

// DequantizeMode sets the optional mode attribute to value.
// If not specified, defaults to "MIN_COMBINED"
func DequantizeMode(value string) DequantizeAttr {
	return func(m optionalAttr) {
		m["mode"] = value
	}
}

// Dequantize the 'input' tensor into a float Tensor.
//
// [min_range, max_range] are scalar floats that specify the range for
// the 'input' data. The 'mode' attribute controls exactly which calculations are
// used to convert the float values to their quantized equivalents.
//
// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
//
// ```
// if T == qint8: in[i] += (range(T) + 1)/ 2.0
// out[i] = min_range + (in[i]* (max_range - min_range) / range(T))
// ```
// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
//
// *MIN_COMBINED Mode Example*
//
// If the input comes from a QuantizedRelu6, the output type is
// quint8 (range of 0-255) but the possible range of QuantizedRelu6 is
// 0-6.  The min_range and max_range values are therefore 0.0 and 6.0.
// Dequantize on quint8 will take each value, cast to float, and multiply
// by 6 / 255.
// Note that if quantizedtype is qint8, the operation will additionally add
// each value by 128 prior to casting.
//
// If the mode is 'MIN_FIRST', then this approach is used:
//
// ```c++
// num_discrete_values = 1 << (# of bits in T)
// range_adjust = num_discrete_values / (num_discrete_values - 1)
// range = (range_max - range_min) * range_adjust
// range_scale = range / num_discrete_values
// const double offset_input = static_cast<double>(input) - lowest_quantized;
// result = range_min + ((input - numeric_limits<T>::min()) * range_scale)
// ```
//
// *SCALED mode Example*
//
// `SCALED` mode matches the quantization approach used in
// `QuantizeAndDequantize{V2|V3}`.
//
// If the mode is `SCALED`, we do not use the full range of the output type,
// choosing to elide the lowest possible value for symmetry (e.g., output range is
// -127 to 127, not -128 to 127 for signed 8 bit quantization), so that 0.0 maps to
// 0.
//
// We first find the range of values in our tensor. The
// range we use is always centered on 0, so we find m such that
// ```c++
//   m = max(abs(input_min), abs(input_max))
// ```
//
// Our input tensor range is then `[-m, m]`.
//
// Next, we choose our fixed-point quantization buckets, `[min_fixed, max_fixed]`.
// If T is signed, this is
// ```
//   num_bits = sizeof(T) * 8
//   [min_fixed, max_fixed] =
//       [-(1 << (num_bits - 1) - 1), (1 << (num_bits - 1)) - 1]
// ```
//
// Otherwise, if T is unsigned, the fixed-point range is
// ```
//   [min_fixed, max_fixed] = [0, (1 << num_bits) - 1]
// ```
//
// From this we compute our scaling factor, s:
// ```c++
//   s = (2 * m) / (max_fixed - min_fixed)
// ```
//
// Now we can dequantize the elements of our tensor:
// ```c++
// result = input * s
// ```
//
// Arguments:
//
//	min_range: The minimum scalar value possibly produced for the input.
//	max_range: The maximum scalar value possibly produced for the input.
func Dequantize(scope *Scope, input tf.Output, min_range tf.Output, max_range tf.Output, optional ...DequantizeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Dequantize",
		Input: []tf.Input{
			input, min_range, max_range,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizeV2Attr is an optional argument to QuantizeV2.
type QuantizeV2Attr func(optionalAttr)

// QuantizeV2Mode sets the optional mode attribute to value.
// If not specified, defaults to "MIN_COMBINED"
func QuantizeV2Mode(value string) QuantizeV2Attr {
	return func(m optionalAttr) {
		m["mode"] = value
	}
}

// QuantizeV2RoundMode sets the optional round_mode attribute to value.
// If not specified, defaults to "HALF_AWAY_FROM_ZERO"
func QuantizeV2RoundMode(value string) QuantizeV2Attr {
	return func(m optionalAttr) {
		m["round_mode"] = value
	}
}

// Quantize the 'input' tensor of type float to 'output' tensor of type 'T'.
//
// [min_range, max_range] are scalar floats that specify the range for
// the 'input' data. The 'mode' attribute controls exactly which calculations are
// used to convert the float values to their quantized equivalents.  The
// 'round_mode' attribute controls which rounding tie-breaking algorithm is used
// when rounding float values to their quantized equivalents.
//
// In 'MIN_COMBINED' mode, each value of the tensor will undergo the following:
//
// ```
// out[i] = (in[i] - min_range) * range(T) / (max_range - min_range)
// if T == qint8: out[i] -= (range(T) + 1) / 2.0
// ```
//
// here `range(T) = numeric_limits<T>::max() - numeric_limits<T>::min()`
//
// *MIN_COMBINED Mode Example*
//
// Assume the input is type float and has a possible range of [0.0, 6.0] and the
// output type is quint8 ([0, 255]). The min_range and max_range values should be
// specified as 0.0 and 6.0. Quantizing from float to quint8 will multiply each
// value of the input by 255/6 and cast to quint8.
//
// If the output type was qint8 ([-128, 127]), the operation will additionally
// subtract each value by 128 prior to casting, so that the range of values aligns
// with the range of qint8.
//
// If the mode is 'MIN_FIRST', then this approach is used:
//
// ```
// num_discrete_values = 1 << (# of bits in T)
// range_adjust = num_discrete_values / (num_discrete_values - 1)
// range = (range_max - range_min) * range_adjust
// range_scale = num_discrete_values / range
// quantized = round(input * range_scale) - round(range_min * range_scale) +
//   numeric_limits<T>::min()
// quantized = max(quantized, numeric_limits<T>::min())
// quantized = min(quantized, numeric_limits<T>::max())
// ```
//
// The biggest difference between this and MIN_COMBINED is that the minimum range
// is rounded first, before it's subtracted from the rounded value. With
// MIN_COMBINED, a small bias is introduced where repeated iterations of quantizing
// and dequantizing will introduce a larger and larger error.
//
// *SCALED mode Example*
//
// `SCALED` mode matches the quantization approach used in
// `QuantizeAndDequantize{V2|V3}`.
//
// If the mode is `SCALED`, we do not use the full range of the output type,
// choosing to elide the lowest possible value for symmetry (e.g., output range is
// -127 to 127, not -128 to 127 for signed 8 bit quantization), so that 0.0 maps to
// 0.
//
// We first find the range of values in our tensor. The
// range we use is always centered on 0, so we find m such that
//
// ```c++
//   m = max(abs(input_min), abs(input_max))
// ```
//
// Our input tensor range is then `[-m, m]`.
//
// Next, we choose our fixed-point quantization buckets, `[min_fixed, max_fixed]`.
// If T is signed, this is
//
// ```
//   num_bits = sizeof(T) * 8
//   [min_fixed, max_fixed] =
//       [-(1 << (num_bits - 1) - 1), (1 << (num_bits - 1)) - 1]
// ```
//
// Otherwise, if T is unsigned, the fixed-point range is
//
// ```
//   [min_fixed, max_fixed] = [0, (1 << num_bits) - 1]
// ```
//
// From this we compute our scaling factor, s:
//
// ```c++
//   s = (max_fixed - min_fixed) / (2 * m)
// ```
//
// Now we can quantize the elements of our tensor:
//
// ```c++
// result = round(input * s)
// ```
//
// One thing to watch out for is that the operator may choose to adjust the
// requested minimum and maximum values slightly during the quantization process,
// so you should always use the output ports as the range for further calculations.
// For example, if the requested minimum and maximum values are close to equal,
// they will be separated by a small epsilon value to prevent ill-formed quantized
// buffers from being created. Otherwise, you can end up with buffers where all the
// quantized values map to the same float value, which causes problems for
// operations that have to perform further calculations on them.
//
// Arguments:
//
//	min_range: The minimum scalar value possibly produced for the input.
//	max_range: The maximum scalar value possibly produced for the input.
//
//
// Returns The quantized data produced from the float input.The actual minimum scalar value used for the output.The actual maximum scalar value used for the output.
func QuantizeV2(scope *Scope, input tf.Output, min_range tf.Output, max_range tf.Output, T tf.DataType, optional ...QuantizeV2Attr) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeV2",
		Input: []tf.Input{
			input, min_range, max_range,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizeAndDequantizeV3Attr is an optional argument to QuantizeAndDequantizeV3.
type QuantizeAndDequantizeV3Attr func(optionalAttr)

// QuantizeAndDequantizeV3SignedInput sets the optional signed_input attribute to value.
// If not specified, defaults to true
func QuantizeAndDequantizeV3SignedInput(value bool) QuantizeAndDequantizeV3Attr {
	return func(m optionalAttr) {
		m["signed_input"] = value
	}
}

// QuantizeAndDequantizeV3RangeGiven sets the optional range_given attribute to value.
// If not specified, defaults to true
func QuantizeAndDequantizeV3RangeGiven(value bool) QuantizeAndDequantizeV3Attr {
	return func(m optionalAttr) {
		m["range_given"] = value
	}
}

// Quantizes then dequantizes a tensor.
//
// This is almost identical to QuantizeAndDequantizeV2, except that num_bits is a
// tensor, so its value can change during training.
func QuantizeAndDequantizeV3(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, num_bits tf.Output, optional ...QuantizeAndDequantizeV3Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantizeV3",
		Input: []tf.Input{
			input, input_min, input_max, num_bits,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SpaceToDepthAttr is an optional argument to SpaceToDepth.
type SpaceToDepthAttr func(optionalAttr)

// SpaceToDepthDataFormat sets the optional data_format attribute to value.
// If not specified, defaults to "NHWC"
func SpaceToDepthDataFormat(value string) SpaceToDepthAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// SpaceToDepth for tensors of type T.
//
// Rearranges blocks of spatial data, into depth. More specifically,
// this op outputs a copy of the input tensor where values from the `height`
// and `width` dimensions are moved to the `depth` dimension.
// The attr `block_size` indicates the input block size.
//
//   * Non-overlapping blocks of size `block_size x block size` are rearranged
//     into depth at each location.
//   * The depth of the output tensor is `block_size * block_size * input_depth`.
//   * The Y, X coordinates within each block of the input become the high order
//     component of the output channel index.
//   * The input tensor's height and width must be divisible by block_size.
//
// The `data_format` attr specifies the layout of the input and output tensors
// with the following options:
//   "NHWC": `[ batch, height, width, channels ]`
//   "NCHW": `[ batch, channels, height, width ]`
//   "NCHW_VECT_C":
//       `qint8 [ batch, channels / 4, height, width, 4 ]`
//
// It is useful to consider the operation as transforming a 6-D Tensor.
// e.g. for data_format = NHWC,
//      Each element in the input tensor can be specified via 6 coordinates,
//      ordered by decreasing memory layout significance as:
//      n,oY,bY,oX,bX,iC  (where n=batch index, oX, oY means X or Y coordinates
//                         within the output image, bX, bY means coordinates
//                         within the input block, iC means input channels).
//      The output would be a transpose to the following layout:
//      n,oY,oX,bY,bX,iC
//
// This operation is useful for resizing the activations between convolutions
// (but keeping all data), e.g. instead of pooling. It is also useful for training
// purely convolutional models.
//
// For example, given an input of shape `[1, 2, 2, 1]`, data_format = "NHWC" and
// block_size = 2:
//
// ```
// x = [[[[1], [2]],
//       [[3], [4]]]]
// ```
//
// This operation will output a tensor of shape `[1, 1, 1, 4]`:
//
// ```
// [[[[1, 2, 3, 4]]]]
// ```
//
// Here, the input has a batch of 1 and each batch element has shape `[2, 2, 1]`,
// the corresponding output will have a single element (i.e. width and height are
// both 1) and will have a depth of 4 channels (1 * block_size * block_size).
// The output element shape is `[1, 1, 4]`.
//
// For an input tensor with larger depth, here of shape `[1, 2, 2, 3]`, e.g.
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// This operation, for block_size of 2, will return the following tensor of shape
// `[1, 1, 1, 12]`
//
// ```
// [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
// ```
//
// Similarly, for the following input of shape `[1 4 4 1]`, and a block size of 2:
//
// ```
// x = [[[[1],   [2],  [5],  [6]],
//       [[3],   [4],  [7],  [8]],
//       [[9],  [10], [13],  [14]],
//       [[11], [12], [15],  [16]]]]
// ```
//
// the operator will return the following tensor of shape `[1 2 2 4]`:
//
// ```
// x = [[[[1, 2, 3, 4],
//        [5, 6, 7, 8]],
//       [[9, 10, 11, 12],
//        [13, 14, 15, 16]]]]
// ```
//
// Arguments:
//
//	block_size: The size of the spatial block.
func SpaceToDepth(scope *Scope, input tf.Output, block_size int64, optional ...SpaceToDepthAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SpaceToDepth",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SpaceToBatch for 4-D tensors of type T.
//
// This is a legacy version of the more general SpaceToBatchND.
//
// Zero-pads and then rearranges (permutes) blocks of spatial data into batch.
// More specifically, this op outputs a copy of the input tensor where values from
// the `height` and `width` dimensions are moved to the `batch` dimension. After
// the zero-padding, both `height` and `width` of the input must be divisible by the
// block size.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, depth]`.
//	paddings: 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
//   the padding of the input with zeros across the spatial dimensions as follows:
//
//       paddings = [[pad_top, pad_bottom], [pad_left, pad_right]]
//
//   The effective spatial dimensions of the zero-padded input tensor will be:
//
//       height_pad = pad_top + height + pad_bottom
//       width_pad = pad_left + width + pad_right
//
// The attr `block_size` must be greater than one. It indicates the block size.
//
//   * Non-overlapping blocks of size `block_size x block size` in the height and
//     width dimensions are rearranged into the batch dimension at each location.
//   * The batch of the output tensor is `batch * block_size * block_size`.
//   * Both height_pad and width_pad must be divisible by block_size.
//
// The shape of the output will be:
//
//     [batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
//      depth]
//
// Some examples:
//
// (1) For the following input of shape `[1, 2, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 1]` and value:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// (2) For the following input of shape `[1, 2, 2, 3]` and block_size of 2:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 3]` and value:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[1, 4, 4, 1]` and block_size of 2:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]],
//       [[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[4, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// (4) For the following input of shape `[2, 2, 4, 1]` and block_size of 2:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]]],
//      [[[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[8, 1, 2, 1]` and value:
//
// ```
// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
//      [[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
// ```
//
// Among others, this operation is useful for reducing atrous convolution into
// regular convolution.
//
func SpaceToBatch(scope *Scope, input tf.Output, paddings tf.Output, block_size int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	opspec := tf.OpSpec{
		Type: "SpaceToBatch",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SpaceToBatch for N-D tensors of type T.
//
// This operation divides "spatial" dimensions `[1, ..., M]` of the input into a
// grid of blocks of shape `block_shape`, and interleaves these blocks with the
// "batch" dimension (0) such that in the output, the spatial dimensions
// `[1, ..., M]` correspond to the position within the grid, and the batch
// dimension combines both the position within a spatial block and the original
// batch position.  Prior to division into blocks, the spatial dimensions of the
// input are optionally zero padded according to `paddings`.  See below for a
// precise description.
//
// Arguments:
//	input: N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
// where spatial_shape has `M` dimensions.
//	block_shape: 1-D with shape `[M]`, all values must be >= 1.
//	paddings: 2-D with shape `[M, 2]`, all values must be >= 0.
//   `paddings[i] = [pad_start, pad_end]` specifies the padding for input dimension
//   `i + 1`, which corresponds to spatial dimension `i`.  It is required that
//   `block_shape[i]` divides `input_shape[i + 1] + pad_start + pad_end`.
//
// This operation is equivalent to the following steps:
//
// 1. Zero-pad the start and end of dimensions `[1, ..., M]` of the
//    input according to `paddings` to produce `padded` of shape `padded_shape`.
//
// 2. Reshape `padded` to `reshaped_padded` of shape:
//
//      [batch] +
//      [padded_shape[1] / block_shape[0],
//        block_shape[0],
//       ...,
//       padded_shape[M] / block_shape[M-1],
//       block_shape[M-1]] +
//      remaining_shape
//
// 3. Permute dimensions of `reshaped_padded` to produce
//    `permuted_reshaped_padded` of shape:
//
//      block_shape +
//      [batch] +
//      [padded_shape[1] / block_shape[0],
//       ...,
//       padded_shape[M] / block_shape[M-1]] +
//      remaining_shape
//
// 4. Reshape `permuted_reshaped_padded` to flatten `block_shape` into the batch
//    dimension, producing an output tensor of shape:
//
//      [batch * prod(block_shape)] +
//      [padded_shape[1] / block_shape[0],
//       ...,
//       padded_shape[M] / block_shape[M-1]] +
//      remaining_shape
//
// Some examples:
//
// (1) For the following input of shape `[1, 2, 2, 1]`, `block_shape = [2, 2]`, and
//     `paddings = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 1]` and value:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// (2) For the following input of shape `[1, 2, 2, 3]`, `block_shape = [2, 2]`, and
//     `paddings = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// The output tensor has shape `[4, 1, 1, 3]` and value:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[1, 4, 4, 1]`, `block_shape = [2, 2]`, and
//     `paddings = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]],
//       [[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[4, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// (4) For the following input of shape `[2, 2, 4, 1]`, block_shape = `[2, 2]`, and
//     paddings = `[[0, 0], [2, 0]]`:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]]],
//      [[[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
//
// The output tensor has shape `[8, 1, 3, 1]` and value:
//
// ```
// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
//      [[[0], [2], [4]]], [[[0], [10], [12]]],
//      [[[0], [5], [7]]], [[[0], [13], [15]]],
//      [[[0], [6], [8]]], [[[0], [14], [16]]]]
// ```
//
// Among others, this operation is useful for reducing atrous convolution into
// regular convolution.
func SpaceToBatchND(scope *Scope, input tf.Output, block_shape tf.Output, paddings tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SpaceToBatchND",
		Input: []tf.Input{
			input, block_shape, paddings,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Extract `patches` from `input` and put them in the "depth" output dimension. 3D extension of `extract_image_patches`.
//
// Arguments:
//	input: 5-D Tensor with shape `[batch, in_planes, in_rows, in_cols, depth]`.
//	ksizes: The size of the sliding window for each dimension of `input`.
//	strides: 1-D of length 5. How far the centers of two consecutive patches are in
// `input`. Must be: `[1, stride_planes, stride_rows, stride_cols, 1]`.
//	padding: The type of padding algorithm to use.
//
// We specify the size-related attributes as:
//
// ```python
//       ksizes = [1, ksize_planes, ksize_rows, ksize_cols, 1]
//       strides = [1, stride_planes, strides_rows, strides_cols, 1]
// ```
//
// Returns 5-D Tensor with shape `[batch, out_planes, out_rows, out_cols,
// ksize_planes * ksize_rows * ksize_cols * depth]` containing patches
// with size `ksize_planes x ksize_rows x ksize_cols x depth` vectorized
// in the "depth" dimension. Note `out_planes`, `out_rows` and `out_cols`
// are the dimensions of the output patches.
func ExtractVolumePatches(scope *Scope, input tf.Output, ksizes []int64, strides []int64, padding string) (patches tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksizes": ksizes, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "ExtractVolumePatches",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ListDiffAttr is an optional argument to ListDiff.
type ListDiffAttr func(optionalAttr)

// ListDiffOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func ListDiffOutIdx(value tf.DataType) ListDiffAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Computes the difference between two lists of numbers or strings.
//
// Given a list `x` and a list `y`, this operation returns a list `out` that
// represents all values that are in `x` but not in `y`. The returned list `out`
// is sorted in the same order that the numbers appear in `x` (duplicates are
// preserved). This operation also returns a list `idx` that represents the
// position of each `out` element in `x`. In other words:
//
// `out[i] = x[idx[i]] for i in [0, 1, ..., len(out) - 1]`
//
// For example, given this input:
//
// ```
// x = [1, 2, 3, 4, 5, 6]
// y = [1, 3, 5]
// ```
//
// This operation would return:
//
// ```
// out ==> [2, 4, 6]
// idx ==> [1, 3, 5]
// ```
//
// Arguments:
//	x: 1-D. Values to keep.
//	y: 1-D. Values to remove.
//
// Returns 1-D. Values present in `x` but not in `y`.1-D. Positions of `x` values preserved in `out`.
func ListDiff(scope *Scope, x tf.Output, y tf.Output, optional ...ListDiffAttr) (out tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ListDiff",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// A placeholder op for a value that will be fed into the computation.
//
// DEPRECATED at GraphDef version 23: Placeholder now behaves the same as PlaceholderV2.
//
// N.B. This operation will fail with an error if it is executed. It is
// intended as a way to represent a value that will always be fed, and to
// provide attrs that enable the fed value to be checked at runtime.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor. The shape can be any partially-specified
// shape.  To be unconstrained, pass in a shape with unknown rank.
//
// Returns A placeholder tensor that must be replaced using the feed mechanism.
func PlaceholderV2(scope *Scope, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "PlaceholderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gradient op for `MirrorPad` op. This op folds a mirror-padded tensor.
//
// This operation folds the padded areas of `input` by `MirrorPad` according to the
// `paddings` you specify. `paddings` must be the same as `paddings` argument
// given to the corresponding `MirrorPad` op.
//
// The folded size of each dimension D of the output is:
//
// `input.dim_size(D) - paddings(D, 0) - paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 2, 3], [4, 5, 6], [7, 8, 9]].
// # 'paddings' is [[0, 1]], [0, 1]].
// # 'mode' is SYMMETRIC.
// # rank of 't' is 2.
// pad(t, paddings) ==> [[ 1,  5]
//                       [11, 28]]
// ```
//
// Arguments:
//	input: The input tensor to be folded.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	mode: The mode used in the `MirrorPad` op.
//
// Returns The folded tensor.
func MirrorPadGrad(scope *Scope, input tf.Output, paddings tf.Output, mode string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode}
	opspec := tf.OpSpec{
		Type: "MirrorPadGrad",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor with mirrored values.
//
// This operation pads a `input` with mirrored values according to the `paddings`
// you specify. `paddings` is an integer tensor with shape `[n, 2]`, where n is
// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many values to add before the contents of `input` in that dimension, and
// `paddings[D, 1]` indicates how many values to add after the contents of `input`
// in that dimension. Both `paddings[D, 0]` and `paddings[D, 1]` must be no greater
// than `input.dim_size(D)` (or `input.dim_size(D) - 1`) if `copy_border` is true
// (if false, respectively).
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 2, 3], [4, 5, 6]].
// # 'paddings' is [[1, 1]], [2, 2]].
// # 'mode' is SYMMETRIC.
// # rank of 't' is 2.
// pad(t, paddings) ==> [[2, 1, 1, 2, 3, 3, 2]
//                       [2, 1, 1, 2, 3, 3, 2]
//                       [5, 4, 4, 5, 6, 6, 5]
//                       [5, 4, 4, 5, 6, 6, 5]]
// ```
//
// Arguments:
//	input: The input tensor to be padded.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	mode: Either `REFLECT` or `SYMMETRIC`. In reflect mode the padded regions
// do not include the borders, while in symmetric mode the padded regions
// do include the borders. For example, if `input` is `[1, 2, 3]` and `paddings`
// is `[0, 2]`, then the output is `[1, 2, 3, 2, 1]` in reflect mode, and
// it is `[1, 2, 3, 3, 2]` in symmetric mode.
//
// Returns The padded tensor.
func MirrorPad(scope *Scope, input tf.Output, paddings tf.Output, mode string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode}
	opspec := tf.OpSpec{
		Type: "MirrorPad",
		Input: []tf.Input{
			input, paddings,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor.
//
// This operation pads `input` according to the `paddings` and `constant_values`
// you specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is
// the rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many padding values to add before the contents of `input` in that dimension,
// and `paddings[D, 1]` indicates how many padding values to add after the contents
// of `input` in that dimension. `constant_values` is a scalar tensor of the same
// type as `input` that indicates the value to use for padding `input`.
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 1], [2, 2]]
// # 'paddings' is [[1, 1], [2, 2]]
// # 'constant_values' is 0
// # rank of 't' is 2
// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
//                       [0, 0, 1, 1, 0, 0]
//                       [0, 0, 2, 2, 0, 0]
//                       [0, 0, 0, 0, 0, 0]]
// ```
func PadV2(scope *Scope, input tf.Output, paddings tf.Output, constant_values tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "PadV2",
		Input: []tf.Input{
			input, paddings, constant_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Pads a tensor with zeros.
//
// This operation pads a `input` with zeros according to the `paddings` you
// specify. `paddings` is an integer tensor with shape `[Dn, 2]`, where n is the
// rank of `input`. For each dimension D of `input`, `paddings[D, 0]` indicates
// how many zeros to add before the contents of `input` in that dimension, and
// `paddings[D, 1]` indicates how many zeros to add after the contents of `input`
// in that dimension.
//
// The padded size of each dimension D of the output is:
//
// `paddings(D, 0) + input.dim_size(D) + paddings(D, 1)`
//
// For example:
//
// ```
// # 't' is [[1, 1], [2, 2]]
// # 'paddings' is [[1, 1], [2, 2]]
// # rank of 't' is 2
// pad(t, paddings) ==> [[0, 0, 0, 0, 0, 0]
//                       [0, 0, 1, 1, 0, 0]
//                       [0, 0, 2, 2, 0, 0]
//                       [0, 0, 0, 0, 0, 0]]
// ```
//
func Pad(scope *Scope, input tf.Output, paddings tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Pad",
		Input: []tf.Input{
			input, paddings,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return the reduction indices for computing gradients of s0 op s1 with broadcast.
//
// This is typically used by gradient computations for a broadcasting operation.
func BroadcastGradientArgs(scope *Scope, s0 tf.Output, s1 tf.Output) (r0 tf.Output, r1 tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastGradientArgs",
		Input: []tf.Input{
			s0, s1,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns locations of nonzero / true values in a tensor.
//
// This operation returns the coordinates of true elements in `condition`. The
// coordinates are returned in a 2-D tensor where the first dimension (rows)
// represents the number of true elements, and the second dimension (columns)
// represents the coordinates of the true elements. Keep in mind, the shape of
// the output tensor can vary depending on how many true values there are in
// `condition`. Indices are output in row-major order.
//
// For example:
//
// ```
// # 'input' tensor is [[True, False]
// #                    [True, False]]
// # 'input' has two true values, so output has two coordinates.
// # 'input' has rank of 2, so coordinates have two indices.
// where(input) ==> [[0, 0],
//                   [1, 0]]
//
// # `condition` tensor is [[[True, False]
// #                     [True, False]]
// #                    [[False, True]
// #                     [False, True]]
// #                    [[False, False]
// #                     [False, True]]]
// # 'input' has 5 true values, so output has 5 coordinates.
// # 'input' has rank of 3, so coordinates have three indices.
// where(input) ==> [[0, 0, 0],
//                   [0, 1, 0],
//                   [1, 0, 1],
//                   [1, 1, 1],
//                   [2, 1, 1]]
//
// # `condition` tensor is [[[1.5,  0.0]
// #                     [-0.5, 0.0]]
// #                    [[0.0,  0.25]
// #                     [0.0,  0.75]]
// #                    [[0.0,  0.0]
// #                     [0.0,  0.01]]]
// # 'input' has 5 nonzero values, so output has 5 coordinates.
// # 'input' has rank of 3, so coordinates have three indices.
// where(input) ==> [[0, 0, 0],
//                   [0, 1, 0],
//                   [1, 0, 1],
//                   [1, 1, 1],
//                   [2, 1, 1]]
//
// # `condition` tensor is [[[1.5 + 0.0j, 0.0  + 0.0j]
// #                     [0.0 + 0.5j, 0.0  + 0.0j]]
// #                    [[0.0 + 0.0j, 0.25 + 1.5j]
// #                     [0.0 + 0.0j, 0.75 + 0.0j]]
// #                    [[0.0 + 0.0j, 0.0  + 0.0j]
// #                     [0.0 + 0.0j, 0.01 + 0.0j]]]
// # 'input' has 5 nonzero magnitude values, so output has 5 coordinates.
// # 'input' has rank of 3, so coordinates have three indices.
// where(input) ==> [[0, 0, 0],
//                   [0, 1, 0],
//                   [1, 0, 1],
//                   [1, 1, 1],
//                   [2, 1, 1]]
// ```
func Where(scope *Scope, condition tf.Output) (index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Where",
		Input: []tf.Input{
			condition,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the gradient of `Tile`.
//
// DEPRECATED at GraphDef version 3: TileGrad has been replaced with reduce_sum
//
// Since `Tile` takes an input and repeats the input `multiples` times
// along each dimension, `TileGrad` takes in `multiples` and aggregates
// each repeated tile of `input` into `output`.
func TileGrad(scope *Scope, input tf.Output, multiples tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TileGrad",
		Input: []tf.Input{
			input, multiples,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorStridedSliceUpdateAttr is an optional argument to TensorStridedSliceUpdate.
type TensorStridedSliceUpdateAttr func(optionalAttr)

// TensorStridedSliceUpdateBeginMask sets the optional begin_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateBeginMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// TensorStridedSliceUpdateEndMask sets the optional end_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateEndMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// TensorStridedSliceUpdateEllipsisMask sets the optional ellipsis_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateEllipsisMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// TensorStridedSliceUpdateNewAxisMask sets the optional new_axis_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateNewAxisMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// TensorStridedSliceUpdateShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
// If not specified, defaults to 0
func TensorStridedSliceUpdateShrinkAxisMask(value int64) TensorStridedSliceUpdateAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Assign `value` to the sliced l-value reference of `input`.
//
// The values of `value` are assigned to the positions in the tensor `input` that
// are selected by the slice parameters. The slice parameters `begin` `end`
// `strides` etc. work exactly as in `StridedSlice`.
//
// NOTE this op currently does not support broadcasting and so `value`'s shape
// must be exactly the shape produced by the slice of `input`.
func TensorStridedSliceUpdate(scope *Scope, input tf.Output, begin tf.Output, end tf.Output, strides tf.Output, value tf.Output, optional ...TensorStridedSliceUpdateAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorStridedSliceUpdate",
		Input: []tf.Input{
			input, begin, end, strides, value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceStridedSliceAssignAttr is an optional argument to ResourceStridedSliceAssign.
type ResourceStridedSliceAssignAttr func(optionalAttr)

// ResourceStridedSliceAssignBeginMask sets the optional begin_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignBeginMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// ResourceStridedSliceAssignEndMask sets the optional end_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignEndMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// ResourceStridedSliceAssignEllipsisMask sets the optional ellipsis_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignEllipsisMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// ResourceStridedSliceAssignNewAxisMask sets the optional new_axis_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignNewAxisMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// ResourceStridedSliceAssignShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
// If not specified, defaults to 0
func ResourceStridedSliceAssignShrinkAxisMask(value int64) ResourceStridedSliceAssignAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Assign `value` to the sliced l-value reference of `ref`.
//
// The values of `value` are assigned to the positions in the variable
// `ref` that are selected by the slice parameters. The slice parameters
// `begin, `end`, `strides`, etc. work exactly as in `StridedSlice`.
//
// NOTE this op currently does not support broadcasting and so `value`'s
// shape must be exactly the shape produced by the slice of `ref`.
//
// Returns the created operation.
func ResourceStridedSliceAssign(scope *Scope, ref tf.Output, begin tf.Output, end tf.Output, strides tf.Output, value tf.Output, optional ...ResourceStridedSliceAssignAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceStridedSliceAssign",
		Input: []tf.Input{
			ref, begin, end, strides, value,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// StridedSliceGradAttr is an optional argument to StridedSliceGrad.
type StridedSliceGradAttr func(optionalAttr)

// StridedSliceGradBeginMask sets the optional begin_mask attribute to value.
// If not specified, defaults to 0
func StridedSliceGradBeginMask(value int64) StridedSliceGradAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// StridedSliceGradEndMask sets the optional end_mask attribute to value.
// If not specified, defaults to 0
func StridedSliceGradEndMask(value int64) StridedSliceGradAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// StridedSliceGradEllipsisMask sets the optional ellipsis_mask attribute to value.
// If not specified, defaults to 0
func StridedSliceGradEllipsisMask(value int64) StridedSliceGradAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// StridedSliceGradNewAxisMask sets the optional new_axis_mask attribute to value.
// If not specified, defaults to 0
func StridedSliceGradNewAxisMask(value int64) StridedSliceGradAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// StridedSliceGradShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
// If not specified, defaults to 0
func StridedSliceGradShrinkAxisMask(value int64) StridedSliceGradAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Returns the gradient of `StridedSlice`.
//
// Since `StridedSlice` cuts out pieces of its `input` which is size
// `shape`, its gradient will have the same shape (which is passed here
// as `shape`). The gradient will be zero in any element that the slice
// does not select.
//
// Arguments are the same as StridedSliceGrad with the exception that
// `dy` is the input gradient to be propagated and `shape` is the
// shape of `StridedSlice`'s `input`.
func StridedSliceGrad(scope *Scope, shape tf.Output, begin tf.Output, end tf.Output, strides tf.Output, dy tf.Output, optional ...StridedSliceGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StridedSliceGrad",
		Input: []tf.Input{
			shape, begin, end, strides, dy,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the rank of a tensor.
//
// This operation returns an integer representing the rank of `input`.
//
// For example:
//
// ```
// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
// # shape of tensor 't' is [2, 2, 3]
// rank(t) ==> 3
// ```
//
// **Note**: The rank of a tensor is not the same as the rank of a matrix. The rank
// of a tensor is the number of indices required to uniquely select each element
// of the tensor. Rank is also known as "order", "degree", or "ndims."
func Rank(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Rank",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ReverseSequenceAttr is an optional argument to ReverseSequence.
type ReverseSequenceAttr func(optionalAttr)

// ReverseSequenceBatchDim sets the optional batch_dim attribute to value.
//
// value: The dimension along which reversal is performed.
// If not specified, defaults to 0
func ReverseSequenceBatchDim(value int64) ReverseSequenceAttr {
	return func(m optionalAttr) {
		m["batch_dim"] = value
	}
}

// Reverses variable length slices.
//
// This op first slices `input` along the dimension `batch_dim`, and for each
// slice `i`, reverses the first `seq_lengths[i]` elements along
// the dimension `seq_dim`.
//
// The elements of `seq_lengths` must obey `seq_lengths[i] <= input.dims[seq_dim]`,
// and `seq_lengths` must be a vector of length `input.dims[batch_dim]`.
//
// The output slice `i` along dimension `batch_dim` is then given by input
// slice `i`, with the first `seq_lengths[i]` slices along dimension
// `seq_dim` reversed.
//
// For example:
//
// ```
// # Given this:
// batch_dim = 0
// seq_dim = 1
// input.dims = (4, 8, ...)
// seq_lengths = [7, 2, 3, 5]
//
// # then slices of input are reversed on seq_dim, but only up to seq_lengths:
// output[0, 0:7, :, ...] = input[0, 7:0:-1, :, ...]
// output[1, 0:2, :, ...] = input[1, 2:0:-1, :, ...]
// output[2, 0:3, :, ...] = input[2, 3:0:-1, :, ...]
// output[3, 0:5, :, ...] = input[3, 5:0:-1, :, ...]
//
// # while entries past seq_lens are copied through:
// output[0, 7:, :, ...] = input[0, 7:, :, ...]
// output[1, 2:, :, ...] = input[1, 2:, :, ...]
// output[2, 3:, :, ...] = input[2, 3:, :, ...]
// output[3, 2:, :, ...] = input[3, 2:, :, ...]
// ```
//
// In contrast, if:
//
// ```
// # Given this:
// batch_dim = 2
// seq_dim = 0
// input.dims = (8, ?, 4, ...)
// seq_lengths = [7, 2, 3, 5]
//
// # then slices of input are reversed on seq_dim, but only up to seq_lengths:
// output[0:7, :, 0, :, ...] = input[7:0:-1, :, 0, :, ...]
// output[0:2, :, 1, :, ...] = input[2:0:-1, :, 1, :, ...]
// output[0:3, :, 2, :, ...] = input[3:0:-1, :, 2, :, ...]
// output[0:5, :, 3, :, ...] = input[5:0:-1, :, 3, :, ...]
//
// # while entries past seq_lens are copied through:
// output[7:, :, 0, :, ...] = input[7:, :, 0, :, ...]
// output[2:, :, 1, :, ...] = input[2:, :, 1, :, ...]
// output[3:, :, 2, :, ...] = input[3:, :, 2, :, ...]
// output[2:, :, 3, :, ...] = input[2:, :, 3, :, ...]
// ```
//
// Arguments:
//	input: The input to reverse.
//	seq_lengths: 1-D with length `input.dims(batch_dim)` and
// `max(seq_lengths) <= input.dims(seq_dim)`
//	seq_dim: The dimension which is partially reversed.
//
// Returns The partially reversed input. It has the same shape as `input`.
func ReverseSequence(scope *Scope, input tf.Output, seq_lengths tf.Output, seq_dim int64, optional ...ReverseSequenceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"seq_dim": seq_dim}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ReverseSequence",
		Input: []tf.Input{
			input, seq_lengths,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShapeAttr is an optional argument to Shape.
type ShapeAttr func(optionalAttr)

// ShapeOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_INT32
func ShapeOutType(value tf.DataType) ShapeAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Returns the shape of a tensor.
//
// This operation returns a 1-D integer tensor representing the shape of `input`.
//
// For example:
//
// ```
// # 't' is [[[1, 1, 1], [2, 2, 2]], [[3, 3, 3], [4, 4, 4]]]
// shape(t) ==> [2, 2, 3]
// ```
func Shape(scope *Scope, input tf.Output, optional ...ShapeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Shape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueWithCountsV2Attr is an optional argument to UniqueWithCountsV2.
type UniqueWithCountsV2Attr func(optionalAttr)

// UniqueWithCountsV2OutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueWithCountsV2OutIdx(value tf.DataType) UniqueWithCountsV2Attr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements along an axis of a tensor.
//
// This operation either returns a tensor `y` containing unique elements
// along the `axis` of a tensor. The returned unique elements is sorted
// in the same order as they occur along `axis` in `x`.
// This operation also returns a tensor `idx` and a tensor `count`
// that are the same size as the number of the elements in `x` along the
// `axis` dimension. The `idx` contains the index in the unique output `y`
// and the `count` contains the count in the unique output `y`.
// In other words, for an `1-D` tensor `x` with `axis = None:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx, count = unique_with_counts(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// count ==> [2, 1, 3, 1, 2]
// ```
//
// For an `2-D` tensor `x` with `axis = 0`:
//
// ```
// # tensor 'x' is [[1, 0, 0],
// #                [1, 0, 0],
// #                [2, 0, 0]]
// y, idx, count = unique_with_counts(x, axis=0)
// y ==> [[1, 0, 0],
//        [2, 0, 0]]
// idx ==> [0, 0, 1]
// count ==> [2, 1]
// ```
//
// For an `2-D` tensor `x` with `axis = 1`:
//
// ```
// # tensor 'x' is [[1, 0, 0],
// #                [1, 0, 0],
// #                [2, 0, 0]]
// y, idx, count = unique_with_counts(x, axis=1)
// y ==> [[1, 0],
//        [1, 0],
//        [2, 0]]
// idx ==> [0, 1, 1]
// count ==> [1, 2]
// ```
//
// Arguments:
//	x: A `Tensor`.
//	axis: A `Tensor` of type `int32` (default: None). The axis of the Tensor to
// find the unique elements.
//
// Returns A `Tensor`. Unique elements along the `axis` of `Tensor` x.A 1-D Tensor. Has the same type as x that contains the index of each
// value of x in the output y.A 1-D Tensor. The count of each value of x in the output y.
func UniqueWithCountsV2(scope *Scope, x tf.Output, axis tf.Output, optional ...UniqueWithCountsV2Attr) (y tf.Output, idx tf.Output, count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueWithCountsV2",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// UniqueV2Attr is an optional argument to UniqueV2.
type UniqueV2Attr func(optionalAttr)

// UniqueV2OutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueV2OutIdx(value tf.DataType) UniqueV2Attr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements along an axis of a tensor.
//
// This operation either returns a tensor `y` containing unique elements
// along the `axis` of a tensor. The returned unique elements is sorted
// in the same order as they occur along `axis` in `x`.
// This operation also returns a tensor `idx` that is the same size as
// the number of the elements in `x` along the `axis` dimension. It
// contains the index in the unique output `y`.
// In other words, for an `1-D` tensor `x` with `axis = None:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx = unique(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// ```
//
// For an `2-D` tensor `x` with `axis = 0`:
//
// ```
// # tensor 'x' is [[1, 0, 0],
// #                [1, 0, 0],
// #                [2, 0, 0]]
// y, idx = unique(x, axis=0)
// y ==> [[1, 0, 0],
//        [2, 0, 0]]
// idx ==> [0, 0, 1]
// ```
//
// For an `2-D` tensor `x` with `axis = 1`:
//
// ```
// # tensor 'x' is [[1, 0, 0],
// #                [1, 0, 0],
// #                [2, 0, 0]]
// y, idx = unique(x, axis=1)
// y ==> [[1, 0],
//        [1, 0],
//        [2, 0]]
// idx ==> [0, 1, 1]
// ```
//
// Arguments:
//	x: A `Tensor`.
//	axis: A `Tensor` of type `int32` (default: None). The axis of the Tensor to
// find the unique elements.
//
// Returns A `Tensor`. Unique elements along the `axis` of `Tensor` x.A 1-D Tensor. Has the same type as x that contains the index of each
// value of x in the output y.
func UniqueV2(scope *Scope, x tf.Output, axis tf.Output, optional ...UniqueV2Attr) (y tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueV2",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Shuffle dimensions of x according to a permutation and conjugate the result.
//
// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
//   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
//   `y[i,j,k,...,s,t,u] == conj(x[perm[i], perm[j], perm[k],...,perm[s], perm[t], perm[u]])`
func ConjugateTranspose(scope *Scope, x tf.Output, perm tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConjugateTranspose",
		Input: []tf.Input{
			x, perm,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Stops gradient computation.
//
// When executed in a graph, this op outputs its input tensor as-is.
//
// When building ops to compute gradients, this op prevents the contribution of
// its inputs to be taken into account.  Normally, the gradient generator adds ops
// to a graph to compute the derivatives of a specified 'loss' by recursively
// finding out inputs that contributed to its computation.  If you insert this op
// in the graph it inputs are masked from the gradient generator.  They are not
// taken into account for computing gradients.
//
// This is useful any time you want to compute a value with TensorFlow but need
// to pretend that the value was a constant. Some examples include:
//
// *  The *EM* algorithm where the *M-step* should not involve backpropagation
//    through the output of the *E-step*.
// *  Contrastive divergence training of Boltzmann machines where, when
//    differentiating the energy function, the training must not backpropagate
//    through the graph that generated the samples from the model.
// *  Adversarial training, where no backprop should happen through the adversarial
//    example generation process.
func StopGradient(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StopGradient",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Identity op for gradient debugging.
//
// This op is hidden from public in Python. It is used by TensorFlow Debugger to
// register gradient tensors for gradient debugging.
// This op operates on non-reference-type tensors.
func DebugGradientIdentity(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DebugGradientIdentity",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a copy of the input tensor.
func Snapshot(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Snapshot",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return a tensor with the same shape and contents as the input tensor or value.
func Identity(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Identity",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gather slices from `params` into a Tensor with shape specified by `indices`.
//
// `indices` is an K-dimensional integer tensor, best thought of as a
// (K-1)-dimensional tensor of indices into `params`, where each element defines a
// slice of `params`:
//
//     output[\\(i_0, ..., i_{K-2}\\)] = params[indices[\\(i_0, ..., i_{K-2}\\)]]
//
// Whereas in `tf.gather` `indices` defines slices into the first
// dimension of `params`, in `tf.gather_nd`, `indices` defines slices into the
// first `N` dimensions of `params`, where `N = indices.shape[-1]`.
//
// The last dimension of `indices` can be at most the rank of
// `params`:
//
//     indices.shape[-1] <= params.rank
//
// The last dimension of `indices` corresponds to elements
// (if `indices.shape[-1] == params.rank`) or slices
// (if `indices.shape[-1] < params.rank`) along dimension `indices.shape[-1]`
// of `params`.  The output tensor has shape
//
//     indices.shape[:-1] + params.shape[indices.shape[-1]:]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, a 0 is stored in the
// corresponding output value.
//
// Some examples below.
//
// Simple indexing into a matrix:
//
// ```python
//     indices = [[0, 0], [1, 1]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = ['a', 'd']
// ```
//
// Slice indexing into a matrix:
//
// ```python
//     indices = [[1], [0]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = [['c', 'd'], ['a', 'b']]
// ```
//
// Indexing into a 3-tensor:
//
// ```python
//     indices = [[1]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [[['a1', 'b1'], ['c1', 'd1']]]
//
//
//     indices = [[0, 1], [1, 0]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [['c0', 'd0'], ['a1', 'b1']]
//
//
//     indices = [[0, 0, 1], [1, 0, 1]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = ['b0', 'b1']
// ```
//
// Batched indexing into a matrix:
//
// ```python
//     indices = [[[0, 0]], [[0, 1]]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = [['a'], ['b']]
// ```
//
// Batched slice indexing into a matrix:
//
// ```python
//     indices = [[[1]], [[0]]]
//     params = [['a', 'b'], ['c', 'd']]
//     output = [[['c', 'd']], [['a', 'b']]]
// ```
//
// Batched indexing into a 3-tensor:
//
// ```python
//     indices = [[[1]], [[0]]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [[[['a1', 'b1'], ['c1', 'd1']]],
//               [[['a0', 'b0'], ['c0', 'd0']]]]
//
//     indices = [[[0, 1], [1, 0]], [[0, 0], [1, 1]]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [[['c0', 'd0'], ['a1', 'b1']],
//               [['a0', 'b0'], ['c1', 'd1']]]
//
//
//     indices = [[[0, 0, 1], [1, 0, 1]], [[0, 1, 1], [1, 1, 0]]]
//     params = [[['a0', 'b0'], ['c0', 'd0']],
//               [['a1', 'b1'], ['c1', 'd1']]]
//     output = [['b0', 'b1'], ['d0', 'c1']]
// ```
//
// See also `tf.gather` and `tf.batch_gather`.
//
// Arguments:
//	params: The tensor from which to gather values.
//	indices: Index tensor.
//
// Returns Values from `params` gathered from indices given by `indices`, with
// shape `indices.shape[:-1] + params.shape[indices.shape[-1]:]`.
func GatherNd(scope *Scope, params tf.Output, indices tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GatherNd",
		Input: []tf.Input{
			params, indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reverses specific dimensions of a tensor.
//
// Given a `tensor`, and a `bool` tensor `dims` representing the dimensions
// of `tensor`, this operation reverses each dimension i of `tensor` where
// `dims[i]` is `True`.
//
// `tensor` can have up to 8 dimensions. The number of dimensions
// of `tensor` must equal the number of elements in `dims`. In other words:
//
// `rank(tensor) = size(dims)`
//
// For example:
//
// ```
// # tensor 't' is [[[[ 0,  1,  2,  3],
// #                  [ 4,  5,  6,  7],
// #                  [ 8,  9, 10, 11]],
// #                 [[12, 13, 14, 15],
// #                  [16, 17, 18, 19],
// #                  [20, 21, 22, 23]]]]
// # tensor 't' shape is [1, 2, 3, 4]
//
// # 'dims' is [False, False, False, True]
// reverse(t, dims) ==> [[[[ 3,  2,  1,  0],
//                         [ 7,  6,  5,  4],
//                         [ 11, 10, 9, 8]],
//                        [[15, 14, 13, 12],
//                         [19, 18, 17, 16],
//                         [23, 22, 21, 20]]]]
//
// # 'dims' is [False, True, False, False]
// reverse(t, dims) ==> [[[[12, 13, 14, 15],
//                         [16, 17, 18, 19],
//                         [20, 21, 22, 23]
//                        [[ 0,  1,  2,  3],
//                         [ 4,  5,  6,  7],
//                         [ 8,  9, 10, 11]]]]
//
// # 'dims' is [False, False, True, False]
// reverse(t, dims) ==> [[[[8, 9, 10, 11],
//                         [4, 5, 6, 7],
//                         [0, 1, 2, 3]]
//                        [[20, 21, 22, 23],
//                         [16, 17, 18, 19],
//                         [12, 13, 14, 15]]]]
// ```
//
// Arguments:
//	tensor: Up to 8-D.
//	dims: 1-D. The dimensions to reverse.
//
// Returns The same shape as `tensor`.
func Reverse(scope *Scope, tensor tf.Output, dims tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Reverse",
		Input: []tf.Input{
			tensor, dims,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the batched diagonal part of a batched tensor.
//
// This operation returns a tensor with the `diagonal` part
// of the batched `input`. The `diagonal` part is computed as follows:
//
// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
// tensor of rank `k - 1` with dimensions `[I, J, K, ..., min(M, N)]` where:
//
// `diagonal[i, j, k, ..., n] = input[i, j, k, ..., n, n]`.
//
// The input must be at least a matrix.
//
// For example:
//
// ```
// # 'input' is [[[1, 0, 0, 0]
//                [0, 2, 0, 0]
//                [0, 0, 3, 0]
//                [0, 0, 0, 4]],
//               [[5, 0, 0, 0]
//                [0, 6, 0, 0]
//                [0, 0, 7, 0]
//                [0, 0, 0, 8]]]
//
// and input.shape = (2, 4, 4)
//
// tf.matrix_diag_part(input) ==> [[1, 2, 3, 4], [5, 6, 7, 8]]
//
// which has shape (2, 4)
// ```
//
// Arguments:
//	input: Rank `k` tensor where `k >= 2`.
//
// Returns The extracted diagonal(s) having shape
// `diagonal.shape = input.shape[:-2] + [min(input.shape[-2:])]`.
func MatrixDiagPart(scope *Scope, input tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiagPart",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched matrix tensor with new batched diagonal values.
//
// Given `input` and `diagonal`, this operation returns a tensor with the
// same shape and values as `input`, except for the main diagonal of the
// innermost matrices.  These will be overwritten by the values in `diagonal`.
//
// The output is computed as follows:
//
// Assume `input` has `k+1` dimensions `[I, J, K, ..., M, N]` and `diagonal` has
// `k` dimensions `[I, J, K, ..., min(M, N)]`.  Then the output is a
// tensor of rank `k+1` with dimensions `[I, J, K, ..., M, N]` where:
//
//   * `output[i, j, k, ..., m, n] = diagonal[i, j, k, ..., n]` for `m == n`.
//   * `output[i, j, k, ..., m, n] = input[i, j, k, ..., m, n]` for `m != n`.
//
// Arguments:
//	input: Rank `k+1`, where `k >= 1`.
//	diagonal: Rank `k`, where `k >= 1`.
//
// Returns Rank `k+1`, with `output.shape = input.shape`.
func MatrixSetDiag(scope *Scope, input tf.Output, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixSetDiag",
		Input: []tf.Input{
			input, diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Extract `patches` from `images` and put them in the "depth" output dimension.
//
// Arguments:
//	images: 4-D Tensor with shape `[batch, in_rows, in_cols, depth]`.
//	ksizes: The size of the sliding window for each dimension of `images`.
//	strides: 1-D of length 4. How far the centers of two consecutive patches are in
// the images. Must be: `[1, stride_rows, stride_cols, 1]`.
//	rates: 1-D of length 4. Must be: `[1, rate_rows, rate_cols, 1]`. This is the
// input stride, specifying how far two consecutive patch samples are in the
// input. Equivalent to extracting patches with
// `patch_sizes_eff = patch_sizes + (patch_sizes - 1) * (rates - 1)`, followed by
// subsampling them spatially by a factor of `rates`. This is equivalent to
// `rate` in dilated (a.k.a. Atrous) convolutions.
//	padding: The type of padding algorithm to use.
//
// We specify the size-related attributes as:
//
// ```python
//       ksizes = [1, ksize_rows, ksize_cols, 1]
//       strides = [1, strides_rows, strides_cols, 1]
//       rates = [1, rates_rows, rates_cols, 1]
// ```
//
// Returns 4-D Tensor with shape `[batch, out_rows, out_cols, ksize_rows *
// ksize_cols * depth]` containing image patches with size
// `ksize_rows x ksize_cols x depth` vectorized in the "depth" dimension. Note
// `out_rows` and `out_cols` are the dimensions of the output patches.
func ExtractImagePatches(scope *Scope, images tf.Output, ksizes []int64, strides []int64, rates []int64, padding string) (patches tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksizes": ksizes, "strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "ExtractImagePatches",
		Input: []tf.Input{
			images,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a batched diagonal tensor with a given batched diagonal values.
//
// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
// everything else padded with zeros. The diagonal is computed as follows:
//
// Assume `diagonal` has `k` dimensions `[I, J, K, ..., N]`, then the output is a
// tensor of rank `k+1` with dimensions [I, J, K, ..., N, N]` where:
//
// `output[i, j, k, ..., m, n] = 1{m=n} * diagonal[i, j, k, ..., n]`.
//
// For example:
//
// ```
// # 'diagonal' is [[1, 2, 3, 4], [5, 6, 7, 8]]
//
// and diagonal.shape = (2, 4)
//
// tf.matrix_diag(diagonal) ==> [[[1, 0, 0, 0]
//                                      [0, 2, 0, 0]
//                                      [0, 0, 3, 0]
//                                      [0, 0, 0, 4]],
//                                     [[5, 0, 0, 0]
//                                      [0, 6, 0, 0]
//                                      [0, 0, 7, 0]
//                                      [0, 0, 0, 8]]]
//
// which has shape (2, 4, 4)
// ```
//
// Arguments:
//	diagonal: Rank `k`, where `k >= 1`.
//
// Returns Rank `k+1`, with `output.shape = diagonal.shape + [diagonal.shape[-1]]`.
func MatrixDiag(scope *Scope, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixDiag",
		Input: []tf.Input{
			diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Splits a tensor into `num_split` tensors along one dimension.
//
// Arguments:
//	value: The tensor to split.
//	size_splits: list containing the sizes of each output tensor along the split
// dimension. Must sum to the dimension of value along split_dim.
// Can contain one -1 indicating that dimension is to be inferred.
//	axis: 0-D.  The dimension along which to split.  Must be in the range
// `[-rank(value), rank(value))`.
//
//
// Returns Tensors whose shape matches that of `value`
// except along `axis`, where their sizes are
// `size_splits[i]`.
func SplitV(scope *Scope, value tf.Output, size_splits tf.Output, axis tf.Output, num_split int64) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_split": num_split}
	opspec := tf.OpSpec{
		Type: "SplitV",
		Input: []tf.Input{
			value, size_splits, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("SplitV", err)
		return
	}
	return output
}

// Gives a guarantee to the TF runtime that the input tensor is a constant.
//
// The runtime is then free to make optimizations based on this.
//
// Only accepts value typed tensors as inputs and rejects resource variable handles
// as input.
//
// Returns the input tensor without modification.
func GuaranteeConst(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GuaranteeConst",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Concatenates tensors along one dimension.
//
// Arguments:
//	values: List of `N` Tensors to concatenate. Their ranks and types must match,
// and their sizes must match in all dimensions except `concat_dim`.
//	axis: 0-D.  The dimension along which to concatenate.  Must be in the
// range [-rank(values), rank(values)).
//
// Returns A `Tensor` with the concatenation of values stacked along the
// `concat_dim` dimension.  This tensor's shape matches that of `values` except
// in `concat_dim` where it has the sum of the sizes.
func ConcatV2(scope *Scope, values []tf.Output, axis tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConcatV2",
		Input: []tf.Input{
			tf.OutputList(values), axis,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Broadcast an array for a compatible shape.
//
// Broadcasting is the process of making arrays to have compatible shapes
// for arithmetic operations. Two shapes are compatible if for each
// dimension pair they are either equal or one of them is one. When trying
// to broadcast a Tensor to a shape, it starts with the trailing dimensions,
// and works its way forward.
//
// For example,
//
// ```python
// >>> x = tf.constant([1, 2, 3])
// >>> y = tf.broadcast_to(x, [3, 3])
// >>> sess.run(y)
// array([[1, 2, 3],
//        [1, 2, 3],
//        [1, 2, 3]], dtype=int32)
// ```
//
// In the above example, the input Tensor with the shape of `[1, 3]`
// is broadcasted to output Tensor with shape of `[3, 3]`.
//
// Arguments:
//	input: A Tensor to broadcast.
//	shape: An 1-D `int` Tensor. The shape of the desired output.
//
// Returns A Tensor.
func BroadcastTo(scope *Scope, input tf.Output, shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastTo",
		Input: []tf.Input{
			input, shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts a flat index or array of flat indices into a tuple of
//
// coordinate arrays.
//
// @compatibility(numpy)
// Equivalent to np.unravel_index
// @end_compatibility
//
// Arguments:
//	indices: An 0-D or 1-D `int` Tensor whose elements are indices into the
// flattened version of an array of dimensions dims.
//	dims: An 1-D `int` Tensor. The shape of the array to use for unraveling
// indices.
//
// Returns An 2-D (or 1-D if indices is 0-D) tensor where each row has the
// same shape as the indices array.
func UnravelIndex(scope *Scope, indices tf.Output, dims tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnravelIndex",
		Input: []tf.Input{
			indices, dims,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UnpackAttr is an optional argument to Unpack.
type UnpackAttr func(optionalAttr)

// UnpackAxis sets the optional axis attribute to value.
//
// value: Dimension along which to unpack.  Negative values wrap around, so the
// valid range is `[-R, R)`.
// If not specified, defaults to 0
func UnpackAxis(value int64) UnpackAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Unpacks a given dimension of a rank-`R` tensor into `num` rank-`(R-1)` tensors.
//
// Unpacks `num` tensors from `value` by chipping it along the `axis` dimension.
// For example, given a tensor of shape `(A, B, C, D)`;
//
// If `axis == 0` then the i'th tensor in `output` is the slice `value[i, :, :, :]`
//   and each tensor in `output` will have shape `(B, C, D)`. (Note that the
//   dimension unpacked along is gone, unlike `split`).
//
// If `axis == 1` then the i'th tensor in `output` is the slice `value[:, i, :, :]`
//   and each tensor in `output` will have shape `(A, C, D)`.
// Etc.
//
// This is the opposite of `pack`.
//
// Arguments:
//	value: 1-D or higher, with `axis` dimension size equal to `num`.
//
//
// Returns The list of tensors unpacked from `value`.
func Unpack(scope *Scope, value tf.Output, num int64, optional ...UnpackAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num": num}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unpack",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("Unpack", err)
		return
	}
	return output
}

//     Subtracts `v` into specified rows of `x`.
//
//     Computes y = x; y[i, :] -= v; return y.
//
// Arguments:
//	x: A `Tensor` of type T.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceSub(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceSub",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//     Updates specified rows with values in `v`.
//
//     Computes `x[i, :] = v; return x`.
//
// Arguments:
//	x: A tensor of type `T`.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceUpdate(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceUpdate",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AudioSpectrogramAttr is an optional argument to AudioSpectrogram.
type AudioSpectrogramAttr func(optionalAttr)

// AudioSpectrogramMagnitudeSquared sets the optional magnitude_squared attribute to value.
//
// value: Whether to return the squared magnitude or just the
// magnitude. Using squared magnitude can avoid extra calculations.
// If not specified, defaults to false
func AudioSpectrogramMagnitudeSquared(value bool) AudioSpectrogramAttr {
	return func(m optionalAttr) {
		m["magnitude_squared"] = value
	}
}

// Produces a visualization of audio data over time.
//
// Spectrograms are a standard way of representing audio information as a series of
// slices of frequency information, one slice for each window of time. By joining
// these together into a sequence, they form a distinctive fingerprint of the sound
// over time.
//
// This op expects to receive audio data as an input, stored as floats in the range
// -1 to 1, together with a window width in samples, and a stride specifying how
// far to move the window between slices. From this it generates a three
// dimensional output. The first dimension is for the channels in the input, so a
// stereo audio input would have two here for example. The second dimension is time,
// with successive frequency slices. The third dimension has an amplitude value for
// each frequency during that time slice.
//
// This means the layout when converted and saved as an image is rotated 90 degrees
// clockwise from a typical spectrogram. Time is descending down the Y axis, and
// the frequency decreases from left to right.
//
// Each value in the result represents the square root of the sum of the real and
// imaginary parts of an FFT on the current window of samples. In this way, the
// lowest dimension represents the power of each frequency in the current window,
// and adjacent windows are concatenated in the next dimension.
//
// To get a more intuitive and visual look at what this operation does, you can run
// tensorflow/examples/wav_to_spectrogram to read in an audio file and save out the
// resulting spectrogram as a PNG image.
//
// Arguments:
//	input: Float representation of audio data.
//	window_size: How wide the input window is in samples. For the highest efficiency
// this should be a power of two, but other values are accepted.
//	stride: How widely apart the center of adjacent sample windows should be.
//
// Returns 3D representation of the audio frequencies as an image.
func AudioSpectrogram(scope *Scope, input tf.Output, window_size int64, stride int64, optional ...AudioSpectrogramAttr) (spectrogram tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"window_size": window_size, "stride": stride}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AudioSpectrogram",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Encode audio data using the WAV file format.
//
// This operation will generate a string suitable to be saved out to create a .wav
// audio file. It will be encoded in the 16-bit PCM format. It takes in float
// values in the range -1.0f to 1.0f, and any outside that value will be clamped to
// that range.
//
// `audio` is a 2-D float Tensor of shape `[length, channels]`.
// `sample_rate` is a scalar Tensor holding the rate to use (e.g. 44100).
//
// Arguments:
//	audio: 2-D with shape `[length, channels]`.
//	sample_rate: Scalar containing the sample frequency.
//
// Returns 0-D. WAV-encoded file contents.
func EncodeWav(scope *Scope, audio tf.Output, sample_rate tf.Output) (contents tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "EncodeWav",
		Input: []tf.Input{
			audio, sample_rate,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeWavAttr is an optional argument to DecodeWav.
type DecodeWavAttr func(optionalAttr)

// DecodeWavDesiredChannels sets the optional desired_channels attribute to value.
//
// value: Number of sample channels wanted.
// If not specified, defaults to -1
func DecodeWavDesiredChannels(value int64) DecodeWavAttr {
	return func(m optionalAttr) {
		m["desired_channels"] = value
	}
}

// DecodeWavDesiredSamples sets the optional desired_samples attribute to value.
//
// value: Length of audio requested.
// If not specified, defaults to -1
func DecodeWavDesiredSamples(value int64) DecodeWavAttr {
	return func(m optionalAttr) {
		m["desired_samples"] = value
	}
}

// Decode a 16-bit PCM WAV file to a float tensor.
//
// The -32768 to 32767 signed 16-bit values will be scaled to -1.0 to 1.0 in float.
//
// When desired_channels is set, if the input contains fewer channels than this
// then the last channel will be duplicated to give the requested number, else if
// the input has more channels than requested then the additional channels will be
// ignored.
//
// If desired_samples is set, then the audio will be cropped or padded with zeroes
// to the requested length.
//
// The first output contains a Tensor with the content of the audio samples. The
// lowest dimension will be the number of channels, and the second will be the
// number of samples. For example, a ten-sample-long stereo WAV file should give an
// output shape of [10, 2].
//
// Arguments:
//	contents: The WAV-encoded audio, usually from a file.
//
// Returns 2-D with shape `[length, channels]`.Scalar holding the sample rate found in the WAV header.
func DecodeWav(scope *Scope, contents tf.Output, optional ...DecodeWavAttr) (audio tf.Output, sample_rate tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeWav",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// UnbatchAttr is an optional argument to Unbatch.
type UnbatchAttr func(optionalAttr)

// UnbatchContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func UnbatchContainer(value string) UnbatchAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// UnbatchSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func UnbatchSharedName(value string) UnbatchAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Reverses the operation of Batch for a single output Tensor.
//
// An instance of Unbatch either receives an empty batched_tensor, in which case it
// asynchronously waits until the values become available from a concurrently
// running instance of Unbatch with the same container and shared_name, or receives
// a non-empty batched_tensor in which case it finalizes all other concurrently
// running instances and outputs its own element from the batch.
//
// batched_tensor: The possibly transformed output of Batch. The size of the first
//  dimension should remain unchanged by the transformations for the operation to
//  work.
// batch_index: The matching batch_index obtained from Batch.
// id: The id scalar emitted by Batch.
// unbatched_tensor: The Tensor corresponding to this execution.
// timeout_micros: Maximum amount of time (in microseconds) to wait to receive the
//  batched input tensor associated with a given invocation of the op.
// container: Container to control resource sharing.
// shared_name: Instances of Unbatch with the same container and shared_name are
//  assumed to possibly belong to the same batch. If left empty, the op name will
//  be used as the shared name.
func Unbatch(scope *Scope, batched_tensor tf.Output, batch_index tf.Output, id tf.Output, timeout_micros int64, optional ...UnbatchAttr) (unbatched_tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"timeout_micros": timeout_micros}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unbatch",
		Input: []tf.Input{
			batched_tensor, batch_index, id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchAttr is an optional argument to Batch.
type BatchAttr func(optionalAttr)

// BatchMaxEnqueuedBatches sets the optional max_enqueued_batches attribute to value.
// If not specified, defaults to 10
func BatchMaxEnqueuedBatches(value int64) BatchAttr {
	return func(m optionalAttr) {
		m["max_enqueued_batches"] = value
	}
}

// BatchAllowedBatchSizes sets the optional allowed_batch_sizes attribute to value.
// If not specified, defaults to <>
func BatchAllowedBatchSizes(value []int64) BatchAttr {
	return func(m optionalAttr) {
		m["allowed_batch_sizes"] = value
	}
}

// BatchContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BatchContainer(value string) BatchAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BatchSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BatchSharedName(value string) BatchAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// BatchBatchingQueue sets the optional batching_queue attribute to value.
// If not specified, defaults to ""
func BatchBatchingQueue(value string) BatchAttr {
	return func(m optionalAttr) {
		m["batching_queue"] = value
	}
}

// Batches all input tensors nondeterministically.
//
// When many instances of this Op are being run concurrently with the same
// container/shared_name in the same device, some will output zero-shaped Tensors
// and others will output Tensors of size up to max_batch_size.
//
// All Tensors in in_tensors are batched together (so, for example, labels and
// features should be batched with a single instance of this operation.
//
// Each invocation of batch emits an `id` scalar which will be used to identify
// this particular invocation when doing unbatch or its gradient.
//
// Each op which emits a non-empty batch will also emit a non-empty batch_index
// Tensor, which, is a [K, 3] matrix where each row contains the invocation's id,
// start, and length of elements of each set of Tensors present in batched_tensors.
//
// Batched tensors are concatenated along the first dimension, and all tensors in
// in_tensors must have the first dimension of the same size.
//
// in_tensors: The tensors to be batched.
// num_batch_threads: Number of scheduling threads for processing batches of work.
//  Determines the number of batches processed in parallel.
// max_batch_size: Batch sizes will never be bigger than this.
// batch_timeout_micros: Maximum number of microseconds to wait before outputting
//  an incomplete batch.
// allowed_batch_sizes: Optional list of allowed batch sizes. If left empty, does
//  nothing. Otherwise, supplies a list of batch sizes, causing the op to pad
//  batches up to one of those sizes. The entries must increase monotonically, and
//  the final entry must equal max_batch_size.
// grad_timeout_micros: The timeout to use for the gradient. See Unbatch.
// batched_tensors: Either empty tensors or a batch of concatenated Tensors.
// batch_index: If out_tensors is non-empty, has information to invert it.
// container: Controls the scope of sharing of this batch.
// id: always contains a scalar with a unique ID for this invocation of Batch.
// shared_name: Concurrently running instances of batch in the same device with the
//  same container and shared_name will batch their elements together. If left
//  empty, the op name will be used as the shared name.
// T: the types of tensors to be batched.
func Batch(scope *Scope, in_tensors []tf.Output, num_batch_threads int64, max_batch_size int64, batch_timeout_micros int64, grad_timeout_micros int64, optional ...BatchAttr) (batched_tensors []tf.Output, batch_index tf.Output, id tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_batch_threads": num_batch_threads, "max_batch_size": max_batch_size, "batch_timeout_micros": batch_timeout_micros, "grad_timeout_micros": grad_timeout_micros}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Batch",
		Input: []tf.Input{
			tf.OutputList(in_tensors),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if batched_tensors, idx, err = makeOutputList(op, idx, "batched_tensors"); err != nil {
		scope.UpdateErr("Batch", err)
		return
	}
	batch_index = op.Output(idx)
	id = op.Output(idx)
	return batched_tensors, batch_index, id
}

// Elementwise computes the bitwise right-shift of `x` and `y`.
//
// Performs a logical shift for unsigned integer types, and an arithmetic shift
// for signed integer types.
//
// If `y` is negative, or greater than or equal to than the width of `x` in bits
// the result is implementation defined.
func RightShift(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RightShift",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise OR of `x` and `y`.
//
// The result will have those bits set, that are set in `x`, `y` or both. The
// computation is performed on the underlying representations of `x` and `y`.
func BitwiseOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BoostedTreesQuantileStreamResourceFlushAttr is an optional argument to BoostedTreesQuantileStreamResourceFlush.
type BoostedTreesQuantileStreamResourceFlushAttr func(optionalAttr)

// BoostedTreesQuantileStreamResourceFlushGenerateQuantiles sets the optional generate_quantiles attribute to value.
//
// value: bool; If True, the output will be the num_quantiles for each stream where the ith
// entry is the ith quantile of the input with an approximation error of epsilon.
// Duplicate values may be present.
// If False, the output will be the points in the histogram that we got which roughly
// translates to 1/epsilon boundaries and without any duplicates.
// Default to False.
// If not specified, defaults to false
func BoostedTreesQuantileStreamResourceFlushGenerateQuantiles(value bool) BoostedTreesQuantileStreamResourceFlushAttr {
	return func(m optionalAttr) {
		m["generate_quantiles"] = value
	}
}

// Flush the summaries for a quantile stream resource.
//
// An op that flushes the summaries for a quantile stream resource.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	num_buckets: int; approximate number of buckets unless using generate_quantiles.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceFlush(scope *Scope, quantile_stream_resource_handle tf.Output, num_buckets tf.Output, optional ...BoostedTreesQuantileStreamResourceFlushAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceFlush",
		Input: []tf.Input{
			quantile_stream_resource_handle, num_buckets,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesQuantileStreamResourceHandleOpAttr is an optional argument to BoostedTreesQuantileStreamResourceHandleOp.
type BoostedTreesQuantileStreamResourceHandleOpAttr func(optionalAttr)

// BoostedTreesQuantileStreamResourceHandleOpContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BoostedTreesQuantileStreamResourceHandleOpContainer(value string) BoostedTreesQuantileStreamResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BoostedTreesQuantileStreamResourceHandleOpSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BoostedTreesQuantileStreamResourceHandleOpSharedName(value string) BoostedTreesQuantileStreamResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a handle to a BoostedTreesQuantileStreamResource.
func BoostedTreesQuantileStreamResourceHandleOp(scope *Scope, optional ...BoostedTreesQuantileStreamResourceHandleOpAttr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceHandleOp",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the update to cached logits. It is designed to be used during training.
// It traverses the trees starting from cached tree id and cached node id and
// calculates the updates to be pushed to the cache.
//
// Arguments:
//
//	cached_tree_ids: Rank 1 Tensor containing cached tree ids which is the starting
// tree of prediction.
//	cached_node_ids: Rank 1 Tensor containing cached node id which is the starting
// node of prediction.
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
// feature.
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
// shape.
//
// Returns Rank 2 Tensor containing logits update (with respect to cached
// values stored) for each example.Rank 1 Tensor containing new tree ids for each example.Rank 1 Tensor containing new node ids in the new tree_ids.
func BoostedTreesTrainingPredict(scope *Scope, tree_ensemble_handle tf.Output, cached_tree_ids tf.Output, cached_node_ids tf.Output, bucketized_features []tf.Output, logits_dimension int64) (partial_logits tf.Output, tree_ids tf.Output, node_ids tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesTrainingPredict",
		Input: []tf.Input{
			tree_ensemble_handle, cached_tree_ids, cached_node_ids, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Serializes the tree ensemble to a proto.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble.
//
// Returns Stamp token of the tree ensemble resource.Serialized proto of the ensemble.
func BoostedTreesSerializeEnsemble(scope *Scope, tree_ensemble_handle tf.Output) (stamp_token tf.Output, tree_ensemble_serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSerializeEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Debugging/model interpretability outputs for each example.
//
// It traverses all the trees and computes debug metrics for individual examples,
// such as getting split feature ids and logits after each split along the decision
// path used to compute directional feature contributions.
//
// Arguments:
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
// feature.
//	logits_dimension: scalar, dimension of the logits, to be used for constructing the protos in
// examples_debug_outputs_serialized.
//
// Returns Output rank 1 Tensor containing a proto serialized as a string for each example.
func BoostedTreesExampleDebugOutputs(scope *Scope, tree_ensemble_handle tf.Output, bucketized_features []tf.Output, logits_dimension int64) (examples_debug_outputs_serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesExampleDebugOutputs",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

//     Adds v into specified rows of x.
//
//     Computes y = x; y[i, :] += v; return y.
//
// Arguments:
//	x: A `Tensor` of type T.
//	i: A vector. Indices into the left-most dimension of `x`.
//	v: A `Tensor` of type T. Same dimension sizes as x except the first dimension, which must be the same as i's size.
//
// Returns A `Tensor` of type T. An alias of `x`. The content of `y` is undefined if there are duplicates in `i`.
func InplaceAdd(scope *Scope, x tf.Output, i tf.Output, v tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InplaceAdd",
		Input: []tf.Input{
			x, i, v,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Runs multiple additive regression ensemble predictors on input instances and
//
// computes the logits. It is designed to be used during prediction.
// It traverses all the trees and calculates the final score for each instance.
//
// Arguments:
//
//	bucketized_features: A list of rank 1 Tensors containing bucket id for each
// feature.
//	logits_dimension: scalar, dimension of the logits, to be used for partial logits
// shape.
//
// Returns Output rank 2 Tensor containing logits for each example.
func BoostedTreesPredict(scope *Scope, tree_ensemble_handle tf.Output, bucketized_features []tf.Output, logits_dimension int64) (logits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "BoostedTreesPredict",
		Input: []tf.Input{
			tree_ensemble_handle, tf.OutputList(bucketized_features),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated into the corresponding node and bucket for each example.
//
// Arguments:
//	node_ids: int32 Rank 1 Tensor containing node ids, which each example falls into for the requested layer.
//	gradients: float32; Rank 2 Tensor (shape=[#examples, 1]) for gradients.
//	hessians: float32; Rank 2 Tensor (shape=[#examples, 1]) for hessians.
//	bucketized_features_list: int32 list of Rank 1 Tensors, each containing the bucketized feature (for each feature column).
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature.
//
// Returns output Rank 4 Tensor (shape=[#features, #splits, #buckets, 2]) containing accumulated stats put into the corresponding node and bucket. The first index of 4th dimension refers to gradients, and the second to hessians.
func BoostedTreesMakeStatsSummary(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, bucketized_features_list []tf.Output, max_splits int64, num_buckets int64) (stats_summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesMakeStatsSummary",
		Input: []tf.Input{
			node_ids, gradients, hessians, tf.OutputList(bucketized_features_list),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deserializes a serialized tree ensemble config and replaces current tree
//
// ensemble.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble.
//	stamp_token: Token to use as the new value of the resource stamp.
//	tree_ensemble_serialized: Serialized proto of the ensemble.
//
// Returns the created operation.
func BoostedTreesDeserializeEnsemble(scope *Scope, tree_ensemble_handle tf.Output, stamp_token tf.Output, tree_ensemble_serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesDeserializeEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, stamp_token, tree_ensemble_serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// QuantizedInstanceNormAttr is an optional argument to QuantizedInstanceNorm.
type QuantizedInstanceNormAttr func(optionalAttr)

// QuantizedInstanceNormOutputRangeGiven sets the optional output_range_given attribute to value.
//
// value: If True, `given_y_min` and `given_y_min`
// and `given_y_max` are used as the output range. Otherwise,
// the implementation computes the output range.
// If not specified, defaults to false
func QuantizedInstanceNormOutputRangeGiven(value bool) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["output_range_given"] = value
	}
}

// QuantizedInstanceNormGivenYMin sets the optional given_y_min attribute to value.
//
// value: Output in `y_min` if `output_range_given` is True.
// If not specified, defaults to 0
func QuantizedInstanceNormGivenYMin(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["given_y_min"] = value
	}
}

// QuantizedInstanceNormGivenYMax sets the optional given_y_max attribute to value.
//
// value: Output in `y_max` if `output_range_given` is True.
// If not specified, defaults to 0
func QuantizedInstanceNormGivenYMax(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["given_y_max"] = value
	}
}

// QuantizedInstanceNormVarianceEpsilon sets the optional variance_epsilon attribute to value.
//
// value: A small float number to avoid dividing by 0.
// If not specified, defaults to 1e-05
func QuantizedInstanceNormVarianceEpsilon(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["variance_epsilon"] = value
	}
}

// QuantizedInstanceNormMinSeparation sets the optional min_separation attribute to value.
//
// value: Minimum value of `y_max - y_min`
// If not specified, defaults to 0.001
func QuantizedInstanceNormMinSeparation(value float32) QuantizedInstanceNormAttr {
	return func(m optionalAttr) {
		m["min_separation"] = value
	}
}

// Quantized Instance normalization.
//
// Arguments:
//	x: A 4D input Tensor.
//	x_min: The value represented by the lowest quantized input.
//	x_max: The value represented by the highest quantized input.
//
// Returns A 4D Tensor.The value represented by the lowest quantized output.The value represented by the highest quantized output.
func QuantizedInstanceNorm(scope *Scope, x tf.Output, x_min tf.Output, x_max tf.Output, optional ...QuantizedInstanceNormAttr) (y tf.Output, y_min tf.Output, y_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedInstanceNorm",
		Input: []tf.Input{
			x, x_min, x_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Creates a tree ensemble model and returns a handle to it.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble resource to be created.
//	stamp_token: Token to use as the initial value of the resource stamp.
//	tree_ensemble_serialized: Serialized proto of the tree ensemble.
//
// Returns the created operation.
func BoostedTreesCreateEnsemble(scope *Scope, tree_ensemble_handle tf.Output, stamp_token tf.Output, tree_ensemble_serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCreateEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, stamp_token, tree_ensemble_serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesCalculateBestFeatureSplitAttr is an optional argument to BoostedTreesCalculateBestFeatureSplit.
type BoostedTreesCalculateBestFeatureSplitAttr func(optionalAttr)

// BoostedTreesCalculateBestFeatureSplitSplitType sets the optional split_type attribute to value.
//
// value: A string indicating if this Op should perform inequality split or equality split.
// If not specified, defaults to "inequality"
func BoostedTreesCalculateBestFeatureSplitSplitType(value string) BoostedTreesCalculateBestFeatureSplitAttr {
	return func(m optionalAttr) {
		m["split_type"] = value
	}
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The output shapes are compatible in a way that the first dimension of all tensors are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary: A Rank 4 tensor (#shape=[max_splits, feature_dims, bucket, stats_dims]) for accumulated stats summary (gradient/hessian) per node, per dimension, per buckets for each feature.
// The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: mininum avg of hessians in a node before required for the node to be considered for splitting.
//	logits_dimension: The dimension of logit, i.e., number of classes.
//
// Returns A Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.A Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.A Rank 1 tensors indicating the best feature dimension for each feature to split for certain nodes if the feature is multi-dimension. See above for details like shapes and sizes.A Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.A Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.A Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.A Rank 1 tensors indicating the which direction to go if data is missing. See above for details like shapes and sizes.
func BoostedTreesCalculateBestFeatureSplit(scope *Scope, node_id_range tf.Output, stats_summary tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, logits_dimension int64, optional ...BoostedTreesCalculateBestFeatureSplitAttr) (node_ids tf.Output, gains tf.Output, feature_dimensions tf.Output, thresholds tf.Output, left_node_contribs tf.Output, right_node_contribs tf.Output, split_with_default_directions tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestFeatureSplit",
		Input: []tf.Input{
			node_id_range, stats_summary, l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5), op.Output(6)
}

// Calculates gains for each feature and returns the best possible split information for the feature.
//
// The split information is the best threshold (bucket id), gains and left/right node contributions per node for each feature.
//
// It is possible that not all nodes can be split on each feature. Hence, the list of possible nodes can differ between the features. Therefore, we return `node_ids_list` for each feature, containing the list of nodes that this feature can be used to split.
//
// In this manner, the output is the best split per features and per node, so that it needs to be combined later to produce the best split for each node (among all possible features).
//
// The length of output lists are all of the same length, `num_features`.
// The output shapes are compatible in a way that the first dimension of all tensors of all lists are the same and equal to the number of possible split nodes for each feature.
//
// Arguments:
//	node_id_range: A Rank 1 tensor (shape=[2]) to specify the range [first, last) of node ids to process within `stats_summary_list`. The nodes are iterated between the two nodes specified by the tensor, as like `for node_id in range(node_id_range[0], node_id_range[1])` (Note that the last index node_id_range[1] is exclusive).
//	stats_summary_list: A list of Rank 3 tensor (#shape=[max_splits, bucket, 2]) for accumulated stats summary (gradient/hessian) per node per buckets for each feature. The first dimension of the tensor is the maximum number of splits, and thus not all elements of it will be used, but only the indexes specified by node_ids will be used.
//	l1: l1 regularization factor on leaf weights, per instance based.
//	l2: l2 regularization factor on leaf weights, per instance based.
//	tree_complexity: adjustment to the gain, per leaf based.
//	min_node_weight: mininum avg of hessians in a node before required for the node to be considered for splitting.
//	max_splits: the number of nodes that can be split in the whole tree. Used as a dimension of output tensors.
//
// Returns An output list of Rank 1 tensors indicating possible split node ids for each feature. The length of the list is num_features, but each tensor has different size as each feature provides different possible nodes. See above for details like shapes and sizes.An output list of Rank 1 tensors indicating the best gains for each feature to split for certain nodes. See above for details like shapes and sizes.An output list of Rank 1 tensors indicating the bucket id to compare with (as a threshold) for split in each node. See above for details like shapes and sizes.A list of Rank 2 tensors indicating the contribution of the left nodes when branching from parent nodes (given by the tensor element in the output node_ids_list) to the left direction by the given threshold for each feature. This value will be used to make the left node value by adding to the parent node value. Second dimension size is 1 for 1-dimensional logits, but would be larger for multi-class problems. See above for details like shapes and sizes.A list of Rank 2 tensors, with the same shape/conditions as left_node_contribs_list, but just that the value is for the right node.
func BoostedTreesCalculateBestGainsPerFeature(scope *Scope, node_id_range tf.Output, stats_summary_list []tf.Output, l1 tf.Output, l2 tf.Output, tree_complexity tf.Output, min_node_weight tf.Output, max_splits int64) (node_ids_list []tf.Output, gains_list []tf.Output, thresholds_list []tf.Output, left_node_contribs_list []tf.Output, right_node_contribs_list []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCalculateBestGainsPerFeature",
		Input: []tf.Input{
			node_id_range, tf.OutputList(stats_summary_list), l1, l2, tree_complexity, min_node_weight,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if node_ids_list, idx, err = makeOutputList(op, idx, "node_ids_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if gains_list, idx, err = makeOutputList(op, idx, "gains_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if thresholds_list, idx, err = makeOutputList(op, idx, "thresholds_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if left_node_contribs_list, idx, err = makeOutputList(op, idx, "left_node_contribs_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	if right_node_contribs_list, idx, err = makeOutputList(op, idx, "right_node_contribs_list"); err != nil {
		scope.UpdateErr("BoostedTreesCalculateBestGainsPerFeature", err)
		return
	}
	return node_ids_list, gains_list, thresholds_list, left_node_contribs_list, right_node_contribs_list
}

// Get the number of nodes in a tree
//
// Arguments:
//	tree_handle: Handle to the tree resource.
//
// Returns The size of the tree.
func TensorForestTreeSize(scope *Scope, tree_handle tf.Output) (tree_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorForestTreeSize",
		Input: []tf.Input{
			tree_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deserializes a proto into the tree handle
//
// Arguments:
//	tree_handle: Handle to the tree resource to be restored.
//	tree_config: Serialied proto string of the boosted_trees.Tree proto.
//
// Returns the created operation.
func TensorForestTreeDeserialize(scope *Scope, tree_handle tf.Output, tree_config tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorForestTreeDeserialize",
		Input: []tf.Input{
			tree_handle, tree_config,
		},
	}
	return scope.AddOperation(opspec)
}

// Serializes the tree handle to a proto
//
// Arguments:
//	tree_handle: Handle to the tree resource to be serialized.
//
// Returns Serialied proto string of the tree resource.
func TensorForestTreeSerialize(scope *Scope, tree_handle tf.Output) (tree_config tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorForestTreeSerialize",
		Input: []tf.Input{
			tree_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a tree resource and returns a handle to it.
//
// Arguments:
//	tree_handle: Handle to the tree resource to be created.
//	tree_config: Serialized proto string of the boosted_trees.Tree.
//
// Returns the created operation.
func TensorForestCreateTreeVariable(scope *Scope, tree_handle tf.Output, tree_config tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorForestCreateTreeVariable",
		Input: []tf.Input{
			tree_handle, tree_config,
		},
	}
	return scope.AddOperation(opspec)
}

// ComputeAccidentalHitsAttr is an optional argument to ComputeAccidentalHits.
type ComputeAccidentalHitsAttr func(optionalAttr)

// ComputeAccidentalHitsSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func ComputeAccidentalHitsSeed(value int64) ComputeAccidentalHitsAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// ComputeAccidentalHitsSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func ComputeAccidentalHitsSeed2(value int64) ComputeAccidentalHitsAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Computes the ids of the positions in sampled_candidates that match true_labels.
//
// When doing log-odds NCE, the result of this op should be passed through a
// SparseToDense op, then added to the logits of the sampled candidates. This has
// the effect of 'removing' the sampled labels that match the true labels by
// making the classifier sure that they are sampled labels.
//
// Arguments:
//	true_classes: The true_classes output of UnpackSparseLabels.
//	sampled_candidates: The sampled_candidates output of CandidateSampler.
//	num_true: Number of true labels per context.
//
// Returns A vector of indices corresponding to rows of true_candidates.A vector of IDs of positions in sampled_candidates that match a true_label
// for the row with the corresponding index in indices.A vector of the same length as indices and ids, in which each element
// is -FLOAT_MAX.
func ComputeAccidentalHits(scope *Scope, true_classes tf.Output, sampled_candidates tf.Output, num_true int64, optional ...ComputeAccidentalHitsAttr) (indices tf.Output, ids tf.Output, weights tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ComputeAccidentalHits",
		Input: []tf.Input{
			true_classes, sampled_candidates,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// LearnedUnigramCandidateSamplerAttr is an optional argument to LearnedUnigramCandidateSampler.
type LearnedUnigramCandidateSamplerAttr func(optionalAttr)

// LearnedUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func LearnedUnigramCandidateSamplerSeed(value int64) LearnedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// LearnedUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func LearnedUnigramCandidateSamplerSeed2(value int64) LearnedUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func LearnedUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...LearnedUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LearnedUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// UniformCandidateSamplerAttr is an optional argument to UniformCandidateSampler.
type UniformCandidateSamplerAttr func(optionalAttr)

// UniformCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func UniformCandidateSamplerSeed(value int64) UniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// UniformCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func UniformCandidateSamplerSeed2(value int64) UniformCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a uniform distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func UniformCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...UniformCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniformCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// LoadAndRemapMatrixAttr is an optional argument to LoadAndRemapMatrix.
type LoadAndRemapMatrixAttr func(optionalAttr)

// LoadAndRemapMatrixMaxRowsInMemory sets the optional max_rows_in_memory attribute to value.
//
// value: The maximum number of rows to load from the checkpoint at
// once. If less than or equal to 0, the entire matrix will be loaded into
// memory. Setting this arg trades increased disk reads for lower memory usage.
// If not specified, defaults to -1
func LoadAndRemapMatrixMaxRowsInMemory(value int64) LoadAndRemapMatrixAttr {
	return func(m optionalAttr) {
		m["max_rows_in_memory"] = value
	}
}

// Loads a 2-D (matrix) `Tensor` with name `old_tensor_name` from the checkpoint
//
// at `ckpt_path` and potentially reorders its rows and columns using the
// specified remappings.
//
// Most users should use one of the wrapper initializers (such as
// `tf.contrib.framework.load_and_remap_matrix_initializer`) instead of this
// function directly.
//
// The remappings are 1-D tensors with the following properties:
//
// * `row_remapping` must have exactly `num_rows` entries. Row `i` of the output
//   matrix will be initialized from the row corresponding to index
//   `row_remapping[i]` in the old `Tensor` from the checkpoint.
// * `col_remapping` must have either 0 entries (indicating that no column
//   reordering is needed) or `num_cols` entries. If specified, column `j` of the
//   output matrix will be initialized from the column corresponding to index
//   `col_remapping[j]` in the old `Tensor` from the checkpoint.
// * A value of -1 in either of the remappings signifies a "missing" entry. In that
//   case, values from the `initializing_values` tensor will be used to fill that
//   missing row or column. If `row_remapping` has `r` missing entries and
//   `col_remapping` has `c` missing entries, then the following condition must be
//   true:
//
// `(r * num_cols) + (c * num_rows) - (r * c) == len(initializing_values)`
//
// The remapping tensors can be generated using the GenerateVocabRemapping op.
//
// As an example, with row_remapping = [1, 0, -1], col_remapping = [0, 2, -1],
// initializing_values = [0.5, -0.5, 0.25, -0.25, 42], and w(i, j) representing
// the value from row i, column j of the old tensor in the checkpoint, the output
// matrix will look like the following:
//
// [[w(1, 0),  w(1, 2),  0.5],
//  [w(0, 0),  w(0, 2), -0.5],
//  [0.25,    -0.25,      42]]
//
// Arguments:
//	ckpt_path: Path to the TensorFlow checkpoint (version 2, `TensorBundle`) from
// which the old matrix `Tensor` will be loaded.
//	old_tensor_name: Name of the 2-D `Tensor` to load from checkpoint.
//	row_remapping: An int `Tensor` of row remappings (generally created by
// `generate_vocab_remapping`).  Even if no row remapping is needed, this must
// still be an index-valued Tensor (e.g. [0, 1, 2, ...]), or a shifted
// index-valued `Tensor` (e.g. [8, 9, 10, ...], for partitioned `Variables`).
//	col_remapping: An int `Tensor` of column remappings (generally created by
// `generate_vocab_remapping`).  May be a size-0 `Tensor` if only row remapping
// is to be done (e.g. column ordering is the same).
//	initializing_values: A float `Tensor` containing  values to fill in for cells
// in the output matrix that are not loaded from the checkpoint. Length must be
// exactly the same as the number of missing / new cells.
//	num_rows: Number of rows (length of the 1st dimension) in the output matrix.
//	num_cols: Number of columns (length of the 2nd dimension) in the output matrix.
//
// Returns Output matrix containing existing values loaded from the
// checkpoint, and with any missing values filled in from initializing_values.
func LoadAndRemapMatrix(scope *Scope, ckpt_path tf.Output, old_tensor_name tf.Output, row_remapping tf.Output, col_remapping tf.Output, initializing_values tf.Output, num_rows int64, num_cols int64, optional ...LoadAndRemapMatrixAttr) (output_matrix tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_rows": num_rows, "num_cols": num_cols}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadAndRemapMatrix",
		Input: []tf.Input{
			ckpt_path, old_tensor_name, row_remapping, col_remapping, initializing_values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GenerateVocabRemappingAttr is an optional argument to GenerateVocabRemapping.
type GenerateVocabRemappingAttr func(optionalAttr)

// GenerateVocabRemappingOldVocabSize sets the optional old_vocab_size attribute to value.
//
// value: Number of entries in the old vocab file to consider.  If -1,
// use the entire old vocabulary.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func GenerateVocabRemappingOldVocabSize(value int64) GenerateVocabRemappingAttr {
	return func(m optionalAttr) {
		m["old_vocab_size"] = value
	}
}

// Given a path to new and old vocabulary files, returns a remapping Tensor of
//
// length `num_new_vocab`, where `remapping[i]` contains the row number in the old
// vocabulary that corresponds to row `i` in the new vocabulary (starting at line
// `new_vocab_offset` and up to `num_new_vocab` entities), or `-1` if entry `i`
// in the new vocabulary is not in the old vocabulary.  The old vocabulary is
// constrained to the first `old_vocab_size` entries if `old_vocab_size` is not the
// default value of -1.
//
// `num_vocab_offset` enables
// use in the partitioned variable case, and should generally be set through
// examining partitioning info.  The format of the files should be a text file,
// with each line containing a single entity within the vocabulary.
//
// For example, with `new_vocab_file` a text file containing each of the following
// elements on a single line: `[f0, f1, f2, f3]`, old_vocab_file = [f1, f0, f3],
// `num_new_vocab = 3, new_vocab_offset = 1`, the returned remapping would be
// `[0, -1, 2]`.
//
// The op also returns a count of how many entries in the new vocabulary
// were present in the old vocabulary, which is used to calculate the number of
// values to initialize in a weight matrix remapping
//
// This functionality can be used to remap both row vocabularies (typically,
// features) and column vocabularies (typically, classes) from TensorFlow
// checkpoints.  Note that the partitioning logic relies on contiguous vocabularies
// corresponding to div-partitioned variables.  Moreover, the underlying remapping
// uses an IndexTable (as opposed to an inexact CuckooTable), so client code should
// use the corresponding index_table_from_file() as the FeatureColumn framework
// does (as opposed to tf.feature_to_id(), which uses a CuckooTable).
//
// Arguments:
//	new_vocab_file: Path to the new vocab file.
//	old_vocab_file: Path to the old vocab file.
//	new_vocab_offset: How many entries into the new vocab file to start reading.
//	num_new_vocab: Number of entries in the new vocab file to remap.
//
// Returns A Tensor of length num_new_vocab where the element at index i
// is equal to the old ID that maps to the new ID i.  This element is -1 for any
// new ID that is not found in the old vocabulary.Number of new vocab entries found in old vocab.
func GenerateVocabRemapping(scope *Scope, new_vocab_file tf.Output, old_vocab_file tf.Output, new_vocab_offset int64, num_new_vocab int64, optional ...GenerateVocabRemappingAttr) (remapping tf.Output, num_present tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"new_vocab_offset": new_vocab_offset, "num_new_vocab": num_new_vocab}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GenerateVocabRemapping",
		Input: []tf.Input{
			new_vocab_file, old_vocab_file,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Selects the k nearest centers for each point.
//
// Rows of points are assumed to be input points. Rows of centers are assumed to be
// the list of candidate centers. For each point, the k centers that have least L2
// distance to it are computed.
//
// Arguments:
//	points: Matrix of shape (n, d). Rows are assumed to be input points.
//	centers: Matrix of shape (m, d). Rows are assumed to be centers.
//	k: Number of nearest centers to return for each point. If k is larger than m, then
// only m centers are returned.
//
// Returns Matrix of shape (n, min(m, k)). Each row contains the indices of the centers
// closest to the corresponding point, ordered by increasing distance.Matrix of shape (n, min(m, k)). Each row contains the squared L2 distance to the
// corresponding center in nearest_center_indices.
func NearestNeighbors(scope *Scope, points tf.Output, centers tf.Output, k tf.Output) (nearest_center_indices tf.Output, nearest_center_distances tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NearestNeighbors",
		Input: []tf.Input{
			points, centers, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns the index of a data point that should be added to the seed set.
//
// Entries in distances are assumed to be squared distances of candidate points to
// the already sampled centers in the seed set. The op constructs one Markov chain
// of the k-MC^2 algorithm and returns the index of one candidate point to be added
// as an additional cluster center.
//
// Arguments:
//	distances: Vector with squared distances to the closest previously sampled cluster center
// for each candidate point.
//	seed: Scalar. Seed for initializing the random number generator.
//
// Returns Scalar with the index of the sampled point.
func KMC2ChainInitialization(scope *Scope, distances tf.Output, seed tf.Output) (index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "KMC2ChainInitialization",
		Input: []tf.Input{
			distances, seed,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Selects num_to_sample rows of input using the KMeans++ criterion.
//
// Rows of points are assumed to be input points. One row is selected at random.
// Subsequent rows are sampled with probability proportional to the squared L2
// distance from the nearest row selected thus far till num_to_sample rows have
// been sampled.
//
// Arguments:
//	points: Matrix of shape (n, d). Rows are assumed to be input points.
//	num_to_sample: Scalar. The number of rows to sample. This value must not be larger than n.
//	seed: Scalar. Seed for initializing the random number generator.
//	num_retries_per_sample: Scalar. For each row that is sampled, this parameter
// specifies the number of additional points to draw from the current
// distribution before selecting the best. If a negative value is specified, a
// heuristic is used to sample O(log(num_to_sample)) additional points.
//
// Returns Matrix of shape (num_to_sample, d). The sampled rows.
func KmeansPlusPlusInitialization(scope *Scope, points tf.Output, num_to_sample tf.Output, seed tf.Output, num_retries_per_sample tf.Output) (samples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "KmeansPlusPlusInitialization",
		Input: []tf.Input{
			points, num_to_sample, seed, num_retries_per_sample,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Receives a tensor value broadcast from another device.
func CollectiveBcastRecv(scope *Scope, T tf.DataType, group_size int64, group_key int64, instance_key int64, shape tf.Shape) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T, "group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastRecv",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Ensures that the tensor's shape matches the expected shape.
//
// Raises an error if the input tensor's shape does not match the specified shape.
// Returns the input tensor otherwise.
//
// Arguments:
//	input: A tensor, whose shape is to be validated.
//	shape: The expected (possibly partially specified) shape of the input tensor.
//
// Returns A tensor with the same shape and contents as the input tensor or value.
func EnsureShape(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "EnsureShape",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Broadcasts a tensor value to one or more other devices.
func CollectiveBcastSend(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, shape tf.Shape) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	opspec := tf.OpSpec{
		Type: "CollectiveBcastSend",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Mutually accumulates multiple tensors of identical type and shape.
func CollectiveGather(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, shape tf.Shape) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "shape": shape}
	opspec := tf.OpSpec{
		Type: "CollectiveGather",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CollectiveReduceAttr is an optional argument to CollectiveReduce.
type CollectiveReduceAttr func(optionalAttr)

// CollectiveReduceWaitFor sets the optional wait_for attribute to value.
// If not specified, defaults to <>
func CollectiveReduceWaitFor(value []int64) CollectiveReduceAttr {
	return func(m optionalAttr) {
		m["wait_for"] = value
	}
}

// Mutually reduces multiple tensors of identical type and shape.
func CollectiveReduce(scope *Scope, input tf.Output, group_size int64, group_key int64, instance_key int64, merge_op string, final_op string, subdiv_offsets []int64, optional ...CollectiveReduceAttr) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"group_size": group_size, "group_key": group_key, "instance_key": instance_key, "merge_op": merge_op, "final_op": final_op, "subdiv_offsets": subdiv_offsets}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CollectiveReduce",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bitcasts a tensor from one type to another without copying data.
//
// Given a tensor `input`, this operation returns a tensor that has the same buffer
// data as `input` with datatype `type`.
//
// If the input datatype `T` is larger than the output datatype `type` then the
// shape changes from [...] to [..., sizeof(`T`)/sizeof(`type`)].
//
// If `T` is smaller than `type`, the operator requires that the rightmost
// dimension be equal to sizeof(`type`)/sizeof(`T`). The shape then goes from
// [..., sizeof(`type`)/sizeof(`T`)] to [...].
//
// tf.bitcast() and tf.cast() work differently when real dtype is casted as a complex dtype
// (e.g. tf.complex64 or tf.complex128) as tf.cast() make imaginary part 0 while tf.bitcast()
// gives module error.
// For example,
//
// Example 1:
// ```python
// >>> a = [1., 2., 3.]
// >>> equality_bitcast = tf.bitcast(a,tf.complex128)
// tensorflow.python.framework.errors_impl.InvalidArgumentError: Cannot bitcast from float to complex128: shape [3] [Op:Bitcast]
// >>> equality_cast = tf.cast(a,tf.complex128)
// >>> print(equality_cast)
// tf.Tensor([1.+0.j 2.+0.j 3.+0.j], shape=(3,), dtype=complex128)
// ```
// Example 2:
// ```python
// >>> tf.bitcast(tf.constant(0xffffffff, dtype=tf.uint32), tf.uint8)
// <tf.Tensor: ... shape=(4,), dtype=uint8, numpy=array([255, 255, 255, 255], dtype=uint8)>
// ```
// Example 3:
// ```python
// >>> x = [1., 2., 3.]
// >>> y = [0., 2., 3.]
// >>> equality= tf.equal(x,y)
// >>> equality_cast = tf.cast(equality,tf.float32)
// >>> equality_bitcast = tf.bitcast(equality_cast,tf.uint8)
// >>> print(equality)
// tf.Tensor([False True True], shape=(3,), dtype=bool)
// >>> print(equality_cast)
// tf.Tensor([0. 1. 1.], shape=(3,), dtype=float32)
// >>> print(equality_bitcast)
// tf.Tensor(
// [[ 0 0 0 0]
//  [ 0 0 128 63]
//  [ 0 0 128 63]], shape=(3, 4), dtype=uint8)
// ```
//
// *NOTE*: Bitcast is implemented as a low-level cast, so machines with different
// endian orderings will give different results.
func Bitcast(scope *Scope, input tf.Output, type_ tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"type": type_}
	opspec := tf.OpSpec{
		Type: "Bitcast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AbortAttr is an optional argument to Abort.
type AbortAttr func(optionalAttr)

// AbortErrorMsg sets the optional error_msg attribute to value.
//
// value: A string which is the message associated with the exception.
// If not specified, defaults to ""
func AbortErrorMsg(value string) AbortAttr {
	return func(m optionalAttr) {
		m["error_msg"] = value
	}
}

// AbortExitWithoutError sets the optional exit_without_error attribute to value.
// If not specified, defaults to false
func AbortExitWithoutError(value bool) AbortAttr {
	return func(m optionalAttr) {
		m["exit_without_error"] = value
	}
}

// Raise a exception to abort the process when called.
//
// If exit_without_error is true, the process will exit normally,
// otherwise it will exit with a SIGABORT signal.
//
// Returns nothing but an exception.
//
// Returns the created operation.
func Abort(scope *Scope, optional ...AbortAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Abort",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Forwards the input to the output.
//
// This operator represents the loop termination condition used by the
// "pivot" switches of a loop.
//
// Arguments:
//	input: A boolean scalar, representing the branch predicate of the Switch op.
//
// Returns The same tensor as `input`.
func LoopCond(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LoopCond",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthToSpaceAttr is an optional argument to DepthToSpace.
type DepthToSpaceAttr func(optionalAttr)

// DepthToSpaceDataFormat sets the optional data_format attribute to value.
// If not specified, defaults to "NHWC"
func DepthToSpaceDataFormat(value string) DepthToSpaceAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthToSpace for tensors of type T.
//
// Rearranges data from depth into blocks of spatial data.
// This is the reverse transformation of SpaceToDepth. More specifically,
// this op outputs a copy of the input tensor where values from the `depth`
// dimension are moved in spatial blocks to the `height` and `width` dimensions.
// The attr `block_size` indicates the input block size and how the data is moved.
//
//   * Chunks of data of size `block_size * block_size` from depth are rearranged
//     into non-overlapping blocks of size `block_size x block_size`
//   * The width the output tensor is `input_depth * block_size`, whereas the
//     height is `input_height * block_size`.
//   * The Y, X coordinates within each block of the output image are determined
//     by the high order component of the input channel index.
//   * The depth of the input tensor must be divisible by
//     `block_size * block_size`.
//
// The `data_format` attr specifies the layout of the input and output tensors
// with the following options:
//   "NHWC": `[ batch, height, width, channels ]`
//   "NCHW": `[ batch, channels, height, width ]`
//   "NCHW_VECT_C":
//       `qint8 [ batch, channels / 4, height, width, 4 ]`
//
// It is useful to consider the operation as transforming a 6-D Tensor.
// e.g. for data_format = NHWC,
//      Each element in the input tensor can be specified via 6 coordinates,
//      ordered by decreasing memory layout significance as:
//      n,iY,iX,bY,bX,oC  (where n=batch index, iX, iY means X or Y coordinates
//                         within the input image, bX, bY means coordinates
//                         within the output block, oC means output channels).
//      The output would be the input transposed to the following layout:
//      n,iY,bY,iX,bX,oC
//
// This operation is useful for resizing the activations between convolutions
// (but keeping all data), e.g. instead of pooling. It is also useful for training
// purely convolutional models.
//
// For example, given an input of shape `[1, 1, 1, 4]`, data_format = "NHWC" and
// block_size = 2:
//
// ```
// x = [[[[1, 2, 3, 4]]]]
//
// ```
//
// This operation will output a tensor of shape `[1, 2, 2, 1]`:
//
// ```
//    [[[[1], [2]],
//      [[3], [4]]]]
// ```
//
// Here, the input has a batch of 1 and each batch element has shape `[1, 1, 4]`,
// the corresponding output will have 2x2 elements and will have a depth of
// 1 channel (1 = `4 / (block_size * block_size)`).
// The output element shape is `[2, 2, 1]`.
//
// For an input tensor with larger depth, here of shape `[1, 1, 1, 12]`, e.g.
//
// ```
// x = [[[[1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]]]]
// ```
//
// This operation, for block size of 2, will return the following tensor of shape
// `[1, 2, 2, 3]`
//
// ```
//    [[[[1, 2, 3], [4, 5, 6]],
//      [[7, 8, 9], [10, 11, 12]]]]
//
// ```
//
// Similarly, for the following input of shape `[1 2 2 4]`, and a block size of 2:
//
// ```
// x =  [[[[1, 2, 3, 4],
//        [5, 6, 7, 8]],
//       [[9, 10, 11, 12],
//        [13, 14, 15, 16]]]]
// ```
//
// the operator will return the following tensor of shape `[1 4 4 1]`:
//
// ```
// x = [[[ [1],   [2],  [5],  [6]],
//       [ [3],   [4],  [7],  [8]],
//       [ [9],  [10], [13],  [14]],
//       [ [11], [12], [15],  [16]]]]
//
// ```
//
// Arguments:
//
//	block_size: The size of the spatial block, same as in Space2Depth.
func DepthToSpace(scope *Scope, input tf.Output, block_size int64, optional ...DepthToSpaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthToSpace",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EnterAttr is an optional argument to Enter.
type EnterAttr func(optionalAttr)

// EnterIsConstant sets the optional is_constant attribute to value.
//
// value: If true, the output is constant within the child frame.
// If not specified, defaults to false
func EnterIsConstant(value bool) EnterAttr {
	return func(m optionalAttr) {
		m["is_constant"] = value
	}
}

// EnterParallelIterations sets the optional parallel_iterations attribute to value.
//
// value: The number of iterations allowed to run in parallel.
// If not specified, defaults to 10
func EnterParallelIterations(value int64) EnterAttr {
	return func(m optionalAttr) {
		m["parallel_iterations"] = value
	}
}

// Creates or finds a child frame, and makes `data` available to the child frame.
//
// This op is used together with `Exit` to create loops in the graph.
// The unique `frame_name` is used by the `Executor` to identify frames. If
// `is_constant` is true, `output` is a constant in the child frame; otherwise
// it may be changed in the child frame. At most `parallel_iterations` iterations
// are run in parallel in the child frame.
//
// Arguments:
//	data: The tensor to be made available to the child frame.
//	frame_name: The name of the child frame.
//
// Returns The same tensor as `data`.
func Enter(scope *Scope, data tf.Output, frame_name string, optional ...EnterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"frame_name": frame_name}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Enter",
		Input: []tf.Input{
			data,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Forwards `data` to the output port determined by `pred`.
//
// If `pred` is true, the `data` input is forwarded to `output_true`. Otherwise,
// the data goes to `output_false`.
//
// See also `RefSwitch` and `Merge`.
//
// Arguments:
//	data: The tensor to be forwarded to the appropriate output.
//	pred: A scalar that specifies which output port will receive data.
//
// Returns If `pred` is false, data will be forwarded to this output.If `pred` is true, data will be forwarded to this output.
func Switch(scope *Scope, data tf.Output, pred tf.Output) (output_false tf.Output, output_true tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Switch",
		Input: []tf.Input{
			data, pred,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CTCGreedyDecoderAttr is an optional argument to CTCGreedyDecoder.
type CTCGreedyDecoderAttr func(optionalAttr)

// CTCGreedyDecoderMergeRepeated sets the optional merge_repeated attribute to value.
//
// value: If True, merge repeated classes in output.
// If not specified, defaults to false
func CTCGreedyDecoderMergeRepeated(value bool) CTCGreedyDecoderAttr {
	return func(m optionalAttr) {
		m["merge_repeated"] = value
	}
}

// Performs greedy decoding on the logits given in inputs.
//
// A note about the attribute merge_repeated: if enabled, when
// consecutive logits' maximum indices are the same, only the first of
// these is emitted.  Labeling the blank '*', the sequence "A B B * B B"
// becomes "A B B" if merge_repeated = True and "A B B B B" if
// merge_repeated = False.
//
// Regardless of the value of merge_repeated, if the maximum index of a given
// time and batch corresponds to the blank, index `(num_classes - 1)`, no new
// element is emitted.
//
// Arguments:
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	sequence_length: A vector containing sequence lengths, size `(batch_size)`.
//
// Returns Indices matrix, size `(total_decoded_outputs x 2)`,
// of a `SparseTensor<int64, 2>`.  The rows store: [batch, time].Values vector, size: `(total_decoded_outputs)`,
// of a `SparseTensor<int64, 2>`.  The vector stores the decoded classes.Shape vector, size `(2)`, of the decoded SparseTensor.
// Values are: `[batch_size, max_decoded_length]`.Matrix, size `(batch_size x 1)`, containing sequence
// log-probabilities.
func CTCGreedyDecoder(scope *Scope, inputs tf.Output, sequence_length tf.Output, optional ...CTCGreedyDecoderAttr) (decoded_indices tf.Output, decoded_values tf.Output, decoded_shape tf.Output, log_probability tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCGreedyDecoder",
		Input: []tf.Input{
			inputs, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNParamsToCanonicalAttr is an optional argument to CudnnRNNParamsToCanonical.
type CudnnRNNParamsToCanonicalAttr func(optionalAttr)

// CudnnRNNParamsToCanonicalRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsToCanonicalRnnMode(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsToCanonicalInputMode(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsToCanonicalDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsToCanonicalDirection(value string) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsToCanonicalDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalDropout(value float32) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsToCanonicalSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalSeed(value int64) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsToCanonicalSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsToCanonicalSeed2(value int64) CudnnRNNParamsToCanonicalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Retrieves CudnnRNN params in canonical form.
//
// Retrieves a set of weights from the opaque params buffer that can be saved and
// restored in a way compatible with future runs.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// num_params: number of parameter sets for all layers.
//     Each layer may contain multiple parameter sets, with each set consisting of
//     a weight matrix and a bias vector.
// weights: the canonical form of weights that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// biases: the canonical form of biases that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     The actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//     dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
func CudnnRNNParamsToCanonical(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, params tf.Output, num_params int64, optional ...CudnnRNNParamsToCanonicalAttr) (weights []tf.Output, biases []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_params": num_params}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsToCanonical",
		Input: []tf.Input{
			num_layers, num_units, input_size, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if weights, idx, err = makeOutputList(op, idx, "weights"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonical", err)
		return
	}
	if biases, idx, err = makeOutputList(op, idx, "biases"); err != nil {
		scope.UpdateErr("CudnnRNNParamsToCanonical", err)
		return
	}
	return weights, biases
}

// CudnnRNNBackpropV3Attr is an optional argument to CudnnRNNBackpropV3.
type CudnnRNNBackpropV3Attr func(optionalAttr)

// CudnnRNNBackpropV3RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropV3RnnMode(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropV3InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropV3InputMode(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropV3Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropV3Direction(value string) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropV3Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Dropout(value float32) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropV3Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Seed(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropV3Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropV3Seed2(value int64) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNBackpropV3TimeMajor sets the optional time_major attribute to value.
// If not specified, defaults to true
func CudnnRNNBackpropV3TimeMajor(value bool) CudnnRNNBackpropV3Attr {
	return func(m optionalAttr) {
		m["time_major"] = value
	}
}

// Backprop step of CudnnRNNV3.
//
// Compute the backprop of both data and weights in a RNN. Takes an extra
//     "sequence_lengths" input than CudnnRNNBackprop.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//     the actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: If time_major is true, this is a 3-D tensor with the shape of
//     [seq_length, batch_size, input_size]. If time_major is false, the shape is
//     [batch_size, seq_length, input_size].
// input_h: If time_major is true, this is a 3-D tensor with the shape of
//     [num_layer * dir, batch_size, num_units]. If time_major is false, the shape
//     is [batch_size, num_layer * dir, num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// sequence_lengths: a vector of lengths of each input sequence.
// output: If time_major is true, this is a 3-D tensor with the shape of
//     [seq_length, batch_size, dir * num_units]. If time_major is false, the
//     shape is [batch_size, seq_length, dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//     pass.
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//     pass.
// time_major: Indicates whether the input/output format is time major or batch
//     major.
// reserve_space: The same reserve_space produced in the forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//     as input.
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//     shape as input_h.
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//     shape as input_c.
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//     same shape as params.
func CudnnRNNBackpropV3(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, sequence_lengths tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, host_reserved tf.Output, optional ...CudnnRNNBackpropV3Attr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackpropV3",
		Input: []tf.Input{
			input, input_h, input_c, params, sequence_lengths, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space, host_reserved,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNV2Attr is an optional argument to CudnnRNNV2.
type CudnnRNNV2Attr func(optionalAttr)

// CudnnRNNV2RnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNV2RnnMode(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNV2InputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNV2InputMode(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNV2Direction sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNV2Direction(value string) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNV2Dropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Dropout(value float32) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNV2Seed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Seed(value int64) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNV2Seed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNV2Seed2(value int64) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNV2IsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNV2IsTraining(value bool) CudnnRNNV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer. Produces one extra output "host_reserved" than CudnnRNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicates whether there is a linear projection between the input and
//   the actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inferenece or
//   training.
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//   is only produced if is_training is true.
// host_reserved: An opaque tensor that can be used in backprop calculation. It is
//   only produced if is_training is true. It is output on host memory rather than
//   device memory.
func CudnnRNNV2(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, optional ...CudnnRNNV2Attr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output, host_reserved tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNV2",
		Input: []tf.Input{
			input, input_h, input_c, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// CudnnRNNAttr is an optional argument to CudnnRNN.
type CudnnRNNAttr func(optionalAttr)

// CudnnRNNRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNRnnMode(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNInputMode(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNDirection(value string) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNDropout(value float32) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNSeed(value int64) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNSeed2(value int64) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// CudnnRNNIsTraining sets the optional is_training attribute to value.
// If not specified, defaults to true
func CudnnRNNIsTraining(value bool) CudnnRNNAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// A RNN backed by cuDNN.
//
// Computes the RNN from the input and initial states, with respect to the params
// buffer.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//   the actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// is_training: Indicates whether this operation is used for inferenece or
//   training.
// reserve_space: An opaque tensor that can be used in backprop calculation. It
//   is only produced if is_training is false.
func CudnnRNN(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, optional ...CudnnRNNAttr) (output tf.Output, output_h tf.Output, output_c tf.Output, reserve_space tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNN",
		Input: []tf.Input{
			input, input_h, input_c, params,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// CudnnRNNParamsSizeAttr is an optional argument to CudnnRNNParamsSize.
type CudnnRNNParamsSizeAttr func(optionalAttr)

// CudnnRNNParamsSizeRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNParamsSizeRnnMode(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNParamsSizeInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNParamsSizeInputMode(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNParamsSizeDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNParamsSizeDirection(value string) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNParamsSizeDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeDropout(value float32) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNParamsSizeSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeSeed(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNParamsSizeSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNParamsSizeSeed2(value int64) CudnnRNNParamsSizeAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Computes size of weights that can be used by a Cudnn RNN model.
//
// Return the params size that can be used by the Cudnn RNN model. Subsequent
// weight allocation and initialization should use this size.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//   The actual computation before the first layer. 'skip_input' is only allowed
//   when input_size == num_units; 'auto_select' implies 'skip_input' when
//   input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//   dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
// params_size: The size of the params buffer that should be allocated and
//   initialized for this RNN model. Note that this params buffer may not be
//   compatible across GPUs. Please use CudnnRNNParamsWeights and
//   CudnnRNNParamsBiases to save and restore them in a way that is compatible
//   across different runs.
func CudnnRNNParamsSize(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, T tf.DataType, S tf.DataType, optional ...CudnnRNNParamsSizeAttr) (params_size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"T": T, "S": S}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNParamsSize",
		Input: []tf.Input{
			num_layers, num_units, input_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RecordInputAttr is an optional argument to RecordInput.
type RecordInputAttr func(optionalAttr)

// RecordInputFileRandomSeed sets the optional file_random_seed attribute to value.
//
// value: Random seeds used to produce randomized records.
// If not specified, defaults to 301
func RecordInputFileRandomSeed(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_random_seed"] = value
	}
}

// RecordInputFileShuffleShiftRatio sets the optional file_shuffle_shift_ratio attribute to value.
//
// value: Shifts the list of files after the list is randomly
// shuffled.
// If not specified, defaults to 0
func RecordInputFileShuffleShiftRatio(value float32) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_shuffle_shift_ratio"] = value
	}
}

// RecordInputFileBufferSize sets the optional file_buffer_size attribute to value.
//
// value: The randomization shuffling buffer.
// If not specified, defaults to 10000
func RecordInputFileBufferSize(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_buffer_size"] = value
	}
}

// RecordInputFileParallelism sets the optional file_parallelism attribute to value.
//
// value: How many sstables are opened and concurrently iterated over.
// If not specified, defaults to 16
func RecordInputFileParallelism(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["file_parallelism"] = value
	}
}

// RecordInputBatchSize sets the optional batch_size attribute to value.
//
// value: The batch size.
// If not specified, defaults to 32
func RecordInputBatchSize(value int64) RecordInputAttr {
	return func(m optionalAttr) {
		m["batch_size"] = value
	}
}

// RecordInputCompressionType sets the optional compression_type attribute to value.
//
// value: The type of compression for the file. Currently ZLIB and
// GZIP are supported. Defaults to none.
// If not specified, defaults to ""
func RecordInputCompressionType(value string) RecordInputAttr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// Emits randomized records.
//
// Arguments:
//	file_pattern: Glob pattern for the data files.
//
// Returns A tensor of shape [batch_size].
func RecordInput(scope *Scope, file_pattern string, optional ...RecordInputAttr) (records tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"file_pattern": file_pattern}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RecordInput",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapIncompleteSizeAttr is an optional argument to OrderedMapIncompleteSize.
type OrderedMapIncompleteSizeAttr func(optionalAttr)

// OrderedMapIncompleteSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapIncompleteSizeCapacity(value int64) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapIncompleteSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapIncompleteSizeMemoryLimit(value int64) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapIncompleteSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapIncompleteSizeContainer(value string) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapIncompleteSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapIncompleteSizeSharedName(value string) OrderedMapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of incomplete elements in the underlying container.
func OrderedMapIncompleteSize(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapIncompleteSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapIncompleteSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapSizeAttr is an optional argument to OrderedMapSize.
type OrderedMapSizeAttr func(optionalAttr)

// OrderedMapSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapSizeCapacity(value int64) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapSizeMemoryLimit(value int64) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapSizeContainer(value string) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapSizeSharedName(value string) OrderedMapSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func OrderedMapSize(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OrderedMapUnstageNoKeyAttr is an optional argument to OrderedMapUnstageNoKey.
type OrderedMapUnstageNoKeyAttr func(optionalAttr)

// OrderedMapUnstageNoKeyCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageNoKeyCapacity(value int64) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapUnstageNoKeyMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageNoKeyMemoryLimit(value int64) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapUnstageNoKeyContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageNoKeyContainer(value string) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapUnstageNoKeySharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageNoKeySharedName(value string) OrderedMapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the (key, value) element with the smallest
//
// key from the underlying container.   If the underlying container
// does not contain elements, the op will block until it does.
func OrderedMapUnstageNoKey(scope *Scope, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapUnstageNoKeyAttr) (key tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapUnstageNoKey",
		Input: []tf.Input{
			indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	key = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapUnstageNoKey", err)
		return
	}
	return key, values
}

// OrderedMapUnstageAttr is an optional argument to OrderedMapUnstage.
type OrderedMapUnstageAttr func(optionalAttr)

// OrderedMapUnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageCapacity(value int64) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapUnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapUnstageMemoryLimit(value int64) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapUnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageContainer(value string) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapUnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapUnstageSharedName(value string) OrderedMapUnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the values associated with the key
//
// from the underlying container.   If the underlying container
// does not contain this key, the op will block until it does.
func OrderedMapUnstage(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapUnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapUnstage",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapUnstage", err)
		return
	}
	return values
}

// OrderedMapPeekAttr is an optional argument to OrderedMapPeek.
type OrderedMapPeekAttr func(optionalAttr)

// OrderedMapPeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapPeekCapacity(value int64) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapPeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapPeekMemoryLimit(value int64) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapPeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapPeekContainer(value string) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapPeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapPeekSharedName(value string) OrderedMapPeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified key.  If the
//
// underlying container does not contain this key
// this op will block until it does.   This Op is optimized for
// performance.
func OrderedMapPeek(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...OrderedMapPeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapPeek",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("OrderedMapPeek", err)
		return
	}
	return values
}

// OrderedMapStageAttr is an optional argument to OrderedMapStage.
type OrderedMapStageAttr func(optionalAttr)

// OrderedMapStageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapStageCapacity(value int64) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapStageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapStageMemoryLimit(value int64) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapStageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func OrderedMapStageContainer(value string) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapStageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func OrderedMapStageSharedName(value string) OrderedMapStageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage (key, values) in the underlying container which behaves like a ordered
//
// associative container.   Elements are ordered by key.
//
// Arguments:
//	key: int64
//
//	values: a list of tensors
// dtypes A list of data types that inserted values should adhere to.
//
//
// Returns the created operation.
func OrderedMapStage(scope *Scope, key tf.Output, indices tf.Output, values []tf.Output, dtypes []tf.DataType, optional ...OrderedMapStageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapStage",
		Input: []tf.Input{
			key, indices, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MapClearAttr is an optional argument to MapClear.
type MapClearAttr func(optionalAttr)

// MapClearCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapClearCapacity(value int64) MapClearAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapClearMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapClearMemoryLimit(value int64) MapClearAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapClearContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapClearContainer(value string) MapClearAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapClearSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapClearSharedName(value string) MapClearAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes all elements in the underlying container.
//
// Returns the created operation.
func MapClear(scope *Scope, dtypes []tf.DataType, optional ...MapClearAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapClear",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MapIncompleteSizeAttr is an optional argument to MapIncompleteSize.
type MapIncompleteSizeAttr func(optionalAttr)

// MapIncompleteSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapIncompleteSizeCapacity(value int64) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapIncompleteSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapIncompleteSizeMemoryLimit(value int64) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapIncompleteSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapIncompleteSizeContainer(value string) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapIncompleteSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapIncompleteSizeSharedName(value string) MapIncompleteSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of incomplete elements in the underlying container.
func MapIncompleteSize(scope *Scope, dtypes []tf.DataType, optional ...MapIncompleteSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapIncompleteSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapUnstageAttr is an optional argument to MapUnstage.
type MapUnstageAttr func(optionalAttr)

// MapUnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageCapacity(value int64) MapUnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapUnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageMemoryLimit(value int64) MapUnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapUnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapUnstageContainer(value string) MapUnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapUnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapUnstageSharedName(value string) MapUnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns the values associated with the key
//
// from the underlying container.   If the underlying container
// does not contain this key, the op will block until it does.
func MapUnstage(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...MapUnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapUnstage",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapUnstage", err)
		return
	}
	return values
}

// MapPeekAttr is an optional argument to MapPeek.
type MapPeekAttr func(optionalAttr)

// MapPeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapPeekCapacity(value int64) MapPeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapPeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapPeekMemoryLimit(value int64) MapPeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapPeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapPeekContainer(value string) MapPeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapPeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapPeekSharedName(value string) MapPeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified key.  If the
//
// underlying container does not contain this key
// this op will block until it does.
func MapPeek(scope *Scope, key tf.Output, indices tf.Output, dtypes []tf.DataType, optional ...MapPeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapPeek",
		Input: []tf.Input{
			key, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapPeek", err)
		return
	}
	return values
}

// MapStageAttr is an optional argument to MapStage.
type MapStageAttr func(optionalAttr)

// MapStageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapStageCapacity(value int64) MapStageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapStageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapStageMemoryLimit(value int64) MapStageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapStageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func MapStageContainer(value string) MapStageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapStageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func MapStageSharedName(value string) MapStageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage (key, values) in the underlying container which behaves like a hashtable.
//
// Arguments:
//	key: int64
//
//	values: a list of tensors
// dtypes A list of data types that inserted values should adhere to.
//
//
// Returns the created operation.
func MapStage(scope *Scope, key tf.Output, indices tf.Output, values []tf.Output, dtypes []tf.DataType, optional ...MapStageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapStage",
		Input: []tf.Input{
			key, indices, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Concatenates quantized tensors along one dimension.
//
// Arguments:
//	concat_dim: 0-D.  The dimension along which to concatenate.  Must be in the
// range [0, rank(values)).
//	values: The `N` Tensors to concatenate. Their ranks and types must match,
// and their sizes must match in all dimensions except `concat_dim`.
//	input_mins: The minimum scalar values for each of the input tensors.
//	input_maxes: The maximum scalar values for each of the input tensors.
//
// Returns A `Tensor` with the concatenation of values stacked along the
// `concat_dim` dimension.  This tensor's shape matches that of `values` except
// in `concat_dim` where it has the sum of the sizes.The float value that the minimum quantized output value represents.The float value that the maximum quantized output value represents.
func QuantizedConcat(scope *Scope, concat_dim tf.Output, values []tf.Output, input_mins []tf.Output, input_maxes []tf.Output) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "QuantizedConcat",
		Input: []tf.Input{
			concat_dim, tf.OutputList(values), tf.OutputList(input_mins), tf.OutputList(input_maxes),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// StagePeekAttr is an optional argument to StagePeek.
type StagePeekAttr func(optionalAttr)

// StagePeekCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StagePeekCapacity(value int64) StagePeekAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StagePeekMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StagePeekMemoryLimit(value int64) StagePeekAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StagePeekContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StagePeekContainer(value string) StagePeekAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StagePeekSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StagePeekSharedName(value string) StagePeekAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op peeks at the values at the specified index.  If the
//
// underlying container does not contain sufficient elements
// this op will block until it does.   This Op is optimized for
// performance.
func StagePeek(scope *Scope, index tf.Output, dtypes []tf.DataType, optional ...StagePeekAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StagePeek",
		Input: []tf.Input{
			index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("StagePeek", err)
		return
	}
	return values
}

// Store the input tensor in the state of the current session.
//
// Arguments:
//	value: The tensor to be stored.
//
// Returns The handle for the tensor stored in the session state, represented
// as a ResourceHandle object.
func GetSessionHandleV2(scope *Scope, value tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetSessionHandleV2",
		Input: []tf.Input{
			value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Store the input tensor in the state of the current session.
//
// Arguments:
//	value: The tensor to be stored.
//
// Returns The handle for the tensor stored in the session state, represented
// as a string.
func GetSessionHandle(scope *Scope, value tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "GetSessionHandle",
		Input: []tf.Input{
			value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// GatherAttr is an optional argument to Gather.
type GatherAttr func(optionalAttr)

// GatherValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func GatherValidateIndices(value bool) GatherAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Gather slices from `params` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
//
// ```python
//     # Scalar indices
//     output[:, ..., :] = params[indices, :, ... :]
//
//     # Vector indices
//     output[i, :, ..., :] = params[indices[i], :, ... :]
//
//     # Higher rank indices
//     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
// ```
//
// If `indices` is a permutation and `len(indices) == params.shape[0]` then
// this operation will permute `params` accordingly.
//
// `validate_indices`: DEPRECATED. If this operation is assigned to CPU, values in
// `indices` are always validated to be within range. If assigned to GPU,
// out-of-bound indices result in safe but unspecified behavior, which may include
// raising an error.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
// </div>
func Gather(scope *Scope, params tf.Output, indices tf.Output, optional ...GatherAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Gather",
		Input: []tf.Input{
			params, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArraySplitV3
//
// DEPRECATED at GraphDef version 26: Use TensorArraySplitV3
func TensorArraySplitV2(scope *Scope, handle tf.Output, value tf.Output, lengths tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySplitV2",
		Input: []tf.Input{
			handle, value, lengths, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayScatterV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayScatterV3
func TensorArrayScatterV2(scope *Scope, handle tf.Output, indices tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayScatterV2",
		Input: []tf.Input{
			handle, indices, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArraySizeV3
//
// DEPRECATED at GraphDef version 26: Use TensorArraySizeV3
func TensorArraySizeV2(scope *Scope, handle tf.Output, flow_in tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySizeV2",
		Input: []tf.Input{
			handle, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorArrayGatherV2Attr is an optional argument to TensorArrayGatherV2.
type TensorArrayGatherV2Attr func(optionalAttr)

// TensorArrayGatherV2ElementShape sets the optional element_shape attribute to value.
// If not specified, defaults to <unknown_rank:true >
func TensorArrayGatherV2ElementShape(value tf.Shape) TensorArrayGatherV2Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// Deprecated. Use TensorArrayGatherV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayGatherV3
func TensorArrayGatherV2(scope *Scope, handle tf.Output, indices tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayGatherV2Attr) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayGatherV2",
		Input: []tf.Input{
			handle, indices, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Concatenates a list of `N` tensors along the first dimension.
//
// The input tensors are all required to have size 1 in the first dimension.
//
// For example:
//
// ```
// # 'x' is [[1, 4]]
// # 'y' is [[2, 5]]
// # 'z' is [[3, 6]]
// parallel_concat([x, y, z]) => [[1, 4], [2, 5], [3, 6]]  # Pack along first dim.
// ```
//
// The difference between concat and parallel_concat is that concat requires all
// of the inputs be computed before the operation will begin but doesn't require
// that the input shapes be known during graph construction.  Parallel concat
// will copy pieces of the input into the output as they become available, in
// some situations this can provide a performance benefit.
//
// Arguments:
//	values: Tensors to be concatenated. All must have size 1 in the first dimension
// and same shape.
//	shape: the final shape of the result; should be equal to the shapes of any input
// but with the number of input values in the first dimension.
//
// Returns The concatenated tensor.
func ParallelConcat(scope *Scope, values []tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "ParallelConcat",
		Input: []tf.Input{
			tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorArrayV2Attr is an optional argument to TensorArrayV2.
type TensorArrayV2Attr func(optionalAttr)

// TensorArrayV2ElementShape sets the optional element_shape attribute to value.
// If not specified, defaults to <unknown_rank:true >
func TensorArrayV2ElementShape(value tf.Shape) TensorArrayV2Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// TensorArrayV2DynamicSize sets the optional dynamic_size attribute to value.
// If not specified, defaults to false
func TensorArrayV2DynamicSize(value bool) TensorArrayV2Attr {
	return func(m optionalAttr) {
		m["dynamic_size"] = value
	}
}

// TensorArrayV2ClearAfterRead sets the optional clear_after_read attribute to value.
// If not specified, defaults to true
func TensorArrayV2ClearAfterRead(value bool) TensorArrayV2Attr {
	return func(m optionalAttr) {
		m["clear_after_read"] = value
	}
}

// TensorArrayV2TensorArrayName sets the optional tensor_array_name attribute to value.
// If not specified, defaults to ""
func TensorArrayV2TensorArrayName(value string) TensorArrayV2Attr {
	return func(m optionalAttr) {
		m["tensor_array_name"] = value
	}
}

// Deprecated. Use TensorArrayV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayV3
func TensorArrayV2(scope *Scope, size tf.Output, dtype tf.DataType, optional ...TensorArrayV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayV2",
		Input: []tf.Input{
			size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Delete the TensorArray from its resource container.
//
// This enables the user to close and release the resource in the middle
// of a step/run.
//
// Arguments:
//	handle: The handle to a TensorArray (output of TensorArray or TensorArrayGrad).
//
// Returns the created operation.
func TensorArrayCloseV3(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayCloseV3",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Get the current size of the TensorArray.
//
// Arguments:
//	handle: The handle to a TensorArray (output of TensorArray or TensorArrayGrad).
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns The current size of the TensorArray.
func TensorArraySizeV3(scope *Scope, handle tf.Output, flow_in tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySizeV3",
		Input: []tf.Input{
			handle, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Split the data from the input value into TensorArray elements.
//
// Assuming that `lengths` takes on values
//
//   ```(n0, n1, ..., n(T-1))```
//
// and that `value` has shape
//
//   ```(n0 + n1 + ... + n(T-1) x d0 x d1 x ...)```,
//
// this splits values into a TensorArray with T tensors.
//
// TensorArray index t will be the subtensor of values with starting position
//
//   ```(n0 + n1 + ... + n(t-1), 0, 0, ...)```
//
// and having size
//
//   ```nt x d0 x d1 x ...```
//
// Arguments:
//	handle: The handle to a TensorArray.
//	value: The concatenated tensor to write to the TensorArray.
//	lengths: The vector of lengths, how to split the rows of value into the
// TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns A float scalar that enforces proper chaining of operations.
func TensorArraySplitV3(scope *Scope, handle tf.Output, value tf.Output, lengths tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArraySplitV3",
		Input: []tf.Input{
			handle, value, lengths, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Scatter the data from the input value into specific TensorArray elements.
//
// `indices` must be a vector, its length must match the first dim of `value`.
//
// Arguments:
//	handle: The handle to a TensorArray.
//	indices: The locations at which to write the tensor elements.
//	value: The concatenated tensor to write to the TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns A float scalar that enforces proper chaining of operations.
func TensorArrayScatterV3(scope *Scope, handle tf.Output, indices tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayScatterV3",
		Input: []tf.Input{
			handle, indices, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Read an element from the TensorArray into output `value`.
//
// Arguments:
//	handle: The handle to a TensorArray.
//
//	flow_in: A float scalar that enforces proper chaining of operations.
//	dtype: The type of the elem that is returned.
//
// Returns The tensor that is read from the TensorArray.
func TensorArrayReadV3(scope *Scope, handle tf.Output, index tf.Output, flow_in tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "TensorArrayReadV3",
		Input: []tf.Input{
			handle, index, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Push an element onto the tensor_array.
//
// Arguments:
//	handle: The handle to a TensorArray.
//	index: The position to write to inside the TensorArray.
//	value: The tensor to write to the TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//
// Returns A float scalar that enforces proper chaining of operations.
func TensorArrayWriteV3(scope *Scope, handle tf.Output, index tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayWriteV3",
		Input: []tf.Input{
			handle, index, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a TensorArray for storing multiple gradients of values in the given handle.
//
// Similar to TensorArrayGradV3. However it creates an accumulator with an
// expanded shape compared to the input TensorArray whose gradient is being
// computed. This enables multiple gradients for the same TensorArray to be
// calculated using the same accumulator.
//
// Arguments:
//	handle: The handle to the forward TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	shape_to_prepend: An int32 vector representing a shape. Elements in the gradient accumulator will
// have shape which is this shape_to_prepend value concatenated with shape of the
// elements in the TensorArray corresponding to the input handle.
//	source: The gradient source string, used to decide which gradient TensorArray
// to return.
func TensorArrayGradWithShape(scope *Scope, handle tf.Output, flow_in tf.Output, shape_to_prepend tf.Output, source string) (grad_handle tf.Output, flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradWithShape",
		Input: []tf.Input{
			handle, flow_in, shape_to_prepend,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Creates a TensorArray for storing the gradients of values in the given handle.
//
// If the given TensorArray gradient already exists, returns a reference to it.
//
// Locks the size of the original TensorArray by disabling its dynamic size flag.
//
// **A note about the input flow_in:**
//
// The handle flow_in forces the execution of the gradient lookup to occur
// only after certain other operations have occurred.  For example, when
// the forward TensorArray is dynamically sized, writes to this TensorArray
// may resize the object.  The gradient TensorArray is statically sized based
// on the size of the forward TensorArray when this operation executes.
// Furthermore, the size of the forward TensorArray is frozen by this call.
// As a result, the flow is used to ensure that the call to generate the gradient
// TensorArray only happens after all writes are executed.
//
// In the case of dynamically sized TensorArrays, gradient computation should
// only be performed on read operations that have themselves been chained via
// flow to occur only after all writes have executed. That way the final size
// of the forward TensorArray is known when this operation is called.
//
// **A note about the source attribute:**
//
// TensorArray gradient calls use an accumulator TensorArray object.  If
// multiple gradients are calculated and run in the same session, the multiple
// gradient nodes may accidentally flow through the same accumulator TensorArray.
// This double counts and generally breaks the TensorArray gradient flow.
//
// The solution is to identify which gradient call this particular
// TensorArray gradient is being called in.  This is performed by identifying
// a unique string (e.g. "gradients", "gradients_1", ...) from the input
// gradient Tensor's name.  This string is used as a suffix when creating
// the TensorArray gradient object here (the attribute `source`).
//
// The attribute `source` is added as a suffix to the forward TensorArray's
// name when performing the creation / lookup, so that each separate gradient
// calculation gets its own TensorArray accumulator.
//
// Arguments:
//	handle: The handle to the forward TensorArray.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	source: The gradient source string, used to decide which gradient TensorArray
// to return.
func TensorArrayGradV3(scope *Scope, handle tf.Output, flow_in tf.Output, source string) (grad_handle tf.Output, flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradV3",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// TensorArrayV3Attr is an optional argument to TensorArrayV3.
type TensorArrayV3Attr func(optionalAttr)

// TensorArrayV3ElementShape sets the optional element_shape attribute to value.
//
// value: The expected shape of an element, if known. Used to
// validate the shapes of TensorArray elements. If this shape is not
// fully specified, gathering zero-size TensorArrays is an error.
// If not specified, defaults to <unknown_rank:true >
func TensorArrayV3ElementShape(value tf.Shape) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// TensorArrayV3DynamicSize sets the optional dynamic_size attribute to value.
//
// value: A boolean that determines whether writes to the TensorArray
// are allowed to grow the size.  By default, this is not allowed.
// If not specified, defaults to false
func TensorArrayV3DynamicSize(value bool) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["dynamic_size"] = value
	}
}

// TensorArrayV3ClearAfterRead sets the optional clear_after_read attribute to value.
//
// value: If true (default), Tensors in the TensorArray are cleared
// after being read.  This disables multiple read semantics but allows early
// release of memory.
// If not specified, defaults to true
func TensorArrayV3ClearAfterRead(value bool) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["clear_after_read"] = value
	}
}

// TensorArrayV3IdenticalElementShapes sets the optional identical_element_shapes attribute to value.
//
// value: If true (default is false), then all
// elements in the TensorArray will be expected to have have identical shapes.
// This allows certain behaviors, like dynamically checking for
// consistent shapes on write, and being able to fill in properly
// shaped zero tensors on stack -- even if the element_shape attribute
// is not fully defined.
// If not specified, defaults to false
func TensorArrayV3IdenticalElementShapes(value bool) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["identical_element_shapes"] = value
	}
}

// TensorArrayV3TensorArrayName sets the optional tensor_array_name attribute to value.
//
// value: Overrides the name used for the temporary tensor_array
// resource. Default value is the name of the 'TensorArray' op (which
// is guaranteed unique).
// If not specified, defaults to ""
func TensorArrayV3TensorArrayName(value string) TensorArrayV3Attr {
	return func(m optionalAttr) {
		m["tensor_array_name"] = value
	}
}

// An array of Tensors of given size.
//
// Write data via Write and read via Read or Pack.
//
// Arguments:
//	size: The size of the array.
//	dtype: The type of the elements on the tensor_array.
//
// Returns The handle to the TensorArray.A scalar used to control gradient flow.
func TensorArrayV3(scope *Scope, size tf.Output, dtype tf.DataType, optional ...TensorArrayV3Attr) (handle tf.Output, flow tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayV3",
		Input: []tf.Input{
			size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Delete the stack from its resource container.
//
// Arguments:
//	handle: The handle to a stack.
//
// Returns the created operation.
func StackCloseV2(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StackCloseV2",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Pop the element at the top of the stack.
//
// Arguments:
//	handle: The handle to a stack.
//	elem_type: The type of the elem that is popped.
//
// Returns The tensor that is popped from the top of the stack.
func StackPopV2(scope *Scope, handle tf.Output, elem_type tf.DataType) (elem tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"elem_type": elem_type}
	opspec := tf.OpSpec{
		Type: "StackPopV2",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StackV2Attr is an optional argument to StackV2.
type StackV2Attr func(optionalAttr)

// StackV2StackName sets the optional stack_name attribute to value.
//
// value: Overrides the name used for the temporary stack resource. Default
// value is the name of the 'Stack' op (which is guaranteed unique).
// If not specified, defaults to ""
func StackV2StackName(value string) StackV2Attr {
	return func(m optionalAttr) {
		m["stack_name"] = value
	}
}

// A stack that produces elements in first-in last-out order.
//
// Arguments:
//	max_size: The maximum size of the stack if non-negative. If negative, the stack
// size is unlimited.
//	elem_type: The type of the elements on the stack.
//
// Returns The handle to the stack.
func StackV2(scope *Scope, max_size tf.Output, elem_type tf.DataType, optional ...StackV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"elem_type": elem_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StackV2",
		Input: []tf.Input{
			max_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxVarsAttr is an optional argument to FakeQuantWithMinMaxVars.
type FakeQuantWithMinMaxVarsAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsNumBits(value int64) FakeQuantWithMinMaxVarsAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsNarrowRange(value bool) FakeQuantWithMinMaxVarsAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor of type float via global float scalars `min`
//
// and `max` to 'outputs' tensor of same shape as `inputs`.
//
// `[min; max]` define the clamping range for the `inputs` data.
// `inputs` values are quantized into the quantization range (`[0; 2^num_bits - 1]`
// when `narrow_range` is false and `[1; 2^num_bits - 1]` when it is true) and
// then de-quantized and output as floats in `[min; max]` interval.
// `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
// If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// This operation has a gradient and thus allows for training `min` and `max`
// values.
func FakeQuantWithMinMaxVars(scope *Scope, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVars",
		Input: []tf.Input{
			inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the number of elements in the given queue.
//
// Arguments:
//	handle: The handle to a queue.
//
// Returns The number of elements in the given queue.
func QueueSizeV2(scope *Scope, handle tf.Output) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "QueueSizeV2",
		Input: []tf.Input{
			handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns true if queue is closed.
//
// This operation returns true if the queue is closed and false if the queue
// is open.
//
// Arguments:
//	handle: The handle to a queue.
func QueueIsClosedV2(scope *Scope, handle tf.Output) (is_closed tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "QueueIsClosedV2",
		Input: []tf.Input{
			handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds sparse `updates` to an existing tensor according to `indices`.
//
// This operation creates a new tensor by adding sparse `updates` to the passed
// in `tensor`.
// This operation is very similar to `tf.scatter_nd_add`, except that the updates
// are added onto an existing tensor (as opposed to a variable). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `shape`.  The last dimension of `indices` can be at most the rank of `shape`:
//
//     indices.shape[-1] <= shape.rank
//
// The last dimension of `indices` corresponds to indices into elements
// (if `indices.shape[-1] = shape.rank`) or slices
// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
// `shape`.  `updates` is a tensor with shape
//
//     indices.shape[:-1] + shape[indices.shape[-1]:]
//
// The simplest form of tensor_scatter_add is to add individual elements to a
// tensor by index. For example, say we want to add 4 elements in a rank-1
// tensor with 8 elements.
//
// In Python, this scatter add operation would look like this:
//
// ```python
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     tensor = tf.ones([8], dtype=tf.int32)
//     updated = tf.tensor_scatter_add(tensor, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(scatter))
// ```
//
// The resulting tensor would look like this:
//
//     [1, 12, 1, 11, 10, 1, 1, 13]
//
// We can also, insert entire slices of a higher rank tensor all at once. For
// example, if we wanted to insert two slices in the first dimension of a
// rank-3 tensor with two matrices of new values.
//
// In Python, this scatter add operation would look like this:
//
// ```python
//     indices = tf.constant([[0], [2]])
//     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]],
//                            [[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]]])
//     tensor = tf.ones([4, 4, 4])
//     updated = tf.tensor_scatter_add(tensor, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(scatter))
// ```
//
// The resulting tensor would look like this:
//
//     [[[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
//      [[6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8], [9, 9, 9, 9]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, the index is ignored.
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor copied from tensor and updates added according to the indices.
func TensorScatterAdd(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterAdd",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QueueCloseV2Attr is an optional argument to QueueCloseV2.
type QueueCloseV2Attr func(optionalAttr)

// QueueCloseV2CancelPendingEnqueues sets the optional cancel_pending_enqueues attribute to value.
//
// value: If true, all pending enqueue requests that are
// blocked on the given queue will be canceled.
// If not specified, defaults to false
func QueueCloseV2CancelPendingEnqueues(value bool) QueueCloseV2Attr {
	return func(m optionalAttr) {
		m["cancel_pending_enqueues"] = value
	}
}

// Closes the given queue.
//
// This operation signals that no more elements will be enqueued in the
// given queue. Subsequent Enqueue(Many) operations will fail.
// Subsequent Dequeue(Many) operations will continue to succeed if
// sufficient elements remain in the queue. Subsequent Dequeue(Many)
// operations that would block will fail immediately.
//
// Arguments:
//	handle: The handle to a queue.
//
// Returns the created operation.
func QueueCloseV2(scope *Scope, handle tf.Output, optional ...QueueCloseV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueCloseV2",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// QueueDequeueUpToV2Attr is an optional argument to QueueDequeueUpToV2.
type QueueDequeueUpToV2Attr func(optionalAttr)

// QueueDequeueUpToV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue has fewer than n elements, this operation
// will block for up to timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueDequeueUpToV2TimeoutMs(value int64) QueueDequeueUpToV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Dequeues `n` tuples of one or more tensors from the given queue.
//
// This operation is not supported by all queues.  If a queue does not support
// DequeueUpTo, then an Unimplemented error is returned.
//
// If the queue is closed and there are more than 0 but less than `n`
// elements remaining, then instead of returning an OutOfRange error like
// QueueDequeueMany, less than `n` elements are returned immediately.  If
// the queue is closed and there are 0 elements left in the queue, then
// an OutOfRange error is returned just like in QueueDequeueMany.
// Otherwise the behavior is identical to QueueDequeueMany:
//
// This operation concatenates queue-element component tensors along the
// 0th dimension to make a single component tensor.  All of the components
// in the dequeued tuple will have size n in the 0th dimension.
//
// This operation has `k` outputs, where `k` is the number of components in
// the tuples stored in the given queue, and output `i` is the ith
// component of the dequeued tuple.
//
// Arguments:
//	handle: The handle to a queue.
//	n: The number of tuples to dequeue.
//	component_types: The type of each component in a tuple.
//
// Returns One or more tensors that were dequeued as a tuple.
func QueueDequeueUpToV2(scope *Scope, handle tf.Output, n tf.Output, component_types []tf.DataType, optional ...QueueDequeueUpToV2Attr) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueDequeueUpToV2",
		Input: []tf.Input{
			handle, n,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("QueueDequeueUpToV2", err)
		return
	}
	return components
}

// QueueDequeueManyV2Attr is an optional argument to QueueDequeueManyV2.
type QueueDequeueManyV2Attr func(optionalAttr)

// QueueDequeueManyV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue has fewer than n elements, this operation
// will block for up to timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueDequeueManyV2TimeoutMs(value int64) QueueDequeueManyV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Dequeues `n` tuples of one or more tensors from the given queue.
//
// If the queue is closed and there are fewer than `n` elements, then an
// OutOfRange error is returned.
//
// This operation concatenates queue-element component tensors along the
// 0th dimension to make a single component tensor.  All of the components
// in the dequeued tuple will have size `n` in the 0th dimension.
//
// This operation has `k` outputs, where `k` is the number of components in
// the tuples stored in the given queue, and output `i` is the ith
// component of the dequeued tuple.
//
// N.B. If the queue is empty, this operation will block until `n` elements
// have been dequeued (or 'timeout_ms' elapses, if specified).
//
// Arguments:
//	handle: The handle to a queue.
//	n: The number of tuples to dequeue.
//	component_types: The type of each component in a tuple.
//
// Returns One or more tensors that were dequeued as a tuple.
func QueueDequeueManyV2(scope *Scope, handle tf.Output, n tf.Output, component_types []tf.DataType, optional ...QueueDequeueManyV2Attr) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueDequeueManyV2",
		Input: []tf.Input{
			handle, n,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("QueueDequeueManyV2", err)
		return
	}
	return components
}

// QueueEnqueueV2Attr is an optional argument to QueueEnqueueV2.
type QueueEnqueueV2Attr func(optionalAttr)

// QueueEnqueueV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue is full, this operation will block for up to
// timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueEnqueueV2TimeoutMs(value int64) QueueEnqueueV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Enqueues a tuple of one or more tensors in the given queue.
//
// The components input has k elements, which correspond to the components of
// tuples stored in the given queue.
//
// N.B. If the queue is full, this operation will block until the given
// element has been enqueued (or 'timeout_ms' elapses, if specified).
//
// Arguments:
//	handle: The handle to a queue.
//	components: One or more tensors from which the enqueued tensors should be taken.
//
// Returns the created operation.
func QueueEnqueueV2(scope *Scope, handle tf.Output, components []tf.Output, optional ...QueueEnqueueV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueEnqueueV2",
		Input: []tf.Input{
			handle, tf.OutputList(components),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// PaddingFIFOQueueV2Attr is an optional argument to PaddingFIFOQueueV2.
type PaddingFIFOQueueV2Attr func(optionalAttr)

// PaddingFIFOQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types.
// Shapes of fixed rank but variable size are allowed by setting
// any shape dimension to -1.  In this case, the inputs' shape may vary along
// the given dimension, and DequeueMany will pad the given dimension with
// zeros up to the maximum shape of all elements in the given batch.
// If the length of this attr is 0, different queue elements may have
// different ranks and shapes, but only one element may be dequeued at a time.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func PaddingFIFOQueueV2Shapes(value []tf.Shape) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// PaddingFIFOQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func PaddingFIFOQueueV2Capacity(value int64) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// PaddingFIFOQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func PaddingFIFOQueueV2Container(value string) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// PaddingFIFOQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func PaddingFIFOQueueV2SharedName(value string) PaddingFIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that produces elements in first-in first-out order.
//
// Variable-size shapes are allowed by setting the corresponding shape dimensions
// to 0 in the shape attr.  In this case DequeueMany will pad up to the maximum
// size of any given element in the minibatch.  See below for details.
//
// Arguments:
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func PaddingFIFOQueueV2(scope *Scope, component_types []tf.DataType, optional ...PaddingFIFOQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddingFIFOQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomShuffleQueueV2Attr is an optional argument to RandomShuffleQueueV2.
type RandomShuffleQueueV2Attr func(optionalAttr)

// RandomShuffleQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types. If the length of
// this attr is 0, the shapes of queue elements are not constrained, and
// only one element may be dequeued at a time.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func RandomShuffleQueueV2Shapes(value []tf.Shape) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// RandomShuffleQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func RandomShuffleQueueV2Capacity(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// RandomShuffleQueueV2MinAfterDequeue sets the optional min_after_dequeue attribute to value.
//
// value: Dequeue will block unless there would be this
// many elements after the dequeue or the queue is closed. This
// ensures a minimum level of mixing of elements.
// If not specified, defaults to 0
func RandomShuffleQueueV2MinAfterDequeue(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["min_after_dequeue"] = value
	}
}

// RandomShuffleQueueV2Seed sets the optional seed attribute to value.
//
// value: If either seed or seed2 is set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, a random seed is used.
// If not specified, defaults to 0
func RandomShuffleQueueV2Seed(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomShuffleQueueV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomShuffleQueueV2Seed2(value int64) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// RandomShuffleQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func RandomShuffleQueueV2Container(value string) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// RandomShuffleQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func RandomShuffleQueueV2SharedName(value string) RandomShuffleQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that randomizes the order of elements.
//
// Arguments:
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func RandomShuffleQueueV2(scope *Scope, component_types []tf.DataType, optional ...RandomShuffleQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomShuffleQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Interleave the values from the `data` tensors into a single tensor.
//
// Builds a merged tensor such that
//
// ```python
//     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
// ```
//
// For example, if each `indices[m]` is scalar or vector, we have
//
// ```python
//     # Scalar indices:
//     merged[indices[m], ...] = data[m][...]
//
//     # Vector indices:
//     merged[indices[m][i], ...] = data[m][i, ...]
// ```
//
// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
// `constant`, the output shape is
//
//     merged.shape = [max(indices)] + constant
//
// Values may be merged in parallel, so if an index appears in both `indices[m][i]`
// and `indices[n][j]`, the result may be invalid. This differs from the normal
// DynamicStitch operator that defines the behavior in that case.
//
// For example:
//
// ```python
//     indices[0] = 6
//     indices[1] = [4, 1]
//     indices[2] = [[5, 2], [0, 3]]
//     data[0] = [61, 62]
//     data[1] = [[41, 42], [11, 12]]
//     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
//     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
//               [51, 52], [61, 62]]
// ```
//
// This method can be used to merge partitions created by `dynamic_partition`
// as illustrated on the following example:
//
// ```python
//     # Apply function (increments x_i) on elements for which a certain condition
//     # apply (x_i != -1 in this example).
//     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
//     condition_mask=tf.not_equal(x,tf.constant(-1.))
//     partitioned_data = tf.dynamic_partition(
//         x, tf.cast(condition_mask, tf.int32) , 2)
//     partitioned_data[1] = partitioned_data[1] + 1.0
//     condition_indices = tf.dynamic_partition(
//         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
//     x = tf.dynamic_stitch(condition_indices, partitioned_data)
//     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
//     # unchanged.
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
// </div>
func ParallelDynamicStitch(scope *Scope, indices []tf.Output, data []tf.Output) (merged tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ParallelDynamicStitch",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(data),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Interleave the values from the `data` tensors into a single tensor.
//
// Builds a merged tensor such that
//
// ```python
//     merged[indices[m][i, ..., j], ...] = data[m][i, ..., j, ...]
// ```
//
// For example, if each `indices[m]` is scalar or vector, we have
//
// ```python
//     # Scalar indices:
//     merged[indices[m], ...] = data[m][...]
//
//     # Vector indices:
//     merged[indices[m][i], ...] = data[m][i, ...]
// ```
//
// Each `data[i].shape` must start with the corresponding `indices[i].shape`,
// and the rest of `data[i].shape` must be constant w.r.t. `i`.  That is, we
// must have `data[i].shape = indices[i].shape + constant`.  In terms of this
// `constant`, the output shape is
//
//     merged.shape = [max(indices)] + constant
//
// Values are merged in order, so if an index appears in both `indices[m][i]` and
// `indices[n][j]` for `(m,i) < (n,j)` the slice `data[n][j]` will appear in the
// merged result. If you do not need this guarantee, ParallelDynamicStitch might
// perform better on some devices.
//
// For example:
//
// ```python
//     indices[0] = 6
//     indices[1] = [4, 1]
//     indices[2] = [[5, 2], [0, 3]]
//     data[0] = [61, 62]
//     data[1] = [[41, 42], [11, 12]]
//     data[2] = [[[51, 52], [21, 22]], [[1, 2], [31, 32]]]
//     merged = [[1, 2], [11, 12], [21, 22], [31, 32], [41, 42],
//               [51, 52], [61, 62]]
// ```
//
// This method can be used to merge partitions created by `dynamic_partition`
// as illustrated on the following example:
//
// ```python
//     # Apply function (increments x_i) on elements for which a certain condition
//     # apply (x_i != -1 in this example).
//     x=tf.constant([0.1, -1., 5.2, 4.3, -1., 7.4])
//     condition_mask=tf.not_equal(x,tf.constant(-1.))
//     partitioned_data = tf.dynamic_partition(
//         x, tf.cast(condition_mask, tf.int32) , 2)
//     partitioned_data[1] = partitioned_data[1] + 1.0
//     condition_indices = tf.dynamic_partition(
//         tf.range(tf.shape(x)[0]), tf.cast(condition_mask, tf.int32) , 2)
//     x = tf.dynamic_stitch(condition_indices, partitioned_data)
//     # Here x=[1.1, -1., 6.2, 5.3, -1, 8.4], the -1. values remain
//     # unchanged.
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicStitch.png" alt>
// </div>
func DynamicStitch(scope *Scope, indices []tf.Output, data []tf.Output) (merged tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DynamicStitch",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(data),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Partitions `data` into `num_partitions` tensors using indices from `partitions`.
//
// For each index tuple `js` of size `partitions.ndim`, the slice `data[js, ...]`
// becomes part of `outputs[partitions[js]]`.  The slices with `partitions[js] = i`
// are placed in `outputs[i]` in lexicographic order of `js`, and the first
// dimension of `outputs[i]` is the number of entries in `partitions` equal to `i`.
// In detail,
//
// ```python
//     outputs[i].shape = [sum(partitions == i)] + data.shape[partitions.ndim:]
//
//     outputs[i] = pack([data[js, ...] for js if partitions[js] == i])
// ```
//
// `data.shape` must start with `partitions.shape`.
//
// For example:
//
// ```python
//     # Scalar partitions.
//     partitions = 1
//     num_partitions = 2
//     data = [10, 20]
//     outputs[0] = []  # Empty with shape [0, 2]
//     outputs[1] = [[10, 20]]
//
//     # Vector partitions.
//     partitions = [0, 0, 1, 1, 0]
//     num_partitions = 2
//     data = [10, 20, 30, 40, 50]
//     outputs[0] = [10, 20, 50]
//     outputs[1] = [30, 40]
// ```
//
// See `dynamic_stitch` for an example on how to merge partitions back.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/DynamicPartition.png" alt>
// </div>
//
// Arguments:
//
//	partitions: Any shape.  Indices in the range `[0, num_partitions)`.
//	num_partitions: The number of partitions to output.
func DynamicPartition(scope *Scope, data tf.Output, partitions tf.Output, num_partitions int64) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_partitions": num_partitions}
	opspec := tf.OpSpec{
		Type: "DynamicPartition",
		Input: []tf.Input{
			data, partitions,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("DynamicPartition", err)
		return
	}
	return outputs
}

// Produces a string handle for the given MultiDeviceIterator.
//
// Arguments:
//	multi_device_iterator: A MultiDeviceIterator resource.
//
// Returns A string representing the resource.
func MultiDeviceIteratorToStringHandle(scope *Scope, multi_device_iterator tf.Output) (string_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorToStringHandle",
		Input: []tf.Input{
			multi_device_iterator,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a MultiDeviceIterator resource.
//
// Arguments:
//	devices: A list of devices the iterator works across.
//	shared_name: If non-empty, this resource will be shared under the given name
// across multiple sessions.
//	container: If non-empty, this resource is placed in the given container.
// Otherwise, a default container is used.
//	output_types: The type list for the return values.
//	output_shapes: The list of shapes being produced.
//
// Returns Handle to the resource created.
func MultiDeviceIterator(scope *Scope, devices []string, shared_name string, container string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"devices": devices, "shared_name": shared_name, "container": container, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Constructs an Optional variant from a tuple of tensors.
func OptionalFromValue(scope *Scope, components []tf.Output) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalFromValue",
		Input: []tf.Input{
			tf.OutputList(components),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts the given `resource_handle` representing an iterator to a variant tensor.
//
// Arguments:
//	resource_handle: A handle to an iterator resource.
//
// Returns A variant tensor storing the state of the iterator contained in the
// resource.
func SerializeIterator(scope *Scope, resource_handle tf.Output) (serialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SerializeIterator",
		Input: []tf.Input{
			resource_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator.
//
// This operation is a synchronous version IteratorGetNext. It should only be used
// in situations where the iterator does not block the calling thread, or where
// the calling thread is not a member of the thread pool used to execute parallel
// operations (e.g. in eager mode).
func IteratorGetNextSync(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextSync",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNextSync", err)
		return
	}
	return components
}

// A container for an iterator resource.
//
// Arguments:
//	handle: A handle to the iterator to delete.
//	deleter: A variant deleter.
//
// Returns the created operation.
func DeleteIterator(scope *Scope, handle tf.Output, deleter tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeleteIterator",
		Input: []tf.Input{
			handle, deleter,
		},
	}
	return scope.AddOperation(opspec)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.A variant deleter that should be passed into the op that deletes the iterator.
func AnonymousIteratorV2(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output, deleter tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIteratorV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator"
// or "IteratorGetNext" op.
func Iterator(scope *Scope, shared_name string, container string, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shared_name": shared_name, "container": container, "output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "Iterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes offsets of concat inputs within its output.
//
// For example:
//
// ```
// # 'x' is [2, 2, 7]
// # 'y' is [2, 3, 7]
// # 'z' is [2, 5, 7]
// concat_offset(2, [x, y, z]) => [0, 0, 0], [0, 2, 0], [0, 5, 0]
// ```
//
// This is typically used by gradient computations for a concat operation.
//
// Arguments:
//	concat_dim: The dimension along which to concatenate.
//	shape: The `N` int32 vectors representing shape of tensors being concatenated.
//
// Returns The `N` int32 vectors representing the starting offset
// of input tensors within the concatenated output.
func ConcatOffset(scope *Scope, concat_dim tf.Output, shape []tf.Output) (offset []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConcatOffset",
		Input: []tf.Input{
			concat_dim, tf.OutputList(shape),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if offset, idx, err = makeOutputList(op, idx, "offset"); err != nil {
		scope.UpdateErr("ConcatOffset", err)
		return
	}
	return offset
}

// Creates a dataset that emits the records from one or more binary files.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the file(s) to be
// read.
//	header_bytes: A scalar representing the number of bytes to skip at the
// beginning of a file.
//	record_bytes: A scalar representing the number of bytes in each record.
//	footer_bytes: A scalar representing the number of bytes to skip at the end
// of a file.
//	buffer_size: A scalar representing the number of bytes to buffer. Must be > 0.
func FixedLengthRecordDataset(scope *Scope, filenames tf.Output, header_bytes tf.Output, record_bytes tf.Output, footer_bytes tf.Output, buffer_size tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FixedLengthRecordDataset",
		Input: []tf.Input{
			filenames, header_bytes, record_bytes, footer_bytes, buffer_size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that caches elements from `input_dataset`.
//
// A CacheDataset will iterate over the input_dataset, and store tensors. If the
// cache already exists, the cache will be used. If the cache is inappropriate
// (e.g. cannot be opened, contains tensors of the wrong shape / size), an error
// will the returned when used.
//
// Arguments:
//
//	filename: A path on the filesystem where we should cache the dataset. Note: this
// will be a directory.
//
//
func CacheDataset(scope *Scope, input_dataset tf.Output, filename tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "CacheDataset",
		Input: []tf.Input{
			input_dataset, filename,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShuffleDatasetAttr is an optional argument to ShuffleDataset.
type ShuffleDatasetAttr func(optionalAttr)

// ShuffleDatasetReshuffleEachIteration sets the optional reshuffle_each_iteration attribute to value.
//
// value: If true, each iterator over this dataset will be given
// a different pseudorandomly generated seed, based on a sequence seeded by the
// `seed` and `seed2` inputs. If false, each iterator will be given the same
// seed, and repeated iteration over this dataset will yield the exact same
// sequence of results.
// If not specified, defaults to true
func ShuffleDatasetReshuffleEachIteration(value bool) ShuffleDatasetAttr {
	return func(m optionalAttr) {
		m["reshuffle_each_iteration"] = value
	}
}

// Creates a dataset that shuffles elements from `input_dataset` pseudorandomly.
//
// Arguments:
//
//	buffer_size: The number of output elements to buffer in an iterator over
// this dataset. Compare with the `min_after_dequeue` attr when creating a
// `RandomShuffleQueue`.
//	seed: A scalar seed for the random number generator. If either `seed` or
// `seed2` is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func ShuffleDataset(scope *Scope, input_dataset tf.Output, buffer_size tf.Output, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShuffleDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShuffleDataset",
		Input: []tf.Input{
			input_dataset, buffer_size, seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PaddedBatchDatasetV2Attr is an optional argument to PaddedBatchDatasetV2.
type PaddedBatchDatasetV2Attr func(optionalAttr)

// PaddedBatchDatasetV2ParallelCopy sets the optional parallel_copy attribute to value.
// If not specified, defaults to false
func PaddedBatchDatasetV2ParallelCopy(value bool) PaddedBatchDatasetV2Attr {
	return func(m optionalAttr) {
		m["parallel_copy"] = value
	}
}

// Creates a dataset that batches and pads `batch_size` elements from the input.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	padded_shapes: A list of int64 tensors representing the desired padded shapes
// of the corresponding output components. These shapes may be partially
// specified, using `-1` to indicate that a particular dimension should be
// padded to the maximum size of all batch elements.
//	padding_values: A list of scalars containing the padding value to use for
// each of the outputs.
//	drop_remainder: A scalar representing whether the last batch should be dropped in case its size
// is smaller than desired.
//
func PaddedBatchDatasetV2(scope *Scope, input_dataset tf.Output, batch_size tf.Output, padded_shapes []tf.Output, padding_values []tf.Output, drop_remainder tf.Output, output_shapes []tf.Shape, optional ...PaddedBatchDatasetV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PaddedBatchDatasetV2",
		Input: []tf.Input{
			input_dataset, batch_size, tf.OutputList(padded_shapes), tf.OutputList(padding_values), drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StridedSliceAttr is an optional argument to StridedSlice.
type StridedSliceAttr func(optionalAttr)

// StridedSliceBeginMask sets the optional begin_mask attribute to value.
//
// value: a bitmask where a bit i being 1 means to ignore the begin
// value and instead use the largest interval possible. At runtime
// begin[i] will be replaced with `[0, n-1)` if `stride[i] > 0` or
// `[-1, n-1]` if `stride[i] < 0`
// If not specified, defaults to 0
func StridedSliceBeginMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["begin_mask"] = value
	}
}

// StridedSliceEndMask sets the optional end_mask attribute to value.
//
// value: analogous to `begin_mask`
// If not specified, defaults to 0
func StridedSliceEndMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["end_mask"] = value
	}
}

// StridedSliceEllipsisMask sets the optional ellipsis_mask attribute to value.
//
// value: a bitmask where bit `i` being 1 means the `i`th
// position is actually an ellipsis. One bit at most can be 1.
// If `ellipsis_mask == 0`, then an implicit ellipsis mask of `1 << (m+1)`
// is provided. This means that `foo[3:5] == foo[3:5, ...]`. An ellipsis
// implicitly creates as many range specifications as necessary to fully
// specify the sliced range for every dimension. For example for a 4-dimensional
// tensor `foo` the slice `foo[2, ..., 5:8]` implies `foo[2, :, :, 5:8]`.
// If not specified, defaults to 0
func StridedSliceEllipsisMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["ellipsis_mask"] = value
	}
}

// StridedSliceNewAxisMask sets the optional new_axis_mask attribute to value.
//
// value: a bitmask where bit `i` being 1 means the `i`th
// specification creates a new shape 1 dimension. For example
// `foo[:4, tf.newaxis, :2]` would produce a shape `(4, 1, 2)` tensor.
// If not specified, defaults to 0
func StridedSliceNewAxisMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["new_axis_mask"] = value
	}
}

// StridedSliceShrinkAxisMask sets the optional shrink_axis_mask attribute to value.
//
// value: a bitmask where bit `i` implies that the `i`th
// specification should shrink the dimensionality. begin and end
// must imply a slice of size 1 in the dimension. For example in
// python one might do `foo[:, 3, :]` which would result in
// `shrink_axis_mask` being 2.
// If not specified, defaults to 0
func StridedSliceShrinkAxisMask(value int64) StridedSliceAttr {
	return func(m optionalAttr) {
		m["shrink_axis_mask"] = value
	}
}

// Return a strided slice from `input`.
//
// Note, most python users will want to use the Python `Tensor.__getitem__`
// or `Variable.__getitem__` rather than this op directly.
//
// The goal of this op is to produce a new tensor with a subset of
// the elements from the `n` dimensional `input` tensor. The subset is chosen using
// a sequence of `m` sparse range specifications encoded into the arguments
// of this function. Note, in some cases
// `m` could be equal to `n`, but this need not be the case. Each
// range specification entry can be one of the following:
//
// - An ellipsis (...). Ellipses are used to imply zero or more
//   dimensions of full-dimension selection and are produced using
//   `ellipsis_mask`. For example, `foo[...]` is the identity slice.
//
// - A new axis. This is used to insert a new shape=1 dimension and is
//   produced using `new_axis_mask`. For example, `foo[:, ...]` where
//   `foo` is shape `(3, 4)` produces a `(1, 3, 4)` tensor.
//
//
// - A range `begin:end:stride`. This is used to specify how much to choose from
//   a given dimension. `stride` can be any integer but 0.  `begin` is an integer
//   which represents the index of the first value to select while `end` represents
//   the index of the last value to select. The number of values selected in each
//   dimension is `end - begin` if `stride > 0` and `begin - end` if `stride < 0`.
//   `begin` and `end` can be negative where `-1` is the last element, `-2` is
//   the second to last. `begin_mask` controls whether to replace the explicitly
//   given `begin` with an implicit effective value of `0` if `stride > 0` and
//   `-1` if `stride < 0`. `end_mask` is analogous but produces the number
//   required to create the largest open interval. For example, given a shape
//   `(3,)` tensor `foo[:]`, the effective `begin` and `end` are `0` and `3`. Do
//   not assume this is equivalent to `foo[0:-1]` which has an effective `begin`
//   and `end` of `0` and `2`. Another example is `foo[-2::-1]` which reverses the
//   first dimension of a tensor while dropping the last two (in the original
//   order elements). For example `foo = [1,2,3,4]; foo[-2::-1]` is `[4,3]`.
//
// - A single index. This is used to keep only elements that have a given
//   index. For example (`foo[2, :]` on a shape `(5,6)` tensor produces a
//   shape `(6,)` tensor. This is encoded in `begin` and `end` and
//   `shrink_axis_mask`.
//
// Each conceptual range specification is encoded in the op's argument. This
// encoding is best understand by considering a non-trivial example. In
// particular,
// `foo[1, 2:4, None, ..., :-3:-1, :]` will be encoded as
//
// ```
// begin = [1, 2, x, x, 0, x] # x denotes don't care (usually 0)
// end = [2, 4, x, x, -3, x]
// strides = [1, 1, x, x, -1, 1]
// begin_mask = 1<<4 | 1 << 5 = 48
// end_mask = 1<<5 = 32
// ellipsis_mask = 1<<3 = 8
// new_axis_mask = 1<<2 4
// shrink_axis_mask = 1<<0
// ```
//
// In this case if `foo.shape` is (5, 5, 5, 5, 5, 5) the final shape of
// the slice becomes (2, 1, 5, 5, 2, 5).
// Let us walk step by step through each argument specification.
//
// 1.  The first argument in the example slice is turned into `begin = 1` and
// `end = begin + 1 = 2`. To disambiguate from the original spec `2:4` we
// also set the appropriate bit in `shrink_axis_mask`.
//
// 2. `2:4` is contributes 2, 4, 1 to begin, end, and stride. All masks have
// zero bits contributed.
//
// 3. None is a synonym for `tf.newaxis`. This means insert a dimension of size 1
// dimension in the final shape. Dummy values are contributed to begin,
// end and stride, while the new_axis_mask bit is set.
//
// 4. `...` grab the full ranges from as many dimensions as needed to
// fully specify a slice for every dimension of the input shape.
//
// 5. `:-3:-1` shows the use of negative indices. A negative index `i` associated
// with a dimension that has shape `s` is converted to a positive index
// `s + i`. So `-1` becomes `s-1` (i.e. the last element). This conversion
// is done internally so begin, end and strides receive x, -3, and -1.
// The appropriate begin_mask bit is set to indicate the start range is the
// full range (ignoring the x).
//
// 6. `:` indicates that the entire contents of the corresponding dimension
// is selected. This is equivalent to `::` or `0::1`. begin, end, and strides
// receive 0, 0, and 1, respectively. The appropriate bits in `begin_mask` and
// `end_mask` are also set.
//
// *Requirements*:
//   `0 != strides[i] for i in [0, m)`
//   `ellipsis_mask must be a power of two (only one ellipsis)`
//
// Arguments:
//
//	begin: `begin[k]` specifies the offset into the `k`th range specification.
// The exact dimension this corresponds to will be determined by context.
// Out-of-bounds values will be silently clamped. If the `k`th bit of
// `begin_mask` then `begin[k]` is ignored and the full range of the
// appropriate dimension is used instead. Negative values causes indexing
// to start from the highest element e.g. If `foo==[1,2,3]` then `foo[-1]==3`.
//	end: `end[i]` is like `begin` with the exception that `end_mask` is
// used to determine full ranges.
//	strides: `strides[i]` specifies the increment in the `i`th specification
// after extracting a given element. Negative indices will reverse
// the original order. Out or range values are
// clamped to `[0,dim[i]) if slice[i]>0` or `[-1,dim[i]-1] if slice[i] < 0`
func StridedSlice(scope *Scope, input tf.Output, begin tf.Output, end tf.Output, strides tf.Output, optional ...StridedSliceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StridedSlice",
		Input: []tf.Input{
			input, begin, end, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that batches and pads `batch_size` elements from the input.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//	padded_shapes: A list of int64 tensors representing the desired padded shapes
// of the corresponding output components. These shapes may be partially
// specified, using `-1` to indicate that a particular dimension should be
// padded to the maximum size of all batch elements.
//	padding_values: A list of scalars containing the padding value to use for
// each of the outputs.
//
func PaddedBatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, padded_shapes []tf.Output, padding_values []tf.Output, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "PaddedBatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size, tf.OutputList(padded_shapes), tf.OutputList(padding_values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ShardDatasetAttr is an optional argument to ShardDataset.
type ShardDatasetAttr func(optionalAttr)

// ShardDatasetRequireNonEmpty sets the optional require_non_empty attribute to value.
// If not specified, defaults to false
func ShardDatasetRequireNonEmpty(value bool) ShardDatasetAttr {
	return func(m optionalAttr) {
		m["require_non_empty"] = value
	}
}

// Creates a `Dataset` that includes only 1/`num_shards` of this dataset.
//
// Arguments:
//
//	num_shards: An integer representing the number of shards operating in parallel.
//	index: An integer representing the current worker index.
//
//
func ShardDataset(scope *Scope, input_dataset tf.Output, num_shards tf.Output, index tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...ShardDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ShardDataset",
		Input: []tf.Input{
			input_dataset, num_shards, index,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A dataset that creates window datasets from the input dataset.
//
// Arguments:
//
//	size: A scalar representing the number of elements to accumulate in a window.
//	shift: A scalar representing the steps moving the sliding window forward in one
// iteration. It must be positive.
//	stride: A scalar representing the stride of the input elements of the sliding window.
// It must be positive.
//	drop_remainder: A scalar representing whether a window should be dropped in case its size is
// smaller than desired.
//
//
func WindowDataset(scope *Scope, input_dataset tf.Output, size tf.Output, shift tf.Output, stride tf.Output, drop_remainder tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "WindowDataset",
		Input: []tf.Input{
			input_dataset, size, shift, stride, drop_remainder,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset containing elements of first component of `input_dataset` having true in the last component.
func FilterByLastComponentDataset(scope *Scope, input_dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "FilterByLastComponentDataset",
		Input: []tf.Input{
			input_dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayGradV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayGradV3
func TensorArrayGradV2(scope *Scope, handle tf.Output, flow_in tf.Output, source string) (grad_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"source": source}
	opspec := tf.OpSpec{
		Type: "TensorArrayGradV2",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds Tensor 'bias' to Tensor 'input' for Quantized types.
//
// Broadcasts the values of bias on dimensions 0..N-2 of 'input'.
//
// Arguments:
//
//	bias: A 1D bias Tensor with size matching the last dimension of 'input'.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	min_bias: The float value that the lowest quantized bias value represents.
//	max_bias: The float value that the highest quantized bias value represents.
//
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedBiasAdd(scope *Scope, input tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_bias tf.Output, max_bias tf.Output, out_type tf.DataType) (output tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "QuantizedBiasAdd",
		Input: []tf.Input{
			input, bias, min_input, max_input, min_bias, max_bias,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Checks whether a tree ensemble has been initialized.
//
// Arguments:
//	tree_ensemble_handle: Handle to the tree ensemble resouce.
//
// Returns output boolean on whether it is initialized or not.
func IsBoostedTreesEnsembleInitialized(scope *Scope, tree_ensemble_handle tf.Output) (is_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsBoostedTreesEnsembleInitialized",
		Input: []tf.Input{
			tree_ensemble_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceSumAttr is an optional argument to SparseReduceSum.
type SparseReduceSumAttr func(optionalAttr)

// SparseReduceSumKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceSumKeepDims(value bool) SparseReduceSumAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_sum()`.  In particular, this Op also returns a dense `Tensor`
// instead of a sparse one.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
//
// Returns `R-K`-D.  The reduced Tensor.
func SparseReduceSum(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceSumAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceSum",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalAvgPoolGradAttr is an optional argument to FractionalAvgPoolGrad.
type FractionalAvgPoolGradAttr func(optionalAttr)

// FractionalAvgPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolGradOverlapping(value bool) FractionalAvgPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalAvgPool function.
//
// Unlike FractionalMaxPoolGrad, we don't need to find arg_max for
// FractionalAvgPoolGrad, we just need to evenly back-propagate each element of
// out_backprop to those indices that form the same pooling cell. Therefore, we
// just need to know the shape of original input tensor, instead of the whole
// tensor.
//
// Arguments:
//	orig_input_tensor_shape: Original input tensor shape for `fractional_avg_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
// w.r.t. the output of `fractional_avg_pool`.
//	row_pooling_sequence: row pooling sequence, form pooling region with
// col_pooling_sequence.
//	col_pooling_sequence: column pooling sequence, form pooling region with
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_avg_pool`.
func FractionalAvgPoolGrad(scope *Scope, orig_input_tensor_shape tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalAvgPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPoolGrad",
		Input: []tf.Input{
			orig_input_tensor_shape, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalMaxPoolGradAttr is an optional argument to FractionalMaxPoolGrad.
type FractionalMaxPoolGradAttr func(optionalAttr)

// FractionalMaxPoolGradOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolGradOverlapping(value bool) FractionalMaxPoolGradAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// Computes gradient of the FractionalMaxPool function.
//
// Arguments:
//	orig_input: Original input for `fractional_max_pool`
//	orig_output: Original output for `fractional_max_pool`
//	out_backprop: 4-D with shape `[batch, height, width, channels]`.  Gradients
// w.r.t. the output of `fractional_max_pool`.
//	row_pooling_sequence: row pooling sequence, form pooling region with
// col_pooling_sequence.
//	col_pooling_sequence: column pooling sequence, form pooling region with
// row_pooling sequence.
//
// Returns 4-D.  Gradients w.r.t. the input of `fractional_max_pool`.
func FractionalMaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, out_backprop tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output, optional ...FractionalMaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, out_backprop, row_pooling_sequence, col_pooling_sequence,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingCenteredRMSPropParametersAttr is an optional argument to LoadTPUEmbeddingCenteredRMSPropParameters.
type LoadTPUEmbeddingCenteredRMSPropParametersAttr func(optionalAttr)

// LoadTPUEmbeddingCenteredRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingCenteredRMSPropParametersTableId(value int64) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingCenteredRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingCenteredRMSPropParametersTableName(value string) LoadTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load centered RMSProp embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the centered RMSProp optimization algorithm.
//	ms: Value of ms used in the centered RMSProp optimization algorithm.
//	mom: Value of mom used in the centered RMSProp optimization algorithm.
//	mg: Value of mg used in the centered RMSProp optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingCenteredRMSPropParameters(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, mg tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingCenteredRMSPropParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingCenteredRMSPropParameters",
		Input: []tf.Input{
			parameters, ms, mom, mg,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Return the shape of s0 op s1 with broadcast.
//
// Given `s0` and `s1`, tensors that represent shapes, compute `r0`, the
// broadcasted shape. `s0`, `s1` and `r0` are all integer vectors.
func BroadcastArgs(scope *Scope, s0 tf.Output, s1 tf.Output) (r0 tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BroadcastArgs",
		Input: []tf.Input{
			s0, s1,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes inverse hyperbolic cosine of x element-wise.
func Acosh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acosh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of (x > y) element-wise.
//
// *NOTE*: `Greater` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func Greater(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Greater",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softplus: `log(exp(features) + 1)`.
func Softplus(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softplus",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedAddAttr is an optional argument to QuantizedAdd.
type QuantizedAddAttr func(optionalAttr)

// QuantizedAddToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedAddToutput(value tf.DataType) QuantizedAddAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// Returns x + y element-wise, working on quantized buffers.
//
// Arguments:
//
//
//	min_x: The float value that the lowest quantized `x` value represents.
//	max_x: The float value that the highest quantized `x` value represents.
//	min_y: The float value that the lowest quantized `y` value represents.
//	max_y: The float value that the highest quantized `y` value represents.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
//
// *NOTE*: `QuantizedAdd` supports limited forms of broadcasting. More about
// broadcasting [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func QuantizedAdd(scope *Scope, x tf.Output, y tf.Output, min_x tf.Output, max_x tf.Output, min_y tf.Output, max_y tf.Output, optional ...QuantizedAddAttr) (z tf.Output, min_z tf.Output, max_z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedAdd",
		Input: []tf.Input{
			x, y, min_x, max_x, min_y, max_y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes gradients for the scaled exponential linear (Selu) operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Selu operation.
//	outputs: The outputs of the corresponding Selu operation.
//
// Returns The gradients: `gradients * (outputs + scale * alpha)`
// if outputs < 0, `scale * gradients` otherwise.
func SeluGrad(scope *Scope, gradients tf.Output, outputs tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SeluGrad",
		Input: []tf.Input{
			gradients, outputs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueWithCountsAttr is an optional argument to UniqueWithCounts.
type UniqueWithCountsAttr func(optionalAttr)

// UniqueWithCountsOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueWithCountsOutIdx(value tf.DataType) UniqueWithCountsAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements in a 1-D tensor.
//
// This operation returns a tensor `y` containing all of the unique elements of `x`
// sorted in the same order that they occur in `x`. This operation also returns a
// tensor `idx` the same size as `x` that contains the index of each value of `x`
// in the unique output `y`. Finally, it returns a third tensor `count` that
// contains the count of each element of `y` in `x`. In other words:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx, count = unique_with_counts(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// count ==> [2, 1, 3, 1, 2]
// ```
//
// Arguments:
//	x: 1-D.
//
// Returns 1-D.1-D.1-D.
func UniqueWithCounts(scope *Scope, x tf.Output, optional ...UniqueWithCountsAttr) (y tf.Output, idx tf.Output, count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UniqueWithCounts",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ArgMinAttr is an optional argument to ArgMin.
type ArgMinAttr func(optionalAttr)

// ArgMinOutputType sets the optional output_type attribute to value.
// If not specified, defaults to DT_INT64
func ArgMinOutputType(value tf.DataType) ArgMinAttr {
	return func(m optionalAttr) {
		m["output_type"] = value
	}
}

// Returns the index with the smallest value across dimensions of a tensor.
//
// Note that in case of ties the identity of the return value is not guaranteed.
//
// Usage:
//   ```python
//   import tensorflow as tf
//   a = [1, 10, 26.9, 2.8, 166.32, 62.3]
//   b = tf.math.argmin(input = a)
//   c = tf.keras.backend.eval(b)
//   # c = 0
//   # here a[0] = 1 which is the smallest element of a across axis 0
//   ```
//
// Arguments:
//
//	dimension: int32 or int64, must be in the range `[-rank(input), rank(input))`.
// Describes which dimension of the input Tensor to reduce across. For vectors,
// use dimension = 0.
func ArgMin(scope *Scope, input tf.Output, dimension tf.Output, optional ...ArgMinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ArgMin",
		Input: []tf.Input{
			input, dimension,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LeakyReluGradAttr is an optional argument to LeakyReluGrad.
type LeakyReluGradAttr func(optionalAttr)

// LeakyReluGradAlpha sets the optional alpha attribute to value.
// If not specified, defaults to 0.2
func LeakyReluGradAlpha(value float32) LeakyReluGradAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// Computes rectified linear gradients for a LeakyRelu operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding LeakyRelu operation.
//	features: The features passed as input to the corresponding LeakyRelu operation,
// OR the outputs of that operation (both work equivalently).
//
// Returns `gradients * (features > 0) + alpha * gradients * (featurs <= 0)`.
func LeakyReluGrad(scope *Scope, gradients tf.Output, features tf.Output, optional ...LeakyReluGradAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LeakyReluGrad",
		Input: []tf.Input{
			gradients, features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse real-valued fast Fourier transform.
//
// Computes the inverse 1-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most dimension of `input`.
//
// The inner-most dimension of `input` is assumed to be the result of `RFFT`: the
// `fft_length / 2 + 1` unique components of the DFT of a real-valued signal. If
// `fft_length` is not provided, it is computed from the size of the inner-most
// dimension of `input` (`fft_length = 2 * (inner - 1)`). If the FFT length used to
// compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along the axis `IRFFT` is computed on, if `fft_length / 2 + 1` is smaller
// than the corresponding dimension of `input`, the dimension is cropped. If it is
// larger, the dimension is padded with zeros.
//
// Arguments:
//	input: A complex64 tensor.
//	fft_length: An int32 tensor of shape [1]. The FFT length.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most
//   dimension of `input` is replaced with the `fft_length` samples of its inverse
//   1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfft
// @end_compatibility
func IRFFT(scope *Scope, input tf.Output, fft_length tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IRFFT",
		Input: []tf.Input{
			input, fft_length,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes rectified linear: `max(features, 0)`.
func Relu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Relu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolWithArgmaxAttr is an optional argument to MaxPoolWithArgmax.
type MaxPoolWithArgmaxAttr func(optionalAttr)

// MaxPoolWithArgmaxTargmax sets the optional Targmax attribute to value.
// If not specified, defaults to DT_INT64
func MaxPoolWithArgmaxTargmax(value tf.DataType) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["Targmax"] = value
	}
}

// MaxPoolWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolWithArgmaxIncludeBatchInIndex(value bool) MaxPoolWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Performs max pooling on the input and outputs both max values and indices.
//
// The indices in `argmax` are flattened, so that a maximum value at position
// `[b, y, x, c]` becomes flattened index:
// `(y * width + x) * channels + c` if `include_batch_in_index` is False;
// `((b * height + y) * width + x) * channels + c` if `include_batch_in_index` is True.
//
// The indices returned are always in `[0, height) x [0, width)` before flattening,
// even if padding is involved and the mathematically correct answer is outside
// (either negative or too large).  This is a bug, but fixing it is difficult to do
// in a safe backwards compatible way, especially due to flattening.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, channels]`.  Input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.4-D.  The flattened indices of the max values chosen for each output.
func MaxPoolWithArgmax(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolWithArgmaxAttr) (output tf.Output, argmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolWithArgmax",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ResourceSparseApplyFtrlV2Attr is an optional argument to ResourceSparseApplyFtrlV2.
type ResourceSparseApplyFtrlV2Attr func(optionalAttr)

// ResourceSparseApplyFtrlV2UseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyFtrlV2UseLocking(value bool) ResourceSparseApplyFtrlV2Attr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update relevant entries in '*var' according to the Ftrl-proximal scheme.
//
// That is for rows we have grad for, we update var, accum and linear as follows:
// grad_with_shrinkage = grad + 2 * l2_shrinkage * var
// accum_new = accum + grad_with_shrinkage * grad_with_shrinkage
// linear += grad_with_shrinkage +
//     (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
// accum = accum_new
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	linear: Should be from a Variable().
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 shrinkage regulariation. Must be a scalar.
//
//	lr_power: Scaling factor. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyFtrlV2(scope *Scope, var_ tf.Output, accum tf.Output, linear tf.Output, grad tf.Output, indices tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, l2_shrinkage tf.Output, lr_power tf.Output, optional ...ResourceSparseApplyFtrlV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyFtrlV2",
		Input: []tf.Input{
			var_, accum, linear, grad, indices, lr, l1, l2, l2_shrinkage, lr_power,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Shuts down a running distributed TPU system.
//
// The op returns an error if no system is running.
//
// Returns the created operation.
func ShutdownDistributedTPU(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ShutdownDistributedTPU",
	}
	return scope.AddOperation(opspec)
}

// MaxPool3DGradGradAttr is an optional argument to MaxPool3DGradGrad.
type MaxPool3DGradGradAttr func(optionalAttr)

// MaxPool3DGradGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DGradGradDataFormat(value string) MaxPool3DGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPool3DGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3DGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DGradAttr is an optional argument to MaxPool3DGrad.
type MaxPool3DGradAttr func(optionalAttr)

// MaxPool3DGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DGradDataFormat(value string) MaxPool3DGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of max pooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func MaxPool3DGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3DGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Updates the table to associates keys with values.
//
// The tensor `keys` must be of the same type as the keys of the table.
// The tensor `values` must be of the type of the table values.
//
// Arguments:
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//	values: Values to associate with keys.
//
// Returns the created operation.
func LookupTableInsertV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableInsertV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// StageClearAttr is an optional argument to StageClear.
type StageClearAttr func(optionalAttr)

// StageClearCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageClearCapacity(value int64) StageClearAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StageClearMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageClearMemoryLimit(value int64) StageClearAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StageClearContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StageClearContainer(value string) StageClearAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StageClearSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StageClearSharedName(value string) StageClearAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes all elements in the underlying container.
//
// Returns the created operation.
func StageClear(scope *Scope, dtypes []tf.DataType, optional ...StageClearAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StageClear",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Inverse fast Fourier transform.
//
// Computes the inverse 1-dimensional discrete Fourier transform over the
// inner-most dimension of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most
//   dimension of `input` is replaced with its inverse 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifft
// @end_compatibility
func IFFT(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high intersection-over-union (IOU) overlap
// with previously selected boxes.  Bounding boxes are supplied as
// [y1, x1, y2, x2], where (y1, x1) and (y2, x2) are the coordinates of any
// diagonal pair of box corners and the coordinates can be provided as normalized
// (i.e., lying in the interval [0, 1]) or absolute.  Note that this algorithm
// is agnostic to where the origin is in the coordinate system.  Note that this
// algorithm is invariant to orthogonal transformations and translations
// of the coordinate system; thus translating or reflections of the coordinate
// system result in the same boxes being selected by the algorithm.
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//   selected_indices = tf.image.non_max_suppression_v2(
//       boxes, scores, max_output_size, iou_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	boxes: A 2-D float tensor of shape `[num_boxes, 4]`.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	iou_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too much with respect to IOU.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionV2(scope *Scope, boxes tf.Output, scores tf.Output, max_output_size tf.Output, iou_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionV2",
		Input: []tf.Input{
			boxes, scores, max_output_size, iou_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterV2Attr is an optional argument to Conv3DBackpropFilterV2.
type Conv3DBackpropFilterV2Attr func(optionalAttr)

// Conv3DBackpropFilterV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DBackpropFilterV2DataFormat(value string) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropFilterV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropFilterV2Dilations(value []int64) Conv3DBackpropFilterV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 5-D
// `[filter_depth, filter_height, filter_width, in_channels, out_channels]`
// tensor.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilterV2(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilterV2",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DepthwiseConv2dNativeBackpropFilterAttr is an optional argument to DepthwiseConv2dNativeBackpropFilter.
type DepthwiseConv2dNativeBackpropFilterAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropFilterDataFormat(value string) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func DepthwiseConv2dNativeBackpropFilterDilations(value []int64) DepthwiseConv2dNativeBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the filter.
//
// Arguments:
//	input: 4-D with shape based on `data_format`.  For example, if
// `data_format` is 'NHWC' then `input` is a 4-D `[batch, in_height,
// in_width, in_channels]` tensor.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, depthwise_multiplier]` tensor.
//	out_backprop: 4-D with shape  based on `data_format`.
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func DepthwiseConv2dNativeBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BoostedTreesEnsembleResourceHandleOpAttr is an optional argument to BoostedTreesEnsembleResourceHandleOp.
type BoostedTreesEnsembleResourceHandleOpAttr func(optionalAttr)

// BoostedTreesEnsembleResourceHandleOpContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func BoostedTreesEnsembleResourceHandleOpContainer(value string) BoostedTreesEnsembleResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// BoostedTreesEnsembleResourceHandleOpSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func BoostedTreesEnsembleResourceHandleOpSharedName(value string) BoostedTreesEnsembleResourceHandleOpAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a handle to a BoostedTreesEnsembleResource
func BoostedTreesEnsembleResourceHandleOp(scope *Scope, optional ...BoostedTreesEnsembleResourceHandleOpAttr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesEnsembleResourceHandleOp",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that shuffles and repeats elements from `input_dataset`
//
// pseudorandomly.
//
// Arguments:
//
//	buffer_size: The number of output elements to buffer in an iterator over
// this dataset. Compare with the `min_after_dequeue` attr when creating a
// `RandomShuffleQueue`.
//	seed: A scalar seed for the random number generator. If either `seed` or
// `seed2` is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//	count: A scalar representing the number of times the underlying dataset
// should be repeated. The default is `-1`, which results in infinite repetition.
//
//
func ShuffleAndRepeatDataset(scope *Scope, input_dataset tf.Output, buffer_size tf.Output, seed tf.Output, seed2 tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ShuffleAndRepeatDataset",
		Input: []tf.Input{
			input_dataset, buffer_size, seed, seed2, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the inverse of `x` wrt its input.
//
// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
// is the corresponding input gradient.
func InvGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradAttr is an optional argument to MaxPoolGradGrad.
type MaxPoolGradGradAttr func(optionalAttr)

// MaxPoolGradGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradGradDataFormat(value string) MaxPoolGradGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FIFOQueueV2Attr is an optional argument to FIFOQueueV2.
type FIFOQueueV2Attr func(optionalAttr)

// FIFOQueueV2Shapes sets the optional shapes attribute to value.
//
// value: The shape of each component in a value. The length of this attr must
// be either 0 or the same as the length of component_types. If the length of
// this attr is 0, the shapes of queue elements are not constrained, and
// only one element may be dequeued at a time.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func FIFOQueueV2Shapes(value []tf.Shape) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shapes"] = value
	}
}

// FIFOQueueV2Capacity sets the optional capacity attribute to value.
//
// value: The upper bound on the number of elements in this queue.
// Negative numbers mean no limit.
// If not specified, defaults to -1
func FIFOQueueV2Capacity(value int64) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// FIFOQueueV2Container sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func FIFOQueueV2Container(value string) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// FIFOQueueV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this queue will be shared under the given name
// across multiple sessions.
// If not specified, defaults to ""
func FIFOQueueV2SharedName(value string) FIFOQueueV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A queue that produces elements in first-in first-out order.
//
// Arguments:
//	component_types: The type of each component in a value.
//
// Returns The handle to the queue.
func FIFOQueueV2(scope *Scope, component_types []tf.DataType, optional ...FIFOQueueV2Attr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"component_types": component_types}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FIFOQueueV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DBackpropFilterAttr is an optional argument to Conv2DBackpropFilter.
type Conv2DBackpropFilterAttr func(optionalAttr)

// Conv2DBackpropFilterUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DBackpropFilterUseCudnnOnGpu(value bool) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DBackpropFilterExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to <>
func Conv2DBackpropFilterExplicitPaddings(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DBackpropFilterDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func Conv2DBackpropFilterDataFormat(value string) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DBackpropFilterDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func Conv2DBackpropFilterDilations(value []int64) Conv2DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of convolution with respect to the filter.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	filter_sizes: An integer vector representing the tensor shape of `filter`,
// where `filter` is a 4-D
// `[filter_height, filter_width, in_channels, out_channels]` tensor.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution. Must be in the same order as the dimension specified with
// format.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.  Gradient w.r.t.
// the `filter` input of the convolution.
func Conv2DBackpropFilter(scope *Scope, input tf.Output, filter_sizes tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv2DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2DBackpropFilter",
		Input: []tf.Input{
			input, filter_sizes, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedConv2DAttr is an optional argument to QuantizedConv2D.
type QuantizedConv2DAttr func(optionalAttr)

// QuantizedConv2DOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedConv2DOutType(value tf.DataType) QuantizedConv2DAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedConv2DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedConv2DDilations(value []int64) QuantizedConv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2D convolution given quantized 4D input and filter tensors.
//
// The inputs are quantized tensors where the lowest value represents the real
// number of the associated minimum, and the highest represents the maximum.
// This means that you can only interpret the quantized output in the same way, by
// taking the returned minimum and maximum values into account.
//
// Arguments:
//
//	filter: filter's input_depth dimension must match input's depth dimensions.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	min_filter: The float value that the lowest quantized filter value represents.
//	max_filter: The float value that the highest quantized filter value represents.
//	strides: The stride of the sliding window for each dimension of the input
// tensor.
//	padding: The type of padding algorithm to use.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedConv2D(scope *Scope, input tf.Output, filter tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedConv2DAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedConv2D",
		Input: []tf.Input{
			input, filter, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Adds `bias` to `value`.
//
// This is a deprecated version of BiasAdd and will be soon removed.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAddV1(scope *Scope, value tf.Output, bias tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BiasAddV1",
		Input: []tf.Input{
			value, bias,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that emits the lines of one or more text files.
//
// Arguments:
//	filenames: A scalar or a vector containing the name(s) of the file(s) to be
// read.
//	compression_type: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
//	buffer_size: A scalar containing the number of bytes to buffer.
func TextLineDataset(scope *Scope, filenames tf.Output, compression_type tf.Output, buffer_size tf.Output) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TextLineDataset",
		Input: []tf.Input{
			filenames, compression_type, buffer_size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BiasAddGradAttr is an optional argument to BiasAddGrad.
type BiasAddGradAttr func(optionalAttr)

// BiasAddGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the bias tensor will be added to the last dimension
// of the value tensor.
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// The tensor will be added to "in_channels", the third-to-the-last
//     dimension.
// If not specified, defaults to "NHWC"
func BiasAddGradDataFormat(value string) BiasAddGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// The backward operation for "BiasAdd" on the "bias" tensor.
//
// It accumulates all the values from out_backprop into the feature dimension.
// For NHWC data format, the feature dimension is the last. For NCHW data format,
// the feature dimension is the third-to-last.
//
// Arguments:
//	out_backprop: Any number of dimensions.
//
// Returns 1-D with size the feature dimension of `out_backprop`.
func BiasAddGrad(scope *Scope, out_backprop tf.Output, optional ...BiasAddGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BiasAddGrad",
		Input: []tf.Input{
			out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the minimum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \min_j(data_j)\\) where `min` is over `j` such
// that `segment_ids[j] == i`.
//
// If the min is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMin.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_min(c, tf.constant([0, 0, 1]))
// # ==> [[1, 2, 2, 1],
// #      [5, 6, 7, 8]]
// ```
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMin(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMin",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormGradV3Attr is an optional argument to FusedBatchNormGradV3.
type FusedBatchNormGradV3Attr func(optionalAttr)

// FusedBatchNormGradV3Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradV3Epsilon(value float32) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradV3DataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradV3DataFormat(value string) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradV3IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradV3IsTraining(value bool) FusedBatchNormGradV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//	reserve_space_3: When is_training is True, a 1D Tensor for some intermediate results to be reused
// in gradient computation. When is_training is False, a dummy empty Tensor will be
// created.
//
// Returns A 4D Tensor for the gradient with respect to x.A 1D Tensor for the gradient with respect to scale.A 1D Tensor for the gradient with respect to offset.Unused placeholder to match the mean input in FusedBatchNorm.Unused placeholder to match the variance input
// in FusedBatchNorm.
func FusedBatchNormGradV3(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, reserve_space_3 tf.Output, optional ...FusedBatchNormGradV3Attr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_4 tf.Output, reserve_space_5 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGradV3",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2, reserve_space_3,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormGradAttr is an optional argument to FusedBatchNormGrad.
type FusedBatchNormGradAttr func(optionalAttr)

// FusedBatchNormGradEpsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradEpsilon(value float32) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradDataFormat(value string) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradIsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradIsTraining(value bool) FusedBatchNormGradAttr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
// Returns A 4D Tensor for the gradient with respect to x.A 1D Tensor for the gradient with respect to scale.A 1D Tensor for the gradient with respect to offset.Unused placeholder to match the mean input in FusedBatchNorm.Unused placeholder to match the variance input
// in FusedBatchNorm.
func FusedBatchNormGrad(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, optional ...FusedBatchNormGradAttr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_3 tf.Output, reserve_space_4 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGrad",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// FusedBatchNormV3Attr is an optional argument to FusedBatchNormV3.
type FusedBatchNormV3Attr func(optionalAttr)

// FusedBatchNormV3Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV3Epsilon(value float32) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV3DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV3DataFormat(value string) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV3IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV3IsTraining(value bool) FusedBatchNormV3Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns A 4D Tensor for output data.A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.A 1D Tensor for some intermediate results, to be reused in the gradient
// computation for better efficiency.
func FusedBatchNormV3(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV3Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, reserve_space_3 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV3",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4), op.Output(5)
}

// ImagAttr is an optional argument to Imag.
type ImagAttr func(optionalAttr)

// ImagTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func ImagTout(value tf.DataType) ImagAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the imaginary part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the imaginary part of each element in `input`. All
// elements in `input` must be complex numbers of the form \\(a + bj\\), where *a*
// is the real part and *b* is the imaginary part returned by this operation.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.imag(input) ==> [4.75, 5.75]
// ```
func Imag(scope *Scope, input tf.Output, optional ...ImagAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Imag",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RequantizePerChannelAttr is an optional argument to RequantizePerChannel.
type RequantizePerChannelAttr func(optionalAttr)

// RequantizePerChannelOutType sets the optional out_type attribute to value.
//
// value: The quantized type of output tensor that needs to be converted.
// If not specified, defaults to DT_QUINT8
func RequantizePerChannelOutType(value tf.DataType) RequantizePerChannelAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Requantizes input with min and max values known per channel.
//
// Arguments:
//	input: The original input tensor.
//	input_min: The minimum value of the input tensor
//	input_max: The maximum value of the input tensor.
//	requested_output_min: The minimum value of the output tensor requested.
//	requested_output_max: The maximum value of the output tensor requested.
//
// Returns Output tensor.The minimum value of the final output tensorThe maximum value of the final output tensor.
func RequantizePerChannel(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, requested_output_min tf.Output, requested_output_max tf.Output, optional ...RequantizePerChannelAttr) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RequantizePerChannel",
		Input: []tf.Input{
			input, input_min, input_max, requested_output_min, requested_output_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DecodeCSVAttr is an optional argument to DecodeCSV.
type DecodeCSVAttr func(optionalAttr)

// DecodeCSVFieldDelim sets the optional field_delim attribute to value.
//
// value: char delimiter to separate fields in a record.
// If not specified, defaults to ","
func DecodeCSVFieldDelim(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["field_delim"] = value
	}
}

// DecodeCSVUseQuoteDelim sets the optional use_quote_delim attribute to value.
//
// value: If false, treats double quotation marks as regular
// characters inside of the string fields (ignoring RFC 4180, Section 2,
// Bullet 5).
// If not specified, defaults to true
func DecodeCSVUseQuoteDelim(value bool) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["use_quote_delim"] = value
	}
}

// DecodeCSVNaValue sets the optional na_value attribute to value.
//
// value: Additional string to recognize as NA/NaN.
// If not specified, defaults to ""
func DecodeCSVNaValue(value string) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["na_value"] = value
	}
}

// DecodeCSVSelectCols sets the optional select_cols attribute to value.
// If not specified, defaults to <>
func DecodeCSVSelectCols(value []int64) DecodeCSVAttr {
	return func(m optionalAttr) {
		m["select_cols"] = value
	}
}

// Convert CSV records to tensors. Each column maps to one tensor.
//
// RFC 4180 format is expected for the CSV records.
// (https://tools.ietf.org/html/rfc4180)
// Note that we allow leading and trailing spaces with int or float field.
//
// Arguments:
//	records: Each string is a record/row in the csv and all records should have
// the same format.
//	record_defaults: One tensor per column of the input record, with either a
// scalar default value for that column or an empty vector if the column is
// required.
//
// Returns Each tensor will have the same shape as records.
func DecodeCSV(scope *Scope, records tf.Output, record_defaults []tf.Output, optional ...DecodeCSVAttr) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCSV",
		Input: []tf.Input{
			records, tf.OutputList(record_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("DecodeCSV", err)
		return
	}
	return output
}

// ParseSequenceExampleAttr is an optional argument to ParseSequenceExample.
type ParseSequenceExampleAttr func(optionalAttr)

// ParseSequenceExampleNcontextSparse sets the optional Ncontext_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNcontextSparse(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Ncontext_sparse"] = value
	}
}

// ParseSequenceExampleNcontextDense sets the optional Ncontext_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNcontextDense(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Ncontext_dense"] = value
	}
}

// ParseSequenceExampleNfeatureListSparse sets the optional Nfeature_list_sparse attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNfeatureListSparse(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Nfeature_list_sparse"] = value
	}
}

// ParseSequenceExampleNfeatureListDense sets the optional Nfeature_list_dense attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func ParseSequenceExampleNfeatureListDense(value int64) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["Nfeature_list_dense"] = value
	}
}

// ParseSequenceExampleContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleContextSparseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSequenceExampleFeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListDenseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSequenceExampleContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleContextDenseShapes(value []tf.Shape) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSequenceExampleFeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListSparseTypes(value []tf.DataType) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSequenceExampleFeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSequenceExampleFeatureListDenseShapes(value []tf.Shape) ParseSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a vector of brain.SequenceExample protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A vector containing binary serialized SequenceExample protos.
//	debug_name: A vector containing the names of the serialized protos.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no name is available.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
//	feature_list_dense_missing_assumed_empty: A vector listing the
// FeatureList keys which may be missing from the SequenceExamples.  If the
// associated FeatureList is missing, it is treated as empty.  By default,
// any FeatureList not listed in this vector must exist in the SequenceExamples.
//	context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
// The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' context features associated with
// dense values.
//	feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
// (scalars).  The keys expected in the FeatureLists associated with sparse
// values.
//	feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
func ParseSequenceExample(scope *Scope, serialized tf.Output, debug_name tf.Output, context_dense_defaults []tf.Output, feature_list_dense_missing_assumed_empty []string, context_sparse_keys []string, context_dense_keys []string, feature_list_sparse_keys []string, feature_list_dense_keys []string, optional ...ParseSequenceExampleAttr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output, feature_list_dense_lengths []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"feature_list_dense_missing_assumed_empty": feature_list_dense_missing_assumed_empty, "context_sparse_keys": context_sparse_keys, "context_dense_keys": context_dense_keys, "feature_list_sparse_keys": feature_list_sparse_keys, "feature_list_dense_keys": feature_list_dense_keys}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSequenceExample",
		Input: []tf.Input{
			serialized, debug_name, tf.OutputList(context_dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	if feature_list_dense_lengths, idx, err = makeOutputList(op, idx, "feature_list_dense_lengths"); err != nil {
		scope.UpdateErr("ParseSequenceExample", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values, feature_list_dense_lengths
}

// Returns a tensor of zeros with the same shape and type as x.
//
// Arguments:
//	x: a tensor of type T.
//
// Returns a tensor of the same shape and type as x but filled with zeros.
func ZerosLike(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ZerosLike",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Aggregates the summary of accumulated stats for the batch.
//
// The summary stats contains gradients and hessians accumulated for each node, bucket and dimension id.
//
// Arguments:
//	node_ids: int32; Rank 1 Tensor containing node ids for each example, shape [batch_size].
//	gradients: float32; Rank 2 Tensor (shape=[batch_size, logits_dimension]) with gradients for each example.
//	hessians: float32; Rank 2 Tensor (shape=[batch_size, hessian_dimension]) with hessians for each example.
//	feature_indices: int32; Rank 2 indices of feature sparse Tensors (shape=[number of sparse entries, 2]).
// Number of sparse entries across all instances from the batch. The first value is
// the index of the instance, the second is dimension of the feature. The second axis
// can only have 2 values, i.e., the input dense version of Tensor can only be matrix.
//	feature_values: int32; Rank 1 values of feature sparse Tensors (shape=[number of sparse entries]).
// Number of sparse entries across all instances from the batch. The first value is
// the index of the instance, the second is dimension of the feature.
//	feature_shape: int32; Rank 1 dense shape of feature sparse Tensors (shape=[2]).
// The first axis can only have 2 values, [batch_size, feature_dimension].
//	max_splits: int; the maximum number of splits possible in the whole tree.
//	num_buckets: int; equals to the maximum possible value of bucketized feature + 1.
//
// Returns int32; Rank 2 indices of summary sparse Tensors (shape=[number of non zero statistics, 4])
// The second axis can only be 4 including node id, feature dimension, bucket id, and statistics_dimension.
// statistics_dimension = logits_dimension + hessian_dimension.output Rank 1 Tensor (shape=[number of non zero statistics])output Rank 1 Tensor (shape=[4])
// The tensor has following 4 values: [max_splits, feature_dimension, num_buckets, statistics_dimension],
// where statistics_dimension = gradient_dimension + hessian_dimension. gradient_dimension
// is the same as label_dimension, i.e., the output space. hessian_dimension can be the same
// as logits dimension when diagonal hessian is used, or label_dimension^2 when full
// hessian is used.
func BoostedTreesSparseAggregateStats(scope *Scope, node_ids tf.Output, gradients tf.Output, hessians tf.Output, feature_indices tf.Output, feature_values tf.Output, feature_shape tf.Output, max_splits int64, num_buckets int64) (stats_summary_indices tf.Output, stats_summary_values tf.Output, stats_summary_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"max_splits": max_splits, "num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "BoostedTreesSparseAggregateStats",
		Input: []tf.Input{
			node_ids, gradients, hessians, feature_indices, feature_values, feature_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DecodePaddedRawAttr is an optional argument to DecodePaddedRaw.
type DecodePaddedRawAttr func(optionalAttr)

// DecodePaddedRawLittleEndian sets the optional little_endian attribute to value.
//
// value: Whether the input `input_bytes` is in little-endian order. Ignored for
// `out_type` values that are stored in a single byte, like `uint8`
// If not specified, defaults to true
func DecodePaddedRawLittleEndian(value bool) DecodePaddedRawAttr {
	return func(m optionalAttr) {
		m["little_endian"] = value
	}
}

// Reinterpret the bytes of a string as a vector of numbers.
//
// Arguments:
//	input_bytes: Tensor of string to be decoded.
//	fixed_length: Length in bytes for each element of the decoded output. Must be a multiple
// of the size of the output type.
//
//
// Returns A Tensor with one more dimension than the input `bytes`. The added dimension
// will have size equal to the length of the elements of `bytes` divided by the
// number of bytes to represent `out_type`.
func DecodePaddedRaw(scope *Scope, input_bytes tf.Output, fixed_length tf.Output, out_type tf.DataType, optional ...DecodePaddedRawAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodePaddedRaw",
		Input: []tf.Input{
			input_bytes, fixed_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a serialized GraphDef representing `input_dataset`.
//
// Returns a graph representation for `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return the graph representation for.
//
// Returns The graph representation of the dataset (as serialized GraphDef).
func DatasetToGraph(scope *Scope, input_dataset tf.Output) (graph tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DatasetToGraph",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StageAttr is an optional argument to Stage.
type StageAttr func(optionalAttr)

// StageCapacity sets the optional capacity attribute to value.
//
// value: Maximum number of elements in the Staging Area. If > 0, inserts
// on the container will block when the capacity is reached.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageCapacity(value int64) StageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StageMemoryLimit sets the optional memory_limit attribute to value.
//
// value: The maximum number of bytes allowed for Tensors in the Staging Area.
// If > 0, inserts will block until sufficient space is available.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageMemoryLimit(value int64) StageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StageContainer sets the optional container attribute to value.
//
// value: If non-empty, this queue is placed in the given container. Otherwise,
// a default container is used.
// If not specified, defaults to ""
func StageContainer(value string) StageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StageSharedName sets the optional shared_name attribute to value.
//
// value: It is necessary to match this name to the matching Unstage Op.
// If not specified, defaults to ""
func StageSharedName(value string) StageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Stage values similar to a lightweight Enqueue.
//
// The basic functionality of this Op is similar to a queue with many
// fewer capabilities and options.  This Op is optimized for performance.
//
// Arguments:
//	values: a list of tensors
// dtypes A list of data types that inserted values should adhere to.
//
// Returns the created operation.
func Stage(scope *Scope, values []tf.Output, optional ...StageAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Stage",
		Input: []tf.Input{
			tf.OutputList(values),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// TruncatedNormalAttr is an optional argument to TruncatedNormal.
type TruncatedNormalAttr func(optionalAttr)

// TruncatedNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func TruncatedNormalSeed(value int64) TruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// TruncatedNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func TruncatedNormalSeed2(value int64) TruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a truncated normal distribution.
//
// The generated values follow a normal distribution with mean 0 and standard
// deviation 1, except that values whose magnitude is more than 2 standard
// deviations from the mean are dropped and re-picked.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with random truncated normal
// values.
func TruncatedNormal(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...TruncatedNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TruncatedNormal",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the inverse permutation of a tensor.
//
// This operation computes the inverse of an index permutation. It takes a 1-D
// integer tensor `x`, which represents the indices of a zero-based array, and
// swaps each value with its index position. In other words, for an output tensor
// `y` and an input tensor `x`, this operation computes the following:
//
// `y[x[i]] = i for i in [0, 1, ..., len(x) - 1]`
//
// The values must include 0. There can be no duplicate values or negative values.
//
// For example:
//
// ```
// # tensor `x` is [3, 4, 0, 2, 1]
// invert_permutation(x) ==> [2, 4, 3, 0, 1]
// ```
//
// Arguments:
//	x: 1-D.
//
// Returns 1-D.
func InvertPermutation(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InvertPermutation",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalMaxPoolAttr is an optional argument to FractionalMaxPool.
type FractionalMaxPoolAttr func(optionalAttr)

// FractionalMaxPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalMaxPoolPseudoRandom(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalMaxPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [20, 16] for fractional max pooling.
// If not specified, defaults to false
func FractionalMaxPoolOverlapping(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalMaxPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalMaxPool node in the computation graph. Mainly used
// in unit test to make FractionalMaxPool deterministic.
// If not specified, defaults to false
func FractionalMaxPoolDeterministic(value bool) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalMaxPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalMaxPoolSeed(value int64) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalMaxPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalMaxPoolSeed2(value int64) FractionalMaxPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional max pooling on the input.
//
// Fractional max pooling is slightly different than regular max pooling.  In
// regular max pooling, you downsize an input set by taking the maximum value of
// smaller N x N subsections of the set (often 2x2), and try to reduce the set by
// a factor of N, where N is an integer.  Fractional max pooling, as you might
// expect from the word "fractional", means that the overall reduction ratio N
// does not have to be an integer.
//
// The sizes of the pooling regions are generated randomly but are fairly uniform.
// For example, let's look at the height dimension, and the constraints on the
// list of rows that will be pool boundaries.
//
// First we define the following:
//
// 1.  input_row_length : the number of rows from the input set
// 2.  output_row_length : which will be smaller than the input
// 3.  alpha = input_row_length / output_row_length : our reduction ratio
// 4.  K = floor(alpha)
// 5.  row_pooling_sequence : this is the result list of pool boundary rows
//
// Then, row_pooling_sequence should satisfy:
//
// 1.  a[0] = 0 : the first value of the sequence is 0
// 2.  a[end] = input_row_length : the last value of the sequence is the size
// 3.  K <= (a[i+1] - a[i]) <= K+1 : all intervals are K or K+1 size
// 4.  length(row_pooling_sequence) = output_row_length+1
//
// For more details on fractional max pooling, see this paper:
// [Benjamin Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071)
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns output tensor after fractional max pooling.row pooling sequence, needed to calculate gradient.column pooling sequence, needed to calculate gradient.
func FractionalMaxPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalMaxPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalMaxPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Encodes a `RaggedTensor` into a `variant` Tensor.
//
//
// Encodes the given `RaggedTensor` and returns a `variant` Tensor. If
// `batched_input` is True, then input `RaggedTensor` is unbatched along the
// zero-th dimension, each component `RaggedTensor` is encoded into a scalar
// `variant` Tensor, and these are stacked to return a 1-D `variant` Tensor.
// If `batched_input` is False, then the input `RaggedTensor` is encoded as is and
// a scalar `variant` Tensor is returned. A `RaggedTensor` is encoded by first
// creating a 1-D `variant` Tensor with `ragged_rank + 1` elements, containing the
// splits and values Tensors of the `RaggedTensor`. Then the 1-D `variant` Tensor
// is wrapped in a scalar `variant` Tensor. See `RaggedTensorFromVariant` for the
// corresponding decoding logic.
//
//
// Arguments:
//	rt_nested_splits: A list of one or more Tensors representing the splits of the input
// `RaggedTensor`.
//	rt_dense_values: A Tensor representing the values of the input `RaggedTensor`.
//	batched_input: A `bool` denoting whether the input is a batched `RaggedTensor`.
//
// Returns A `variant` Tensor that containing encoded `RaggedTensor`.
func RaggedTensorToVariant(scope *Scope, rt_nested_splits []tf.Output, rt_dense_values tf.Output, batched_input bool) (encoded_ragged tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"batched_input": batched_input}
	opspec := tf.OpSpec{
		Type: "RaggedTensorToVariant",
		Input: []tf.Input{
			tf.OutputList(rt_nested_splits), rt_dense_values,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes rectified linear 6 gradients for a Relu6 operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Relu6 operation.
//	features: The features passed as input to the corresponding Relu6 operation, or
// its output; using either one produces the same result.
//
// Returns The gradients:
// `gradients * (features > 0) * (features < 6)`.
func Relu6Grad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Relu6Grad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringToNumberAttr is an optional argument to StringToNumber.
type StringToNumberAttr func(optionalAttr)

// StringToNumberOutType sets the optional out_type attribute to value.
//
// value: The numeric type to interpret each string in `string_tensor` as.
// If not specified, defaults to DT_FLOAT
func StringToNumberOutType(value tf.DataType) StringToNumberAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Converts each string in the input Tensor to the specified numeric type.
//
// (Note that int32 overflow results in an error while float overflow
// results in a rounded value.)
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToNumber(scope *Scope, string_tensor tf.Output, optional ...StringToNumberAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringToNumber",
		Input: []tf.Input{
			string_tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxArgsAttr is an optional argument to FakeQuantWithMinMaxArgs.
type FakeQuantWithMinMaxArgsAttr func(optionalAttr)

// FakeQuantWithMinMaxArgsMin sets the optional min attribute to value.
// If not specified, defaults to -6
func FakeQuantWithMinMaxArgsMin(value float32) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["min"] = value
	}
}

// FakeQuantWithMinMaxArgsMax sets the optional max attribute to value.
// If not specified, defaults to 6
func FakeQuantWithMinMaxArgsMax(value float32) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["max"] = value
	}
}

// FakeQuantWithMinMaxArgsNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxArgsNumBits(value int64) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxArgsNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxArgsNarrowRange(value bool) FakeQuantWithMinMaxArgsAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Fake-quantize the 'inputs' tensor, type float to 'outputs' tensor of same type.
//
// Attributes `[min; max]` define the clamping range for the `inputs` data.
// `inputs` values are quantized into the quantization range (`[0; 2^num_bits - 1]`
// when `narrow_range` is false and `[1; 2^num_bits - 1]` when it is true) and
// then de-quantized and output as floats in `[min; max]` interval.
// `num_bits` is the bitwidth of the quantization; between 2 and 16, inclusive.
//
// Before quantization, `min` and `max` values are adjusted with the following
// logic.
// It is suggested to have `min <= 0 <= max`. If `0` is not in the range of values,
// the behavior can be unexpected:
// If `0 < min < max`: `min_adj = 0` and `max_adj = max - min`.
// If `min < max < 0`: `min_adj = min - max` and `max_adj = 0`.
// If `min <= 0 <= max`: `scale = (max - min) / (2^num_bits - 1) `,
// `min_adj = scale * round(min / scale)` and `max_adj = max + min_adj - min`.
//
// Quantization is called fake since the output is still in floating point.
func FakeQuantWithMinMaxArgs(scope *Scope, inputs tf.Output, optional ...FakeQuantWithMinMaxArgsAttr) (outputs tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxArgs",
		Input: []tf.Input{
			inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Bucketize each feature based on bucket boundaries.
//
// An op that returns a list of float tensors, where each tensor represents the
// bucketized values for a single feature.
//
// Arguments:
//	float_values: float; List of Rank 1 Tensor each containing float values for a single feature.
//	bucket_boundaries: float; List of Rank 1 Tensors each containing the bucket boundaries for a single
// feature.
//
// Returns int; List of Rank 1 Tensors each containing the bucketized values for a single feature.
func BoostedTreesBucketize(scope *Scope, float_values []tf.Output, bucket_boundaries []tf.Output) (buckets []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesBucketize",
		Input: []tf.Input{
			tf.OutputList(float_values), tf.OutputList(bucket_boundaries),
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if buckets, idx, err = makeOutputList(op, idx, "buckets"); err != nil {
		scope.UpdateErr("BoostedTreesBucketize", err)
		return
	}
	return buckets
}

// ParameterizedTruncatedNormalAttr is an optional argument to ParameterizedTruncatedNormal.
type ParameterizedTruncatedNormalAttr func(optionalAttr)

// ParameterizedTruncatedNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func ParameterizedTruncatedNormalSeed(value int64) ParameterizedTruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// ParameterizedTruncatedNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func ParameterizedTruncatedNormalSeed2(value int64) ParameterizedTruncatedNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a normal distribution. The parameters may each be a
//
// scalar which applies to the entire output, or a vector of length shape[0] which
// stores the parameters for each batch.
//
// Arguments:
//	shape: The shape of the output tensor. Batches are indexed by the 0th dimension.
//	means: The mean parameter of each batch.
//	stdevs: The standard deviation parameter of each batch. Must be greater than 0.
//	minvals: The minimum cutoff. May be -infinity.
//	maxvals: The maximum cutoff. May be +infinity, and must be more than the minval
// for each batch.
//
// Returns A matrix of shape num_batches x samples_per_batch, filled with random
// truncated normal values using the parameters for each row.
func ParameterizedTruncatedNormal(scope *Scope, shape tf.Output, means tf.Output, stdevs tf.Output, minvals tf.Output, maxvals tf.Output, optional ...ParameterizedTruncatedNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParameterizedTruncatedNormal",
		Input: []tf.Input{
			shape, means, stdevs, minvals, maxvals,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes reciprocal of square root of x element-wise.
//
// I.e., \\(y = 1 / \sqrt{x}\\).
func Rsqrt(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Rsqrt",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedDepthwiseConv2DAttr is an optional argument to QuantizedDepthwiseConv2D.
type QuantizedDepthwiseConv2DAttr func(optionalAttr)

// QuantizedDepthwiseConv2DOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QINT32
func QuantizedDepthwiseConv2DOutType(value tf.DataType) QuantizedDepthwiseConv2DAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedDepthwiseConv2DDilations(value []int64) QuantizedDepthwiseConv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes quantized depthwise Conv2D.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	strides: List of stride values.
//
//
// Returns The output tensor.The float value that the minimum quantized output value represents.The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2D(scope *Scope, input tf.Output, filter tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2D",
		Input: []tf.Input{
			input, filter, min_input, max_input, min_filter, max_filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RandomStandardNormalAttr is an optional argument to RandomStandardNormal.
type RandomStandardNormalAttr func(optionalAttr)

// RandomStandardNormalSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomStandardNormalSeed(value int64) RandomStandardNormalAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomStandardNormalSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomStandardNormalSeed2(value int64) RandomStandardNormalAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with random normal values.
func RandomStandardNormal(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...RandomStandardNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomStandardNormal",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Flips all bits elementwise.
//
// The result will have exactly those bits set, that are not set in `x`. The
// computation is performed on the underlying representation of x.
func Invert(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Invert",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingProximalAdagradParametersAttr is an optional argument to RetrieveTPUEmbeddingProximalAdagradParameters.
type RetrieveTPUEmbeddingProximalAdagradParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingProximalAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingProximalAdagradParametersTableId(value int64) RetrieveTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingProximalAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingProximalAdagradParametersTableName(value string) RetrieveTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve proximal Adagrad embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the proximal Adagrad optimization algorithm.Parameter accumulators updated by the proximal Adagrad optimization algorithm.
func RetrieveTPUEmbeddingProximalAdagradParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingProximalAdagradParametersAttr) (parameters tf.Output, accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingProximalAdagradParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// MapUnstageNoKeyAttr is an optional argument to MapUnstageNoKey.
type MapUnstageNoKeyAttr func(optionalAttr)

// MapUnstageNoKeyCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageNoKeyCapacity(value int64) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapUnstageNoKeyMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapUnstageNoKeyMemoryLimit(value int64) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapUnstageNoKeyContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapUnstageNoKeyContainer(value string) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapUnstageNoKeySharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapUnstageNoKeySharedName(value string) MapUnstageNoKeyAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes and returns a random (key, value)
//
// from the underlying container.   If the underlying container
// does not contain elements, the op will block until it does.
func MapUnstageNoKey(scope *Scope, indices tf.Output, dtypes []tf.DataType, optional ...MapUnstageNoKeyAttr) (key tf.Output, values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapUnstageNoKey",
		Input: []tf.Input{
			indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	key = op.Output(idx)
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("MapUnstageNoKey", err)
		return
	}
	return key, values
}

// Computes softplus gradients for a softplus operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding softplus operation.
//	features: The features passed as input to the corresponding softplus operation.
//
// Returns The gradients: `gradients / (1 + exp(-features))`.
func SoftplusGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftplusGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DataFormatVecPermuteAttr is an optional argument to DataFormatVecPermute.
type DataFormatVecPermuteAttr func(optionalAttr)

// DataFormatVecPermuteSrcFormat sets the optional src_format attribute to value.
//
// value: source data format.
// If not specified, defaults to "NHWC"
func DataFormatVecPermuteSrcFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["src_format"] = value
	}
}

// DataFormatVecPermuteDstFormat sets the optional dst_format attribute to value.
//
// value: destination data format.
// If not specified, defaults to "NCHW"
func DataFormatVecPermuteDstFormat(value string) DataFormatVecPermuteAttr {
	return func(m optionalAttr) {
		m["dst_format"] = value
	}
}

// Returns the permuted vector/tensor in the destination data format given the
//
// one in the source data format.
//
// Arguments:
//	x: Vector of size 4 or Tensor of shape (4, 2) in source data format.
//
// Returns Vector of size 4 or Tensor of shape (4, 2) in destination data format.
func DataFormatVecPermute(scope *Scope, x tf.Output, optional ...DataFormatVecPermuteAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DataFormatVecPermute",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gradients for batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. See `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this Tensor will be multiplied
// with the normalized Tensor.
//	backprop: 4D backprop Tensor.
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
//
// Returns 4D backprop tensor for input.1D backprop tensor for mean.1D backprop tensor for variance.1D backprop tensor for beta.1D backprop tensor for gamma.
func BatchNormWithGlobalNormalizationGrad(scope *Scope, t tf.Output, m tf.Output, v tf.Output, gamma tf.Output, backprop tf.Output, variance_epsilon float32, scale_after_normalization bool) (dx tf.Output, dm tf.Output, dv tf.Output, db tf.Output, dg tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalizationGrad",
		Input: []tf.Input{
			t, m, v, gamma, backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// CTCLossAttr is an optional argument to CTCLoss.
type CTCLossAttr func(optionalAttr)

// CTCLossPreprocessCollapseRepeated sets the optional preprocess_collapse_repeated attribute to value.
//
// value: Scalar, if true then repeated labels are
// collapsed prior to the CTC calculation.
// If not specified, defaults to false
func CTCLossPreprocessCollapseRepeated(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["preprocess_collapse_repeated"] = value
	}
}

// CTCLossCtcMergeRepeated sets the optional ctc_merge_repeated attribute to value.
//
// value: Scalar.  If set to false, *during* CTC calculation
// repeated non-blank labels will not be merged and are interpreted as
// individual labels.  This is a simplified version of CTC.
// If not specified, defaults to true
func CTCLossCtcMergeRepeated(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["ctc_merge_repeated"] = value
	}
}

// CTCLossIgnoreLongerOutputsThanInputs sets the optional ignore_longer_outputs_than_inputs attribute to value.
//
// value: Scalar. If set to true, during CTC
// calculation, items that have longer output sequences than input sequences
// are skipped: they don't contribute to the loss term and have zero-gradient.
// If not specified, defaults to false
func CTCLossIgnoreLongerOutputsThanInputs(value bool) CTCLossAttr {
	return func(m optionalAttr) {
		m["ignore_longer_outputs_than_inputs"] = value
	}
}

// Calculates the CTC Loss (log probability) for each batch entry.  Also calculates
//
// the gradient.  This class performs the softmax operation for you, so inputs
// should be e.g. linear projections of outputs by an LSTM.
//
// Arguments:
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	labels_indices: The indices of a `SparseTensor<int32, 2>`.
// `labels_indices(i, :) == [b, t]` means `labels_values(i)` stores the id for
// `(batch b, time t)`.
//	labels_values: The values (labels) associated with the given batch and time.
//	sequence_length: A vector containing sequence lengths (batch).
//
// Returns A vector (batch) containing log-probabilities.The gradient of `loss`.  3-D, shape:
// `(max_time x batch_size x num_classes)`.
func CTCLoss(scope *Scope, inputs tf.Output, labels_indices tf.Output, labels_values tf.Output, sequence_length tf.Output, optional ...CTCLossAttr) (loss tf.Output, gradient tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCLoss",
		Input: []tf.Input{
			inputs, labels_indices, labels_values, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Restore a Reader to its initial clean state.
//
// Arguments:
//	reader_handle: Handle to a Reader.
//
// Returns the created operation.
func ReaderResetV2(scope *Scope, reader_handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReaderResetV2",
		Input: []tf.Input{
			reader_handle,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes rectified linear gradients for a Relu operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding Relu operation.
//	features: The features passed as input to the corresponding Relu operation, OR
// the outputs of that operation (both work equivalently).
//
// Returns `gradients * (features > 0)`.
func ReluGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReluGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Elementwise computes the bitwise XOR of `x` and `y`.
//
// The result will have those bits set, that are different in `x` and `y`. The
// computation is performed on the underlying representations of `x` and `y`.
func BitwiseXor(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BitwiseXor",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMatMulWithBiasAndReluAndRequantizeAttr is an optional argument to QuantizedMatMulWithBiasAndReluAndRequantize.
type QuantizedMatMulWithBiasAndReluAndRequantizeAttr func(optionalAttr)

// QuantizedMatMulWithBiasAndReluAndRequantizeToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedMatMulWithBiasAndReluAndRequantizeToutput(value tf.DataType) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluAndRequantizeTransposeA(value bool) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluAndRequantizeTransposeB(value bool) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasAndReluAndRequantizeInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasAndReluAndRequantizeInputQuantMode(value string) QuantizedMatMulWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Perform a quantized matrix multiplication of  `a` by the matrix `b` with bias
// add and relu and requantize fusion.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// mulplication result. The bias size must match inner dimension of `b`.  Then do
// relu activation to get non-negative result. Then do requantize operation to get
// final uint8 result.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching with inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//	min_freezed_output: The float value that the highest quantized output value after requantize.
//
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedMatMulWithBiasAndReluAndRequantize(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, min_freezed_output tf.Output, max_freezed_output tf.Output, optional ...QuantizedMatMulWithBiasAndReluAndRequantizeAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBiasAndReluAndRequantize",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b, min_freezed_output, max_freezed_output,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Advance the counter of a counter-based RNG.
//
// The state of the RNG after
// `rng_skip(n)` will be the same as that after `stateful_uniform([n])`
// (or any other distribution). The actual increment added to the
// counter is an unspecified implementation detail.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	delta: The amount of advancement.
//
// Returns the created operation.
func RngSkip(scope *Scope, resource tf.Output, algorithm tf.Output, delta tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RngSkip",
		Input: []tf.Input{
			resource, algorithm, delta,
		},
	}
	return scope.AddOperation(opspec)
}

// Produces the max pool of the input tensor for quantized types.
//
// Arguments:
//	input: The 4D (batch x rows x cols x depth) Tensor to MaxReduce over.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	ksize: The size of the window for each dimension of the input tensor.
// The length must be 4 to match the number of dimensions of the input.
//	strides: The stride of the sliding window for each dimension of the input
// tensor. The length must be 4 to match the number of dimensions of the input.
//	padding: The type of padding algorithm to use.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedMaxPool(scope *Scope, input tf.Output, min_input tf.Output, max_input tf.Output, ksize []int64, strides []int64, padding string) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "QuantizedMaxPool",
		Input: []tf.Input{
			input, min_input, max_input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Outputs random integers from a uniform distribution.
//
// The generated values are uniform integers in the range `[minval, maxval)`.
// The lower bound `minval` is included in the range, while the upper bound
// `maxval` is excluded.
//
// The random integers are slightly biased unless `maxval - minval` is an exact
// power of two.  The bias is small for values of `maxval - minval` significantly
// smaller than the range of the output (either `2^32` or `2^64`).
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//	minval: Minimum value (inclusive, scalar).
//	maxval: Maximum value (exclusive, scalar).
//
// Returns Random values with specified shape.
func StatefulUniformInt(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, minval tf.Output, maxval tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatefulUniformInt",
		Input: []tf.Input{
			resource, algorithm, shape, minval, maxval,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingADAMParametersGradAccumDebug.
type RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingADAMParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve ADAM embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the ADAM optimization algorithm.Parameter momenta updated by the ADAM optimization algorithm.Parameter velocities updated by the ADAM optimization algorithm.Parameter gradient_accumulators updated by the ADAM optimization algorithm.
func RetrieveTPUEmbeddingADAMParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingADAMParametersGradAccumDebugAttr) (parameters tf.Output, momenta tf.Output, velocities tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingADAMParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// MutexV2Attr is an optional argument to MutexV2.
type MutexV2Attr func(optionalAttr)

// MutexV2Container sets the optional container attribute to value.
//
// value: If non-empty, this variable is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func MutexV2Container(value string) MutexV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MutexV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this variable is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func MutexV2SharedName(value string) MutexV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a Mutex resource that can be locked by `MutexLock`.
//
// Returns The mutex resource.
func MutexV2(scope *Scope, optional ...MutexV2Attr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MutexV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Updates the tree ensemble by either adding a layer to the last tree being grown
//
// or by starting a new tree.
//
// Arguments:
//	tree_ensemble_handle: Handle to the ensemble variable.
//	feature_ids: Rank 1 tensor with ids for each feature. This is the real id of
// the feature that will be used in the split.
//	node_ids: List of rank 1 tensors representing the nodes for which this feature
// has a split.
//	gains: List of rank 1 tensors representing the gains for each of the feature's
// split.
//	thresholds: List of rank 1 tensors representing the thesholds for each of the
// feature's split.
//	left_node_contribs: List of rank 2 tensors with left leaf contribs for each of
// the feature's splits. Will be added to the previous node values to constitute
// the values of the left nodes.
//	right_node_contribs: List of rank 2 tensors with right leaf contribs for each
// of the feature's splits. Will be added to the previous node values to constitute
// the values of the right nodes.
//	max_depth: Max depth of the tree to build.
//	learning_rate: shrinkage const for each new tree.
//	pruning_mode: 0-No pruning, 1-Pre-pruning, 2-Post-pruning.
//
// Returns the created operation.
func BoostedTreesUpdateEnsemble(scope *Scope, tree_ensemble_handle tf.Output, feature_ids tf.Output, node_ids []tf.Output, gains []tf.Output, thresholds []tf.Output, left_node_contribs []tf.Output, right_node_contribs []tf.Output, max_depth tf.Output, learning_rate tf.Output, pruning_mode int64) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pruning_mode": pruning_mode}
	opspec := tf.OpSpec{
		Type: "BoostedTreesUpdateEnsemble",
		Input: []tf.Input{
			tree_ensemble_handle, feature_ids, tf.OutputList(node_ids), tf.OutputList(gains), tf.OutputList(thresholds), tf.OutputList(left_node_contribs), tf.OutputList(right_node_contribs), max_depth, learning_rate,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Reduces sparse updates into the variable referenced by `resource` using the `min` operation.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = min(ref[indices, ...], updates[...])
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = min(ref[indices[i], ...], updates[i, ...])
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = min(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions are combined.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterMin(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterMin",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Multiplies sparse updates into the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] *= updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] *= updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] *= updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions multiply.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterMul(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterMul",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Subtracts sparse updates from the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] -= updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] -= updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] -= updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions add.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterSub(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterSub",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Adds sparse updates to the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] += updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] += updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] += updates[i, ..., j, ...]
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions add.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterAdd(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterAdd",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// Convert the quantized 'input' tensor into a lower-precision 'output', using the
//
// actual distribution of the values to maximize the usage of the lower bit depth
// and adjusting the output min and max ranges accordingly.
//
// [input_min, input_max] are scalar floats that specify the range for the float
// interpretation of the 'input' data. For example, if input_min is -1.0f and
// input_max is 1.0f, and we are dealing with quint16 quantized data, then a 0
// value in the 16-bit data should be interpreted as -1.0f, and a 65535 means 1.0f.
//
// This operator tries to squeeze as much precision as possible into an output with
// a lower bit depth by calculating the actual min and max values found in the
// data. For example, maybe that quint16 input has no values lower than 16,384 and
// none higher than 49,152. That means only half the range is actually needed, all
// the float interpretations are between -0.5f and 0.5f, so if we want to compress
// the data into a quint8 output, we can use that range rather than the theoretical
// -1.0f to 1.0f that is suggested by the input min and max.
//
// In practice, this is most useful for taking output from operations like
// QuantizedMatMul that can produce higher bit-depth outputs than their inputs and
// may have large potential output ranges, but in practice have a distribution of
// input values that only uses a small fraction of the possible range. By feeding
// that output into this operator, we can reduce it from 32 bits down to 8 with
// minimal loss of accuracy.
//
// Arguments:
//
//	input_min: The float value that the minimum quantized input value represents.
//	input_max: The float value that the maximum quantized input value represents.
//	out_type: The type of the output. Should be a lower bit depth than Tinput.
//
// Returns The float value that the minimum quantized output value represents.The float value that the maximum quantized output value represents.
func QuantizeDownAndShrinkRange(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, out_type tf.DataType) (output tf.Output, output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "QuantizeDownAndShrinkRange",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Says whether the targets are in the top `K` predictions.
//
// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
// prediction for the target class is among the top `k` predictions among
// all predictions for example `i`. Note that the behavior of `InTopK` differs
// from the `TopK` op in its handling of ties; if multiple classes have the
// same prediction value and straddle the top-`k` boundary, all of those
// classes are considered to be in the top `k`.
//
// More formally, let
//
//   \\(predictions_i\\) be the predictions for all classes for example `i`,
//   \\(targets_i\\) be the target class for example `i`,
//   \\(out_i\\) be the output for example `i`,
//
// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
//
// Arguments:
//	predictions: A `batch_size` x `classes` tensor.
//	targets: A `batch_size` vector of class ids.
//	k: Number of top elements to look at for computing precision.
//
// Returns Computed precision at `k` as a `bool Tensor`.
func InTopKV2(scope *Scope, predictions tf.Output, targets tf.Output, k tf.Output) (precision tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InTopKV2",
		Input: []tf.Input{
			predictions, targets, k,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LeakyReluAttr is an optional argument to LeakyRelu.
type LeakyReluAttr func(optionalAttr)

// LeakyReluAlpha sets the optional alpha attribute to value.
// If not specified, defaults to 0.2
func LeakyReluAlpha(value float32) LeakyReluAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// Computes rectified linear: `max(features, features * alpha)`.
func LeakyRelu(scope *Scope, features tf.Output, optional ...LeakyReluAttr) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LeakyRelu",
		Input: []tf.Input{
			features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPool3DGradAttr is an optional argument to AvgPool3DGrad.
type AvgPool3DGradAttr func(optionalAttr)

// AvgPool3DGradDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func AvgPool3DGradDataFormat(value string) AvgPool3DGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of average pooling function.
//
// Arguments:
//	orig_input_shape: The original input dimensions.
//	grad: Output backprop of shape `[batch, depth, rows, cols, channels]`.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The backprop for input.
func AvgPool3DGrad(scope *Scope, orig_input_shape tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPool3DGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool3DGrad",
		Input: []tf.Input{
			orig_input_shape, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BiasAddAttr is an optional argument to BiasAdd.
type BiasAddAttr func(optionalAttr)

// BiasAddDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the bias tensor will be added to the last dimension
// of the value tensor.
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// The tensor will be added to "in_channels", the third-to-the-last
//     dimension.
// If not specified, defaults to "NHWC"
func BiasAddDataFormat(value string) BiasAddAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Adds `bias` to `value`.
//
// This is a special case of `tf.add` where `bias` is restricted to be 1-D.
// Broadcasting is supported, so `value` may have any number of dimensions.
//
// Arguments:
//	value: Any number of dimensions.
//	bias: 1-D with size the last dimension of `value`.
//
// Returns Broadcasted sum of `value` and `bias`.
func BiasAdd(scope *Scope, value tf.Output, bias tf.Output, optional ...BiasAddAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BiasAdd",
		Input: []tf.Input{
			value, bias,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TryRpcAttr is an optional argument to TryRpc.
type TryRpcAttr func(optionalAttr)

// TryRpcProtocol sets the optional protocol attribute to value.
//
// value: RPC protocol to use.  Empty string means use the default protocol.
// Options include 'grpc'.
// If not specified, defaults to ""
func TryRpcProtocol(value string) TryRpcAttr {
	return func(m optionalAttr) {
		m["protocol"] = value
	}
}

// TryRpcFailFast sets the optional fail_fast attribute to value.
//
// value: `boolean`. If `true` (default), then failures to connect
// (i.e., the server does not immediately respond) cause an RPC failure.
// If not specified, defaults to true
func TryRpcFailFast(value bool) TryRpcAttr {
	return func(m optionalAttr) {
		m["fail_fast"] = value
	}
}

// TryRpcTimeoutInMs sets the optional timeout_in_ms attribute to value.
//
// value: `int`. If `0` (default), then the kernel will run the RPC
// request and only time out if the RPC deadline passes or the session times out.
// If this value is greater than `0`, then the op will raise an exception if
// the RPC takes longer than `timeout_in_ms`.
// If not specified, defaults to 0
func TryRpcTimeoutInMs(value int64) TryRpcAttr {
	return func(m optionalAttr) {
		m["timeout_in_ms"] = value
	}
}

// Perform batches of RPC requests.
//
// This op asynchronously performs either a single RPC request, or a batch
// of requests.  RPC requests are defined by three main parameters:
//
//   - `address` (the host+port or BNS address of the request)
//   - `method` (the method name for the request)
//   - `request` (the serialized proto string, or vector of strings,
//      of the RPC request argument).
//
// For example, if you have an RPC service running on port localhost:2345,
// and its interface is configured with the following proto declaration:
//
// ```
// service MyService {
//   rpc MyMethod(MyRequestProto) returns (MyResponseProto) {
//   }
// };
// ```
//
// then call this op with arguments:
//
// ```
// address = "localhost:2345"
// method = "MyService/MyMethod"
// ```
//
// The `request` tensor is a string tensor representing serialized `MyRequestProto`
// strings; and the output string tensor `response` will have the same shape
// and contain (upon successful completion) corresponding serialized
// `MyResponseProto` strings.
//
// For example, to send a single, empty, `MyRequestProto`, call
// this op with `request = ""`.  To send 5 **parallel** empty requests,
// call this op with `request = ["", "", "", "", ""]`.
//
// More generally, one can create a batch of `MyRequestProto` serialized protos
// from regular batched tensors using the `encode_proto` op, and convert
// the response `MyResponseProto` serialized protos to batched tensors
// using the `decode_proto` op.
//
// **NOTE** Working with serialized proto strings is faster than instantiating
// actual proto objects in memory, so no performance degradation is expected
// compared to writing custom kernels for this workflow.
//
// Unlike the standard `Rpc` op, if the connection fails or the remote worker
// returns an error status, this op does **not** reraise the exception.
// Instead, the `status_code` and `status_message` entry for the corresponding RPC
// call is set with the error returned from the RPC call.  The `response` tensor
// will contain valid response values for those minibatch entries whose RPCs did
// not fail; the rest of the entries will have empty strings.
//
// Arguments:
//	address: `0-D` or `1-D`.  The address (i.e. host_name:port) of the RPC server.
// If this tensor has more than 1 element, then multiple parallel rpc requests
// are sent.  This argument broadcasts with `method` and `request`.
//	method: `0-D` or `1-D`.  The method address on the RPC server.
// If this tensor has more than 1 element, then multiple parallel rpc requests
// are sent.  This argument broadcasts with `address` and `request`.
//	request: `0-D` or `1-D`.  Serialized proto strings: the rpc request argument.
// If this tensor has more than 1 element, then multiple parallel rpc requests
// are sent.  This argument broadcasts with `address` and `method`.
//
// Returns Same shape as `request`. Serialized proto strings: the rpc responses.Same shape as `request`.  Values correspond to tensorflow Status enum codes.Same shape as `request`.  Values correspond to Status messages
// returned from the RPC calls.
func TryRpc(scope *Scope, address tf.Output, method tf.Output, request tf.Output, optional ...TryRpcAttr) (response tf.Output, status_code tf.Output, status_message tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TryRpc",
		Input: []tf.Input{
			address, method, request,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RpcAttr is an optional argument to Rpc.
type RpcAttr func(optionalAttr)

// RpcProtocol sets the optional protocol attribute to value.
//
// value: RPC protocol to use.  Empty string means use the default protocol.
// Options include 'grpc'.
// If not specified, defaults to ""
func RpcProtocol(value string) RpcAttr {
	return func(m optionalAttr) {
		m["protocol"] = value
	}
}

// RpcFailFast sets the optional fail_fast attribute to value.
//
// value: `boolean`. If `true` (default), then failures to connect
// (i.e., the server does not immediately respond) cause an RPC failure.
// If not specified, defaults to true
func RpcFailFast(value bool) RpcAttr {
	return func(m optionalAttr) {
		m["fail_fast"] = value
	}
}

// RpcTimeoutInMs sets the optional timeout_in_ms attribute to value.
//
// value: `int`. If `0` (default), then the kernel will run the RPC
// request and only time out if the RPC deadline passes or the session times out.
// If this value is greater than `0`, then the op will raise an exception if
// the RPC takes longer than `timeout_in_ms`.
// If not specified, defaults to 0
func RpcTimeoutInMs(value int64) RpcAttr {
	return func(m optionalAttr) {
		m["timeout_in_ms"] = value
	}
}

// Perform batches of RPC requests.
//
// This op asynchronously performs either a single RPC request, or a batch
// of requests.  RPC requests are defined by three main parameters:
//
//   - `address` (the host+port or BNS address of the request)
//   - `method` (the RPC method name for the request)
//   - `request` (the serialized proto string, or vector of strings,
//      of the RPC request argument).
//
// For example, if you have an RPC service running on port localhost:2345,
// and its interface is configured with the following proto declaration:
//
// ```
// service MyService {
//   rpc MyMethod(MyRequestProto) returns (MyResponseProto) {
//   }
// };
// ```
//
// then call this op with arguments:
//
// ```
// address = "localhost:2345"
// method = "MyService/MyMethod"
// ```
//
// The `request` tensor is a string tensor representing serialized `MyRequestProto`
// strings; and the output string tensor `response` will have the same shape
// and contain (upon successful completion) corresponding serialized
// `MyResponseProto` strings.
//
// For example, to send a single, empty, `MyRequestProto`, call
// this op with `request = ""`.  To send 5 **parallel** empty requests,
// call this op with `request = ["", "", "", "", ""]`.
//
// More generally, one can create a batch of `MyRequestProto` serialized protos
// from regular batched tensors using the `encode_proto` op, and convert
// the response `MyResponseProto` serialized protos to batched tensors
// using the `decode_proto` op.
//
// **NOTE** Working with serialized proto strings is faster than instantiating
// actual proto objects in memory, so no performance degradation is expected
// compared to writing custom kernels for this workflow.
//
// If the connection fails or the remote worker returns an error
// status, the op reraises this exception locally.
//
// See the `TryRpc` op if you prefer to handle RPC failures manually in the graph.
//
// Arguments:
//	address: `0-D` or `1-D`.  The address (i.e. host_name:port) of the RPC server.
// If this tensor has more than 1 element, then multiple parallel rpc requests
// are sent.  This argument broadcasts with `method` and `request`.
//	method: `0-D` or `1-D`.  The method address on the RPC server.
// If this tensor has more than 1 element, then multiple parallel rpc requests
// are sent.  This argument broadcasts with `address` and `request`.
//	request: `0-D` or `1-D`.  Serialized proto strings: the rpc request argument.
// If this tensor has more than 1 element, then multiple parallel rpc requests
// are sent.  This argument broadcasts with `address` and `method`.
//
// Returns Same shape as `request`. Serialized proto strings: the rpc responses.
func Rpc(scope *Scope, address tf.Output, method tf.Output, request tf.Output, optional ...RpcAttr) (response tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Rpc",
		Input: []tf.Input{
			address, method, request,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Worker heartbeat op.
//
// Heartbeats may be sent periodically to indicate the coordinator is still active,
// to retrieve the current worker status and to expedite shutdown when necessary.
//
// Arguments:
//	request: A string tensor containing a serialized WorkerHeartbeatRequest
//
// Returns A string tensor containing a serialized WorkerHeartbeatResponse
func WorkerHeartbeat(scope *Scope, request tf.Output) (response tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WorkerHeartbeat",
		Input: []tf.Input{
			request,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// L2 Loss.
//
// Computes half the L2 norm of a tensor without the `sqrt`:
//
//     output = sum(t ** 2) / 2
//
// Arguments:
//	t: Typically 2-D, but may have any dimensions.
//
// Returns 0-D.
func L2Loss(scope *Scope, t tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "L2Loss",
		Input: []tf.Input{
			t,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMatMulWithBiasAttr is an optional argument to QuantizedMatMulWithBias.
type QuantizedMatMulWithBiasAttr func(optionalAttr)

// QuantizedMatMulWithBiasToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMatMulWithBiasToutput(value tf.DataType) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasTransposeA(value bool) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasTransposeB(value bool) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasInputQuantMode(value string) QuantizedMatMulWithBiasAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Performs a quantized matrix multiplication of `a` by the matrix `b` with bias
// add.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// mulplication result. The bias size must match inner dimension of `b`.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedMatMulWithBias(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, optional ...QuantizedMatMulWithBiasAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBias",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Says whether the targets are in the top `K` predictions.
//
// This outputs a `batch_size` bool array, an entry `out[i]` is `true` if the
// prediction for the target class is among the top `k` predictions among
// all predictions for example `i`. Note that the behavior of `InTopK` differs
// from the `TopK` op in its handling of ties; if multiple classes have the
// same prediction value and straddle the top-`k` boundary, all of those
// classes are considered to be in the top `k`.
//
// More formally, let
//
//   \\(predictions_i\\) be the predictions for all classes for example `i`,
//   \\(targets_i\\) be the target class for example `i`,
//   \\(out_i\\) be the output for example `i`,
//
// $$out_i = predictions_{i, targets_i} \in TopKIncludingTies(predictions_i)$$
//
// Arguments:
//	predictions: A `batch_size` x `classes` tensor.
//	targets: A `batch_size` vector of class ids.
//	k: Number of top elements to look at for computing precision.
//
// Returns Computed Precision at `k` as a `bool Tensor`.
func InTopK(scope *Scope, predictions tf.Output, targets tf.Output, k int64) (precision tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	opspec := tf.OpSpec{
		Type: "InTopK",
		Input: []tf.Input{
			predictions, targets,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Eagerly executes a python function to compute func(input)->output. The
//
// semantics of the input, output, and attributes are the same as those for
// PyFunc.
func EagerPyFunc(scope *Scope, input []tf.Output, token string, Tout []tf.DataType) (output []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"token": token, "Tout": Tout}
	opspec := tf.OpSpec{
		Type: "EagerPyFunc",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output, idx, err = makeOutputList(op, idx, "output"); err != nil {
		scope.UpdateErr("EagerPyFunc", err)
		return
	}
	return output
}

// ResourceApplyRMSPropAttr is an optional argument to ResourceApplyRMSProp.
type ResourceApplyRMSPropAttr func(optionalAttr)

// ResourceApplyRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, ms, and mom tensors is protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyRMSPropUseLocking(value bool) ResourceApplyRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the RMSProp algorithm.
//
// Note that in dense implementation of this algorithm, ms and mom will
// update even if the grad is zero, but in this sparse implementation, ms
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon)
//
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyRMSProp(scope *Scope, var_ tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyRMSProp",
		Input: []tf.Input{
			var_, ms, mom, lr, rho, momentum, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Returns the truth value of (x <= y) element-wise.
//
// *NOTE*: `LessEqual` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LessEqual(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LessEqual",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gather ragged slices from `params` axis `0` according to `indices`.
//
// Outputs a `RaggedTensor` output composed from `output_dense_values` and
// `output_nested_splits`, such that:
//
// ```python
// output.shape = indices.shape + params.shape[1:]
// output.ragged_rank = indices.shape.ndims + params.ragged_rank
// output[i...j, d0...dn] = params[indices[i...j], d0...dn]
// ```
//
// where
//
// * `params =
//    ragged.from_nested_row_splits(params_dense_values, params_nested_splits)`
//    provides the values that should be gathered.
// * `indices` ia a dense tensor with dtype `int32` or `int64`, indicating which
//    values should be gathered.
// * `output =
//    ragged.from_nested_row_splits(output_dense_values, output_nested_splits)`
//    is the output tensor.
//
// (Note: This c++ op is used to implement the higher-level python
// `tf.ragged.gather` op, which also supports ragged indices.)
//
//
// Arguments:
//	params_nested_splits: The `nested_row_splits` tensors that define the row-partitioning for the
// `params` RaggedTensor input.
//	params_dense_values: The `flat_values` for the `params` RaggedTensor. There was a terminology change
// at the python level from dense_values to flat_values, so dense_values is the
// deprecated name.
//	indices: Indices in the outermost dimension of `params` of the values that should be
// gathered.
//	OUTPUT_RAGGED_RANK: The ragged rank of the output RaggedTensor. `output_nested_splits` will contain
// this number of `row_splits` tensors. This value should equal
// `indices.shape.ndims + params.ragged_rank - 1`.
//
// Returns The `nested_row_splits` tensors that define the row-partitioning for the
// returned RaggedTensor.The `flat_values` for the returned RaggedTensor.
func RaggedGather(scope *Scope, params_nested_splits []tf.Output, params_dense_values tf.Output, indices tf.Output, OUTPUT_RAGGED_RANK int64) (output_nested_splits []tf.Output, output_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"OUTPUT_RAGGED_RANK": OUTPUT_RAGGED_RANK}
	opspec := tf.OpSpec{
		Type: "RaggedGather",
		Input: []tf.Input{
			tf.OutputList(params_nested_splits), params_dense_values, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_nested_splits, idx, err = makeOutputList(op, idx, "output_nested_splits"); err != nil {
		scope.UpdateErr("RaggedGather", err)
		return
	}
	output_dense_values = op.Output(idx)
	return output_nested_splits, output_dense_values
}

// Applies sparse addition to `input` using individual values or slices
//
// from `updates` according to indices `indices`.  The updates are non-aliasing:
// `input` is only modified in-place if no other operations will use it.
// Otherwise, a copy of `input` is made.  This operation has a gradient with
// respect to both `input` and `updates`.
//
// `input` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `input`.
// It must be shape \\([d_0, ..., d_{Q-2}, K]\\) where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or `(P-K)`-dimensional slices
// (if `K < P`) along the `K`th dimension of `input`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// $$[d_0, ..., d_{Q-2}, input.shape[K], ..., input.shape[P-1]].$$
//
// For example, say we want to add 4 scattered elements to a rank-1 tensor to 8
// elements. In Python, that addition would look like this:
//
//     input = tf.constant([1, 2, 3, 4, 5, 6, 7, 8])
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     output = tf.scatter_nd_non_aliasing_add(input, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(output))
//
// The resulting value `output` would look like this:
//
//     [1, 13, 3, 14, 14, 6, 7, 20]
//
// See `tf.scatter_nd` for more details about how to make updates to slices.
//
// Arguments:
//	input: A Tensor.
//	indices: A Tensor. Must be one of the following types: `int32`, `int64`.
// A tensor of indices into `input`.
//	updates: A Tensor. Must have the same type as ref. A tensor of updated values
// to add to `input`.
//
// Returns A `Tensor` with the same shape as `input`, containing values of `input`
// updated with `updates`.
func ScatterNdNonAliasingAdd(scope *Scope, input tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ScatterNdNonAliasingAdd",
		Input: []tf.Input{
			input, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringSplitV2Attr is an optional argument to StringSplitV2.
type StringSplitV2Attr func(optionalAttr)

// StringSplitV2Maxsplit sets the optional maxsplit attribute to value.
//
// value: An `int`. If `maxsplit > 0`, limit of the split of the result.
// If not specified, defaults to -1
func StringSplitV2Maxsplit(value int64) StringSplitV2Attr {
	return func(m optionalAttr) {
		m["maxsplit"] = value
	}
}

// Split elements of `source` based on `sep` into a `SparseTensor`.
//
// Let N be the size of source (typically N will be the batch size). Split each
// element of `source` based on `sep` and return a `SparseTensor`
// containing the split tokens. Empty tokens are ignored.
//
// For example, N = 2, source[0] is 'hello world' and source[1] is 'a b c',
// then the output will be
// ```
// st.indices = [0, 0;
//               0, 1;
//               1, 0;
//               1, 1;
//               1, 2]
// st.shape = [2, 3]
// st.values = ['hello', 'world', 'a', 'b', 'c']
// ```
//
// If `sep` is given, consecutive delimiters are not grouped together and are
// deemed to delimit empty strings. For example, source of `"1<>2<><>3"` and
// sep of `"<>"` returns `["1", "2", "", "3"]`. If `sep` is None or an empty
// string, consecutive whitespace are regarded as a single separator, and the
// result will contain no empty strings at the startor end if the string has
// leading or trailing whitespace.
//
// Note that the above mentioned behavior matches python's str.split.
//
// Arguments:
//	input: `1-D` string `Tensor`, the strings to split.
//	sep: `0-D` string `Tensor`, the delimiter character.
func StringSplitV2(scope *Scope, input tf.Output, sep tf.Output, optional ...StringSplitV2Attr) (indices tf.Output, values tf.Output, shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringSplitV2",
		Input: []tf.Input{
			input, sep,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Saves input tensors slices to disk.
//
// This is like `Save` except that tensors can be listed in the saved file as being
// a slice of a larger tensor.  `shapes_and_slices` specifies the shape of the
// larger tensor and the slice that this tensor covers. `shapes_and_slices` must
// have as many elements as `tensor_names`.
//
// Elements of the `shapes_and_slices` input must either be:
//
// *  The empty string, in which case the corresponding tensor is
//    saved normally.
// *  A string of the form `dim0 dim1 ... dimN-1 slice-spec` where the
//    `dimI` are the dimensions of the larger tensor and `slice-spec`
//    specifies what part is covered by the tensor to save.
//
// `slice-spec` itself is a `:`-separated list: `slice0:slice1:...:sliceN-1`
// where each `sliceI` is either:
//
// *  The string `-` meaning that the slice covers all indices of this dimension
// *  `start,length` where `start` and `length` are integers.  In that
//    case the slice covers `length` indices starting at `start`.
//
// See also `Save`.
//
// Arguments:
//	filename: Must have a single element. The name of the file to which we write the
// tensor.
//	tensor_names: Shape `[N]`. The names of the tensors to be saved.
//	shapes_and_slices: Shape `[N]`.  The shapes and slice specifications to use when
// saving the tensors.
//	data: `N` tensors to save.
//
// Returns the created operation.
func SaveSlices(scope *Scope, filename tf.Output, tensor_names tf.Output, shapes_and_slices tf.Output, data []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SaveSlices",
		Input: []tf.Input{
			filename, tensor_names, shapes_and_slices, tf.OutputList(data),
		},
	}
	return scope.AddOperation(opspec)
}

// Forwards the value of an available tensor from `inputs` to `output`.
//
// `Merge` waits for at least one of the tensors in `inputs` to become available.
// It is usually combined with `Switch` to implement branching.
//
// `Merge` forwards the first tensor to become available to `output`, and sets
// `value_index` to its index in `inputs`.
//
// Arguments:
//	inputs: The input tensors, exactly one of which will become available.
//
// Returns Will be set to the available input tensor.The index of the chosen input tensor in `inputs`.
func Merge(scope *Scope, inputs []tf.Output) (output tf.Output, value_index tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Merge",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// RetrieveTPUEmbeddingCenteredRMSPropParametersAttr is an optional argument to RetrieveTPUEmbeddingCenteredRMSPropParameters.
type RetrieveTPUEmbeddingCenteredRMSPropParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingCenteredRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingCenteredRMSPropParametersTableId(value int64) RetrieveTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingCenteredRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingCenteredRMSPropParametersTableName(value string) RetrieveTPUEmbeddingCenteredRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve centered RMSProp embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the centered RMSProp optimization algorithm.Parameter ms updated by the centered RMSProp optimization algorithm.Parameter mom updated by the centered RMSProp optimization algorithm.Parameter mg updated by the centered RMSProp optimization algorithm.
func RetrieveTPUEmbeddingCenteredRMSPropParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingCenteredRMSPropParametersAttr) (parameters tf.Output, ms tf.Output, mom tf.Output, mg tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingCenteredRMSPropParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// SetSizeAttr is an optional argument to SetSize.
type SetSizeAttr func(optionalAttr)

// SetSizeValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func SetSizeValidateIndices(value bool) SetSizeAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Number of unique elements along last dimension of input `set`.
//
// Input `set` is a `SparseTensor` represented by `set_indices`, `set_values`,
// and `set_shape`. The last dimension contains values in a set, duplicates are
// allowed but ignored.
//
// If `validate_indices` is `True`, this op validates the order and range of `set`
// indices.
//
// Arguments:
//	set_indices: 2D `Tensor`, indices of a `SparseTensor`.
//	set_values: 1D `Tensor`, values of a `SparseTensor`.
//	set_shape: 1D `Tensor`, shape of a `SparseTensor`.
//
// Returns For `set` ranked `n`, this is a `Tensor` with rank `n-1`, and the same 1st
// `n-1` dimensions as `set`. Each value is the number of unique elements in
// the corresponding `[0...n-1]` dimension of `set`.
func SetSize(scope *Scope, set_indices tf.Output, set_values tf.Output, set_shape tf.Output, optional ...SetSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SetSize",
		Input: []tf.Input{
			set_indices, set_values, set_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a serialized tensorflow.TensorProto proto into a Tensor.
//
// Arguments:
//	serialized: A scalar string containing a serialized TensorProto proto.
//	out_type: The type of the serialized tensor.  The provided type must match the
// type of the serialized tensor and no implicit conversion will take place.
//
// Returns A Tensor of type `out_type`.
func ParseTensor(scope *Scope, serialized tf.Output, out_type tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	opspec := tf.OpSpec{
		Type: "ParseTensor",
		Input: []tf.Input{
			serialized,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Checks whether a quantile stream has been initialized.
//
// An Op that checks if quantile stream resource is initialized.
//
// Arguments:
//	quantile_stream_resource_handle: resource; The reference to quantile stream resource handle.
//
// Returns bool; True if the resource is initialized, False otherwise.
func IsBoostedTreesQuantileStreamResourceInitialized(scope *Scope, quantile_stream_resource_handle tf.Output) (is_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsBoostedTreesQuantileStreamResourceInitialized",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the element-wise max of two SparseTensors.
//
// Assumes the two SparseTensors have the same shape, i.e., no broadcasting.
//
// Arguments:
//	a_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, in the canonical lexicographic ordering.
//	a_values: 1-D.  `N` non-empty values corresponding to `a_indices`.
//	a_shape: 1-D.  Shape of the input SparseTensor.
//	b_indices: counterpart to `a_indices` for the other operand.
//	b_values: counterpart to `a_values` for the other operand; must be of the same dtype.
//	b_shape: counterpart to `a_shape` for the other operand; the two shapes must be equal.
//
// Returns 2-D.  The indices of the output SparseTensor.1-D.  The values of the output SparseTensor.
func SparseSparseMaximum(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b_indices tf.Output, b_values tf.Output, b_shape tf.Output) (output_indices tf.Output, output_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSparseMaximum",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b_indices, b_values, b_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Computes the derivative of a Gamma random sample w.r.t. `alpha`.
func RandomGammaGrad(scope *Scope, alpha tf.Output, sample tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RandomGammaGrad",
		Input: []tf.Input{
			alpha, sample,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AvgPool3DAttr is an optional argument to AvgPool3D.
type AvgPool3DAttr func(optionalAttr)

// AvgPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func AvgPool3DDataFormat(value string) AvgPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D average pooling on the input.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The average pooled output tensor.
func AvgPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceMaxSparseAttr is an optional argument to SparseReduceMaxSparse.
type SparseReduceMaxSparseAttr func(optionalAttr)

// SparseReduceMaxSparseKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceMaxSparseKeepDims(value bool) SparseReduceMaxSparseAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the max of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_max()`.  In contrast to SparseReduceMax, this Op returns a
// SparseTensor.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
func SparseReduceMaxSparse(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceMaxSparseAttr) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceMaxSparse",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// The gradient of SparseFillEmptyRows.
//
// Takes vectors reverse_index_map, shaped `[N]`, and grad_values,
// shaped `[N_full]`, where `N_full >= N` and copies data into either
// `d_values` or `d_default_value`.  Here `d_values` is shaped `[N]` and
// `d_default_value` is a scalar.
//
//   d_values[j] = grad_values[reverse_index_map[j]]
//   d_default_value = sum_{k : 0 .. N_full - 1} (
//      grad_values[k] * 1{k not in reverse_index_map})
//
// Arguments:
//	reverse_index_map: 1-D.  The reverse index map from SparseFillEmptyRows.
//	grad_values: 1-D.  The gradients from backprop.
//
// Returns 1-D.  The backprop into values.0-D.  The backprop into default_value.
func SparseFillEmptyRowsGrad(scope *Scope, reverse_index_map tf.Output, grad_values tf.Output) (d_values tf.Output, d_default_value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseFillEmptyRowsGrad",
		Input: []tf.Input{
			reverse_index_map, grad_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// UnicodeDecodeWithOffsetsAttr is an optional argument to UnicodeDecodeWithOffsets.
type UnicodeDecodeWithOffsetsAttr func(optionalAttr)

// UnicodeDecodeWithOffsetsErrors sets the optional errors attribute to value.
//
// value: Error handling policy when there is invalid formatting found in the input.
// The value of 'strict' will cause the operation to produce a InvalidArgument
// error on any invalid input formatting. A value of 'replace' (the default) will
// cause the operation to replace any invalid formatting in the input with the
// `replacement_char` codepoint. A value of 'ignore' will cause the operation to
// skip any invalid formatting in the input and produce no corresponding output
// character.
// If not specified, defaults to "replace"
func UnicodeDecodeWithOffsetsErrors(value string) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["errors"] = value
	}
}

// UnicodeDecodeWithOffsetsReplacementChar sets the optional replacement_char attribute to value.
//
// value: The replacement character codepoint to be used in place of any invalid
// formatting in the input when `errors='replace'`. Any valid unicode codepoint may
// be used. The default value is the default unicode replacement character is
// 0xFFFD or U+65533.)
// If not specified, defaults to 65533
func UnicodeDecodeWithOffsetsReplacementChar(value int64) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["replacement_char"] = value
	}
}

// UnicodeDecodeWithOffsetsReplaceControlCharacters sets the optional replace_control_characters attribute to value.
//
// value: Whether to replace the C0 control characters (00-1F) with the
// `replacement_char`. Default is false.
// If not specified, defaults to false
func UnicodeDecodeWithOffsetsReplaceControlCharacters(value bool) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["replace_control_characters"] = value
	}
}

// UnicodeDecodeWithOffsetsTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func UnicodeDecodeWithOffsetsTsplits(value tf.DataType) UnicodeDecodeWithOffsetsAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Decodes each string in `input` into a sequence of Unicode code points.
//
// The character codepoints for all strings are returned using a single vector
// `char_values`, with strings expanded to characters in row-major order.
// Similarly, the character start byte offsets are returned using a single vector
// `char_to_byte_starts`, with strings expanded in row-major order.
//
// The `row_splits` tensor indicates where the codepoints and start offsets for
// each input string begin and end within the `char_values` and
// `char_to_byte_starts` tensors.  In particular, the values for the `i`th
// string (in row-major order) are stored in the slice
// `[row_splits[i]:row_splits[i+1]]`. Thus:
//
// * `char_values[row_splits[i]+j]` is the Unicode codepoint for the `j`th
//   character in the `i`th string (in row-major order).
// * `char_to_bytes_starts[row_splits[i]+j]` is the start byte offset for the `j`th
//   character in the `i`th string (in row-major order).
// * `row_splits[i+1] - row_splits[i]` is the number of characters in the `i`th
//   string (in row-major order).
//
// Arguments:
//	input: The text to be decoded. Can have any shape. Note that the output is flattened
// to a vector of char values.
//	input_encoding: Text encoding of the input strings. This is any of the encodings supported
// by ICU ucnv algorithmic converters. Examples: `"UTF-16", "US ASCII", "UTF-8"`.
//
// Returns A 1D int32 tensor containing the row splits.A 1D int32 Tensor containing the decoded codepoints.A 1D int32 Tensor containing the byte index in the input string where each
// character in `char_values` starts.
func UnicodeDecodeWithOffsets(scope *Scope, input tf.Output, input_encoding string, optional ...UnicodeDecodeWithOffsetsAttr) (row_splits tf.Output, char_values tf.Output, char_to_byte_starts tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_encoding": input_encoding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnicodeDecodeWithOffsets",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Concatenates a list of `SparseTensor` along the specified dimension.
//
// Concatenation is with respect to the dense versions of these sparse tensors.
// It is assumed that each input is a `SparseTensor` whose elements are ordered
// along increasing dimension number.
//
// All inputs' shapes must match, except for the concat dimension.  The
// `indices`, `values`, and `shapes` lists must have the same length.
//
// The output shape is identical to the inputs', except along the concat
// dimension, where it is the sum of the inputs' sizes along that dimension.
//
// The output elements will be resorted to preserve the sort order along
// increasing dimension number.
//
// This op runs in `O(M log M)` time, where `M` is the total number of non-empty
// values across all inputs. This is due to the need for an internal sort in
// order to concatenate efficiently across an arbitrary dimension.
//
// For example, if `concat_dim = 1` and the inputs are
//
//     sp_inputs[0]: shape = [2, 3]
//     [0, 2]: "a"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
//     sp_inputs[1]: shape = [2, 4]
//     [0, 1]: "d"
//     [0, 2]: "e"
//
// then the output will be
//
//     shape = [2, 7]
//     [0, 2]: "a"
//     [0, 4]: "d"
//     [0, 5]: "e"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
// Graphically this is equivalent to doing
//
//     [    a] concat [  d e  ] = [    a   d e  ]
//     [b c  ]        [       ]   [b c          ]
//
// Arguments:
//	indices: 2-D.  Indices of each input `SparseTensor`.
//	values: 1-D.  Non-empty values of each `SparseTensor`.
//	shapes: 1-D.  Shapes of each `SparseTensor`.
//	concat_dim: Dimension to concatenate along. Must be in range [-rank, rank),
// where rank is the number of dimensions in each input `SparseTensor`.
//
// Returns 2-D.  Indices of the concatenated `SparseTensor`.1-D.  Non-empty values of the concatenated `SparseTensor`.1-D.  Shape of the concatenated `SparseTensor`.
func SparseConcat(scope *Scope, indices []tf.Output, values []tf.Output, shapes []tf.Output, concat_dim int64) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"concat_dim": concat_dim}
	opspec := tf.OpSpec{
		Type: "SparseConcat",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(values), tf.OutputList(shapes),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Deserialize and concatenate `SparseTensors` from a serialized minibatch.
//
// The input `serialized_sparse` must be a string matrix of shape `[N x 3]` where
// `N` is the minibatch size and the rows correspond to packed outputs of
// `SerializeSparse`.  The ranks of the original `SparseTensor` objects
// must all match.  When the final `SparseTensor` is created, it has rank one
// higher than the ranks of the incoming `SparseTensor` objects
// (they have been concatenated along a new row dimension).
//
// The output `SparseTensor` object's shape values for all dimensions but the
// first are the max across the input `SparseTensor` objects' shape values
// for the corresponding dimensions.  Its first shape value is `N`, the minibatch
// size.
//
// The input `SparseTensor` objects' indices are assumed ordered in
// standard lexicographic order.  If this is not the case, after this
// step run `SparseReorder` to restore index ordering.
//
// For example, if the serialized input is a `[2 x 3]` matrix representing two
// original `SparseTensor` objects:
//
//     index = [ 0]
//             [10]
//             [20]
//     values = [1, 2, 3]
//     shape = [50]
//
// and
//
//     index = [ 2]
//             [10]
//     values = [4, 5]
//     shape = [30]
//
// then the final deserialized `SparseTensor` will be:
//
//     index = [0  0]
//             [0 10]
//             [0 20]
//             [1  2]
//             [1 10]
//     values = [1, 2, 3, 4, 5]
//     shape = [2 50]
//
// Arguments:
//	serialized_sparse: 2-D, The `N` serialized `SparseTensor` objects.
// Must have 3 columns.
//	dtype: The `dtype` of the serialized `SparseTensor` objects.
func DeserializeManySparse(scope *Scope, serialized_sparse tf.Output, dtype tf.DataType) (sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "DeserializeManySparse",
		Input: []tf.Input{
			serialized_sparse,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes softmax activations.
//
// For each batch `i` and class `j` we have
//
//     $$softmax[i, j] = exp(logits[i, j]) / sum_j(exp(logits[i, j]))$$
//
// Arguments:
//	logits: 2-D with shape `[batch_size, num_classes]`.
//
// Returns Same shape as `logits`.
func Softmax(scope *Scope, logits tf.Output) (softmax tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softmax",
		Input: []tf.Input{
			logits,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedBatchNormV2Attr is an optional argument to FusedBatchNormV2.
type FusedBatchNormV2Attr func(optionalAttr)

// FusedBatchNormV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormV2Epsilon(value float32) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for x and y. Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormV2DataFormat(value string) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormV2IsTraining(value bool) FusedBatchNormV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	offset: A 1D Tensor for offset, to shift to the normalized x.
//	mean: A 1D Tensor for population mean. Used for inference only;
// must be empty for training.
//	variance: A 1D Tensor for population variance. Used for inference only;
// must be empty for training.
//
// Returns A 4D Tensor for output data.A 1D Tensor for the computed batch mean, to be used by TensorFlow
// to compute the running mean.A 1D Tensor for the computed batch variance, to be used by
// TensorFlow to compute the running variance.A 1D Tensor for the computed batch mean, to be reused
// in the gradient computation.A 1D Tensor for the computed batch variance (inverted variance
// in the cuDNN case), to be reused in the gradient computation.
func FusedBatchNormV2(scope *Scope, x tf.Output, scale tf.Output, offset tf.Output, mean tf.Output, variance tf.Output, optional ...FusedBatchNormV2Attr) (y tf.Output, batch_mean tf.Output, batch_variance tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormV2",
		Input: []tf.Input{
			x, scale, offset, mean, variance,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// Computes Psi, the derivative of Lgamma (the log of the absolute value of
//
// `Gamma(x)`), element-wise.
func Digamma(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Digamma",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds two `SparseTensor` objects to produce another `SparseTensor`.
//
// The input `SparseTensor` objects' indices are assumed ordered in standard
// lexicographic order.  If this is not the case, before this step run
// `SparseReorder` to restore index ordering.
//
// By default, if two values sum to zero at some index, the output `SparseTensor`
// would still include that particular location in its index, storing a zero in the
// corresponding value slot.  To override this, callers can specify `thresh`,
// indicating that if the sum has a magnitude strictly smaller than `thresh`, its
// corresponding value and index would then not be included.  In particular,
// `thresh == 0` (default) means everything is kept and actual thresholding happens
// only for a positive value.
//
// In the following shapes, `nnz` is the count after taking `thresh` into account.
//
// Arguments:
//	a_indices: 2-D.  The `indices` of the first `SparseTensor`, size `[nnz, ndims]` Matrix.
//	a_values: 1-D.  The `values` of the first `SparseTensor`, size `[nnz]` Vector.
//	a_shape: 1-D.  The `shape` of the first `SparseTensor`, size `[ndims]` Vector.
//	b_indices: 2-D.  The `indices` of the second `SparseTensor`, size `[nnz, ndims]` Matrix.
//	b_values: 1-D.  The `values` of the second `SparseTensor`, size `[nnz]` Vector.
//	b_shape: 1-D.  The `shape` of the second `SparseTensor`, size `[ndims]` Vector.
//	thresh: 0-D.  The magnitude threshold that determines if an output value/index
// pair takes space.
func SparseAdd(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b_indices tf.Output, b_values tf.Output, b_shape tf.Output, thresh tf.Output) (sum_indices tf.Output, sum_values tf.Output, sum_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseAdd",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b_indices, b_values, b_shape, thresh,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// StatefulStandardNormalAttr is an optional argument to StatefulStandardNormal.
type StatefulStandardNormalAttr func(optionalAttr)

// StatefulStandardNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulStandardNormalDtype(value tf.DataType) StatefulStandardNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a normal distribution. This op is deprecated in favor of op 'StatefulStandardNormalV2'
//
// DEPRECATED at GraphDef version 29: Use StatefulStandardNormalV2 instead
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	shape: The shape of the output tensor.
//
// Returns A tensor of the specified shape filled with random normal values.
func StatefulStandardNormal(scope *Scope, resource tf.Output, shape tf.Output, optional ...StatefulStandardNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulStandardNormal",
		Input: []tf.Input{
			resource, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// The gradient operator for the SparseAdd op.
//
// The SparseAdd op calculates A + B, where A, B, and the sum are all represented
// as `SparseTensor` objects.  This op takes in the upstream gradient w.r.t.
// non-empty values of the sum, and outputs the gradients w.r.t. the non-empty
// values of A and B.
//
// Arguments:
//	backprop_val_grad: 1-D with shape `[nnz(sum)]`.  The gradient with respect to
// the non-empty values of the sum.
//	a_indices: 2-D.  The `indices` of the `SparseTensor` A, size `[nnz(A), ndims]`.
//	b_indices: 2-D.  The `indices` of the `SparseTensor` B, size `[nnz(B), ndims]`.
//	sum_indices: 2-D.  The `indices` of the sum `SparseTensor`, size
// `[nnz(sum), ndims]`.
//
// Returns 1-D with shape `[nnz(A)]`. The gradient with respect to the
// non-empty values of A.1-D with shape `[nnz(B)]`. The gradient with respect to the
// non-empty values of B.
func SparseAddGrad(scope *Scope, backprop_val_grad tf.Output, a_indices tf.Output, b_indices tf.Output, sum_indices tf.Output) (a_val_grad tf.Output, b_val_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseAddGrad",
		Input: []tf.Input{
			backprop_val_grad, a_indices, b_indices, sum_indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// StackPushV2Attr is an optional argument to StackPushV2.
type StackPushV2Attr func(optionalAttr)

// StackPushV2SwapMemory sets the optional swap_memory attribute to value.
//
// value: Swap `elem` to CPU. Default to false.
// If not specified, defaults to false
func StackPushV2SwapMemory(value bool) StackPushV2Attr {
	return func(m optionalAttr) {
		m["swap_memory"] = value
	}
}

// Push an element onto the stack.
//
// Arguments:
//	handle: The handle to a stack.
//	elem: The tensor to be pushed onto the stack.
//
// Returns The same tensor as the input 'elem'.
func StackPushV2(scope *Scope, handle tf.Output, elem tf.Output, optional ...StackPushV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StackPushV2",
		Input: []tf.Input{
			handle, elem,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Batch normalization.
//
// DEPRECATED at GraphDef version 9: Use tf.nn.batch_normalization()
//
// This op is deprecated. Prefer `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	beta: A 1D beta Tensor with size matching the last dimension of t.
// An offset to be added to the normalized tensor.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this tensor will be multiplied
// with the normalized tensor.
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
func BatchNormWithGlobalNormalization(scope *Scope, t tf.Output, m tf.Output, v tf.Output, beta tf.Output, gamma tf.Output, variance_epsilon float32, scale_after_normalization bool) (result tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "BatchNormWithGlobalNormalization",
		Input: []tf.Input{
			t, m, v, beta, gamma,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the grayscale dilation of 4-D `input` and 3-D `filter` tensors.
//
// The `input` tensor has shape `[batch, in_height, in_width, depth]` and the
// `filter` tensor has shape `[filter_height, filter_width, depth]`, i.e., each
// input channel is processed independently of the others with its own structuring
// function. The `output` tensor has shape
// `[batch, out_height, out_width, depth]`. The spatial dimensions of the output
// tensor depend on the `padding` algorithm. We currently only support the default
// "NHWC" `data_format`.
//
// In detail, the grayscale morphological 2-D dilation is the max-sum correlation
// (for consistency with `conv2d`, we use unmirrored filters):
//
//     output[b, y, x, c] =
//        max_{dy, dx} input[b,
//                           strides[1] * y + rates[1] * dy,
//                           strides[2] * x + rates[2] * dx,
//                           c] +
//                     filter[dy, dx, c]
//
// Max-pooling is a special case when the filter has size equal to the pooling
// kernel size and contains all zeros.
//
// Note on duality: The dilation of `input` by the `filter` is equal to the
// negation of the erosion of `-input` by the reflected `filter`.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	strides: The stride of the sliding window for each dimension of the input
// tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: The input stride for atrous morphological dilation. Must be:
// `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, out_height, out_width, depth]`.
func Dilation2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, rates []int64, padding string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CumprodAttr is an optional argument to Cumprod.
type CumprodAttr func(optionalAttr)

// CumprodExclusive sets the optional exclusive attribute to value.
//
// value: If `True`, perform exclusive cumprod.
// If not specified, defaults to false
func CumprodExclusive(value bool) CumprodAttr {
	return func(m optionalAttr) {
		m["exclusive"] = value
	}
}

// CumprodReverse sets the optional reverse attribute to value.
//
// value: A `bool` (default: False).
// If not specified, defaults to false
func CumprodReverse(value bool) CumprodAttr {
	return func(m optionalAttr) {
		m["reverse"] = value
	}
}

// Compute the cumulative product of the tensor `x` along `axis`.
//
// By default, this op performs an inclusive cumprod, which means that the first
// element of the input is identical to the first element of the output:
//
// ```python
// tf.cumprod([a, b, c])  # => [a, a * b, a * b * c]
// ```
//
// By setting the `exclusive` kwarg to `True`, an exclusive cumprod is
// performed instead:
//
// ```python
// tf.cumprod([a, b, c], exclusive=True)  # => [1, a, a * b]
// ```
//
// By setting the `reverse` kwarg to `True`, the cumprod is performed in the
// opposite direction:
//
// ```python
// tf.cumprod([a, b, c], reverse=True)  # => [a * b * c, b * c, c]
// ```
//
// This is more efficient than using separate `tf.reverse` ops.
//
// The `reverse` and `exclusive` kwargs can also be combined:
//
// ```python
// tf.cumprod([a, b, c], exclusive=True, reverse=True)  # => [b * c, c, 1]
// ```
//
// Arguments:
//	x: A `Tensor`. Must be one of the following types: `float32`, `float64`,
// `int64`, `int32`, `uint8`, `uint16`, `int16`, `int8`, `complex64`,
// `complex128`, `qint8`, `quint8`, `qint32`, `half`.
//	axis: A `Tensor` of type `int32` (default: 0). Must be in the range
// `[-rank(x), rank(x))`.
func Cumprod(scope *Scope, x tf.Output, axis tf.Output, optional ...CumprodAttr) (out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cumprod",
		Input: []tf.Input{
			x, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FractionalAvgPoolAttr is an optional argument to FractionalAvgPool.
type FractionalAvgPoolAttr func(optionalAttr)

// FractionalAvgPoolPseudoRandom sets the optional pseudo_random attribute to value.
//
// value: When set to True, generates the pooling sequence in a
// pseudorandom fashion, otherwise, in a random fashion. Check paper [Benjamin
// Graham, Fractional Max-Pooling](http://arxiv.org/abs/1412.6071) for
// difference between pseudorandom and random.
// If not specified, defaults to false
func FractionalAvgPoolPseudoRandom(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["pseudo_random"] = value
	}
}

// FractionalAvgPoolOverlapping sets the optional overlapping attribute to value.
//
// value: When set to True, it means when pooling, the values at the boundary
// of adjacent pooling cells are used by both cells. For example:
//
// `index  0  1  2  3  4`
//
// `value  20 5  16 3  7`
//
// If the pooling sequence is [0, 2, 4], then 16, at index 2 will be used twice.
// The result would be [41/3, 26/3] for fractional avg pooling.
// If not specified, defaults to false
func FractionalAvgPoolOverlapping(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["overlapping"] = value
	}
}

// FractionalAvgPoolDeterministic sets the optional deterministic attribute to value.
//
// value: When set to True, a fixed pooling region will be used when
// iterating over a FractionalAvgPool node in the computation graph. Mainly used
// in unit test to make FractionalAvgPool deterministic.
// If not specified, defaults to false
func FractionalAvgPoolDeterministic(value bool) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["deterministic"] = value
	}
}

// FractionalAvgPoolSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func FractionalAvgPoolSeed(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// FractionalAvgPoolSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func FractionalAvgPoolSeed2(value int64) FractionalAvgPoolAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Performs fractional average pooling on the input.
//
// Fractional average pooling is similar to Fractional max pooling in the pooling
// region generation step. The only difference is that after pooling regions are
// generated, a mean operation is performed instead of a max operation in each
// pooling region.
//
// Arguments:
//	value: 4-D with shape `[batch, height, width, channels]`.
//	pooling_ratio: Pooling ratio for each dimension of `value`, currently only
// supports row and col dimension and should be >= 1.0. For example, a valid
// pooling ratio looks like [1.0, 1.44, 1.73, 1.0]. The first and last elements
// must be 1.0 because we don't allow pooling on batch and channels
// dimensions. 1.44 and 1.73 are pooling ratio on height and width dimensions
// respectively.
//
// Returns output tensor after fractional avg pooling.row pooling sequence, needed to calculate gradient.column pooling sequence, needed to calculate gradient.
func FractionalAvgPool(scope *Scope, value tf.Output, pooling_ratio []float32, optional ...FractionalAvgPoolAttr) (output tf.Output, row_pooling_sequence tf.Output, col_pooling_sequence tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pooling_ratio": pooling_ratio}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FractionalAvgPool",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// QuantizeAndDequantizeV2Attr is an optional argument to QuantizeAndDequantizeV2.
type QuantizeAndDequantizeV2Attr func(optionalAttr)

// QuantizeAndDequantizeV2SignedInput sets the optional signed_input attribute to value.
//
// value: Whether the quantization is signed or unsigned. (actually this parameter should
// have been called <b>`signed_output`</b>)
// If not specified, defaults to true
func QuantizeAndDequantizeV2SignedInput(value bool) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["signed_input"] = value
	}
}

// QuantizeAndDequantizeV2NumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization.
// If not specified, defaults to 8
func QuantizeAndDequantizeV2NumBits(value int64) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// QuantizeAndDequantizeV2RangeGiven sets the optional range_given attribute to value.
//
// value: Whether the range is given or should be determined from the `input` tensor.
// If not specified, defaults to false
func QuantizeAndDequantizeV2RangeGiven(value bool) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["range_given"] = value
	}
}

// QuantizeAndDequantizeV2RoundMode sets the optional round_mode attribute to value.
//
// value: The 'round_mode' attribute controls which rounding tie-breaking algorithm is
// used when rounding float values to their quantized equivalents. The following
// rounding modes are currently supported:
//
// *   HALF_TO_EVEN: this is the default round_mode.
// *   HALF_UP: round towards positive. In this mode 7.5 rounds up to 8 and -7.5
//     rounds up to -7.
//
// If not specified, defaults to "HALF_TO_EVEN"
func QuantizeAndDequantizeV2RoundMode(value string) QuantizeAndDequantizeV2Attr {
	return func(m optionalAttr) {
		m["round_mode"] = value
	}
}

// Quantizes then dequantizes a tensor.
//
// This op simulates the precision loss from the quantized forward pass by:
//
// 1. Quantizing the tensor to fixed point numbers, which should match the target
//    quantization method when it is used in inference.
// 2. Dequantizing it back to floating point numbers for the following ops, most
//    likely matmul.
//
// There are different ways to quantize. This version uses only scaling, so 0.0
// maps to 0.
//
// From the specified 'num_bits' in the quantized output type, it determines
// minimum and maximum representable quantized values.
//
// e.g.
//
// *   [-128, 127] for signed, num_bits = 8, or
// *   [0, 255] for unsigned, num_bits = 8.
//
// If range_given == False, the initial input_min, input_max will be determined
// automatically as the minimum and maximum values in the input tensor, otherwise
// the specified values of input_min, input_max are used.
//
// Note: If the input_min, input_max are specified, they do not need to equal the
// actual minimum and maximum values in the tensor. e.g. in some cases it may be
// beneficial to specify these values such that the low probability extremes of the
// input distribution are clipped.
//
// This op determines the maximum scale_factor that would map the initial
// [input_min, input_max] range to a range that lies within the representable
// quantized range.
//
// It determines the scale from one of input_min and input_max, then updates the
// other one to maximize the respresentable range.
//
// e.g.
//
// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
//     5.0]: it would use a scale_factor of -128 / -10.0 = 12.8 In this case, it
//     would update input_max to be 127 / 12.8 = 9.921875
// *   if the output is signed, num_bits = 8, [input_min, input_max] = [-10.0,
//     10.0]: it would use a scale_factor of 127 / 10.0 = 12.7 In this case, it
//     would update input_min to be 128.0 / 12.7 = -10.07874
// *   if the output is unsigned, input_min is forced to be 0, and only the
//     specified input_max is used.
//
// After determining the scale_factor and updating the input range, it applies the
// following to each value in the 'input' tensor.
//
// output = round(clamp(value, input_min, input_max) * scale_factor) / scale_factor.
//
// The above round function rounds the value based on the given round_mode.
//
//
// Arguments:
//	input: Tensor to quantize and then dequantize.
//	input_min: If `range_given == True`, this specifies the minimum input value that needs to
// be represented, otherwise it is determined from the min value of the `input`
// tensor.
//	input_max: If `range_given == True`, this specifies the maximum input value that needs to
// be represented, otherwise it is determined from the max value of the `input`
// tensor.
func QuantizeAndDequantizeV2(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, optional ...QuantizeAndDequantizeV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizeAndDequantizeV2",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the Eigen Decomposition of a batch of square self-adjoint matrices.
//
// DEPRECATED at GraphDef version 11: Use SelfAdjointEigV2 instead.
//
// The input is a tensor of shape `[..., M, M]` whose inner-most 2 dimensions
// form square matrices, with the same constraints as the single matrix
// SelfAdjointEig.
//
// The result is a [..., M+1, M] matrix with [..., 0,:] containing the
// eigenvalues, and subsequent [...,1:, :] containing the eigenvectors. The eigenvalues
// are sorted in non-decreasing order.
//
// Arguments:
//	input: Shape is `[..., M, M]`.
//
// Returns Shape is `[..., M+1, M]`.
func SelfAdjointEig(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SelfAdjointEig",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SvdAttr is an optional argument to Svd.
type SvdAttr func(optionalAttr)

// SvdComputeUv sets the optional compute_uv attribute to value.
//
// value: If true, left and right singular vectors will be
// computed and returned in `u` and `v`, respectively.
// If false, `u` and `v` are not set and should never referenced.
// If not specified, defaults to true
func SvdComputeUv(value bool) SvdAttr {
	return func(m optionalAttr) {
		m["compute_uv"] = value
	}
}

// SvdFullMatrices sets the optional full_matrices attribute to value.
//
// value: If true, compute full-sized `u` and `v`. If false
// (the default), compute only the leading `P` singular vectors.
// Ignored if `compute_uv` is `False`.
// If not specified, defaults to false
func SvdFullMatrices(value bool) SvdAttr {
	return func(m optionalAttr) {
		m["full_matrices"] = value
	}
}

// Computes the singular value decompositions of one or more matrices.
//
// Computes the SVD of each inner matrix in `input` such that
// `input[..., :, :] = u[..., :, :] * diag(s[..., :, :]) * transpose(v[..., :, :])`
//
// ```python
// # a is a tensor containing a batch of matrices.
// # s is a tensor of singular values for each matrix.
// # u is the tensor containing of left singular vectors for each matrix.
// # v is the tensor containing of right singular vectors for each matrix.
// s, u, v = svd(a)
// s, _, _ = svd(a, compute_uv=False)
// ```
//
// Arguments:
//	input: A tensor of shape `[..., M, N]` whose inner-most 2 dimensions
// form matrices of size `[M, N]`. Let `P` be the minimum of `M` and `N`.
//
// Returns Singular values. Shape is `[..., P]`.Left singular vectors. If `full_matrices` is `False` then shape is
// `[..., M, P]`; if `full_matrices` is `True` then shape is
// `[..., M, M]`. Undefined if `compute_uv` is `False`.Left singular vectors. If `full_matrices` is `False` then shape is
// `[..., N, P]`. If `full_matrices` is `True` then shape is `[..., N, N]`.
// Undefined if `compute_uv` is false.
func Svd(scope *Scope, input tf.Output, optional ...SvdAttr) (s tf.Output, u tf.Output, v tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Svd",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DepthwiseConv2dNativeBackpropInputAttr is an optional argument to DepthwiseConv2dNativeBackpropInput.
type DepthwiseConv2dNativeBackpropInputAttr func(optionalAttr)

// DepthwiseConv2dNativeBackpropInputDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeBackpropInputDataFormat(value string) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeBackpropInputDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func DepthwiseConv2dNativeBackpropInputDilations(value []int64) DepthwiseConv2dNativeBackpropInputAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of depthwise convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the shape of `input`, based
// on `data_format`.  For example, if `data_format` is 'NHWC' then
//  `input` is a 4-D `[batch, height, width, channels]` tensor.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, depthwise_multiplier]`.
//	out_backprop: 4-D with shape  based on `data_format`.
// For example, if `data_format` is 'NHWC' then
// out_backprop shape is `[batch, out_height, out_width, out_channels]`.
// Gradients w.r.t. the output of the convolution.
//	strides: The stride of the sliding window for each dimension of the input
// of the convolution.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape according to `data_format`.  For example, if
// `data_format` is 'NHWC', output shape is `[batch, in_height,
// in_width, in_channels]`.  Gradient w.r.t. the input of the
// convolution.
func DepthwiseConv2dNativeBackpropInput(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeBackpropInputAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNativeBackpropInput",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EncodeProtoAttr is an optional argument to EncodeProto.
type EncodeProtoAttr func(optionalAttr)

// EncodeProtoDescriptorSource sets the optional descriptor_source attribute to value.
// If not specified, defaults to "local://"
func EncodeProtoDescriptorSource(value string) EncodeProtoAttr {
	return func(m optionalAttr) {
		m["descriptor_source"] = value
	}
}

// The op serializes protobuf messages provided in the input tensors.
//
// The types of the tensors in `values` must match the schema for the
// fields specified in `field_names`. All the tensors in `values` must
// have a common shape prefix, *batch_shape*.
//
// The `sizes` tensor specifies repeat counts for each field.  The repeat
// count (last dimension) of a each tensor in `values` must be greater
// than or equal to corresponding repeat count in `sizes`.
//
// A `message_type` name must be provided to give context for the field
// names. The actual message descriptor can be looked up either in the
// linked-in descriptor pool or a filename provided by the caller using
// the `descriptor_source` attribute.
//
// The `descriptor_source` attribute selects a source of protocol
// descriptors to consult when looking up `message_type`. This may be a
// filename containing a serialized `FileDescriptorSet` message,
// or the special value `local://`, in which case only descriptors linked
// into the code will be searched; the filename can be on any filesystem
// accessible to TensorFlow.
//
// You can build a `descriptor_source` file using the `--descriptor_set_out`
// and `--include_imports` options to the protocol compiler `protoc`.
//
// The `local://` database only covers descriptors linked into the
// code via C++ libraries, not Python imports. You can link in a proto descriptor
// by creating a cc_library target with alwayslink=1.
//
// There are a few special cases in the value mapping:
//
// Submessage and group fields must be pre-serialized as TensorFlow strings.
//
// TensorFlow lacks support for unsigned int64s, so they must be
// represented as `tf.int64` with the same twos-complement bit pattern
// (the obvious way).
//
// Unsigned int32 values can be represented exactly with `tf.int64`, or
// with sign wrapping if the input is of type `tf.int32`.
//
// Arguments:
//	sizes: Tensor of int32 with shape `[batch_shape, len(field_names)]`.
//	values: List of tensors containing values for the corresponding field.
//	field_names: List of strings containing proto field names.
//	message_type: Name of the proto message type to decode.
//
// Returns Tensor of serialized protos with shape `batch_shape`.
func EncodeProto(scope *Scope, sizes tf.Output, values []tf.Output, field_names []string, message_type string, optional ...EncodeProtoAttr) (bytes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"field_names": field_names, "message_type": message_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeProto",
		Input: []tf.Input{
			sizes, tf.OutputList(values),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Rounds the values of a tensor to the nearest integer, element-wise.
//
// Rounds half to even.  Also known as bankers rounding. If you want to round
// according to the current system rounding mode use std::cint.
func Round(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Round",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradWithArgmaxAttr is an optional argument to MaxPoolGradGradWithArgmax.
type MaxPoolGradGradWithArgmaxAttr func(optionalAttr)

// MaxPoolGradGradWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolGradGradWithArgmaxIncludeBatchInIndex(value bool) MaxPoolGradGradWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	input: The original input.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
// input of `max_pool`.
//	argmax: The indices of the maximum values chosen for each output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input of `max_pool`.
func MaxPoolGradGradWithArgmax(scope *Scope, input tf.Output, grad tf.Output, argmax tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradGradWithArgmaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGradWithArgmax",
		Input: []tf.Input{
			input, grad, argmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TopKV2Attr is an optional argument to TopKV2.
type TopKV2Attr func(optionalAttr)

// TopKV2Sorted sets the optional sorted attribute to value.
//
// value: If true the resulting `k` elements will be sorted by the values in
// descending order.
// If not specified, defaults to true
func TopKV2Sorted(value bool) TopKV2Attr {
	return func(m optionalAttr) {
		m["sorted"] = value
	}
}

// Finds values and indices of the `k` largest elements for the last dimension.
//
// If the input is a vector (rank-1), finds the `k` largest entries in the vector
// and outputs their values and indices as vectors.  Thus `values[j]` is the
// `j`-th largest entry in `input`, and its index is `indices[j]`.
//
// For matrices (resp. higher rank input), computes the top `k` entries in each
// row (resp. vector along the last dimension).  Thus,
//
//     values.shape = indices.shape = input.shape[:-1] + [k]
//
// If two elements are equal, the lower-index element appears first.
//
// Arguments:
//	input: 1-D or higher with last dimension at least `k`.
//	k: 0-D.  Number of top elements to look for along the last dimension (along each
// row for matrices).
//
// Returns The `k` largest elements along each last dimensional slice.The indices of `values` within the last dimension of `input`.
func TopKV2(scope *Scope, input tf.Output, k tf.Output, optional ...TopKV2Attr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TopKV2",
		Input: []tf.Input{
			input, k,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// TensorArrayConcatV2Attr is an optional argument to TensorArrayConcatV2.
type TensorArrayConcatV2Attr func(optionalAttr)

// TensorArrayConcatV2ElementShapeExcept0 sets the optional element_shape_except0 attribute to value.
// If not specified, defaults to <unknown_rank:true >
func TensorArrayConcatV2ElementShapeExcept0(value tf.Shape) TensorArrayConcatV2Attr {
	return func(m optionalAttr) {
		m["element_shape_except0"] = value
	}
}

// Deprecated. Use TensorArrayConcatV3
func TensorArrayConcatV2(scope *Scope, handle tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayConcatV2Attr) (value tf.Output, lengths tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayConcatV2",
		Input: []tf.Input{
			handle, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CastAttr is an optional argument to Cast.
type CastAttr func(optionalAttr)

// CastTruncate sets the optional Truncate attribute to value.
// If not specified, defaults to false
func CastTruncate(value bool) CastAttr {
	return func(m optionalAttr) {
		m["Truncate"] = value
	}
}

// Cast x of type SrcT to y of DstT.
func Cast(scope *Scope, x tf.Output, DstT tf.DataType, optional ...CastAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"DstT": DstT}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Cast",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolAttr is an optional argument to MaxPool.
type MaxPoolAttr func(optionalAttr)

// MaxPoolDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolDataFormat(value string) MaxPoolAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs max pooling on the input.
//
// Arguments:
//	input: 4-D input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPool(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomGammaAttr is an optional argument to RandomGamma.
type RandomGammaAttr func(optionalAttr)

// RandomGammaSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomGammaSeed(value int64) RandomGammaAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomGammaSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomGammaSeed2(value int64) RandomGammaAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from the Gamma distribution(s) described by alpha.
//
// This op uses the algorithm by Marsaglia et al. to acquire samples via
// transformation-rejection from pairs of uniform and normal random variables.
// See http://dl.acm.org/citation.cfm?id=358414
//
// Arguments:
//	shape: 1-D integer tensor. Shape of independent samples to draw from each
// distribution described by the shape parameters given in alpha.
//	alpha: A tensor in which each scalar is a "shape" parameter describing the
// associated gamma distribution.
//
// Returns A tensor with shape `shape + shape(alpha)`. Each slice
// `[:, ..., :, i0, i1, ...iN]` contains the samples drawn for
// `alpha[i0, i1, ...iN]`. The dtype of the output matches the dtype of alpha.
func RandomGamma(scope *Scope, shape tf.Output, alpha tf.Output, optional ...RandomGammaAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomGamma",
		Input: []tf.Input{
			shape, alpha,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulUniformAttr is an optional argument to StatefulUniform.
type StatefulUniformAttr func(optionalAttr)

// StatefulUniformDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulUniformDtype(value tf.DataType) StatefulUniformAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[0, 1)`. The
// lower bound 0 is included in the range, while the upper bound 1 is excluded.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//
// Returns Random values with specified shape.
func StatefulUniform(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, optional ...StatefulUniformAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulUniform",
		Input: []tf.Input{
			resource, algorithm, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingMDLAdagradLightParametersAttr is an optional argument to LoadTPUEmbeddingMDLAdagradLightParameters.
type LoadTPUEmbeddingMDLAdagradLightParametersAttr func(optionalAttr)

// LoadTPUEmbeddingMDLAdagradLightParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingMDLAdagradLightParametersTableId(value int64) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMDLAdagradLightParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMDLAdagradLightParametersTableName(value string) LoadTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load MDL Adagrad Light embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the MDL Adagrad Light optimization algorithm.
//	accumulators: Value of accumulators used in the MDL Adagrad Light optimization algorithm.
//	weights: Value of weights used in the MDL Adagrad Light optimization algorithm.
//	benefits: Value of benefits used in the MDL Adagrad Light optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingMDLAdagradLightParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, weights tf.Output, benefits tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMDLAdagradLightParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMDLAdagradLightParameters",
		Input: []tf.Input{
			parameters, accumulators, weights, benefits,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// MaxPoolV2Attr is an optional argument to MaxPoolV2.
type MaxPoolV2Attr func(optionalAttr)

// MaxPoolV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolV2DataFormat(value string) MaxPoolV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs max pooling on the input.
//
// Arguments:
//	input: 4-D input to pool over.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPoolV2(scope *Scope, input tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolV2",
		Input: []tf.Input{
			input, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingMomentumParametersGradAccumDebug.
type LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingMomentumParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingMomentumParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load Momentum embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Momentum optimization algorithm.
//	momenta: Value of momenta used in the Momentum optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the Momentum optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingMomentumParametersGradAccumDebug(scope *Scope, parameters tf.Output, momenta tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMomentumParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMomentumParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, momenta, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// A substitute for `InterleaveDataset` on a fixed list of `N` datasets.
//
// Arguments:
//	selector_input_dataset: A dataset of scalar `DT_INT64` elements that determines which of the
// `N` data inputs should produce the next output element.
//	data_input_datasets: `N` datasets with the same type that will be interleaved according to
// the values of `selector_input_dataset`.
//
//
func ExperimentalDirectedInterleaveDataset(scope *Scope, selector_input_dataset tf.Output, data_input_datasets []tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalDirectedInterleaveDataset",
		Input: []tf.Input{
			selector_input_dataset, tf.OutputList(data_input_datasets),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// InfeedEnqueueAttr is an optional argument to InfeedEnqueue.
type InfeedEnqueueAttr func(optionalAttr)

// InfeedEnqueueShape sets the optional shape attribute to value.
//
// value: The shape of the tensor.
// If not specified, defaults to <>
func InfeedEnqueueShape(value tf.Shape) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// InfeedEnqueueLayout sets the optional layout attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence.
// If a layout attribute is passed, but its values are all -1, the layout will
// be computed by the infeed operation.
// If not specified, defaults to <>
func InfeedEnqueueLayout(value []int64) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["layout"] = value
	}
}

// InfeedEnqueueDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func InfeedEnqueueDeviceOrdinal(value int64) InfeedEnqueueAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op which feeds a single Tensor value into the computation.
//
// Arguments:
//	input: A tensor that will be provided using the infeed mechanism.
//
// Returns the created operation.
func InfeedEnqueue(scope *Scope, input tf.Output, optional ...InfeedEnqueueAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueue",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Get the value of the tensor specified by its handle.
//
// Arguments:
//	handle: The handle for a tensor stored in the session state.
//	dtype: The type of the output value.
//
// Returns The tensor for the given handle.
func GetSessionTensor(scope *Scope, handle tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "GetSessionTensor",
		Input: []tf.Input{
			handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SubstrAttr is an optional argument to Substr.
type SubstrAttr func(optionalAttr)

// SubstrUnit sets the optional unit attribute to value.
//
// value: The unit that is used to create the substring.  One of: `"BYTE"` (for
// defining position and length by bytes) or `"UTF8_CHAR"` (for the UTF-8
// encoded Unicode code points).  The default is `"BYTE"`. Results are undefined if
// `unit=UTF8_CHAR` and the `input` strings do not contain structurally valid
// UTF-8.
// If not specified, defaults to "BYTE"
func SubstrUnit(value string) SubstrAttr {
	return func(m optionalAttr) {
		m["unit"] = value
	}
}

// Return substrings from `Tensor` of strings.
//
// For each string in the input `Tensor`, creates a substring starting at index
// `pos` with a total length of `len`.
//
// If `len` defines a substring that would extend beyond the length of the input
// string, then as many characters as possible are used.
//
// A negative `pos` indicates distance within the string backwards from the end.
//
// If `pos` specifies an index which is out of range for any of the input strings,
// then an `InvalidArgumentError` is thrown.
//
// `pos` and `len` must have the same shape, otherwise a `ValueError` is thrown on
// Op creation.
//
// *NOTE*: `Substr` supports broadcasting up to two dimensions. More about
// broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
//
// ---
//
// Examples
//
// Using scalar `pos` and `len`:
//
// ```python
// input = [b'Hello', b'World']
// position = 1
// length = 3
//
// output = [b'ell', b'orl']
// ```
//
// Using `pos` and `len` with same shape as `input`:
//
// ```python
// input = [[b'ten', b'eleven', b'twelve'],
//          [b'thirteen', b'fourteen', b'fifteen'],
//          [b'sixteen', b'seventeen', b'eighteen']]
// position = [[1, 2, 3],
//             [1, 2, 3],
//             [1, 2, 3]]
// length =   [[2, 3, 4],
//             [4, 3, 2],
//             [5, 5, 5]]
//
// output = [[b'en', b'eve', b'lve'],
//           [b'hirt', b'urt', b'te'],
//           [b'ixtee', b'vente', b'hteen']]
// ```
//
// Broadcasting `pos` and `len` onto `input`:
//
// ```
// input = [[b'ten', b'eleven', b'twelve'],
//          [b'thirteen', b'fourteen', b'fifteen'],
//          [b'sixteen', b'seventeen', b'eighteen'],
//          [b'nineteen', b'twenty', b'twentyone']]
// position = [1, 2, 3]
// length =   [1, 2, 3]
//
// output = [[b'e', b'ev', b'lve'],
//           [b'h', b'ur', b'tee'],
//           [b'i', b've', b'hte'],
//           [b'i', b'en', b'nty']]
// ```
//
// Broadcasting `input` onto `pos` and `len`:
//
// ```
// input = b'thirteen'
// position = [1, 5, 7]
// length =   [3, 2, 1]
//
// output = [b'hir', b'ee', b'n']
// ```
//
// Arguments:
//	input: Tensor of strings
//	pos: Scalar defining the position of first character in each substring
//	len: Scalar defining the number of characters to include in each substring
//
// Returns Tensor of substrings
func Substr(scope *Scope, input tf.Output, pos tf.Output, len tf.Output, optional ...SubstrAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Substr",
		Input: []tf.Input{
			input, pos, len,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RaggedRangeAttr is an optional argument to RaggedRange.
type RaggedRangeAttr func(optionalAttr)

// RaggedRangeTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func RaggedRangeTsplits(value tf.DataType) RaggedRangeAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Returns a `RaggedTensor` containing the specified sequences of numbers.
//
//
// Returns a `RaggedTensor` `result` composed from `rt_dense_values` and
// `rt_nested_splits`, such that
// `result[i] = range(starts[i], limits[i], deltas[i])`.
//
// ```python
// >>> (rt_nested_splits, rt_dense_values) = gen_ragged_ops.ragged_range(
// ...     starts=[2, 5, 8], limits=[3, 5, 12], deltas=1)
// >>> result = ragged.from_nested_row_splits(rt_dense_values, rt_nested_splits)
// >>> print result.eval().tolist()
// [[2],               # result[0] = range(2, 3)
//  [],                # result[1] = range(5, 5)
//  [8, 9, 10, 11]]    # result[2] = range(8, 12)
// ```
//
// The input tensors `starts`, `limits`, and `deltas` may be scalars or vectors.
// The vector inputs must all have the same size.  Scalar inputs are broadcast
// to match the size of the vector inputs.
//
// Arguments:
//	starts: The starts of each range.
//	limits: The limits of each range.
//	deltas: The deltas of each range.
//
// Returns The `row_splits` for the returned `RaggedTensor`.The `flat_values` for the returned `RaggedTensor`.
func RaggedRange(scope *Scope, starts tf.Output, limits tf.Output, deltas tf.Output, optional ...RaggedRangeAttr) (rt_nested_splits tf.Output, rt_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RaggedRange",
		Input: []tf.Input{
			starts, limits, deltas,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Outputs a `Summary` protocol buffer with a histogram.
//
// The generated
// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
// has one summary value containing a histogram for `values`.
//
// This op reports an `InvalidArgument` error if any value is not finite.
//
// Arguments:
//	tag: Scalar.  Tag to use for the `Summary.Value`.
//	values: Any shape. Values to use to build the histogram.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func HistogramSummary(scope *Scope, tag tf.Output, values tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "HistogramSummary",
		Input: []tf.Input{
			tag, values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that contains `count` elements from the `input_dataset`.
//
// Arguments:
//
//	count: A scalar representing the number of elements from the `input_dataset`
// that should be taken. A value of `-1` indicates that all of `input_dataset`
// is taken.
//
//
func TakeDataset(scope *Scope, input_dataset tf.Output, count tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "TakeDataset",
		Input: []tf.Input{
			input_dataset, count,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingADAMParametersAttr is an optional argument to LoadTPUEmbeddingADAMParameters.
type LoadTPUEmbeddingADAMParametersAttr func(optionalAttr)

// LoadTPUEmbeddingADAMParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingADAMParametersTableId(value int64) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingADAMParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingADAMParametersTableName(value string) LoadTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load ADAM embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the ADAM optimization algorithm.
//	momenta: Value of momenta used in the ADAM optimization algorithm.
//	velocities: Value of velocities used in the ADAM optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingADAMParameters(scope *Scope, parameters tf.Output, momenta tf.Output, velocities tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingADAMParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingADAMParameters",
		Input: []tf.Input{
			parameters, momenta, velocities,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingStochasticGradientDescentParametersAttr is an optional argument to LoadTPUEmbeddingStochasticGradientDescentParameters.
type LoadTPUEmbeddingStochasticGradientDescentParametersAttr func(optionalAttr)

// LoadTPUEmbeddingStochasticGradientDescentParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingStochasticGradientDescentParametersTableId(value int64) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingStochasticGradientDescentParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingStochasticGradientDescentParametersTableName(value string) LoadTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load SGD embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the stochastic gradient descent optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingStochasticGradientDescentParameters(scope *Scope, parameters tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingStochasticGradientDescentParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingStochasticGradientDescentParameters",
		Input: []tf.Input{
			parameters,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes softsign gradients for a softsign operation.
//
// Arguments:
//	gradients: The backpropagated gradients to the corresponding softsign operation.
//	features: The features passed as input to the corresponding softsign operation.
//
// Returns The gradients: `gradients / (1 + abs(features)) ** 2`.
func SoftsignGrad(scope *Scope, gradients tf.Output, features tf.Output) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftsignGrad",
		Input: []tf.Input{
			gradients, features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// The gradient operator for the SparseSlice op.
//
// This op takes in the upstream gradient w.r.t. non-empty values of
// the sliced `SparseTensor`, and outputs the gradients w.r.t.
// the non-empty values of input `SparseTensor`.
//
// Arguments:
//	backprop_val_grad: 1-D. The gradient with respect to
// the non-empty values of the sliced `SparseTensor`.
//	input_indices: 2-D.  The `indices` of the input `SparseTensor`.
//	input_start: 1-D. tensor represents the start of the slice.
//	output_indices: 2-D.  The `indices` of the sliced `SparseTensor`.
//
// Returns 1-D. The gradient with respect to the non-empty values of input `SparseTensor`.
func SparseSliceGrad(scope *Scope, backprop_val_grad tf.Output, input_indices tf.Output, input_start tf.Output, output_indices tf.Output) (val_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSliceGrad",
		Input: []tf.Input{
			backprop_val_grad, input_indices, input_start, output_indices,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An Op to sum inputs across replicated TPU instances.
//
// Each instance supplies its own input.
//
// For example, suppose there are 8 TPU instances: `[A, B, C, D, E, F, G, H]`.
// Passing group_assignment=`[[0,2,4,6],[1,3,5,7]]` sets `A, C, E, G` as group 0,
// and `B, D, F, H` as group 1. Thus we get the outputs:
// `[A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H, A+C+E+G, B+D+F+H]`.
//
// Arguments:
//	input: The local input to the sum.
//	group_assignment: An int32 tensor with shape
// [num_groups, num_replicas_per_group]. `group_assignment[i]` represents the
// replica ids in the ith subgroup.
//
// Returns The sum of all the distributed inputs.
func CrossReplicaSum(scope *Scope, input tf.Output, group_assignment tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CrossReplicaSum",
		Input: []tf.Input{
			input, group_assignment,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Fills empty rows in the input 2-D `SparseTensor` with a default value.
//
// The input `SparseTensor` is represented via the tuple of inputs
// (`indices`, `values`, `dense_shape`).  The output `SparseTensor` has the
// same `dense_shape` but with indices `output_indices` and values
// `output_values`.
//
// This op inserts a single entry for every row that doesn't have any values.
// The index is created as `[row, 0, ..., 0]` and the inserted value
// is `default_value`.
//
// For example, suppose `sp_input` has shape `[5, 6]` and non-empty values:
//
//     [0, 1]: a
//     [0, 3]: b
//     [2, 0]: c
//     [3, 1]: d
//
// Rows 1 and 4 are empty, so the output will be of shape `[5, 6]` with values:
//
//     [0, 1]: a
//     [0, 3]: b
//     [1, 0]: default_value
//     [2, 0]: c
//     [3, 1]: d
//     [4, 0]: default_value
//
// The output `SparseTensor` will be in row-major order and will have the
// same shape as the input.
//
// This op also returns an indicator vector shaped `[dense_shape[0]]` such that
//
//     empty_row_indicator[i] = True iff row i was an empty row.
//
// And a reverse index map vector shaped `[indices.shape[0]]` that is used during
// backpropagation,
//
//     reverse_index_map[j] = out_j s.t. indices[j, :] == output_indices[out_j, :]
//
// Arguments:
//	indices: 2-D. the indices of the sparse tensor.
//	values: 1-D. the values of the sparse tensor.
//	dense_shape: 1-D. the shape of the sparse tensor.
//	default_value: 0-D. default value to insert into location `[row, 0, ..., 0]`
//   for rows missing from the input sparse tensor.
// output indices: 2-D. the indices of the filled sparse tensor.
//
// Returns 1-D. the values of the filled sparse tensor.1-D. whether the dense row was missing in the
// input sparse tensor.1-D. a map from the input indices to the output indices.
func SparseFillEmptyRows(scope *Scope, indices tf.Output, values tf.Output, dense_shape tf.Output, default_value tf.Output) (output_indices tf.Output, output_values tf.Output, empty_row_indicator tf.Output, reverse_index_map tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseFillEmptyRows",
		Input: []tf.Input{
			indices, values, dense_shape, default_value,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// An Op to permute tensors across replicated TPU instances.
//
// Each instance supplies its own input.
//
// For example, suppose there are 4 TPU instances: `[A, B, C, D]`. Passing
// source_target_pairs=`[[0,1],[1,2],[2,3],[3,0]]` gets the outputs:
// `[D, A, B, C]`.
//
// Arguments:
//	input: The local input to be permuted. Currently only supports float and
// bfloat16.
//	source_target_pairs: A tensor with shape [num_pairs, 2].
//
// Returns The permuted input.
func CollectivePermute(scope *Scope, input tf.Output, source_target_pairs tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "CollectivePermute",
		Input: []tf.Input{
			input, source_target_pairs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceGatherAttr is an optional argument to ResourceGather.
type ResourceGatherAttr func(optionalAttr)

// ResourceGatherBatchDims sets the optional batch_dims attribute to value.
// If not specified, defaults to 0
func ResourceGatherBatchDims(value int64) ResourceGatherAttr {
	return func(m optionalAttr) {
		m["batch_dims"] = value
	}
}

// ResourceGatherValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func ResourceGatherValidateIndices(value bool) ResourceGatherAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Gather slices from the variable pointed to by `resource` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `indices.shape + params.shape[1:]` where:
//
// ```python
//     # Scalar indices
//     output[:, ..., :] = params[indices, :, ... :]
//
//     # Vector indices
//     output[i, :, ..., :] = params[indices[i], :, ... :]
//
//     # Higher rank indices
//     output[i, ..., j, :, ... :] = params[indices[i, ..., j], :, ..., :]
// ```
func ResourceGather(scope *Scope, resource tf.Output, indices tf.Output, dtype tf.DataType, optional ...ResourceGatherAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceGather",
		Input: []tf.Input{
			resource, indices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates and returns an empty tensor list.
//
// All list elements must be tensors of dtype element_dtype and shape compatible
// with element_shape.
//
// handle: an empty tensor list.
// element_dtype: the type of elements in the list.
// element_shape: a shape compatible with that of elements in the list.
func EmptyTensorList(scope *Scope, element_shape tf.Output, max_num_elements tf.Output, element_dtype tf.DataType) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	opspec := tf.OpSpec{
		Type: "EmptyTensorList",
		Input: []tf.Input{
			element_shape, max_num_elements,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Saves the input tensors to disk.
//
// The size of `tensor_names` must match the number of tensors in `data`. `data[i]`
// is written to `filename` with name `tensor_names[i]`.
//
// See also `SaveSlices`.
//
// Arguments:
//	filename: Must have a single element. The name of the file to which we write
// the tensor.
//	tensor_names: Shape `[N]`. The names of the tensors to be saved.
//	data: `N` tensors to save.
//
// Returns the created operation.
func Save(scope *Scope, filename tf.Output, tensor_names tf.Output, data []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Save",
		Input: []tf.Input{
			filename, tensor_names, tf.OutputList(data),
		},
	}
	return scope.AddOperation(opspec)
}

// FakeQuantWithMinMaxVarsGradientAttr is an optional argument to FakeQuantWithMinMaxVarsGradient.
type FakeQuantWithMinMaxVarsGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxVarsGradientNumBits sets the optional num_bits attribute to value.
//
// value: The bitwidth of the quantization; between 2 and 8, inclusive.
// If not specified, defaults to 8
func FakeQuantWithMinMaxVarsGradientNumBits(value int64) FakeQuantWithMinMaxVarsGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxVarsGradientNarrowRange sets the optional narrow_range attribute to value.
//
// value: Whether to quantize into 2^num_bits - 1 distinct values.
// If not specified, defaults to false
func FakeQuantWithMinMaxVarsGradientNarrowRange(value bool) FakeQuantWithMinMaxVarsGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxVars operation.
//
// Arguments:
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxVars operation.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxVars operation.
// min, max: Quantization interval, scalar floats.
//
//
//
// Returns Backpropagated gradients w.r.t. inputs:
// `gradients * (inputs >= min && inputs <= max)`.Backpropagated gradients w.r.t. min parameter:
// `sum(gradients * (inputs < min))`.Backpropagated gradients w.r.t. max parameter:
// `sum(gradients * (inputs > max))`.
func FakeQuantWithMinMaxVarsGradient(scope *Scope, gradients tf.Output, inputs tf.Output, min tf.Output, max tf.Output, optional ...FakeQuantWithMinMaxVarsGradientAttr) (backprops_wrt_input tf.Output, backprop_wrt_min tf.Output, backprop_wrt_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxVarsGradient",
		Input: []tf.Input{
			gradients, inputs, min, max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Outputs deterministic pseudorandom random integers from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[minval, maxval)`.
//
// The outputs are a deterministic function of `shape`, `seed`, `minval`, and `maxval`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//	minval: Minimum value (inclusive, scalar).
//	maxval: Maximum value (exclusive, scalar).
//
// Returns Random values with specified shape.
func StatelessRandomUniformInt(scope *Scope, shape tf.Output, seed tf.Output, minval tf.Output, maxval tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomUniformInt",
		Input: []tf.Input{
			shape, seed, minval, maxval,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradGradV2Attr is an optional argument to MaxPoolGradGradV2.
type MaxPoolGradGradV2Attr func(optionalAttr)

// MaxPoolGradGradV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradGradV2DataFormat(value string) MaxPoolGradGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes second-order gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients of gradients w.r.t. the input of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients of gradients w.r.t. the input to `max_pool`.
func MaxPoolGradGradV2(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolGradGradV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradGradV2",
		Input: []tf.Input{
			orig_input, orig_output, grad, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeBmpAttr is an optional argument to DecodeBmp.
type DecodeBmpAttr func(optionalAttr)

// DecodeBmpChannels sets the optional channels attribute to value.
// If not specified, defaults to 0
func DecodeBmpChannels(value int64) DecodeBmpAttr {
	return func(m optionalAttr) {
		m["channels"] = value
	}
}

// Decode the first frame of a BMP-encoded image to a uint8 tensor.
//
// The attr `channels` indicates the desired number of color channels for the
// decoded image.
//
// Accepted values are:
//
// *   0: Use the number of channels in the BMP-encoded image.
// *   3: output an RGB image.
// *   4: output an RGBA image.
//
// Arguments:
//	contents: 0-D.  The BMP-encoded image.
//
// Returns 3-D with shape `[height, width, channels]`. RGB order
func DecodeBmp(scope *Scope, contents tf.Output, optional ...DecodeBmpAttr) (image tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeBmp",
		Input: []tf.Input{
			contents,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes exponential linear: `exp(features) - 1` if < 0, `features` otherwise.
//
// See [Fast and Accurate Deep Network Learning by Exponential Linear Units (ELUs)
// ](http://arxiv.org/abs/1511.07289)
func Elu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Elu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// An Op to exchange data across TPU replicas.
//
// On each replica, the input is split into `split_count` blocks along
// `split_dimension` and send to the other replicas given group_assignment. After
// receiving `split_count` - 1 blocks from other replicas, we concatenate the
// blocks along `concat_dimension` as the output.
//
// For example, suppose there are 2 TPU replicas:
// replica 0 receives input: `[[A, B]]`
// replica 1 receives input: `[[C, D]]`
//
// group_assignment=`[[0, 1]]`
// concat_dimension=0
// split_dimension=1
// split_count=2
//
// replica 0's output: `[[A], [C]]`
// replica 1's output: `[[B], [D]]`
//
// Arguments:
//	input: The local input to the sum.
//	group_assignment: An int32 tensor with shape
// [num_groups, num_replicas_per_group]. `group_assignment[i]` represents the
// replica ids in the ith subgroup.
//	concat_dimension: The dimension number to concatenate.
//	split_dimension: The dimension number to split.
//	split_count: The number of splits, this number must equal to the sub-group
// size(group_assignment.get_shape()[1])
//
// Returns The exchanged result.
func AllToAll(scope *Scope, input tf.Output, group_assignment tf.Output, concat_dimension int64, split_dimension int64, split_count int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"concat_dimension": concat_dimension, "split_dimension": split_dimension, "split_count": split_count}
	opspec := tf.OpSpec{
		Type: "AllToAll",
		Input: []tf.Input{
			input, group_assignment,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeRawAttr is an optional argument to DecodeRaw.
type DecodeRawAttr func(optionalAttr)

// DecodeRawLittleEndian sets the optional little_endian attribute to value.
//
// value: Whether the input `bytes` are in little-endian order.
// Ignored for `out_type` values that are stored in a single byte like
// `uint8`.
// If not specified, defaults to true
func DecodeRawLittleEndian(value bool) DecodeRawAttr {
	return func(m optionalAttr) {
		m["little_endian"] = value
	}
}

// Reinterpret the bytes of a string as a vector of numbers.
//
// Arguments:
//	bytes: All the elements must have the same length.
//
//
// Returns A Tensor with one more dimension than the input `bytes`.  The
// added dimension will have size equal to the length of the elements
// of `bytes` divided by the number of bytes to represent `out_type`.
func DecodeRaw(scope *Scope, bytes tf.Output, out_type tf.DataType, optional ...DecodeRawAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeRaw",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IdentityReaderV2Attr is an optional argument to IdentityReaderV2.
type IdentityReaderV2Attr func(optionalAttr)

// IdentityReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func IdentityReaderV2Container(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// IdentityReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func IdentityReaderV2SharedName(value string) IdentityReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the queued work as both the key and value.
//
// To use, enqueue strings in a Queue.  ReaderRead will take the front
// work string and output (work, work).
//
// Returns The handle to reference the Reader.
func IdentityReaderV2(scope *Scope, optional ...IdentityReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IdentityReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyFtrlV2Attr is an optional argument to ResourceApplyFtrlV2.
type ResourceApplyFtrlV2Attr func(optionalAttr)

// ResourceApplyFtrlV2UseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyFtrlV2UseLocking(value bool) ResourceApplyFtrlV2Attr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the Ftrl-proximal scheme.
//
// grad_with_shrinkage = grad + 2 * l2_shrinkage * var
// accum_new = accum + grad_with_shrinkage * grad_with_shrinkage
// linear += grad_with_shrinkage +
//     (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
// accum = accum_new
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	linear: Should be from a Variable().
//	grad: The gradient.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regulariation. Must be a scalar.
//	l2: L2 shrinkage regulariation. Must be a scalar.
//
//	lr_power: Scaling factor. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyFtrlV2(scope *Scope, var_ tf.Output, accum tf.Output, linear tf.Output, grad tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, l2_shrinkage tf.Output, lr_power tf.Output, optional ...ResourceApplyFtrlV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyFtrlV2",
		Input: []tf.Input{
			var_, accum, linear, grad, lr, l1, l2, l2_shrinkage, lr_power,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Produces the average pool of the input tensor for quantized types.
//
// Arguments:
//	input: 4-D with shape `[batch, height, width, channels]`.
//	min_input: The float value that the lowest quantized input value represents.
//	max_input: The float value that the highest quantized input value represents.
//	ksize: The size of the window for each dimension of the input tensor.
// The length must be 4 to match the number of dimensions of the input.
//	strides: The stride of the sliding window for each dimension of the input
// tensor.  The length must be 4 to match the number of dimensions of the input.
//	padding: The type of padding algorithm to use.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedAvgPool(scope *Scope, input tf.Output, min_input tf.Output, max_input tf.Output, ksize []int64, strides []int64, padding string) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	opspec := tf.OpSpec{
		Type: "QuantizedAvgPool",
		Input: []tf.Input{
			input, min_input, max_input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RetrieveTPUEmbeddingAdagradParametersAttr is an optional argument to RetrieveTPUEmbeddingAdagradParameters.
type RetrieveTPUEmbeddingAdagradParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingAdagradParametersTableId(value int64) RetrieveTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdagradParametersTableName(value string) RetrieveTPUEmbeddingAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve Adagrad embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the Adagrad optimization algorithm.Parameter accumulators updated by the Adagrad optimization algorithm.
func RetrieveTPUEmbeddingAdagradParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingAdagradParametersAttr) (parameters tf.Output, accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingAdagradParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// SerializeManySparseAttr is an optional argument to SerializeManySparse.
type SerializeManySparseAttr func(optionalAttr)

// SerializeManySparseOutType sets the optional out_type attribute to value.
//
// value: The `dtype` to use for serialization; the supported types are `string`
// (default) and `variant`.
// If not specified, defaults to DT_STRING
func SerializeManySparseOutType(value tf.DataType) SerializeManySparseAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Serialize an `N`-minibatch `SparseTensor` into an `[N, 3]` `Tensor` object.
//
// The `SparseTensor` must have rank `R` greater than 1, and the first dimension
// is treated as the minibatch dimension.  Elements of the `SparseTensor`
// must be sorted in increasing order of this first dimension.  The serialized
// `SparseTensor` objects going into each row of `serialized_sparse` will have
// rank `R-1`.
//
// The minibatch size `N` is extracted from `sparse_shape[0]`.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the minibatch `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the minibatch `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the minibatch `SparseTensor`.
func SerializeManySparse(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...SerializeManySparseAttr) (serialized_sparse tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SerializeManySparse",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringJoinAttr is an optional argument to StringJoin.
type StringJoinAttr func(optionalAttr)

// StringJoinSeparator sets the optional separator attribute to value.
//
// value: string, an optional join separator.
// If not specified, defaults to ""
func StringJoinSeparator(value string) StringJoinAttr {
	return func(m optionalAttr) {
		m["separator"] = value
	}
}

// Joins the strings in the given list of string tensors into one tensor;
//
// with the given separator (default is an empty separator).
//
// Arguments:
//	inputs: A list of string tensors.  The tensors must all have the same shape,
// or be scalars.  Scalars may be mixed in; these will be broadcast to the shape
// of non-scalar inputs.
func StringJoin(scope *Scope, inputs []tf.Output, optional ...StringJoinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringJoin",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of x OR y element-wise.
//
// *NOTE*: `LogicalOr` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalOr(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalOr",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SumAttr is an optional argument to Sum.
type SumAttr func(optionalAttr)

// SumKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SumKeepDims(value bool) SumAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Sum(scope *Scope, input tf.Output, axis tf.Output, optional ...SumAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Sum",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OneHotAttr is an optional argument to OneHot.
type OneHotAttr func(optionalAttr)

// OneHotAxis sets the optional axis attribute to value.
//
// value: The axis to fill (default: -1, a new inner-most axis).
// If not specified, defaults to -1
func OneHotAxis(value int64) OneHotAttr {
	return func(m optionalAttr) {
		m["axis"] = value
	}
}

// Returns a one-hot tensor.
//
// The locations represented by indices in `indices` take value `on_value`,
// while all other locations take value `off_value`.
//
// If the input `indices` is rank `N`, the output will have rank `N+1`,
// The new axis is created at dimension `axis` (default: the new axis is
// appended at the end).
//
// If `indices` is a scalar the output shape will be a vector of length `depth`.
//
// If `indices` is a vector of length `features`, the output shape will be:
// ```
//   features x depth if axis == -1
//   depth x features if axis == 0
// ```
//
// If `indices` is a matrix (batch) with shape `[batch, features]`,
// the output shape will be:
// ```
//   batch x features x depth if axis == -1
//   batch x depth x features if axis == 1
//   depth x batch x features if axis == 0
// ```
//
//
// Examples
// =========
//
// Suppose that
// ```
//   indices = [0, 2, -1, 1]
//   depth = 3
//   on_value = 5.0
//   off_value = 0.0
//   axis = -1
// ```
//
// Then output is `[4 x 3]`:
// ```
// output =
//   [5.0 0.0 0.0]  // one_hot(0)
//   [0.0 0.0 5.0]  // one_hot(2)
//   [0.0 0.0 0.0]  // one_hot(-1)
//   [0.0 5.0 0.0]  // one_hot(1)
// ```
//
// Suppose that
// ```
//   indices = [0, 2, -1, 1]
//   depth = 3
//   on_value = 0.0
//   off_value = 3.0
//   axis = 0
// ```
//
// Then output is `[3 x 4]`:
// ```
// output =
//   [0.0 3.0 3.0 3.0]
//   [3.0 3.0 3.0 0.0]
//   [3.0 3.0 3.0 3.0]
//   [3.0 0.0 3.0 3.0]
// //  ^                one_hot(0)
// //      ^            one_hot(2)
// //          ^        one_hot(-1)
// //              ^    one_hot(1)
// ```
//
// Suppose that
// ```
//   indices = [[0, 2], [1, -1]]
//   depth = 3
//   on_value = 1.0
//   off_value = 0.0
//   axis = -1
// ```
//
// Then output is `[2 x 2 x 3]`:
// ```
// output =
//   [
//     [1.0, 0.0, 0.0]  // one_hot(0)
//     [0.0, 0.0, 1.0]  // one_hot(2)
//   ][
//     [0.0, 1.0, 0.0]  // one_hot(1)
//     [0.0, 0.0, 0.0]  // one_hot(-1)
//   ]
// ```
//
// Arguments:
//	indices: A tensor of indices.
//	depth: A scalar defining the depth of the one hot dimension.
//	on_value: A scalar defining the value to fill in output when `indices[j] = i`.
//	off_value: A scalar defining the value to fill in output when `indices[j] != i`.
//
// Returns The one-hot tensor.
func OneHot(scope *Scope, indices tf.Output, depth tf.Output, on_value tf.Output, off_value tf.Output, optional ...OneHotAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OneHot",
		Input: []tf.Input{
			indices, depth, on_value, off_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PrelinearizeAttr is an optional argument to Prelinearize.
type PrelinearizeAttr func(optionalAttr)

// PrelinearizeShape sets the optional shape attribute to value.
//
// value: The shape of the tensor.
// If not specified, defaults to <>
func PrelinearizeShape(value tf.Shape) PrelinearizeAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// PrelinearizeLayout sets the optional layout attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence. If a layout
// attribute is passed but its values are all -1 the layout will be computed by
// the infeed operation.
// If not specified, defaults to <>
func PrelinearizeLayout(value []int64) PrelinearizeAttr {
	return func(m optionalAttr) {
		m["layout"] = value
	}
}

// An op which linearizes one Tensor value to an opaque variant tensor.
//
// Arguments:
//	input: A tensor that will be linearized.
func Prelinearize(scope *Scope, input tf.Output, optional ...PrelinearizeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Prelinearize",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Component-wise multiplies a SparseTensor by a dense Tensor.
//
// The output locations corresponding to the implicitly zero elements in the sparse
// tensor will be zero (i.e., will not take up storage space), regardless of the
// contents of the dense tensor (even if it's +/-INF and that INF*0 == NaN).
//
// *Limitation*: this Op only broadcasts the dense side to the sparse side, but not
// the other direction.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseMul(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseMul",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Connects outputs of an N-way replicated computation to N outputs.
func TPUReplicatedOutput(scope *Scope, input tf.Output, num_replicas int64) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_replicas": num_replicas}
	opspec := tf.OpSpec{
		Type: "TPUReplicatedOutput",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("TPUReplicatedOutput", err)
		return
	}
	return outputs
}

// Split a `SparseTensor` into `num_split` tensors along one dimension.
//
// If the `shape[split_dim]` is not an integer multiple of `num_split`. Slices
// `[0 : shape[split_dim] % num_split]` gets one extra dimension.
// For example, if `split_dim = 1` and `num_split = 2` and the input is
//
//     input_tensor = shape = [2, 7]
//     [    a   d e  ]
//     [b c          ]
//
// Graphically the output tensors are:
//
//     output_tensor[0] = shape = [2, 4]
//     [    a  ]
//     [b c    ]
//
//     output_tensor[1] = shape = [2, 3]
//     [ d e  ]
//     [      ]
//
// Arguments:
//	split_dim: 0-D.  The dimension along which to split.  Must be in the range
// `[0, rank(shape))`.
//	indices: 2-D tensor represents the indices of the sparse tensor.
//	values: 1-D tensor represents the values of the sparse tensor.
//	shape: 1-D. tensor represents the shape of the sparse tensor.
// output indices: A list of 1-D tensors represents the indices of the output
// sparse tensors.
//	num_split: The number of ways to split.
//
// Returns A list of 1-D tensors represents the values of the output sparse
// tensors.A list of 1-D tensors represents the shape of the output sparse
// tensors.
func SparseSplit(scope *Scope, split_dim tf.Output, indices tf.Output, values tf.Output, shape tf.Output, num_split int64) (output_indices []tf.Output, output_values []tf.Output, output_shape []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_split": num_split}
	opspec := tf.OpSpec{
		Type: "SparseSplit",
		Input: []tf.Input{
			split_dim, indices, values, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_indices, idx, err = makeOutputList(op, idx, "output_indices"); err != nil {
		scope.UpdateErr("SparseSplit", err)
		return
	}
	if output_values, idx, err = makeOutputList(op, idx, "output_values"); err != nil {
		scope.UpdateErr("SparseSplit", err)
		return
	}
	if output_shape, idx, err = makeOutputList(op, idx, "output_shape"); err != nil {
		scope.UpdateErr("SparseSplit", err)
		return
	}
	return output_indices, output_values, output_shape
}

// Copy a tensor setting everything outside a central band in each innermost matrix
//
// to zero.
//
// The `band` part is computed as follows:
// Assume `input` has `k` dimensions `[I, J, K, ..., M, N]`, then the output is a
// tensor with the same shape where
//
// `band[i, j, k, ..., m, n] = in_band(m, n) * input[i, j, k, ..., m, n]`.
//
// The indicator function
//
// `in_band(m, n) = (num_lower < 0 || (m-n) <= num_lower)) &&
//                  (num_upper < 0 || (n-m) <= num_upper)`.
//
// For example:
//
// ```
// # if 'input' is [[ 0,  1,  2, 3]
//                  [-1,  0,  1, 2]
//                  [-2, -1,  0, 1]
//                  [-3, -2, -1, 0]],
//
// tf.matrix_band_part(input, 1, -1) ==> [[ 0,  1,  2, 3]
//                                        [-1,  0,  1, 2]
//                                        [ 0, -1,  0, 1]
//                                        [ 0,  0, -1, 0]],
//
// tf.matrix_band_part(input, 2, 1) ==> [[ 0,  1,  0, 0]
//                                       [-1,  0,  1, 0]
//                                       [-2, -1,  0, 1]
//                                       [ 0, -2, -1, 0]]
// ```
//
// Useful special cases:
//
// ```
//  tf.matrix_band_part(input, 0, -1) ==> Upper triangular part.
//  tf.matrix_band_part(input, -1, 0) ==> Lower triangular part.
//  tf.matrix_band_part(input, 0, 0) ==> Diagonal.
// ```
//
// Arguments:
//	input: Rank `k` tensor.
//	num_lower: 0-D tensor. Number of subdiagonals to keep. If negative, keep entire
// lower triangle.
//	num_upper: 0-D tensor. Number of superdiagonals to keep. If negative, keep
// entire upper triangle.
//
// Returns Rank `k` tensor of the same shape as input. The extracted banded tensor.
func MatrixBandPart(scope *Scope, input tf.Output, num_lower tf.Output, num_upper tf.Output) (band tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MatrixBandPart",
		Input: []tf.Input{
			input, num_lower, num_upper,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingFTRLParametersGradAccumDebug.
type LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingFTRLParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingFTRLParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingFTRLParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingFTRLParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load FTRL embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the FTRL optimization algorithm.
//	accumulators: Value of accumulators used in the FTRL optimization algorithm.
//	linears: Value of linears used in the FTRL optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the FTRL optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingFTRLParametersGradAccumDebug(scope *Scope, parameters tf.Output, accumulators tf.Output, linears tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingFTRLParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingFTRLParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, accumulators, linears, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes rectified linear 6: `min(max(features, 0), 6)`.
func Relu6(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Relu6",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Provides the time since epoch in seconds.
//
// Returns the timestamp as a `float64` for seconds since the Unix epoch.
//
// Note: the timestamp is computed when the op is executed, not when it is added
// to the graph.
func Timestamp(scope *Scope) (ts tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Timestamp",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A placeholder op for a value that will be fed into the computation.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be provided using the infeed mechanism.
func InfeedDequeue(scope *Scope, dtype tf.DataType, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	opspec := tf.OpSpec{
		Type: "InfeedDequeue",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes tan of x element-wise.
func Tan(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Tan",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CudnnRNNCanonicalToParamsAttr is an optional argument to CudnnRNNCanonicalToParams.
type CudnnRNNCanonicalToParamsAttr func(optionalAttr)

// CudnnRNNCanonicalToParamsRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNCanonicalToParamsRnnMode(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNCanonicalToParamsInputMode(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNCanonicalToParamsDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNCanonicalToParamsDirection(value string) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNCanonicalToParamsDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsDropout(value float32) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNCanonicalToParamsSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsSeed(value int64) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNCanonicalToParamsSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNCanonicalToParamsSeed2(value int64) CudnnRNNCanonicalToParamsAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Converts CudnnRNN params from canonical form to usable form.
//
// Writes a set of weights into the opaque params buffer so they can be used in
// upcoming training or inferences.
//
// Note that the params buffer may not be compatible across different GPUs. So any
// save and restoration should be converted to and from the canonical weights and
// biases.
//
// num_layers: Specifies the number of layers in the RNN model.
// num_units: Specifies the size of the hidden state.
// input_size: Specifies the size of the input state.
// weights: the canonical form of weights that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// biases: the canonical form of biases that can be used for saving
//     and restoration. They are more likely to be compatible across different
//     generations.
// num_params: number of parameter sets for all layers.
//     Each layer may contain multiple parameter sets, with each set consisting of
//     a weight matrix and a bias vector.
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     The actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used.
//     dir = (direction == bidirectional) ? 2 : 1
// dropout: dropout probability. When set to 0., dropout is disabled.
// seed: the 1st part of a seed to initialize dropout.
// seed2: the 2nd part of a seed to initialize dropout.
func CudnnRNNCanonicalToParams(scope *Scope, num_layers tf.Output, num_units tf.Output, input_size tf.Output, weights []tf.Output, biases []tf.Output, optional ...CudnnRNNCanonicalToParamsAttr) (params tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNCanonicalToParams",
		Input: []tf.Input{
			num_layers, num_units, input_size, tf.OutputList(weights), tf.OutputList(biases),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomPoissonAttr is an optional argument to RandomPoisson.
type RandomPoissonAttr func(optionalAttr)

// RandomPoissonSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func RandomPoissonSeed(value int64) RandomPoissonAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomPoissonSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func RandomPoissonSeed2(value int64) RandomPoissonAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Use RandomPoissonV2 instead.
//
// DEPRECATED at GraphDef version 25: Replaced by RandomPoissonV2
func RandomPoisson(scope *Scope, shape tf.Output, rate tf.Output, optional ...RandomPoissonAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomPoisson",
		Input: []tf.Input{
			shape, rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Fast Fourier transform.
//
// Computes the 1-dimensional discrete Fourier transform over the inner-most
// dimension of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most
//   dimension of `input` is replaced with its 1D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fft
// @end_compatibility
func FFT(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayCloseV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayCloseV3
//
// Returns the created operation.
func TensorArrayCloseV2(scope *Scope, handle tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayCloseV2",
		Input: []tf.Input{
			handle,
		},
	}
	return scope.AddOperation(opspec)
}

// AddSparseToTensorsMapAttr is an optional argument to AddSparseToTensorsMap.
type AddSparseToTensorsMapAttr func(optionalAttr)

// AddSparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddSparseToTensorsMapContainer(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddSparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddSparseToTensorsMapSharedName(value string) AddSparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add a `SparseTensor` to a `SparseTensorsMap` return its handle.
//
// A `SparseTensor` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`.
//
// This operator takes the given `SparseTensor` and adds it to a container
// object (a `SparseTensorsMap`).  A unique key within this container is generated
// in the form of an `int64`, and this is the value that is returned.
//
// The `SparseTensor` can then be read out as part of a minibatch by passing
// the key as a vector element to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddSparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the `SparseTensor`.
//	sparse_values: 1-D.  The `values` of the `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the `SparseTensor`.
//
// Returns 0-D.  The handle of the `SparseTensor` now stored in the
// `SparseTensorsMap`.
func AddSparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddSparseToTensorsMapAttr) (sparse_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddSparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingRMSPropParametersAttr is an optional argument to LoadTPUEmbeddingRMSPropParameters.
type LoadTPUEmbeddingRMSPropParametersAttr func(optionalAttr)

// LoadTPUEmbeddingRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingRMSPropParametersTableId(value int64) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersTableName(value string) LoadTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load RMSProp embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the RMSProp optimization algorithm.
//	ms: Value of ms used in the RMSProp optimization algorithm.
//	mom: Value of mom used in the RMSProp optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingRMSPropParameters(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingRMSPropParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingRMSPropParameters",
		Input: []tf.Input{
			parameters, ms, mom,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// VarHandleOpAttr is an optional argument to VarHandleOp.
type VarHandleOpAttr func(optionalAttr)

// VarHandleOpContainer sets the optional container attribute to value.
//
// value: the container this variable is placed in.
// If not specified, defaults to ""
func VarHandleOpContainer(value string) VarHandleOpAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// VarHandleOpSharedName sets the optional shared_name attribute to value.
//
// value: the name by which this variable is referred to.
// If not specified, defaults to ""
func VarHandleOpSharedName(value string) VarHandleOpAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a handle to a Variable resource.
//
// Arguments:
//	dtype: the type of this variable. Must agree with the dtypes
// of all ops using this variable.
//	shape: The (possibly partially specified) shape of this variable.
func VarHandleOp(scope *Scope, dtype tf.DataType, shape tf.Shape, optional ...VarHandleOpAttr) (resource tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "VarHandleOp",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient of morphological 2-D dilation with respect to the input.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
// Must be: `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D with shape `[batch, in_height, in_width, depth]`.
func Dilation2DBackpropInput(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (in_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropInput",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a vector of brain.Example protos (as strings) into typed tensors.
//
// Arguments:
//	serialized: A vector containing a batch of binary serialized Example protos.
//	names: A vector containing the names of the serialized protos.
// May contain, for example, table key (descriptive) names for the
// corresponding serialized protos.  These are purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty vector if no names are available.
// If non-empty, this vector must be the same length as "serialized".
//	sparse_keys: A list of Nsparse string Tensors (scalars).
// The keys expected in the Examples' features associated with sparse values.
//	dense_keys: A list of Ndense string Tensors (scalars).
// The keys expected in the Examples' features associated with dense values.
//	dense_defaults: A list of Ndense Tensors (some may be empty).
// dense_defaults[j] provides default values
// when the example's feature_map lacks dense_key[j].  If an empty Tensor is
// provided for dense_defaults[j], then the Feature dense_keys[j] is required.
// The input type is inferred from dense_defaults[j], even when it's empty.
// If dense_defaults[j] is not empty, and dense_shapes[j] is fully defined,
// then the shape of dense_defaults[j] must match that of dense_shapes[j].
// If dense_shapes[j] has an undefined major dimension (variable strides dense
// feature), dense_defaults[j] must contain a single element:
// the padding element.
//	sparse_types: A list of Nsparse types; the data types of data in each Feature
// given in sparse_keys.
// Currently the ParseExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	dense_shapes: A list of Ndense shapes; the shapes of data in each Feature
// given in dense_keys.
// The number of elements in the Feature corresponding to dense_key[j]
// must always equal dense_shapes[j].NumEntries().
// If dense_shapes[j] == (D0, D1, ..., DN) then the shape of output
// Tensor dense_values[j] will be (|serialized|, D0, D1, ..., DN):
// The dense outputs are just the inputs row-stacked by batch.
// This works for dense_shapes[j] = (-1, D1, ..., DN).  In this case
// the shape of the output Tensor dense_values[j] will be
// (|serialized|, M, D1, .., DN), where M is the maximum number of blocks
// of elements of length D1 * .... * DN, across all minibatch entries
// in the input.  Any minibatch entry with less than M blocks of elements of
// length D1 * ... * DN will be padded with the corresponding default_value
// scalar element along the second dimension.
func ParseExample(scope *Scope, serialized tf.Output, names tf.Output, sparse_keys []tf.Output, dense_keys []tf.Output, dense_defaults []tf.Output, sparse_types []tf.DataType, dense_shapes []tf.Shape) (sparse_indices []tf.Output, sparse_values []tf.Output, sparse_shapes []tf.Output, dense_values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"sparse_types": sparse_types, "dense_shapes": dense_shapes}
	opspec := tf.OpSpec{
		Type: "ParseExample",
		Input: []tf.Input{
			serialized, names, tf.OutputList(sparse_keys), tf.OutputList(dense_keys), tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if sparse_indices, idx, err = makeOutputList(op, idx, "sparse_indices"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	if sparse_values, idx, err = makeOutputList(op, idx, "sparse_values"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	if sparse_shapes, idx, err = makeOutputList(op, idx, "sparse_shapes"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	if dense_values, idx, err = makeOutputList(op, idx, "dense_values"); err != nil {
		scope.UpdateErr("ParseExample", err)
		return
	}
	return sparse_indices, sparse_values, sparse_shapes, dense_values
}

// UnicodeEncodeAttr is an optional argument to UnicodeEncode.
type UnicodeEncodeAttr func(optionalAttr)

// UnicodeEncodeErrors sets the optional errors attribute to value.
//
// value: Error handling policy when there is invalid formatting found in the input.
// The value of 'strict' will cause the operation to produce a InvalidArgument
// error on any invalid input formatting. A value of 'replace' (the default) will
// cause the operation to replace any invalid formatting in the input with the
// `replacement_char` codepoint. A value of 'ignore' will cause the operation to
// skip any invalid formatting in the input and produce no corresponding output
// character.
// If not specified, defaults to "replace"
func UnicodeEncodeErrors(value string) UnicodeEncodeAttr {
	return func(m optionalAttr) {
		m["errors"] = value
	}
}

// UnicodeEncodeReplacementChar sets the optional replacement_char attribute to value.
//
// value: The replacement character codepoint to be used in place of any invalid
// formatting in the input when `errors='replace'`. Any valid unicode codepoint may
// be used. The default value is the default unicode replacement character is
// 0xFFFD (U+65533).
// If not specified, defaults to 65533
func UnicodeEncodeReplacementChar(value int64) UnicodeEncodeAttr {
	return func(m optionalAttr) {
		m["replacement_char"] = value
	}
}

// Encode a tensor of ints into unicode strings.
//
// Returns a vector of strings, where `output[i]` is constructed by encoding the
// Unicode codepoints in `input_values[input_splits[i]:input_splits[i+1]]`
// using `output_encoding`.
//
// ---
//
// Example:
//
// ```
// input_values = [72, 101, 108, 108, 111, 87, 111, 114, 108, 100]
// input_splits = [0, 5, 10]
// output_encoding = 'UTF-8'
//
// output = ['Hello', 'World']
// ```
//
// Arguments:
//	input_values: A 1D tensor containing the unicode codepoints that should be encoded.
//	input_splits: A 1D tensor specifying how the unicode codepoints should be split into strings.
// In particular, `output[i]` is constructed by encoding the codepoints in the
// slice `input_values[input_splits[i]:input_splits[i+1]]`.
//	output_encoding: Unicode encoding of the output strings. Valid encodings are: `"UTF-8",
// "UTF-16-BE", and "UTF-32-BE"`.
//
// Returns The 1-D Tensor of strings encoded from the provided unicode codepoints.
func UnicodeEncode(scope *Scope, input_values tf.Output, input_splits tf.Output, output_encoding string, optional ...UnicodeEncodeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_encoding": output_encoding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnicodeEncode",
		Input: []tf.Input{
			input_values, input_splits,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceSparseApplyProximalGradientDescentAttr is an optional argument to ResourceSparseApplyProximalGradientDescent.
type ResourceSparseApplyProximalGradientDescentAttr func(optionalAttr)

// ResourceSparseApplyProximalGradientDescentUseLocking sets the optional use_locking attribute to value.
//
// value: If True, the subtraction will be protected by a lock;
// otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyProximalGradientDescentUseLocking(value bool) ResourceSparseApplyProximalGradientDescentAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Sparse update '*var' as FOBOS algorithm with fixed learning rate.
//
// That is for rows we have grad for, we update var as follows:
// prox_v = var - alpha * grad
// var = sign(prox_v)/(1+alpha*l2) * max{|prox_v|-alpha*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	alpha: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyProximalGradientDescent(scope *Scope, var_ tf.Output, alpha tf.Output, l1 tf.Output, l2 tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyProximalGradientDescentAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyProximalGradientDescent",
		Input: []tf.Input{
			var_, alpha, l1, l2, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// A TPU core selector Op.
//
// This Op produces a set of TPU cores (for warm-up) or a single TPU core
// (for regular inference) to execute the TPU program on. The output is
// consumed by TPUPartitionedCall.
//
// Returns A vector 1 or more TPU cores.
func TPUOrdinalSelector(scope *Scope) (device_ordinals tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TPUOrdinalSelector",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomUniformAttr is an optional argument to RandomUniform.
type RandomUniformAttr func(optionalAttr)

// RandomUniformSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomUniformSeed(value int64) RandomUniformAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomUniformSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomUniformSeed2(value int64) RandomUniformAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Outputs random values from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[0, 1)`. The
// lower bound 0 is included in the range, while the upper bound 1 is excluded.
//
// Arguments:
//	shape: The shape of the output tensor.
//	dtype: The type of the output.
//
// Returns A tensor of the specified shape filled with uniform random values.
func RandomUniform(scope *Scope, shape tf.Output, dtype tf.DataType, optional ...RandomUniformAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomUniform",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the trignometric inverse sine of x element-wise.
//
// The `tf.math.asin` operation returns the inverse of `tf.math.sin`, such that
// if `y = tf.math.sin(x)` then, `x = tf.math.asin(y)`.
//
// **Note**: The output of `tf.math.asin` will lie within the invertible range
// of sine, i.e [-pi/2, pi/2].
//
// For example:
//
// ```python
// # Note: [1.047, 0.785] ~= [(pi/3), (pi/4)]
// x = tf.constant([1.047, 0.785])
// y = tf.math.sin(x) # [0.8659266, 0.7068252]
//
// tf.math.asin(y) # [1.047, 0.785] = x
// ```
//
func Asin(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asin",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Concatenates tensors along one dimension.
//
// Arguments:
//	concat_dim: 0-D.  The dimension along which to concatenate.  Must be in the
// range [0, rank(values)).
//	values: The `N` Tensors to concatenate. Their ranks and types must match,
// and their sizes must match in all dimensions except `concat_dim`.
//
// Returns A `Tensor` with the concatenation of values stacked along the
// `concat_dim` dimension.  This tensor's shape matches that of `values` except
// in `concat_dim` where it has the sum of the sizes.
func Concat(scope *Scope, concat_dim tf.Output, values []tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Concat",
		Input: []tf.Input{
			concat_dim, tf.OutputList(values),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingMomentumParametersAttr is an optional argument to LoadTPUEmbeddingMomentumParameters.
type LoadTPUEmbeddingMomentumParametersAttr func(optionalAttr)

// LoadTPUEmbeddingMomentumParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingMomentumParametersTableId(value int64) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingMomentumParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingMomentumParametersTableName(value string) LoadTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load Momentum embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Momentum optimization algorithm.
//	momenta: Value of momenta used in the Momentum optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingMomentumParameters(scope *Scope, parameters tf.Output, momenta tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingMomentumParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingMomentumParameters",
		Input: []tf.Input{
			parameters, momenta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// AvgPoolGradAttr is an optional argument to AvgPoolGrad.
type AvgPoolGradAttr func(optionalAttr)

// AvgPoolGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func AvgPoolGradDataFormat(value string) AvgPoolGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the average pooling function.
//
// Arguments:
//	orig_input_shape: 1-D.  Shape of the original input to `avg_pool`.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t.
// the output of `avg_pool`.
//	ksize: The size of the sliding window for each dimension of the input.
//	strides: The stride of the sliding window for each dimension of the input.
//	padding: The type of padding algorithm to use.
//
// Returns 4-D.  Gradients w.r.t. the input of `avg_pool`.
func AvgPoolGrad(scope *Scope, orig_input_shape tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...AvgPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AvgPoolGrad",
		Input: []tf.Input{
			orig_input_shape, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedRelu6Attr is an optional argument to QuantizedRelu6.
type QuantizedRelu6Attr func(optionalAttr)

// QuantizedRelu6OutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedRelu6OutType(value tf.DataType) QuantizedRelu6Attr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear 6: `min(max(features, 0), 6)`
//
// Arguments:
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns Has the same output shape as "features".The float value that the lowest quantized value represents.The float value that the highest quantized value represents.
func QuantizedRelu6(scope *Scope, features tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedRelu6Attr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedRelu6",
		Input: []tf.Input{
			features, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceSparseApplyCenteredRMSPropAttr is an optional argument to ResourceSparseApplyCenteredRMSProp.
type ResourceSparseApplyCenteredRMSPropAttr func(optionalAttr)

// ResourceSparseApplyCenteredRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, mg, ms, and mom tensors is
// protected by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyCenteredRMSPropUseLocking(value bool) ResourceSparseApplyCenteredRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the centered RMSProp algorithm.
//
// The centered RMSProp algorithm uses an estimate of the centered second moment
// (i.e., the variance) for normalization, as opposed to regular RMSProp, which
// uses the (uncentered) second moment. This often helps with training, but is
// slightly more expensive in terms of computation and memory.
//
// Note that in dense implementation of this algorithm, mg, ms, and mom will
// update even if the grad is zero, but in this sparse implementation, mg, ms,
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// mean_grad = decay * mean_grad + (1-decay) * gradient
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon - mean_grad ** 2)
//
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	mg: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var, ms and mom.
//
// Returns the created operation.
func ResourceSparseApplyCenteredRMSProp(scope *Scope, var_ tf.Output, mg tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyCenteredRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyCenteredRMSProp",
		Input: []tf.Input{
			var_, mg, ms, mom, lr, rho, momentum, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Reshapes a SparseTensor to represent values in a new dense shape.
//
// This operation has the same semantics as reshape on the represented dense
// tensor.  The `input_indices` are recomputed based on the requested `new_shape`.
//
// If one component of `new_shape` is the special value -1, the size of that
// dimension is computed so that the total dense size remains constant.  At
// most one component of `new_shape` can be -1.  The number of dense elements
// implied by `new_shape` must be the same as the number of dense elements
// originally implied by `input_shape`.
//
// Reshaping does not affect the order of values in the SparseTensor.
//
// If the input tensor has rank `R_in` and `N` non-empty values, and `new_shape`
// has length `R_out`, then `input_indices` has shape `[N, R_in]`,
// `input_shape` has length `R_in`, `output_indices` has shape `[N, R_out]`, and
// `output_shape` has length `R_out`.
//
// Arguments:
//	input_indices: 2-D.  `N x R_in` matrix with the indices of non-empty values in a
// SparseTensor.
//	input_shape: 1-D.  `R_in` vector with the input SparseTensor's dense shape.
//	new_shape: 1-D.  `R_out` vector with the requested new dense shape.
//
// Returns 2-D.  `N x R_out` matrix with the updated indices of non-empty
// values in the output SparseTensor.1-D.  `R_out` vector with the full dense shape of the output
// SparseTensor.  This is the same as `new_shape` but with any -1 dimensions
// filled in.
func SparseReshape(scope *Scope, input_indices tf.Output, input_shape tf.Output, new_shape tf.Output) (output_indices tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseReshape",
		Input: []tf.Input{
			input_indices, input_shape, new_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// RetrieveTPUEmbeddingFTRLParametersAttr is an optional argument to RetrieveTPUEmbeddingFTRLParameters.
type RetrieveTPUEmbeddingFTRLParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingFTRLParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingFTRLParametersTableId(value int64) RetrieveTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingFTRLParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingFTRLParametersTableName(value string) RetrieveTPUEmbeddingFTRLParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve FTRL embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the FTRL optimization algorithm.Parameter accumulators updated by the FTRL optimization algorithm.Parameter linears updated by the FTRL optimization algorithm.
func RetrieveTPUEmbeddingFTRLParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingFTRLParametersAttr) (parameters tf.Output, accumulators tf.Output, linears tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingFTRLParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceSparseApplyProximalAdagradAttr is an optional argument to ResourceSparseApplyProximalAdagrad.
type ResourceSparseApplyProximalAdagradAttr func(optionalAttr)

// ResourceSparseApplyProximalAdagradUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyProximalAdagradUseLocking(value bool) ResourceSparseApplyProximalAdagradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Sparse update entries in '*var' and '*accum' according to FOBOS algorithm.
//
// That is for rows we have grad for, we update var and accum as follows:
// accum += grad * grad
// prox_v = var
// prox_v -= lr * grad * (1 / sqrt(accum))
// var = sign(prox_v)/(1+lr*l2) * max{|prox_v|-lr*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyProximalAdagrad(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyProximalAdagradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyProximalAdagrad",
		Input: []tf.Input{
			var_, accum, lr, l1, l2, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Creates a dataset that emits `components` as a tuple of tensors once.
func TensorDataset(scope *Scope, components []tf.Output, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "TensorDataset",
		Input: []tf.Input{
			tf.OutputList(components),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyAddSignAttr is an optional argument to ResourceApplyAddSign.
type ResourceApplyAddSignAttr func(optionalAttr)

// ResourceApplyAddSignUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and m tensors is
// protected by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAddSignUseLocking(value bool) ResourceApplyAddSignAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the AddSign update.
//
// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
// update <- (alpha + sign_decay * sign(g) *sign(m)) * g
// variable <- variable - lr_t * update
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	alpha: Must be a scalar.
//	sign_decay: Must be a scalar.
//	beta: Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAddSign(scope *Scope, var_ tf.Output, m tf.Output, lr tf.Output, alpha tf.Output, sign_decay tf.Output, beta tf.Output, grad tf.Output, optional ...ResourceApplyAddSignAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAddSign",
		Input: []tf.Input{
			var_, m, lr, alpha, sign_decay, beta, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceSparseApplyRMSPropAttr is an optional argument to ResourceSparseApplyRMSProp.
type ResourceSparseApplyRMSPropAttr func(optionalAttr)

// ResourceSparseApplyRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, ms, and mom tensors is protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyRMSPropUseLocking(value bool) ResourceSparseApplyRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the RMSProp algorithm.
//
// Note that in dense implementation of this algorithm, ms and mom will
// update even if the grad is zero, but in this sparse implementation, ms
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon)
//
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var, ms and mom.
//
// Returns the created operation.
func ResourceSparseApplyRMSProp(scope *Scope, var_ tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyRMSProp",
		Input: []tf.Input{
			var_, ms, mom, lr, rho, momentum, epsilon, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes the gradient of morphological 2-D dilation with respect to the filter.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, depth]`.
//	filter: 3-D with shape `[filter_height, filter_width, depth]`.
//	out_backprop: 4-D with shape `[batch, out_height, out_width, depth]`.
//	strides: 1-D of length 4. The stride of the sliding window for each dimension of
// the input tensor. Must be: `[1, stride_height, stride_width, 1]`.
//	rates: 1-D of length 4. The input stride for atrous morphological dilation.
// Must be: `[1, rate_height, rate_width, 1]`.
//	padding: The type of padding algorithm to use.
//
// Returns 3-D with shape `[filter_height, filter_width, depth]`.
func Dilation2DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, rates []int64, padding string) (filter_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "rates": rates, "padding": padding}
	opspec := tf.OpSpec{
		Type: "Dilation2DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Scatter `updates` into an existing tensor according to `indices`.
//
// This operation creates a new tensor by applying sparse `updates` to the passed
// in `tensor`.
// This operation is very similar to `tf.scatter_nd`, except that the updates are
// scattered onto an existing tensor (as opposed to a zero-tensor). If the memory
// for the existing tensor cannot be re-used, a copy is made and updated.
//
// If `indices` contains duplicates, then their updates are accumulated (summed).
//
// **WARNING**: The order in which updates are applied is nondeterministic, so the
// output will be nondeterministic if `indices` contains duplicates -- because
// of some numerical approximation issues, numbers summed in different order
// may yield different results.
//
// `indices` is an integer tensor containing indices into a new tensor of shape
// `shape`.  The last dimension of `indices` can be at most the rank of `shape`:
//
//     indices.shape[-1] <= shape.rank
//
// The last dimension of `indices` corresponds to indices into elements
// (if `indices.shape[-1] = shape.rank`) or slices
// (if `indices.shape[-1] < shape.rank`) along dimension `indices.shape[-1]` of
// `shape`.  `updates` is a tensor with shape
//
//     indices.shape[:-1] + shape[indices.shape[-1]:]
//
// The simplest form of scatter is to insert individual elements in a tensor by
// index. For example, say we want to insert 4 scattered elements in a rank-1
// tensor with 8 elements.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/ScatterNd1.png" alt>
// </div>
//
// In Python, this scatter operation would look like this:
//
// ```python
//     indices = tf.constant([[4], [3], [1], [7]])
//     updates = tf.constant([9, 10, 11, 12])
//     tensor = tf.ones([8], dtype=tf.int32)
//     updated = tf.tensor_scatter_update(tensor, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(scatter))
// ```
//
// The resulting tensor would look like this:
//
//     [1, 11, 1, 10, 9, 1, 1, 12]
//
// We can also, insert entire slices of a higher rank tensor all at once. For
// example, if we wanted to insert two slices in the first dimension of a
// rank-3 tensor with two matrices of new values.
//
// In Python, this scatter operation would look like this:
//
// ```python
//     indices = tf.constant([[0], [2]])
//     updates = tf.constant([[[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]],
//                            [[5, 5, 5, 5], [6, 6, 6, 6],
//                             [7, 7, 7, 7], [8, 8, 8, 8]]])
//     tensor = tf.ones([4, 4, 4])
//     updated = tf.tensor_scatter_update(tensor, indices, updates)
//     with tf.Session() as sess:
//       print(sess.run(scatter))
// ```
//
// The resulting tensor would look like this:
//
//     [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]],
//      [[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
//      [[1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1], [1, 1, 1, 1]]]
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, the index is ignored.
//
// Arguments:
//	tensor: Tensor to copy/update.
//	indices: Index tensor.
//	updates: Updates to scatter into output.
//
// Returns A new tensor with the given shape and updates applied according
// to the indices.
func TensorScatterUpdate(scope *Scope, tensor tf.Output, indices tf.Output, updates tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorScatterUpdate",
		Input: []tf.Input{
			tensor, indices, updates,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DAttr is an optional argument to Conv3D.
type Conv3DAttr func(optionalAttr)

// Conv3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DDataFormat(value string) Conv3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DDilations(value []int64) Conv3DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 3-D convolution given 5-D `input` and `filter` tensors.
//
// In signal processing, cross-correlation is a measure of similarity of
// two waveforms as a function of a time-lag applied to one of them. This
// is also known as a sliding dot product or sliding inner-product.
//
// Our Conv3D implements a form of cross-correlation.
//
// Arguments:
//	input: Shape `[batch, in_depth, in_height, in_width, in_channels]`.
//	filter: Shape `[filter_depth, filter_height, filter_width, in_channels,
// out_channels]`. `in_channels` must match between `input` and `filter`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv3DBackpropFilterAttr is an optional argument to Conv3DBackpropFilter.
type Conv3DBackpropFilterAttr func(optionalAttr)

// Conv3DBackpropFilterDilations sets the optional dilations attribute to value.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropFilterDilations(value []int64) Conv3DBackpropFilterAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the filter.
//
// DEPRECATED at GraphDef version 10: Use Conv3DBackpropFilterV2
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, in_channels]`.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropFilter(scope *Scope, input tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropFilterAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropFilter",
		Input: []tf.Input{
			input, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Selects elements from `x` or `y`, depending on `condition`.
//
// The `x`, and `y` tensors must all have the same shape, and the
// output will also have that shape.
//
// The `condition` tensor must be a scalar if `x` and `y` are scalars.
// If `x` and `y` are vectors or higher rank, then `condition` must be either a
// scalar, a vector with size matching the first dimension of `x`, or must have
// the same shape as `x`.
//
// The `condition` tensor acts as a mask that chooses, based on the value at each
// element, whether the corresponding element / row in the output should be
// taken from `x` (if true) or `y` (if false).
//
// If `condition` is a vector and `x` and `y` are higher rank matrices, then
// it chooses which row (outer dimension) to copy from `x` and `y`.
// If `condition` has the same shape as `x` and `y`, then it chooses which
// element to copy from `x` and `y`.
//
// For example:
//
// ```python
// # 'condition' tensor is [[True,  False]
// #                        [False, True]]
// # 't' is [[1, 2],
// #         [3, 4]]
// # 'e' is [[5, 6],
// #         [7, 8]]
// select(condition, t, e)  # => [[1, 6], [7, 4]]
//
//
// # 'condition' tensor is [True, False]
// # 't' is [[1, 2],
// #         [3, 4]]
// # 'e' is [[5, 6],
// #         [7, 8]]
// select(condition, t, e) ==> [[1, 2],
//                              [7, 8]]
//
// ```
//
// Arguments:
//
//	x: = A `Tensor` which may have the same shape as `condition`.
// If `condition` is rank 1, `x` may have higher rank,
// but its first dimension must match the size of `condition`.
//	y: = A `Tensor` with the same type and shape as `x`.
//
// Returns = A `Tensor` with the same type and shape as `x` and `y`.
func Select(scope *Scope, condition tf.Output, x tf.Output, y tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Select",
		Input: []tf.Input{
			condition, x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RealAttr is an optional argument to Real.
type RealAttr func(optionalAttr)

// RealTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func RealTout(value tf.DataType) RealAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Returns the real part of a complex number.
//
// Given a tensor `input` of complex numbers, this operation returns a tensor of
// type `float` that is the real part of each element in `input`. All elements in
// `input` must be complex numbers of the form \\(a + bj\\), where *a* is the real
//  part returned by this operation and *b* is the imaginary part.
//
// For example:
//
// ```
// # tensor 'input' is [-2.25 + 4.75j, 3.25 + 5.75j]
// tf.real(input) ==> [-2.25, 3.25]
// ```
func Real(scope *Scope, input tf.Output, optional ...RealAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Real",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes natural logarithm of (1 + x) element-wise.
//
// I.e., \\(y = \log_e (1 + x)\\).
func Log1p(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log1p",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes a new iterator from the given `dataset` and stores it in `iterator`.
//
// This operation may be executed multiple times. Each execution will reset the
// iterator in `iterator` to the first element of `dataset`.
//
// Returns the created operation.
func MakeIterator(scope *Scope, dataset tf.Output, iterator tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MakeIterator",
		Input: []tf.Input{
			dataset, iterator,
		},
	}
	return scope.AddOperation(opspec)
}

// Enqueue a Tensor on the computation outfeed.
//
// Arguments:
//	input: A tensor that will be inserted into the outfeed queue.
//
// Returns the created operation.
func OutfeedEnqueue(scope *Scope, input tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OutfeedEnqueue",
		Input: []tf.Input{
			input,
		},
	}
	return scope.AddOperation(opspec)
}

// RandomPoissonV2Attr is an optional argument to RandomPoissonV2.
type RandomPoissonV2Attr func(optionalAttr)

// RandomPoissonV2Seed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomPoissonV2Seed(value int64) RandomPoissonV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomPoissonV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomPoissonV2Seed2(value int64) RandomPoissonV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// RandomPoissonV2Dtype sets the optional dtype attribute to value.
// If not specified, defaults to DT_INT64
func RandomPoissonV2Dtype(value tf.DataType) RandomPoissonV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from the Poisson distribution(s) described by rate.
//
// This op uses two algorithms, depending on rate. If rate >= 10, then
// the algorithm by Hormann is used to acquire samples via
// transformation-rejection.
// See http://www.sciencedirect.com/science/article/pii/0167668793909974.
//
// Otherwise, Knuth's algorithm is used to acquire samples via multiplying uniform
// random variables.
// See Donald E. Knuth (1969). Seminumerical Algorithms. The Art of Computer
// Programming, Volume 2. Addison Wesley
//
// Arguments:
//	shape: 1-D integer tensor. Shape of independent samples to draw from each
// distribution described by the shape parameters given in rate.
//	rate: A tensor in which each scalar is a "rate" parameter describing the
// associated poisson distribution.
//
// Returns A tensor with shape `shape + shape(rate)`. Each slice
// `[:, ..., :, i0, i1, ...iN]` contains the samples drawn for
// `rate[i0, i1, ...iN]`.
func RandomPoissonV2(scope *Scope, shape tf.Output, rate tf.Output, optional ...RandomPoissonV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomPoissonV2",
		Input: []tf.Input{
			shape, rate,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Fetches multiple values from infeed as an XLA tuple.
//
// Arguments:
//	dtypes: The element types of each element in `outputs`.
//	shapes: The shapes of each tensor in `outputs`.
//
// Returns A list of tensors that will be provided using the infeed mechanism.
func InfeedDequeueTuple(scope *Scope, dtypes []tf.DataType, shapes []tf.Shape) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes, "shapes": shapes}
	opspec := tf.OpSpec{
		Type: "InfeedDequeueTuple",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("InfeedDequeueTuple", err)
		return
	}
	return outputs
}

// PlaceholderAttr is an optional argument to Placeholder.
type PlaceholderAttr func(optionalAttr)

// PlaceholderShape sets the optional shape attribute to value.
//
// value: (Optional) The shape of the tensor. If the shape has 0 dimensions, the
// shape is unconstrained.
// If not specified, defaults to <unknown_rank:true >
func PlaceholderShape(value tf.Shape) PlaceholderAttr {
	return func(m optionalAttr) {
		m["shape"] = value
	}
}

// A placeholder op for a value that will be fed into the computation.
//
// N.B. This operation will fail with an error if it is executed. It is
// intended as a way to represent a value that will always be fed, and to
// provide attrs that enable the fed value to be checked at runtime.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//
// Returns A placeholder tensor that must be replaced using the feed mechanism.
func Placeholder(scope *Scope, dtype tf.DataType, optional ...PlaceholderAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Placeholder",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reorders a SparseTensor into the canonical, row-major ordering.
//
// Note that by convention, all sparse ops preserve the canonical ordering along
// increasing dimension number. The only time ordering can be violated is during
// manual manipulation of the indices and values vectors to add entries.
//
// Reordering does not affect the shape of the SparseTensor.
//
// If the tensor has rank `R` and `N` non-empty values, `input_indices` has
// shape `[N, R]`, input_values has length `N`, and input_shape has length `R`.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//
// Returns 2-D.  `N x R` matrix with the same indices as input_indices, but
// in canonical row-major ordering.1-D.  `N` non-empty values corresponding to `output_indices`.
func SparseReorder(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output) (output_indices tf.Output, output_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseReorder",
		Input: []tf.Input{
			input_indices, input_values, input_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// LoadTPUEmbeddingProximalAdagradParametersAttr is an optional argument to LoadTPUEmbeddingProximalAdagradParameters.
type LoadTPUEmbeddingProximalAdagradParametersAttr func(optionalAttr)

// LoadTPUEmbeddingProximalAdagradParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingProximalAdagradParametersTableId(value int64) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingProximalAdagradParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingProximalAdagradParametersTableName(value string) LoadTPUEmbeddingProximalAdagradParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load proximal Adagrad embedding parameters.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the proximal Adagrad optimization algorithm.
//	accumulators: Value of accumulators used in the proximal Adagrad optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingProximalAdagradParameters(scope *Scope, parameters tf.Output, accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingProximalAdagradParametersAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingProximalAdagradParameters",
		Input: []tf.Input{
			parameters, accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingRMSPropParametersGradAccumDebug.
type LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingRMSPropParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load RMSProp embedding parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the RMSProp optimization algorithm.
//	ms: Value of ms used in the RMSProp optimization algorithm.
//	mom: Value of mom used in the RMSProp optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the RMSProp optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingRMSPropParametersGradAccumDebug(scope *Scope, parameters tf.Output, ms tf.Output, mom tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingRMSPropParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingRMSPropParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, ms, mom, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// DenseToSparseSetOperationAttr is an optional argument to DenseToSparseSetOperation.
type DenseToSparseSetOperationAttr func(optionalAttr)

// DenseToSparseSetOperationValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func DenseToSparseSetOperationValidateIndices(value bool) DenseToSparseSetOperationAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Applies set operation along last dimension of `Tensor` and `SparseTensor`.
//
// See SetOperationOp::SetOperationFromContext for values of `set_operation`.
//
// Input `set2` is a `SparseTensor` represented by `set2_indices`, `set2_values`,
// and `set2_shape`. For `set2` ranked `n`, 1st `n-1` dimensions must be the same
// as `set1`. Dimension `n` contains values in a set, duplicates are allowed but
// ignored.
//
// If `validate_indices` is `True`, this op validates the order and range of `set2`
// indices.
//
// Output `result` is a `SparseTensor` represented by `result_indices`,
// `result_values`, and `result_shape`. For `set1` and `set2` ranked `n`, this
// has rank `n` and the same 1st `n-1` dimensions as `set1` and `set2`. The `nth`
// dimension contains the result of `set_operation` applied to the corresponding
// `[0...n-1]` dimension of `set`.
//
// Arguments:
//	set1: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//	set2_indices: 2D `Tensor`, indices of a `SparseTensor`. Must be in row-major
// order.
//	set2_values: 1D `Tensor`, values of a `SparseTensor`. Must be in row-major
// order.
//	set2_shape: 1D `Tensor`, shape of a `SparseTensor`. `set2_shape[0...n-1]` must
// be the same as the 1st `n-1` dimensions of `set1`, `result_shape[n]` is the
// max set size across `n-1` dimensions.
//
//
// Returns 2D indices of a `SparseTensor`.1D values of a `SparseTensor`.1D `Tensor` shape of a `SparseTensor`. `result_shape[0...n-1]` is
// the same as the 1st `n-1` dimensions of `set1` and `set2`, `result_shape[n]`
// is the max result set size across all `0...n-1` dimensions.
func DenseToSparseSetOperation(scope *Scope, set1 tf.Output, set2_indices tf.Output, set2_values tf.Output, set2_shape tf.Output, set_operation string, optional ...DenseToSparseSetOperationAttr) (result_indices tf.Output, result_values tf.Output, result_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"set_operation": set_operation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseToSparseSetOperation",
		Input: []tf.Input{
			set1, set2_indices, set2_values, set2_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// UnicodeDecodeAttr is an optional argument to UnicodeDecode.
type UnicodeDecodeAttr func(optionalAttr)

// UnicodeDecodeErrors sets the optional errors attribute to value.
//
// value: Error handling policy when there is invalid formatting found in the input.
// The value of 'strict' will cause the operation to produce a InvalidArgument
// error on any invalid input formatting. A value of 'replace' (the default) will
// cause the operation to replace any invalid formatting in the input with the
// `replacement_char` codepoint. A value of 'ignore' will cause the operation to
// skip any invalid formatting in the input and produce no corresponding output
// character.
// If not specified, defaults to "replace"
func UnicodeDecodeErrors(value string) UnicodeDecodeAttr {
	return func(m optionalAttr) {
		m["errors"] = value
	}
}

// UnicodeDecodeReplacementChar sets the optional replacement_char attribute to value.
//
// value: The replacement character codepoint to be used in place of any invalid
// formatting in the input when `errors='replace'`. Any valid unicode codepoint may
// be used. The default value is the default unicode replacement character is
// 0xFFFD or U+65533.)
// If not specified, defaults to 65533
func UnicodeDecodeReplacementChar(value int64) UnicodeDecodeAttr {
	return func(m optionalAttr) {
		m["replacement_char"] = value
	}
}

// UnicodeDecodeReplaceControlCharacters sets the optional replace_control_characters attribute to value.
//
// value: Whether to replace the C0 control characters (00-1F) with the
// `replacement_char`. Default is false.
// If not specified, defaults to false
func UnicodeDecodeReplaceControlCharacters(value bool) UnicodeDecodeAttr {
	return func(m optionalAttr) {
		m["replace_control_characters"] = value
	}
}

// UnicodeDecodeTsplits sets the optional Tsplits attribute to value.
// If not specified, defaults to DT_INT64
func UnicodeDecodeTsplits(value tf.DataType) UnicodeDecodeAttr {
	return func(m optionalAttr) {
		m["Tsplits"] = value
	}
}

// Decodes each string in `input` into a sequence of Unicode code points.
//
// The character codepoints for all strings are returned using a single vector
// `char_values`, with strings expanded to characters in row-major order.
//
// The `row_splits` tensor indicates where the codepoints for
// each input string begin and end within the `char_values` tensor.
// In particular, the values for the `i`th
// string (in row-major order) are stored in the slice
// `[row_splits[i]:row_splits[i+1]]`. Thus:
//
// * `char_values[row_splits[i]+j]` is the Unicode codepoint for the `j`th
//   character in the `i`th string (in row-major order).
// * `row_splits[i+1] - row_splits[i]` is the number of characters in the `i`th
//   string (in row-major order).
//
// Arguments:
//	input: The text to be decoded. Can have any shape. Note that the output is flattened
// to a vector of char values.
//	input_encoding: Text encoding of the input strings. This is any of the encodings supported
// by ICU ucnv algorithmic converters. Examples: `"UTF-16", "US ASCII", "UTF-8"`.
//
// Returns A 1D int32 tensor containing the row splits.A 1D int32 Tensor containing the decoded codepoints.
func UnicodeDecode(scope *Scope, input tf.Output, input_encoding string, optional ...UnicodeDecodeAttr) (row_splits tf.Output, char_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_encoding": input_encoding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnicodeDecode",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ResourceApplyAdadeltaAttr is an optional argument to ResourceApplyAdadelta.
type ResourceApplyAdadeltaAttr func(optionalAttr)

// ResourceApplyAdadeltaUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var, accum and update_accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyAdadeltaUseLocking(value bool) ResourceApplyAdadeltaAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the adadelta scheme.
//
// accum = rho() * accum + (1 - rho()) * grad.square();
// update = (update_accum + epsilon).sqrt() * (accum + epsilon()).rsqrt() * grad;
// update_accum = rho() * update_accum + (1 - rho()) * update.square();
// var -= update;
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	accum_update: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay factor. Must be a scalar.
//	epsilon: Constant factor. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdadelta(scope *Scope, var_ tf.Output, accum tf.Output, accum_update tf.Output, lr tf.Output, rho tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdadeltaAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdadelta",
		Input: []tf.Input{
			var_, accum, accum_update, lr, rho, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Gets the next output from the given iterator as an Optional variant.
func IteratorGetNextAsOptional(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNextAsOptional",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RegexReplaceAttr is an optional argument to RegexReplace.
type RegexReplaceAttr func(optionalAttr)

// RegexReplaceReplaceGlobal sets the optional replace_global attribute to value.
//
// value: If True, the replacement is global (that is, all matches of the `pattern` regular
// expression in each input string are rewritten), otherwise the `rewrite`
// substitution is only made for the first `pattern` match.
// If not specified, defaults to true
func RegexReplaceReplaceGlobal(value bool) RegexReplaceAttr {
	return func(m optionalAttr) {
		m["replace_global"] = value
	}
}

// Replaces matches of the `pattern` regular expression in `input` with the
// replacement string provided in `rewrite`.
//
// It follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: The text to be processed.
//	pattern: The regular expression to be matched in the `input` strings.
//	rewrite: The rewrite string to be substituted for the `pattern` expression where it is
// matched in the `input` strings.
//
// Returns The text after applying pattern match and rewrite substitution.
func RegexReplace(scope *Scope, input tf.Output, pattern tf.Output, rewrite tf.Output, optional ...RegexReplaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RegexReplace",
		Input: []tf.Input{
			input, pattern, rewrite,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Output a fact about factorials.
func Fact(scope *Scope) (fact tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fact",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TopKAttr is an optional argument to TopK.
type TopKAttr func(optionalAttr)

// TopKSorted sets the optional sorted attribute to value.
//
// value: If true the resulting `k` elements will be sorted by the values in
// descending order.
// If not specified, defaults to true
func TopKSorted(value bool) TopKAttr {
	return func(m optionalAttr) {
		m["sorted"] = value
	}
}

// Finds values and indices of the `k` largest elements for the last dimension.
//
// DEPRECATED at GraphDef version 7: Use TopKV2 instead
//
// If the input is a vector (rank-1), finds the `k` largest entries in the vector
// and outputs their values and indices as vectors.  Thus `values[j]` is the
// `j`-th largest entry in `input`, and its index is `indices[j]`.
//
// For matrices (resp. higher rank input), computes the top `k` entries in each
// row (resp. vector along the last dimension).  Thus,
//
//     values.shape = indices.shape = input.shape[:-1] + [k]
//
// If two elements are equal, the lower-index element appears first.
//
// If `k` varies dynamically, use `TopKV2` below.
//
// Arguments:
//	input: 1-D or higher with last dimension at least `k`.
//	k: Number of top elements to look for along the last dimension (along each
// row for matrices).
//
// Returns The `k` largest elements along each last dimensional slice.The indices of `values` within the last dimension of `input`.
func TopK(scope *Scope, input tf.Output, k int64, optional ...TopKAttr) (values tf.Output, indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"k": k}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TopK",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// SparseToDenseAttr is an optional argument to SparseToDense.
type SparseToDenseAttr func(optionalAttr)

// SparseToDenseValidateIndices sets the optional validate_indices attribute to value.
//
// value: If true, indices are checked to make sure they are sorted in
// lexicographic order and that there are no repeats.
// If not specified, defaults to true
func SparseToDenseValidateIndices(value bool) SparseToDenseAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Converts a sparse representation into a dense tensor.
//
// Builds an array `dense` with shape `output_shape` such that
//
// ```
// # If sparse_indices is scalar
// dense[i] = (i == sparse_indices ? sparse_values : default_value)
//
// # If sparse_indices is a vector, then for each i
// dense[sparse_indices[i]] = sparse_values[i]
//
// # If sparse_indices is an n by d matrix, then for each i in [0, n)
// dense[sparse_indices[i][0], ..., sparse_indices[i][d-1]] = sparse_values[i]
// ```
//
// All other values in `dense` are set to `default_value`.  If `sparse_values` is a
// scalar, all sparse indices are set to this single value.
//
// Indices should be sorted in lexicographic order, and indices must not
// contain any repeats. If `validate_indices` is true, these properties
// are checked during execution.
//
// Arguments:
//	sparse_indices: 0-D, 1-D, or 2-D.  `sparse_indices[i]` contains the complete
// index where `sparse_values[i]` will be placed.
//	output_shape: 1-D.  Shape of the dense output tensor.
//	sparse_values: 1-D.  Values corresponding to each row of `sparse_indices`,
// or a scalar value to be used for all sparse indices.
//	default_value: Scalar value to set for indices not specified in
// `sparse_indices`.
//
// Returns Dense output tensor of shape `output_shape`.
func SparseToDense(scope *Scope, sparse_indices tf.Output, output_shape tf.Output, sparse_values tf.Output, default_value tf.Output, optional ...SparseToDenseAttr) (dense tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseToDense",
		Input: []tf.Input{
			sparse_indices, output_shape, sparse_values, default_value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Add the quantile summaries to each quantile stream resource.
//
// An op that adds a list of quantile summaries to a quantile stream resource. Each
// summary Tensor is rank 2, containing summaries (value, weight, min_rank, max_rank)
// for a single feature.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	summaries: string; List of Rank 2 Tensor each containing the summaries for a single feature.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceAddSummaries(scope *Scope, quantile_stream_resource_handle tf.Output, summaries []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceAddSummaries",
		Input: []tf.Input{
			quantile_stream_resource_handle, tf.OutputList(summaries),
		},
	}
	return scope.AddOperation(opspec)
}

// OrderedMapClearAttr is an optional argument to OrderedMapClear.
type OrderedMapClearAttr func(optionalAttr)

// OrderedMapClearCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapClearCapacity(value int64) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// OrderedMapClearMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func OrderedMapClearMemoryLimit(value int64) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// OrderedMapClearContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func OrderedMapClearContainer(value string) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// OrderedMapClearSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func OrderedMapClearSharedName(value string) OrderedMapClearAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op removes all elements in the underlying container.
//
// Returns the created operation.
func OrderedMapClear(scope *Scope, dtypes []tf.DataType, optional ...OrderedMapClearAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OrderedMapClear",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Execute a sub graph on a remote processor.
//
// The graph specifications(such as graph itself, input tensors and output names)
// are stored as a serialized protocol buffer of RemoteFusedGraphExecuteInfo
// as serialized_remote_fused_graph_execute_info.
// The specifications will be passed to a dedicated registered
// remote fused graph executor.  The executor will send the graph specifications
// to a remote processor and execute that graph.  The execution results
// will be passed to consumer nodes as outputs of this node.
//
// Arguments:
//	inputs: Arbitrary number of tensors with arbitrary data types
//
//	serialized_remote_fused_graph_execute_info: Serialized protocol buffer
// of RemoteFusedGraphExecuteInfo which contains graph specifications.
//
// Returns Arbitrary number of tensors with arbitrary data types
func RemoteFusedGraphExecute(scope *Scope, inputs []tf.Output, Toutputs []tf.DataType, serialized_remote_fused_graph_execute_info string) (outputs []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Toutputs": Toutputs, "serialized_remote_fused_graph_execute_info": serialized_remote_fused_graph_execute_info}
	opspec := tf.OpSpec{
		Type: "RemoteFusedGraphExecute",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if outputs, idx, err = makeOutputList(op, idx, "outputs"); err != nil {
		scope.UpdateErr("RemoteFusedGraphExecute", err)
		return
	}
	return outputs
}

// RetrieveTPUEmbeddingMomentumParametersAttr is an optional argument to RetrieveTPUEmbeddingMomentumParameters.
type RetrieveTPUEmbeddingMomentumParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingMomentumParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingMomentumParametersTableId(value int64) RetrieveTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingMomentumParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMomentumParametersTableName(value string) RetrieveTPUEmbeddingMomentumParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve Momentum embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the Momentum optimization algorithm.Parameter momenta updated by the Momentum optimization algorithm.
func RetrieveTPUEmbeddingMomentumParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingMomentumParametersAttr) (parameters tf.Output, momenta tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingMomentumParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Slice a `SparseTensor` based on the `start` and `size`.
//
// For example, if the input is
//
//     input_tensor = shape = [2, 7]
//     [    a   d e  ]
//     [b c          ]
//
// Graphically the output tensors are:
//
//     sparse_slice([0, 0], [2, 4]) = shape = [2, 4]
//     [    a  ]
//     [b c    ]
//
//     sparse_slice([0, 4], [2, 3]) = shape = [2, 3]
//     [ d e  ]
//     [      ]
//
// Arguments:
//	indices: 2-D tensor represents the indices of the sparse tensor.
//	values: 1-D tensor represents the values of the sparse tensor.
//	shape: 1-D. tensor represents the shape of the sparse tensor.
//	start: 1-D. tensor represents the start of the slice.
//	size: 1-D. tensor represents the size of the slice.
// output indices: A list of 1-D tensors represents the indices of the output
// sparse tensors.
//
// Returns A list of 1-D tensors represents the values of the output sparse
// tensors.A list of 1-D tensors represents the shape of the output sparse
// tensors.
func SparseSlice(scope *Scope, indices tf.Output, values tf.Output, shape tf.Output, start tf.Output, size tf.Output) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSlice",
		Input: []tf.Input{
			indices, values, shape, start, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceApplyFtrlAttr is an optional argument to ResourceApplyFtrl.
type ResourceApplyFtrlAttr func(optionalAttr)

// ResourceApplyFtrlUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyFtrlUseLocking(value bool) ResourceApplyFtrlAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the Ftrl-proximal scheme.
//
// accum_new = accum + grad * grad
// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
// accum = accum_new
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	linear: Should be from a Variable().
//	grad: The gradient.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regulariation. Must be a scalar.
//	l2: L2 regulariation. Must be a scalar.
//	lr_power: Scaling factor. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyFtrl(scope *Scope, var_ tf.Output, accum tf.Output, linear tf.Output, grad tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, lr_power tf.Output, optional ...ResourceApplyFtrlAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyFtrl",
		Input: []tf.Input{
			var_, accum, linear, grad, lr, l1, l2, lr_power,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// SnapshotDatasetAttr is an optional argument to SnapshotDataset.
type SnapshotDatasetAttr func(optionalAttr)

// SnapshotDatasetCompression sets the optional compression attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetCompression(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["compression"] = value
	}
}

// SnapshotDatasetReaderPathPrefix sets the optional reader_path_prefix attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetReaderPathPrefix(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["reader_path_prefix"] = value
	}
}

// SnapshotDatasetWriterPathPrefix sets the optional writer_path_prefix attribute to value.
// If not specified, defaults to ""
func SnapshotDatasetWriterPathPrefix(value string) SnapshotDatasetAttr {
	return func(m optionalAttr) {
		m["writer_path_prefix"] = value
	}
}

// Creates a dataset that will write to / read from a snapshot.
//
// This dataset attempts to determine whether a valid snapshot exists at the
// `snapshot_path`, and reads from the snapshot in lieu of using `input_dataset`.
// If not, it will run the preprocessing pipeline as usual, and write out a
// snapshot of the data processed for future use.
//
// Arguments:
//	input_dataset: A variant tensor representing the input dataset.
//	path: The path we should write snapshots to / read snapshots from.
//
//
func SnapshotDataset(scope *Scope, input_dataset tf.Output, path tf.Output, output_types []tf.DataType, output_shapes []tf.Shape, optional ...SnapshotDatasetAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SnapshotDataset",
		Input: []tf.Input{
			input_dataset, path,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UnstageAttr is an optional argument to Unstage.
type UnstageAttr func(optionalAttr)

// UnstageCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func UnstageCapacity(value int64) UnstageAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// UnstageMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func UnstageMemoryLimit(value int64) UnstageAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// UnstageContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func UnstageContainer(value string) UnstageAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// UnstageSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func UnstageSharedName(value string) UnstageAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op is similar to a lightweight Dequeue.
//
// The basic functionality is similar to dequeue with many fewer
// capabilities and options.  This Op is optimized for performance.
func Unstage(scope *Scope, dtypes []tf.DataType, optional ...UnstageAttr) (values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unstage",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if values, idx, err = makeOutputList(op, idx, "values"); err != nil {
		scope.UpdateErr("Unstage", err)
		return
	}
	return values
}

// Computes natural logarithm of x element-wise.
//
// I.e., \\(y = \log_e x\\).
func Log(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Log",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResizeBilinearGradAttr is an optional argument to ResizeBilinearGrad.
type ResizeBilinearGradAttr func(optionalAttr)

// ResizeBilinearGradAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and grad tensors are
// aligned. Defaults to false.
// If not specified, defaults to false
func ResizeBilinearGradAlignCorners(value bool) ResizeBilinearGradAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// ResizeBilinearGradHalfPixelCenters sets the optional half_pixel_centers attribute to value.
// If not specified, defaults to false
func ResizeBilinearGradHalfPixelCenters(value bool) ResizeBilinearGradAttr {
	return func(m optionalAttr) {
		m["half_pixel_centers"] = value
	}
}

// Computes the gradient of bilinear interpolation.
//
// Arguments:
//	grads: 4-D with shape `[batch, height, width, channels]`.
//	original_image: 4-D with shape `[batch, orig_height, orig_width, channels]`,
// The image tensor that was resized.
//
// Returns 4-D with shape `[batch, orig_height, orig_width, channels]`.
// Gradients with respect to the input image. Input image must have been
// float or double.
func ResizeBilinearGrad(scope *Scope, grads tf.Output, original_image tf.Output, optional ...ResizeBilinearGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeBilinearGrad",
		Input: []tf.Input{
			grads, original_image,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ThreadUnsafeUnigramCandidateSamplerAttr is an optional argument to ThreadUnsafeUnigramCandidateSampler.
type ThreadUnsafeUnigramCandidateSamplerAttr func(optionalAttr)

// ThreadUnsafeUnigramCandidateSamplerSeed sets the optional seed attribute to value.
//
// value: If either seed or seed2 are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func ThreadUnsafeUnigramCandidateSamplerSeed(value int64) ThreadUnsafeUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// ThreadUnsafeUnigramCandidateSamplerSeed2 sets the optional seed2 attribute to value.
//
// value: An second seed to avoid seed collision.
// If not specified, defaults to 0
func ThreadUnsafeUnigramCandidateSamplerSeed2(value int64) ThreadUnsafeUnigramCandidateSamplerAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Generates labels for candidate sampling with a learned unigram distribution.
//
// See explanations of candidate sampling and the data formats at
// go/candidate-sampling.
//
// For each batch, this op picks a single set of sampled candidate labels.
//
// The advantages of sampling candidates per-batch are simplicity and the
// possibility of efficient dense matrix multiplication. The disadvantage is that
// the sampled candidates must be chosen independently of the context and of the
// true labels.
//
// Arguments:
//	true_classes: A batch_size * num_true matrix, in which each row contains the
// IDs of the num_true target_classes in the corresponding original label.
//	num_true: Number of true labels per context.
//	num_sampled: Number of candidates to randomly sample.
//	unique: If unique is true, we sample with rejection, so that all sampled
// candidates in a batch are unique. This requires some approximation to
// estimate the post-rejection sampling probabilities.
//	range_max: The sampler will sample integers from the interval [0, range_max).
//
// Returns A vector of length num_sampled, in which each element is
// the ID of a sampled candidate.A batch_size * num_true matrix, representing
// the number of times each candidate is expected to occur in a batch
// of sampled candidates. If unique=true, then this is a probability.A vector of length num_sampled, for each sampled
// candidate representing the number of times the candidate is expected
// to occur in a batch of sampled candidates.  If unique=true, then this is a
// probability.
func ThreadUnsafeUnigramCandidateSampler(scope *Scope, true_classes tf.Output, num_true int64, num_sampled int64, unique bool, range_max int64, optional ...ThreadUnsafeUnigramCandidateSamplerAttr) (sampled_candidates tf.Output, true_expected_count tf.Output, sampled_expected_count tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_true": num_true, "num_sampled": num_sampled, "unique": unique, "range_max": range_max}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ThreadUnsafeUnigramCandidateSampler",
		Input: []tf.Input{
			true_classes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// DepthwiseConv2dNativeAttr is an optional argument to DepthwiseConv2dNative.
type DepthwiseConv2dNativeAttr func(optionalAttr)

// DepthwiseConv2dNativeDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func DepthwiseConv2dNativeDataFormat(value string) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// DepthwiseConv2dNativeDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each filter
// element on that dimension. The dimension order is determined by the value of
// `data_format`, see above for details. Dilations in the batch and depth
// dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func DepthwiseConv2dNativeDilations(value []int64) DepthwiseConv2dNativeAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D depthwise convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, channel_multiplier]`, containing
// `in_channels` convolutional filters of depth 1, `depthwise_conv2d` applies
// a different filter to each input channel (expanding from 1 channel to
// `channel_multiplier` channels for each), then concatenates the results
// together. Thus, the output has `in_channels * channel_multiplier` channels.
//
// ```
// for k in 0..in_channels-1
//   for q in 0..channel_multiplier-1
//     output[b, i, j, k * channel_multiplier + q] =
//       sum_{di, dj} input[b, strides[1] * i + di, strides[2] * j + dj, k] *
//                         filter[di, dj, k, q]
// ```
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
// of `input`.
//	padding: The type of padding algorithm to use.
func DepthwiseConv2dNative(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...DepthwiseConv2dNativeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DepthwiseConv2dNative",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Subtracts a value from the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the decremented value or a subsequent newer one.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignSubVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignSubVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// InfeedEnqueueTupleAttr is an optional argument to InfeedEnqueueTuple.
type InfeedEnqueueTupleAttr func(optionalAttr)

// InfeedEnqueueTupleLayouts sets the optional layouts attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence for
// all the tuple shapes, in the order the shapes appear in the "shapes" input.
// The layout elements for a sub-shape can be set to -1, in which case the
// corresponding layout will be computed by the infeed operation.
// If not specified, defaults to <>
func InfeedEnqueueTupleLayouts(value []int64) InfeedEnqueueTupleAttr {
	return func(m optionalAttr) {
		m["layouts"] = value
	}
}

// InfeedEnqueueTupleDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func InfeedEnqueueTupleDeviceOrdinal(value int64) InfeedEnqueueTupleAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Feeds multiple Tensor values into the computation as an XLA tuple.
//
// Arguments:
//	inputs: A list of tensors that will be provided using the infeed mechanism.
//	shapes: The shapes of each tensor in `inputs`.
//
// Returns the created operation.
func InfeedEnqueueTuple(scope *Scope, inputs []tf.Output, shapes []tf.Shape, optional ...InfeedEnqueueTupleAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueueTuple",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Converts each string in the input Tensor to its hash mod by a number of buckets.
//
// The hash function is deterministic on the content of the string within the
// process. The hash function is a keyed hash function, where attribute `key`
// defines the key of the hash function. `key` is an array of 2 elements.
//
// A strong hash is important when inputs may be malicious, e.g. URLs with
// additional components. Adversaries could try to make their inputs hash to the
// same bucket for a denial-of-service attack or to skew the results. A strong
// hash can be used to make it difficult to find inputs with a skewed hash value
// distribution over buckets. This requires that the hash function is
// seeded by a high-entropy (random) "key" unknown to the adversary.
//
// The additional robustness comes at a cost of roughly 4x higher compute
// time than `tf.string_to_hash_bucket_fast`.
//
// Arguments:
//	input: The strings to assign a hash bucket.
//	num_buckets: The number of buckets.
//	key: The key used to seed the hash function, passed as a list of two uint64
// elements.
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToHashBucketStrong(scope *Scope, input tf.Output, num_buckets int64, key []int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_buckets": num_buckets, "key": key}
	opspec := tf.OpSpec{
		Type: "StringToHashBucketStrong",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns 0 if x == 0, and x / y otherwise, elementwise.
func Xdivy(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Xdivy",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softsign: `features / (abs(features) + 1)`.
func Softsign(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Softsign",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Counts the number of occurrences of each value in an integer array.
//
// Outputs a vector with length `size` and the same dtype as `weights`. If
// `weights` are empty, then index `i` stores the number of times the value `i` is
// counted in `arr`. If `weights` are non-empty, then index `i` stores the sum of
// the value in `weights` at each index where the corresponding value in `arr` is
// `i`.
//
// Values in `arr` outside of the range [0, size) are ignored.
//
// Arguments:
//	arr: int32 `Tensor`.
//	size: non-negative int32 scalar `Tensor`.
//	weights: is an int32, int64, float32, or float64 `Tensor` with the same
// shape as `arr`, or a length-0 `Tensor`, in which case it acts as all weights
// equal to 1.
//
// Returns 1D `Tensor` with length equal to `size`. The counts or summed weights for
// each value in the range [0, size).
func Bincount(scope *Scope, arr tf.Output, size tf.Output, weights tf.Output) (bins tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Bincount",
		Input: []tf.Input{
			arr, size, weights,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes scaled exponential linear: `scale * alpha * (exp(features) - 1)`
//
// if < 0, `scale * features` otherwise.
//
// To be used together with
// `initializer = tf.variance_scaling_initializer(factor=1.0, mode='FAN_IN')`.
// For correct dropout, use `tf.contrib.nn.alpha_dropout`.
//
// See [Self-Normalizing Neural Networks](https://arxiv.org/abs/1706.02515)
func Selu(scope *Scope, features tf.Output) (activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Selu",
		Input: []tf.Input{
			features,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Check if the input matches the regex pattern.
//
// The input is a string tensor of any shape. The pattern is the
// regular expression to be matched with every element of the input tensor.
// The boolean values (True or False) of the output tensor indicate
// if the input matches the regex pattern provided.
//
// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: A string tensor of the text to be processed.
//	pattern: The regular expression to match the input.
//
// Returns A bool tensor with the same shape as `input`.
func StaticRegexFullMatch(scope *Scope, input tf.Output, pattern string) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pattern": pattern}
	opspec := tf.OpSpec{
		Type: "StaticRegexFullMatch",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the maximum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// This operator is similar to the unsorted segment sum operator found
// [(here)](../../../api_docs/python/math_ops.md#UnsortedSegmentSum).
// Instead of computing the sum over segments, it computes the maximum such that:
//
// \\(output_i = \max_{j...} data[j...]\\) where max is over tuples `j...` such
// that `segment_ids[j...] == i`.
//
// If the maximum is empty for a given segment ID `i`, it outputs the smallest
// possible value for the specific numeric type,
// `output[i] = numeric_limits<T>::lowest()`.
//
// If the given segment ID `i` is negative, then the corresponding value is
// dropped, and will not be included in the result.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/UnsortedSegmentMax.png" alt>
// </div>
//
// For example:
//
// ``` python
// c = tf.constant([[1,2,3,4], [5,6,7,8], [4,3,2,1]])
// tf.unsorted_segment_max(c, tf.constant([0, 1, 0]), num_segments=2)
// # ==> [[ 4,  3, 3, 4],
// #       [5,  6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A tensor whose shape is a prefix of `data.shape`.
//
//
// Returns Has same shape as data, except for the first `segment_ids.rank`
// dimensions, which are replaced with a single dimension which has size
// `num_segments`.
func UnsortedSegmentMax(scope *Scope, data tf.Output, segment_ids tf.Output, num_segments tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnsortedSegmentMax",
		Input: []tf.Input{
			data, segment_ids, num_segments,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns x / y element-wise for real types.
//
// If `x` and `y` are reals, this will return the floating-point division.
//
// *NOTE*: `Div` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func RealDiv(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RealDiv",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes gradients for SparseSegmentSqrtN.
//
// Returns tensor "output" with same shape as grad, except for dimension 0 whose
// value is output_dim0.
//
// Arguments:
//	grad: gradient propagated to the SparseSegmentSqrtN op.
//	indices: indices passed to the corresponding SparseSegmentSqrtN op.
//	segment_ids: segment_ids passed to the corresponding SparseSegmentSqrtN op.
//	output_dim0: dimension 0 of "data" passed to SparseSegmentSqrtN op.
func SparseSegmentSqrtNGrad(scope *Scope, grad tf.Output, indices tf.Output, segment_ids tf.Output, output_dim0 tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSegmentSqrtNGrad",
		Input: []tf.Input{
			grad, indices, segment_ids, output_dim0,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Calculate product with tridiagonal matrix.
//
// Calculates product of two matrices, where left matrix is a tridiagonal matrix.
//
// Arguments:
//	superdiag: Tensor of shape `[..., 1, M]`, representing superdiagonals of
// tri-diagonal matrices to the left of multiplication. Last element is ingored.
//	maindiag: Tensor of shape `[..., 1, M]`, representing main diagonals of tri-diagonal
// matrices to the left of multiplication.
//	subdiag: Tensor of shape `[..., 1, M]`, representing subdiagonals of tri-diagonal
// matrices to the left of multiplication. First element is ingored.
//	rhs: Tensor of shape `[..., M, N]`, representing MxN matrices to the right of
// multiplication.
//
// Returns Tensor of shape `[..., M, N]` containing the product.
func TridiagonalMatMul(scope *Scope, superdiag tf.Output, maindiag tf.Output, subdiag tf.Output, rhs tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TridiagonalMatMul",
		Input: []tf.Input{
			superdiag, maindiag, subdiag, rhs,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Locks a mutex resource.  The output is the lock.  So long as the lock tensor
//
// is alive, any other request to use `MutexLock` with this mutex will wait.
//
// This is particularly useful for creating a critical section when used in
// conjunction with `MutexLockIdentity`:
//
// ```python
//
// mutex = mutex_v2(
//   shared_name=handle_name, container=container, name=name)
//
// def execute_in_critical_section(fn, *args, **kwargs):
//   lock = gen_resource_variable_ops.mutex_lock(mutex)
//
//   with ops.control_dependencies([lock]):
//     r = fn(*args, **kwargs)
//
//   with ops.control_dependencies(nest.flatten(r)):
//     with ops.colocate_with(mutex):
//       ensure_lock_exists = mutex_lock_identity(lock)
//
//     # Make sure that if any element of r is accessed, all of
//     # them are executed together.
//     r = nest.map_structure(tf.identity, r)
//
//   with ops.control_dependencies([ensure_lock_exists]):
//     return nest.map_structure(tf.identity, r)
// ```
//
// While `fn` is running in the critical section, no other functions which wish to
// use this critical section may run.
//
// Often the use case is that two executions of the same graph, in parallel,
// wish to run `fn`; and we wish to ensure that only one of them executes
// at a time.  This is especially important if `fn` modifies one or more
// variables at a time.
//
// It is also useful if two separate functions must share a resource, but we
// wish to ensure the usage is exclusive.
//
// Arguments:
//	mutex: The mutex resource to lock.
//
// Returns A tensor that keeps a shared pointer to a lock on the mutex;
// when the Tensor is destroyed, the use count on the shared pointer is decreased
// by 1.  When it reaches 0, the lock is released.
func MutexLock(scope *Scope, mutex tf.Output) (mutex_lock tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MutexLock",
		Input: []tf.Input{
			mutex,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a list list which has the passed-in `Tensor` as last element and the other elements of the given list in `input_handle`.
//
// tensor: The tensor to put on the list.
// input_handle: The old list.
// output_handle: A list with the elements of the old list followed by tensor.
// element_dtype: the type of elements in the list.
// element_shape: a shape compatible with that of elements in the list.
func TensorListPushBack(scope *Scope, input_handle tf.Output, tensor tf.Output) (output_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorListPushBack",
		Input: []tf.Input{
			input_handle, tensor,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EditDistanceAttr is an optional argument to EditDistance.
type EditDistanceAttr func(optionalAttr)

// EditDistanceNormalize sets the optional normalize attribute to value.
//
// value: boolean (if true, edit distances are normalized by length of truth).
//
// The output is:
// If not specified, defaults to true
func EditDistanceNormalize(value bool) EditDistanceAttr {
	return func(m optionalAttr) {
		m["normalize"] = value
	}
}

// Computes the (possibly normalized) Levenshtein Edit Distance.
//
// The inputs are variable-length sequences provided by SparseTensors
//   (hypothesis_indices, hypothesis_values, hypothesis_shape)
// and
//   (truth_indices, truth_values, truth_shape).
//
// The inputs are:
//
// Arguments:
//	hypothesis_indices: The indices of the hypothesis list SparseTensor.
// This is an N x R int64 matrix.
//	hypothesis_values: The values of the hypothesis list SparseTensor.
// This is an N-length vector.
//	hypothesis_shape: The shape of the hypothesis list SparseTensor.
// This is an R-length vector.
//	truth_indices: The indices of the truth list SparseTensor.
// This is an M x R int64 matrix.
//	truth_values: The values of the truth list SparseTensor.
// This is an M-length vector.
//	truth_shape: truth indices, vector.
//
// Returns A dense float tensor with rank R - 1.
//
// For the example input:
//
//     // hypothesis represents a 2x1 matrix with variable-length values:
//     //   (0,0) = ["a"]
//     //   (1,0) = ["b"]
//     hypothesis_indices = [[0, 0, 0],
//                           [1, 0, 0]]
//     hypothesis_values = ["a", "b"]
//     hypothesis_shape = [2, 1, 1]
//
//     // truth represents a 2x2 matrix with variable-length values:
//     //   (0,0) = []
//     //   (0,1) = ["a"]
//     //   (1,0) = ["b", "c"]
//     //   (1,1) = ["a"]
//     truth_indices = [[0, 1, 0],
//                      [1, 0, 0],
//                      [1, 0, 1],
//                      [1, 1, 0]]
//     truth_values = ["a", "b", "c", "a"]
//     truth_shape = [2, 2, 2]
//     normalize = true
//
// The output will be:
//
//     // output is a 2x2 matrix with edit distances normalized by truth lengths.
//     output = [[inf, 1.0],  // (0,0): no truth, (0,1): no hypothesis
//               [0.5, 1.0]]  // (1,0): addition, (1,1): no hypothesis
func EditDistance(scope *Scope, hypothesis_indices tf.Output, hypothesis_values tf.Output, hypothesis_shape tf.Output, truth_indices tf.Output, truth_values tf.Output, truth_shape tf.Output, optional ...EditDistanceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EditDistance",
		Input: []tf.Input{
			hypothesis_indices, hypothesis_values, hypothesis_shape, truth_indices, truth_values, truth_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs a tensor containing the reduction across all input tensors.
//
// Outputs a tensor containing the reduction across all input tensors passed to ops
// within the same `shared_name.
//
// The graph should be constructed so if one op runs with shared_name value `c`,
// then `num_devices` ops will run with shared_name value `c`.  Failure to do so
// will cause the graph execution to fail to complete.
//
// input: the input to the reduction
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
// num_devices: The number of devices participating in this reduction.
// shared_name: Identifier that shared between ops of the same reduction.
func NcclAllReduce(scope *Scope, input tf.Output, reduction string, num_devices int64, shared_name string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction, "num_devices": num_devices, "shared_name": shared_name}
	opspec := tf.OpSpec{
		Type: "NcclAllReduce",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Outputs the single element from the given dataset.
//
// Arguments:
//	dataset: A handle to a dataset that contains a single element.
//
//
//
// Returns The components of the single element of `input`.
func DatasetToSingleElement(scope *Scope, dataset tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "DatasetToSingleElement",
		Input: []tf.Input{
			dataset,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("DatasetToSingleElement", err)
		return
	}
	return components
}

// ResourceApplyCenteredRMSPropAttr is an optional argument to ResourceApplyCenteredRMSProp.
type ResourceApplyCenteredRMSPropAttr func(optionalAttr)

// ResourceApplyCenteredRMSPropUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, mg, ms, and mom tensors is
// protected by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyCenteredRMSPropUseLocking(value bool) ResourceApplyCenteredRMSPropAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the centered RMSProp algorithm.
//
// The centered RMSProp algorithm uses an estimate of the centered second moment
// (i.e., the variance) for normalization, as opposed to regular RMSProp, which
// uses the (uncentered) second moment. This often helps with training, but is
// slightly more expensive in terms of computation and memory.
//
// Note that in dense implementation of this algorithm, mg, ms, and mom will
// update even if the grad is zero, but in this sparse implementation, mg, ms,
// and mom will not update in iterations during which the grad is zero.
//
// mean_square = decay * mean_square + (1-decay) * gradient ** 2
// mean_grad = decay * mean_grad + (1-decay) * gradient
//
// Delta = learning_rate * gradient / sqrt(mean_square + epsilon - mean_grad ** 2)
//
// mg <- rho * mg_{t-1} + (1-rho) * grad
// ms <- rho * ms_{t-1} + (1-rho) * grad * grad
// mom <- momentum * mom_{t-1} + lr * grad / sqrt(ms - mg * mg + epsilon)
// var <- var - mom
//
// Arguments:
//	var_: Should be from a Variable().
//	mg: Should be from a Variable().
//	ms: Should be from a Variable().
//	mom: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	rho: Decay rate. Must be a scalar.
//
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyCenteredRMSProp(scope *Scope, var_ tf.Output, mg tf.Output, ms tf.Output, mom tf.Output, lr tf.Output, rho tf.Output, momentum tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyCenteredRMSPropAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyCenteredRMSProp",
		Input: []tf.Input{
			var_, mg, ms, mom, lr, rho, momentum, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyKerasMomentumAttr is an optional argument to ResourceApplyKerasMomentum.
type ResourceApplyKerasMomentumAttr func(optionalAttr)

// ResourceApplyKerasMomentumUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyKerasMomentumUseLocking(value bool) ResourceApplyKerasMomentumAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyKerasMomentumUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, the tensor passed to compute grad will be
// var + momentum * accum, so in the end, the var you get is actually
// var + momentum * accum.
// If not specified, defaults to false
func ResourceApplyKerasMomentumUseNesterov(value bool) ResourceApplyKerasMomentumAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the momentum scheme. Set use_nesterov = True if you
//
// want to use Nesterov momentum.
//
// accum = accum * momentum - lr * grad
// var += accum
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	grad: The gradient.
//	momentum: Momentum. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyKerasMomentum(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, momentum tf.Output, optional ...ResourceApplyKerasMomentumAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyKerasMomentum",
		Input: []tf.Input{
			var_, accum, lr, grad, momentum,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Conv3DBackpropInputV2Attr is an optional argument to Conv3DBackpropInputV2.
type Conv3DBackpropInputV2Attr func(optionalAttr)

// Conv3DBackpropInputV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func Conv3DBackpropInputV2DataFormat(value string) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv3DBackpropInputV2Dilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 5.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 i:1 >
func Conv3DBackpropInputV2Dilations(value []int64) Conv3DBackpropInputV2Attr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes the gradients of 3-D convolution with respect to the input.
//
// Arguments:
//	input_sizes: An integer vector representing the tensor shape of `input`,
// where `input` is a 5-D
// `[batch, depth, rows, cols, in_channels]` tensor.
//	filter: Shape `[depth, rows, cols, in_channels, out_channels]`.
// `in_channels` must match between `input` and `filter`.
//	out_backprop: Backprop signal of shape `[batch, out_depth, out_rows, out_cols,
// out_channels]`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
func Conv3DBackpropInputV2(scope *Scope, input_sizes tf.Output, filter tf.Output, out_backprop tf.Output, strides []int64, padding string, optional ...Conv3DBackpropInputV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv3DBackpropInputV2",
		Input: []tf.Input{
			input_sizes, filter, out_backprop,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyProximalGradientDescentAttr is an optional argument to ResourceApplyProximalGradientDescent.
type ResourceApplyProximalGradientDescentAttr func(optionalAttr)

// ResourceApplyProximalGradientDescentUseLocking sets the optional use_locking attribute to value.
//
// value: If True, the subtraction will be protected by a lock;
// otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyProximalGradientDescentUseLocking(value bool) ResourceApplyProximalGradientDescentAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' as FOBOS algorithm with fixed learning rate.
//
// prox_v = var - alpha * delta
// var = sign(prox_v)/(1+alpha*l2) * max{|prox_v|-alpha*l1,0}
//
// Arguments:
//	var_: Should be from a Variable().
//	alpha: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	delta: The change.
//
// Returns the created operation.
func ResourceApplyProximalGradientDescent(scope *Scope, var_ tf.Output, alpha tf.Output, l1 tf.Output, l2 tf.Output, delta tf.Output, optional ...ResourceApplyProximalGradientDescentAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyProximalGradientDescent",
		Input: []tf.Input{
			var_, alpha, l1, l2, delta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Output the logits for the given input data
//
// Arguments:
//	tree_handle: Handle to the tree resource.
//	dense_features: Rank 2 dense features tensor.
//	logits_dimension: Scalar, dimension of the logits.
//
// Returns The logits predictions from the tree for each instance in the batch.
func TensorForestTreePredict(scope *Scope, tree_handle tf.Output, dense_features tf.Output, logits_dimension int64) (logits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"logits_dimension": logits_dimension}
	opspec := tf.OpSpec{
		Type: "TensorForestTreePredict",
		Input: []tf.Input{
			tree_handle, dense_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generate a sharded filename. The filename is printf formatted as
//
//    %s-%05d-of-%05d, basename, shard, num_shards.
func ShardedFilename(scope *Scope, basename tf.Output, shard tf.Output, num_shards tf.Output) (filename tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ShardedFilename",
		Input: []tf.Input{
			basename, shard, num_shards,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyAdagradDAAttr is an optional argument to ResourceApplyAdagradDA.
type ResourceApplyAdagradDAAttr func(optionalAttr)

// ResourceApplyAdagradDAUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyAdagradDAUseLocking(value bool) ResourceApplyAdagradDAAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the proximal adagrad scheme.
//
// Arguments:
//	var_: Should be from a Variable().
//	gradient_accumulator: Should be from a Variable().
//	gradient_squared_accumulator: Should be from a Variable().
//	grad: The gradient.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	global_step: Training step number. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyAdagradDA(scope *Scope, var_ tf.Output, gradient_accumulator tf.Output, gradient_squared_accumulator tf.Output, grad tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, global_step tf.Output, optional ...ResourceApplyAdagradDAAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdagradDA",
		Input: []tf.Input{
			var_, gradient_accumulator, gradient_squared_accumulator, grad, lr, l1, l2, global_step,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes sigmoid of `x` element-wise.
//
// Specifically, `y = 1 / (1 + exp(-x))`.
func Sigmoid(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sigmoid",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedReluXAttr is an optional argument to QuantizedReluX.
type QuantizedReluXAttr func(optionalAttr)

// QuantizedReluXOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedReluXOutType(value tf.DataType) QuantizedReluXAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear X: `min(max(features, 0), max_value)`
//
// Arguments:
//
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns Has the same output shape as "features".The float value that the lowest quantized value represents.The float value that the highest quantized value represents.
func QuantizedReluX(scope *Scope, features tf.Output, max_value tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedReluXAttr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedReluX",
		Input: []tf.Input{
			features, max_value, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes a range that covers the actual values present in a quantized tensor.
//
// Given a quantized tensor described by `(input, input_min, input_max)`, outputs a
// range that covers the actual values present in that tensor. This op is typically
// used to produce the `requested_output_min` and `requested_output_max` for
// `Requantize`.
//
// Arguments:
//
//	input_min: The float value that the minimum quantized input value represents.
//	input_max: The float value that the maximum quantized input value represents.
//
// Returns The computed min output.the computed max output.
func RequantizationRange(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output) (output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RequantizationRange",
		Input: []tf.Input{
			input, input_min, input_max,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// ResourceApplyGradientDescentAttr is an optional argument to ResourceApplyGradientDescent.
type ResourceApplyGradientDescentAttr func(optionalAttr)

// ResourceApplyGradientDescentUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, the subtraction will be protected by a lock;
// otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceApplyGradientDescentUseLocking(value bool) ResourceApplyGradientDescentAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' by subtracting 'alpha' * 'delta' from it.
//
// Arguments:
//	var_: Should be from a Variable().
//	alpha: Scaling factor. Must be a scalar.
//	delta: The change.
//
// Returns the created operation.
func ResourceApplyGradientDescent(scope *Scope, var_ tf.Output, alpha tf.Output, delta tf.Output, optional ...ResourceApplyGradientDescentAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyGradientDescent",
		Input: []tf.Input{
			var_, alpha, delta,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Computes softmax cross entropy cost and gradients to backpropagate.
//
// Unlike `SoftmaxCrossEntropyWithLogits`, this operation does not accept
// a matrix of label probabilities, but rather a single label per row
// of features.  This label is considered to have probability 1.0 for the
// given row.
//
// Inputs are the logits, not probabilities.
//
// Arguments:
//	features: batch_size x num_classes matrix
//	labels: batch_size vector with values in [0, num_classes).
// This is the label for the given minibatch entry.
//
// Returns Per example loss (batch_size vector).backpropagated gradients (batch_size x num_classes matrix).
func SparseSoftmaxCrossEntropyWithLogits(scope *Scope, features tf.Output, labels tf.Output) (loss tf.Output, backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSoftmaxCrossEntropyWithLogits",
		Input: []tf.Input{
			features, labels,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Replaces the contents of the table with the specified keys and values.
//
// The tensor `keys` must be of the same type as the keys of the table.
// The tensor `values` must be of the type of the table values.
//
// Arguments:
//	table_handle: Handle to the table.
//	keys: Any shape.  Keys to look up.
//	values: Values to associate with keys.
//
// Returns the created operation.
func LookupTableImportV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LookupTableImportV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Deserialize bucket boundaries and ready flag into current QuantileAccumulator.
//
// An op that deserializes bucket boundaries and are boundaries ready flag into current QuantileAccumulator.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	bucket_boundaries: float; List of Rank 1 Tensors each containing the bucket boundaries for a feature.
//
// Returns the created operation.
func BoostedTreesQuantileStreamResourceDeserialize(scope *Scope, quantile_stream_resource_handle tf.Output, bucket_boundaries []tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceDeserialize",
		Input: []tf.Input{
			quantile_stream_resource_handle, tf.OutputList(bucket_boundaries),
		},
	}
	return scope.AddOperation(opspec)
}

// Returns the value stored in an Optional variant or raises an error if none exists.
func OptionalGetValue(scope *Scope, optional tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "OptionalGetValue",
		Input: []tf.Input{
			optional,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("OptionalGetValue", err)
		return
	}
	return components
}

// Adds up a `SparseTensor` and a dense `Tensor`, producing a dense `Tensor`.
//
// This Op does not require `a_indices` be sorted in standard lexicographic order.
//
// Arguments:
//	a_indices: 2-D.  The `indices` of the `SparseTensor`, with shape `[nnz, ndims]`.
//	a_values: 1-D.  The `values` of the `SparseTensor`, with shape `[nnz]`.
//	a_shape: 1-D.  The `shape` of the `SparseTensor`, with shape `[ndims]`.
//	b: `ndims`-D Tensor.  With shape `a_shape`.
func SparseTensorDenseAdd(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseTensorDenseAdd",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPool3DAttr is an optional argument to MaxPool3D.
type MaxPool3DAttr func(optionalAttr)

// MaxPool3DDataFormat sets the optional data_format attribute to value.
//
// value: The data format of the input and output data. With the
// default format "NDHWC", the data is stored in the order of:
//     [batch, in_depth, in_height, in_width, in_channels].
// Alternatively, the format could be "NCDHW", the data storage order is:
//     [batch, in_channels, in_depth, in_height, in_width].
// If not specified, defaults to "NDHWC"
func MaxPool3DDataFormat(value string) MaxPool3DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Performs 3D max pooling on the input.
//
// Arguments:
//	input: Shape `[batch, depth, rows, cols, channels]` tensor to pool over.
//	ksize: 1-D tensor of length 5. The size of the window for each dimension of
// the input tensor. Must have `ksize[0] = ksize[4] = 1`.
//	strides: 1-D tensor of length 5. The stride of the sliding window for each
// dimension of `input`. Must have `strides[0] = strides[4] = 1`.
//	padding: The type of padding algorithm to use.
//
// Returns The max pooled output tensor.
func MaxPool3D(scope *Scope, input tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPool3DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPool3D",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ExperimentalStatsAggregatorHandleAttr is an optional argument to ExperimentalStatsAggregatorHandle.
type ExperimentalStatsAggregatorHandleAttr func(optionalAttr)

// ExperimentalStatsAggregatorHandleContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func ExperimentalStatsAggregatorHandleContainer(value string) ExperimentalStatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// ExperimentalStatsAggregatorHandleSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func ExperimentalStatsAggregatorHandleSharedName(value string) ExperimentalStatsAggregatorHandleAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Creates a statistics manager resource.
func ExperimentalStatsAggregatorHandle(scope *Scope, optional ...ExperimentalStatsAggregatorHandleAttr) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalStatsAggregatorHandle",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// IteratorFromStringHandleAttr is an optional argument to IteratorFromStringHandle.
type IteratorFromStringHandleAttr func(optionalAttr)

// IteratorFromStringHandleOutputTypes sets the optional output_types attribute to value.
//
// value: If specified, defines the type of each tuple component in an
// element produced by the resulting iterator.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func IteratorFromStringHandleOutputTypes(value []tf.DataType) IteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_types"] = value
	}
}

// IteratorFromStringHandleOutputShapes sets the optional output_shapes attribute to value.
//
// value: If specified, defines the shape of each tuple component in an
// element produced by the resulting iterator.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func IteratorFromStringHandleOutputShapes(value []tf.Shape) IteratorFromStringHandleAttr {
	return func(m optionalAttr) {
		m["output_shapes"] = value
	}
}

// Converts the given string representing a handle to an iterator to a resource.
//
// Arguments:
//	string_handle: A string representation of the given handle.
//
// Returns A handle to an iterator resource.
func IteratorFromStringHandle(scope *Scope, string_handle tf.Output, optional ...IteratorFromStringHandleAttr) (resource_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "IteratorFromStringHandle",
		Input: []tf.Input{
			string_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	num_threads: Identifies the number of threads to use for the private threadpool.
//
//
func ExperimentalPrivateThreadPoolDataset(scope *Scope, input_dataset tf.Output, num_threads tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalPrivateThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, num_threads,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// PreventGradientAttr is an optional argument to PreventGradient.
type PreventGradientAttr func(optionalAttr)

// PreventGradientMessage sets the optional message attribute to value.
//
// value: Will be printed in the error when anyone tries to differentiate
// this operation.
// If not specified, defaults to ""
func PreventGradientMessage(value string) PreventGradientAttr {
	return func(m optionalAttr) {
		m["message"] = value
	}
}

// An identity op that triggers an error if a gradient is requested.
//
// When executed in a graph, this op outputs its input tensor as-is.
//
// When building ops to compute gradients, the TensorFlow gradient system
// will return an error when trying to lookup the gradient of this op,
// because no gradient must ever be registered for this function.  This
// op exists to prevent subtle bugs from silently returning unimplemented
// gradients in some corner cases.
//
// Arguments:
//	input: any tensor.
//
// Returns the same input tensor.
func PreventGradient(scope *Scope, input tf.Output, optional ...PreventGradientAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PreventGradient",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// EnqueueTPUEmbeddingSparseBatchAttr is an optional argument to EnqueueTPUEmbeddingSparseBatch.
type EnqueueTPUEmbeddingSparseBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingSparseBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingSparseBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingSparseBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// EnqueueTPUEmbeddingSparseBatchCombiners sets the optional combiners attribute to value.
//
// value: A list of string scalars, one for each embedding table that specify
// how to normalize the embedding activations after weighted summation.
// Supported combiners are 'mean', 'sum', or 'sqrtn'. It is invalid to have
// the sum of the weights be 0 for 'mean' or the sum of the squared weights be
// 0 for 'sqrtn'. If combiners isn't passed, the default is to use 'sum' for
// all tables.
// If not specified, defaults to <>
func EnqueueTPUEmbeddingSparseBatchCombiners(value []string) EnqueueTPUEmbeddingSparseBatchAttr {
	return func(m optionalAttr) {
		m["combiners"] = value
	}
}

// An op that enqueues TPUEmbedding input indices from a SparseTensor.
//
// This Op eases the porting of code that uses embedding_lookup_sparse(),
// although some Python preprocessing of the SparseTensor arguments to
// embedding_lookup_sparse() is required to produce the arguments to this Op,
// since only a single EnqueueTPUEmbeddingSparseBatch Op is allowed per training
// step.
//
// The tensors at corresponding positions in the three input lists
// must have the same shape, i.e. rank 1 with dim_size() equal to the total
// number of lookups into the table described by the corresponding table_id.
//
// Arguments:
//	sample_indices: A list of rank 1 Tensors specifying the training example and
// feature to which the corresponding embedding_indices and aggregation_weights
// values belong. sample_indices[i] must equal b * nf + f, where nf is the
// number of features from the corresponding table, f is in [0, nf), and
// b is in [0, batch size).
//	embedding_indices: A list of rank 1 Tensors, indices into the embedding tables.
//	aggregation_weights: A list of rank 1 Tensors containing per sample -- i.e. per
// (training example, feature) -- aggregation weights.
//	mode_override: A string input that overrides the mode specified in the
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingSparseBatch(scope *Scope, sample_indices []tf.Output, embedding_indices []tf.Output, aggregation_weights []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingSparseBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingSparseBatch",
		Input: []tf.Input{
			tf.OutputList(sample_indices), tf.OutputList(embedding_indices), tf.OutputList(aggregation_weights), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// EncodeBase64Attr is an optional argument to EncodeBase64.
type EncodeBase64Attr func(optionalAttr)

// EncodeBase64Pad sets the optional pad attribute to value.
//
// value: Bool whether padding is applied at the ends.
// If not specified, defaults to false
func EncodeBase64Pad(value bool) EncodeBase64Attr {
	return func(m optionalAttr) {
		m["pad"] = value
	}
}

// Encode strings into web-safe base64 format.
//
// Refer to the following article for more information on base64 format:
// en.wikipedia.org/wiki/Base64. Base64 strings may have padding with '=' at the
// end so that the encoded has length multiple of 4. See Padding section of the
// link above.
//
// Web-safe means that the encoder uses - and _ instead of + and /.
//
// Arguments:
//	input: Strings to be encoded.
//
// Returns Input strings encoded in base64.
func EncodeBase64(scope *Scope, input tf.Output, optional ...EncodeBase64Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EncodeBase64",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceSparseApplyFtrlAttr is an optional argument to ResourceSparseApplyFtrl.
type ResourceSparseApplyFtrlAttr func(optionalAttr)

// ResourceSparseApplyFtrlUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyFtrlUseLocking(value bool) ResourceSparseApplyFtrlAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update relevant entries in '*var' according to the Ftrl-proximal scheme.
//
// That is for rows we have grad for, we update var, accum and linear as follows:
// accum_new = accum + grad * grad
// linear += grad - (accum_new^(-lr_power) - accum^(-lr_power)) / lr * var
// quadratic = 1.0 / (accum_new^(lr_power) * lr) + 2 * l2
// var = (sign(linear) * l1 - linear) / quadratic if |linear| > l1 else 0.0
// accum = accum_new
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	linear: Should be from a Variable().
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	lr: Scaling factor. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	lr_power: Scaling factor. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyFtrl(scope *Scope, var_ tf.Output, accum tf.Output, linear tf.Output, grad tf.Output, indices tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, lr_power tf.Output, optional ...ResourceSparseApplyFtrlAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyFtrl",
		Input: []tf.Input{
			var_, accum, linear, grad, indices, lr, l1, l2, lr_power,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// TensorArrayGatherV3Attr is an optional argument to TensorArrayGatherV3.
type TensorArrayGatherV3Attr func(optionalAttr)

// TensorArrayGatherV3ElementShape sets the optional element_shape attribute to value.
//
// value: The expected shape of an element, if known. Used to
// validate the shapes of TensorArray elements. If this shape is not
// fully specified, gathering zero-size TensorArrays is an error.
// If not specified, defaults to <unknown_rank:true >
func TensorArrayGatherV3ElementShape(value tf.Shape) TensorArrayGatherV3Attr {
	return func(m optionalAttr) {
		m["element_shape"] = value
	}
}

// Gather specific elements from the TensorArray into output `value`.
//
// All elements selected by `indices` must have the same shape.
//
// Arguments:
//	handle: The handle to a TensorArray.
//	indices: The locations in the TensorArray from which to read tensor elements.
//	flow_in: A float scalar that enforces proper chaining of operations.
//	dtype: The type of the elem that is returned.
//
// Returns All of the elements in the TensorArray, concatenated along a new
// axis (the new dimension 0).
func TensorArrayGatherV3(scope *Scope, handle tf.Output, indices tf.Output, flow_in tf.Output, dtype tf.DataType, optional ...TensorArrayGatherV3Attr) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayGatherV3",
		Input: []tf.Input{
			handle, indices, flow_in,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Makes the summary of quantiles for the batch.
//
// An op that takes a list of tensors (one tensor per feature) and outputs the
// quantile summaries for each tensor.
//
// Arguments:
//	float_values: float; List of Rank 1 Tensors each containing values for a single feature.
//	example_weights: float; Rank 1 Tensor with weights per instance.
//	epsilon: float; The required maximum approximation error.
//
// Returns float; List of Rank 2 Tensors each containing the quantile summary
// (value, weight, min_rank, max_rank) of a single feature.
func BoostedTreesMakeQuantileSummaries(scope *Scope, float_values []tf.Output, example_weights tf.Output, epsilon tf.Output) (summaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesMakeQuantileSummaries",
		Input: []tf.Input{
			tf.OutputList(float_values), example_weights, epsilon,
		},
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if summaries, idx, err = makeOutputList(op, idx, "summaries"); err != nil {
		scope.UpdateErr("BoostedTreesMakeQuantileSummaries", err)
		return
	}
	return summaries
}

// StatelessMultinomialAttr is an optional argument to StatelessMultinomial.
type StatelessMultinomialAttr func(optionalAttr)

// StatelessMultinomialOutputDtype sets the optional output_dtype attribute to value.
// If not specified, defaults to DT_INT64
func StatelessMultinomialOutputDtype(value tf.DataType) StatelessMultinomialAttr {
	return func(m optionalAttr) {
		m["output_dtype"] = value
	}
}

// Draws samples from a multinomial distribution.
//
// Arguments:
//	logits: 2-D Tensor with shape `[batch_size, num_classes]`.  Each slice `[i, :]`
// represents the unnormalized log probabilities for all classes.
//	num_samples: 0-D.  Number of independent samples to draw for each row slice.
//	seed: 2 seeds (shape [2]).
//
// Returns 2-D Tensor with shape `[batch_size, num_samples]`.  Each slice `[i, :]`
// contains the drawn class labels with range `[0, num_classes)`.
func StatelessMultinomial(scope *Scope, logits tf.Output, num_samples tf.Output, seed tf.Output, optional ...StatelessMultinomialAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessMultinomial",
		Input: []tf.Input{
			logits, num_samples, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingAdagradParametersGradAccumDebug.
type RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve Adagrad embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the Adagrad optimization algorithm.Parameter accumulators updated by the Adagrad optimization algorithm.Parameter gradient_accumulators updated by the Adagrad optimization algorithm.
func RetrieveTPUEmbeddingAdagradParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingAdagradParametersGradAccumDebugAttr) (parameters tf.Output, accumulators tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingAdagradParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Connects N inputs to an N-way replicated TPU computation.
func TPUReplicatedInput(scope *Scope, inputs []tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TPUReplicatedInput",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Initializes the multi device iterator with the given dataset.
//
// Arguments:
//	dataset: Dataset to be iterated upon.
//	multi_device_iterator: A MultiDeviceIteratorResource.
//	max_buffer_size: The maximum size of the host side per device buffer to keep.
//
// Returns An int64 indicating which incarnation of the MultiDeviceIterator
// is running.
func MultiDeviceIteratorInit(scope *Scope, dataset tf.Output, multi_device_iterator tf.Output, max_buffer_size tf.Output) (incarnation_id tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MultiDeviceIteratorInit",
		Input: []tf.Input{
			dataset, multi_device_iterator, max_buffer_size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradWithArgmaxAttr is an optional argument to MaxPoolGradWithArgmax.
type MaxPoolGradWithArgmaxAttr func(optionalAttr)

// MaxPoolGradWithArgmaxIncludeBatchInIndex sets the optional include_batch_in_index attribute to value.
//
// value: Whether to include batch dimension in flattened index of `argmax`.
// If not specified, defaults to false
func MaxPoolGradWithArgmaxIncludeBatchInIndex(value bool) MaxPoolGradWithArgmaxAttr {
	return func(m optionalAttr) {
		m["include_batch_in_index"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	input: The original input.
//	grad: 4-D with shape `[batch, height, width, channels]`.  Gradients w.r.t. the
// output of `max_pool`.
//	argmax: The indices of the maximum values chosen for each output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input of `max_pool`.
func MaxPoolGradWithArgmax(scope *Scope, input tf.Output, grad tf.Output, argmax tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradWithArgmaxAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradWithArgmax",
		Input: []tf.Input{
			input, grad, argmax,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic cosine of x element-wise.
func Cosh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Cosh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyMomentumAttr is an optional argument to ResourceApplyMomentum.
type ResourceApplyMomentumAttr func(optionalAttr)

// ResourceApplyMomentumUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyMomentumUseLocking(value bool) ResourceApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyMomentumUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, the tensor passed to compute grad will be
// var - lr * momentum * accum, so in the end, the var you get is actually
// var - lr * momentum * accum.
// If not specified, defaults to false
func ResourceApplyMomentumUseNesterov(value bool) ResourceApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the momentum scheme. Set use_nesterov = True if you
//
// want to use Nesterov momentum.
//
// accum = accum * momentum + grad
// var -= lr * accum
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	grad: The gradient.
//	momentum: Momentum. Must be a scalar.
//
// Returns the created operation.
func ResourceApplyMomentum(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, momentum tf.Output, optional ...ResourceApplyMomentumAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyMomentum",
		Input: []tf.Input{
			var_, accum, lr, grad, momentum,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyAdamAttr is an optional argument to ResourceApplyAdam.
type ResourceApplyAdamAttr func(optionalAttr)

// ResourceApplyAdamUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdamUseLocking(value bool) ResourceApplyAdamAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyAdamUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, uses the nesterov update.
// If not specified, defaults to false
func ResourceApplyAdamUseNesterov(value bool) ResourceApplyAdamAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update '*var' according to the Adam algorithm.
//
// $$lr_t := \text{learning\_rate} * \sqrt{1 - beta_2^t} / (1 - beta_1^t)$$
// $$m_t := beta_1 * m_{t-1} + (1 - beta_1) * g$$
// $$v_t := beta_2 * v_{t-1} + (1 - beta_2) * g * g$$
// $$variable := variable - lr_t * m_t / (\sqrt{v_t} + \epsilon)$$
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	beta2_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdam(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, beta1_power tf.Output, beta2_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdamAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdam",
		Input: []tf.Input{
			var_, m, v, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// FusedBatchNormGradV2Attr is an optional argument to FusedBatchNormGradV2.
type FusedBatchNormGradV2Attr func(optionalAttr)

// FusedBatchNormGradV2Epsilon sets the optional epsilon attribute to value.
//
// value: A small float number added to the variance of x.
// If not specified, defaults to 0.0001
func FusedBatchNormGradV2Epsilon(value float32) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["epsilon"] = value
	}
}

// FusedBatchNormGradV2DataFormat sets the optional data_format attribute to value.
//
// value: The data format for y_backprop, x, x_backprop.
// Either "NHWC" (default) or "NCHW".
// If not specified, defaults to "NHWC"
func FusedBatchNormGradV2DataFormat(value string) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// FusedBatchNormGradV2IsTraining sets the optional is_training attribute to value.
//
// value: A bool value to indicate the operation is for training (default)
// or inference.
// If not specified, defaults to true
func FusedBatchNormGradV2IsTraining(value bool) FusedBatchNormGradV2Attr {
	return func(m optionalAttr) {
		m["is_training"] = value
	}
}

// Gradient for batch normalization.
//
// Note that the size of 4D Tensors are defined by either "NHWC" or "NCHW".
// The size of 1D Tensors matches the dimension C of the 4D Tensors.
//
// Arguments:
//	y_backprop: A 4D Tensor for the gradient with respect to y.
//	x: A 4D Tensor for input data.
//	scale: A 1D Tensor for scaling factor, to scale the normalized x.
//	reserve_space_1: When is_training is True, a 1D Tensor for the computed batch
// mean to be reused in gradient computation. When is_training is
// False, a 1D Tensor for the population mean to be reused in both
// 1st and 2nd order gradient computation.
//	reserve_space_2: When is_training is True, a 1D Tensor for the computed batch
// variance (inverted variance in the cuDNN case) to be reused in
// gradient computation. When is_training is False, a 1D Tensor
// for the population variance to be reused in both 1st and 2nd
// order gradient computation.
//
// Returns A 4D Tensor for the gradient with respect to x.A 1D Tensor for the gradient with respect to scale.A 1D Tensor for the gradient with respect to offset.Unused placeholder to match the mean input in FusedBatchNorm.Unused placeholder to match the variance input
// in FusedBatchNorm.
func FusedBatchNormGradV2(scope *Scope, y_backprop tf.Output, x tf.Output, scale tf.Output, reserve_space_1 tf.Output, reserve_space_2 tf.Output, optional ...FusedBatchNormGradV2Attr) (x_backprop tf.Output, scale_backprop tf.Output, offset_backprop tf.Output, reserve_space_3 tf.Output, reserve_space_4 tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedBatchNormGradV2",
		Input: []tf.Input{
			y_backprop, x, scale, reserve_space_1, reserve_space_2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3), op.Output(4)
}

// MinAttr is an optional argument to Min.
type MinAttr func(optionalAttr)

// MinKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func MinKeepDims(value bool) MinAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the minimum of elements across dimensions of a tensor.
//
// Reduces `input` along the dimensions given in `axis`. Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `axis`. If `keep_dims` is true, the reduced dimensions are
// retained with length 1.
//
// Arguments:
//	input: The tensor to reduce.
//	axis: The dimensions to reduce. Must be in the range
// `[-rank(input), rank(input))`.
//
// Returns The reduced tensor.
func Min(scope *Scope, input tf.Output, axis tf.Output, optional ...MinAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Min",
		Input: []tf.Input{
			input, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebug.
type RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve proximal Adagrad embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the proximal Adagrad optimization algorithm.Parameter accumulators updated by the proximal Adagrad optimization algorithm.Parameter gradient_accumulators updated by the proximal Adagrad optimization algorithm.
func RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebugAttr) (parameters tf.Output, accumulators tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingProximalAdagradParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceApplyPowerSignAttr is an optional argument to ResourceApplyPowerSign.
type ResourceApplyPowerSignAttr func(optionalAttr)

// ResourceApplyPowerSignUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and m tensors is
// protected by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyPowerSignUseLocking(value bool) ResourceApplyPowerSignAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the AddSign update.
//
// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
// update <- exp(logbase * sign_decay * sign(g) * sign(m_t)) * g
// variable <- variable - lr_t * update
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	logbase: Must be a scalar.
//	sign_decay: Must be a scalar.
//	beta: Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyPowerSign(scope *Scope, var_ tf.Output, m tf.Output, lr tf.Output, logbase tf.Output, sign_decay tf.Output, beta tf.Output, grad tf.Output, optional ...ResourceApplyPowerSignAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyPowerSign",
		Input: []tf.Input{
			var_, m, lr, logbase, sign_decay, beta, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Constructs a tensor by tiling a given tensor.
//
// This operation creates a new tensor by replicating `input` `multiples` times.
// The output tensor's i'th dimension has `input.dims(i) * multiples[i]` elements,
// and the values of `input` are replicated `multiples[i]` times along the 'i'th
// dimension. For example, tiling `[a b c d]` by `[2]` produces
// `[a b c d a b c d]`.
//
// Arguments:
//	input: 1-D or higher.
//	multiples: 1-D. Length must be the same as the number of dimensions in `input`
func Tile(scope *Scope, input tf.Output, multiples tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Tile",
		Input: []tf.Input{
			input, multiples,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UnicodeTranscodeAttr is an optional argument to UnicodeTranscode.
type UnicodeTranscodeAttr func(optionalAttr)

// UnicodeTranscodeErrors sets the optional errors attribute to value.
//
// value: Error handling policy when there is invalid formatting found in the input.
// The value of 'strict' will cause the operation to produce a InvalidArgument
// error on any invalid input formatting. A value of 'replace' (the default) will
// cause the operation to replace any invalid formatting in the input with the
// `replacement_char` codepoint. A value of 'ignore' will cause the operation to
// skip any invalid formatting in the input and produce no corresponding output
// character.
// If not specified, defaults to "replace"
func UnicodeTranscodeErrors(value string) UnicodeTranscodeAttr {
	return func(m optionalAttr) {
		m["errors"] = value
	}
}

// UnicodeTranscodeReplacementChar sets the optional replacement_char attribute to value.
//
// value: The replacement character codepoint to be used in place of any invalid
// formatting in the input when `errors='replace'`. Any valid unicode codepoint may
// be used. The default value is the default unicode replacement character is
// 0xFFFD or U+65533.)
//
// Note that for UTF-8, passing a replacement character expressible in 1 byte, such
// as ' ', will preserve string alignment to the source since invalid bytes will be
// replaced with a 1-byte replacement. For UTF-16-BE and UTF-16-LE, any 1 or 2 byte
// replacement character will preserve byte alignment to the source.
// If not specified, defaults to 65533
func UnicodeTranscodeReplacementChar(value int64) UnicodeTranscodeAttr {
	return func(m optionalAttr) {
		m["replacement_char"] = value
	}
}

// UnicodeTranscodeReplaceControlCharacters sets the optional replace_control_characters attribute to value.
//
// value: Whether to replace the C0 control characters (00-1F) with the
// `replacement_char`. Default is false.
// If not specified, defaults to false
func UnicodeTranscodeReplaceControlCharacters(value bool) UnicodeTranscodeAttr {
	return func(m optionalAttr) {
		m["replace_control_characters"] = value
	}
}

// Transcode the input text from a source encoding to a destination encoding.
//
// The input is a string tensor of any shape. The output is a string tensor of
// the same shape containing the transcoded strings. Output strings are always
// valid unicode. If the input contains invalid encoding positions, the
// `errors` attribute sets the policy for how to deal with them. If the default
// error-handling policy is used, invalid formatting will be substituted in the
// output by the `replacement_char`. If the errors policy is to `ignore`, any
// invalid encoding positions in the input are skipped and not included in the
// output. If it set to `strict` then any invalid formatting will result in an
// InvalidArgument error.
//
// This operation can be used with `output_encoding = input_encoding` to enforce
// correct formatting for inputs even if they are already in the desired encoding.
//
// If the input is prefixed by a Byte Order Mark needed to determine encoding
// (e.g. if the encoding is UTF-16 and the BOM indicates big-endian), then that
// BOM will be consumed and not emitted into the output. If the input encoding
// is marked with an explicit endianness (e.g. UTF-16-BE), then the BOM is
// interpreted as a non-breaking-space and is preserved in the output (including
// always for UTF-8).
//
// The end result is that if the input is marked as an explicit endianness the
// transcoding is faithful to all codepoints in the source. If it is not marked
// with an explicit endianness, the BOM is not considered part of the string itself
// but as metadata, and so is not preserved in the output.
//
// Arguments:
//	input: The text to be processed. Can have any shape.
//	input_encoding: Text encoding of the input strings. This is any of the encodings supported
// by ICU ucnv algorithmic converters. Examples: `"UTF-16", "US ASCII", "UTF-8"`.
//	output_encoding: The unicode encoding to use in the output. Must be one of
// `"UTF-8", "UTF-16-BE", "UTF-32-BE"`. Multi-byte encodings will be big-endian.
//
// Returns A string tensor containing unicode text encoded using `output_encoding`.
func UnicodeTranscode(scope *Scope, input tf.Output, input_encoding string, output_encoding string, optional ...UnicodeTranscodeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_encoding": input_encoding, "output_encoding": output_encoding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnicodeTranscode",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceApplyAdamWithAmsgradAttr is an optional argument to ResourceApplyAdamWithAmsgrad.
type ResourceApplyAdamWithAmsgradAttr func(optionalAttr)

// ResourceApplyAdamWithAmsgradUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdamWithAmsgradUseLocking(value bool) ResourceApplyAdamWithAmsgradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the Adam algorithm.
//
// $$lr_t := \text{learning\_rate} * \sqrt{1 - beta_2^t} / (1 - beta_1^t)$$
// $$m_t := beta_1 * m_{t-1} + (1 - beta_1) * g$$
// $$v_t := beta_2 * v_{t-1} + (1 - beta_2) * g * g$$
// $$vhat_t := max{vhat_{t-1}, v_t}$$
// $$variable := variable - lr_t * m_t / (\sqrt{vhat_t} + \epsilon)$$
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	vhat: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	beta2_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdamWithAmsgrad(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, vhat tf.Output, beta1_power tf.Output, beta2_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdamWithAmsgradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdamWithAmsgrad",
		Input: []tf.Input{
			var_, m, v, vhat, beta1_power, beta2_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// QuantizedReluAttr is an optional argument to QuantizedRelu.
type QuantizedReluAttr func(optionalAttr)

// QuantizedReluOutType sets the optional out_type attribute to value.
// If not specified, defaults to DT_QUINT8
func QuantizedReluOutType(value tf.DataType) QuantizedReluAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// Computes Quantized Rectified Linear: `max(features, 0)`
//
// Arguments:
//
//	min_features: The float value that the lowest quantized value represents.
//	max_features: The float value that the highest quantized value represents.
//
// Returns Has the same output shape as "features".The float value that the lowest quantized value represents.The float value that the highest quantized value represents.
func QuantizedRelu(scope *Scope, features tf.Output, min_features tf.Output, max_features tf.Output, optional ...QuantizedReluAttr) (activations tf.Output, min_activations tf.Output, max_activations tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedRelu",
		Input: []tf.Input{
			features, min_features, max_features,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceApplyAdagradAttr is an optional argument to ResourceApplyAdagrad.
type ResourceApplyAdagradAttr func(optionalAttr)

// ResourceApplyAdagradUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdagradUseLocking(value bool) ResourceApplyAdagradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceApplyAdagradUpdateSlots sets the optional update_slots attribute to value.
// If not specified, defaults to true
func ResourceApplyAdagradUpdateSlots(value bool) ResourceApplyAdagradAttr {
	return func(m optionalAttr) {
		m["update_slots"] = value
	}
}

// Update '*var' according to the adagrad scheme.
//
// accum += grad * grad
// var -= lr * grad * (1 / sqrt(accum))
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Scaling factor. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdagrad(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, optional ...ResourceApplyAdagradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdagrad",
		Input: []tf.Input{
			var_, accum, lr, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// ResizeAreaAttr is an optional argument to ResizeArea.
type ResizeAreaAttr func(optionalAttr)

// ResizeAreaAlignCorners sets the optional align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func ResizeAreaAlignCorners(value bool) ResizeAreaAttr {
	return func(m optionalAttr) {
		m["align_corners"] = value
	}
}

// Resize `images` to `size` using area interpolation.
//
// Input images can be of different types but output images are always float.
//
// The range of pixel values for the output image might be slightly different
// from the range for the input image because of limited numerical precision.
// To guarantee an output range, for example `[0.0, 1.0]`, apply
// `tf.clip_by_value` to the output.
//
// Each output pixel is computed by first transforming the pixel's footprint into
// the input tensor and then averaging the pixels that intersect the footprint. An
// input pixel's contribution to the average is weighted by the fraction of its
// area that intersects the footprint.  This is the same as OpenCV's INTER_AREA.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, channels]`.
//	size: = A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//
// Returns 4-D with shape
// `[batch, new_height, new_width, channels]`.
func ResizeArea(scope *Scope, images tf.Output, size tf.Output, optional ...ResizeAreaAttr) (resized_images tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResizeArea",
		Input: []tf.Input{
			images, size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 2D fast Fourier transform.
//
// Computes the inverse 2-dimensional discrete Fourier transform over the
// inner-most 2 dimensions of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 2
//   dimensions of `input` are replaced with their inverse 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifft2
// @end_compatibility
func IFFT2D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT2D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset with a range of values. Corresponds to python's xrange.
//
// Arguments:
//	start: corresponds to start in python's xrange().
//	stop: corresponds to stop in python's xrange().
//	step: corresponds to step in python's xrange().
//
//
func RangeDataset(scope *Scope, start tf.Output, stop tf.Output, step tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "RangeDataset",
		Input: []tf.Input{
			start, stop, step,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMatMulWithBiasAndReluAttr is an optional argument to QuantizedMatMulWithBiasAndRelu.
type QuantizedMatMulWithBiasAndReluAttr func(optionalAttr)

// QuantizedMatMulWithBiasAndReluToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMatMulWithBiasAndReluToutput(value tf.DataType) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// QuantizedMatMulWithBiasAndReluTransposeA sets the optional transpose_a attribute to value.
//
// value: If true, `a` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluTransposeA(value bool) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["transpose_a"] = value
	}
}

// QuantizedMatMulWithBiasAndReluTransposeB sets the optional transpose_b attribute to value.
//
// value: If true, `b` is transposed before multiplication.
// If not specified, defaults to false
func QuantizedMatMulWithBiasAndReluTransposeB(value bool) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["transpose_b"] = value
	}
}

// QuantizedMatMulWithBiasAndReluInputQuantMode sets the optional input_quant_mode attribute to value.
//
// value: Input data quantization mode. Either MIN_FIRST(default) or SCALED.
// If not specified, defaults to "MIN_FIRST"
func QuantizedMatMulWithBiasAndReluInputQuantMode(value string) QuantizedMatMulWithBiasAndReluAttr {
	return func(m optionalAttr) {
		m["input_quant_mode"] = value
	}
}

// Perform a quantized matrix multiplication of  `a` by the matrix `b` with bias
// add and relu fusion.
//
// The inputs must be two-dimensional matrices and 1D bias vector. And the inner
// dimension of `a` (after being transposed if `transpose_a` is non-zero) must
// match the outer dimension of `b` (after being transposed if `transposed_b` is
// non-zero). Then do broadcast add operation with bias values on the matrix
// mulplication result. The bias size must match inner dimension of `b`. Then do
// relu activation to get non-negative result.
//
// Arguments:
//	a: A matrix to be multiplied. Must be a two-dimensional tensor of type `quint8`.
//	b: A matrix to be multiplied and must be a two-dimensional tensor of type `qint8`.
//	bias: A 1D bias tensor with size matching with inner dimension of `b` (after being
// transposed if `transposed_b` is non-zero).
//	min_a: The float value that the lowest quantized `a` value represents.
//	max_a: The float value that the highest quantized `a` value represents.
//	min_b: The float value that the lowest quantized `b` value represents.
//	max_b: The float value that the highest quantized `b` value represents.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
func QuantizedMatMulWithBiasAndRelu(scope *Scope, a tf.Output, b tf.Output, bias tf.Output, min_a tf.Output, max_a tf.Output, min_b tf.Output, max_b tf.Output, optional ...QuantizedMatMulWithBiasAndReluAttr) (out tf.Output, min_out tf.Output, max_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMatMulWithBiasAndRelu",
		Input: []tf.Input{
			a, b, bias, min_a, max_a, min_b, max_b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceSparseApplyAdagradAttr is an optional argument to ResourceSparseApplyAdagrad.
type ResourceSparseApplyAdagradAttr func(optionalAttr)

// ResourceSparseApplyAdagradUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyAdagradUseLocking(value bool) ResourceSparseApplyAdagradAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceSparseApplyAdagradUpdateSlots sets the optional update_slots attribute to value.
// If not specified, defaults to true
func ResourceSparseApplyAdagradUpdateSlots(value bool) ResourceSparseApplyAdagradAttr {
	return func(m optionalAttr) {
		m["update_slots"] = value
	}
}

// Update relevant entries in '*var' and '*accum' according to the adagrad scheme.
//
// That is for rows we have grad for, we update var and accum as follows:
// accum += grad * grad
// var -= lr * grad * (1 / sqrt(accum))
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//
// Returns the created operation.
func ResourceSparseApplyAdagrad(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, indices tf.Output, optional ...ResourceSparseApplyAdagradAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyAdagrad",
		Input: []tf.Input{
			var_, accum, lr, grad, indices,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Writes contents to the file at input filename. Creates file and recursively
//
// creates directory if not existing.
//
// Arguments:
//	filename: scalar. The name of the file to which we write the contents.
//	contents: scalar. The content to be written to the output file.
//
// Returns the created operation.
func WriteFile(scope *Scope, filename tf.Output, contents tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "WriteFile",
		Input: []tf.Input{
			filename, contents,
		},
	}
	return scope.AddOperation(opspec)
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr is an optional argument to RetrieveTPUEmbeddingStochasticGradientDescentParameters.
type RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingStochasticGradientDescentParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingStochasticGradientDescentParametersTableId(value int64) RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingStochasticGradientDescentParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingStochasticGradientDescentParametersTableName(value string) RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve SGD embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the stochastic gradient descent optimization algorithm.
func RetrieveTPUEmbeddingStochasticGradientDescentParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingStochasticGradientDescentParametersAttr) (parameters tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingStochasticGradientDescentParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Gets the next output from the given iterator .
func IteratorGetNext(scope *Scope, iterator tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (components []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "IteratorGetNext",
		Input: []tf.Input{
			iterator,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if components, idx, err = makeOutputList(op, idx, "components"); err != nil {
		scope.UpdateErr("IteratorGetNext", err)
		return
	}
	return components
}

// MaxPoolGradAttr is an optional argument to MaxPoolGrad.
type MaxPoolGradAttr func(optionalAttr)

// MaxPoolGradDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradDataFormat(value string) MaxPoolGradAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGrad(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize []int64, strides []int64, padding string, optional ...MaxPoolGradAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"ksize": ksize, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGrad",
		Input: []tf.Input{
			orig_input, orig_output, grad,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AddManySparseToTensorsMapAttr is an optional argument to AddManySparseToTensorsMap.
type AddManySparseToTensorsMapAttr func(optionalAttr)

// AddManySparseToTensorsMapContainer sets the optional container attribute to value.
//
// value: The container name for the `SparseTensorsMap` created by this op.
// If not specified, defaults to ""
func AddManySparseToTensorsMapContainer(value string) AddManySparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// AddManySparseToTensorsMapSharedName sets the optional shared_name attribute to value.
//
// value: The shared name for the `SparseTensorsMap` created by this op.
// If blank, the new Operation's unique name is used.
// If not specified, defaults to ""
func AddManySparseToTensorsMapSharedName(value string) AddManySparseToTensorsMapAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Add an `N`-minibatch `SparseTensor` to a `SparseTensorsMap`, return `N` handles.
//
// A `SparseTensor` of rank `R` is represented by three tensors: `sparse_indices`,
// `sparse_values`, and `sparse_shape`, where
//
// ```sparse_indices.shape[1] == sparse_shape.shape[0] == R```
//
// An `N`-minibatch of `SparseTensor` objects is represented as a `SparseTensor`
// having a first `sparse_indices` column taking values between `[0, N)`, where
// the minibatch size `N == sparse_shape[0]`.
//
// The input `SparseTensor` must have rank `R` greater than 1, and the first
// dimension is treated as the minibatch dimension.  Elements of the `SparseTensor`
// must be sorted in increasing order of this first dimension.  The stored
// `SparseTensor` objects pointed to by each row of the output `sparse_handles`
// will have rank `R-1`.
//
// The `SparseTensor` values can then be read out as part of a minibatch by passing
// the given keys as vector elements to `TakeManySparseFromTensorsMap`.  To ensure
// the correct `SparseTensorsMap` is accessed, ensure that the same
// `container` and `shared_name` are passed to that Op.  If no `shared_name`
// is provided here, instead use the *name* of the Operation created by calling
// `AddManySparseToTensorsMap` as the `shared_name` passed to
// `TakeManySparseFromTensorsMap`.  Ensure the Operations are colocated.
//
// Arguments:
//	sparse_indices: 2-D.  The `indices` of the minibatch `SparseTensor`.
// `sparse_indices[:, 0]` must be ordered values in `[0, N)`.
//	sparse_values: 1-D.  The `values` of the minibatch `SparseTensor`.
//	sparse_shape: 1-D.  The `shape` of the minibatch `SparseTensor`.
// The minibatch size `N == sparse_shape[0]`.
//
// Returns 1-D.  The handles of the `SparseTensor` now stored in the
// `SparseTensorsMap`.  Shape: `[N]`.
func AddManySparseToTensorsMap(scope *Scope, sparse_indices tf.Output, sparse_values tf.Output, sparse_shape tf.Output, optional ...AddManySparseToTensorsMapAttr) (sparse_handles tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AddManySparseToTensorsMap",
		Input: []tf.Input{
			sparse_indices, sparse_values, sparse_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DecodeCompressedAttr is an optional argument to DecodeCompressed.
type DecodeCompressedAttr func(optionalAttr)

// DecodeCompressedCompressionType sets the optional compression_type attribute to value.
//
// value: A scalar containing either (i) the empty string (no
// compression), (ii) "ZLIB", or (iii) "GZIP".
// If not specified, defaults to ""
func DecodeCompressedCompressionType(value string) DecodeCompressedAttr {
	return func(m optionalAttr) {
		m["compression_type"] = value
	}
}

// Decompress strings.
//
// This op decompresses each element of the `bytes` input `Tensor`, which
// is assumed to be compressed using the given `compression_type`.
//
// The `output` is a string `Tensor` of the same shape as `bytes`,
// each element containing the decompressed data from the corresponding
// element in `bytes`.
//
// Arguments:
//	bytes: A Tensor of string which is compressed.
//
// Returns A Tensor with the same shape as input `bytes`, uncompressed
// from bytes.
func DecodeCompressed(scope *Scope, bytes tf.Output, optional ...DecodeCompressedAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DecodeCompressed",
		Input: []tf.Input{
			bytes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingMomentumParametersGradAccumDebug.
type RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve Momentum embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the Momentum optimization algorithm.Parameter momenta updated by the Momentum optimization algorithm.Parameter gradient_accumulators updated by the Momentum optimization algorithm.
func RetrieveTPUEmbeddingMomentumParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingMomentumParametersGradAccumDebugAttr) (parameters tf.Output, momenta tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingMomentumParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// GatherV2Attr is an optional argument to GatherV2.
type GatherV2Attr func(optionalAttr)

// GatherV2BatchDims sets the optional batch_dims attribute to value.
// If not specified, defaults to 0
func GatherV2BatchDims(value int64) GatherV2Attr {
	return func(m optionalAttr) {
		m["batch_dims"] = value
	}
}

// Gather slices from `params` axis `axis` according to `indices`.
//
// `indices` must be an integer tensor of any dimension (usually 0-D or 1-D).
// Produces an output tensor with shape `params.shape[:axis] + indices.shape +
// params.shape[axis + 1:]` where:
//
// ```python
//     # Scalar indices (output is rank(params) - 1).
//     output[a_0, ..., a_n, b_0, ..., b_n] =
//       params[a_0, ..., a_n, indices, b_0, ..., b_n]
//
//     # Vector indices (output is rank(params)).
//     output[a_0, ..., a_n, i, b_0, ..., b_n] =
//       params[a_0, ..., a_n, indices[i], b_0, ..., b_n]
//
//     # Higher rank indices (output is rank(params) + rank(indices) - 1).
//     output[a_0, ..., a_n, i, ..., j, b_0, ... b_n] =
//       params[a_0, ..., a_n, indices[i, ..., j], b_0, ..., b_n]
// ```
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/Gather.png" alt>
// </div>
//
// Note that on CPU, if an out of bound index is found, an error is returned.
// On GPU, if an out of bound index is found, a 0 is stored in the
// corresponding output value.
//
// See also `tf.batch_gather` and `tf.gather_nd`.
//
// Arguments:
//	params: The tensor from which to gather values. Must be at least rank
// `axis + 1`.
//	indices: Index tensor. Must be in range `[0, params.shape[axis])`.
//	axis: The axis in `params` to gather `indices` from. Defaults to the first
// dimension. Supports negative indexes.
//
// Returns Values from `params` gathered from indices given by `indices`, with
// shape `params.shape[:axis] + indices.shape + params.shape[axis + 1:]`.
func GatherV2(scope *Scope, params tf.Output, indices tf.Output, axis tf.Output, optional ...GatherV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "GatherV2",
		Input: []tf.Input{
			params, indices, axis,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Convert JSON-encoded Example records to binary protocol buffer strings.
//
// This op translates a tensor containing Example records, encoded using
// the [standard JSON
// mapping](https://developers.google.com/protocol-buffers/docs/proto3#json),
// into a tensor containing the same records encoded as binary protocol
// buffers. The resulting tensor can then be fed to any of the other
// Example-parsing ops.
//
// Arguments:
//	json_examples: Each string is a JSON object serialized according to the JSON
// mapping of the Example proto.
//
// Returns Each string is a binary Example protocol buffer corresponding
// to the respective element of `json_examples`.
func DecodeJSONExample(scope *Scope, json_examples tf.Output) (binary_examples tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeJSONExample",
		Input: []tf.Input{
			json_examples,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 2D real-valued fast Fourier transform.
//
// Computes the inverse 2-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most 2 dimensions of `input`.
//
// The inner-most 2 dimensions of `input` are assumed to be the result of `RFFT2D`:
// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
// from the size of the inner-most 2 dimensions of `input`. If the FFT length used
// to compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along each axis `IRFFT2D` is computed on, if `fft_length` (or
// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A complex64 tensor.
//	fft_length: An int32 tensor of shape [2]. The FFT length for each dimension.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most 2
//   dimensions of `input` are replaced with the `fft_length` samples of their
//   inverse 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.irfft2
// @end_compatibility
func IRFFT2D(scope *Scope, input tf.Output, fft_length tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IRFFT2D",
		Input: []tf.Input{
			input, fft_length,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceSparseApplyAdagradDAAttr is an optional argument to ResourceSparseApplyAdagradDA.
type ResourceSparseApplyAdagradDAAttr func(optionalAttr)

// ResourceSparseApplyAdagradDAUseLocking sets the optional use_locking attribute to value.
//
// value: If True, updating of the var and accum tensors will be protected by
// a lock; otherwise the behavior is undefined, but may exhibit less contention.
// If not specified, defaults to false
func ResourceSparseApplyAdagradDAUseLocking(value bool) ResourceSparseApplyAdagradDAAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update entries in '*var' and '*accum' according to the proximal adagrad scheme.
//
// Arguments:
//	var_: Should be from a Variable().
//	gradient_accumulator: Should be from a Variable().
//	gradient_squared_accumulator: Should be from a Variable().
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	lr: Learning rate. Must be a scalar.
//	l1: L1 regularization. Must be a scalar.
//	l2: L2 regularization. Must be a scalar.
//	global_step: Training step number. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyAdagradDA(scope *Scope, var_ tf.Output, gradient_accumulator tf.Output, gradient_squared_accumulator tf.Output, grad tf.Output, indices tf.Output, lr tf.Output, l1 tf.Output, l2 tf.Output, global_step tf.Output, optional ...ResourceSparseApplyAdagradDAAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyAdagradDA",
		Input: []tf.Input{
			var_, gradient_accumulator, gradient_squared_accumulator, grad, indices, lr, l1, l2, global_step,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Greedily selects a subset of bounding boxes in descending order of score,
//
// pruning away boxes that have high overlaps
// with previously selected boxes.  Bounding boxes with score less than
// `score_threshold` are removed. N-by-n overlap values are supplied as square matrix,
// which allows for defining a custom overlap criterium (eg. intersection over union,
// intersection over area, etc.).
//
// The output of this operation is a set of integers indexing into the input
// collection of bounding boxes representing the selected boxes.  The bounding
// box coordinates corresponding to the selected indices can then be obtained
// using the `tf.gather operation`.  For example:
//
//   selected_indices = tf.image.non_max_suppression_with_overlaps(
//       overlaps, scores, max_output_size, overlap_threshold, score_threshold)
//   selected_boxes = tf.gather(boxes, selected_indices)
//
// Arguments:
//	overlaps: A 2-D float tensor of shape `[num_boxes, num_boxes]` representing
// the n-by-n box overlap values.
//	scores: A 1-D float tensor of shape `[num_boxes]` representing a single
// score corresponding to each box (each row of boxes).
//	max_output_size: A scalar integer tensor representing the maximum number of
// boxes to be selected by non max suppression.
//	overlap_threshold: A 0-D float tensor representing the threshold for deciding whether
// boxes overlap too.
//	score_threshold: A 0-D float tensor representing the threshold for deciding when to remove
// boxes based on score.
//
// Returns A 1-D integer tensor of shape `[M]` representing the selected
// indices from the boxes tensor, where `M <= max_output_size`.
func NonMaxSuppressionWithOverlaps(scope *Scope, overlaps tf.Output, scores tf.Output, max_output_size tf.Output, overlap_threshold tf.Output, score_threshold tf.Output) (selected_indices tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NonMaxSuppressionWithOverlaps",
		Input: []tf.Input{
			overlaps, scores, max_output_size, overlap_threshold, score_threshold,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingRMSPropParametersGradAccumDebug.
type RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve RMSProp embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the RMSProp optimization algorithm.Parameter ms updated by the RMSProp optimization algorithm.Parameter mom updated by the RMSProp optimization algorithm.Parameter gradient_accumulators updated by the RMSProp optimization algorithm.
func RetrieveTPUEmbeddingRMSPropParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingRMSPropParametersGradAccumDebugAttr) (parameters tf.Output, ms tf.Output, mom tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingRMSPropParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// RetrieveTPUEmbeddingMDLAdagradLightParametersAttr is an optional argument to RetrieveTPUEmbeddingMDLAdagradLightParameters.
type RetrieveTPUEmbeddingMDLAdagradLightParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingMDLAdagradLightParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingMDLAdagradLightParametersTableId(value int64) RetrieveTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingMDLAdagradLightParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingMDLAdagradLightParametersTableName(value string) RetrieveTPUEmbeddingMDLAdagradLightParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve MDL Adagrad Light embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the MDL Adagrad Light optimization algorithm.Parameter accumulators updated by the MDL Adagrad Light optimization algorithm.Parameter weights updated by the MDL Adagrad Light optimization algorithm.Parameter benefits updated by the MDL Adagrad Light optimization algorithm.
func RetrieveTPUEmbeddingMDLAdagradLightParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingMDLAdagradLightParametersAttr) (parameters tf.Output, accumulators tf.Output, weights tf.Output, benefits tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingMDLAdagradLightParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Returns x + y element-wise.
//
// *NOTE*: `Add` supports broadcasting. `AddN` does not. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func AddV2(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AddV2",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// A container for an iterator resource.
//
// Returns A handle to the iterator that can be passed to a "MakeIterator" or
// "IteratorGetNext" op. In contrast to Iterator, AnonymousIterator prevents
// resource sharing by name, and does not keep a reference to the resource
// container.
func AnonymousIterator(scope *Scope, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "AnonymousIterator",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the tanh of `x` wrt its input.
//
// Specifically, `grad = dy * (1 - y*y)`, where `y = tanh(x)`, and `dy`
// is the corresponding input gradient.
func TanhGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TanhGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// LoadTPUEmbeddingAdadeltaParametersGradAccumDebugAttr is an optional argument to LoadTPUEmbeddingAdadeltaParametersGradAccumDebug.
type LoadTPUEmbeddingAdadeltaParametersGradAccumDebugAttr func(optionalAttr)

// LoadTPUEmbeddingAdadeltaParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func LoadTPUEmbeddingAdadeltaParametersGradAccumDebugTableId(value int64) LoadTPUEmbeddingAdadeltaParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// LoadTPUEmbeddingAdadeltaParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func LoadTPUEmbeddingAdadeltaParametersGradAccumDebugTableName(value string) LoadTPUEmbeddingAdadeltaParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Load Adadelta parameters with debug support.
//
// An op that loads optimization parameters into HBM for embedding. Must be
// preceded by a ConfigureTPUEmbeddingHost op that sets up the correct
// embedding table configuration. For example, this op is used to install
// parameters that are loaded from a checkpoint before a training loop is
// executed.
//
// Arguments:
//	parameters: Value of parameters used in the Adadelta optimization algorithm.
//	accumulators: Value of accumulators used in the Adadelta optimization algorithm.
//	updates: Value of updates used in the Adadelta optimization algorithm.
//	gradient_accumulators: Value of gradient_accumulators used in the Adadelta optimization algorithm.
//
//
//
// Returns the created operation.
func LoadTPUEmbeddingAdadeltaParametersGradAccumDebug(scope *Scope, parameters tf.Output, accumulators tf.Output, updates tf.Output, gradient_accumulators tf.Output, num_shards int64, shard_id int64, optional ...LoadTPUEmbeddingAdadeltaParametersGradAccumDebugAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LoadTPUEmbeddingAdadeltaParametersGradAccumDebug",
		Input: []tf.Input{
			parameters, accumulators, updates, gradient_accumulators,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// SparseTensorDenseMatMulAttr is an optional argument to SparseTensorDenseMatMul.
type SparseTensorDenseMatMulAttr func(optionalAttr)

// SparseTensorDenseMatMulAdjointA sets the optional adjoint_a attribute to value.
//
// value: Use the adjoint of A in the matrix multiply.  If A is complex, this
// is transpose(conj(A)).  Otherwise it's transpose(A).
// If not specified, defaults to false
func SparseTensorDenseMatMulAdjointA(value bool) SparseTensorDenseMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_a"] = value
	}
}

// SparseTensorDenseMatMulAdjointB sets the optional adjoint_b attribute to value.
//
// value: Use the adjoint of B in the matrix multiply.  If B is complex, this
// is transpose(conj(B)).  Otherwise it's transpose(B).
// If not specified, defaults to false
func SparseTensorDenseMatMulAdjointB(value bool) SparseTensorDenseMatMulAttr {
	return func(m optionalAttr) {
		m["adjoint_b"] = value
	}
}

// Multiply SparseTensor (of rank 2) "A" by dense matrix "B".
//
// No validity checking is performed on the indices of A.  However, the following
// input format is recommended for optimal behavior:
//
// if adjoint_a == false:
//   A should be sorted in lexicographically increasing order.  Use SparseReorder
//   if you're not sure.
// if adjoint_a == true:
//   A should be sorted in order of increasing dimension 1 (i.e., "column major"
//   order instead of "row major" order).
//
// Arguments:
//	a_indices: 2-D.  The `indices` of the `SparseTensor`, size `[nnz, 2]` Matrix.
//	a_values: 1-D.  The `values` of the `SparseTensor`, size `[nnz]` Vector.
//	a_shape: 1-D.  The `shape` of the `SparseTensor`, size `[2]` Vector.
//	b: 2-D.  A dense Matrix.
func SparseTensorDenseMatMul(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b tf.Output, optional ...SparseTensorDenseMatMulAttr) (product tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseTensorDenseMatMul",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Return a slice from 'input'.
//
// The output tensor is a tensor with dimensions described by 'size'
// whose values are extracted from 'input' starting at the offsets in
// 'begin'.
//
// *Requirements*:
//   0 <= begin[i] <= begin[i] + size[i] <= Di  for i in [0, n)
//
// Arguments:
//
//	begin: begin[i] specifies the offset into the 'i'th dimension of
// 'input' to slice from.
//	size: size[i] specifies the number of elements of the 'i'th dimension
// of 'input' to slice. If size[i] is -1, all remaining elements in dimension
// i are included in the slice (i.e. this is equivalent to setting
// size[i] = input.dim_size(i) - begin[i]).
func Slice(scope *Scope, input tf.Output, begin tf.Output, size tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Slice",
		Input: []tf.Input{
			input, begin, size,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts a `RaggedTensor` into a `SparseTensor` with the same values.
//
// input=ragged.from_nested_row_splits(rt_dense_values, rt_nested_splits)
// output=SparseTensor(indices=sparse_indices, values=sparse_values,
//                     dense_shape=sparse_dense_shape)
//
// Arguments:
//	rt_nested_splits: The `row_splits` for the `RaggedTensor`.
//	rt_dense_values: The `flat_values` for the `RaggedTensor`.
//
// Returns The indices for the `SparseTensor`.The values of the `SparseTensor`.`sparse_dense_shape` is a tight bounding box of the input `RaggedTensor`.
func RaggedTensorToSparse(scope *Scope, rt_nested_splits []tf.Output, rt_dense_values tf.Output) (sparse_indices tf.Output, sparse_values tf.Output, sparse_dense_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RaggedTensorToSparse",
		Input: []tf.Input{
			tf.OutputList(rt_nested_splits), rt_dense_values,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// RetrieveTPUEmbeddingAdadeltaParametersAttr is an optional argument to RetrieveTPUEmbeddingAdadeltaParameters.
type RetrieveTPUEmbeddingAdadeltaParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingAdadeltaParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingAdadeltaParametersTableId(value int64) RetrieveTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingAdadeltaParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingAdadeltaParametersTableName(value string) RetrieveTPUEmbeddingAdadeltaParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve Adadelta embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the Adadelta optimization algorithm.Parameter accumulators updated by the Adadelta optimization algorithm.Parameter updates updated by the Adadelta optimization algorithm.
func RetrieveTPUEmbeddingAdadeltaParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingAdadeltaParametersAttr) (parameters tf.Output, accumulators tf.Output, updates tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingAdadeltaParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Computes acos of x element-wise.
func Acos(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Acos",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts the given variant tensor to an iterator and stores it in the given resource.
//
// Arguments:
//	resource_handle: A handle to an iterator resource.
//	serialized: A variant tensor storing the state of the iterator contained in the
// resource.
//
// Returns the created operation.
func DeserializeIterator(scope *Scope, resource_handle tf.Output, serialized tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DeserializeIterator",
		Input: []tf.Input{
			resource_handle, serialized,
		},
	}
	return scope.AddOperation(opspec)
}

// Creates a Dataset that returns pseudorandom numbers.
//
// Arguments:
//	seed: A scalar seed for the random number generator. If either seed or
// seed2 is set to be non-zero, the random number generator is seeded
// by the given seed.  Otherwise, a random seed is used.
//	seed2: A second scalar seed to avoid seed collision.
//
//
func ExperimentalRandomDataset(scope *Scope, seed tf.Output, seed2 tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalRandomDataset",
		Input: []tf.Input{
			seed, seed2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of x AND y element-wise.
//
// *NOTE*: `LogicalAnd` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func LogicalAnd(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalAnd",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchToSpace for N-D tensors of type T.
//
// This operation reshapes the "batch" dimension 0 into `M + 1` dimensions of shape
// `block_shape + [batch]`, interleaves these blocks back into the grid defined by
// the spatial dimensions `[1, ..., M]`, to obtain a result with the same rank as
// the input.  The spatial dimensions of this intermediate result are then
// optionally cropped according to `crops` to produce the output.  This is the
// reverse of SpaceToBatch.  See below for a precise description.
//
// Arguments:
//	input: N-D with shape `input_shape = [batch] + spatial_shape + remaining_shape`,
// where spatial_shape has M dimensions.
//	block_shape: 1-D with shape `[M]`, all values must be >= 1.
//	crops: 2-D with shape `[M, 2]`, all values must be >= 0.
//   `crops[i] = [crop_start, crop_end]` specifies the amount to crop from input
//   dimension `i + 1`, which corresponds to spatial dimension `i`.  It is
//   required that
//   `crop_start[i] + crop_end[i] <= block_shape[i] * input_shape[i + 1]`.
//
// This operation is equivalent to the following steps:
//
// 1. Reshape `input` to `reshaped` of shape:
//      [block_shape[0], ..., block_shape[M-1],
//       batch / prod(block_shape),
//       input_shape[1], ..., input_shape[N-1]]
//
// 2. Permute dimensions of `reshaped` to produce `permuted` of shape
//      [batch / prod(block_shape),
//
//       input_shape[1], block_shape[0],
//       ...,
//       input_shape[M], block_shape[M-1],
//
//       input_shape[M+1], ..., input_shape[N-1]]
//
// 3. Reshape `permuted` to produce `reshaped_permuted` of shape
//      [batch / prod(block_shape),
//
//       input_shape[1] * block_shape[0],
//       ...,
//       input_shape[M] * block_shape[M-1],
//
//       input_shape[M+1],
//       ...,
//       input_shape[N-1]]
//
// 4. Crop the start and end of dimensions `[1, ..., M]` of
//    `reshaped_permuted` according to `crops` to produce the output of shape:
//      [batch / prod(block_shape),
//
//       input_shape[1] * block_shape[0] - crops[0,0] - crops[0,1],
//       ...,
//       input_shape[M] * block_shape[M-1] - crops[M-1,0] - crops[M-1,1],
//
//       input_shape[M+1], ..., input_shape[N-1]]
//
// Some examples:
//
// (1) For the following input of shape `[4, 1, 1, 1]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [0, 0]]`:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// (2) For the following input of shape `[4, 1, 1, 3]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [0, 0]]`:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 3]` and value:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[4, 2, 2, 1]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [0, 0]]`:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// The output tensor has shape `[1, 4, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//      [[5],   [6],  [7],  [8]],
//      [[9],  [10], [11],  [12]],
//      [[13], [14], [15],  [16]]]]
// ```
//
// (4) For the following input of shape `[8, 1, 3, 1]`, `block_shape = [2, 2]`, and
//     `crops = [[0, 0], [2, 0]]`:
//
// ```
// x = [[[[0], [1], [3]]], [[[0], [9], [11]]],
//      [[[0], [2], [4]]], [[[0], [10], [12]]],
//      [[[0], [5], [7]]], [[[0], [13], [15]]],
//      [[[0], [6], [8]]], [[[0], [14], [16]]]]
// ```
//
// The output tensor has shape `[2, 2, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//       [[5],   [6],  [7],  [8]]],
//      [[[9],  [10], [11],  [12]],
//       [[13], [14], [15],  [16]]]]
// ```
func BatchToSpaceND(scope *Scope, input tf.Output, block_shape tf.Output, crops tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "BatchToSpaceND",
		Input: []tf.Input{
			input, block_shape, crops,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceSparseApplyMomentumAttr is an optional argument to ResourceSparseApplyMomentum.
type ResourceSparseApplyMomentumAttr func(optionalAttr)

// ResourceSparseApplyMomentumUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var and accum tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceSparseApplyMomentumUseLocking(value bool) ResourceSparseApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// ResourceSparseApplyMomentumUseNesterov sets the optional use_nesterov attribute to value.
//
// value: If `True`, the tensor passed to compute grad will be
// var - lr * momentum * accum, so in the end, the var you get is actually
// var - lr * momentum * accum.
// If not specified, defaults to false
func ResourceSparseApplyMomentumUseNesterov(value bool) ResourceSparseApplyMomentumAttr {
	return func(m optionalAttr) {
		m["use_nesterov"] = value
	}
}

// Update relevant entries in '*var' and '*accum' according to the momentum scheme.
//
// Set use_nesterov = True if you want to use Nesterov momentum.
//
// That is for rows we have grad for, we update var and accum as follows:
//
// accum = accum * momentum + grad
// var -= lr * accum
//
// Arguments:
//	var_: Should be from a Variable().
//	accum: Should be from a Variable().
//	lr: Learning rate. Must be a scalar.
//	grad: The gradient.
//	indices: A vector of indices into the first dimension of var and accum.
//	momentum: Momentum. Must be a scalar.
//
// Returns the created operation.
func ResourceSparseApplyMomentum(scope *Scope, var_ tf.Output, accum tf.Output, lr tf.Output, grad tf.Output, indices tf.Output, momentum tf.Output, optional ...ResourceSparseApplyMomentumAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceSparseApplyMomentum",
		Input: []tf.Input{
			var_, accum, lr, grad, indices, momentum,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// An op enabling differentiation of TPU Embeddings.
//
// This op simply returns its first input, which is assumed to have been sliced
// from the Tensors returned by TPUEmbeddingDequeueActivations. The presence of
// this op, and its first argument being a trainable Variable, enables automatic
// differentiation of graphs containing embeddings via the TPU Embedding Python
// libraries.
//
// Arguments:
//	embedding_variable: A trainable variable, enabling optimizers to find this op.
//	sliced_activations: The embedding activations Tensor to return.
//	table_id: The id of the table in the embedding layer configuration from which
// these activations were computed.
//	lookup_id: Identifier of the set of embedding indices which produced these
// activations.
func TPUEmbeddingActivations(scope *Scope, embedding_variable tf.Output, sliced_activations tf.Output, table_id int64, lookup_id int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"table_id": table_id, "lookup_id": lookup_id}
	opspec := tf.OpSpec{
		Type: "TPUEmbeddingActivations",
		Input: []tf.Input{
			embedding_variable, sliced_activations,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UnbatchGradAttr is an optional argument to UnbatchGrad.
type UnbatchGradAttr func(optionalAttr)

// UnbatchGradContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func UnbatchGradContainer(value string) UnbatchGradAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// UnbatchGradSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func UnbatchGradSharedName(value string) UnbatchGradAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Gradient of Unbatch.
//
// Acts like Batch but using the given batch_index index of batching things as they
// become available. This ensures that the gradients are propagated back in the
// same session which did the forward pass.
//
// original_input: The input to the Unbatch operation this is the gradient of.
// batch_index: The batch_index given to the Unbatch operation this is the gradient
// of.
// grad: The downstream gradient.
// id: The id scalar emitted by Batch.
// batched_grad: The return value, either an empty tensor or the batched gradient.
// container: Container to control resource sharing.
// shared_name: Instances of UnbatchGrad with the same container and shared_name
//  are assumed to possibly belong to the same batch. If left empty, the op name
//  will be used as the shared name.
func UnbatchGrad(scope *Scope, original_input tf.Output, batch_index tf.Output, grad tf.Output, id tf.Output, optional ...UnbatchGradAttr) (batched_grad tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "UnbatchGrad",
		Input: []tf.Input{
			original_input, batch_index, grad, id,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Conv2DAttr is an optional argument to Conv2D.
type Conv2DAttr func(optionalAttr)

// Conv2DUseCudnnOnGpu sets the optional use_cudnn_on_gpu attribute to value.
// If not specified, defaults to true
func Conv2DUseCudnnOnGpu(value bool) Conv2DAttr {
	return func(m optionalAttr) {
		m["use_cudnn_on_gpu"] = value
	}
}

// Conv2DExplicitPaddings sets the optional explicit_paddings attribute to value.
//
// value: If `padding` is `"EXPLICIT"`, the list of explicit padding amounts. For the ith
// dimension, the amount of padding inserted before and after the dimension is
// `explicit_paddings[2 * i]` and `explicit_paddings[2 * i + 1]`, respectively. If
// `padding` is not `"EXPLICIT"`, `explicit_paddings` must be empty.
// If not specified, defaults to <>
func Conv2DExplicitPaddings(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["explicit_paddings"] = value
	}
}

// Conv2DDataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, height, width, channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, channels, height, width].
// If not specified, defaults to "NHWC"
func Conv2DDataFormat(value string) Conv2DAttr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Conv2DDilations sets the optional dilations attribute to value.
//
// value: 1-D tensor of length 4.  The dilation factor for each dimension of
// `input`. If set to k > 1, there will be k-1 skipped cells between each
// filter element on that dimension. The dimension order is determined by the
// value of `data_format`, see above for details. Dilations in the batch and
// depth dimensions must be 1.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func Conv2DDilations(value []int64) Conv2DAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes a 2-D convolution given 4-D `input` and `filter` tensors.
//
// Given an input tensor of shape `[batch, in_height, in_width, in_channels]`
// and a filter / kernel tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`, this op
// performs the following:
//
// 1. Flattens the filter to a 2-D matrix with shape
//    `[filter_height * filter_width * in_channels, output_channels]`.
// 2. Extracts image patches from the input tensor to form a *virtual*
//    tensor of shape `[batch, out_height, out_width,
//    filter_height * filter_width * in_channels]`.
// 3. For each patch, right-multiplies the filter matrix and the image patch
//    vector.
//
// In detail, with the default NHWC format,
//
//     output[b, i, j, k] =
//         sum_{di, dj, q} input[b, strides[1] * i + di, strides[2] * j + dj, q] *
//                         filter[di, dj, q, k]
//
// Must have `strides[0] = strides[3] = 1`.  For the most common case of the same
// horizontal and vertices strides, `strides = [1, stride, stride, 1]`.
//
// Arguments:
//	input: A 4-D tensor. The dimension order is interpreted according to the value
// of `data_format`, see below for details.
//	filter: A 4-D tensor of shape
// `[filter_height, filter_width, in_channels, out_channels]`
//	strides: 1-D tensor of length 4.  The stride of the sliding window for each
// dimension of `input`. The dimension order is determined by the value of
// `data_format`, see below for details.
//	padding: The type of padding algorithm to use.
//
// Returns A 4-D tensor. The dimension order is determined by the value of
// `data_format`, see below for details.
func Conv2D(scope *Scope, input tf.Output, filter tf.Output, strides []int64, padding string, optional ...Conv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Conv2D",
		Input: []tf.Input{
			input, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ResourceScatterNdSubAttr is an optional argument to ResourceScatterNdSub.
type ResourceScatterNdSubAttr func(optionalAttr)

// ResourceScatterNdSubUseLocking sets the optional use_locking attribute to value.
//
// value: An optional bool. Defaults to True. If True, the assignment will
// be protected by a lock; otherwise the behavior is undefined,
// but may exhibit less contention.
// If not specified, defaults to true
func ResourceScatterNdSubUseLocking(value bool) ResourceScatterNdSubAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Applies sparse subtraction to individual values or slices in a Variable.
//
// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `ref`.
// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
// dimension of `ref`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// ```
// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]]
// ```
//
// For example, say we want to subtract 4 scattered elements from a rank-1 tensor
// with 8 elements. In Python, that subtraction would look like this:
//
// ```python
// ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8], use_resource=True)
// indices = tf.constant([[4], [3], [1], [7]])
// updates = tf.constant([9, 10, 11, 12])
// sub = tf.scatter_nd_sub(ref, indices, updates)
// with tf.Session() as sess:
//   print sess.run(sub)
// ```
//
// The resulting update to ref would look like this:
//
//     [1, -9, 3, -6, -4, 6, 7, -4]
//
// See `tf.scatter_nd` for more details about how to make updates to
// slices.
//
// Arguments:
//	ref: A resource handle. Must be from a VarHandleOp.
//	indices: A Tensor. Must be one of the following types: int32, int64.
// A tensor of indices into ref.
//	updates: A Tensor. Must have the same type as ref. A tensor of
// values to add to ref.
//
// Returns the created operation.
func ResourceScatterNdSub(scope *Scope, ref tf.Output, indices tf.Output, updates tf.Output, optional ...ResourceScatterNdSubAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterNdSub",
		Input: []tf.Input{
			ref, indices, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Assigns sparse updates to the variable referenced by `resource`.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = updates[...]
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = updates[i, ...]
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = updates[i, ..., j, ...]
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterUpdate(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterUpdate",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// InfeedEnqueuePrelinearizedBufferAttr is an optional argument to InfeedEnqueuePrelinearizedBuffer.
type InfeedEnqueuePrelinearizedBufferAttr func(optionalAttr)

// InfeedEnqueuePrelinearizedBufferDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op is running on a TPU device
// and = 0 when the Op is running on the CPU device.
// If not specified, defaults to -1
func InfeedEnqueuePrelinearizedBufferDeviceOrdinal(value int64) InfeedEnqueuePrelinearizedBufferAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op which enqueues prelinearized buffer into TPU infeed.
//
// Arguments:
//	input: A variant tensor representing linearized output.
//
// Returns the created operation.
func InfeedEnqueuePrelinearizedBuffer(scope *Scope, input tf.Output, optional ...InfeedEnqueuePrelinearizedBufferAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "InfeedEnqueuePrelinearizedBuffer",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Determine the script codes of a given tensor of Unicode integer code points.
//
// This operation converts Unicode code points to script codes corresponding to
// each code point. Script codes correspond to International Components for
// Unicode (ICU) UScriptCode values. See http://icu-project.org/apiref/icu4c/uscript_8h.html.
// Returns -1 (USCRIPT_INVALID_CODE) for invalid codepoints. Output shape will
// match input shape.
//
// Arguments:
//	input: A Tensor of int32 Unicode code points.
//
// Returns A Tensor of int32 script codes corresponding to each input code point.
func UnicodeScript(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "UnicodeScript",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Does nothing. Only useful as a placeholder for control edges.
//
// Returns the created operation.
func NoOp(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "NoOp",
	}
	return scope.AddOperation(opspec)
}

// EnqueueTPUEmbeddingIntegerBatchAttr is an optional argument to EnqueueTPUEmbeddingIntegerBatch.
type EnqueueTPUEmbeddingIntegerBatchAttr func(optionalAttr)

// EnqueueTPUEmbeddingIntegerBatchDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. Should be >= 0 and less than the number
// of TPU cores in the task on which the node is placed.
// If not specified, defaults to -1
func EnqueueTPUEmbeddingIntegerBatchDeviceOrdinal(value int64) EnqueueTPUEmbeddingIntegerBatchAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// An op that enqueues a list of input batch tensors to TPUEmbedding.
//
// Arguments:
//	batch: A list of 1D tensors, one for each embedding table, containing the
// indices into the tables.
//	mode_override: A string input that overrides the mode specified in the
// TPUEmbeddingConfiguration. Supported values are {'unspecified', 'inference',
// 'training', 'backward_pass_only'}. When set to 'unspecified', the mode set
// in TPUEmbeddingConfiguration is used, otherwise mode_override is used.
//
// Returns the created operation.
func EnqueueTPUEmbeddingIntegerBatch(scope *Scope, batch []tf.Output, mode_override tf.Output, optional ...EnqueueTPUEmbeddingIntegerBatchAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "EnqueueTPUEmbeddingIntegerBatch",
		Input: []tf.Input{
			tf.OutputList(batch), mode_override,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// LRNAttr is an optional argument to LRN.
type LRNAttr func(optionalAttr)

// LRNDepthRadius sets the optional depth_radius attribute to value.
//
// value: 0-D.  Half-width of the 1-D normalization window.
// If not specified, defaults to 5
func LRNDepthRadius(value int64) LRNAttr {
	return func(m optionalAttr) {
		m["depth_radius"] = value
	}
}

// LRNBias sets the optional bias attribute to value.
//
// value: An offset (usually positive to avoid dividing by 0).
// If not specified, defaults to 1
func LRNBias(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["bias"] = value
	}
}

// LRNAlpha sets the optional alpha attribute to value.
//
// value: A scale factor, usually positive.
// If not specified, defaults to 1
func LRNAlpha(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["alpha"] = value
	}
}

// LRNBeta sets the optional beta attribute to value.
//
// value: An exponent.
// If not specified, defaults to 0.5
func LRNBeta(value float32) LRNAttr {
	return func(m optionalAttr) {
		m["beta"] = value
	}
}

// Local Response Normalization.
//
// The 4-D `input` tensor is treated as a 3-D array of 1-D vectors (along the last
// dimension), and each vector is normalized independently.  Within a given vector,
// each component is divided by the weighted, squared sum of inputs within
// `depth_radius`.  In detail,
//
//     sqr_sum[a, b, c, d] =
//         sum(input[a, b, c, d - depth_radius : d + depth_radius + 1] ** 2)
//     output = input / (bias + alpha * sqr_sum) ** beta
//
// For details, see [Krizhevsky et al., ImageNet classification with deep
// convolutional neural networks (NIPS 2012)](http://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks).
//
// Arguments:
//	input: 4-D.
func LRN(scope *Scope, input tf.Output, optional ...LRNAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "LRN",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates sparse cross from a list of sparse and dense tensors.
//
// The op takes two lists, one of 2D `SparseTensor` and one of 2D `Tensor`, each
// representing features of one feature column. It outputs a 2D `SparseTensor` with
// the batchwise crosses of these features.
//
// For example, if the inputs are
//
//     inputs[0]: SparseTensor with shape = [2, 2]
//     [0, 0]: "a"
//     [1, 0]: "b"
//     [1, 1]: "c"
//
//     inputs[1]: SparseTensor with shape = [2, 1]
//     [0, 0]: "d"
//     [1, 0]: "e"
//
//     inputs[2]: Tensor [["f"], ["g"]]
//
// then the output will be
//
//     shape = [2, 2]
//     [0, 0]: "a_X_d_X_f"
//     [1, 0]: "b_X_e_X_g"
//     [1, 1]: "c_X_e_X_g"
//
// if hashed_output=true then the output will be
//
//     shape = [2, 2]
//     [0, 0]: FingerprintCat64(
//                 Fingerprint64("f"), FingerprintCat64(
//                     Fingerprint64("d"), Fingerprint64("a")))
//     [1, 0]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("b")))
//     [1, 1]: FingerprintCat64(
//                 Fingerprint64("g"), FingerprintCat64(
//                     Fingerprint64("e"), Fingerprint64("c")))
//
// Arguments:
//	indices: 2-D.  Indices of each input `SparseTensor`.
//	values: 1-D.   values of each `SparseTensor`.
//	shapes: 1-D.   Shapes of each `SparseTensor`.
//	dense_inputs: 2-D.    Columns represented by dense `Tensor`.
//	hashed_output: If true, returns the hash of the cross instead of the string.
// This will allow us avoiding string manipulations.
//	num_buckets: It is used if hashed_output is true.
// output = hashed_value%num_buckets if num_buckets > 0 else hashed_value.
//	hash_key: Specify the hash_key that will be used by the `FingerprintCat64`
// function to combine the crosses fingerprints.
//
//
//
// Returns 2-D.  Indices of the concatenated `SparseTensor`.1-D.  Non-empty values of the concatenated or hashed
// `SparseTensor`.1-D.  Shape of the concatenated `SparseTensor`.
func SparseCross(scope *Scope, indices []tf.Output, values []tf.Output, shapes []tf.Output, dense_inputs []tf.Output, hashed_output bool, num_buckets int64, hash_key int64, out_type tf.DataType, internal_type tf.DataType) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"hashed_output": hashed_output, "num_buckets": num_buckets, "hash_key": hash_key, "out_type": out_type, "internal_type": internal_type}
	opspec := tf.OpSpec{
		Type: "SparseCross",
		Input: []tf.Input{
			tf.OutputList(indices), tf.OutputList(values), tf.OutputList(shapes), tf.OutputList(dense_inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// WholeFileReaderV2Attr is an optional argument to WholeFileReaderV2.
type WholeFileReaderV2Attr func(optionalAttr)

// WholeFileReaderV2Container sets the optional container attribute to value.
//
// value: If non-empty, this reader is placed in the given container.
// Otherwise, a default container is used.
// If not specified, defaults to ""
func WholeFileReaderV2Container(value string) WholeFileReaderV2Attr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// WholeFileReaderV2SharedName sets the optional shared_name attribute to value.
//
// value: If non-empty, this reader is named in the given bucket
// with this shared_name. Otherwise, the node name is used instead.
// If not specified, defaults to ""
func WholeFileReaderV2SharedName(value string) WholeFileReaderV2Attr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// A Reader that outputs the entire contents of a file as a value.
//
// To use, enqueue filenames in a Queue.  The output of ReaderRead will
// be a filename (key) and the contents of that file (value).
//
// Returns The handle to reference the Reader.
func WholeFileReaderV2(scope *Scope, optional ...WholeFileReaderV2Attr) (reader_handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "WholeFileReaderV2",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Transforms a tf.Example proto (as a string) into typed tensors.
//
// Arguments:
//	serialized: A vector containing a batch of binary serialized Example protos.
//	dense_defaults: A list of Tensors (some may be empty), whose length matches
// the length of `dense_keys`. dense_defaults[j] provides default values
// when the example's feature_map lacks dense_key[j].  If an empty Tensor is
// provided for dense_defaults[j], then the Feature dense_keys[j] is required.
// The input type is inferred from dense_defaults[j], even when it's empty.
// If dense_defaults[j] is not empty, and dense_shapes[j] is fully defined,
// then the shape of dense_defaults[j] must match that of dense_shapes[j].
// If dense_shapes[j] has an undefined major dimension (variable strides dense
// feature), dense_defaults[j] must contain a single element:
// the padding element.
//	num_sparse: The number of sparse features to be parsed from the example. This
// must match the lengths of `sparse_keys` and `sparse_types`.
//	sparse_keys: A list of `num_sparse` strings.
// The keys expected in the Examples' features associated with sparse values.
//	dense_keys: The keys expected in the Examples' features associated with dense
// values.
//	sparse_types: A list of `num_sparse` types; the data types of data in each
// Feature given in sparse_keys.
// Currently the ParseSingleExample op supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
//	dense_shapes: The shapes of data in each Feature given in dense_keys.
// The length of this list must match the length of `dense_keys`.  The
// number of elements in the Feature corresponding to dense_key[j] must
// always equal dense_shapes[j].NumEntries().  If dense_shapes[j] ==
// (D0, D1, ..., DN) then the shape of output Tensor dense_values[j]
// will be (D0, D1, ..., DN): In the case dense_shapes[j] = (-1, D1,
// ..., DN), the shape of the output Tensor dense_values[j] will be (M,
// D1, .., DN), where M is the number of blocks of elements of length
// D1 * .... * DN, in the input.
func ParseSingleExample(scope *Scope, serialized tf.Output, dense_defaults []tf.Output, num_sparse int64, sparse_keys []string, dense_keys []string, sparse_types []tf.DataType, dense_shapes []tf.Shape) (sparse_indices []tf.Output, sparse_values []tf.Output, sparse_shapes []tf.Output, dense_values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_sparse": num_sparse, "sparse_keys": sparse_keys, "dense_keys": dense_keys, "sparse_types": sparse_types, "dense_shapes": dense_shapes}
	opspec := tf.OpSpec{
		Type: "ParseSingleExample",
		Input: []tf.Input{
			serialized, tf.OutputList(dense_defaults),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if sparse_indices, idx, err = makeOutputList(op, idx, "sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleExample", err)
		return
	}
	if sparse_values, idx, err = makeOutputList(op, idx, "sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleExample", err)
		return
	}
	if sparse_shapes, idx, err = makeOutputList(op, idx, "sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleExample", err)
		return
	}
	if dense_values, idx, err = makeOutputList(op, idx, "dense_values"); err != nil {
		scope.UpdateErr("ParseSingleExample", err)
		return
	}
	return sparse_indices, sparse_values, sparse_shapes, dense_values
}

// Quantized Batch normalization.
//
// This op is deprecated and will be removed in the future. Prefer
// `tf.nn.batch_normalization`.
//
// Arguments:
//	t: A 4D input Tensor.
//	t_min: The value represented by the lowest quantized input.
//	t_max: The value represented by the highest quantized input.
//	m: A 1D mean Tensor with size matching the last dimension of t.
// This is the first output from tf.nn.moments,
// or a saved moving average thereof.
//	m_min: The value represented by the lowest quantized mean.
//	m_max: The value represented by the highest quantized mean.
//	v: A 1D variance Tensor with size matching the last dimension of t.
// This is the second output from tf.nn.moments,
// or a saved moving average thereof.
//	v_min: The value represented by the lowest quantized variance.
//	v_max: The value represented by the highest quantized variance.
//	beta: A 1D beta Tensor with size matching the last dimension of t.
// An offset to be added to the normalized tensor.
//	beta_min: The value represented by the lowest quantized offset.
//	beta_max: The value represented by the highest quantized offset.
//	gamma: A 1D gamma Tensor with size matching the last dimension of t.
// If "scale_after_normalization" is true, this tensor will be multiplied
// with the normalized tensor.
//	gamma_min: The value represented by the lowest quantized gamma.
//	gamma_max: The value represented by the highest quantized gamma.
//
//	variance_epsilon: A small float number to avoid dividing by 0.
//	scale_after_normalization: A bool indicating whether the resulted tensor
// needs to be multiplied with gamma.
func QuantizedBatchNormWithGlobalNormalization(scope *Scope, t tf.Output, t_min tf.Output, t_max tf.Output, m tf.Output, m_min tf.Output, m_max tf.Output, v tf.Output, v_min tf.Output, v_max tf.Output, beta tf.Output, beta_min tf.Output, beta_max tf.Output, gamma tf.Output, gamma_min tf.Output, gamma_max tf.Output, out_type tf.DataType, variance_epsilon float32, scale_after_normalization bool) (result tf.Output, result_min tf.Output, result_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"out_type": out_type, "variance_epsilon": variance_epsilon, "scale_after_normalization": scale_after_normalization}
	opspec := tf.OpSpec{
		Type: "QuantizedBatchNormWithGlobalNormalization",
		Input: []tf.Input{
			t, t_min, t_max, m, m_min, m_max, v, v_min, v_max, beta, beta_min, beta_max, gamma, gamma_min, gamma_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// CudnnRNNBackpropAttr is an optional argument to CudnnRNNBackprop.
type CudnnRNNBackpropAttr func(optionalAttr)

// CudnnRNNBackpropRnnMode sets the optional rnn_mode attribute to value.
// If not specified, defaults to "lstm"
func CudnnRNNBackpropRnnMode(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["rnn_mode"] = value
	}
}

// CudnnRNNBackpropInputMode sets the optional input_mode attribute to value.
// If not specified, defaults to "linear_input"
func CudnnRNNBackpropInputMode(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["input_mode"] = value
	}
}

// CudnnRNNBackpropDirection sets the optional direction attribute to value.
// If not specified, defaults to "unidirectional"
func CudnnRNNBackpropDirection(value string) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["direction"] = value
	}
}

// CudnnRNNBackpropDropout sets the optional dropout attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropDropout(value float32) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["dropout"] = value
	}
}

// CudnnRNNBackpropSeed sets the optional seed attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropSeed(value int64) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// CudnnRNNBackpropSeed2 sets the optional seed2 attribute to value.
// If not specified, defaults to 0
func CudnnRNNBackpropSeed2(value int64) CudnnRNNBackpropAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Backprop step of CudnnRNN.
//
// Compute the backprop of both data and weights in a RNN.
//
// rnn_mode: Indicates the type of the RNN model.
// input_mode: Indicate whether there is a linear projection between the input and
//     the actual computation before the first layer. 'skip_input' is only allowed
//     when input_size == num_units; 'auto_select' implies 'skip_input' when
//     input_size == num_units; otherwise, it implies 'linear_input'.
// direction: Indicates whether a bidirectional model will be used. Should be
//   "unidirectional" or "bidirectional".
// dropout: Dropout probability. When set to 0., dropout is disabled.
// seed: The 1st part of a seed to initialize dropout.
// seed2: The 2nd part of a seed to initialize dropout.
// input: A 3-D tensor with the shape of [seq_length, batch_size, input_size].
// input_h: A 3-D tensor with the shape of [num_layer * dir, batch_size,
//     num_units].
// input_c: For LSTM, a 3-D tensor with the shape of
//     [num_layer * dir, batch, num_units]. For other models, it is ignored.
// params: A 1-D tensor that contains the weights and biases in an opaque layout.
//     The size must be created through CudnnRNNParamsSize, and initialized
//     separately. Note that they might not be compatible across different
//     generations. So it is a good idea to save and restore
// output: A 3-D tensor with the shape of [seq_length, batch_size,
//     dir * num_units].
// output_h: The same shape has input_h.
// output_c: The same shape as input_c for LSTM. An empty tensor for other models.
// output_backprop: A 3-D tensor with the same shape as output in the forward pass.
// output_h_backprop: A 3-D tensor with the same shape as output_h in the forward
//     pass.
// output_c_backprop: A 3-D tensor with the same shape as output_c in the forward
//     pass.
// reserve_space: The same reserve_space produced in for forward operation.
// input_backprop: The backprop to input in the forward pass. Has the same shape
//     as input.
// input_h_backprop: The backprop to input_h in the forward pass. Has the same
//     shape as input_h.
// input_c_backprop: The backprop to input_c in the forward pass. Has the same
//     shape as input_c.
// params_backprop: The backprop to the params buffer in the forward pass. Has the
//     same shape as params.
func CudnnRNNBackprop(scope *Scope, input tf.Output, input_h tf.Output, input_c tf.Output, params tf.Output, output tf.Output, output_h tf.Output, output_c tf.Output, output_backprop tf.Output, output_h_backprop tf.Output, output_c_backprop tf.Output, reserve_space tf.Output, optional ...CudnnRNNBackpropAttr) (input_backprop tf.Output, input_h_backprop tf.Output, input_c_backprop tf.Output, params_backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CudnnRNNBackprop",
		Input: []tf.Input{
			input, input_h, input_c, params, output, output_h, output_c, output_backprop, output_h_backprop, output_c_backprop, reserve_space,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// StaticRegexReplaceAttr is an optional argument to StaticRegexReplace.
type StaticRegexReplaceAttr func(optionalAttr)

// StaticRegexReplaceReplaceGlobal sets the optional replace_global attribute to value.
//
// value: If True, the replacement is global, otherwise the replacement
// is done only on the first match.
// If not specified, defaults to true
func StaticRegexReplaceReplaceGlobal(value bool) StaticRegexReplaceAttr {
	return func(m optionalAttr) {
		m["replace_global"] = value
	}
}

// Replaces the match of pattern in input with rewrite.
//
// It follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: The text to be processed.
//	pattern: The regular expression to match the input.
//	rewrite: The rewrite to be applied to the matched expression.
//
// Returns The text after applying pattern and rewrite.
func StaticRegexReplace(scope *Scope, input tf.Output, pattern string, rewrite string, optional ...StaticRegexReplaceAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"pattern": pattern, "rewrite": rewrite}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StaticRegexReplace",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MapSizeAttr is an optional argument to MapSize.
type MapSizeAttr func(optionalAttr)

// MapSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapSizeCapacity(value int64) MapSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// MapSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func MapSizeMemoryLimit(value int64) MapSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// MapSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func MapSizeContainer(value string) MapSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// MapSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func MapSizeSharedName(value string) MapSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func MapSize(scope *Scope, dtypes []tf.DataType, optional ...MapSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MapSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes requantization range per channel.
//
// Arguments:
//	input: The original input tensor.
//	input_min: The minimum value of the input tensor
//	input_max: The maximum value of the input tensor.
//	clip_value_max: The maximum value of the output that needs to be clipped.
// Example: set this to 6 for Relu6.
//
// Returns The minimum value of the final output tensorThe maximum value of the final output tensor.
func RequantizationRangePerChannel(scope *Scope, input tf.Output, input_min tf.Output, input_max tf.Output, clip_value_max float32) (output_min tf.Output, output_max tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"clip_value_max": clip_value_max}
	opspec := tf.OpSpec{
		Type: "RequantizationRangePerChannel",
		Input: []tf.Input{
			input, input_min, input_max,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// NonDeterministicIntsAttr is an optional argument to NonDeterministicInts.
type NonDeterministicIntsAttr func(optionalAttr)

// NonDeterministicIntsDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_INT64
func NonDeterministicIntsDtype(value tf.DataType) NonDeterministicIntsAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Non-deterministically generates some integers.
//
// This op may use some OS-provided source of non-determinism (e.g. an RNG), so each execution will give different results.
//
// Arguments:
//	shape: The shape of the output tensor.
//
// Returns Non-deterministic integer values with specified shape.
func NonDeterministicInts(scope *Scope, shape tf.Output, optional ...NonDeterministicIntsAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "NonDeterministicInts",
		Input: []tf.Input{
			shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Check if the input matches the regex pattern.
//
// The input is a string tensor of any shape. The pattern is a scalar
// string tensor which is applied to every element of the input tensor.
// The boolean values (True or False) of the output tensor indicate
// if the input matches the regex pattern provided.
//
// The pattern follows the re2 syntax (https://github.com/google/re2/wiki/Syntax)
//
// Arguments:
//	input: A string tensor of the text to be processed.
//	pattern: A scalar string tensor containing the regular expression to match the input.
//
// Returns A bool tensor with the same shape as `input`.
func RegexFullMatch(scope *Scope, input tf.Output, pattern tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RegexFullMatch",
		Input: []tf.Input{
			input, pattern,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Adds a value to the current value of a variable.
//
// Any ReadVariableOp with a control dependency on this op is guaranteed to
// see the incremented value or a subsequent newer one.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	value: the value by which the variable will be incremented.
//
// Returns the created operation.
func AssignAddVariableOp(scope *Scope, resource tf.Output, value tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "AssignAddVariableOp",
		Input: []tf.Input{
			resource, value,
		},
	}
	return scope.AddOperation(opspec)
}

// BoostedTreesCreateQuantileStreamResourceAttr is an optional argument to BoostedTreesCreateQuantileStreamResource.
type BoostedTreesCreateQuantileStreamResourceAttr func(optionalAttr)

// BoostedTreesCreateQuantileStreamResourceMaxElements sets the optional max_elements attribute to value.
//
// value: int; The maximum number of data points that can be fed to the stream.
// If not specified, defaults to 1099511627776
func BoostedTreesCreateQuantileStreamResourceMaxElements(value int64) BoostedTreesCreateQuantileStreamResourceAttr {
	return func(m optionalAttr) {
		m["max_elements"] = value
	}
}

// Create the Resource for Quantile Streams.
//
// Arguments:
//	quantile_stream_resource_handle: resource; Handle to quantile stream resource.
//	epsilon: float; The required approximation error of the stream resource.
//	num_streams: int; The number of streams managed by the resource that shares the same epsilon.
//
// Returns the created operation.
func BoostedTreesCreateQuantileStreamResource(scope *Scope, quantile_stream_resource_handle tf.Output, epsilon tf.Output, num_streams tf.Output, optional ...BoostedTreesCreateQuantileStreamResourceAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BoostedTreesCreateQuantileStreamResource",
		Input: []tf.Input{
			quantile_stream_resource_handle, epsilon, num_streams,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// StageSizeAttr is an optional argument to StageSize.
type StageSizeAttr func(optionalAttr)

// StageSizeCapacity sets the optional capacity attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageSizeCapacity(value int64) StageSizeAttr {
	return func(m optionalAttr) {
		m["capacity"] = value
	}
}

// StageSizeMemoryLimit sets the optional memory_limit attribute to value.
// If not specified, defaults to 0
//
// REQUIRES: value >= 0
func StageSizeMemoryLimit(value int64) StageSizeAttr {
	return func(m optionalAttr) {
		m["memory_limit"] = value
	}
}

// StageSizeContainer sets the optional container attribute to value.
// If not specified, defaults to ""
func StageSizeContainer(value string) StageSizeAttr {
	return func(m optionalAttr) {
		m["container"] = value
	}
}

// StageSizeSharedName sets the optional shared_name attribute to value.
// If not specified, defaults to ""
func StageSizeSharedName(value string) StageSizeAttr {
	return func(m optionalAttr) {
		m["shared_name"] = value
	}
}

// Op returns the number of elements in the underlying container.
func StageSize(scope *Scope, dtypes []tf.DataType, optional ...StageSizeAttr) (size tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StageSize",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts each string in the input Tensor to its hash mod by a number of buckets.
//
// The hash function is deterministic on the content of the string within the
// process and will never change. However, it is not suitable for cryptography.
// This function may be used when CPU time is scarce and inputs are trusted or
// unimportant. There is a risk of adversaries constructing inputs that all hash
// to the same bucket. To prevent this problem, use a strong hash function with
// `tf.string_to_hash_bucket_strong`.
//
// Arguments:
//	input: The strings to assign a hash bucket.
//	num_buckets: The number of buckets.
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToHashBucketFast(scope *Scope, input tf.Output, num_buckets int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "StringToHashBucketFast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Converts one or more images from RGB to HSV.
//
// Outputs a tensor of the same shape as the `images` tensor, containing the HSV
// value of the pixels. The output is only well defined if the value in `images`
// are in `[0,1]`.
//
// `output[..., 0]` contains hue, `output[..., 1]` contains saturation, and
// `output[..., 2]` contains value. All HSV values are in `[0,1]`. A hue of 0
// corresponds to pure red, hue 1/3 is pure green, and 2/3 is pure blue.
//
// Arguments:
//	images: 1-D or higher rank. RGB data to convert. Last dimension must be size 3.
//
// Returns `images` converted to HSV.
func RGBToHSV(scope *Scope, images tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RGBToHSV",
		Input: []tf.Input{
			images,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SparseReduceSumSparseAttr is an optional argument to SparseReduceSumSparse.
type SparseReduceSumSparseAttr func(optionalAttr)

// SparseReduceSumSparseKeepDims sets the optional keep_dims attribute to value.
//
// value: If true, retain reduced dimensions with length 1.
// If not specified, defaults to false
func SparseReduceSumSparseKeepDims(value bool) SparseReduceSumSparseAttr {
	return func(m optionalAttr) {
		m["keep_dims"] = value
	}
}

// Computes the sum of elements across dimensions of a SparseTensor.
//
// This Op takes a SparseTensor and is the sparse counterpart to
// `tf.reduce_sum()`.  In contrast to SparseReduceSum, this Op returns a
// SparseTensor.
//
// Reduces `sp_input` along the dimensions given in `reduction_axes`.  Unless
// `keep_dims` is true, the rank of the tensor is reduced by 1 for each entry in
// `reduction_axes`. If `keep_dims` is true, the reduced dimensions are retained
// with length 1.
//
// If `reduction_axes` has no entries, all dimensions are reduced, and a tensor
// with a single element is returned.  Additionally, the axes can be negative,
// which are interpreted according to the indexing rules in Python.
//
// Arguments:
//	input_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	input_values: 1-D.  `N` non-empty values corresponding to `input_indices`.
//	input_shape: 1-D.  Shape of the input SparseTensor.
//	reduction_axes: 1-D.  Length-`K` vector containing the reduction axes.
func SparseReduceSumSparse(scope *Scope, input_indices tf.Output, input_values tf.Output, input_shape tf.Output, reduction_axes tf.Output, optional ...SparseReduceSumSparseAttr) (output_indices tf.Output, output_values tf.Output, output_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SparseReduceSumSparse",
		Input: []tf.Input{
			input_indices, input_values, input_shape, reduction_axes,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Adds up a SparseTensor and a dense Tensor, using these special rules:
//
// (1) Broadcasts the dense side to have the same shape as the sparse side, if
//     eligible;
// (2) Then, only the dense values pointed to by the indices of the SparseTensor
//     participate in the cwise addition.
//
// By these rules, the result is a logical SparseTensor with exactly the same
// indices and shape, but possibly with different non-zero values.  The output of
// this Op is the resultant non-zero values.
//
// Arguments:
//	sp_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, possibly not in canonical ordering.
//	sp_values: 1-D.  `N` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//	dense: `R`-D.  The dense Tensor operand.
//
// Returns 1-D.  The `N` values that are operated on.
func SparseDenseCwiseAdd(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output, dense tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseDenseCwiseAdd",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape, dense,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingFTRLParametersGradAccumDebugAttr is an optional argument to RetrieveTPUEmbeddingFTRLParametersGradAccumDebug.
type RetrieveTPUEmbeddingFTRLParametersGradAccumDebugAttr func(optionalAttr)

// RetrieveTPUEmbeddingFTRLParametersGradAccumDebugTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingFTRLParametersGradAccumDebugTableId(value int64) RetrieveTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingFTRLParametersGradAccumDebugTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingFTRLParametersGradAccumDebugTableName(value string) RetrieveTPUEmbeddingFTRLParametersGradAccumDebugAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve FTRL embedding parameters with debug support.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the FTRL optimization algorithm.Parameter accumulators updated by the FTRL optimization algorithm.Parameter linears updated by the FTRL optimization algorithm.Parameter gradient_accumulators updated by the FTRL optimization algorithm.
func RetrieveTPUEmbeddingFTRLParametersGradAccumDebug(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingFTRLParametersGradAccumDebugAttr) (parameters tf.Output, accumulators tf.Output, linears tf.Output, gradient_accumulators tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingFTRLParametersGradAccumDebug",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2), op.Output(3)
}

// Returns 0 if the denominator is zero.
//
//
// *NOTE*: `DivNoNan` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func DivNoNan(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DivNoNan",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Shuffle dimensions of x according to a permutation.
//
// The output `y` has the same rank as `x`. The shapes of `x` and `y` satisfy:
//   `y.shape[i] == x.shape[perm[i]] for i in [0, 1, ..., rank(x) - 1]`
func Transpose(scope *Scope, x tf.Output, perm tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Transpose",
		Input: []tf.Input{
			x, perm,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes element-wise population count (a.k.a. popcount, bitsum, bitcount).
//
// For each entry in `x`, calculates the number of `1` (on) bits in the binary
// representation of that entry.
//
// **NOTE**: It is more efficient to first `tf.bitcast` your tensors into
// `int32` or `int64` and perform the bitcount on the result, than to feed in
// 8- or 16-bit inputs and then aggregate the resulting counts.
func PopulationCount(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "PopulationCount",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the element-wise min of two SparseTensors.
//
// Assumes the two SparseTensors have the same shape, i.e., no broadcasting.
//
// Arguments:
//	a_indices: 2-D.  `N x R` matrix with the indices of non-empty values in a
// SparseTensor, in the canonical lexicographic ordering.
//	a_values: 1-D.  `N` non-empty values corresponding to `a_indices`.
//	a_shape: 1-D.  Shape of the input SparseTensor.
//	b_indices: counterpart to `a_indices` for the other operand.
//	b_values: counterpart to `a_values` for the other operand; must be of the same dtype.
//	b_shape: counterpart to `a_shape` for the other operand; the two shapes must be equal.
//
// Returns 2-D.  The indices of the output SparseTensor.1-D.  The values of the output SparseTensor.
func SparseSparseMinimum(scope *Scope, a_indices tf.Output, a_values tf.Output, a_shape tf.Output, b_indices tf.Output, b_values tf.Output, b_shape tf.Output) (output_indices tf.Output, output_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSparseMinimum",
		Input: []tf.Input{
			a_indices, a_values, a_shape, b_indices, b_values, b_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Converts each string in the input Tensor to its hash mod by a number of buckets.
//
// The hash function is deterministic on the content of the string within the
// process.
//
// Note that the hash function may change from time to time.
// This functionality will be deprecated and it's recommended to use
// `tf.string_to_hash_bucket_fast()` or `tf.string_to_hash_bucket_strong()`.
//
// Arguments:
//
//	num_buckets: The number of buckets.
//
// Returns A Tensor of the same shape as the input `string_tensor`.
func StringToHashBucket(scope *Scope, string_tensor tf.Output, num_buckets int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_buckets": num_buckets}
	opspec := tf.OpSpec{
		Type: "StringToHashBucket",
		Input: []tf.Input{
			string_tensor,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reads the value of a variable.
//
// The tensor returned by this operation is immutable.
//
// The value returned by this operation is guaranteed to be influenced by all the
// writes on which this operation depends directly or indirectly, and to not be
// influenced by any of the writes which depend directly or indirectly on this
// operation.
//
// Arguments:
//	resource: handle to the resource in which to store the variable.
//	dtype: the dtype of the value.
func ReadVariableOp(scope *Scope, resource tf.Output, dtype tf.DataType) (value tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype}
	opspec := tf.OpSpec{
		Type: "ReadVariableOp",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Reshapes a tensor.
//
// Given `tensor`, this operation returns a tensor that has the same values
// as `tensor` with shape `shape`.
//
// If one component of `shape` is the special value -1, the size of that dimension
// is computed so that the total size remains constant.  In particular, a `shape`
// of `[-1]` flattens into 1-D.  At most one component of `shape` can be -1.
//
// If `shape` is 1-D or higher, then the operation returns a tensor with shape
// `shape` filled with the values of `tensor`. In this case, the number of elements
// implied by `shape` must be the same as the number of elements in `tensor`.
//
// For example:
//
// ```
// # tensor 't' is [1, 2, 3, 4, 5, 6, 7, 8, 9]
// # tensor 't' has shape [9]
// reshape(t, [3, 3]) ==> [[1, 2, 3],
//                         [4, 5, 6],
//                         [7, 8, 9]]
//
// # tensor 't' is [[[1, 1], [2, 2]],
// #                [[3, 3], [4, 4]]]
// # tensor 't' has shape [2, 2, 2]
// reshape(t, [2, 4]) ==> [[1, 1, 2, 2],
//                         [3, 3, 4, 4]]
//
// # tensor 't' is [[[1, 1, 1],
// #                 [2, 2, 2]],
// #                [[3, 3, 3],
// #                 [4, 4, 4]],
// #                [[5, 5, 5],
// #                 [6, 6, 6]]]
// # tensor 't' has shape [3, 2, 3]
// # pass '[-1]' to flatten 't'
// reshape(t, [-1]) ==> [1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6]
//
// # -1 can also be used to infer the shape
//
// # -1 is inferred to be 9:
// reshape(t, [2, -1]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
//                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
// # -1 is inferred to be 2:
// reshape(t, [-1, 9]) ==> [[1, 1, 1, 2, 2, 2, 3, 3, 3],
//                          [4, 4, 4, 5, 5, 5, 6, 6, 6]]
// # -1 is inferred to be 3:
// reshape(t, [ 2, -1, 3]) ==> [[[1, 1, 1],
//                               [2, 2, 2],
//                               [3, 3, 3]],
//                              [[4, 4, 4],
//                               [5, 5, 5],
//                               [6, 6, 6]]]
//
// # tensor 't' is [7]
// # shape `[]` reshapes to a scalar
// reshape(t, []) ==> 7
// ```
//
// Arguments:
//
//	shape: Defines the shape of the output tensor.
func Reshape(scope *Scope, tensor tf.Output, shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Reshape",
		Input: []tf.Input{
			tensor, shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// AssertAttr is an optional argument to Assert.
type AssertAttr func(optionalAttr)

// AssertSummarize sets the optional summarize attribute to value.
//
// value: Print this many entries of each tensor.
// If not specified, defaults to 3
func AssertSummarize(value int64) AssertAttr {
	return func(m optionalAttr) {
		m["summarize"] = value
	}
}

// Asserts that the given condition is true.
//
// If `condition` evaluates to false, print the list of tensors in `data`.
// `summarize` determines how many entries of the tensors to print.
//
// Arguments:
//	condition: The condition to evaluate.
//	data: The tensors to print out when condition is false.
//
// Returns the created operation.
func Assert(scope *Scope, condition tf.Output, data []tf.Output, optional ...AssertAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Assert",
		Input: []tf.Input{
			condition, tf.OutputList(data),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// AsStringAttr is an optional argument to AsString.
type AsStringAttr func(optionalAttr)

// AsStringPrecision sets the optional precision attribute to value.
//
// value: The post-decimal precision to use for floating point numbers.
// Only used if precision > -1.
// If not specified, defaults to -1
func AsStringPrecision(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["precision"] = value
	}
}

// AsStringScientific sets the optional scientific attribute to value.
//
// value: Use scientific notation for floating point numbers.
// If not specified, defaults to false
func AsStringScientific(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["scientific"] = value
	}
}

// AsStringShortest sets the optional shortest attribute to value.
//
// value: Use shortest representation (either scientific or standard) for
// floating point numbers.
// If not specified, defaults to false
func AsStringShortest(value bool) AsStringAttr {
	return func(m optionalAttr) {
		m["shortest"] = value
	}
}

// AsStringWidth sets the optional width attribute to value.
//
// value: Pad pre-decimal numbers to this width.
// Applies to both floating point and integer numbers.
// Only used if width > -1.
// If not specified, defaults to -1
func AsStringWidth(value int64) AsStringAttr {
	return func(m optionalAttr) {
		m["width"] = value
	}
}

// AsStringFill sets the optional fill attribute to value.
//
// value: The value to pad if width > -1.  If empty, pads with spaces.
// Another typical value is '0'.  String cannot be longer than 1 character.
// If not specified, defaults to ""
func AsStringFill(value string) AsStringAttr {
	return func(m optionalAttr) {
		m["fill"] = value
	}
}

// Converts each entry in the given tensor to strings.  Supports many numeric
//
// types and boolean.
func AsString(scope *Scope, input tf.Output, optional ...AsStringAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "AsString",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulUniformFullIntAttr is an optional argument to StatefulUniformFullInt.
type StatefulUniformFullIntAttr func(optionalAttr)

// StatefulUniformFullIntDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_UINT64
func StatefulUniformFullIntDtype(value tf.DataType) StatefulUniformFullIntAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random integers from a uniform distribution.
//
// The generated values are uniform integers covering the whole range of `dtype`.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//
// Returns Random values with specified shape.
func StatefulUniformFullInt(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, optional ...StatefulUniformFullIntAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulUniformFullInt",
		Input: []tf.Input{
			resource, algorithm, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringFormatAttr is an optional argument to StringFormat.
type StringFormatAttr func(optionalAttr)

// StringFormatTemplate sets the optional template attribute to value.
//
// value: A string, the template to format tensor summaries into.
// If not specified, defaults to "%s"
func StringFormatTemplate(value string) StringFormatAttr {
	return func(m optionalAttr) {
		m["template"] = value
	}
}

// StringFormatPlaceholder sets the optional placeholder attribute to value.
//
// value: A string, at each placeholder in the template a subsequent tensor summary will be inserted.
// If not specified, defaults to "%s"
func StringFormatPlaceholder(value string) StringFormatAttr {
	return func(m optionalAttr) {
		m["placeholder"] = value
	}
}

// StringFormatSummarize sets the optional summarize attribute to value.
//
// value: When formatting the tensor summaries print the first and last summarize entries of each tensor dimension.
// If not specified, defaults to 3
func StringFormatSummarize(value int64) StringFormatAttr {
	return func(m optionalAttr) {
		m["summarize"] = value
	}
}

// Formats a string template using a list of tensors.
//
// Formats a string template using a list of tensors, pretty-printing tensor summaries.
//
// Arguments:
//	inputs: The list of tensors to format into the placeholder string.
//
// Returns = The resulting string scalar.
func StringFormat(scope *Scope, inputs []tf.Output, optional ...StringFormatAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringFormat",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StringSplitAttr is an optional argument to StringSplit.
type StringSplitAttr func(optionalAttr)

// StringSplitSkipEmpty sets the optional skip_empty attribute to value.
//
// value: A `bool`. If `True`, skip the empty strings from the result.
// If not specified, defaults to true
func StringSplitSkipEmpty(value bool) StringSplitAttr {
	return func(m optionalAttr) {
		m["skip_empty"] = value
	}
}

// Split elements of `input` based on `delimiter` into a `SparseTensor`.
//
// Let N be the size of source (typically N will be the batch size). Split each
// element of `input` based on `delimiter` and return a `SparseTensor`
// containing the splitted tokens. Empty tokens are ignored.
//
// `delimiter` can be empty, or a string of split characters. If `delimiter` is an
//  empty string, each element of `input` is split into individual single-byte
//  character strings, including splitting of UTF-8 multibyte sequences. Otherwise
//  every character of `delimiter` is a potential split point.
//
// For example:
//   N = 2, input[0] is 'hello world' and input[1] is 'a b c', then the output
//   will be
//
//   indices = [0, 0;
//              0, 1;
//              1, 0;
//              1, 1;
//              1, 2]
//   shape = [2, 3]
//   values = ['hello', 'world', 'a', 'b', 'c']
//
// Arguments:
//	input: 1-D. Strings to split.
//	delimiter: 0-D. Delimiter characters (bytes), or empty string.
//
// Returns A dense matrix of int64 representing the indices of the sparse tensor.A vector of strings corresponding to the splited values.a length-2 vector of int64 representing the shape of the sparse
// tensor, where the first value is N and the second value is the maximum number
// of tokens in a single input entry.
func StringSplit(scope *Scope, input tf.Output, delimiter tf.Output, optional ...StringSplitAttr) (indices tf.Output, values tf.Output, shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StringSplit",
		Input: []tf.Input{
			input, delimiter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// BatchToSpace for 4-D tensors of type T.
//
// This is a legacy version of the more general BatchToSpaceND.
//
// Rearranges (permutes) data from batch into blocks of spatial data, followed by
// cropping. This is the reverse transformation of SpaceToBatch. More specifically,
// this op outputs a copy of the input tensor where values from the `batch`
// dimension are moved in spatial blocks to the `height` and `width` dimensions,
// followed by cropping along the `height` and `width` dimensions.
//
// Arguments:
//	input: 4-D tensor with shape
// `[batch*block_size*block_size, height_pad/block_size, width_pad/block_size,
//   depth]`. Note that the batch size of the input tensor must be divisible by
// `block_size * block_size`.
//	crops: 2-D tensor of non-negative integers with shape `[2, 2]`. It specifies
// how many elements to crop from the intermediate result across the spatial
// dimensions as follows:
//
//     crops = [[crop_top, crop_bottom], [crop_left, crop_right]]
//
//
// Returns 4-D with shape `[batch, height, width, depth]`, where:
//
//       height = height_pad - crop_top - crop_bottom
//       width = width_pad - crop_left - crop_right
//
// The attr `block_size` must be greater than one. It indicates the block size.
//
// Some examples:
//
// (1) For the following input of shape `[4, 1, 1, 1]` and block_size of 2:
//
// ```
// [[[[1]]], [[[2]]], [[[3]]], [[[4]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 1]` and value:
//
// ```
// x = [[[[1], [2]], [[3], [4]]]]
// ```
//
// (2) For the following input of shape `[4, 1, 1, 3]` and block_size of 2:
//
// ```
// [[[[1, 2, 3]]], [[[4, 5, 6]]], [[[7, 8, 9]]], [[[10, 11, 12]]]]
// ```
//
// The output tensor has shape `[1, 2, 2, 3]` and value:
//
// ```
// x = [[[[1, 2, 3], [4, 5, 6]],
//       [[7, 8, 9], [10, 11, 12]]]]
// ```
//
// (3) For the following input of shape `[4, 2, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [3]], [[9], [11]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
//
// The output tensor has shape `[1, 4, 4, 1]` and value:
//
// ```
// x = [[[[1],   [2],  [3],  [4]],
//      [[5],   [6],  [7],  [8]],
//      [[9],  [10], [11],  [12]],
//      [[13], [14], [15],  [16]]]]
// ```
//
// (4) For the following input of shape `[8, 1, 2, 1]` and block_size of 2:
//
// ```
// x = [[[[1], [3]]], [[[9], [11]]], [[[2], [4]]], [[[10], [12]]],
//      [[[5], [7]]], [[[13], [15]]], [[[6], [8]]], [[[14], [16]]]]
// ```
//
// The output tensor has shape `[2, 2, 4, 1]` and value:
//
// ```
// x = [[[[1], [3]], [[5], [7]]],
//      [[[2], [4]], [[10], [12]]],
//      [[[5], [7]], [[13], [15]]],
//      [[[6], [8]], [[14], [16]]]]
// ```
func BatchToSpace(scope *Scope, input tf.Output, crops tf.Output, block_size int64) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"block_size": block_size}
	opspec := tf.OpSpec{
		Type: "BatchToSpace",
		Input: []tf.Input{
			input, crops,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// This op consumes a lock created by `MutexLock`.
//
// This op exists to consume a tensor created by `MutexLock` (other than
// direct control dependencies).  It should be the only that consumes the tensor,
// and will raise an error if it is not.  Its only purpose is to keep the
// mutex lock tensor alive until it is consumed by this op.
//
// **NOTE**: This operation must run on the same device as its input.  This may
// be enforced via the `colocate_with` mechanism.
//
// Arguments:
//	mutex_lock: A tensor returned by `MutexLock`.
//
// Returns the created operation.
func ConsumeMutexLock(scope *Scope, mutex_lock tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ConsumeMutexLock",
		Input: []tf.Input{
			mutex_lock,
		},
	}
	return scope.AddOperation(opspec)
}

// Reduces sparse updates into the variable referenced by `resource` using the `max` operation.
//
// This operation computes
//
//     # Scalar indices
//     ref[indices, ...] = max(ref[indices, ...], updates[...])
//
//     # Vector indices (for each i)
//     ref[indices[i], ...] = max(ref[indices[i], ...], updates[i, ...])
//
//     # High rank indices (for each i, ..., j)
//     ref[indices[i, ..., j], ...] = max(ref[indices[i, ..., j], ...], updates[i, ..., j, ...])
//
// Duplicate entries are handled correctly: if multiple `indices` reference
// the same location, their contributions are combined.
//
// Requires `updates.shape = indices.shape + ref.shape[1:]` or `updates.shape = []`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src='https://www.tensorflow.org/images/ScatterAdd.png' alt>
// </div>
//
// Arguments:
//	resource: Should be from a `Variable` node.
//	indices: A tensor of indices into the first dimension of `ref`.
//	updates: A tensor of updated values to add to `ref`.
//
// Returns the created operation.
func ResourceScatterMax(scope *Scope, resource tf.Output, indices tf.Output, updates tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterMax",
		Input: []tf.Input{
			resource, indices, updates,
		},
	}
	return scope.AddOperation(opspec)
}

// ResourceApplyAdaMaxAttr is an optional argument to ResourceApplyAdaMax.
type ResourceApplyAdaMaxAttr func(optionalAttr)

// ResourceApplyAdaMaxUseLocking sets the optional use_locking attribute to value.
//
// value: If `True`, updating of the var, m, and v tensors will be protected
// by a lock; otherwise the behavior is undefined, but may exhibit less
// contention.
// If not specified, defaults to false
func ResourceApplyAdaMaxUseLocking(value bool) ResourceApplyAdaMaxAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Update '*var' according to the AdaMax algorithm.
//
// m_t <- beta1 * m_{t-1} + (1 - beta1) * g
// v_t <- max(beta2 * v_{t-1}, abs(g))
// variable <- variable - learning_rate / (1 - beta1^t) * m_t / (v_t + epsilon)
//
// Arguments:
//	var_: Should be from a Variable().
//	m: Should be from a Variable().
//	v: Should be from a Variable().
//	beta1_power: Must be a scalar.
//	lr: Scaling factor. Must be a scalar.
//	beta1: Momentum factor. Must be a scalar.
//	beta2: Momentum factor. Must be a scalar.
//	epsilon: Ridge term. Must be a scalar.
//	grad: The gradient.
//
// Returns the created operation.
func ResourceApplyAdaMax(scope *Scope, var_ tf.Output, m tf.Output, v tf.Output, beta1_power tf.Output, lr tf.Output, beta1 tf.Output, beta2 tf.Output, epsilon tf.Output, grad tf.Output, optional ...ResourceApplyAdaMaxAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceApplyAdaMax",
		Input: []tf.Input{
			var_, m, v, beta1_power, lr, beta1, beta2, epsilon, grad,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// CTCBeamSearchDecoderAttr is an optional argument to CTCBeamSearchDecoder.
type CTCBeamSearchDecoderAttr func(optionalAttr)

// CTCBeamSearchDecoderMergeRepeated sets the optional merge_repeated attribute to value.
//
// value: If true, merge repeated classes in output.
// If not specified, defaults to true
func CTCBeamSearchDecoderMergeRepeated(value bool) CTCBeamSearchDecoderAttr {
	return func(m optionalAttr) {
		m["merge_repeated"] = value
	}
}

// Performs beam search decoding on the logits given in input.
//
// A note about the attribute merge_repeated: For the beam search decoder,
// this means that if consecutive entries in a beam are the same, only
// the first of these is emitted.  That is, when the top path is "A B B B B",
// "A B" is returned if merge_repeated = True but "A B B B B" is
// returned if merge_repeated = False.
//
// Arguments:
//	inputs: 3-D, shape: `(max_time x batch_size x num_classes)`, the logits.
//	sequence_length: A vector containing sequence lengths, size `(batch)`.
//	beam_width: A scalar >= 0 (beam search beam width).
//	top_paths: A scalar >= 0, <= beam_width (controls output size).
//
// Returns A list (length: top_paths) of indices matrices.  Matrix j,
// size `(total_decoded_outputs[j] x 2)`, has indices of a
// `SparseTensor<int64, 2>`.  The rows store: [batch, time].A list (length: top_paths) of values vectors.  Vector j,
// size `(length total_decoded_outputs[j])`, has the values of a
// `SparseTensor<int64, 2>`.  The vector stores the decoded classes for beam j.A list (length: top_paths) of shape vector.  Vector j,
// size `(2)`, stores the shape of the decoded `SparseTensor[j]`.
// Its values are: `[batch_size, max_decoded_length[j]]`.A matrix, shaped: `(batch_size x top_paths)`.  The
// sequence log-probabilities.
func CTCBeamSearchDecoder(scope *Scope, inputs tf.Output, sequence_length tf.Output, beam_width int64, top_paths int64, optional ...CTCBeamSearchDecoderAttr) (decoded_indices []tf.Output, decoded_values []tf.Output, decoded_shape []tf.Output, log_probability tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"beam_width": beam_width, "top_paths": top_paths}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CTCBeamSearchDecoder",
		Input: []tf.Input{
			inputs, sequence_length,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if decoded_indices, idx, err = makeOutputList(op, idx, "decoded_indices"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	if decoded_values, idx, err = makeOutputList(op, idx, "decoded_values"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	if decoded_shape, idx, err = makeOutputList(op, idx, "decoded_shape"); err != nil {
		scope.UpdateErr("CTCBeamSearchDecoder", err)
		return
	}
	log_probability = op.Output(idx)
	return decoded_indices, decoded_values, decoded_shape, log_probability
}

// Applies softmax to a batched N-D `SparseTensor`.
//
// The inputs represent an N-D SparseTensor  with logical shape `[..., B, C]`
// (where `N >= 2`), and with indices sorted in the canonical lexicographic order.
//
// This op is equivalent to applying the normal `tf.nn.softmax()` to each innermost
// logical submatrix with shape `[B, C]`, but with the catch that *the implicitly
// zero elements do not participate*.  Specifically, the algorithm is equivalent
// to the following:
//
//   (1) Applies `tf.nn.softmax()` to a densified view of each innermost submatrix
//       with shape `[B, C]`, along the size-C dimension;
//   (2) Masks out the original implicitly-zero locations;
//   (3) Renormalizes the remaining elements.
//
// Hence, the `SparseTensor` result has exactly the same non-zero indices and
// shape.
//
// Arguments:
//	sp_indices: 2-D.  `NNZ x R` matrix with the indices of non-empty values in a
// SparseTensor, in canonical ordering.
//	sp_values: 1-D.  `NNZ` non-empty values corresponding to `sp_indices`.
//	sp_shape: 1-D.  Shape of the input SparseTensor.
//
// Returns 1-D.  The `NNZ` values for the result `SparseTensor`.
func SparseSoftmax(scope *Scope, sp_indices tf.Output, sp_values tf.Output, sp_shape tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SparseSoftmax",
		Input: []tf.Input{
			sp_indices, sp_values, sp_shape,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Strip leading and trailing whitespaces from the Tensor.
//
// Arguments:
//	input: A string `Tensor` of any shape.
//
// Returns A string `Tensor` of the same shape as the input.
func StringStrip(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StringStrip",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessTruncatedNormalAttr is an optional argument to StatelessTruncatedNormal.
type StatelessTruncatedNormalAttr func(optionalAttr)

// StatelessTruncatedNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessTruncatedNormalDtype(value tf.DataType) StatelessTruncatedNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom values from a truncated normal distribution.
//
// The generated values follow a normal distribution with mean 0 and standard
// deviation 1, except that values whose magnitude is more than 2 standard
// deviations from the mean are dropped and re-picked.
//
// The outputs are a deterministic function of `shape` and `seed`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//
// Returns Random values with specified shape.
func StatelessTruncatedNormal(scope *Scope, shape tf.Output, seed tf.Output, optional ...StatelessTruncatedNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessTruncatedNormal",
		Input: []tf.Input{
			shape, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatefulStandardNormalV2Attr is an optional argument to StatefulStandardNormalV2.
type StatefulStandardNormalV2Attr func(optionalAttr)

// StatefulStandardNormalV2Dtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatefulStandardNormalV2Dtype(value tf.DataType) StatefulStandardNormalV2Attr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs random values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// Arguments:
//	resource: The handle of the resource variable that stores the state of the RNG.
//	algorithm: The RNG algorithm.
//	shape: The shape of the output tensor.
//
// Returns A tensor of the specified shape filled with random normal values.
func StatefulStandardNormalV2(scope *Scope, resource tf.Output, algorithm tf.Output, shape tf.Output, optional ...StatefulStandardNormalV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatefulStandardNormalV2",
		Input: []tf.Input{
			resource, algorithm, shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Restores tensors from a V2 checkpoint.
//
// For backward compatibility with the V1 format, this Op currently allows
// restoring from a V1 checkpoint as well:
//   - This Op first attempts to find the V2 index file pointed to by "prefix", and
//     if found proceed to read it as a V2 checkpoint;
//   - Otherwise the V1 read path is invoked.
// Relying on this behavior is not recommended, as the ability to fall back to read
// V1 might be deprecated and eventually removed.
//
// By default, restores the named tensors in full.  If the caller wishes to restore
// specific slices of stored tensors, "shape_and_slices" should be non-empty
// strings and correspondingly well-formed.
//
// Callers must ensure all the named tensors are indeed stored in the checkpoint.
//
// Arguments:
//	prefix: Must have a single element.  The prefix of a V2 checkpoint.
//	tensor_names: shape {N}.  The names of the tensors to be restored.
//	shape_and_slices: shape {N}.  The slice specs of the tensors to be restored.
// Empty strings indicate that they are non-partitioned tensors.
//	dtypes: shape {N}.  The list of expected dtype for the tensors.  Must match
// those stored in the checkpoint.
//
// Returns shape {N}.  The restored tensors, whose shapes are read from the
// checkpoint directly.
func RestoreV2(scope *Scope, prefix tf.Output, tensor_names tf.Output, shape_and_slices tf.Output, dtypes []tf.DataType) (tensors []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtypes": dtypes}
	opspec := tf.OpSpec{
		Type: "RestoreV2",
		Input: []tf.Input{
			prefix, tensor_names, shape_and_slices,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if tensors, idx, err = makeOutputList(op, idx, "tensors"); err != nil {
		scope.UpdateErr("RestoreV2", err)
		return
	}
	return tensors
}

// RetrieveTPUEmbeddingADAMParametersAttr is an optional argument to RetrieveTPUEmbeddingADAMParameters.
type RetrieveTPUEmbeddingADAMParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingADAMParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingADAMParametersTableId(value int64) RetrieveTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingADAMParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingADAMParametersTableName(value string) RetrieveTPUEmbeddingADAMParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve ADAM embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the ADAM optimization algorithm.Parameter momenta updated by the ADAM optimization algorithm.Parameter velocities updated by the ADAM optimization algorithm.
func RetrieveTPUEmbeddingADAMParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingADAMParametersAttr) (parameters tf.Output, momenta tf.Output, velocities tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingADAMParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ResourceScatterNdUpdateAttr is an optional argument to ResourceScatterNdUpdate.
type ResourceScatterNdUpdateAttr func(optionalAttr)

// ResourceScatterNdUpdateUseLocking sets the optional use_locking attribute to value.
//
// value: An optional bool. Defaults to True. If True, the assignment will
// be protected by a lock; otherwise the behavior is undefined,
// but may exhibit less contention.
// If not specified, defaults to true
func ResourceScatterNdUpdateUseLocking(value bool) ResourceScatterNdUpdateAttr {
	return func(m optionalAttr) {
		m["use_locking"] = value
	}
}

// Applies sparse `updates` to individual values or slices within a given
//
// variable according to `indices`.
//
// `ref` is a `Tensor` with rank `P` and `indices` is a `Tensor` of rank `Q`.
//
// `indices` must be integer tensor, containing indices into `ref`.
// It must be shape `[d_0, ..., d_{Q-2}, K]` where `0 < K <= P`.
//
// The innermost dimension of `indices` (with length `K`) corresponds to
// indices into elements (if `K = P`) or slices (if `K < P`) along the `K`th
// dimension of `ref`.
//
// `updates` is `Tensor` of rank `Q-1+P-K` with shape:
//
// ```
// [d_0, ..., d_{Q-2}, ref.shape[K], ..., ref.shape[P-1]].
// ```
//
// For example, say we want to update 4 scattered elements to a rank-1 tensor to
// 8 elements. In Python, that update would look like this:
//
// ```python
//     ref = tf.Variable([1, 2, 3, 4, 5, 6, 7, 8])
//     indices = tf.constant([[4], [3], [1] ,[7]])
//     updates = tf.constant([9, 10, 11, 12])
//     update = tf.scatter_nd_update(ref, indices, updates)
//     with tf.Session() as sess:
//       print sess.run(update)
// ```
//
// The resulting update to ref would look like this:
//
//     [1, 11, 3, 10, 9, 6, 7, 12]
//
// See `tf.scatter_nd` for more details about how to make updates to
// slices.
//
// Arguments:
//	ref: A resource handle. Must be from a VarHandleOp.
//	indices: A Tensor. Must be one of the following types: int32, int64.
// A tensor of indices into ref.
//	updates: A Tensor. Must have the same type as ref. A tensor of updated
// values to add to ref.
//
// Returns the created operation.
func ResourceScatterNdUpdate(scope *Scope, ref tf.Output, indices tf.Output, updates tf.Output, optional ...ResourceScatterNdUpdateAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ResourceScatterNdUpdate",
		Input: []tf.Input{
			ref, indices, updates,
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Creates a dataset that passes a sliding window over `input_dataset`.
//
// Arguments:
//
//	window_size: A scalar representing the number of elements in the
// sliding window.
//	window_shift: A scalar representing the steps moving the sliding window
// forward in one iteration. It must be positive.
//	window_stride: A scalar representing the stride of the input elements of the sliding window.
// It must be positive.
//
//
func ExperimentalSlidingWindowDataset(scope *Scope, input_dataset tf.Output, window_size tf.Output, window_shift tf.Output, window_stride tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalSlidingWindowDataset",
		Input: []tf.Input{
			input_dataset, window_size, window_shift, window_stride,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates an Optional variant with no value.
func OptionalNone(scope *Scope) (optional tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalNone",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Draw bounding boxes on a batch of images.
//
// Outputs a copy of `images` but draws on top of the pixels zero or more bounding
// boxes specified by the locations in `boxes`. The coordinates of the each
// bounding box in `boxes` are encoded as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example, if an image is 100 x 200 pixels (height x width) and the bounding
// box is `[0.1, 0.2, 0.5, 0.9]`, the upper-left and bottom-right coordinates of
// the bounding box will be `(40, 10)` to `(100, 50)` (in (x,y) coordinates).
//
// Parts of the bounding box may fall outside the image.
//
// Arguments:
//	images: 4-D with shape `[batch, height, width, depth]`. A batch of images.
//	boxes: 3-D with shape `[batch, num_bounding_boxes, 4]` containing bounding
// boxes.
//	colors: 2-D. A list of RGBA colors to cycle through for the boxes.
//
// Returns 4-D with the same shape as `images`. The batch of input images with
// bounding boxes drawn on the images.
func DrawBoundingBoxesV2(scope *Scope, images tf.Output, boxes tf.Output, colors tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DrawBoundingBoxesV2",
		Input: []tf.Input{
			images, boxes, colors,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a tensor of ones with the same shape and type as x.
//
// Arguments:
//	x: a tensor of type T.
//
// Returns a tensor of the same shape and type as x but filled with ones.
func OnesLike(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OnesLike",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TPUReplicateMetadataAttr is an optional argument to TPUReplicateMetadata.
type TPUReplicateMetadataAttr func(optionalAttr)

// TPUReplicateMetadataNumCoresPerReplica sets the optional num_cores_per_replica attribute to value.
//
// value: Number of cores per replica. Used for model parallelism.
// If not specified, defaults to 1
func TPUReplicateMetadataNumCoresPerReplica(value int64) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["num_cores_per_replica"] = value
	}
}

// TPUReplicateMetadataTopology sets the optional topology attribute to value.
//
// value: TopologyProto indicating the topology of the TPU pod slice.
// If not specified, defaults to ""
func TPUReplicateMetadataTopology(value string) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["topology"] = value
	}
}

// TPUReplicateMetadataUseTpu sets the optional use_tpu attribute to value.
//
// value: Whether to place the computation on the TPU.
// If not specified, defaults to true
func TPUReplicateMetadataUseTpu(value bool) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["use_tpu"] = value
	}
}

// TPUReplicateMetadataDeviceAssignment sets the optional device_assignment attribute to value.
//
// value: The assignment of devices for the computation.
// If not specified, defaults to <>
func TPUReplicateMetadataDeviceAssignment(value []int64) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["device_assignment"] = value
	}
}

// TPUReplicateMetadataComputationShape sets the optional computation_shape attribute to value.
//
// value: DEPRECATED. Use num_cores_per_replica instead.
// If not specified, defaults to <>
func TPUReplicateMetadataComputationShape(value []int64) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["computation_shape"] = value
	}
}

// TPUReplicateMetadataHostComputeCore sets the optional host_compute_core attribute to value.
// If not specified, defaults to <>
func TPUReplicateMetadataHostComputeCore(value []string) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["host_compute_core"] = value
	}
}

// TPUReplicateMetadataPaddingMap sets the optional padding_map attribute to value.
// If not specified, defaults to <>
func TPUReplicateMetadataPaddingMap(value []string) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["padding_map"] = value
	}
}

// TPUReplicateMetadataStepMarkerLocation sets the optional step_marker_location attribute to value.
// If not specified, defaults to "STEP_MARK_AT_ENTRY"
func TPUReplicateMetadataStepMarkerLocation(value string) TPUReplicateMetadataAttr {
	return func(m optionalAttr) {
		m["step_marker_location"] = value
	}
}

// Metadata indicaitng how the TPU computation should be replicated.
//
// Arguments:
//	num_replicas: Number of replicas of the computation
//
// Returns the created operation.
func TPUReplicateMetadata(scope *Scope, num_replicas int64, optional ...TPUReplicateMetadataAttr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_replicas": num_replicas}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TPUReplicateMetadata",

		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Increments variable pointed to by 'resource' until it reaches 'limit'.
//
// Arguments:
//	resource: Should be from a scalar `Variable` node.
//	limit: If incrementing ref would bring it above limit, instead generates an
// 'OutOfRange' error.
//
//
// Returns A copy of the input before increment. If nothing else modifies the
// input, the values produced will all be distinct.
func ResourceCountUpTo(scope *Scope, resource tf.Output, limit int64, T tf.DataType) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"limit": limit, "T": T}
	opspec := tf.OpSpec{
		Type: "ResourceCountUpTo",
		Input: []tf.Input{
			resource,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FusedResizeAndPadConv2DAttr is an optional argument to FusedResizeAndPadConv2D.
type FusedResizeAndPadConv2DAttr func(optionalAttr)

// FusedResizeAndPadConv2DResizeAlignCorners sets the optional resize_align_corners attribute to value.
//
// value: If true, the centers of the 4 corner pixels of the input and output tensors are
// aligned, preserving the values at the corner pixels. Defaults to false.
// If not specified, defaults to false
func FusedResizeAndPadConv2DResizeAlignCorners(value bool) FusedResizeAndPadConv2DAttr {
	return func(m optionalAttr) {
		m["resize_align_corners"] = value
	}
}

// Performs a resize and padding as a preprocess during a convolution.
//
// It's often possible to do spatial transformations more efficiently as part of
// the packing stage of a convolution, so this op allows for an optimized
// implementation where these stages are fused together. This prevents the need to
// write out the intermediate results as whole tensors, reducing memory pressure,
// and we can get some latency gains by merging the transformation calculations.
// The data_format attribute for Conv2D isn't supported by this op, and defaults to
// 'NHWC' order.
// Internally this op uses a single per-graph scratch buffer, which means that it
// will block if multiple versions are being run in parallel. This is because this
// operator is primarily an optimization to minimize memory usage.
//
// Arguments:
//	input: 4-D with shape `[batch, in_height, in_width, in_channels]`.
//	size: A 1-D int32 Tensor of 2 elements: `new_height, new_width`.  The
// new size for the images.
//	paddings: A two-column matrix specifying the padding sizes. The number of
// rows must be the same as the rank of `input`.
//	filter: 4-D with shape
// `[filter_height, filter_width, in_channels, out_channels]`.
//
//	strides: 1-D of length 4.  The stride of the sliding window for each dimension
// of `input`. Must be in the same order as the dimension specified with format.
//	padding: The type of padding algorithm to use.
func FusedResizeAndPadConv2D(scope *Scope, input tf.Output, size tf.Output, paddings tf.Output, filter tf.Output, mode string, strides []int64, padding string, optional ...FusedResizeAndPadConv2DAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"mode": mode, "strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FusedResizeAndPadConv2D",
		Input: []tf.Input{
			input, size, paddings, filter,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns a diagonal tensor with a given diagonal values.
//
// Given a `diagonal`, this operation returns a tensor with the `diagonal` and
// everything else padded with zeros. The diagonal is computed as follows:
//
// Assume `diagonal` has dimensions [D1,..., Dk], then the output is a tensor of
// rank 2k with dimensions [D1,..., Dk, D1,..., Dk] where:
//
// `output[i1,..., ik, i1,..., ik] = diagonal[i1, ..., ik]` and 0 everywhere else.
//
// For example:
//
// ```
// # 'diagonal' is [1, 2, 3, 4]
// tf.diag(diagonal) ==> [[1, 0, 0, 0]
//                        [0, 2, 0, 0]
//                        [0, 0, 3, 0]
//                        [0, 0, 0, 4]]
// ```
//
// Arguments:
//	diagonal: Rank k tensor where k is at most 1.
func Diag(scope *Scope, diagonal tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Diag",
		Input: []tf.Input{
			diagonal,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Decodes a `variant` Tensor into a `RaggedTensor`.
//
// Decodes the given `variant` Tensor and returns a `RaggedTensor`. The input
// could be a scalar, meaning it encodes a single `RaggedTensor` with ragged_rank
// `output_ragged_rank`. It could also have an arbitrary rank, in which case each
// element is decoded into a `RaggedTensor` with ragged_rank `input_ragged_rank`
// and these are then stacked according to the input shape to output a single
// `RaggedTensor` with ragged_rank `output_ragged_rank`. Each `variant` element in
// the input Tensor is decoded by retrieving from the element a 1-D `variant`
// Tensor with `input_ragged_rank + 1` Tensors, corresponding to the splits and
// values of the decoded `RaggedTensor`. If `input_ragged_rank` is -1, then it is
// inferred as `output_ragged_rank` - `rank(encoded_ragged)`. See
// `RaggedTensorToVariant` for the corresponding encoding logic.
//
//
// Arguments:
//	encoded_ragged: A `variant` Tensor containing encoded `RaggedTensor`s.
//	input_ragged_rank: The ragged rank of each encoded `RaggedTensor` component in the input. If set to
// -1, this is inferred as `output_ragged_rank` - `rank(encoded_ragged)`
//	output_ragged_rank: The expected ragged rank of the output `RaggedTensor`. The following must hold:
// `output_ragged_rank = rank(encoded_ragged) + input_ragged_rank`.
//
//
//
// Returns A list of one or more Tensors representing the splits of the output
// `RaggedTensor`.A Tensor representing the values of the output `RaggedTensor`.
func RaggedTensorFromVariant(scope *Scope, encoded_ragged tf.Output, input_ragged_rank int64, output_ragged_rank int64, Tvalues tf.DataType, Tsplits tf.DataType) (output_nested_splits []tf.Output, output_dense_values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"input_ragged_rank": input_ragged_rank, "output_ragged_rank": output_ragged_rank, "Tvalues": Tvalues, "Tsplits": Tsplits}
	opspec := tf.OpSpec{
		Type: "RaggedTensorFromVariant",
		Input: []tf.Input{
			encoded_ragged,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if output_nested_splits, idx, err = makeOutputList(op, idx, "output_nested_splits"); err != nil {
		scope.UpdateErr("RaggedTensorFromVariant", err)
		return
	}
	output_dense_values = op.Output(idx)
	return output_nested_splits, output_dense_values
}

// 2D fast Fourier transform.
//
// Computes the 2-dimensional discrete Fourier transform over the inner-most
// 2 dimensions of `input`.
//
// Arguments:
//	input: A complex tensor.
//
// Returns A complex tensor of the same shape as `input`. The inner-most 2
//   dimensions of `input` are replaced with their 2D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fft2
// @end_compatibility
func FFT2D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT2D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// 3D fast Fourier transform.
//
// Computes the 3-dimensional discrete Fourier transform over the inner-most 3
// dimensions of `input`.
//
// Arguments:
//	input: A complex64 tensor.
//
// Returns A complex64 tensor of the same shape as `input`. The inner-most 3
//   dimensions of `input` are replaced with their 3D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.fftn with 3 dimensions.
// @end_compatibility
func FFT3D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FFT3D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes softmax cross entropy cost and gradients to backpropagate.
//
// Inputs are the logits, not probabilities.
//
// Arguments:
//	features: batch_size x num_classes matrix
//	labels: batch_size x num_classes matrix
// The caller must ensure that each batch of labels represents a valid
// probability distribution.
//
// Returns Per example loss (batch_size vector).backpropagated gradients (batch_size x num_classes matrix).
func SoftmaxCrossEntropyWithLogits(scope *Scope, features tf.Output, labels tf.Output) (loss tf.Output, backprop tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SoftmaxCrossEntropyWithLogits",
		Input: []tf.Input{
			features, labels,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Checks whether a resource handle-based variable has been initialized.
//
// Arguments:
//	resource: the input resource handle.
//
// Returns a scalar boolean which is true if the variable has been
// initialized.
func VarIsInitializedOp(scope *Scope, resource tf.Output) (is_initialized tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "VarIsInitializedOp",
		Input: []tf.Input{
			resource,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedMulAttr is an optional argument to QuantizedMul.
type QuantizedMulAttr func(optionalAttr)

// QuantizedMulToutput sets the optional Toutput attribute to value.
// If not specified, defaults to DT_QINT32
func QuantizedMulToutput(value tf.DataType) QuantizedMulAttr {
	return func(m optionalAttr) {
		m["Toutput"] = value
	}
}

// Returns x * y element-wise, working on quantized buffers.
//
// Arguments:
//
//
//	min_x: The float value that the lowest quantized `x` value represents.
//	max_x: The float value that the highest quantized `x` value represents.
//	min_y: The float value that the lowest quantized `y` value represents.
//	max_y: The float value that the highest quantized `y` value represents.
//
// Returns The float value that the lowest quantized output value represents.The float value that the highest quantized output value represents.
//
// *NOTE*: `QuantizedMul` supports limited forms of broadcasting. More about
// broadcasting [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func QuantizedMul(scope *Scope, x tf.Output, y tf.Output, min_x tf.Output, max_x tf.Output, min_y tf.Output, max_y tf.Output, optional ...QuantizedMulAttr) (z tf.Output, min_z tf.Output, max_z tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedMul",
		Input: []tf.Input{
			x, y, min_x, max_x, min_y, max_y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// ParseSingleSequenceExampleAttr is an optional argument to ParseSingleSequenceExample.
type ParseSingleSequenceExampleAttr func(optionalAttr)

// ParseSingleSequenceExampleContextSparseTypes sets the optional context_sparse_types attribute to value.
//
// value: A list of Ncontext_sparse types; the data types of data in
// each context Feature given in context_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleContextSparseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_sparse_types"] = value
	}
}

// ParseSingleSequenceExampleFeatureListDenseTypes sets the optional feature_list_dense_types attribute to value.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListDenseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_types"] = value
	}
}

// ParseSingleSequenceExampleContextDenseShapes sets the optional context_dense_shapes attribute to value.
//
// value: A list of Ncontext_dense shapes; the shapes of data in
// each context Feature given in context_dense_keys.
// The number of elements in the Feature corresponding to context_dense_key[j]
// must always equal context_dense_shapes[j].NumEntries().
// The shape of context_dense_values[j] will match context_dense_shapes[j].
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleContextDenseShapes(value []tf.Shape) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["context_dense_shapes"] = value
	}
}

// ParseSingleSequenceExampleFeatureListSparseTypes sets the optional feature_list_sparse_types attribute to value.
//
// value: A list of Nfeature_list_sparse types; the data types
// of data in each FeatureList given in feature_list_sparse_keys.
// Currently the ParseSingleSequenceExample supports DT_FLOAT (FloatList),
// DT_INT64 (Int64List), and DT_STRING (BytesList).
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListSparseTypes(value []tf.DataType) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_sparse_types"] = value
	}
}

// ParseSingleSequenceExampleFeatureListDenseShapes sets the optional feature_list_dense_shapes attribute to value.
//
// value: A list of Nfeature_list_dense shapes; the shapes of
// data in each FeatureList given in feature_list_dense_keys.
// The shape of each Feature in the FeatureList corresponding to
// feature_list_dense_key[j] must always equal
// feature_list_dense_shapes[j].NumEntries().
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func ParseSingleSequenceExampleFeatureListDenseShapes(value []tf.Shape) ParseSingleSequenceExampleAttr {
	return func(m optionalAttr) {
		m["feature_list_dense_shapes"] = value
	}
}

// Transforms a scalar brain.SequenceExample proto (as strings) into typed tensors.
//
// Arguments:
//	serialized: A scalar containing a binary serialized SequenceExample proto.
//	feature_list_dense_missing_assumed_empty: A vector listing the
// FeatureList keys which may be missing from the SequenceExample.  If the
// associated FeatureList is missing, it is treated as empty.  By default,
// any FeatureList not listed in this vector must exist in the SequenceExample.
//	context_sparse_keys: A list of Ncontext_sparse string Tensors (scalars).
// The keys expected in the Examples' features associated with context_sparse
// values.
//	context_dense_keys: A list of Ncontext_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' context features associated with
// dense values.
//	feature_list_sparse_keys: A list of Nfeature_list_sparse string Tensors
// (scalars).  The keys expected in the FeatureLists associated with sparse
// values.
//	feature_list_dense_keys: A list of Nfeature_list_dense string Tensors (scalars).
// The keys expected in the SequenceExamples' feature_lists associated
// with lists of dense values.
//	context_dense_defaults: A list of Ncontext_dense Tensors (some may be empty).
// context_dense_defaults[j] provides default values
// when the SequenceExample's context map lacks context_dense_key[j].
// If an empty Tensor is provided for context_dense_defaults[j],
// then the Feature context_dense_keys[j] is required.
// The input type is inferred from context_dense_defaults[j], even when it's
// empty.  If context_dense_defaults[j] is not empty, its shape must match
// context_dense_shapes[j].
//	debug_name: A scalar containing the name of the serialized proto.
// May contain, for example, table key (descriptive) name for the
// corresponding serialized proto.  This is purely useful for debugging
// purposes, and the presence of values here has no effect on the output.
// May also be an empty scalar if no name is available.
func ParseSingleSequenceExample(scope *Scope, serialized tf.Output, feature_list_dense_missing_assumed_empty tf.Output, context_sparse_keys []tf.Output, context_dense_keys []tf.Output, feature_list_sparse_keys []tf.Output, feature_list_dense_keys []tf.Output, context_dense_defaults []tf.Output, debug_name tf.Output, optional ...ParseSingleSequenceExampleAttr) (context_sparse_indices []tf.Output, context_sparse_values []tf.Output, context_sparse_shapes []tf.Output, context_dense_values []tf.Output, feature_list_sparse_indices []tf.Output, feature_list_sparse_values []tf.Output, feature_list_sparse_shapes []tf.Output, feature_list_dense_values []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ParseSingleSequenceExample",
		Input: []tf.Input{
			serialized, feature_list_dense_missing_assumed_empty, tf.OutputList(context_sparse_keys), tf.OutputList(context_dense_keys), tf.OutputList(feature_list_sparse_keys), tf.OutputList(feature_list_dense_keys), tf.OutputList(context_dense_defaults), debug_name,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if context_sparse_indices, idx, err = makeOutputList(op, idx, "context_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_sparse_values, idx, err = makeOutputList(op, idx, "context_sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_sparse_shapes, idx, err = makeOutputList(op, idx, "context_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if context_dense_values, idx, err = makeOutputList(op, idx, "context_dense_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_indices, idx, err = makeOutputList(op, idx, "feature_list_sparse_indices"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_values, idx, err = makeOutputList(op, idx, "feature_list_sparse_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_sparse_shapes, idx, err = makeOutputList(op, idx, "feature_list_sparse_shapes"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	if feature_list_dense_values, idx, err = makeOutputList(op, idx, "feature_list_dense_values"); err != nil {
		scope.UpdateErr("ParseSingleSequenceExample", err)
		return
	}
	return context_sparse_indices, context_sparse_values, context_sparse_shapes, context_dense_values, feature_list_sparse_indices, feature_list_sparse_values, feature_list_sparse_shapes, feature_list_dense_values
}

// Outputs all keys and values in the table.
//
// Arguments:
//	table_handle: Handle to the table.
//
//
//
// Returns Vector of all keys present in the table.Tensor of all values in the table. Indexed in parallel with `keys`.
func LookupTableExportV2(scope *Scope, table_handle tf.Output, Tkeys tf.DataType, Tvalues tf.DataType) (keys tf.Output, values tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"Tkeys": Tkeys, "Tvalues": Tvalues}
	opspec := tf.OpSpec{
		Type: "LookupTableExportV2",
		Input: []tf.Input{
			table_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// CompilationResultProto indicating the status of the TPU compilation.
func TPUCompilationResult(scope *Scope) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TPUCompilationResult",
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Performs gradient updates of embedding tables.
//
// Arguments:
//	inputs: A TensorList of gradients with which to update embedding tables.
// This argument has the same length and shapes as the return value of
// RecvTPUEmbeddingActivations, but contains gradients of the model's loss
// with respect to the embedding activations. The embedding tables are updated
// from these gradients via the optimizer specified in the TPU embedding
// configuration given to tpu.initialize_system.
//	learning_rates: A TensorList of float32 scalars, one for each dynamic learning
// rate tag: see the comments in
// //third_party/tensorflow/core/protobuf/tpu/optimization_parameters.proto.
// Multiple tables can share the same dynamic learning rate tag as specified
// in the configuration. If the learning rates for all tables are constant,
// this list should be empty.
//	config: Serialized TPUEmbeddingConfiguration proto.
//
// Returns the created operation.
func SendTPUEmbeddingGradients(scope *Scope, inputs []tf.Output, learning_rates []tf.Output, config string) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"config": config}
	opspec := tf.OpSpec{
		Type: "SendTPUEmbeddingGradients",
		Input: []tf.Input{
			tf.OutputList(inputs), tf.OutputList(learning_rates),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// SampleDistortedBoundingBoxV2Attr is an optional argument to SampleDistortedBoundingBoxV2.
type SampleDistortedBoundingBoxV2Attr func(optionalAttr)

// SampleDistortedBoundingBoxV2Seed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to non-zero, the random number
// generator is seeded by the given `seed`.  Otherwise, it is seeded by a random
// seed.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxV2Seed(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// SampleDistortedBoundingBoxV2Seed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func SampleDistortedBoundingBoxV2Seed2(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// SampleDistortedBoundingBoxV2AspectRatioRange sets the optional aspect_ratio_range attribute to value.
//
// value: The cropped area of the image must have an aspect ratio =
// width / height within this range.
// If not specified, defaults to <f:0.75 f:1.33 >
func SampleDistortedBoundingBoxV2AspectRatioRange(value []float32) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["aspect_ratio_range"] = value
	}
}

// SampleDistortedBoundingBoxV2AreaRange sets the optional area_range attribute to value.
//
// value: The cropped area of the image must contain a fraction of the
// supplied image within this range.
// If not specified, defaults to <f:0.05 f:1 >
func SampleDistortedBoundingBoxV2AreaRange(value []float32) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["area_range"] = value
	}
}

// SampleDistortedBoundingBoxV2MaxAttempts sets the optional max_attempts attribute to value.
//
// value: Number of attempts at generating a cropped region of the image
// of the specified constraints. After `max_attempts` failures, return the entire
// image.
// If not specified, defaults to 100
func SampleDistortedBoundingBoxV2MaxAttempts(value int64) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["max_attempts"] = value
	}
}

// SampleDistortedBoundingBoxV2UseImageIfNoBoundingBoxes sets the optional use_image_if_no_bounding_boxes attribute to value.
//
// value: Controls behavior if no bounding boxes supplied.
// If true, assume an implicit bounding box covering the whole input. If false,
// raise an error.
// If not specified, defaults to false
func SampleDistortedBoundingBoxV2UseImageIfNoBoundingBoxes(value bool) SampleDistortedBoundingBoxV2Attr {
	return func(m optionalAttr) {
		m["use_image_if_no_bounding_boxes"] = value
	}
}

// Generate a single randomly distorted bounding box for an image.
//
// Bounding box annotations are often supplied in addition to ground-truth labels
// in image recognition or object localization tasks. A common technique for
// training such a system is to randomly distort an image while preserving
// its content, i.e. *data augmentation*. This Op outputs a randomly distorted
// localization of an object, i.e. bounding box, given an `image_size`,
// `bounding_boxes` and a series of constraints.
//
// The output of this Op is a single bounding box that may be used to crop the
// original image. The output is returned as 3 tensors: `begin`, `size` and
// `bboxes`. The first 2 tensors can be fed directly into `tf.slice` to crop the
// image. The latter may be supplied to `tf.image.draw_bounding_boxes` to visualize
// what the bounding box looks like.
//
// Bounding boxes are supplied and returned as `[y_min, x_min, y_max, x_max]`. The
// bounding box coordinates are floats in `[0.0, 1.0]` relative to the width and
// height of the underlying image.
//
// For example,
//
// ```python
//     # Generate a single distorted bounding box.
//     begin, size, bbox_for_draw = tf.image.sample_distorted_bounding_box(
//         tf.shape(image),
//         bounding_boxes=bounding_boxes)
//
//     # Draw the bounding box in an image summary.
//     image_with_box = tf.image.draw_bounding_boxes(tf.expand_dims(image, 0),
//                                                   bbox_for_draw)
//     tf.summary.image('images_with_box', image_with_box)
//
//     # Employ the bounding box to distort the image.
//     distorted_image = tf.slice(image, begin, size)
// ```
//
// Note that if no bounding box information is available, setting
// `use_image_if_no_bounding_boxes = true` will assume there is a single implicit
// bounding box covering the whole image. If `use_image_if_no_bounding_boxes` is
// false and no bounding boxes are supplied, an error is raised.
//
// Arguments:
//	image_size: 1-D, containing `[height, width, channels]`.
//	bounding_boxes: 3-D with shape `[batch, N, 4]` describing the N bounding boxes
// associated with the image.
//	min_object_covered: The cropped area of the image must contain at least this
// fraction of any bounding box supplied. The value of this parameter should be
// non-negative. In the case of 0, the cropped area does not need to overlap
// any of the bounding boxes supplied.
//
// Returns 1-D, containing `[offset_height, offset_width, 0]`. Provide as input to
// `tf.slice`.1-D, containing `[target_height, target_width, -1]`. Provide as input to
// `tf.slice`.3-D with shape `[1, 1, 4]` containing the distorted bounding box.
// Provide as input to `tf.image.draw_bounding_boxes`.
func SampleDistortedBoundingBoxV2(scope *Scope, image_size tf.Output, bounding_boxes tf.Output, min_object_covered tf.Output, optional ...SampleDistortedBoundingBoxV2Attr) (begin tf.Output, size tf.Output, bboxes tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SampleDistortedBoundingBoxV2",
		Input: []tf.Input{
			image_size, bounding_boxes, min_object_covered,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Decode web-safe base64-encoded strings.
//
// Input may or may not have padding at the end. See EncodeBase64 for padding.
// Web-safe means that input must use - and _ instead of + and /.
//
// Arguments:
//	input: Base64 strings to decode.
//
// Returns Decoded strings.
func DecodeBase64(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DecodeBase64",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// FakeQuantWithMinMaxArgsGradientAttr is an optional argument to FakeQuantWithMinMaxArgsGradient.
type FakeQuantWithMinMaxArgsGradientAttr func(optionalAttr)

// FakeQuantWithMinMaxArgsGradientMin sets the optional min attribute to value.
// If not specified, defaults to -6
func FakeQuantWithMinMaxArgsGradientMin(value float32) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["min"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientMax sets the optional max attribute to value.
// If not specified, defaults to 6
func FakeQuantWithMinMaxArgsGradientMax(value float32) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["max"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientNumBits sets the optional num_bits attribute to value.
// If not specified, defaults to 8
func FakeQuantWithMinMaxArgsGradientNumBits(value int64) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["num_bits"] = value
	}
}

// FakeQuantWithMinMaxArgsGradientNarrowRange sets the optional narrow_range attribute to value.
// If not specified, defaults to false
func FakeQuantWithMinMaxArgsGradientNarrowRange(value bool) FakeQuantWithMinMaxArgsGradientAttr {
	return func(m optionalAttr) {
		m["narrow_range"] = value
	}
}

// Compute gradients for a FakeQuantWithMinMaxArgs operation.
//
// Arguments:
//	gradients: Backpropagated gradients above the FakeQuantWithMinMaxArgs operation.
//	inputs: Values passed as inputs to the FakeQuantWithMinMaxArgs operation.
//
// Returns Backpropagated gradients below the FakeQuantWithMinMaxArgs operation:
// `gradients * (inputs >= min && inputs <= max)`.
func FakeQuantWithMinMaxArgsGradient(scope *Scope, gradients tf.Output, inputs tf.Output, optional ...FakeQuantWithMinMaxArgsGradientAttr) (backprops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "FakeQuantWithMinMaxArgsGradient",
		Input: []tf.Input{
			gradients, inputs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns true if and only if the given Optional variant has a value.
func OptionalHasValue(scope *Scope, optional tf.Output) (has_value tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "OptionalHasValue",
		Input: []tf.Input{
			optional,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 3D fast Fourier transform.
//
// Computes the inverse 3-dimensional discrete Fourier transform over the
// inner-most 3 dimensions of `input`.
//
// Arguments:
//	input: A complex64 tensor.
//
// Returns A complex64 tensor of the same shape as `input`. The inner-most 3
//   dimensions of `input` are replaced with their inverse 3D Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.fft.ifftn with 3 dimensions.
// @end_compatibility
func IFFT3D(scope *Scope, input tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IFFT3D",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// CropAndResizeAttr is an optional argument to CropAndResize.
type CropAndResizeAttr func(optionalAttr)

// CropAndResizeMethod sets the optional method attribute to value.
//
// value: A string specifying the sampling method for resizing. It can be either
// `"bilinear"` or `"nearest"` and default to `"bilinear"`. Currently two sampling
// methods are supported: Bilinear and Nearest Neighbor.
// If not specified, defaults to "bilinear"
func CropAndResizeMethod(value string) CropAndResizeAttr {
	return func(m optionalAttr) {
		m["method"] = value
	}
}

// CropAndResizeExtrapolationValue sets the optional extrapolation_value attribute to value.
//
// value: Value used for extrapolation, when applicable.
// If not specified, defaults to 0
func CropAndResizeExtrapolationValue(value float32) CropAndResizeAttr {
	return func(m optionalAttr) {
		m["extrapolation_value"] = value
	}
}

// Extracts crops from the input image tensor and resizes them.
//
// Extracts crops from the input image tensor and resizes them using bilinear
// sampling or nearest neighbor sampling (possibly with aspect ratio change) to a
// common output size specified by `crop_size`. This is more general than the
// `crop_to_bounding_box` op which extracts a fixed size slice from the input image
// and does not allow resizing or aspect ratio change.
//
// Returns a tensor with `crops` from the input `image` at positions defined at the
// bounding box locations in `boxes`. The cropped boxes are all resized (with
// bilinear or nearest neighbor interpolation) to a fixed
// `size = [crop_height, crop_width]`. The result is a 4-D tensor
// `[num_boxes, crop_height, crop_width, depth]`. The resizing is corner aligned.
// In particular, if `boxes = [[0, 0, 1, 1]]`, the method will give identical
// results to using `tf.image.resize_bilinear()` or
// `tf.image.resize_nearest_neighbor()`(depends on the `method` argument) with
// `align_corners=True`.
//
// Arguments:
//	image: A 4-D tensor of shape `[batch, image_height, image_width, depth]`.
// Both `image_height` and `image_width` need to be positive.
//	boxes: A 2-D tensor of shape `[num_boxes, 4]`. The `i`-th row of the tensor
// specifies the coordinates of a box in the `box_ind[i]` image and is specified
// in normalized coordinates `[y1, x1, y2, x2]`. A normalized coordinate value of
// `y` is mapped to the image coordinate at `y * (image_height - 1)`, so as the
// `[0, 1]` interval of normalized image height is mapped to
// `[0, image_height - 1]` in image height coordinates. We do allow `y1` > `y2`, in
// which case the sampled crop is an up-down flipped version of the original
// image. The width dimension is treated similarly. Normalized coordinates
// outside the `[0, 1]` range are allowed, in which case we use
// `extrapolation_value` to extrapolate the input image values.
//	box_ind: A 1-D tensor of shape `[num_boxes]` with int32 values in `[0, batch)`.
// The value of `box_ind[i]` specifies the image that the `i`-th box refers to.
//	crop_size: A 1-D tensor of 2 elements, `size = [crop_height, crop_width]`. All
// cropped image patches are resized to this size. The aspect ratio of the image
// content is not preserved. Both `crop_height` and `crop_width` need to be
// positive.
//
// Returns A 4-D tensor of shape `[num_boxes, crop_height, crop_width, depth]`.
func CropAndResize(scope *Scope, image tf.Output, boxes tf.Output, box_ind tf.Output, crop_size tf.Output, optional ...CropAndResizeAttr) (crops tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "CropAndResize",
		Input: []tf.Input{
			image, boxes, box_ind, crop_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns which elements of x are finite.
//
// @compatibility(numpy)
// Equivalent to np.isfinite
// @end_compatibility
func IsFinite(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IsFinite",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessRandomNormalAttr is an optional argument to StatelessRandomNormal.
type StatelessRandomNormalAttr func(optionalAttr)

// StatelessRandomNormalDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessRandomNormalDtype(value tf.DataType) StatelessRandomNormalAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom values from a normal distribution.
//
// The generated values will have mean 0 and standard deviation 1.
//
// The outputs are a deterministic function of `shape` and `seed`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//
// Returns Random values with specified shape.
func StatelessRandomNormal(scope *Scope, shape tf.Output, seed tf.Output, optional ...StatelessRandomNormalAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomNormal",
		Input: []tf.Input{
			shape, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// DenseToDenseSetOperationAttr is an optional argument to DenseToDenseSetOperation.
type DenseToDenseSetOperationAttr func(optionalAttr)

// DenseToDenseSetOperationValidateIndices sets the optional validate_indices attribute to value.
// If not specified, defaults to true
func DenseToDenseSetOperationValidateIndices(value bool) DenseToDenseSetOperationAttr {
	return func(m optionalAttr) {
		m["validate_indices"] = value
	}
}

// Applies set operation along last dimension of 2 `Tensor` inputs.
//
// See SetOperationOp::SetOperationFromContext for values of `set_operation`.
//
// Output `result` is a `SparseTensor` represented by `result_indices`,
// `result_values`, and `result_shape`. For `set1` and `set2` ranked `n`, this
// has rank `n` and the same 1st `n-1` dimensions as `set1` and `set2`. The `nth`
// dimension contains the result of `set_operation` applied to the corresponding
// `[0...n-1]` dimension of `set`.
//
// Arguments:
//	set1: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set2`.
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//	set2: `Tensor` with rank `n`. 1st `n-1` dimensions must be the same as `set1`.
// Dimension `n` contains values in a set, duplicates are allowed but ignored.
//
//
// Returns 2D indices of a `SparseTensor`.1D values of a `SparseTensor`.1D `Tensor` shape of a `SparseTensor`. `result_shape[0...n-1]` is
// the same as the 1st `n-1` dimensions of `set1` and `set2`, `result_shape[n]`
// is the max result set size across all `0...n-1` dimensions.
func DenseToDenseSetOperation(scope *Scope, set1 tf.Output, set2 tf.Output, set_operation string, optional ...DenseToDenseSetOperationAttr) (result_indices tf.Output, result_values tf.Output, result_shape tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"set_operation": set_operation}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "DenseToDenseSetOperation",
		Input: []tf.Input{
			set1, set2,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// 3D real-valued fast Fourier transform.
//
// Computes the 3-dimensional discrete Fourier transform of a real-valued signal
// over the inner-most 3 dimensions of `input`.
//
// Since the DFT of a real signal is Hermitian-symmetric, `RFFT3D` only returns the
// `fft_length / 2 + 1` unique components of the FFT for the inner-most dimension
// of `output`: the zero-frequency term, followed by the `fft_length / 2`
// positive-frequency terms.
//
// Along each axis `RFFT3D` is computed on, if `fft_length` is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A float32 tensor.
//	fft_length: An int32 tensor of shape [3]. The FFT length for each dimension.
//
// Returns A complex64 tensor of the same rank as `input`. The inner-most 3
//   dimensions of `input` are replaced with the their 3D Fourier transform. The
//   inner-most dimension contains `fft_length / 2 + 1` unique frequency
//   components.
//
// @compatibility(numpy)
// Equivalent to np.fft.rfftn with 3 dimensions.
// @end_compatibility
func RFFT3D(scope *Scope, input tf.Output, fft_length tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "RFFT3D",
		Input: []tf.Input{
			input, fft_length,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Inverse 3D real-valued fast Fourier transform.
//
// Computes the inverse 3-dimensional discrete Fourier transform of a real-valued
// signal over the inner-most 3 dimensions of `input`.
//
// The inner-most 3 dimensions of `input` are assumed to be the result of `RFFT3D`:
// The inner-most dimension contains the `fft_length / 2 + 1` unique components of
// the DFT of a real-valued signal. If `fft_length` is not provided, it is computed
// from the size of the inner-most 3 dimensions of `input`. If the FFT length used
// to compute `input` is odd, it should be provided since it cannot be inferred
// properly.
//
// Along each axis `IRFFT3D` is computed on, if `fft_length` (or
// `fft_length / 2 + 1` for the inner-most dimension) is smaller than the
// corresponding dimension of `input`, the dimension is cropped. If it is larger,
// the dimension is padded with zeros.
//
// Arguments:
//	input: A complex64 tensor.
//	fft_length: An int32 tensor of shape [3]. The FFT length for each dimension.
//
// Returns A float32 tensor of the same rank as `input`. The inner-most 3
//   dimensions of `input` are replaced with the `fft_length` samples of their
//   inverse 3D real Fourier transform.
//
// @compatibility(numpy)
// Equivalent to np.irfftn with 3 dimensions.
// @end_compatibility
func IRFFT3D(scope *Scope, input tf.Output, fft_length tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "IRFFT3D",
		Input: []tf.Input{
			input, fft_length,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Deprecated. Use TensorArrayGradV3
//
// DEPRECATED at GraphDef version 26: Use TensorArrayWriteV3
func TensorArrayWriteV2(scope *Scope, handle tf.Output, index tf.Output, value tf.Output, flow_in tf.Output) (flow_out tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "TensorArrayWriteV2",
		Input: []tf.Input{
			handle, index, value, flow_in,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RetrieveTPUEmbeddingRMSPropParametersAttr is an optional argument to RetrieveTPUEmbeddingRMSPropParameters.
type RetrieveTPUEmbeddingRMSPropParametersAttr func(optionalAttr)

// RetrieveTPUEmbeddingRMSPropParametersTableId sets the optional table_id attribute to value.
// If not specified, defaults to -1
//
// REQUIRES: value >= -1
func RetrieveTPUEmbeddingRMSPropParametersTableId(value int64) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_id"] = value
	}
}

// RetrieveTPUEmbeddingRMSPropParametersTableName sets the optional table_name attribute to value.
// If not specified, defaults to ""
func RetrieveTPUEmbeddingRMSPropParametersTableName(value string) RetrieveTPUEmbeddingRMSPropParametersAttr {
	return func(m optionalAttr) {
		m["table_name"] = value
	}
}

// Retrieve RMSProp embedding parameters.
//
// An op that retrieves optimization parameters from embedding to host
// memory. Must be preceded by a ConfigureTPUEmbeddingHost op that sets up
// the correct embedding table configuration. For example, this op is
// used to retrieve updated parameters before saving a checkpoint.
//
// Returns Parameter parameters updated by the RMSProp optimization algorithm.Parameter ms updated by the RMSProp optimization algorithm.Parameter mom updated by the RMSProp optimization algorithm.
func RetrieveTPUEmbeddingRMSPropParameters(scope *Scope, num_shards int64, shard_id int64, optional ...RetrieveTPUEmbeddingRMSPropParametersAttr) (parameters tf.Output, ms tf.Output, mom tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_shards": num_shards, "shard_id": shard_id}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RetrieveTPUEmbeddingRMSPropParameters",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// SdcaOptimizerAttr is an optional argument to SdcaOptimizer.
type SdcaOptimizerAttr func(optionalAttr)

// SdcaOptimizerAdaptative sets the optional adaptative attribute to value.
//
// value: Whether to use Adaptive SDCA for the inner loop.
// If not specified, defaults to true
func SdcaOptimizerAdaptative(value bool) SdcaOptimizerAttr {
	return func(m optionalAttr) {
		m["adaptative"] = value
	}
}

// Distributed version of Stochastic Dual Coordinate Ascent (SDCA) optimizer for
//
// linear models with L1 + L2 regularization. As global optimization objective is
// strongly-convex, the optimizer optimizes the dual objective at each step. The
// optimizer applies each update one example at a time. Examples are sampled
// uniformly, and the optimizer is learning rate free and enjoys linear convergence
// rate.
//
// [Proximal Stochastic Dual Coordinate Ascent](http://arxiv.org/pdf/1211.2717v1.pdf).<br>
// Shai Shalev-Shwartz, Tong Zhang. 2012
//
// $$Loss Objective = \sum f_{i} (wx_{i}) + (l2 / 2) * |w|^2 + l1 * |w|$$
//
// [Adding vs. Averaging in Distributed Primal-Dual Optimization](http://arxiv.org/abs/1502.03508).<br>
// Chenxin Ma, Virginia Smith, Martin Jaggi, Michael I. Jordan,
// Peter Richtarik, Martin Takac. 2015
//
// [Stochastic Dual Coordinate Ascent with Adaptive Probabilities](https://arxiv.org/abs/1502.08053).<br>
// Dominik Csiba, Zheng Qu, Peter Richtarik. 2015
//
// Arguments:
//	sparse_example_indices: a list of vectors which contain example indices.
//	sparse_feature_indices: a list of vectors which contain feature indices.
//	sparse_feature_values: a list of vectors which contains feature value
// associated with each feature group.
//	dense_features: a list of matrices which contains the dense feature values.
//	example_weights: a vector which contains the weight associated with each
// example.
//	example_labels: a vector which contains the label/target associated with each
// example.
//	sparse_indices: a list of vectors where each value is the indices which has
// corresponding weights in sparse_weights. This field maybe omitted for the
// dense approach.
//	sparse_weights: a list of vectors where each value is the weight associated with
// a sparse feature group.
//	dense_weights: a list of vectors where the values are the weights associated
// with a dense feature group.
//	example_state_data: a list of vectors containing the example state data.
//	loss_type: Type of the primal loss. Currently SdcaSolver supports logistic,
// squared and hinge losses.
//	l1: Symmetric l1 regularization strength.
//	l2: Symmetric l2 regularization strength.
//	num_loss_partitions: Number of partitions of the global loss function.
//	num_inner_iterations: Number of iterations per mini-batch.
//
// Returns a list of vectors containing the updated example state
// data.a list of vectors where each value is the delta
// weights associated with a sparse feature group.a list of vectors where the values are the delta
// weights associated with a dense feature group.
func SdcaOptimizer(scope *Scope, sparse_example_indices []tf.Output, sparse_feature_indices []tf.Output, sparse_feature_values []tf.Output, dense_features []tf.Output, example_weights tf.Output, example_labels tf.Output, sparse_indices []tf.Output, sparse_weights []tf.Output, dense_weights []tf.Output, example_state_data tf.Output, loss_type string, l1 float32, l2 float32, num_loss_partitions int64, num_inner_iterations int64, optional ...SdcaOptimizerAttr) (out_example_state_data tf.Output, out_delta_sparse_weights []tf.Output, out_delta_dense_weights []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"loss_type": loss_type, "l1": l1, "l2": l2, "num_loss_partitions": num_loss_partitions, "num_inner_iterations": num_inner_iterations}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "SdcaOptimizer",
		Input: []tf.Input{
			tf.OutputList(sparse_example_indices), tf.OutputList(sparse_feature_indices), tf.OutputList(sparse_feature_values), tf.OutputList(dense_features), example_weights, example_labels, tf.OutputList(sparse_indices), tf.OutputList(sparse_weights), tf.OutputList(dense_weights), example_state_data,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	out_example_state_data = op.Output(idx)
	if out_delta_sparse_weights, idx, err = makeOutputList(op, idx, "out_delta_sparse_weights"); err != nil {
		scope.UpdateErr("SdcaOptimizer", err)
		return
	}
	if out_delta_dense_weights, idx, err = makeOutputList(op, idx, "out_delta_dense_weights"); err != nil {
		scope.UpdateErr("SdcaOptimizer", err)
		return
	}
	return out_example_state_data, out_delta_sparse_weights, out_delta_dense_weights
}

// PrelinearizeTupleAttr is an optional argument to PrelinearizeTuple.
type PrelinearizeTupleAttr func(optionalAttr)

// PrelinearizeTupleLayouts sets the optional layouts attribute to value.
//
// value: A vector holding the requested layout in minor-to-major sequence for all the
// tuple shapes in the order the shapes appear in the "shapes" input. The layout
// elements for a sub-shape can be set to -1 in which case the corresponding layout
// will be computed by the infeed operation.
// If not specified, defaults to <>
func PrelinearizeTupleLayouts(value []int64) PrelinearizeTupleAttr {
	return func(m optionalAttr) {
		m["layouts"] = value
	}
}

// An op which linearizes multiple Tensor values to an opaque variant tensor.
//
// Arguments:
//	inputs: A list of tensors that will be provided using the infeed mechanism.
//	shapes: The shapes of each tensor in `inputs`.
func PrelinearizeTuple(scope *Scope, inputs []tf.Output, shapes []tf.Shape, optional ...PrelinearizeTupleAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shapes": shapes}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "PrelinearizeTuple",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Merges summaries.
//
// This op creates a
// [`Summary`](https://www.tensorflow.org/code/tensorflow/core/framework/summary.proto)
// protocol buffer that contains the union of all the values in the input
// summaries.
//
// When the Op is run, it reports an `InvalidArgument` error if multiple values
// in the summaries to merge use the same tag.
//
// Arguments:
//	inputs: Can be of any shape.  Each must contain serialized `Summary` protocol
// buffers.
//
// Returns Scalar. Serialized `Summary` protocol buffer.
func MergeSummary(scope *Scope, inputs []tf.Output) (summary tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "MergeSummary",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QueueEnqueueManyV2Attr is an optional argument to QueueEnqueueManyV2.
type QueueEnqueueManyV2Attr func(optionalAttr)

// QueueEnqueueManyV2TimeoutMs sets the optional timeout_ms attribute to value.
//
// value: If the queue is too full, this operation will block for up
// to timeout_ms milliseconds.
// Note: This option is not supported yet.
// If not specified, defaults to -1
func QueueEnqueueManyV2TimeoutMs(value int64) QueueEnqueueManyV2Attr {
	return func(m optionalAttr) {
		m["timeout_ms"] = value
	}
}

// Enqueues zero or more tuples of one or more tensors in the given queue.
//
// This operation slices each component tensor along the 0th dimension to
// make multiple queue elements. All of the tuple components must have the
// same size in the 0th dimension.
//
// The components input has k elements, which correspond to the components of
// tuples stored in the given queue.
//
// N.B. If the queue is full, this operation will block until the given
// elements have been enqueued (or 'timeout_ms' elapses, if specified).
//
// Arguments:
//	handle: The handle to a queue.
//	components: One or more tensors from which the enqueued tensors should
// be taken.
//
// Returns the created operation.
func QueueEnqueueManyV2(scope *Scope, handle tf.Output, components []tf.Output, optional ...QueueEnqueueManyV2Attr) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QueueEnqueueManyV2",
		Input: []tf.Input{
			handle, tf.OutputList(components),
		},
		Attrs: attrs,
	}
	return scope.AddOperation(opspec)
}

// Table initializer that takes two tensors for keys and values respectively.
//
// Arguments:
//	table_handle: Handle to a table which will be initialized.
//	keys: Keys of type Tkey.
//	values: Values of type Tval.
//
// Returns the created operation.
func InitializeTableV2(scope *Scope, table_handle tf.Output, keys tf.Output, values tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "InitializeTableV2",
		Input: []tf.Input{
			table_handle, keys, values,
		},
	}
	return scope.AddOperation(opspec)
}

// Does nothing. Serves as a control trigger for scheduling.
//
// Only useful as a placeholder for control edges.
//
// Returns the created operation.
func ControlTrigger(scope *Scope) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ControlTrigger",
	}
	return scope.AddOperation(opspec)
}

// Returns the diagonal part of the tensor.
//
// This operation returns a tensor with the `diagonal` part
// of the `input`. The `diagonal` part is computed as follows:
//
// Assume `input` has dimensions `[D1,..., Dk, D1,..., Dk]`, then the output is a
// tensor of rank `k` with dimensions `[D1,..., Dk]` where:
//
// `diagonal[i1,..., ik] = input[i1, ..., ik, i1,..., ik]`.
//
// For example:
//
// ```
// # 'input' is [[1, 0, 0, 0]
//               [0, 2, 0, 0]
//               [0, 0, 3, 0]
//               [0, 0, 0, 4]]
//
// tf.diag_part(input) ==> [1, 2, 3, 4]
// ```
//
// Arguments:
//	input: Rank k tensor where k is even and not zero.
//
// Returns The extracted diagonal.
func DiagPart(scope *Scope, input tf.Output) (diagonal tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "DiagPart",
		Input: []tf.Input{
			input,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// OutfeedDequeueAttr is an optional argument to OutfeedDequeue.
type OutfeedDequeueAttr func(optionalAttr)

// OutfeedDequeueDeviceOrdinal sets the optional device_ordinal attribute to value.
//
// value: The TPU device to use. This should be -1 when the Op
// is running on a TPU device, and >= 0 when the Op is running on the CPU
// device.
// If not specified, defaults to -1
func OutfeedDequeueDeviceOrdinal(value int64) OutfeedDequeueAttr {
	return func(m optionalAttr) {
		m["device_ordinal"] = value
	}
}

// Retrieves a single tensor from the computation outfeed.
//
// This operation will block indefinitely until data is available.
//
// Arguments:
//	dtype: The type of elements in the tensor.
//	shape: The shape of the tensor.
//
// Returns A tensor that will be read from the device outfeed.
func OutfeedDequeue(scope *Scope, dtype tf.DataType, shape tf.Shape, optional ...OutfeedDequeueAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"dtype": dtype, "shape": shape}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "OutfeedDequeue",

		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// StatelessRandomUniformAttr is an optional argument to StatelessRandomUniform.
type StatelessRandomUniformAttr func(optionalAttr)

// StatelessRandomUniformDtype sets the optional dtype attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_FLOAT
func StatelessRandomUniformDtype(value tf.DataType) StatelessRandomUniformAttr {
	return func(m optionalAttr) {
		m["dtype"] = value
	}
}

// Outputs deterministic pseudorandom random values from a uniform distribution.
//
// The generated values follow a uniform distribution in the range `[0, 1)`. The
// lower bound 0 is included in the range, while the upper bound 1 is excluded.
//
// The outputs are a deterministic function of `shape` and `seed`.
//
// Arguments:
//	shape: The shape of the output tensor.
//	seed: 2 seeds (shape [2]).
//
// Returns Random values with specified shape.
func StatelessRandomUniform(scope *Scope, shape tf.Output, seed tf.Output, optional ...StatelessRandomUniformAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "StatelessRandomUniform",
		Input: []tf.Input{
			shape, seed,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TensorListStackAttr is an optional argument to TensorListStack.
type TensorListStackAttr func(optionalAttr)

// TensorListStackNumElements sets the optional num_elements attribute to value.
// If not specified, defaults to -1
func TensorListStackNumElements(value int64) TensorListStackAttr {
	return func(m optionalAttr) {
		m["num_elements"] = value
	}
}

// Stacks all tensors in the list.
//
// Requires that all tensors have the same shape.
//
// input_handle: the input list
// tensor: the gathered result
// num_elements: optional. If not -1, the number of elements in the list.
//
func TensorListStack(scope *Scope, input_handle tf.Output, element_shape tf.Output, element_dtype tf.DataType, optional ...TensorListStackAttr) (tensor tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"element_dtype": element_dtype}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TensorListStack",
		Input: []tf.Input{
			input_handle, element_shape,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the cardinality of `input_dataset`.
//
// Returns the cardinality of `input_dataset`.
//
// Arguments:
//	input_dataset: A variant tensor representing the dataset to return cardinality for.
//
// Returns The cardinality of `input_dataset`. Named constants are used to represent
// infinite and unknown cardinality.
func ExperimentalDatasetCardinality(scope *Scope, input_dataset tf.Output) (cardinality tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ExperimentalDatasetCardinality",
		Input: []tf.Input{
			input_dataset,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr is an optional argument to QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize.
type QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr func(optionalAttr)

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeOutType sets the optional out_type attribute to value.
//
// value: The type of the output.
// If not specified, defaults to DT_QUINT8
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeOutType(value tf.DataType) QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["out_type"] = value
	}
}

// QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeDilations sets the optional dilations attribute to value.
//
// value: List of dilation values.
// If not specified, defaults to <i:1 i:1 i:1 i:1 >
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeDilations(value []int64) QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr {
	return func(m optionalAttr) {
		m["dilations"] = value
	}
}

// Computes quantized depthwise Conv2D with Bias, Relu and Requantize.
//
// Arguments:
//	input: The original input tensor.
//	filter: The original filter tensor.
//	bias: The original bias tensor.
//	min_input: The float value that the minimum quantized input value represents.
//	max_input: The float value that the maximum quantized input value represents.
//	min_filter: The float value that the minimum quantized filter value represents.
//	max_filter: The float value that the maximum quantized filter value represents.
//	min_freezed_output: The minimum float value of the output tensor.
//	max_freezed_output: The maximum float value of the output tensor.
//	strides: List of stride values.
//
//
// Returns The output tensor.The float value that the minimum quantized output value represents.The float value that the maximum quantized output value represents.
func QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize(scope *Scope, input tf.Output, filter tf.Output, bias tf.Output, min_input tf.Output, max_input tf.Output, min_filter tf.Output, max_filter tf.Output, min_freezed_output tf.Output, max_freezed_output tf.Output, strides []int64, padding string, optional ...QuantizedDepthwiseConv2DWithBiasAndReluAndRequantizeAttr) (output tf.Output, min_output tf.Output, max_output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"strides": strides, "padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "QuantizedDepthwiseConv2DWithBiasAndReluAndRequantize",
		Input: []tf.Input{
			input, filter, bias, min_input, max_input, min_filter, max_filter, min_freezed_output, max_freezed_output,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1), op.Output(2)
}

// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// Reduces `input` from `num_devices` using `reduction` to a single device.
//
// The graph should be constructed so that all inputs have a valid device
// assignment, and the op itself is assigned one of these devices.
//
// input: The input to the reduction.
// data: the value of the reduction across all `num_devices` devices.
// reduction: the reduction operation to perform.
func NcclReduce(scope *Scope, input []tf.Output, reduction string) (data tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"reduction": reduction}
	opspec := tf.OpSpec{
		Type: "NcclReduce",
		Input: []tf.Input{
			tf.OutputList(input),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Sends `input` to all devices that are connected to the output.
//
// Sends `input` to all devices that are connected to the output.
//
// The graph should be constructed so that all ops connected to the output have a
// valid device assignment, and the op itself is assigned one of these devices.
//
// input: The input to the broadcast.
// output: The same as input.
// shape: The shape of the input tensor.
//
func NcclBroadcast(scope *Scope, input tf.Output, shape tf.Shape) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "NcclBroadcast",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the element-wise sum of a list of tensors.
//
// `tf.accumulate_n_v2` performs the same operation as `tf.add_n`, but does not
// wait for all of its inputs to be ready before beginning to sum. This can
// save memory if inputs are ready at different times, since minimum temporary
// storage is proportional to the output size rather than the inputs size.
//
// Unlike the original `accumulate_n`, `accumulate_n_v2` is differentiable.
//
// Returns a `Tensor` of same shape and type as the elements of `inputs`.
//
// Arguments:
//	inputs: A list of `Tensor` objects, each with same shape and type.
//	shape: Shape of elements of `inputs`.
func AccumulateNV2(scope *Scope, inputs []tf.Output, shape tf.Shape) (sum tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"shape": shape}
	opspec := tf.OpSpec{
		Type: "AccumulateNV2",
		Input: []tf.Input{
			tf.OutputList(inputs),
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// RandomShuffleAttr is an optional argument to RandomShuffle.
type RandomShuffleAttr func(optionalAttr)

// RandomShuffleSeed sets the optional seed attribute to value.
//
// value: If either `seed` or `seed2` are set to be non-zero, the random number
// generator is seeded by the given seed.  Otherwise, it is seeded by a
// random seed.
// If not specified, defaults to 0
func RandomShuffleSeed(value int64) RandomShuffleAttr {
	return func(m optionalAttr) {
		m["seed"] = value
	}
}

// RandomShuffleSeed2 sets the optional seed2 attribute to value.
//
// value: A second seed to avoid seed collision.
// If not specified, defaults to 0
func RandomShuffleSeed2(value int64) RandomShuffleAttr {
	return func(m optionalAttr) {
		m["seed2"] = value
	}
}

// Randomly shuffles a tensor along its first dimension.
//
//   The tensor is shuffled along dimension 0, such that each `value[j]` is mapped
//   to one and only one `output[i]`. For example, a mapping that might occur for a
//   3x2 tensor is:
//
// ```
// [[1, 2],       [[5, 6],
//  [3, 4],  ==>   [1, 2],
//  [5, 6]]        [3, 4]]
// ```
//
// Arguments:
//	value: The tensor to be shuffled.
//
// Returns A tensor of same shape and type as `value`, shuffled along its first
// dimension.
func RandomShuffle(scope *Scope, value tf.Output, optional ...RandomShuffleAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "RandomShuffle",
		Input: []tf.Input{
			value,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// BatchMatMulAttr is an optional argument to BatchMatMul.
type BatchMatMulAttr func(optionalAttr)

// BatchMatMulAdjX sets the optional adj_x attribute to value.
//
// value: If `True`, adjoint the slices of `x`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjX(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_x"] = value
	}
}

// BatchMatMulAdjY sets the optional adj_y attribute to value.
//
// value: If `True`, adjoint the slices of `y`. Defaults to `False`.
// If not specified, defaults to false
func BatchMatMulAdjY(value bool) BatchMatMulAttr {
	return func(m optionalAttr) {
		m["adj_y"] = value
	}
}

// Multiplies slices of two tensors in batches.
//
// Multiplies all slices of `Tensor` `x` and `y` (each slice can be
// viewed as an element of a batch), and arranges the individual results
// in a single output tensor of the same batch size. Each of the
// individual slices can optionally be adjointed (to adjoint a matrix
// means to transpose and conjugate it) before multiplication by setting
// the `adj_x` or `adj_y` flag to `True`, which are by default `False`.
//
// The input tensors `x` and `y` are 2-D or higher with shape `[..., r_x, c_x]`
// and `[..., r_y, c_y]`.
//
// The output tensor is 2-D or higher with shape `[..., r_o, c_o]`, where:
//
//     r_o = c_x if adj_x else r_x
//     c_o = r_y if adj_y else c_y
//
// It is computed as:
//
//     output[..., :, :] = matrix(x[..., :, :]) * matrix(y[..., :, :])
//
// Arguments:
//	x: 2-D or higher with shape `[..., r_x, c_x]`.
//	y: 2-D or higher with shape `[..., r_y, c_y]`.
//
// Returns 3-D or higher with shape `[..., r_o, c_o]`
func BatchMatMul(scope *Scope, x tf.Output, y tf.Output, optional ...BatchMatMulAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "BatchMatMul",
		Input: []tf.Input{
			x, y,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generate the bucket boundaries for each feature based on accumulated summaries.
//
// An op that returns a list of float tensors for a quantile stream resource. Each
// tensor is Rank 1 containing bucket boundaries for a single feature.
//
// Arguments:
//	quantile_stream_resource_handle: resource handle referring to a QuantileStreamResource.
//	num_features: inferred int; number of features to get bucket boundaries for.
//
// Returns float; List of Rank 1 Tensors each containing the bucket boundaries for a feature.
func BoostedTreesQuantileStreamResourceGetBucketBoundaries(scope *Scope, quantile_stream_resource_handle tf.Output, num_features int64) (bucket_boundaries []tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"num_features": num_features}
	opspec := tf.OpSpec{
		Type: "BoostedTreesQuantileStreamResourceGetBucketBoundaries",
		Input: []tf.Input{
			quantile_stream_resource_handle,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	if scope.Err() != nil {
		return
	}
	var idx int
	var err error
	if bucket_boundaries, idx, err = makeOutputList(op, idx, "bucket_boundaries"); err != nil {
		scope.UpdateErr("BoostedTreesQuantileStreamResourceGetBucketBoundaries", err)
		return
	}
	return bucket_boundaries
}

// Computes the absolute value of a tensor.
//
// Given a tensor `x`, this operation returns a tensor containing the absolute
// value of each element in `x`. For example, if x is an input element and y is
// an output element, this operation computes \\(y = |x|\\).
func Abs(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Abs",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic tangent of `x` element-wise.
func Tanh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Tanh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// ComplexAbsAttr is an optional argument to ComplexAbs.
type ComplexAbsAttr func(optionalAttr)

// ComplexAbsTout sets the optional Tout attribute to value.
// If not specified, defaults to DT_FLOAT
func ComplexAbsTout(value tf.DataType) ComplexAbsAttr {
	return func(m optionalAttr) {
		m["Tout"] = value
	}
}

// Computes the complex absolute value of a tensor.
//
// Given a tensor `x` of complex numbers, this operation returns a tensor of type
// `float` or `double` that is the absolute value of each element in `x`. All
// elements in `x` must be complex numbers of the form \\(a + bj\\). The absolute
// value is computed as \\( \sqrt{a^2 + b^2}\\).
func ComplexAbs(scope *Scope, x tf.Output, optional ...ComplexAbsAttr) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "ComplexAbs",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the reciprocal of x element-wise.
//
// I.e., \\(y = 1 / x\\).
func Inv(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Inv",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise remainder of division. When `x < 0` xor `y < 0` is
//
// true, this follows Python semantics in that the result here is consistent
// with a flooring divide. E.g. `floor(x / y) * y + mod(x, y) = x`.
//
// *NOTE*: `FloorMod` supports broadcasting. More about broadcasting
// [here](http://docs.scipy.org/doc/numpy/user/basics.broadcasting.html)
func FloorMod(scope *Scope, x tf.Output, y tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "FloorMod",
		Input: []tf.Input{
			x, y,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the maximum along segments of a tensor.
//
// Read
// [the section on segmentation](https://tensorflow.org/api_docs/python/tf/math#Segmentation)
// for an explanation of segments.
//
// Computes a tensor such that
// \\(output_i = \max_j(data_j)\\) where `max` is over `j` such
// that `segment_ids[j] == i`.
//
// If the max is empty for a given segment ID `i`, `output[i] = 0`.
//
// <div style="width:70%; margin:auto; margin-bottom:10px; margin-top:20px;">
// <img style="width:100%" src="https://www.tensorflow.org/images/SegmentMax.png" alt>
// </div>
//
// For example:
//
// ```
// c = tf.constant([[1,2,3,4], [4, 3, 2, 1], [5,6,7,8]])
// tf.segment_max(c, tf.constant([0, 0, 1]))
// # ==> [[4, 3, 3, 4],
// #      [5, 6, 7, 8]]
// ```
//
//
// Arguments:
//
//	segment_ids: A 1-D tensor whose size is equal to the size of `data`'s
// first dimension.  Values should be sorted and can be repeated.
//
// Returns Has same shape as data, except for dimension 0 which
// has size `k`, the number of segments.
func SegmentMax(scope *Scope, data tf.Output, segment_ids tf.Output) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SegmentMax",
		Input: []tf.Input{
			data, segment_ids,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// SqueezeAttr is an optional argument to Squeeze.
type SqueezeAttr func(optionalAttr)

// SqueezeAxis sets the optional axis attribute to value.
//
// value: If specified, only squeezes the dimensions listed. The dimension
// index starts at 0. It is an error to squeeze a dimension that is not 1. Must
// be in the range `[-rank(input), rank(input))`.
// If not specified, defaults to <>
//
// REQUIRES: len(value) >= 0
func SqueezeAxis(value []int64) SqueezeAttr {
	return func(m optionalAttr) {
		m["squeeze_dims"] = value
	}
}

// Removes dimensions of size 1 from the shape of a tensor.
//
// Given a tensor `input`, this operation returns a tensor of the same type with
// all dimensions of size 1 removed. If you don't want to remove all size 1
// dimensions, you can remove specific size 1 dimensions by specifying
// `axis`.
//
// For example:
//
// ```
// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
// shape(squeeze(t)) ==> [2, 3]
// ```
//
// Or, to remove specific size 1 dimensions:
//
// ```
// # 't' is a tensor of shape [1, 2, 1, 3, 1, 1]
// shape(squeeze(t, [2, 4])) ==> [1, 2, 3, 1]
// ```
//
// Arguments:
//	input: The `input` to squeeze.
//
// Returns Contains the same data as `input`, but has one or more dimensions of
// size 1 removed.
func Squeeze(scope *Scope, input tf.Output, optional ...SqueezeAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Squeeze",
		Input: []tf.Input{
			input,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes numerical negative value element-wise.
//
// I.e., \\(y = -x\\).
func Neg(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Neg",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the inverse of `x` wrt its input.
//
// Specifically, `grad = -dy * y*y`, where `y = 1/x`, and `dy`
// is the corresponding input gradient.
func ReciprocalGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "ReciprocalGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that batches `batch_size` elements from `input_dataset`.
//
// Arguments:
//
//	batch_size: A scalar representing the number of elements to accumulate in a
// batch.
//
//
func BatchDataset(scope *Scope, input_dataset tf.Output, batch_size tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "BatchDataset",
		Input: []tf.Input{
			input_dataset, batch_size,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns element-wise smallest integer not less than x.
func Ceil(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Ceil",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Creates a dataset that uses a custom thread pool to compute `input_dataset`.
//
// Arguments:
//
//	thread_pool: A resource produced by the ThreadPoolHandle op.
//
//
func ExperimentalThreadPoolDataset(scope *Scope, input_dataset tf.Output, thread_pool tf.Output, output_types []tf.DataType, output_shapes []tf.Shape) (handle tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"output_types": output_types, "output_shapes": output_shapes}
	opspec := tf.OpSpec{
		Type: "ExperimentalThreadPoolDataset",
		Input: []tf.Input{
			input_dataset, thread_pool,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes square of x element-wise.
//
// I.e., \\(y = x * x = x^2\\).
func Square(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Square",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Generates fingerprint values.
//
// Generates fingerprint values of `data`.
//
// Fingerprint op considers the first dimension of `data` as the batch dimension,
// and `output[i]` contains the fingerprint value generated from contents in
// `data[i, ...]` for all `i`.
//
// Fingerprint op writes fingerprint values as byte arrays. For example, the
// default method `farmhash64` generates a 64-bit fingerprint value at a time.
// This 8-byte value is written out as an `uint8` array of size 8, in little-endian
// order.
//
// For example, suppose that `data` has data type `DT_INT32` and shape (2, 3, 4),
// and that the fingerprint method is `farmhash64`. In this case, the output shape
// is (2, 8), where 2 is the batch dimension size of `data`, and 8 is the size of
// each fingerprint value in bytes. `output[0, :]` is generated from 12 integers in
// `data[0, :, :]` and similarly `output[1, :]` is generated from other 12 integers
// in `data[1, :, :]`.
//
// Note that this op fingerprints the raw underlying buffer, and it does not
// fingerprint Tensor's metadata such as data type and/or shape. For example, the
// fingerprint values are invariant under reshapes and bitcasts as long as the
// batch dimension remain the same:
//
// ```
// Fingerprint(data) == Fingerprint(Reshape(data, ...))
// Fingerprint(data) == Fingerprint(Bitcast(data, ...))
// ```
//
// For string data, one should expect `Fingerprint(data) !=
// Fingerprint(ReduceJoin(data))` in general.
//
// Arguments:
//	data: Must have rank 1 or higher.
//	method: Fingerprint method used by this op. Currently available method is
// `farmhash::fingerprint64`.
//
// Returns A two-dimensional `Tensor` of type `tf.uint8`. The first dimension equals to
// `data`'s first dimension, and the second dimension size depends on the
// fingerprint algorithm.
func Fingerprint(scope *Scope, data tf.Output, method tf.Output) (fingerprint tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Fingerprint",
		Input: []tf.Input{
			data, method,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// TridiagonalSolveAttr is an optional argument to TridiagonalSolve.
type TridiagonalSolveAttr func(optionalAttr)

// TridiagonalSolvePartialPivoting sets the optional partial_pivoting attribute to value.
//
// value: Whether to apply partial pivoting. Partial pivoting makes the procedure more
// stable, but slower.
// If not specified, defaults to true
func TridiagonalSolvePartialPivoting(value bool) TridiagonalSolveAttr {
	return func(m optionalAttr) {
		m["partial_pivoting"] = value
	}
}

// Solves tridiagonal systems of equations.
//
//   Solves tridiagonal systems of equations.
//   Supports batch dimensions and multiple right-hand sides per each left-hand
//   side.
//   On CPU, solution is computed via Gaussian elimination with or without partial
//   pivoting, depending on `partial_pivoting` attribute. On GPU, Nvidia's cuSPARSE
//   library is used: https://docs.nvidia.com/cuda/cusparse/index.html#gtsv
//
// Arguments:
//	diagonals: Tensor of shape `[..., 3, M]` whose innermost 2 dimensions represent the
// tridiagonal matrices with three rows being the superdiagonal, diagonals, and
// subdiagonals, in order. The last element of the superdiagonal and the first
// element of the subdiagonal is ignored.
//	rhs: Tensor of shape `[..., M, K]`, representing K right-hand sides per each
// left-hand side.
//
// Returns Tensor of shape `[..., M, K]` containing the solutions
func TridiagonalSolve(scope *Scope, diagonals tf.Output, rhs tf.Output, optional ...TridiagonalSolveAttr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "TridiagonalSolve",
		Input: []tf.Input{
			diagonals, rhs,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes square root of x element-wise.
//
// I.e., \\(y = \sqrt{x} = x^{1/2}\\).
func Sqrt(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sqrt",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes the gradient for the sqrt of `x` wrt its input.
//
// Specifically, `grad = dy * 0.5 / y`, where `y = sqrt(x)`, and `dy`
// is the corresponding input gradient.
func SqrtGrad(scope *Scope, y tf.Output, dy tf.Output) (z tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "SqrtGrad",
		Input: []tf.Input{
			y, dy,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Set a summary_writer_interface to record statistics using given stats_aggregator.
//
// Returns the created operation.
func StatsAggregatorSetSummaryWriter(scope *Scope, stats_aggregator tf.Output, summary tf.Output) (o *tf.Operation) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "StatsAggregatorSetSummaryWriter",
		Input: []tf.Input{
			stats_aggregator, summary,
		},
	}
	return scope.AddOperation(opspec)
}

// Computes exponential of x element-wise.  \\(y = e^x\\).
func Exp(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Exp",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Returns the truth value of NOT x element-wise.
func LogicalNot(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "LogicalNot",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes hyperbolic sine of x element-wise.
func Sinh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Sinh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// MaxPoolGradV2Attr is an optional argument to MaxPoolGradV2.
type MaxPoolGradV2Attr func(optionalAttr)

// MaxPoolGradV2DataFormat sets the optional data_format attribute to value.
//
// value: Specify the data format of the input and output data. With the
// default format "NHWC", the data is stored in the order of:
//     [batch, in_height, in_width, in_channels].
// Alternatively, the format could be "NCHW", the data storage order of:
//     [batch, in_channels, in_height, in_width].
// If not specified, defaults to "NHWC"
func MaxPoolGradV2DataFormat(value string) MaxPoolGradV2Attr {
	return func(m optionalAttr) {
		m["data_format"] = value
	}
}

// Computes gradients of the maxpooling function.
//
// Arguments:
//	orig_input: The original input tensor.
//	orig_output: The original output tensor.
//	grad: 4-D.  Gradients w.r.t. the output of `max_pool`.
//	ksize: The size of the window for each dimension of the input tensor.
//	strides: The stride of the sliding window for each dimension of the
// input tensor.
//	padding: The type of padding algorithm to use.
//
// Returns Gradients w.r.t. the input to `max_pool`.
func MaxPoolGradV2(scope *Scope, orig_input tf.Output, orig_output tf.Output, grad tf.Output, ksize tf.Output, strides tf.Output, padding string, optional ...MaxPoolGradV2Attr) (output tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{"padding": padding}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "MaxPoolGradV2",
		Input: []tf.Input{
			orig_input, orig_output, grad, ksize, strides,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// Computes inverse hyperbolic sine of x element-wise.
func Asinh(scope *Scope, x tf.Output) (y tf.Output) {
	if scope.Err() != nil {
		return
	}
	opspec := tf.OpSpec{
		Type: "Asinh",
		Input: []tf.Input{
			x,
		},
	}
	op := scope.AddOperation(opspec)
	return op.Output(0)
}

// UniqueAttr is an optional argument to Unique.
type UniqueAttr func(optionalAttr)

// UniqueOutIdx sets the optional out_idx attribute to value.
// If not specified, defaults to DT_INT32
func UniqueOutIdx(value tf.DataType) UniqueAttr {
	return func(m optionalAttr) {
		m["out_idx"] = value
	}
}

// Finds unique elements in a 1-D tensor.
//
// This operation returns a tensor `y` containing all of the unique elements of `x`
// sorted in the same order that they occur in `x`. This operation also returns a
// tensor `idx` the same size as `x` that contains the index of each value of `x`
// in the unique output `y`. In other words:
//
// `y[idx[i]] = x[i] for i in [0, 1,...,rank(x) - 1]`
//
// For example:
//
// ```
// # tensor 'x' is [1, 1, 2, 4, 4, 4, 7, 8, 8]
// y, idx = unique(x)
// y ==> [1, 2, 4, 7, 8]
// idx ==> [0, 0, 1, 2, 2, 2, 3, 4, 4]
// ```
//
// Arguments:
//	x: 1-D.
//
// Returns 1-D.1-D.
func Unique(scope *Scope, x tf.Output, optional ...UniqueAttr) (y tf.Output, idx tf.Output) {
	if scope.Err() != nil {
		return
	}
	attrs := map[string]interface{}{}
	for _, a := range optional {
		a(attrs)
	}
	opspec := tf.OpSpec{
		Type: "Unique",
		Input: []tf.Input{
			x,
		},
		Attrs: attrs,
	}
	op := scope.AddOperation(opspec)
	return op.Output(0), op.Output(1)
}

// Returns the