# TensorFlow Lite converter

TensorFlow Lite uses the optimized
[FlatBuffer](https://google.github.io/flatbuffers/) format to represent graphs.
Therefore, a TensorFlow model
([protocol buffer](https://developers.google.com/protocol-buffers/)) needs to be
converted into a `FlatBuffer` file before deploying to clients.

## From model training to device deployment

The TensorFlow Lite converter generates a TensorFlow Lite
[FlatBuffer](https://google.github.io/flatbuffers/) file (`.tflite`) from a
TensorFlow model.

The converter supports the following input formats:

*   [SavedModels](https://www.tensorflow.org/guide/saved_model#using_savedmodel_with_estimators)
*   Frozen `GraphDef`: Models generated by
    [freeze_graph.py](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/python/tools/freeze_graph.py).
*   `tf.keras` HDF5 models.
*   Any model taken from a `tf.Session` (Python API only).

The TensorFlow Lite `FlatBuffer` file is then deployed to a client device
(generally a mobile or embedded device), and the TensorFlow Lite interpreter
uses the compressed model for on-device inference. This conversion process is
shown in the diagram below:

![TFLite converter workflow](../images/convert/workflow.svg)

## Options

The TensorFlow Lite Converter can be used from either of these two options:

*   [Python](python_api.md) (**Preferred**): Using the Python API makes it
    easier to convert models as part of a model development pipeline, and helps
    mitigate [compatibility](../tf_ops_compatibility.md) issues early on.
*   [Command line](cmdline_examples.md)
