#!/usr/bin/env bash
# Copyright 2016 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
# Install packages required by Python3.6 build

# TODO(amitpatankar): Remove this file once we upgrade to ubuntu:16.04
# docker images for Python 3.6 builds.

# LINT.IfChange

# fkrull/deadsnakes is for Python3.6
add-apt-repository -y ppa:fkrull/deadsnakes
apt-get update

set -e
# Install Python 3.6 and dev library
apt-get install -y --no-install-recommends python3.6 libpython3.6-dev

# Install pip3.6
set +e
pip36_version=$(pip3.6 --version | grep "python 3.6")
if [[ -z $pip36_version ]]; then
  set -e
  wget -q https://bootstrap.pypa.io/get-pip.py
  python3.6 get-pip.py
  rm -f get-pip.py
fi

set -e
pip3.6 install --upgrade pip

# Install last working version of setuptools. This must happen before we install
# absl-py, which uses install_requires notation introduced in setuptools 20.5.
pip3.6 install --upgrade setuptools==39.1.0

pip3.6 install --upgrade virtualenv

# Install six.
pip3.6 install --upgrade absl-py
pip3.6 install --upgrade six==1.10.0

# Install protobuf.
pip3.6 install --upgrade protobuf==3.6.0

# Remove obsolete version of six, which can sometimes confuse virtualenv.
rm -rf /usr/lib/python3/dist-packages/six*

# Install numpy, scipy and scikit-learn required by the builds

# numpy needs to be installed from source to fix segfaults. See:
# https://github.com/tensorflow/tensorflow/issues/6968
# This workaround isn't needed for Ubuntu 16.04 or later.
pip3.6 install --no-binary=:all: --upgrade numpy==1.14.5

pip3.6 install scipy==0.18.1

pip3.6 install scikit-learn==0.19.1

# pandas required by `inflow`
pip3.6 install pandas==0.19.2

pip3.6 install gnureadline

pip3.6 install bz2file

# Install recent-enough version of wheel for Python 3.6 wheel builds
pip3.6 install wheel==0.29.0

pip3.6 install portpicker

pip3.6 install werkzeug

pip3.6 install grpcio

# Eager-to-graph execution needs astor, gast and termcolor:
pip3.6 install --upgrade astor
pip3.6 install --upgrade gast
pip3.6 install --upgrade termcolor

# Keras
pip3.6 install keras_applications==1.0.6
pip3.6 install keras_preprocessing==1.0.5
pip3.6 install --upgrade h5py==2.8.0

# LINT.ThenChange(//tensorflow/tools/ci_build/install/install_python3.5_pip_packages.sh)
