# Copyright 2019 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Utility to create a single py_binary that can call multiple py_binaries.

This simulates executing a python script by importing a module name by the
environment 'SCRIPT_NAME' and executing its main via `app.run`.
"""

from __future__ import absolute_import
from __future__ import division
from __future__ import print_function

import importlib
import os
import sys

from absl import app


if __name__ == '__main__':
  # Append current path to import path and execute `SCRIPT_NAME` main.
  sys.path.extend([os.path.dirname(__file__)])
  module_name = os.environ['SCRIPT_NAME']
  app.run(importlib.import_module(module_name).main)
