# Welcome to the TensorFlow Community

TensorFlow is an open-source project.  This page explains how to contribute,
where to ask questions, and how to help each other.


## Development

The source code for TensorFlow is on
[GitHub](https://github.com/tensorflow/tensorflow).

Before contributing to TensorFlow source code, please review the
[Contribution guidelines](https://github.com/tensorflow/tensorflow/blob/master/CONTRIBUTING.md).


### Projects developed by the TensorFlow community

The TensorFlow community has created many great projects around TensorFlow, including:

* [Machine Learning with TensorFlow (Book & Code)](http://tensorflowbook.com)
* [@jtoy's awesome "Awesome TensorFlow" list of awesome things](https://github.com/jtoy/awesome-tensorflow)
* [TensorFlow tutorials](https://github.com/pkmital/tensorflow_tutorials)
* [Scikit Flow - Simplified Interface for TensorFlow](https://github.com/tensorflow/tensorflow/tree/master/tensorflow/contrib/learn/python/learn)
* [Caffe to TensorFlow model converter](https://github.com/ethereon/caffe-tensorflow)
* [Bitfusion's` GPU-enabled AWS EC2 TensorFlow AMI](https://github.com/bitfusionio/amis/tree/master/awsmrkt-bfboost-ubuntu14-cuda75-tensorflow) ([Launch AMI](https://aws.amazon.com/marketplace/pp/B01EYKBEQ0))
* [Rust language bindings](https://github.com/google/tensorflow-rust)
* [Operator Vectorization Library](https://github.com/opveclib/opveclib)
* [Swift language bindings](https://github.com/PerfectlySoft/Perfect-TensorFlow)
* [Sublime Tensorflow - A plugin for Sublime Text](https://github.com/baptisteArnaud/Sublime-Tensorflow)
* [Edward - A library for probabilistic modeling, inference, and criticism](http://edwardlib.org) ([Github](https://github.com/blei-lab/edward), [Forum](https://discourse.edwardlib.org))
* [GPflow - Gaussian processes in TensorFlow](https://github.com/GPflow/GPflow)

## TensorFlow Communities Around the World

Asia:

* [TensorFlow Korea (TF-KR) User Group](https://www.facebook.com/groups/TensorFlowKR/) _(Korean language)_
* [TensorFlow User Group Tokyo](https://tfug-tokyo.connpass.com/) _(Japanese Language)_
* [Soleil Data Dojo](https://soleildatadojo.connpass.com/) _(Japanese language)_
* [TensorFlow User Group Utsunomiya](https://tfug-utsunomiya.connpass.com/)


Europe:

* [TensorFlow Barcelona](https://www.meetup.com/Barcelona-Machine-Learning-Meetup/)
* [TensorFlow Madrid](https://www.meetup.com/TensorFlow-Madrid/)



## Support

TensorFlow provides multiple communication paths.  To pick the right path,
please read the following list carefully:

  * To ask or answer technical questions about TensorFlow, use
    [Stack Overflow](https://stackoverflow.com/questions/tagged/tensorflow).
    For example, ask or search Stack Overflow about a particular error message
    you encountered during installation.
  * To join general discussions about TensorFlow development and directions,
    please join the
    [TensorFlow discuss mailing list](https://groups.google.com/a/tensorflow.org/d/forum/discuss).
    For example, use this mailing list to learn about new features in
    upcoming releases of TensorFlow.
  * To report bugs or make feature requests, use the
    [TensorFlow issues tracker](https://github.com/tensorflow/tensorflow/issues)
    on GitHub.  For example, use the issue tracker to request a
    new operation in TensorFlow.
    

