import { devices, type PlaywrightTestConfig } from '@playwright/test'
import type { NextOptionsConfig } from './next-options'

/**
 * This is the default configuration generated by Playwright as of v1.43.0 with some modifications.
 *
 * - the `testMatch` property is configured to match all `*.spec.js` or `*.spec.ts` files within the `app` and `pages` directories
 * - the `use` property is configured with a baseURL matching the expected dev server endpoint (http://127.0.0.1:3000)
 * - the `webserver` property is configured to run `next dev`.
 */
export const defaultPlaywrightConfig: PlaywrightTestConfig<NextOptionsConfig> =
  {
    testMatch: '{app,pages}/**/*.spec.{t,j}s',
    fullyParallel: true,
    forbidOnly: process.env.CI === 'true',
    retries: process.env.CI === 'true' ? 2 : 0,
    reporter: [['list'], ['html', { open: 'never' }]],
    use: {
      baseURL: 'http://127.0.0.1:3000',
      trace: 'on-first-retry',
    },
    projects: [
      {
        name: 'chromium',
        use: { ...devices['Desktop Chrome'] },
      },

      {
        name: 'firefox',
        use: { ...devices['Desktop Firefox'] },
      },

      {
        name: 'webkit',
        use: { ...devices['Desktop Safari'] },
      },
    ],
    webServer: {
      command: process.env.CI === 'true' ? 'next start' : 'next dev',
      url: 'http://127.0.0.1:3000',
      reuseExistingServer: process.env.CI !== 'true',
    },
  }
