# Next.js with Meilisearch

This starter configures Meilisearch and InstantSearch for a Next.js application.

## Deploy your own

Deploy the example using [Vercel](https://vercel.com?utm_source=github&utm_medium=readme&utm_campaign=next-example):

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https://github.com/vercel/next.js/tree/canary/examples/with-meilisearch&project-name=with-meilisearch&repository-name=with-meilisearch&integration-ids=oac_VnRV92Cy6BoP96QY6Rkc5898)

## How to use

First, create a [Meilisearch Cloud project](https://cloud.meilisearch.com).

Then, execute [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app) with [npm](https://docs.npmjs.com/cli/init), [Yarn](https://yarnpkg.com/lang/en/docs/cli/create/), [pnpm](https://pnpm.io), or [Bun](https://bun.sh/docs/cli/bunx) to bootstrap the example:

```bash
npx create-next-app --example with-meilisearch with-meilisearch-app
```

```bash
yarn create next-app --example with-meilisearch with-meilisearch-app
```

```bash
pnpm create next-app --example with-meilisearch with-meilisearch-app
```

```bash
bunx create-next-app --example with-meilisearch with-meilisearch-app
```

Deploy it to the cloud with [Vercel](https://vercel.com/new?utm_source=github&utm_medium=readme&utm_campaign=next-example) ([Documentation](https://nextjs.org/docs/deployment)).

> Check out the docs for [Local Installation](https://www.meilisearch.com/docs/learn/getting_started/installation#local-installation) to run Meilisearch locally. The Meilisearch Cloud extension configures your environment varilables for you. If you're not using it, make sure to update your environment variables.

## Notes

For more examples of how to use Meilisearch with Next.js, check out our demo: [Next.js App to Find Where to Stream Movies](https://github.com/meilisearch/demo-movies)
