# Panda CSS Example

This example contains a simple implementation of [Panda CSS](https://panda-css.com/). It contains styling for a link made in four different approaches supported by Panda CSS. Refer to the [documentation](https://panda-css.com/docs) for when to use - and how to combine - the different approaches to suit your needs.

## Link examples

- [Atomic Recipe (CVA)](https://panda-css.com/docs/concepts/recipes#atomic-recipe-or-cva) Create multi-variant atomic styles with a type-safe runtime API.
- [Atomic Style](https://panda-css.com/docs/concepts/writing-styles#atomic-styles) Type-safe reusable atoms with small CSS footprint.
- [Config Recipe](https://panda-css.com/docs/concepts/recipes#config-recipe) Reusable recipes extracted and generated just-in-time.
- [Text Styles](https://panda-css.com/docs/theming/text-styles#defining-text-styles) Global text styles for consistent and legible typography.

## Deploy your own

Deploy the example using [Vercel](https://vercel.com?utm_source=github&utm_medium=readme&utm_campaign=next-example):

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https://github.com/vercel/next.js/tree/canary/examples/DIRECTORY_NAME&project-name=DIRECTORY_NAME&repository-name=DIRECTORY_NAME)

## Preview

Preview the example live on [https://example-panda-css.vercel.app/](https://example-panda-css.vercel.app/)

## How to use

Execute [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app) with [npm](https://docs.npmjs.com/cli/init), [Yarn](https://yarnpkg.com/lang/en/docs/cli/create/), [pnpm](https://pnpm.io), or [Bun](https://bun.sh/docs/cli/bunx) to bootstrap the example:

```bash
npx create-next-app --example panda-css panda-css-app
```

```bash
yarn create next-app --example panda-css panda-css-app
```

```bash
pnpm create next-app --example panda-css panda-css-app
```

```bash
bunx create-next-app --example panda-css panda-css-app
```

Deploy it to the cloud with [Vercel](https://vercel.com/new?utm_source=github&utm_medium=readme&utm_campaign=next-example) ([Documentation](https://nextjs.org/docs/deployment)).
