import type { Metadata } from 'next'

export const metadata: Metadata = {
  title: 'Home Layout',
  description: 'Generated by create next app',
}

export default function RootLayout({
  header,
  children,
}: Readonly<{
  header: React.ReactNode
  children: React.ReactNode
}>) {
  return (
    <html lang="en">
      <body className={`antialiased bg-gray-50 text-black`}>
        {header}
        {children}
      </body>
    </html>
  )
}
