use serde::Deserialize;

/// The top-most structure encoded into the query param in requests to
/// `next/font/google` generated by the next/font swc transform. e.g.
/// `next/font/google/target.css?{"path": "index.js", "import": "Inter"...`
#[derive(Debug, Deserialize)]
#[serde(rename_all = "camelCase")]
pub(super) struct NextFontRequest {
    pub import: String,
    pub arguments: Vec<NextFontRequestArguments>,
}

#[derive(Clone, Debug, Default, Deserialize)]
pub(super) struct NextFontRequestArguments {
    pub weight: Option<OneOrManyStrings>,
    pub subsets: Option<Vec<String>>,
    pub style: Option<OneOrManyStrings>,
    pub display: Option<String>,
    pub preload: Option<bool>,
    pub axes: Option<Vec<String>>,
    pub fallback: Option<Vec<String>>,
    pub adjust_font_fallback: Option<bool>,
    pub variable: Option<String>,
}

#[derive(Clone, Debug, Deserialize)]
#[serde(untagged)]
pub(super) enum OneOrManyStrings {
    One(String),
    Many(Vec<String>),
}
