# OpenTelemetry example

[OpenTelemetry](https://opentelemetry.io/) is a collection of tools for easier instrumentation of you applications.
You can use it to setup instrumentation for Next.js with the `instrumentation.ts` file.

In order to collect and inspect traces generated by OpenTelemetry you need a running OpenTelemetry collector and a backend.

You can easily deploy this example on Vercel. It manages OpenTelemetry collector for you, read the [docs](https://vercel.com/docs/concepts/observability/otel-overview/quickstart) for more details. Or you can follow official OpenTelemetry [documentation](https://opentelemetry.io/docs/collector/getting-started/) if you want to use it in your self-hosted Next.js app.

But you need to run your own collector if you want to test OpenTelemetry locally. We recommend cloning pre-made [dev setup](https://github.com/vercel/opentelemetry-collector-dev-setup). It contains pre-configured docker images for Collector, ZipKin, Jaeger and Prometheus.

More information about OpenTelemetry can be found in [Next.js docs](https://nextjs.org/docs/advanced-features/open-telemetry).

## Deploy your own

Deploy the example using [Vercel](https://vercel.com?utm_source=github&utm_medium=readme&utm_campaign=next-example) or preview live with [StackBlitz](https://stackblitz.com/github/vercel/next.js/tree/canary/examples/data-fetch)

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https://github.com/vercel/next.js/tree/canary/examples/with-opentelemetry&project-name=with-opentelemetry&repository-name=with-opentelemetry)

## How to use

Execute [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app) with [npm](https://docs.npmjs.com/cli/init), [Yarn](https://yarnpkg.com/lang/en/docs/cli/create/), or [pnpm](https://pnpm.io) to bootstrap the example:

```bash
npx create-next-app --example with-opentelemetry with-opentelemetry-app
```

```bash
yarn create next-app --example with-opentelemetry with-opentelemetry-app
```

```bash
pnpm create next-app --example with-opentelemetry with-opentelemetry-app
```

Deploy it to the cloud with [Vercel](https://vercel.com/new?utm_source=github&utm_medium=readme&utm_campaign=next-example) ([Documentation](https://nextjs.org/docs/deployment)).
