# Contributing to Next.js

[Watch the 40-minute walkthrough video on how to contribute to Next.js.](https://www.youtube.com/watch?v=cuoNzXFLitc)

- Read about our [Commitment to Open Source](https://vercel.com/oss).
- Before jumping into a PR be sure to search [existing PRs](https://github.com/vercel/next.js/pulls) or [issues](https://github.com/vercel/next.js/issues) for an open or closed item that relates to your submission.

## Repository

- [Triaging](./contributing/repository/triaging.md)
- [Linting](./contributing/repository/linting.md)
- [Release Channels and Publishing](./contributing/repository/release-channels-publishing.md)
- [Pull Request Descriptions](./contributing/repository/pull-request-descriptions.md)

## Documentation

- [Adding Documentation](./contributing/docs/adding-documentation.md)

## Examples

To contribute to [our examples](./examples), please see

- [Adding Examples](./contributing/examples/adding-examples.md)
- [Run Example Apps](./contributing/examples/run-example-apps.md)

## Core

- [Developing](./contributing/core/developing.md)
- [Building](./contributing/core/building.md)
- [Testing](./contributing/core/testing.md)
- [Adding Error Links](./contributing/core/adding-error-links.md)
- [Adding a new feature](./contributing/core/adding-features.md)
- [Developing Using Local App](./contributing/core/developing-using-local-app.md)
<!-- - [Using the VS Code Debugger](./contributing/core/vscode-debugger.md) -->
