---
title: Hue 4.9 and its new SQL dialects and components are out!
author: Hue Team
type: post
date: 2021-02-02T00:00:00+00:00
url: /blog/hue-4-9-sql-dialects-phoenix-dasksql-flink-components/
sf_thumbnail_type:
  - none
sf_thumbnail_link_type:
  - link_to_post
sf_detail_type:
  - none
sf_page_title:
  - 1
sf_page_title_style:
  - standard
sf_no_breadcrumbs:
  - 1
sf_page_title_bg:
  - none
sf_page_title_text_style:
  - light
sf_background_image_size:
  - cover
sf_social_sharing:
  - 1
sf_related_articles:
  - 1
sf_sidebar_config:
  - left-sidebar
sf_left_sidebar:
  - Sidebar-2
sf_right_sidebar:
  - Sidebar-1
sf_caption_position:
  - caption-right
sf_remove_promo_bar:
  - 1
ampforwp-amp-on-off:
  - default
categories:
  - Version 4.9
  - Release

---
Hi Data Explorers,

The Hue Team is glad to thanks all the contributors and release Hue 4.9!

<a href="https://cdn.gethue.com/uploads/2021/02/hue-4.9.png">
  <img src="https://cdn.gethue.com/uploads/2021/02/hue-4.9.png" />
</a>

&nbsp;

This release brings all these improvements on top of [4.8](https://gethue.com/blog/hue-4-8-phoenix-flink-sparksql-components/).

4.9 brings several improvements on top of the previous release. Several blog posts already detailed some of them, but here is a general summary.

First, the support of many SQL dialects has been improved, with in particular Apache Phoenix, Dask SQL, Apache Flink SQL. Complete end to end tutorials with Docker compose environments have been developed so that you can start poking around in 2 clicks.

* [Querying a live Kafka stream and outputting back calculations on a rolling window](https://gethue.com/blog/sql-querying-live-kafka-logs-and-sending-live-updates-with-flink-sql/)
* [Query live HBase data with Phoenix SQL](https://gethue.com/blog/querying-live-kafka-data-in-apache-hbase-with-phoenix/)
* [Getting started with the Spark SQL Editor](https://gethue.com/blog/querying-spark-sql-with-spark-thrift-server-and-hue-editor/)

!["Flink SQL - SELECT and INSERT data into Kafka Topics"](https://cdn.gethue.com/uploads/2021/02/peek-log-streams.gif)

The Editor is also getting split up into components, so that they are cleaner and easier to reuse (e.g. SQL parsers, SQL Scratchpad...). This will bring a new version of the Editor, which is currently in beta. Another improvement in the introduction of the Connectors (in beta too) so that SQL dialects can be easily added without any server restart.

Secondly, special thanks to the community who contributed a brand new Dask SQL autocomplete (ISSUE-1480) and also Prometheus Alerting for Kubernetes (PR-1648).

Dask SQL is a great way to leverage your existing Python libs by directly calling them via SQL. You can even create your own ML models like you would create a table. Read more on the documentation.

Flink SQL is getting friendlier with more sophisticated syntax autocomplete for critical functions like TUMBLE().

!["Flink SQL - Autocomplete improvements"](https://cdn.gethue.com/uploads/2021/02/flink_udf_tumble.png)

The autocomplete is also getting smart enough to suggest JOINs on tables with Foreign Keys.

!["Foreign Keys JOINs autocomplete](https://cdn.gethue.com/uploads/2021/02/fk_joins.png)

The tech stack continues to get modernized as Python 3 is now the default in the latest Docker image and the port from Django 1 to Django 2 was done (and Django 3 is next).


It has more than 600+ commits and 200+ bug fixes! For more details on all the changes, check out the [release notes](https://docs.gethue.com/releases/release-notes-4.9.0/).

Go grab it and give it a spin!

* Docker
    ```
    docker run -it -p 8888:8888 gethue/4.9.0
    ```
* Kubernetes :
    ```
    helm repo add gethue https://helm.gethue.com
    helm repo update
    helm install hue gethue/hue
    ```
* [demo.gethue.com](demo.gethue.com)
* [Tarball](https://cdn.gethue.com/downloads/hue-4.9.0.tgz) or [source](https://github.com/cloudera/hue/archive/release-4.9.0.zip)

</br>
</br>

Any feedback or question? Feel free to comment here or on the <a href="https://discourse.gethue.com/">Forum</a> and <a href="https://docs.gethue.com/quickstart/">quick start</a> SQL querying!


Onwards!

Romain from the Hue Team
