# This file was auto-generated by lib/tasks/web.rake

module Slack
  module Web
    module Api
      module Endpoints
        module Team
          #
          # Gets the access logs for the current team.
          #
          # @option options [Object] :before
          #   End of time range of logs to include in results (inclusive).
          # @see https://api.slack.com/methods/team.accessLogs
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/team/team.accessLogs.json
          def team_accessLogs(options = {})
            post('team.accessLogs', options)
          end

          #
          # Gets billable users information for the current team.
          #
          # @option options [user] :user
          #   A user to retrieve the billable information for. Defaults to all users.
          # @see https://api.slack.com/methods/team.billableInfo
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/team/team.billableInfo.json
          def team_billableInfo(options = {})
            options = options.merge(user: users_id(options)['user']['id']) if options[:user]
            post('team.billableInfo', options)
          end

          #
          # Gets information about the current team.
          #
          # @see https://api.slack.com/methods/team.info
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/team/team.info.json
          def team_info(options = {})
            post('team.info', options)
          end

          #
          # Gets the integration logs for the current team.
          #
          # @option options [Object] :app_id
          #   Filter logs to this Slack app. Defaults to all logs.
          # @option options [Object] :change_type
          #   Filter logs with this change type. Defaults to all logs.
          # @option options [Object] :service_id
          #   Filter logs to this service. Defaults to all logs.
          # @option options [user] :user
          #   Filter logs generated by this user's actions. Defaults to all logs.
          # @see https://api.slack.com/methods/team.integrationLogs
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/team/team.integrationLogs.json
          def team_integrationLogs(options = {})
            options = options.merge(user: users_id(options)['user']['id']) if options[:user]
            post('team.integrationLogs', options)
          end
        end
      end
    end
  end
end
