# This file was auto-generated by lib/tasks/web.rake

module Slack
  module Web
    module Api
      module Endpoints
        module FilesComments
          #
          # Add a comment to an existing file.
          #
          # @option options [Object] :comment
          #   Text of the comment to add.
          # @option options [file] :file
          #   File to add a comment to.
          # @see https://api.slack.com/methods/files.comments.add
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files.comments/files.comments.add.json
          def files_comments_add(options = {})
            throw ArgumentError.new('Required arguments :comment missing') if options[:comment].nil?
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            post('files.comments.add', options)
          end

          #
          # Deletes an existing comment on a file.
          #
          # @option options [file] :file
          #   File to delete a comment from.
          # @option options [Object] :id
          #   The comment to delete.
          # @see https://api.slack.com/methods/files.comments.delete
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files.comments/files.comments.delete.json
          def files_comments_delete(options = {})
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            throw ArgumentError.new('Required arguments :id missing') if options[:id].nil?
            post('files.comments.delete', options)
          end

          #
          # Edit an existing file comment.
          #
          # @option options [Object] :comment
          #   Text of the comment to edit.
          # @option options [file] :file
          #   File containing the comment to edit.
          # @option options [Object] :id
          #   The comment to edit.
          # @see https://api.slack.com/methods/files.comments.edit
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files.comments/files.comments.edit.json
          def files_comments_edit(options = {})
            throw ArgumentError.new('Required arguments :comment missing') if options[:comment].nil?
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            throw ArgumentError.new('Required arguments :id missing') if options[:id].nil?
            post('files.comments.edit', options)
          end
        end
      end
    end
  end
end
