# This file was auto-generated by lib/tasks/web.rake

module Slack
  module Web
    module Api
      module Endpoints
        module AppsPermissions
          #
          # Returns list of permissions this app has on a team.
          #
          # @see https://api.slack.com/methods/apps.permissions.info
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/apps.permissions/apps.permissions.info.json
          def apps_permissions_info(options = {})
            post('apps.permissions.info', options)
          end

          #
          # Allows an app to request additional scopes
          #
          # @option options [Object] :scopes
          #   A comma separated list of scopes to request for.
          # @option options [Object] :trigger_id
          #   Token used to trigger the permissions API.
          # @see https://api.slack.com/methods/apps.permissions.request
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/apps.permissions/apps.permissions.request.json
          def apps_permissions_request(options = {})
            throw ArgumentError.new('Required arguments :scopes missing') if options[:scopes].nil?
            throw ArgumentError.new('Required arguments :trigger_id missing') if options[:trigger_id].nil?
            post('apps.permissions.request', options)
          end
        end
      end
    end
  end
end
