# This file was auto-generated by lib/tasks/web.rake

desc 'Reminders methods.'
command 'reminders' do |g|
  g.desc 'This method creates a reminder.'
  g.long_desc %( This method creates a reminder. )
  g.command 'add' do |c|
    c.flag 'text', desc: 'The content of the reminder.'
    c.flag 'time', desc: 'When this reminder should happen: the Unix timestamp (up to five years from now), the number of seconds until the reminder (if within 24 hours), or a natural language description (Ex. "in 15 minutes," or "every Thursday").'
    c.flag 'user', desc: 'The user who will receive the reminder. If no user is specified, the reminder will go to user who created it.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.reminders_add(options))
    end
  end

  g.desc 'This method completes a reminder.'
  g.long_desc %( This method completes a reminder. )
  g.command 'complete' do |c|
    c.flag 'reminder', desc: 'The ID of the reminder to be marked as complete.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.reminders_complete(options))
    end
  end

  g.desc 'This method deletes a reminder.'
  g.long_desc %( This method deletes a reminder. )
  g.command 'delete' do |c|
    c.flag 'reminder', desc: 'The ID of the reminder.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.reminders_delete(options))
    end
  end

  g.desc 'This method returns information about a reminder.'
  g.long_desc %( This method returns information about a reminder. )
  g.command 'info' do |c|
    c.flag 'reminder', desc: 'The ID of the reminder.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.reminders_info(options))
    end
  end

  g.desc 'This method lists all reminders created by or for a given user.'
  g.long_desc %( This method lists all reminders created by or for a given user. )
  g.command 'list' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.reminders_list(options))
    end
  end
end
