# This file was auto-generated by lib/tasks/web.rake

desc 'Stars methods.'
command 'stars' do |g|
  g.desc 'This method adds a star to an item (message, file, file comment, channel, private group, or DM) on behalf of the authenticated user.'
  g.long_desc %( This method adds a star to an item (message, file, file comment, channel, private group, or DM) on behalf of the authenticated user. One of file, file_comment, channel, or the combination of channel and timestamp must be specified. )
  g.command 'add' do |c|
    c.flag 'file', desc: 'File to add star to.'
    c.flag 'file_comment', desc: 'File comment to add star to.'
    c.flag 'channel', desc: 'Channel to add star to, or channel where the message to add star to was posted (used with timestamp).'
    c.flag 'timestamp', desc: 'Timestamp of the message to add star to.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.stars_add(options))
    end
  end

  g.desc 'This method lists the items starred by the authed user.'
  g.long_desc %( This method lists the items starred by the authed user. )
  g.command 'list' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.stars_list(options))
    end
  end

  g.desc 'This method removes a star from an item (message, file, file comment, channel, private group, or DM) on behalf of the authenticated user.'
  g.long_desc %( This method removes a star from an item (message, file, file comment, channel, private group, or DM) on behalf of the authenticated user. One of file, file_comment, channel, or the combination of channel and timestamp must be specified. )
  g.command 'remove' do |c|
    c.flag 'file', desc: 'File to remove star from.'
    c.flag 'file_comment', desc: 'File comment to remove star from.'
    c.flag 'channel', desc: 'Channel to remove star from, or channel where the message to remove star from was posted (used with timestamp).'
    c.flag 'timestamp', desc: 'Timestamp of the message to remove star from.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.stars_remove(options))
    end
  end
end
