# This file was auto-generated by lib/tasks/web.rake

desc 'Pins methods.'
command 'pins' do |g|
  g.desc 'This method pins an item (file, file comment, channel message, or group message) to a particular channel.'
  g.long_desc %( This method pins an item (file, file comment, channel message, or group message) to a particular channel. The channel argument is required and one of file, file_comment, or timestamp must also be specified. )
  g.command 'add' do |c|
    c.flag 'channel', desc: 'Channel to pin the item in.'
    c.flag 'file', desc: 'File to pin.'
    c.flag 'file_comment', desc: 'File comment to pin.'
    c.flag 'timestamp', desc: 'Timestamp of the message to pin.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.pins_add(options))
    end
  end

  g.desc 'This method lists the items pinned to a channel.'
  g.long_desc %( This method lists the items pinned to a channel. )
  g.command 'list' do |c|
    c.flag 'channel', desc: 'Channel to get pinned items for.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.pins_list(options))
    end
  end

  g.desc 'This method un-pins an item (file, file comment, channel message, or group message) from a channel.'
  g.long_desc %( This method un-pins an item (file, file comment, channel message, or group message) from a channel. The channel argument is required and one of file, file_comment, or timestamp must also be specified. )
  g.command 'remove' do |c|
    c.flag 'channel', desc: 'Channel where the item is pinned to.'
    c.flag 'file', desc: 'File to un-pin.'
    c.flag 'file_comment', desc: 'File comment to un-pin.'
    c.flag 'timestamp', desc: 'Timestamp of the message to un-pin.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.pins_remove(options))
    end
  end
end
