# This file was auto-generated by lib/tasks/web.rake

desc "Get info on your team's private channels."
command 'groups' do |g|
  g.desc 'This method archives a private channel.'
  g.long_desc %( This method archives a private channel. )
  g.command 'archive' do |c|
    c.flag 'channel', desc: 'Private channel to archive.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_archive(options))
    end
  end

  g.desc 'This method closes a private channel.'
  g.long_desc %( This method closes a private channel. )
  g.command 'close' do |c|
    c.flag 'channel', desc: 'Private channel to close.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_close(options))
    end
  end

  g.desc 'This method creates a private channel.'
  g.long_desc %( This method creates a private channel. )
  g.command 'create' do |c|
    c.flag 'name', desc: 'Name of private channel to create.'
    c.flag 'validate', desc: 'Whether to return errors on invalid channel name instead of modifying it to meet the specified criteria.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_create(options))
    end
  end

  g.desc 'This method takes an existing private channel and performs the following steps:'
  g.long_desc %( This method takes an existing private channel and performs the following steps: )
  g.command 'createChild' do |c|
    c.flag 'channel', desc: 'Private channel to clone and archive.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_createChild(options))
    end
  end

  g.desc 'This method returns a portion of messages/events from the specified private channel.'
  g.long_desc %( This method returns a portion of messages/events from the specified private channel. To read the entire history for a private channel, call the method with no latest or oldest arguments, and then continue paging using the instructions below. )
  g.command 'history' do |c|
    c.flag 'channel', desc: 'Private channel to fetch history for.'
    c.flag 'latest', desc: 'End of time range of messages to include in results.'
    c.flag 'oldest', desc: 'Start of time range of messages to include in results.'
    c.flag 'inclusive', desc: 'Include messages with latest or oldest timestamp in results.'
    c.flag 'unreads', desc: 'Include unread_count_display in the output?.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_history(options))
    end
  end

  g.desc 'This method returns information about a private channel.'
  g.long_desc %( This method returns information about a private channel. )
  g.command 'info' do |c|
    c.flag 'channel', desc: 'Private channel to get info on.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_info(options))
    end
  end

  g.desc 'This method is used to invite a user to a private channel. The calling user must be a member of the private channel.'
  g.long_desc %( This method is used to invite a user to a private channel. The calling user must be a member of the private channel. )
  g.command 'invite' do |c|
    c.flag 'channel', desc: 'Private channel to invite user to.'
    c.flag 'user', desc: 'User to invite.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_invite(options))
    end
  end

  g.desc 'This method allows a user to remove another member from a private channel.'
  g.long_desc %( This method allows a user to remove another member from a private channel. )
  g.command 'kick' do |c|
    c.flag 'channel', desc: 'Private channel to remove user from.'
    c.flag 'user', desc: 'User to remove from private channel.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_kick(options))
    end
  end

  g.desc 'This method is used to leave a private channel.'
  g.long_desc %( This method is used to leave a private channel. )
  g.command 'leave' do |c|
    c.flag 'channel', desc: 'Private channel to leave.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_leave(options))
    end
  end

  g.desc 'This method returns a list of private channels in the team that the caller is in and archived groups that the caller was in.'
  g.long_desc %( This method returns a list of private channels in the team that the caller is in and archived groups that the caller was in. The list of (non-deactivated) members in each private channel is also returned. )
  g.command 'list' do |c|
    c.flag 'exclude_archived', desc: "Don't return archived private channels."
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_list(options))
    end
  end

  g.desc 'This method moves the read cursor in a private channel.'
  g.long_desc %( This method moves the read cursor in a private channel. )
  g.command 'mark' do |c|
    c.flag 'channel', desc: 'Private channel to set reading cursor in.'
    c.flag 'ts', desc: 'Timestamp of the most recently seen message.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_mark(options))
    end
  end

  g.desc 'This method opens a private channel.'
  g.long_desc %( This method opens a private channel. )
  g.command 'open' do |c|
    c.flag 'channel', desc: 'Private channel to open.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_open(options))
    end
  end

  g.desc 'This method renames a private channel.'
  g.long_desc %( This method renames a private channel. )
  g.command 'rename' do |c|
    c.flag 'channel', desc: 'Private channel to rename.'
    c.flag 'name', desc: 'New name for private channel.'
    c.flag 'validate', desc: 'Whether to return errors on invalid channel name instead of modifying it to meet the specified criteria.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_rename(options))
    end
  end

  g.desc 'This method returns an entire thread (a message plus all the messages in reply to it).'
  g.long_desc %( This method returns an entire thread (a message plus all the messages in reply to it). )
  g.command 'replies' do |c|
    c.flag 'channel', desc: 'Private channel to fetch thread from.'
    c.flag 'thread_ts', desc: "Unique identifier of a thread's parent message."
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_replies(options))
    end
  end

  g.desc 'This method is used to change the purpose of a private channel. The calling user must be a member of the private channel.'
  g.long_desc %( This method is used to change the purpose of a private channel. The calling user must be a member of the private channel. )
  g.command 'setPurpose' do |c|
    c.flag 'channel', desc: 'Private channel to set the purpose of.'
    c.flag 'purpose', desc: 'The new purpose.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_setPurpose(options))
    end
  end

  g.desc 'This method is used to change the topic of a private channel. The calling user must be a member of the private channel.'
  g.long_desc %( This method is used to change the topic of a private channel. The calling user must be a member of the private channel. )
  g.command 'setTopic' do |c|
    c.flag 'channel', desc: 'Private channel to set the topic of.'
    c.flag 'topic', desc: 'The new topic.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_setTopic(options))
    end
  end

  g.desc 'This method unarchives a private channel.'
  g.long_desc %( This method unarchives a private channel. )
  g.command 'unarchive' do |c|
    c.flag 'channel', desc: 'Private channel to unarchive.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_unarchive(options))
    end
  end

  g.desc 'This method returns the ID of a group.'
  g.long_desc %( This method returns the ID of a group. )
  g.command 'id' do |c|
    c.flag 'channel', desc: 'Group channel to get ID for, prefixed with #.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.groups_id(options))
    end
  end
end
