# This file was auto-generated by lib/tasks/web.rake

module Slack
  module Web
    module Api
      module Endpoints
        module Reactions
          #
          # This method adds a reaction (emoji) to an item (file, file comment, channel message, group message, or direct message).
          # One of file, file_comment, or the combination of channel and timestamp must be specified.
          #
          # @option options [Object] :name
          #   Reaction (emoji) name.
          # @option options [file] :file
          #   File to add reaction to.
          # @option options [Object] :file_comment
          #   File comment to add reaction to.
          # @option options [channel] :channel
          #   Channel where the message to add reaction to was posted.
          # @option options [Object] :timestamp
          #   Timestamp of the message to add reaction to.
          # @see https://api.slack.com/methods/reactions.add
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/reactions/reactions.add.json
          def reactions_add(options = {})
            throw ArgumentError.new('Required arguments :name missing') if options[:name].nil?
            options = options.merge(channel: channels_id(options)['channel']['id']) if options[:channel]
            post('reactions.add', options)
          end

          #
          # This method returns a list of all reactions for a single item (file, file comment, channel message, group message, or direct message).
          #
          # @option options [file] :file
          #   File to get reactions for.
          # @option options [Object] :file_comment
          #   File comment to get reactions for.
          # @option options [channel] :channel
          #   Channel where the message to get reactions for was posted.
          # @option options [Object] :timestamp
          #   Timestamp of the message to get reactions for.
          # @option options [Object] :full
          #   If true always return the complete reaction list.
          # @see https://api.slack.com/methods/reactions.get
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/reactions/reactions.get.json
          def reactions_get(options = {})
            options = options.merge(channel: channels_id(options)['channel']['id']) if options[:channel]
            post('reactions.get', options)
          end

          #
          # This method returns a list of all items (file, file comment, channel message, group message, or direct message) reacted to by a user.
          #
          # @option options [user] :user
          #   Show reactions made by this user. Defaults to the authed user.
          # @option options [Object] :full
          #   If true always return the complete reaction list.
          # @see https://api.slack.com/methods/reactions.list
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/reactions/reactions.list.json
          def reactions_list(options = {})
            options = options.merge(user: users_id(options)['user']['id']) if options[:user]
            post('reactions.list', options)
          end

          #
          # This method removes a reaction (emoji) from an item (file, file comment, channel message, group message, or direct message).
          # One of file, file_comment, or the combination of channel and timestamp must be specified.
          #
          # @option options [Object] :name
          #   Reaction (emoji) name.
          # @option options [file] :file
          #   File to remove reaction from.
          # @option options [Object] :file_comment
          #   File comment to remove reaction from.
          # @option options [channel] :channel
          #   Channel where the message to remove reaction from was posted.
          # @option options [Object] :timestamp
          #   Timestamp of the message to remove reaction from.
          # @see https://api.slack.com/methods/reactions.remove
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/reactions/reactions.remove.json
          def reactions_remove(options = {})
            throw ArgumentError.new('Required arguments :name missing') if options[:name].nil?
            options = options.merge(channel: channels_id(options)['channel']['id']) if options[:channel]
            post('reactions.remove', options)
          end
        end
      end
    end
  end
end
