# This file was auto-generated by lib/tasks/web.rake

desc 'Adjust and view Do Not Disturb settings for team members.'
command 'dnd' do |g|
  g.desc "Ends the user's currently scheduled Do Not Disturb session immediately."
  g.long_desc %( Ends the user's currently scheduled Do Not Disturb session immediately. )
  g.command 'endDnd' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.dnd_endDnd(options))
    end
  end

  g.desc "Ends the current user's snooze mode immediately."
  g.long_desc %( Ends the current user's snooze mode immediately. )
  g.command 'endSnooze' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.dnd_endSnooze(options))
    end
  end

  g.desc "Provides information about a user's current Do Not Disturb settings."
  g.long_desc %( Provides information about a user's current Do Not Disturb settings. )
  g.command 'info' do |c|
    c.flag 'user', desc: 'User to fetch status for (defaults to current user).'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.dnd_info(options))
    end
  end

  g.desc "Adjusts the snooze duration for a user's Do Not Disturb settings. If a snooze session is not already active for the user, invoking this method will begin one for the specified duration."
  g.long_desc %( Adjusts the snooze duration for a user's Do Not Disturb settings. If a snooze session is not already active for the user, invoking this method will begin one for the specified duration. )
  g.command 'setSnooze' do |c|
    c.flag 'num_minutes', desc: 'Number of minutes, from now, to snooze until.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.dnd_setSnooze(options))
    end
  end

  g.desc 'Provides information about the current Do Not Disturb settings for users of a Slack team.'
  g.long_desc %( Provides information about the current Do Not Disturb settings for users of a Slack team. )
  g.command 'teamInfo' do |c|
    c.flag 'users', desc: 'Comma-separated list of users to fetch Do Not Disturb status for.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.dnd_teamInfo(options))
    end
  end
end
