# This file was auto-generated by lib/tasks/web.rake

desc "Get info on your team's User Groups."
command 'usergroups' do |g|
  g.desc 'This method is used to create a User Group.'
  g.long_desc %( This method is used to create a User Group. )
  g.command 'create' do |c|
    c.flag 'name', desc: 'A name for the User Group. Must be unique among User Groups.'
    c.flag 'handle', desc: 'A mention handle. Must be unique among channels, users and User Groups.'
    c.flag 'description', desc: 'A short description of the User Group.'
    c.flag 'channels', desc: 'A comma separated string of encoded channel IDs for which the User Group uses as a default.'
    c.flag 'include_count', desc: 'Include the number of users in each User Group.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.usergroups_create(options))
    end
  end

  g.desc 'This method disables an existing User Group.'
  g.long_desc %( This method disables an existing User Group. )
  g.command 'disable' do |c|
    c.flag 'usergroup', desc: 'The encoded ID of the User Group to disable.'
    c.flag 'include_count', desc: 'Include the number of users in the User Group.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.usergroups_disable(options))
    end
  end

  g.desc 'This method enables a User Group which was previously disabled.'
  g.long_desc %( This method enables a User Group which was previously disabled. )
  g.command 'enable' do |c|
    c.flag 'usergroup', desc: 'The encoded ID of the User Group to enable.'
    c.flag 'include_count', desc: 'Include the number of users in the User Group.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.usergroups_enable(options))
    end
  end

  g.desc 'This method returns a list of all User Groups in the team. This can optionally include disabled User Groups.'
  g.long_desc %( This method returns a list of all User Groups in the team. This can optionally include disabled User Groups. )
  g.command 'list' do |c|
    c.flag 'include_disabled', desc: 'Include disabled User Groups.'
    c.flag 'include_count', desc: 'Include the number of users in each User Group.'
    c.flag 'include_users', desc: 'Include the list of users for each User Group.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.usergroups_list(options))
    end
  end

  g.desc 'This method updates the properties of an existing User Group.'
  g.long_desc %( This method updates the properties of an existing User Group. )
  g.command 'update' do |c|
    c.flag 'usergroup', desc: 'The encoded ID of the User Group to update.'
    c.flag 'name', desc: 'A name for the User Group. Must be unique among User Groups.'
    c.flag 'handle', desc: 'A mention handle. Must be unique among channels, users and User Groups.'
    c.flag 'description', desc: 'A short description of the User Group.'
    c.flag 'channels', desc: 'A comma separated string of encoded channel IDs for which the User Group uses as a default.'
    c.flag 'include_count', desc: 'Include the number of users in the User Group.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.usergroups_update(options))
    end
  end
end
