# This file was auto-generated by lib/tasks/web.rake

module Slack
  module Web
    module Api
      module Endpoints
        module Files
          #
          # This method deletes a file from your team.
          #
          # @option options [file] :file
          #   ID of file to delete.
          # @see https://api.slack.com/methods/files.delete
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files/files.delete.json
          def files_delete(options = {})
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            post('files.delete', options)
          end

          #
          # This method returns information about a file in your team.
          #
          # @option options [file] :file
          #   Specify a file by providing its ID.
          # @see https://api.slack.com/methods/files.info
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files/files.info.json
          def files_info(options = {})
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            post('files.info', options)
          end

          #
          # This method returns a list of files within the team. It can be filtered and sliced in various ways.
          #
          # @option options [user] :user
          #   Filter files created by a single user.
          # @option options [channel] :channel
          #   Filter files appearing in a specific channel, indicated by its ID.
          # @option options [Object] :ts_from
          #   Filter files created after this timestamp (inclusive).
          # @option options [Object] :ts_to
          #   Filter files created before this timestamp (inclusive).
          # @option options [Object] :types
          #   Filter files by type:
          #
          #   all - All files
          #   spaces - Posts
          #   snippets - Snippets
          #   images - Image files
          #   gdocs - Google docs
          #   zips - Zip files
          #   pdfs - PDF files
          #
          #
          #   You can pass multiple values in the types argument, like types=spaces,snippets.The default value is all, which does not filter the list.
          #   .
          # @see https://api.slack.com/methods/files.list
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files/files.list.json
          def files_list(options = {})
            options = options.merge(channel: channels_id(options)['channel']['id']) if options[:channel]
            options = options.merge(user: users_id(options)['user']['id']) if options[:user]
            post('files.list', options)
          end

          #
          # This method disables public/external sharing for a file.
          #
          # @option options [file] :file
          #   File to revoke.
          # @see https://api.slack.com/methods/files.revokePublicURL
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files/files.revokePublicURL.json
          def files_revokePublicURL(options = {})
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            post('files.revokePublicURL', options)
          end

          #
          # This method enables public/external sharing for a file.
          #
          # @option options [file] :file
          #   File to share.
          # @see https://api.slack.com/methods/files.sharedPublicURL
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files/files.sharedPublicURL.json
          def files_sharedPublicURL(options = {})
            throw ArgumentError.new('Required arguments :file missing') if options[:file].nil?
            post('files.sharedPublicURL', options)
          end

          #
          # This method allows you to create or upload an existing file.
          #
          # @option options [file] :file
          #   File contents via multipart/form-data. If omitting this parameter, you must submit content.
          # @option options [Object] :content
          #   File contents via a POST variable. If omitting this parameter, you must provide a file.
          # @option options [Object] :filetype
          #   A file type identifier.
          # @option options [Object] :filename
          #   Filename of file.
          # @option options [Object] :title
          #   Title of file.
          # @option options [Object] :initial_comment
          #   Initial comment to add to file.
          # @option options [Object] :channels
          #   Comma-separated list of channel names or IDs where the file will be shared.
          # @see https://api.slack.com/methods/files.upload
          # @see https://github.com/dblock/slack-api-ref/blob/master/methods/files/files.upload.json
          def files_upload(options = {})
            throw ArgumentError.new('Required arguments :filename missing') if options[:filename].nil?
            post('files.upload', options)
          end
        end
      end
    end
  end
end
