# This file was auto-generated by lib/tasks/web.rake

desc 'Get info on members of your Slack team.'
command 'users' do |g|
  g.desc 'This method allows the user to delete their profile image. It will clear whatever image is currently set.'
  g.long_desc %( This method allows the user to delete their profile image. It will clear whatever image is currently set. )
  g.command 'deletePhoto' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_deletePhoto(options))
    end
  end

  g.desc "This method lets you find out information about a user's presence."
  g.long_desc %( This method lets you find out information about a user's presence. Consult the presence documentation for more details. )
  g.command 'getPresence' do |c|
    c.flag 'user', desc: 'User to get presence info on. Defaults to the authed user.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_getPresence(options))
    end
  end

  g.desc "After your Slack app is awarded an identity token through Sign in with Slack, use this method to retrieve a user's identity."
  g.long_desc %( After your Slack app is awarded an identity token through Sign in with Slack, use this method to retrieve a user's identity. )
  g.command 'identity' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_identity(options))
    end
  end

  g.desc 'This method returns information about a team member.'
  g.long_desc %( This method returns information about a team member. )
  g.command 'info' do |c|
    c.flag 'user', desc: 'User to get info on.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_info(options))
    end
  end

  g.desc 'This method returns a list of all users in the team. This includes deleted/deactivated users.'
  g.long_desc %( This method returns a list of all users in the team. This includes deleted/deactivated users. )
  g.command 'list' do |c|
    c.flag 'presence', desc: 'Whether to include presence data in the output.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_list(options))
    end
  end

  g.desc 'This method lets the slack messaging server know that the authenticated user'
  g.long_desc %( This method lets the slack messaging server know that the authenticated user is currently active. Consult the presence documentation for more details. )
  g.command 'setActive' do |c|
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_setActive(options))
    end
  end

  g.desc 'This method allows the user to set their profile image. The caller can pass image data via image.'
  g.long_desc %( This method allows the user to set their profile image. The caller can pass image data via image. )
  g.command 'setPhoto' do |c|
    c.flag 'image', desc: 'File contents via multipart/form-data.'
    c.flag 'crop_x', desc: 'X coordinate of top-left corner of crop box.'
    c.flag 'crop_y', desc: 'Y coordinate of top-left corner of crop box.'
    c.flag 'crop_w', desc: 'Width/height of crop box (always square).'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_setPhoto(options))
    end
  end

  g.desc "This method lets you set the calling user's manual presence."
  g.long_desc %( This method lets you set the calling user's manual presence. Consult the presence documentation for more details. )
  g.command 'setPresence' do |c|
    c.flag 'presence', desc: 'Either auto or away.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_setPresence(options))
    end
  end

  g.desc 'This method returns the ID of a team user.'
  g.long_desc %( This method returns the ID of a team user. )
  g.command 'id' do |c|
    c.flag 'user', desc: 'User to get ID for, prefixed with @.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_id(options))
    end
  end

  g.desc 'This method searches for users.'
  g.long_desc %( This method searches for users. )
  g.command 'search' do |c|
    c.flag 'user', desc: 'User to search for.'
    c.action do |_global_options, options, _args|
      puts JSON.dump($client.users_search(options))
    end
  end
end
