# Author: Nic Wolfe <nic@wolfeden.ca>
# URL: http://code.google.com/p/sickbeard/
#
# This file is part of SickRage.
#
# SickRage is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SickRage is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SickRage.  If not, see <http://www.gnu.org/licenses/>.

from sickbeard import helpers
from sickbeard import logger
import requests

meta_session = requests.Session()
def getShowImage(url, imgNum=None):
    image_data = None  # @UnusedVariable

    if url == None:
        return None

    # if they provided a fanart number try to use it instead
    if imgNum != None:
        tempURL = url.split('-')[0] + "-" + str(imgNum) + ".jpg"
    else:
        tempURL = url

    logger.log(u"Fetching image from " + tempURL, logger.DEBUG)

    image_data = helpers.getURL(tempURL, session=meta_session)
    if image_data is None:
        logger.log(u"There was an error trying to retrieve the image, aborting", logger.WARNING)
        return

    return image_data
