# Icon library

October provides an icon library with icons of various descriptions, based on the popular [Font Awesome collection](http://fortawesome.github.io/Font-Awesome/).

### Inline icons

Place icons just about anywhere with the `<i>` tag or to an existing element using the `oc-` prefix.

```html
<i class="icon-camera-retro"></i> icon-camera-retro

<span class="oc-icon-flag-checkered">oc-icon-flag-checkered</span>
```

<div class="frame" style="font-size: 22px;">
    <i class="icon-camera-retro"></i> icon-camera-retro
    <br />
    <span class="oc-icon-flag-checkered">oc-icon-flag-checkered</span>
</div>

### Icon sizes

To increase icon sizes relative to their container, use the `icon-lg` (33% increase), `icon-2x`, `icon-3x`, `icon-4x`, or `icon-5x` classes.

    <i class="icon-camera-retro icon-5x"></i> icon-5x
    <i class="icon-camera-retro icon-4x"></i> icon-4x
    <i class="icon-camera-retro icon-3x"></i> icon-3x
    <i class="icon-camera-retro icon-2x"></i> icon-2x
    <i class="icon-camera-retro icon-lg"></i> icon-lg

### Icon buttons

Feel free to use them alongside your buttons.

    <a class="btn btn-default oc-icon-refresh" href="#">
        Refresh
    </a>
    <a class="btn btn-success oc-icon-shopping" href="#">
        Checkout
    </a>
    <a class="btn btn-primary oc-icon-comment" href="#">
        Comment
    </a>
    <a class="btn btn-danger oc-icon-trash" href="#">
        Delete
    </a>
    <a class="btn btn-default oc-icon-cog" href="#">
        Settings
    </a>
    <a class="btn btn-info oc-icon-info" href="#">
        More Info
    </a>

## Available icons

### Web Application Icons

<div class="category-icons">
<ul>
    <li><i class="icon-adjust"></i> icon-adjust</li>
    <li><i class="icon-american-sign-language-interpreting"></i> icon-american-sign-language-interpreting</li>
    <li><i class="icon-anchor"></i> icon-anchor</li>
    <li><i class="icon-archive"></i> icon-archive</li>
    <li><i class="icon-area-chart"></i> icon-area-chart</li>
    <li><i class="icon-arrows"></i> icon-arrows</li>
    <li><i class="icon-arrows-h"></i> icon-arrows-h</li>
    <li><i class="icon-arrows-v"></i> icon-arrows-v</li>
    <li><i class="icon-assistive-listening-systems"></i> icon-assistive-listening-systems</li>
    <li><i class="icon-asterisk"></i> icon-asterisk</li>
    <li><i class="icon-at"></i> icon-at</li>
    <li><i class="icon-audio-description"></i> icon-audio-description</li>
    <li><i class="icon-balance-scale"></i> icon-balance-scale</li>
    <li><i class="icon-ban"></i> icon-ban</li>
    <li><i class="icon-bar-chart"></i> icon-bar-chart</li>
    <li><i class="icon-barcode"></i> icon-barcode</li>
    <li><i class="icon-bars"></i> icon-bars</li>
    <li><i class="icon-battery-empty"></i> icon-battery-empty</li>
    <li><i class="icon-battery-full"></i> icon-battery-full</li>
    <li><i class="icon-battery-half"></i> icon-battery-half</li>
    <li><i class="icon-battery-quarter"></i> icon-battery-quarter</li>
    <li><i class="icon-battery-three-quarters"></i> icon-battery-three-quarters</li>
    <li><i class="icon-bed"></i> icon-bed</li>
    <li><i class="icon-beer"></i> icon-beer</li>
    <li><i class="icon-bell"></i> icon-bell</li>
    <li><i class="icon-bell-o"></i> icon-bell-o</li>
    <li><i class="icon-bell-slash"></i> icon-bell-slash</li>
    <li><i class="icon-bell-slash-o"></i> icon-bell-slash-o</li>
    <li><i class="icon-bicycle"></i> icon-bicycle</li>
    <li><i class="icon-binoculars"></i> icon-binoculars</li>
    <li><i class="icon-birthday-cake"></i> icon-birthday-cake</li>
    <li><i class="icon-blind"></i> icon-blind</li>
    <li><i class="icon-bluetooth"></i> icon-bluetooth</li>
    <li><i class="icon-bluetooth-b"></i> icon-bluetooth-b</li>
    <li><i class="icon-bolt"></i> icon-bolt</li>
    <li><i class="icon-bomb"></i> icon-bomb</li>
    <li><i class="icon-book"></i> icon-book</li>
    <li><i class="icon-bookmark"></i> icon-bookmark</li>
    <li><i class="icon-bookmark-o"></i> icon-bookmark-o</li>
    <li><i class="icon-braille"></i> icon-braille</li>
    <li><i class="icon-briefcase"></i> icon-briefcase</li>
    <li><i class="icon-bug"></i> icon-bug</li>
    <li><i class="icon-building"></i> icon-building</li>
    <li><i class="icon-building-o"></i> icon-building-o</li>
    <li><i class="icon-bullhorn"></i> icon-bullhorn</li>
    <li><i class="icon-bullseye"></i> icon-bullseye</li>
    <li><i class="icon-bus"></i> icon-bus</li>
    <li><i class="icon-calculator"></i> icon-calculator</li>
    <li><i class="icon-calendar"></i> icon-calendar</li>
    <li><i class="icon-calendar-check-o"></i> icon-calendar-check-o</li>
    <li><i class="icon-calendar-minus-o"></i> icon-calendar-minus-o</li>
    <li><i class="icon-calendar-o"></i> icon-calendar-o</li>
    <li><i class="icon-calendar-plus-o"></i> icon-calendar-plus-o</li>
    <li><i class="icon-calendar-times-o"></i> icon-calendar-times-o</li>
    <li><i class="icon-camera"></i> icon-camera</li>
    <li><i class="icon-camera-retro"></i> icon-camera-retro</li>
    <li><i class="icon-car"></i> icon-car</li>
    <li><i class="icon-caret-square-o-down"></i> icon-caret-square-o-down</li>
    <li><i class="icon-caret-square-o-left"></i> icon-caret-square-o-left</li>
    <li><i class="icon-caret-square-o-right"></i> icon-caret-square-o-right</li>
    <li><i class="icon-caret-square-o-up"></i> icon-caret-square-o-up</li>
    <li><i class="icon-cart-arrow-down"></i> icon-cart-arrow-down</li>
    <li><i class="icon-cart-plus"></i> icon-cart-plus</li>
    <li><i class="icon-cc"></i> icon-cc</li>
    <li><i class="icon-certificate"></i> icon-certificate</li>
    <li><i class="icon-check"></i> icon-check</li>
    <li><i class="icon-check-circle"></i> icon-check-circle</li>
    <li><i class="icon-check-circle-o"></i> icon-check-circle-o</li>
    <li><i class="icon-check-square"></i> icon-check-square</li>
    <li><i class="icon-check-square-o"></i> icon-check-square-o</li>
    <li><i class="icon-child"></i> icon-child</li>
    <li><i class="icon-circle"></i> icon-circle</li>
    <li><i class="icon-circle-o"></i> icon-circle-o</li>
    <li><i class="icon-circle-o-notch"></i> icon-circle-o-notch</li>
    <li><i class="icon-circle-thin"></i> icon-circle-thin</li>
    <li><i class="icon-clock-o"></i> icon-clock-o</li>
    <li><i class="icon-clone"></i> icon-clone</li>
    <li><i class="icon-cloud"></i> icon-cloud</li>
    <li><i class="icon-cloud-download"></i> icon-cloud-download</li>
    <li><i class="icon-cloud-upload"></i> icon-cloud-upload</li>
    <li><i class="icon-code"></i> icon-code</li>
    <li><i class="icon-code-fork"></i> icon-code-fork</li>
    <li><i class="icon-coffee"></i> icon-coffee</li>
    <li><i class="icon-cog"></i> icon-cog</li>
    <li><i class="icon-cogs"></i> icon-cogs</li>
    <li><i class="icon-comment"></i> icon-comment</li>
    <li><i class="icon-comment-o"></i> icon-comment-o</li>
</ul>
<ul>
    <li><i class="icon-commenting"></i> icon-commenting</li>
    <li><i class="icon-commenting-o"></i> icon-commenting-o</li>
    <li><i class="icon-comments"></i> icon-comments</li>
    <li><i class="icon-comments-o"></i> icon-comments-o</li>
    <li><i class="icon-compass"></i> icon-compass</li>
    <li><i class="icon-copyright"></i> icon-copyright</li>
    <li><i class="icon-creative-commons"></i> icon-creative-commons</li>
    <li><i class="icon-credit-card"></i> icon-credit-card</li>
    <li><i class="icon-credit-card-alt"></i> icon-credit-card-alt</li>
    <li><i class="icon-crop"></i> icon-crop</li>
    <li><i class="icon-crosshairs"></i> icon-crosshairs</li>
    <li><i class="icon-cube"></i> icon-cube</li>
    <li><i class="icon-cubes"></i> icon-cubes</li>
    <li><i class="icon-cutlery"></i> icon-cutlery</li>
    <li><i class="icon-database"></i> icon-database</li>
    <li><i class="icon-deaf"></i> icon-deaf</li>
    <li><i class="icon-desktop"></i> icon-desktop</li>
    <li><i class="icon-diamond"></i> icon-diamond</li>
    <li><i class="icon-dot-circle-o"></i> icon-dot-circle-o</li>
    <li><i class="icon-download"></i> icon-download</li>
    <li><i class="icon-ellipsis-h"></i> icon-ellipsis-h</li>
    <li><i class="icon-ellipsis-v"></i> icon-ellipsis-v</li>
    <li><i class="icon-envelope"></i> icon-envelope</li>
    <li><i class="icon-envelope-o"></i> icon-envelope-o</li>
    <li><i class="icon-envelope-square"></i> icon-envelope-square</li>
    <li><i class="icon-eraser"></i> icon-eraser</li>
    <li><i class="icon-exchange"></i> icon-exchange</li>
    <li><i class="icon-exclamation"></i> icon-exclamation</li>
    <li><i class="icon-exclamation-circle"></i> icon-exclamation-circle</li>
    <li><i class="icon-exclamation-triangle"></i> icon-exclamation-triangle</li>
    <li><i class="icon-external-link"></i> icon-external-link</li>
    <li><i class="icon-external-link-square"></i> icon-external-link-square</li>
    <li><i class="icon-eye"></i> icon-eye</li>
    <li><i class="icon-eye-slash"></i> icon-eye-slash</li>
    <li><i class="icon-eyedropper"></i> icon-eyedropper</li>
    <li><i class="icon-fax"></i> icon-fax</li>
    <li><i class="icon-female"></i> icon-female</li>
    <li><i class="icon-fighter-jet"></i> icon-fighter-jet</li>
    <li><i class="icon-file-archive-o"></i> icon-file-archive-o</li>
    <li><i class="icon-file-audio-o"></i> icon-file-audio-o</li>
    <li><i class="icon-file-code-o"></i> icon-file-code-o</li>
    <li><i class="icon-file-excel-o"></i> icon-file-excel-o</li>
    <li><i class="icon-file-image-o"></i> icon-file-image-o</li>
    <li><i class="icon-file-pdf-o"></i> icon-file-pdf-o</li>
    <li><i class="icon-file-powerpoint-o"></i> icon-file-powerpoint-o</li>
    <li><i class="icon-file-video-o"></i> icon-file-video-o</li>
    <li><i class="icon-file-word-o"></i> icon-file-word-o</li>
    <li><i class="icon-film"></i> icon-film</li>
    <li><i class="icon-filter"></i> icon-filter</li>
    <li><i class="icon-fire"></i> icon-fire</li>
    <li><i class="icon-fire-extinguisher"></i> icon-fire-extinguisher</li>
    <li><i class="icon-flag"></i> icon-flag</li>
    <li><i class="icon-flag-checkered"></i> icon-flag-checkered</li>
    <li><i class="icon-flag-o"></i> icon-flag-o</li>
    <li><i class="icon-flask"></i> icon-flask</li>
    <li><i class="icon-folder"></i> icon-folder</li>
    <li><i class="icon-folder-o"></i> icon-folder-o</li>
    <li><i class="icon-folder-open"></i> icon-folder-open</li>
    <li><i class="icon-folder-open-o"></i> icon-folder-open-o</li>
    <li><i class="icon-frown-o"></i> icon-frown-o</li>
    <li><i class="icon-futbol-o"></i> icon-futbol-o</li>
    <li><i class="icon-gamepad"></i> icon-gamepad</li>
    <li><i class="icon-gavel"></i> icon-gavel</li>
    <li><i class="icon-gift"></i> icon-gift</li>
    <li><i class="icon-glass"></i> icon-glass</li>
    <li><i class="icon-globe"></i> icon-globe</li>
    <li><i class="icon-graduation-cap"></i> icon-graduation-cap</li>
    <li><i class="icon-hand-lizard-o"></i> icon-hand-lizard-o</li>
    <li><i class="icon-hand-paper-o"></i> icon-hand-paper-o</li>
    <li><i class="icon-hand-peace-o"></i> icon-hand-peace-o</li>
    <li><i class="icon-hand-pointer-o"></i> icon-hand-pointer-o</li>
    <li><i class="icon-hand-rock-o"></i> icon-hand-rock-o</li>
    <li><i class="icon-hand-scissors-o"></i> icon-hand-scissors-o</li>
    <li><i class="icon-hand-spock-o"></i> icon-hand-spock-o</li>
    <li><i class="icon-hashtag"></i> icon-hashtag</li>
    <li><i class="icon-hdd-o"></i> icon-hdd-o</li>
    <li><i class="icon-headphones"></i> icon-headphones</li>
    <li><i class="icon-heart"></i> icon-heart</li>
    <li><i class="icon-heart-o"></i> icon-heart-o</li>
    <li><i class="icon-heartbeat"></i> icon-heartbeat</li>
    <li><i class="icon-history"></i> icon-history</li>
    <li><i class="icon-home"></i> icon-home</li>
    <li><i class="icon-hourglass"></i> icon-hourglass</li>
    <li><i class="icon-hourglass-end"></i> icon-hourglass-end</li>
    <li><i class="icon-hourglass-half"></i> icon-hourglass-half</li>
    <li><i class="icon-hourglass-o"></i> icon-hourglass-o</li>
    <li><i class="icon-hourglass-start"></i> icon-hourglass-start</li>
</ul>
<ul>
    <li><i class="icon-i-cursor"></i> icon-i-cursor</li>
    <li><i class="icon-inbox"></i> icon-inbox</li>
    <li><i class="icon-industry"></i> icon-industry</li>
    <li><i class="icon-info"></i> icon-info</li>
    <li><i class="icon-info-circle"></i> icon-info-circle</li>
    <li><i class="icon-key"></i> icon-key</li>
    <li><i class="icon-keyboard-o"></i> icon-keyboard-o</li>
    <li><i class="icon-language"></i> icon-language</li>
    <li><i class="icon-laptop"></i> icon-laptop</li>
    <li><i class="icon-leaf"></i> icon-leaf</li>
    <li><i class="icon-lemon-o"></i> icon-lemon-o</li>
    <li><i class="icon-level-down"></i> icon-level-down</li>
    <li><i class="icon-level-up"></i> icon-level-up</li>
    <li><i class="icon-life-ring"></i> icon-life-ring</li>
    <li><i class="icon-lightbulb-o"></i> icon-lightbulb-o</li>
    <li><i class="icon-line-chart"></i> icon-line-chart</li>
    <li><i class="icon-location-arrow"></i> icon-location-arrow</li>
    <li><i class="icon-lock"></i> icon-lock</li>
    <li><i class="icon-low-vision"></i> icon-low-vision</li>
    <li><i class="icon-magic"></i> icon-magic</li>
    <li><i class="icon-magnet"></i> icon-magnet</li>
    <li><i class="icon-male"></i> icon-male</li>
    <li><i class="icon-map"></i> icon-map</li>
    <li><i class="icon-map-marker"></i> icon-map-marker</li>
    <li><i class="icon-map-o"></i> icon-map-o</li>
    <li><i class="icon-map-pin"></i> icon-map-pin</li>
    <li><i class="icon-map-signs"></i> icon-map-signs</li>
    <li><i class="icon-meh-o"></i> icon-meh-o</li>
    <li><i class="icon-microphone"></i> icon-microphone</li>
    <li><i class="icon-microphone-slash"></i> icon-microphone-slash</li>
    <li><i class="icon-minus"></i> icon-minus</li>
    <li><i class="icon-minus-circle"></i> icon-minus-circle</li>
    <li><i class="icon-minus-square"></i> icon-minus-square</li>
    <li><i class="icon-minus-square-o"></i> icon-minus-square-o</li>
    <li><i class="icon-mobile"></i> icon-mobile</li>
    <li><i class="icon-money"></i> icon-money</li>
    <li><i class="icon-moon-o"></i> icon-moon-o</li>
    <li><i class="icon-motorcycle"></i> icon-motorcycle</li>
    <li><i class="icon-mouse-pointer"></i> icon-mouse-pointer</li>
    <li><i class="icon-music"></i> icon-music</li>
    <li><i class="icon-newspaper-o"></i> icon-newspaper-o</li>
    <li><i class="icon-object-group"></i> icon-object-group</li>
    <li><i class="icon-object-ungroup"></i> icon-object-ungroup</li>
    <li><i class="icon-paint-brush"></i> icon-paint-brush</li>
    <li><i class="icon-paper-plane"></i> icon-paper-plane</li>
    <li><i class="icon-paper-plane-o"></i> icon-paper-plane-o</li>
    <li><i class="icon-paw"></i> icon-paw</li>
    <li><i class="icon-pencil"></i> icon-pencil</li>
    <li><i class="icon-pencil-square"></i> icon-pencil-square</li>
    <li><i class="icon-pencil-square-o"></i> icon-pencil-square-o</li>
    <li><i class="icon-percent"></i> icon-percent</li>
    <li><i class="icon-phone"></i> icon-phone</li>
    <li><i class="icon-phone-square"></i> icon-phone-square</li>
    <li><i class="icon-picture-o"></i> icon-picture-o</li>
    <li><i class="icon-pie-chart"></i> icon-pie-chart</li>
    <li><i class="icon-plane"></i> icon-plane</li>
    <li><i class="icon-plug"></i> icon-plug</li>
    <li><i class="icon-plus"></i> icon-plus</li>
    <li><i class="icon-plus-circle"></i> icon-plus-circle</li>
    <li><i class="icon-plus-square"></i> icon-plus-square</li>
    <li><i class="icon-plus-square-o"></i> icon-plus-square-o</li>
    <li><i class="icon-power-off"></i> icon-power-off</li>
    <li><i class="icon-print"></i> icon-print</li>
    <li><i class="icon-puzzle-piece"></i> icon-puzzle-piece</li>
    <li><i class="icon-qrcode"></i> icon-qrcode</li>
    <li><i class="icon-question"></i> icon-question</li>
    <li><i class="icon-question-circle"></i> icon-question-circle</li>
    <li><i class="icon-question-circle-o"></i> icon-question-circle-o</li>
    <li><i class="icon-quote-left"></i> icon-quote-left</li>
    <li><i class="icon-quote-right"></i> icon-quote-right</li>
    <li><i class="icon-random"></i> icon-random</li>
    <li><i class="icon-recycle"></i> icon-recycle</li>
    <li><i class="icon-refresh"></i> icon-refresh</li>
    <li><i class="icon-registered"></i> icon-registered</li>
    <li><i class="icon-reply"></i> icon-reply</li>
    <li><i class="icon-reply-all"></i> icon-reply-all</li>
    <li><i class="icon-retweet"></i> icon-retweet</li>
    <li><i class="icon-road"></i> icon-road</li>
    <li><i class="icon-rocket"></i> icon-rocket</li>
    <li><i class="icon-rss"></i> icon-rss</li>
    <li><i class="icon-rss-square"></i> icon-rss-square</li>
    <li><i class="icon-search"></i> icon-search</li>
    <li><i class="icon-search-minus"></i> icon-search-minus</li>
    <li><i class="icon-search-plus"></i> icon-search-plus</li>
    <li><i class="icon-server"></i> icon-server</li>
    <li><i class="icon-share"></i> icon-share</li>
</ul>
<ul>
    <li><i class="icon-share-alt"></i> icon-share-alt</li>
    <li><i class="icon-share-alt-square"></i> icon-share-alt-square</li>
    <li><i class="icon-share-square"></i> icon-share-square</li>
    <li><i class="icon-share-square-o"></i> icon-share-square-o</li>
    <li><i class="icon-shield"></i> icon-shield</li>
    <li><i class="icon-ship"></i> icon-ship</li>
    <li><i class="icon-shopping-bag"></i> icon-shopping-bag</li>
    <li><i class="icon-shopping-basket"></i> icon-shopping-basket</li>
    <li><i class="icon-shopping-cart"></i> icon-shopping-cart</li>
    <li><i class="icon-sign-in"></i> icon-sign-in</li>
    <li><i class="icon-sign-language"></i> icon-sign-language</li>
    <li><i class="icon-sign-out"></i> icon-sign-out</li>
    <li><i class="icon-signal"></i> icon-signal</li>
    <li><i class="icon-sitemap"></i> icon-sitemap</li>
    <li><i class="icon-sliders"></i> icon-sliders</li>
    <li><i class="icon-smile-o"></i> icon-smile-o</li>
    <li><i class="icon-sort"></i> icon-sort</li>
    <li><i class="icon-sort-alpha-asc"></i> icon-sort-alpha-asc</li>
    <li><i class="icon-sort-alpha-desc"></i> icon-sort-alpha-desc</li>
    <li><i class="icon-sort-amount-asc"></i> icon-sort-amount-asc</li>
    <li><i class="icon-sort-amount-desc"></i> icon-sort-amount-desc</li>
    <li><i class="icon-sort-asc"></i> icon-sort-asc</li>
    <li><i class="icon-sort-desc"></i> icon-sort-desc</li>
    <li><i class="icon-sort-numeric-asc"></i> icon-sort-numeric-asc</li>
    <li><i class="icon-sort-numeric-desc"></i> icon-sort-numeric-desc</li>
    <li><i class="icon-space-shuttle"></i> icon-space-shuttle</li>
    <li><i class="icon-spinner"></i> icon-spinner</li>
    <li><i class="icon-spoon"></i> icon-spoon</li>
    <li><i class="icon-square"></i> icon-square</li>
    <li><i class="icon-square-o"></i> icon-square-o</li>
    <li><i class="icon-star"></i> icon-star</li>
    <li><i class="icon-star-half"></i> icon-star-half</li>
    <li><i class="icon-star-half-o"></i> icon-star-half-o</li>
    <li><i class="icon-star-o"></i> icon-star-o</li>
    <li><i class="icon-sticky-note"></i> icon-sticky-note</li>
    <li><i class="icon-sticky-note-o"></i> icon-sticky-note-o</li>
    <li><i class="icon-street-view"></i> icon-street-view</li>
    <li><i class="icon-suitcase"></i> icon-suitcase</li>
    <li><i class="icon-sun-o"></i> icon-sun-o</li>
    <li><i class="icon-tablet"></i> icon-tablet</li>
    <li><i class="icon-tachometer"></i> icon-tachometer</li>
    <li><i class="icon-tag"></i> icon-tag</li>
    <li><i class="icon-tags"></i> icon-tags</li>
    <li><i class="icon-tasks"></i> icon-tasks</li>
    <li><i class="icon-taxi"></i> icon-taxi</li>
    <li><i class="icon-television"></i> icon-television</li>
    <li><i class="icon-terminal"></i> icon-terminal</li>
    <li><i class="icon-thumb-tack"></i> icon-thumb-tack</li>
    <li><i class="icon-thumbs-down"></i> icon-thumbs-down</li>
    <li><i class="icon-thumbs-o-down"></i> icon-thumbs-o-down</li>
    <li><i class="icon-thumbs-o-up"></i> icon-thumbs-o-up</li>
    <li><i class="icon-thumbs-up"></i> icon-thumbs-up</li>
    <li><i class="icon-ticket"></i> icon-ticket</li>
    <li><i class="icon-times"></i> icon-times</li>
    <li><i class="icon-times-circle"></i> icon-times-circle</li>
    <li><i class="icon-times-circle-o"></i> icon-times-circle-o</li>
    <li><i class="icon-tint"></i> icon-tint</li>
    <li><i class="icon-toggle-off"></i> icon-toggle-off</li>
    <li><i class="icon-toggle-on"></i> icon-toggle-on</li>
    <li><i class="icon-trademark"></i> icon-trademark</li>
    <li><i class="icon-trash"></i> icon-trash</li>
    <li><i class="icon-trash-o"></i> icon-trash-o</li>
    <li><i class="icon-tree"></i> icon-tree</li>
    <li><i class="icon-trophy"></i> icon-trophy</li>
    <li><i class="icon-truck"></i> icon-truck</li>
    <li><i class="icon-tty"></i> icon-tty</li>
    <li><i class="icon-umbrella"></i> icon-umbrella</li>
    <li><i class="icon-universal-access"></i> icon-universal-access</li>
    <li><i class="icon-university"></i> icon-university</li>
    <li><i class="icon-unlock"></i> icon-unlock</li>
    <li><i class="icon-unlock-alt"></i> icon-unlock-alt</li>
    <li><i class="icon-upload"></i> icon-upload</li>
    <li><i class="icon-user"></i> icon-user</li>
    <li><i class="icon-user-plus"></i> icon-user-plus</li>
    <li><i class="icon-user-secret"></i> icon-user-secret</li>
    <li><i class="icon-user-times"></i> icon-user-times</li>
    <li><i class="icon-users"></i> icon-users</li>
    <li><i class="icon-video-camera"></i> icon-video-camera</li>
    <li><i class="icon-volume-control-phone"></i> icon-volume-control-phone</li>
    <li><i class="icon-volume-down"></i> icon-volume-down</li>
    <li><i class="icon-volume-off"></i> icon-volume-off</li>
    <li><i class="icon-volume-up"></i> icon-volume-up</li>
    <li><i class="icon-wheelchair"></i> icon-wheelchair</li>
    <li><i class="icon-wheelchair-alt"></i> icon-wheelchair-alt</li>
    <li><i class="icon-wifi"></i> icon-wifi</li>
    <li><i class="icon-wrench"></i> icon-wrench</li>
</ul>
</div>

### Medical Icons

<div class="category-icons">
<ul>
    <li><i class="icon-ambulance"></i> icon-ambulance</li>
    <li><i class="icon-h-square"></i> icon-h-square</li>
    <li><i class="icon-heart"></i> icon-heart</li>
    <li><i class="icon-heart-o"></i> icon-heart-o</li>
</ul>
<ul>
    <li><i class="icon-heartbeat"></i> icon-heartbeat</li>
    <li><i class="icon-hospital-o"></i> icon-hospital-o</li>
    <li><i class="icon-medkit"></i> icon-medkit</li>
</ul>
<ul>
    <li><i class="icon-plus-square"></i> icon-plus-square</li>
    <li><i class="icon-stethoscope"></i> icon-stethoscope</li>
    <li><i class="icon-user-md"></i> icon-user-md</li>
</ul>
<ul>
    <li><i class="icon-wheelchair"></i> icon-wheelchair</li>
    <li><i class="icon-wheelchair-alt"></i> icon-wheelchair-alt</li>
</ul>
</div>

### Text Editor Icons

<div class="category-icons">
<ul>
    <li><i class="icon-align-center"></i> icon-align-center</li>
    <li><i class="icon-align-justify"></i> icon-align-justify</li>
    <li><i class="icon-align-left"></i> icon-align-left</li>
    <li><i class="icon-align-right"></i> icon-align-right</li>
    <li><i class="icon-bold"></i> icon-bold</li>
    <li><i class="icon-chain-broken"></i> icon-chain-broken</li>
    <li><i class="icon-clipboard"></i> icon-clipboard</li>
    <li><i class="icon-columns"></i> icon-columns</li>
    <li><i class="icon-eraser"></i> icon-eraser</li>
    <li><i class="icon-file"></i> icon-file</li>
    <li><i class="icon-file-o"></i> icon-file-o</li>
</ul>
<ul>
    <li><i class="icon-file-text"></i> icon-file-text</li>
    <li><i class="icon-file-text-o"></i> icon-file-text-o</li>
    <li><i class="icon-files-o"></i> icon-files-o</li>
    <li><i class="icon-floppy-o"></i> icon-floppy-o</li>
    <li><i class="icon-font"></i> icon-font</li>
    <li><i class="icon-header"></i> icon-header</li>
    <li><i class="icon-indent"></i> icon-indent</li>
    <li><i class="icon-italic"></i> icon-italic</li>
    <li><i class="icon-link"></i> icon-link</li>
    <li><i class="icon-list"></i> icon-list</li>
</ul>
<ul>
    <li><i class="icon-list-alt"></i> icon-list-alt</li>
    <li><i class="icon-list-ol"></i> icon-list-ol</li>
    <li><i class="icon-list-ul"></i> icon-list-ul</li>
    <li><i class="icon-outdent"></i> icon-outdent</li>
    <li><i class="icon-paperclip"></i> icon-paperclip</li>
    <li><i class="icon-paragraph"></i> icon-paragraph</li>
    <li><i class="icon-repeat"></i> icon-repeat</li>
    <li><i class="icon-scissors"></i> icon-scissors</li>
    <li><i class="icon-strikethrough"></i> icon-strikethrough</li>
    <li><i class="icon-subscript"></i> icon-subscript</li>
</ul>
<ul>
    <li><i class="icon-superscript"></i> icon-superscript</li>
    <li><i class="icon-table"></i> icon-table</li>
    <li><i class="icon-text-height"></i> icon-text-height</li>
    <li><i class="icon-text-width"></i> icon-text-width</li>
    <li><i class="icon-th"></i> icon-th</li>
    <li><i class="icon-th-large"></i> icon-th-large</li>
    <li><i class="icon-th-list"></i> icon-th-list</li>
    <li><i class="icon-underline"></i> icon-underline</li>
    <li><i class="icon-undo"></i> icon-undo</li>
</ul>
</div>

### Spinner Icons

<div class="category-icons">
<ul>
    <li><i class="icon-circle-o-notch"></i> icon-circle-o-notch</li>
    <li><i class="icon-cog"></i> icon-cog</li>
</ul>
<ul>
    <li><i class="icon-refresh"></i> icon-refresh</li>
</ul>
<ul>
    <li><i class="icon-spinner"></i> icon-spinner</li>
</ul>
<ul>
</ul>
</div>

### File Type Icons

<div class="category-icons">
<ul>
    <li><i class="icon-file"></i> icon-file</li>
    <li><i class="icon-file-archive-o"></i> icon-file-archive-o</li>
    <li><i class="icon-file-audio-o"></i> icon-file-audio-o</li>
    <li><i class="icon-file-code-o"></i> icon-file-code-o</li>
</ul>
<ul>
    <li><i class="icon-file-excel-o"></i> icon-file-excel-o</li>
    <li><i class="icon-file-image-o"></i> icon-file-image-o</li>
    <li><i class="icon-file-o"></i> icon-file-o</li>
</ul>
<ul>
    <li><i class="icon-file-pdf-o"></i> icon-file-pdf-o</li>
    <li><i class="icon-file-powerpoint-o"></i> icon-file-powerpoint-o</li>
    <li><i class="icon-file-text"></i> icon-file-text</li>
</ul>
<ul>
    <li><i class="icon-file-text-o"></i> icon-file-text-o</li>
    <li><i class="icon-file-video-o"></i> icon-file-video-o</li>
    <li><i class="icon-file-word-o"></i> icon-file-word-o</li>
</ul>
</div>

### Directional Icons

<div class="category-icons">
<ul>
    <li><i class="icon-angle-double-down"></i> icon-angle-double-down</li>
    <li><i class="icon-angle-double-left"></i> icon-angle-double-left</li>
    <li><i class="icon-angle-double-right"></i> icon-angle-double-right</li>
    <li><i class="icon-angle-double-up"></i> icon-angle-double-up</li>
    <li><i class="icon-angle-down"></i> icon-angle-down</li>
    <li><i class="icon-angle-left"></i> icon-angle-left</li>
    <li><i class="icon-angle-right"></i> icon-angle-right</li>
    <li><i class="icon-angle-up"></i> icon-angle-up</li>
    <li><i class="icon-arrow-circle-down"></i> icon-arrow-circle-down</li>
    <li><i class="icon-arrow-circle-left"></i> icon-arrow-circle-left</li>
    <li><i class="icon-arrow-circle-o-down"></i> icon-arrow-circle-o-down</li>
    <li><i class="icon-arrow-circle-o-left"></i> icon-arrow-circle-o-left</li>
    <li><i class="icon-arrow-circle-o-right"></i> icon-arrow-circle-o-right</li>
</ul>
<ul>
    <li><i class="icon-arrow-circle-o-up"></i> icon-arrow-circle-o-up</li>
    <li><i class="icon-arrow-circle-right"></i> icon-arrow-circle-right</li>
    <li><i class="icon-arrow-circle-up"></i> icon-arrow-circle-up</li>
    <li><i class="icon-arrow-down"></i> icon-arrow-down</li>
    <li><i class="icon-arrow-left"></i> icon-arrow-left</li>
    <li><i class="icon-arrow-right"></i> icon-arrow-right</li>
    <li><i class="icon-arrow-up"></i> icon-arrow-up</li>
    <li><i class="icon-arrows"></i> icon-arrows</li>
    <li><i class="icon-arrows-alt"></i> icon-arrows-alt</li>
    <li><i class="icon-arrows-h"></i> icon-arrows-h</li>
    <li><i class="icon-arrows-v"></i> icon-arrows-v</li>
    <li><i class="icon-caret-down"></i> icon-caret-down</li>
</ul>
<ul>
    <li><i class="icon-caret-left"></i> icon-caret-left</li>
    <li><i class="icon-caret-right"></i> icon-caret-right</li>
    <li><i class="icon-caret-square-o-down"></i> icon-caret-square-o-down</li>
    <li><i class="icon-caret-square-o-left"></i> icon-caret-square-o-left</li>
    <li><i class="icon-caret-square-o-right"></i> icon-caret-square-o-right</li>
    <li><i class="icon-caret-square-o-up"></i> icon-caret-square-o-up</li>
    <li><i class="icon-caret-up"></i> icon-caret-up</li>
    <li><i class="icon-chevron-circle-down"></i> icon-chevron-circle-down</li>
    <li><i class="icon-chevron-circle-left"></i> icon-chevron-circle-left</li>
    <li><i class="icon-chevron-circle-right"></i> icon-chevron-circle-right</li>
    <li><i class="icon-chevron-circle-up"></i> icon-chevron-circle-up</li>
    <li><i class="icon-chevron-down"></i> icon-chevron-down</li>
</ul>
<ul>
    <li><i class="icon-chevron-left"></i> icon-chevron-left</li>
    <li><i class="icon-chevron-right"></i> icon-chevron-right</li>
    <li><i class="icon-chevron-up"></i> icon-chevron-up</li>
    <li><i class="icon-exchange"></i> icon-exchange</li>
    <li><i class="icon-hand-o-down"></i> icon-hand-o-down</li>
    <li><i class="icon-hand-o-left"></i> icon-hand-o-left</li>
    <li><i class="icon-hand-o-right"></i> icon-hand-o-right</li>
    <li><i class="icon-hand-o-up"></i> icon-hand-o-up</li>
    <li><i class="icon-long-arrow-down"></i> icon-long-arrow-down</li>
    <li><i class="icon-long-arrow-left"></i> icon-long-arrow-left</li>
    <li><i class="icon-long-arrow-right"></i> icon-long-arrow-right</li>
    <li><i class="icon-long-arrow-up"></i> icon-long-arrow-up</li>
</ul>
</div>

### Video Player Icons

<div class="category-icons">
<ul>
    <li><i class="icon-arrows-alt"></i> icon-arrows-alt</li>
    <li><i class="icon-backward"></i> icon-backward</li>
    <li><i class="icon-compress"></i> icon-compress</li>
    <li><i class="icon-eject"></i> icon-eject</li>
    <li><i class="icon-expand"></i> icon-expand</li>
    <li><i class="icon-fast-backward"></i> icon-fast-backward</li>
</ul>
<ul>
    <li><i class="icon-fast-forward"></i> icon-fast-forward</li>
    <li><i class="icon-forward"></i> icon-forward</li>
    <li><i class="icon-pause"></i> icon-pause</li>
    <li><i class="icon-pause-circle"></i> icon-pause-circle</li>
    <li><i class="icon-pause-circle-o"></i> icon-pause-circle-o</li>
</ul>
<ul>
    <li><i class="icon-play"></i> icon-play</li>
    <li><i class="icon-play-circle"></i> icon-play-circle</li>
    <li><i class="icon-play-circle-o"></i> icon-play-circle-o</li>
    <li><i class="icon-random"></i> icon-random</li>
    <li><i class="icon-step-backward"></i> icon-step-backward</li>
</ul>
<ul>
    <li><i class="icon-step-forward"></i> icon-step-forward</li>
    <li><i class="icon-stop"></i> icon-stop</li>
    <li><i class="icon-stop-circle"></i> icon-stop-circle</li>
    <li><i class="icon-stop-circle-o"></i> icon-stop-circle-o</li>
    <li><i class="icon-youtube-play"></i> icon-youtube-play</li>
</ul>
</div>

### Form Control Icons

<div class="category-icons">
<ul>
    <li><i class="icon-check-square"></i> icon-check-square</li>
    <li><i class="icon-check-square-o"></i> icon-check-square-o</li>
    <li><i class="icon-circle"></i> icon-circle</li>
</ul>
<ul>
    <li><i class="icon-circle-o"></i> icon-circle-o</li>
    <li><i class="icon-dot-circle-o"></i> icon-dot-circle-o</li>
    <li><i class="icon-minus-square"></i> icon-minus-square</li>
</ul>
<ul>
    <li><i class="icon-minus-square-o"></i> icon-minus-square-o</li>
    <li><i class="icon-plus-square"></i> icon-plus-square</li>
    <li><i class="icon-plus-square-o"></i> icon-plus-square-o</li>
</ul>
<ul>
    <li><i class="icon-square"></i> icon-square</li>
    <li><i class="icon-square-o"></i> icon-square-o</li>
</ul>
</div>

### Transportation Icons

<div class="category-icons">
<ul>
    <li><i class="icon-ambulance"></i> icon-ambulance</li>
    <li><i class="icon-bicycle"></i> icon-bicycle</li>
    <li><i class="icon-bus"></i> icon-bus</li>
    <li><i class="icon-car"></i> icon-car</li>
    <li><i class="icon-fighter-jet"></i> icon-fighter-jet</li>
</ul>
<ul>
    <li><i class="icon-motorcycle"></i> icon-motorcycle</li>
    <li><i class="icon-plane"></i> icon-plane</li>
    <li><i class="icon-rocket"></i> icon-rocket</li>
    <li><i class="icon-ship"></i> icon-ship</li>
</ul>
<ul>
    <li><i class="icon-space-shuttle"></i> icon-space-shuttle</li>
    <li><i class="icon-subway"></i> icon-subway</li>
    <li><i class="icon-taxi"></i> icon-taxi</li>
    <li><i class="icon-train"></i> icon-train</li>
</ul>
<ul>
    <li><i class="icon-truck"></i> icon-truck</li>
    <li><i class="icon-wheelchair"></i> icon-wheelchair</li>
    <li><i class="icon-wheelchair-alt"></i> icon-wheelchair-alt</li>
</ul>
</div>

### Chart Icons

<div class="category-icons">
<ul>
    <li><i class="icon-area-chart"></i> icon-area-chart</li>
    <li><i class="icon-bar-chart"></i> icon-bar-chart</li>
</ul>
<ul>
    <li><i class="icon-line-chart"></i> icon-line-chart</li>
</ul>
<ul>
    <li><i class="icon-pie-chart"></i> icon-pie-chart</li>
</ul>
<ul>
</ul>
</div>

### Brand Icons

<div class="category-icons">
<ul>
    <li><i class="icon-500px"></i> icon-500px</li>
    <li><i class="icon-adn"></i> icon-adn</li>
    <li><i class="icon-amazon"></i> icon-amazon</li>
    <li><i class="icon-android"></i> icon-android</li>
    <li><i class="icon-angellist"></i> icon-angellist</li>
    <li><i class="icon-apple"></i> icon-apple</li>
    <li><i class="icon-behance"></i> icon-behance</li>
    <li><i class="icon-behance-square"></i> icon-behance-square</li>
    <li><i class="icon-bitbucket"></i> icon-bitbucket</li>
    <li><i class="icon-bitbucket-square"></i> icon-bitbucket-square</li>
    <li><i class="icon-black-tie"></i> icon-black-tie</li>
    <li><i class="icon-bluetooth"></i> icon-bluetooth</li>
    <li><i class="icon-bluetooth-b"></i> icon-bluetooth-b</li>
    <li><i class="icon-btc"></i> icon-btc</li>
    <li><i class="icon-buysellads"></i> icon-buysellads</li>
    <li><i class="icon-cc-amex"></i> icon-cc-amex</li>
    <li><i class="icon-cc-diners-club"></i> icon-cc-diners-club</li>
    <li><i class="icon-cc-discover"></i> icon-cc-discover</li>
    <li><i class="icon-cc-jcb"></i> icon-cc-jcb</li>
    <li><i class="icon-cc-mastercard"></i> icon-cc-mastercard</li>
    <li><i class="icon-cc-paypal"></i> icon-cc-paypal</li>
    <li><i class="icon-cc-stripe"></i> icon-cc-stripe</li>
    <li><i class="icon-cc-visa"></i> icon-cc-visa</li>
    <li><i class="icon-chrome"></i> icon-chrome</li>
    <li><i class="icon-codepen"></i> icon-codepen</li>
    <li><i class="icon-codiepie"></i> icon-codiepie</li>
    <li><i class="icon-connectdevelop"></i> icon-connectdevelop</li>
    <li><i class="icon-contao"></i> icon-contao</li>
    <li><i class="icon-css3"></i> icon-css3</li>
    <li><i class="icon-dashcube"></i> icon-dashcube</li>
    <li><i class="icon-delicious"></i> icon-delicious</li>
    <li><i class="icon-deviantart"></i> icon-deviantart</li>
    <li><i class="icon-digg"></i> icon-digg</li>
    <li><i class="icon-dribbble"></i> icon-dribbble</li>
    <li><i class="icon-dropbox"></i> icon-dropbox</li>
    <li><i class="icon-drupal"></i> icon-drupal</li>
    <li><i class="icon-edge"></i> icon-edge</li>
    <li><i class="icon-empire"></i> icon-empire</li>
    <li><i class="icon-envira"></i> icon-envira</li>
    <li><i class="icon-expeditedssl"></i> icon-expeditedssl</li>
    <li><i class="icon-facebook"></i> icon-facebook</li>
    <li><i class="icon-facebook-official"></i> icon-facebook-official</li>
</ul>
<ul>
    <li><i class="icon-facebook-square"></i> icon-facebook-square</li>
    <li><i class="icon-firefox"></i> icon-firefox</li>
    <li><i class="icon-first-order"></i> icon-first-order</li>
    <li><i class="icon-flickr"></i> icon-flickr</li>
    <li><i class="icon-font-awesome"></i> icon-font-awesome</li>
    <li><i class="icon-fonticons"></i> icon-fonticons</li>
    <li><i class="icon-fort-awesome"></i> icon-fort-awesome</li>
    <li><i class="icon-forumbee"></i> icon-forumbee</li>
    <li><i class="icon-foursquare"></i> icon-foursquare</li>
    <li><i class="icon-get-pocket"></i> icon-get-pocket</li>
    <li><i class="icon-gg"></i> icon-gg</li>
    <li><i class="icon-gg-circle"></i> icon-gg-circle</li>
    <li><i class="icon-git"></i> icon-git</li>
    <li><i class="icon-git-square"></i> icon-git-square</li>
    <li><i class="icon-github"></i> icon-github</li>
    <li><i class="icon-github-alt"></i> icon-github-alt</li>
    <li><i class="icon-github-square"></i> icon-github-square</li>
    <li><i class="icon-gitlab"></i> icon-gitlab</li>
    <li><i class="icon-glide"></i> icon-glide</li>
    <li><i class="icon-glide-g"></i> icon-glide-g</li>
    <li><i class="icon-google"></i> icon-google</li>
    <li><i class="icon-google-plus"></i> icon-google-plus</li>
    <li><i class="icon-google-plus-official"></i> icon-google-plus-official</li>
    <li><i class="icon-google-plus-square"></i> icon-google-plus-square</li>
    <li><i class="icon-google-wallet"></i> icon-google-wallet</li>
    <li><i class="icon-gratipay"></i> icon-gratipay</li>
    <li><i class="icon-hacker-news"></i> icon-hacker-news</li>
    <li><i class="icon-houzz"></i> icon-houzz</li>
    <li><i class="icon-html5"></i> icon-html5</li>
    <li><i class="icon-instagram"></i> icon-instagram</li>
    <li><i class="icon-internet-explorer"></i> icon-internet-explorer</li>
    <li><i class="icon-ioxhost"></i> icon-ioxhost</li>
    <li><i class="icon-joomla"></i> icon-joomla</li>
    <li><i class="icon-jsfiddle"></i> icon-jsfiddle</li>
    <li><i class="icon-lastfm"></i> icon-lastfm</li>
    <li><i class="icon-lastfm-square"></i> icon-lastfm-square</li>
    <li><i class="icon-leanpub"></i> icon-leanpub</li>
    <li><i class="icon-linkedin"></i> icon-linkedin</li>
    <li><i class="icon-linkedin-square"></i> icon-linkedin-square</li>
    <li><i class="icon-linux"></i> icon-linux</li>
    <li><i class="icon-maxcdn"></i> icon-maxcdn</li>
</ul>
<ul>
    <li><i class="icon-meanpath"></i> icon-meanpath</li>
    <li><i class="icon-medium"></i> icon-medium</li>
    <li><i class="icon-mixcloud"></i> icon-mixcloud</li>
    <li><i class="icon-modx"></i> icon-modx</li>
    <li><i class="icon-odnoklassniki"></i> icon-odnoklassniki</li>
    <li><i class="icon-odnoklassniki-square"></i> icon-odnoklassniki-square</li>
    <li><i class="icon-opencart"></i> icon-opencart</li>
    <li><i class="icon-openid"></i> icon-openid</li>
    <li><i class="icon-opera"></i> icon-opera</li>
    <li><i class="icon-optin-monster"></i> icon-optin-monster</li>
    <li><i class="icon-pagelines"></i> icon-pagelines</li>
    <li><i class="icon-paypal"></i> icon-paypal</li>
    <li><i class="icon-pied-piper"></i> icon-pied-piper</li>
    <li><i class="icon-pied-piper-alt"></i> icon-pied-piper-alt</li>
    <li><i class="icon-pied-piper-pp"></i> icon-pied-piper-pp</li>
    <li><i class="icon-pinterest"></i> icon-pinterest</li>
    <li><i class="icon-pinterest-p"></i> icon-pinterest-p</li>
    <li><i class="icon-pinterest-square"></i> icon-pinterest-square</li>
    <li><i class="icon-product-hunt"></i> icon-product-hunt</li>
    <li><i class="icon-qq"></i> icon-qq</li>
    <li><i class="icon-rebel"></i> icon-rebel</li>
    <li><i class="icon-reddit"></i> icon-reddit</li>
    <li><i class="icon-reddit-alien"></i> icon-reddit-alien</li>
    <li><i class="icon-reddit-square"></i> icon-reddit-square</li>
    <li><i class="icon-renren"></i> icon-renren</li>
    <li><i class="icon-safari"></i> icon-safari</li>
    <li><i class="icon-scribd"></i> icon-scribd</li>
    <li><i class="icon-sellsy"></i> icon-sellsy</li>
    <li><i class="icon-share-alt"></i> icon-share-alt</li>
    <li><i class="icon-share-alt-square"></i> icon-share-alt-square</li>
    <li><i class="icon-shirtsinbulk"></i> icon-shirtsinbulk</li>
    <li><i class="icon-simplybuilt"></i> icon-simplybuilt</li>
    <li><i class="icon-skyatlas"></i> icon-skyatlas</li>
    <li><i class="icon-skype"></i> icon-skype</li>
    <li><i class="icon-slack"></i> icon-slack</li>
    <li><i class="icon-slideshare"></i> icon-slideshare</li>
    <li><i class="icon-snapchat"></i> icon-snapchat</li>
    <li><i class="icon-snapchat-ghost"></i> icon-snapchat-ghost</li>
    <li><i class="icon-snapchat-square"></i> icon-snapchat-square</li>
    <li><i class="icon-soundcloud"></i> icon-soundcloud</li>
    <li><i class="icon-spotify"></i> icon-spotify</li>
</ul>
<ul>
    <li><i class="icon-stack-exchange"></i> icon-stack-exchange</li>
    <li><i class="icon-stack-overflow"></i> icon-stack-overflow</li>
    <li><i class="icon-steam"></i> icon-steam</li>
    <li><i class="icon-steam-square"></i> icon-steam-square</li>
    <li><i class="icon-stumbleupon"></i> icon-stumbleupon</li>
    <li><i class="icon-stumbleupon-circle"></i> icon-stumbleupon-circle</li>
    <li><i class="icon-tencent-weibo"></i> icon-tencent-weibo</li>
    <li><i class="icon-themeisle"></i> icon-themeisle</li>
    <li><i class="icon-trello"></i> icon-trello</li>
    <li><i class="icon-tripadvisor"></i> icon-tripadvisor</li>
    <li><i class="icon-tumblr"></i> icon-tumblr</li>
    <li><i class="icon-tumblr-square"></i> icon-tumblr-square</li>
    <li><i class="icon-twitch"></i> icon-twitch</li>
    <li><i class="icon-twitter"></i> icon-twitter</li>
    <li><i class="icon-twitter-square"></i> icon-twitter-square</li>
    <li><i class="icon-usb"></i> icon-usb</li>
    <li><i class="icon-viacoin"></i> icon-viacoin</li>
    <li><i class="icon-viadeo"></i> icon-viadeo</li>
    <li><i class="icon-viadeo-square"></i> icon-viadeo-square</li>
    <li><i class="icon-vimeo"></i> icon-vimeo</li>
    <li><i class="icon-vimeo-square"></i> icon-vimeo-square</li>
    <li><i class="icon-vine"></i> icon-vine</li>
    <li><i class="icon-vk"></i> icon-vk</li>
    <li><i class="icon-weibo"></i> icon-weibo</li>
    <li><i class="icon-weixin"></i> icon-weixin</li>
    <li><i class="icon-whatsapp"></i> icon-whatsapp</li>
    <li><i class="icon-wikipedia-w"></i> icon-wikipedia-w</li>
    <li><i class="icon-windows"></i> icon-windows</li>
    <li><i class="icon-wordpress"></i> icon-wordpress</li>
    <li><i class="icon-wpbeginner"></i> icon-wpbeginner</li>
    <li><i class="icon-wpforms"></i> icon-wpforms</li>
    <li><i class="icon-xing"></i> icon-xing</li>
    <li><i class="icon-xing-square"></i> icon-xing-square</li>
    <li><i class="icon-y-combinator"></i> icon-y-combinator</li>
    <li><i class="icon-yahoo"></i> icon-yahoo</li>
    <li><i class="icon-yelp"></i> icon-yelp</li>
    <li><i class="icon-yoast"></i> icon-yoast</li>
    <li><i class="icon-youtube"></i> icon-youtube</li>
    <li><i class="icon-youtube-play"></i> icon-youtube-play</li>
    <li><i class="icon-youtube-square"></i> icon-youtube-square</li>
</ul>
</div>

### Hand Icons

<div class="category-icons">
<ul>
    <li><i class="icon-hand-lizard-o"></i> icon-hand-lizard-o</li>
    <li><i class="icon-hand-o-down"></i> icon-hand-o-down</li>
    <li><i class="icon-hand-o-left"></i> icon-hand-o-left</li>
    <li><i class="icon-hand-o-right"></i> icon-hand-o-right</li>
</ul>
<ul>
    <li><i class="icon-hand-o-up"></i> icon-hand-o-up</li>
    <li><i class="icon-hand-paper-o"></i> icon-hand-paper-o</li>
    <li><i class="icon-hand-peace-o"></i> icon-hand-peace-o</li>
    <li><i class="icon-hand-pointer-o"></i> icon-hand-pointer-o</li>
</ul>
<ul>
    <li><i class="icon-hand-rock-o"></i> icon-hand-rock-o</li>
    <li><i class="icon-hand-scissors-o"></i> icon-hand-scissors-o</li>
    <li><i class="icon-hand-spock-o"></i> icon-hand-spock-o</li>
    <li><i class="icon-thumbs-down"></i> icon-thumbs-down</li>
</ul>
<ul>
    <li><i class="icon-thumbs-o-down"></i> icon-thumbs-o-down</li>
    <li><i class="icon-thumbs-o-up"></i> icon-thumbs-o-up</li>
    <li><i class="icon-thumbs-up"></i> icon-thumbs-up</li>
</ul>
</div>

### Payment Icons

<div class="category-icons">
<ul>
    <li><i class="icon-cc-amex"></i> icon-cc-amex</li>
    <li><i class="icon-cc-diners-club"></i> icon-cc-diners-club</li>
    <li><i class="icon-cc-discover"></i> icon-cc-discover</li>
    <li><i class="icon-cc-jcb"></i> icon-cc-jcb</li>
</ul>
<ul>
    <li><i class="icon-cc-mastercard"></i> icon-cc-mastercard</li>
    <li><i class="icon-cc-paypal"></i> icon-cc-paypal</li>
    <li><i class="icon-cc-stripe"></i> icon-cc-stripe</li>
</ul>
<ul>
    <li><i class="icon-cc-visa"></i> icon-cc-visa</li>
    <li><i class="icon-credit-card"></i> icon-credit-card</li>
    <li><i class="icon-credit-card-alt"></i> icon-credit-card-alt</li>
</ul>
<ul>
    <li><i class="icon-google-wallet"></i> icon-google-wallet</li>
    <li><i class="icon-paypal"></i> icon-paypal</li>
</ul>
</div>

### Currency Icons

<div class="category-icons">
<ul>
    <li><i class="icon-btc"></i> icon-btc</li>
    <li><i class="icon-eur"></i> icon-eur</li>
    <li><i class="icon-gbp"></i> icon-gbp</li>
    <li><i class="icon-gg"></i> icon-gg</li>
</ul>
<ul>
    <li><i class="icon-gg-circle"></i> icon-gg-circle</li>
    <li><i class="icon-ils"></i> icon-ils</li>
    <li><i class="icon-inr"></i> icon-inr</li>
</ul>
<ul>
    <li><i class="icon-jpy"></i> icon-jpy</li>
    <li><i class="icon-krw"></i> icon-krw</li>
    <li><i class="icon-money"></i> icon-money</li>
</ul>
<ul>
    <li><i class="icon-rub"></i> icon-rub</li>
    <li><i class="icon-try"></i> icon-try</li>
    <li><i class="icon-usd"></i> icon-usd</li>
</ul>
</div>

### Accessibility Icons

<div class="category-icons">
<ul>
    <li><i class="icon-american-sign-language-interpreting"></i> icon-american-sign-language-interpreting</li>
    <li><i class="icon-assistive-listening-systems"></i> icon-assistive-listening-systems</li>
    <li><i class="icon-audio-description"></i> icon-audio-description</li>
    <li><i class="icon-blind"></i> icon-blind</li>
</ul>
<ul>
    <li><i class="icon-braille"></i> icon-braille</li>
    <li><i class="icon-cc"></i> icon-cc</li>
    <li><i class="icon-deaf"></i> icon-deaf</li>
    <li><i class="icon-low-vision"></i> icon-low-vision</li>
</ul>
<ul>
    <li><i class="icon-question-circle-o"></i> icon-question-circle-o</li>
    <li><i class="icon-sign-language"></i> icon-sign-language</li>
    <li><i class="icon-tty"></i> icon-tty</li>
    <li><i class="icon-universal-access"></i> icon-universal-access</li>
</ul>
<ul>
    <li><i class="icon-volume-control-phone"></i> icon-volume-control-phone</li>
    <li><i class="icon-wheelchair"></i> icon-wheelchair</li>
    <li><i class="icon-wheelchair-alt"></i> icon-wheelchair-alt</li>
</ul>
</div>

### Gender Icons

<div class="category-icons">
<ul>
    <li><i class="icon-genderless"></i> icon-genderless</li>
    <li><i class="icon-mars"></i> icon-mars</li>
    <li><i class="icon-mars-double"></i> icon-mars-double</li>
    <li><i class="icon-mars-stroke"></i> icon-mars-stroke</li>
</ul>
<ul>
    <li><i class="icon-mars-stroke-h"></i> icon-mars-stroke-h</li>
    <li><i class="icon-mars-stroke-v"></i> icon-mars-stroke-v</li>
    <li><i class="icon-mercury"></i> icon-mercury</li>
</ul>
<ul>
    <li><i class="icon-neuter"></i> icon-neuter</li>
    <li><i class="icon-transgender"></i> icon-transgender</li>
    <li><i class="icon-transgender-alt"></i> icon-transgender-alt</li>
</ul>
<ul>
    <li><i class="icon-venus"></i> icon-venus</li>
    <li><i class="icon-venus-double"></i> icon-venus-double</li>
    <li><i class="icon-venus-mars"></i> icon-venus-mars</li>
</ul>
</div>

<!-- Styles -->
<style>
.category-icons {
    overflow: hidden;
}
.category-icons > ul {
    list-style-type: none;
    padding: 0;
    margin: 0;
    width: 25%;
    float: left;
}
.category-icons > ul > li {
    line-height: 42px;
    height: 42px;
    padding: 0;
    margin: 0;
    padding-left: 12px;
    overflow: hidden;
    font-size: 11px;
}
.category-icons > ul > li [class^="icon-"],
.category-icons > ul > li [class*=" icon-"] {
    width: 32px;
    font-size: 16px;
    float: right;
    line-height: 42px;
    margin-right: 5px;
}
.category-icons > ul > li:hover {
    background-color: #fbf4f4;
}
.category-icons > ul > li:hover [class^="icon-"]:before,
.category-icons > ul > li:hover [class*=" icon-"]:before {
    font-size: 28px;
    vertical-align: middle;
}
</style>


<!-- PHP code for outputting icons -->
<!--
    <?php

    $iconYaml = <<<ESC
    ... place yaml content here...
    ESC;
    $array = Yaml::parse($iconYaml);
    $categories = [];
    foreach ($array['icons'] as $icon) {
        foreach ($icon['categories'] as $category) {
            $categories[$category][] = $icon['id'];
        }
    }

    $result = [];
    foreach ($categories as $name => &$cat) {
        sort($cat);

        $result[] = PHP_EOL.'### '.$name.PHP_EOL;

        $break = count($cat) / 4;

        $cnt = 0;
        $result[] = '<div class="category-icons">';
        foreach ([1, 2, 3, 4] as $b) {
            $end = $break * $b;
            $result[] = '<ul>';
            while ($cnt <= $end) {
                if (!isset($cat[$cnt])) break;
                $icon = $cat[$cnt];
                $result[] = '    <li><i class="icon-'.$icon.'"></i> icon-'.$icon.'</li>';
                $cnt++;
            }
            $result[] = '</ul>';
        }
        $result[] = '</div>';
    }

    echo '<textarea>'.implode(PHP_EOL, $result).'</textarea>';
    ?>
-->