# 第1章 机器学习基础

![机器学习基础_首页](/images/1.MLFoundation/机器学习基础-首页.jpg)


## 机器学习 概述

`机器学习`就是把无序的数据转换成有用的信息。
1. 获取海量的数据
2. 从海量数据中获取有用的信息

我们会利用计算机来彰显数据背后的真实含义，这才是`机器学习`的意义。

## 机器学习 场景

```
例如：识别动物猫
模式识别（官方标准）：人们通过大量的经验，得到结论，从而判断它就是猫。
机器学习（数据学习）：人们通过阅读进行学习，观察它会叫、小眼睛、两只耳朵、四条腿、一条尾巴，得到结论，从而判断它就是猫。
深度学习（深入数据）：人们通过深入了解它，发现它会'喵喵'的叫、与同类的猫科动物很类似，得到结论，从而判断它就是猫。（深度学习常用领域：语音识别、图像识别）

模式识别（pattern recognition）: 模式识别是最古老的（作为一个术语而言，可以说是很过时的）。
    我们把环境与客体统称为“模式”，识别是对模式的一种认知，是如何让一个计算机程序去做一些看起来很“智能”的事情。
    通过融于智慧和直觉后，通过构建程序，识别一些事物，而不是人，例如: 识别数字。
机器学习（machine learning）: 机器学习是最基础的（当下初创公司和研究实验室的热点领域之一）。
    在90年代初，人们开始意识到一种可以更有效地构建模式识别算法的方法，那就是用数据（可以通过廉价劳动力采集获得）去替换专家（具有很多图像方面知识的人）。
    “机器学习”强调的是，在给计算机程序（或者机器）输入一些数据后，它必须做一些事情，那就是学习这些数据，而这个学习的步骤是明确的。
    机器学习（Machine Learning）是一门专门研究计算机怎样模拟或实现人类的学习行为，以获取新的知识或技能，重新组织已有的知识结构使之不断改善自身性能的学科。
深度学习（deep learning）: 深度学习是非常崭新和有影响力的前沿领域，我们甚至不会去思考-后深度学习时代。
    深度学习是机器学习研究中的一个新的领域，其动机在于建立、模拟人脑进行分析学习的神经网络，它模仿人脑的机制来解释数据，例如图像，声音和文本。

参考地址： 
http://www.csdn.net/article/2015-03-24/2824301
http://baike.baidu.com/link?url=76P-uA4EBrC3G-I__P1tqeO7eoDS709Kp4wYuHxc7GNkz_xn0NxuAtEohbpey7LUa2zUQLJxvIKUx4bnrEfOmsWLKbDmvG1PCoRkJisMTQka6-QReTrIxdYY3v93f55q
```

> 机器学习已应用于多个领域，远远超出大多数人的想象，横跨：计算机科学、工程技术和统计学等多个学科。

* 搜索引擎: 根据你的搜索点击，优化你下次的搜索结果。
* 垃圾邮件: 会自动的过滤垃圾广告邮件到垃圾箱内。
* 超市优惠券: 你会发现，你在购买小孩子尿布的时候，售货员会赠送你一张优惠券可以兑换6罐啤酒。
* 邮局邮寄: 手写软件自动识别寄送贺卡的地址。
* 申请贷款: 通过你最近的金融活动信息进行综合评定，决定你是否合格。


## 机器学习 组成

### 主要任务

* 分类：将实例数据划分到合适的类别中。
* 回归：主要用于预测数值型数据。（示例：数据通过给定数据点来拟合最优曲线）

### 监督学习

* 必须确定目标变量的值，以便机器学习算法可以发现特征和目标变量之间的关系。 (包括：分类和回归)
* 样本集：训练数据 + 测试数据
    * 训练样本 = 特征(feature) + 目标变量(label: 分类-离散值/回归-连续值)
    * 特征通常是训练样本集的列，它们是独立测量得到的。
    * 目标变量: 目标变量是机器学习预测算法的测试结果。
        * 在分类算法中目标变量的类型通常是标称型(如：真与假)，而在回归算法中通常是连续型(如：1~100)。
* `知识表示`：
    1. 可以采用规则集的形式【例如：数学成绩大于90分为优秀】
    2. 可以采用概率分布的形式【例如：通过统计分布发现，90%的同学数学成绩，在70分以下，那么大于70分定为优秀】
    3. 可以使用训练样本集中的一个实例【例如：通过样本集合，我们训练出一个模型实例，得出 年轻，数学成绩中高等，谈吐优雅，我们认为是优秀】

### 非监督学习

* 数据没有类别信息，也不会给定目标值。
* 聚类：在无监督学习中，将数据集分成由类似的对象组成多个类的过程称为聚类。
* 密度估计：将寻找描述数据统计值的过程称之为密度估计。【就是：根据训练样本确定x的概率分布】
* 此外，无监督学习还可以减少数据特征的维度，以便我们可以使用二维或三维图形更加直观地展示数据信息。

### 训练过程

![机器学习训练过程图](/images/1.MLFoundation/机器学习基础训练过程.jpg)

### 算法汇总

![算法汇总](/images/1.MLFoundation/ml_algorithm.jpg)


## 机器学习 使用

> 选择算法需要考虑的两个问题

1. 算法场景
    * 预测明天是否下雨，因为可以用历史的天气情况做预测，所以选择监督学习算法
    * 给一群陌生的人进行分组，但是我们并没有这些人的类别信息，所以选择无监督学习算法、通过他们身高、体重等特征进行处理。
2. 需要收集或分析的数据是什么

> 举例

![选择算法图](/images/1.MLFoundation/机器学习基础-选择算法.jpg)

> 机器学习 开发流程

```
* 收集数据: 收集样本数据
* 准备数据: 注意数据的格式
* 分析数据: 为了确保数据集中没有垃圾数据；
    如果是算法可以处理的数据格式或可信任的数据源，则可以跳过该步骤；
    另外该步骤需要人工干预，会降低自动化系统的价值。
* 训练算法: [机器学习算法核心]如果使用无监督学习算法，由于不存在目标变量值，则可以跳过该步骤
* 测试算法: [机器学习算法核心]评估算法效果
* 使用算法: 将机器学习算法转为应用程序
```


## Python语言 优势

1. 可执行伪代码
2. Python比较流行：使用广泛、代码范例多、丰富模块库，开发周期短
3. Python语言的特色：清晰简练、易于理解
4. Python语言的缺点：唯一不足的是性能问题
5. Python相关的库
    * 科学函数库：`SciPy`、`NumPy`(底层语言：C和Fortran)
    * 绘图工具库：`Matplotlib`


* * *

* **作者：[片刻](http://cwiki.apachecn.org/display/~jiangzhonglian) [1988](http://cwiki.apachecn.org/display/~lihuisong)**
* [GitHub地址](https://github.com/apachecn/MachineLearning): <https://github.com/apachecn/MachineLearning>
* **版权声明：欢迎转载学习 => 请标注信息来源于 [ApacheCN](http://www.apachecn.org/)**
