---
title: "Uppy 1.6: setOptions(), Icelandic and Thai"
date: 2019-11-13
author: arturi
published: true
---

This release adds a long-awaited `uppy.setOptions()` API, allowing you to update options of Uppy and its plugins on the fly. It also includes locales for the Icelandic and Thai languages!

<!--more-->

## uppy.setOptions()

`.setOptions()` for Uppy and its plugins supports most options that can be easily changed on the fly: `restrictions`, `locale`, Dashboard’s `note` and `metaFields`, `disableThumbnailGenerator`, `showProgressDetails`, etc.

⚠️ Note that some options like `target`, `limit` and `id` cannot be changed on the fly, as internal statefull things depend on them.

Here’s how the magic works:

```js
const uppy = Uppy({
  restrictions: {
    maxNumberOfFiles: 3
  }
})
uppy.use(Dashboard, {
  note: 'You can upload up to 3 files'
})
```

Now, based on some condition in our app, we want to allow more files:

```js
// Updating Uppy options
uppy.setOptions({
  restrictions: {
    maxNumberOfFiles: 5
  }
})
// Updating Dashboard options
uppy.getPlugin('Dashboard').setOptions({ note: 'You can upload up to 5 files' })
```

Say, later on, the user changed their locale and we would like to reflect that in Uppy:

```js
const fi_FI = require('@uppy/locales/lib/fi_FI')
uppy.setOptions({
  locale: fi_FI
})
```

Now, Uppy will bark in Finnish! Hau, hau, hau!

Please see [`uppy.setOptions()` docs](https://uppy.io/docs/uppy/#uppy-setOptions-opts) for details.

## Misc

- @uppy/facebook: In the new Facebook plugin (beta), we now use grid view with big image previews for albums (@ifedapoolarewaju, #1886)
- @uppy/companion: The thumbnail size has been increased for Dropbox (@ifedapoolarewaju, #1917)
- @uppy/dashboard: The retry icons have been fixed on individual files (@goto-bus-stop, #1888)
- @uppy/companion: Support `COMPANION_AWS_ENDPOINT` in aws-companion example so it can be used with other S3-compatible services (@goto-bus-stop, [1ab63aa](https://github.com/transloadit/uppy/commit/1ab63aa395859815871c4e1e62dda6e9ca66595f))
- @uppy/companion: Add S3 useAccelerateEndpoint option (@steverob, #1884)
- @uppy/companion: only set `Access-Control-Allow-Credentials` header when origin is whitelisted (@ifedapoolarewaju, #1901)
- @uppy/transloadit: We now send `Transloadit-Client` header with HTTP API requests (@goto-bus-stop, #1919)
- @uppy/tus: Uploads are now being terminated when cancelling, instead of just pausing and letting them expire (@ifedapoolarewaju, #1909)
- build: Updated Lerna, ESlint, and Jest (@goto-bus-stop)

As always, you can find the full list of changes and package versions, as well as future plans, in our [changelog](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md).
