---
title: "Uppy 1.5: Facebook and OneDrive (beta) support, upload cancellation"
date: 2019-10-11
author: renee
published: true
---

In the past two months, we have halved our open issue count and worked on a much more robust approach to upload cancellation. Members of the community also contributed a bunch of new localizations: Czech, Danish, Greek, Indonesian, and Swedish!

We are also releasing beta versions of new remote providers for Facebook and OneDrive. Please try them out!

<!--more-->

## Issue busting

Our issue tracker was getting pretty full over the past year, topping out at about 120 open issues. Some had been open for months without any reply! Issues were being opened at such a rate that it was almost too much for our small team to handle. So, we sat down to go through everything together and started setting up a process to make sure our issue list doesn't get out of hand again in the future.

When opening a new issue, we now ask you to mark it as a bug or a feature request. The issue will also get a “Triage” label, indicating that an Uppy team member needs to sort it. If there are many “Triage” issues open at any point, we will discuss them in our weekly team call. New issues will also be assigned to a specific team member as soon as possible, so each of us has a much smaller and more manageable list of issues to keep track of.

To keep the issue tracker focused on Uppy features and bugs, detailed support questions should go to Transloadit's [community forum](https://community.transloadit.com/).

## Duplicate files

Up until now, if you added a file that had been already added to Uppy some time before — i.e., a file with the same `name`/`type`/`modifiedDate` etc. — the old file would be silently replaced with a new one. This changes with v1.5:

1. Uppy now throws a warning if a file with the same `file.id` already exist. The new file will not be added and the old file will not be replaced.
2. We are adding the `file.meta.relativePath` to `file.id`. `relativePath` exists on files that have been dropped together with a folder. This means that if you drop a folder with `folder/a.jpg` and `folder/subfolder/a.jpg`, both `a.jpg`s will be added, since they come from different folders and this kind of duplication might be intended.

See PR [#1767](https://github.com/transloadit/uppy/pull/1767) for details.

## Dashboard

Files in the Dashboard no longer have an icon indicating where they came from (local device, GDrive, etc.). We think it's nice for developers to see, but not that useful for most end users. If you want to re-enable it, you can add the following CSS to your app:
```css
.uppy-DashboardItem-sourceIcon { display: inline-block; }
```

The difference is very small. The icons used to be next to the file size, as seen here in Uppy v1.3:
![Uppy Dashboard v1.3, with file source icon](/images/blog/1.5/with-source-icon.png)

Now, in v1.5, they’re gone:
![Uppy Dashboard v1.5, without file source icon](/images/blog/1.5/without-source-icon.png)

Additionally:
* Editing a file now fires `dashboard:file-edit-start` and `dashboard:file-edit-complete` events ([#1776](https://github.com/transloadit/uppy/pull/1776))
* Excessive debug logging is reduced ([#1747](https://github.com/transloadit/uppy/pull/1747))
* Fixes to the TypeScript typings were submitted by @mrbatista and @MatthiasKunnen

## Cancellation

Our old approach to limiting the amount of simultaneous uploads had some problems. Uploads were queued by chaining Promises, but they did not respect cancellation. So, if you cancelled an upload while some files were still waiting to start, those files would actually start uploading even though they had already been removed. Obviously, that's pretty bad!

PR [#1736](https://github.com/transloadit/uppy/pull/1736) addresses this by ripping out the old limiting code and replacing it with a new, cancellation-aware upload queue. We’ve also added a browser test to make sure that this thing stays resilient:

<video alt="Demo video showing an automated Chaos Monkey session with Uppy" muted autoplay loop>
  <source src="/images/blog/1.5/chaos-monkey.webm" type="video/webm">
  <source src="/images/blog/1.5/chaos-monkey.mp4" type="video/mp4">
</video>

## Lerna lerna lerna

In August, we bit the bullet and used Lerna’s `lerna link convert` feature. Now, all the packages in our monorepo depend on each other, using `file:../packagename/` paths instead of version numbers. The entire repository is one big dependency tree in npm's view. Npm can install the entire thing on its own, without `lerna bootstrap`’s help! Since npm manages the entire tree, the `package-lock.json` file in the repository root contains everything we need. We can now use the faster `npm ci` install command on CI, saving more than sixty seconds on every run :tada:

As part of this effort, we also added all our examples to the lerna-managed tree, so you no longer have to do `npm install` in example folders to use them.

This change makes working on the repository much easier, since dependencies are handled in the same way as in any other repository, simply by doing:
```bash
npm install
```

## Localization

Thanks to multiple contributors, Uppy now knows Czech, Danish, Greek, Indonesian, and Swedish, on top of the nineteen languages that were already supported! The Serbian locale is now available in both the Cyrillic and Latin scripts. Big thanks to @achmiral, @arggh, @czj, @jukakoski, @marcusforberg, @nndevstudio, @Pzoco, @Tashows, and @tvaliasek for their efforts ✨

New translations are rolling in every month, but there are plenty more languages out there that Uppy would love to learn. Please consider [contributing your language](/docs/locales/#Contributing-a-new-language) as well!

## Facebook and OneDrive

This release adds two experimental new remote providers: Facebook and OneDrive. For now, they are not available through the `uppy` package. To use them, install `@uppy/facebook` or `@uppy/onedrive`:
```bash
npm install @uppy/facebook
npm install @uppy/onedrive
```

Configure Companion to access the Facebook and OneDrive APIs, using environment variables or the JS API:
```bash
export COMPANION_FACEBOOK_KEY="***"
export COMPANION_FACEBOOK_SECRET="***"
export COMPANION_ONEDRIVE_KEY="***"
export COMPANION_ONEDRIVE_SECRET="***"
```
```js
providerOptions: {
  facebook: {
    key: '',
    secret: ''
  },
  // For OneDrive’s key & secret pair, please use `microsoft` option key
  microsoft: {
    key: '',
    secret: ''
  }
}
```

Then use them like the existing providers:
```js
const Facebook = require('@uppy/facebook')
const OneDrive = require('@uppy/onedrive')
uppy.use(Facebook, { companionUrl: YOUR_COMPANION_URL })
uppy.use(OneDrive, { companionUrl: YOUR_COMPANION_URL })
```

We’re still waiting for our developer keys to be approved, so we don't have working examples on the website yet! We’ll let you know on [Twitter](https://twitter.com/uppy_io) when they’re live.

Once these new providers have been tested for a while, we will release them as 1.0 and include them in the main Uppy and Robodog bundles.

## Revoke Companion’s Provider access on logout

Up until now, when users clicked “logout” after using a remote Provider, such as Google Drive or Dropbox, Uppy would destroy the access token. But on the Provider’s side, Uppy was still allowed access. Should the user click “Connect to Google Drive” again, no extra confirmation was required.

After a discussion in [#1563](https://github.com/transloadit/uppy/issues/1563), we are expanding the logout process. Now, when users log out of remote Providers through Uppy, Companion will destroy the token as before, but also attempt to revoke the access from the corresponding Provider. In the event that the Provider doesn’t support access revoke via it’s API, Uppy will display a helpful message informing users how they can revoke the permissions manually.

See [#1843](https://github.com/transloadit/uppy/pull/1843) for details.

## Misc

- @uppy/aws-s3-multipart: fix queueing behaviors, especially interaction with cancellation (@goto-bus-stop, #1855)
- @uppy/aws-s3: replace browser-only resolve-url by isomorphic url-parse (@goto-bus-stop, #1854)
- @uppy/companion-client: rename serverHeaders to companionHeaders (@goto-bus-stop, #1861)
- @uppy/companion: Fix S3 uploads for URL plugins (#1784 / @@ifedapoolarewaju)
- @uppy/companion: bump lodash.merge to 4.6.2 to fix audit warning (#1796 / @rettgerst)
- @uppy/companion: set allowed HTTP methods internally (#1754 / @ifedapoolarewaju)
- @uppy/companion: whenever an error is returned from Companion: the auth screen will be displayed if the user was never authenticated; if the user is authenticated, the last screen on display before the error will be displayed (#1743 / @ifedapoolarewaju)
- @uppy/core: Made sure we can upload new files if we cancel last file (allowMultipleUploads: false) (#1764 / @lakesare)
- @uppy/core: fix "Cannot read property 'log' of undefined" (#1785 / @theJoeBiz)
- @uppy/core: use setFileState inside retryUpload (#1759 / @goto-bus-stop)
- @uppy/dashboard, @uppy/drag-drop: getDroppedFiles.js: handle exceptions better (#1797 / @lakesare)
- @uppy/form: try/catch parsing, set updatedResult to an empty array when not an array (#1800 / @arturi)
- @uppy/locales: Finnish semantics improved and fixed some typos (#1744 / @jukakoski)
- @uppy/locales: Update sr_RS_Latin.js (#1749 / @nndevstudio)
- @uppy/locales: correct some fr_FR localization strings (#1807 / @czj)
- @uppy/locales: fix typo in Persian locale (@uxitten, #1865)
- @uppy/locales: improve Swedish translation (@marcusforberg, #1859)
- @uppy/thumbnail-generator: add waitForThumbnailsBeforeUpload option, false by default (@arturi, #1803)
- @uppy/transloadit: add limit option, warn about using limit when it’s set to 0. In Uppy 2.0 we’ll set the limit to something sensible (like 10 files) by default. (#1789 / @arturi)
- @uppy/transloadit: pin socket.io version to ES5 compatible one (@goto-bus-stop, https://github.com/transloadit/uppy/commit/5839b655f093edaa778d49b719f7dda063ef79cb)
- @uppy/xhr-upload: Throw an error when trying to upload a remote file with `bundle: true` (#1769 / @arturi)
- build: Fix statefulset update: statefulsets image only should be updated. (#1821 / @kiloreux)
- build: Update eslint to v6 (#1777 / @goto-bus-stop)
- build: ci: tweak job run order (#1740 / @goto-bus-stop)
- core: Made addFile return the file id (#1739 / @eliOcs)
- docs: Link to Transloadit plugin from Robodog Form page (#1810 / @janko)
- docs: Talk about using a custom-file input, instead of the file-input plugin (#1765 / @arturi)
- docs: add “force metafield” to docs and changelog (ab053e7ab266d3a4838069ed23675bb9211e4d1a / @arturi)
- docs: explicitly document supported tus-js-client options (#1755 / @goto-bus-stop)
- docs: fix typo (@leftdevel, #1852)
- docs: redux - mentioned that we can't persist Uppy state (#1793 / @lakesare)
- docs: remove pre-1.0 notice from changelog (@mskelton, #1858)
- docs: talk about marking some files as “already uploaded” (c345cbd58992f7bea9525629c28d38420c6b36a3 / @arturi)
- test: add end-to-end test with retries (@ifedapoolarewaju, #1766)
- tests: e2e: reintroduce e2e test for providers locally (#1706 / @ifedapoolarewaju)
- website: /examples/dragdrop - added more obvious 'file was uploaded' indicator (#1750 / @lakesare)
- website: /examples/xhrupload - more obvious UI, added a list of uploaded files (#1768 / @lakesare)
- website: add new version of hexo-filter-github-emojis (#1783 / @lakesare)
- website: fix docs/locales code escaping and css overflow (5a0055c15d04d97e8a0feb784daa7abe8da1d72d / @arturi)

As always, you can find the full list of changes and package versions, as well as future plans, in our [changelog](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md).
