---
title: "Uppy 1.3: Accessibility and performance, new languages"
date: 2019-08-05
author: arturi
published: true
---

Hi there! We are back after a period of silence following the [Uppy 1.0 release](https://uppy.io/blog/2019/04/1.0/) in the end of April. It was pretty well received by the commnunity and press: we hit the front pages of Hacker News, [Product Hunt](https://www.producthunt.com/posts/uppy-1-0/) and [Reddit](https://www.reddit.com/r/javascript/comments/bhkx5k/uppy_10_your_best_friend_in_file_uploading/). We then started trending and gained over 20,000 stargazers on GitHub, got mentioned by [Smashing Magazine](https://mobile.twitter.com/smashingmag/status/1097870169043546112), [JavaScript Daily](https://twitter.com/JavaScriptDaily/status/1122935583603556352) and [JavaScript Weekly](https://javascriptweekly.com/issues/434). It’s been a crazy ride! We’d like to thank all our contributors and users for their continued support.

It was not all self reflection and celebrations, though, in Uppy Remote Headquaters™ following the `1.0` launch. After some vacation time, we quickly got back to work, releasing Uppy `1.1`, `1.2` and `1.3`. These updates address a lot of issues raised by the community and the team.

This post highlights the most important and exciting changes from those releases: accessibility and performance, thumbnails rotatation, new logger, progress and uploader improvements, Robodog and Companion updates, new languages and more.

<!--more-->

## Accessibility

Our new team member, Evgenia, has been on a roll and together with Artur and Alex, she has been working hard on improving accessiblity in Uppy. Evgenia has come up with something called “superfocus”, which makes sure focus stays on the most relevant button or field in the current view. The `@uppy/provider-views` layouts have been refactored so that checkboxes and labels are accessible. Focus styles have also been improved.

<video alt="Demo video showing Uppy focus management in action" muted autoplay loop>
  <source src="/images/blog/1.3/uppy-focus-demo.webm" type="video/webm">
  <source src="/images/blog/1.3/uppy-focus-demo.mp4" type="video/mp4">
</video>

Other notable accessiblity fixes and improvements:

* An “Add more” caption near the + button has been added to the desktop version of Uppy
* “Copy link” & “Edit” links have been replaced with icons
* All SVGs are now not focusable in IE11
* Pasting works while we’re focused on buttons
* Focus is not lost when state is updated in filter in provider-views or when editing file meta
* Selected checkboxes now persist when moving between folders

⚠️ `@uppy/provider-views` translation strings have been moved from Dashboard to Core. This eliminates a dependency of provider-views upon Dashboard [#1712](https://github.com/transloadit/uppy/pull/1712).

See [#1507](https://github.com/transloadit/uppy/pull/1507), [#1574](https://github.com/transloadit/uppy/pull/1574) and [#1656](https://github.com/transloadit/uppy/pull/1656) for more details.

## Dashboard performance improvements

Renée attacked performance problems in the Dashboard when adding many hundreds of files. Previously, we naively rerendered the entire file list when _any_ file had a change. Now, only the changed file rerenders:

Before:

![slow](https://user-images.githubusercontent.com/1006268/59605307-ce67f580-910e-11e9-992a-6e0c3c2a7570.gif)

After:

![fast](https://user-images.githubusercontent.com/1006268/59605354-e3dd1f80-910e-11e9-9cb3-1b7339650959.gif)

See [#1671](https://github.com/transloadit/uppy/pull/1671) for more details. As you can see, there are still some laggy interactions — expect more improvements in future releases!

## Logger

We’ve added an option to supply a `logger` object with `debug`, `warn` and `error` methods, so you can use a custom logging solution with Uppy. Check out [the docs](https://uppy.io/docs/uppy/#logger) for more information.

In the future, past 2.0, the `logger: Uppy.debugLogger` option is going to replace `debug: true`. The latter will be kept for backwards compatibility for now.

⚠️ Since `@uppy/core@1.2`, the default logger has switched to `console.debug` from `console.log` by default. You might need to change settings in your browser’s devtools to see Uppy logs!

Versions of each Uppy plugin and Core are now also logged for easier debugging.

See [#1661](https://github.com/transloadit/uppy/pull/1661) and [#1640](https://github.com/transloadit/uppy/pull/1640) for more details.

## Thumbnails rotated correctly

Before this change, when you added a file to Uppy from a mobile device, you would sometimes see the preview image sideways. This was because we didn’t account for EXIF rotation metadata when generating thumbnails with `@uppy/thumbnail-generator`. But now, thanks to [@Botz](https://github.com/Botz), we do! See [#1532](https://github.com/transloadit/uppy/pull/1661).

## Progress improvements

* The Status Bar now shows the correct total size of the upload when some files have already finished, instead of jumping down [#1685](https://github.com/transloadit/uppy/pull/1685).
* Fixed an issue where progress could jump to bizarrely high values (like 1038%) while uploading files that don’t have a known size (e.g., pictures from Instagram) [#1610](https://github.com/transloadit/uppy/pull/1610).
* We’ve moved from the `prettier-bytes` package into `@uppy/utils`, and divide by `1024` instead of `1000` to justify `KB` vs `kB` [#1732](https://github.com/transloadit/uppy/pull/1732).

## Drag and drop

* Drag and drop has been refactored internally in both the Dashboard and DragDrop plugins. This means a more robust and cross-browser implementation, with a fancy “drop files here” screen when you drag over the Dashboard.
* The `@uppy/drag-drop` plugin now renders an entirely clickable DnD area.

![](/images/blog/1.3/drag-drop-focus.png)

See [#1440](https://github.com/transloadit/uppy/pull/1440), [#1565](https://github.com/transloadit/uppy/pull/1565) and [#1633](https://github.com/transloadit/uppy/pull/1633) for more details.

## Uploaders

* xhr-upload: we now send along global metadata when `bundle: true` option is set [#1677](https://github.com/transloadit/uppy/pull/1677).
* xhr-upload: type and name are set from file.meta [#1616](https://github.com/transloadit/uppy/pull/1616).
* aws-s3-multipart: added metadata support for S3 MultiPart [#1698](https://github.com/transloadit/uppy/pull/1698).
* aws-s3: allows overriding of getResponseData() [#1647](https://github.com/transloadit/uppy/pull/1647).
* aws-s3: prevents unnecessary delete multiparts request for completed files [#1650](https://github.com/transloadit/uppy/pull/1650).
* aws-s3: do not extract keys from empty `fields` [#1569](https://github.com/transloadit/uppy/pull/1569).
* tus: `metaFields` option has been added to the tus plugin [#1644](https://github.com/transloadit/uppy/pull/1644).

## Localization

Thanks to our amazing contributors, Uppy now speaks: Arabic, Chinese, Dutch, English, Finnish, French, German, Hungarian, Italian, Japanese, Persian, Portuguese, Russian, Serbian, Spanish an Turkish!

New translations are rolling in every month, but there are plenty more languages out there that Uppy would love to learn. Please consider [contributing your language](http://localhost:4000/docs/locales/#Contributing-a-new-language) as well!

We’ve also added docs for locales — how to use from NPM and CDN, auto-generated list of languages that are supported already and an invitation to add more [#1553](https://github.com/transloadit/uppy/pull/1553).

Finally, we’ve fixed an issue that could occur when adding files with names in non-Latin alphabets. When adding a file to Uppy, it gets an ID based on several characteristics, such as its size and file name. Previously, our ID generation would ignore any non-alphanumeric characters in the file name, which could cause the IDs for different files to clash. Now, those characters are worked into the ID, so that multiple similar files with different non-alphanumeric names can be added. See [#1722](https://github.com/transloadit/uppy/pull/1722).

## Robodog

Robodog is an Uppy-based library that helps you talk to the Transloadit API. Since 1.0, most of the updates have been bugfixes:

* `Robodog.dashboard()` and `Robodog.form()` now pass their options to the `@uppy/dashboard` plugin as advertised.
* `Robodog.form()` now supports the [`triggerUploadOnSubmit`](/docs/robodog/form/#Separating-Uploads-from-Form-Submission) option from `@uppy/form`.
* `Robodog.form()` now supports localization of the “Choose files” button it adds in the default configuration.

## Build

* Renée split our test runs into multiple jobs on Travis CI, so unit tests, end-to-end tests and other jobs all run in parallel. This lets us identify issues with failing builds quicker and also slashes total build times by half! 🚀 [#1709](https://github.com/transloadit/uppy/pull/1709).
* Webdriverio, which we use for end-to-end testing, has been updated to v5. This improves a bunch of things and adds a lot of `await`s to our tests [#1675](https://github.com/transloadit/uppy/pull/1675).
* Build dependencies have been upgraded: Babel to v7, Eslint to v5, Jest to v24, Typescript to v3, Postcss to v7 [#1549](https://github.com/transloadit/uppy/pull/1686).
* Fixed tags for docker build [#1579](https://github.com/transloadit/uppy/pull/1579).
* New `uploadcdn` and sync version scripts [#1586](https://github.com/transloadit/uppy/pull/1586) [#1600](https://github.com/transloadit/uppy/pull/1600).

## Website and docs

* Added Community projects — a page with Uppy plugins and integrations developed by the community [#1620](https://github.com/transloadit/uppy/pull/1620). [Add yours](https://github.com/transloadit/uppy/blob/master/website/src/docs/community-projects.md)!
* Custom plugin [example](http://localhost:4000/docs/writing-plugins/#Example-of-a-custom-plugin) — now you have a reference to look at when writing your own plugin for Uppy [#1623](https://github.com/transloadit/uppy/pull/1623).
* Added signature authentication to Transloadit example [#1705](https://github.com/transloadit/uppy/pull/1705).
* Documented Companion’s Auth and Token mechanism [#1540](https://github.com/transloadit/uppy/pull/1540).
* Updated AWS S3 Multipart documentation wrt CORS settings [#1539](https://github.com/transloadit/uppy/pull/1539).

## Companion

Of course, we didn’t forget `@uppy/companion`. It’s getting more robust with every release:

* ⚠️ We are now sending an `uppy-versions` header to Companion. Please see [how to avoid errors if you are using Companion but NOT as standalone](https://github.com/transloadit/uppy/pull/1612#issuecomment-515117137) [#1612](https://github.com/transloadit/uppy/pull/1686).
* Companion now returns mimetypes for Dropbox files [#1599](https://github.com/transloadit/uppy/pull/1599).
* Added colors to logs [#1648](https://github.com/transloadit/uppy/pull/1648).
* Changed oauth access token transport method [#1668](https://github.com/transloadit/uppy/pull/1668).
* Companion now displays truer error during oauth failure [#1702](https://github.com/transloadit/uppy/pull/1702).
* Not logging uppyAuthToken and not sending the error stack to client [#1663](https://github.com/transloadit/uppy/pull/1663).
* Properly loading Instagram user name, removed deprecated dropbox field [#1651](https://github.com/transloadit/uppy/pull/1663) [#1692](https://github.com/transloadit/uppy/pull/1692).
* Return nextPagePath for Drive/Dropbox [#1652](https://github.com/transloadit/uppy/pull/1652).
* Added ability to load secret keys from files [#1632](https://github.com/transloadit/uppy/pull/1632).
* Set upload filename from metadata during uploads [#1587](https://github.com/transloadit/uppy/pull/1587).

## Misc

* ⚠️ form: now excludes own metadata when creating a new upload. There’s also a new option to append results to the input instead of overwriting [#1686](https://github.com/transloadit/uppy/pull/1686).
* core: `relativePath` is added to local files when a directory has been dropped/selected. It is `null` for non-foldered files [#1602](https://github.com/transloadit/uppy/pull/1602).
* core: using `uploadStarted: null` instead of false [#1628](https://github.com/transloadit/uppy/pull/1628).
* status-bar: hide seconds if ETA is more than 1 hour [#1501](https://github.com/transloadit/uppy/pull/1501).
* react: dashboard react component prop typings updated [#1598](https://github.com/transloadit/uppy/pull/1598).
* webcam: Allow definition of MediaRecorder `mimeType` [#1708](https://github.com/transloadit/uppy/pull/1708).

As always, you can find the full list of changes and package versions, as well as future plans, in our [changelog](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md).
