---
title: "Day 23"
date: 2019-04-17
author: samuel
image: "https://uppy.io/images/blog/30daystoliftoff/day23.png"
series: 30 Days to Liftoff
seriesSuffix: 'of 30'
---

Hello and welcome to Day 23 of our '30 Days to Liftoff' blog post challenge. The launch date for **Uppy 1.0** is still set for **April the 25th** and a lot of work is ongoing to make it happen. Let's take a look at the updates for today!

<center><br /><img width="400" src="/images/blog/30daystoliftoff/day23.png"><br /><br /></center>

<!--more-->

- [Artur](https://github.com/arturi) and [Kevin](https://github.com/kvz) **finished** the implementation of [language packs](https://github.com/transloadit/uppy/pull/1443) so that you can now display Uppy in your (user's) local Language. Here is a quick example on how it is intended for use:

```js
// npm install @uppy/locales --save
const russianLocale = require('@uppy/locales/lib/ru_RU')
const uppy = Uppy({
  locale: russianLocale,
})
```

and if you'd use the CDN version of Uppy (instead of bundling and hosting yourself:


```html
<script src="https://transloadit.edgly.net/releases/uppy/v0.30.5/uppy.min.js"></script>
<script src="https://transloadit.edgly.net/releases/uppy/v0.30.5/locales/ru_RU.min.js"></script>
<script>
var uppy = Uppy.Core({ 
  locale: Uppy.locales.ru_RU
})
<script>
```

While the new locale packs weren't finished, we had to reject updates to the old locales, and quickly [became outdated](https://github.com/transloadit/uppy/tree/master/packages/%40uppy/locales/legacy) for which we are very sorry. To all language contributors, we hope you can forgive us, and that you're willing to translate the [updated en_US locale](https://github.com/transloadit/uppy/blob/master/packages/%40uppy/locales/src/en_US.js) to your own language! This time we promise your contributions will make it to 1.0!

- [Alex](https://github.com/nqst) continues to work on a [new design for the uppy.io website](https://github.com/transloadit/uppy/pull/1452).

- [Ife](https://github.com/ifedapoolarewaju) finished updating Companion to report [better progress](https://github.com/transloadit/uppy/pull/1454) when it's downloading something that it needs to upload to an XHR target.

- [Renée](https://github.com/goto-bus-stop) is working on error reporting for the Transloadit plugin as mentioned yesterday, which notifies us of connectivity problems when they occur.

- [Evgenia](https://github.com/lakesare) continues her work on browser compatibility for dropping or pasting URLs.

On that note, Day 23 of our thirty-day challenge comes to an end. Tomorrow looks like it will be another exciting day, so don't hesitate to keep checking up on us via [Twitter](https://twitter.com/uppy_io) or [RSS](https://uppy.io/atom.xml)!
