---
title: "Day 3"
date: 2019-03-28
author: samuel
image: "https://uppy.io/images/blog/30daystoliftoff/day3.jpg"
series: 30 Days to Liftoff
seriesSuffix: 'of 30'
---

Two days ago, we announced the **upcoming launch of Uppy 1.0 on April 25**, kicking off our thirty-day blog post challenge to keep you updated on everything that is going on. Here's day three for you!
 
<!--more-->

We're still mostly busy tying up any remaining loose ends before April 1, when we'll really start our coding speedrun towards 1.0:

<center><img width="400" src="/images/blog/30daystoliftoff/day3.jpg"><br /></center>

## Done

[Artur](https://github.com/arturi) merged two pull requests from [Renée](https://github.com/goto-bus-stop). The [first](https://github.com/transloadit/uppy/pull/1375) one aims to use Transloadit Templates and demo keys for the `transloadit-textarea` example, and the [second](https://github.com/transloadit/uppy/pull/1374) one makes error reporting across different locales more flexible.

Artur also added a [GitHub-comment-inspired demo](/examples/markdown-snippets/). Add a file attachment to your markdown, and it will be uploaded and converted to a thumbnail that's displayed inside your post, no matter the media type (audio turns into artwork, images are resized, videos thumbnailed, etc.). 

[Ife](https://github.com/ifedapoolarewaju) reviewed and merged this [pull request](https://github.com/transloadit/uppy/pull/1366), which updates the callback URIs to reflect their correct location in Companion. Thanks to [HughbertD](https://github.com/HughbertD) for that one!

We also celebrated Evgenia submitting her first two PRs: [one](https://github.com/transloadit/uppy/pull/1382) to make sure that tooltips can no longer overflow inside the Uppy container, and [another](https://github.com/transloadit/uppy/pull/1383) that removes the jumpiness when Uppy loads.

## In Progress

Renée is working hard to fix outdated warnings in our examples. Other than that, the team has been dealing with a Companion issue that invalid access tokens are given out when you select a provider to receive your file from. The aim is to return 401 for invalid access tokens, so that the `/authorized` endpoint can be deprecated. You can track the progress of this issue in its [pull request](https://github.com/transloadit/uppy/pull/1298).

<center><img src="/images/blog/30daystoliftoff/2019-03-27-board02.png"></center>

## To Do

The biggest update that will be part of Uppy 1.0 is support for React Native. Yesterday, Renée, Artur, Ife, [Evgenia](https://github.com/lakesare) and [Kevin](https://github.com/kvz) had a call and talked extensively about what would be needed to have a minimum viable product. They settled on the following six subtasks, which I'm copying directly from their notes: :)

```md
MVP for React Native support should:

- [ ] get a link provider example to work, including showing Companion progress and resumability
- [ ] get its own UI, (re)written for RN
- [ ] make websocket progress from Companion work (see: https://facebook.github.io/react-native/docs/network#websocket-support)
- [ ] have an example with buttons for resumability & a progress bar
- [ ] have resumability support within 20 min (easily tested by disabling WiFi on your workstation while uploading to master.tus.io)
- [ ] have an example with basic file previews (Uppy RN itself likely does not offer previews)
```

That's all the updates I have for you today. See you tomorrow for [Day 4](/blog/2019/03/liftoff-04/) of our 30 Days to Liftoff!

P.S. If you don't want to miss an update, consider [good ol' RSS](https://uppy.io/atom.xml) :)
