---
title: "Uppy 0.17: Restrictions"
date: 2017-07-11
author: arturi
published: true
---

Hi! We are back with yet another Uppy release that contains some often requested features such as file restrictions and better file type detection, alongside a brand new Instagram plugin, UI improvements and more!

<!-- more -->

## ⚠️ File Restrictions 

Something that a few of our biggest fans were asking for, is finally here! Here's the gist of it:

```js
  Uppy({
    debug: true,
    autoProceed: false,
    restrictions: {
      maxFileSize: 300000,
      maxNumberOfFiles: 5,
      minNumberOfFiles: 2,
      allowedFileTypes: ['image/*', 'video/*']
    },
    onBeforeFileAdded: (currentFile, files) => {
      if (currentFile.name === 'my-file.jpg') {
        return Promise.resolve()
      }
      return Promise.reject('This is not the file I was looking for')
    },
    onBeforeUpload: (files) => {
      if (Object.keys(files).length < 2) {
        return Promise.reject('Too few files :(')
      }
      return Promise.resolve()
    }
  })
```

Basically, there are two ways to set restrictions:

1\. Using the `restrictions` object in Uppy's core settings:

```js
restrictions: {
  maxFileSize: 300000,
  maxNumberOfFiles: 5,
  minNumberOfFiles: 2,
  allowedFileTypes: ['image/*', 'video/*']
}
```

Translation: allow only images and videos of any type, a minimum of 2 and maximum of 5 files must be selected, 300kb or less.

`allowedFileTypes` must be an array of strings with supported file mime-types. Anything from [this list](https://www.iana.org/assignments/media-types/media-types.xhtml) should work, as long as Uppy is able to detect it (and Uppy promises to try real hard, see below for details). Both wildcards `video/*` and specicifc types `image/jpeg` are supported!

2\. Using the more advanced callbacks: `onBeforeFileAdded(currentFile, files)`, which fires before a file is added and allows you to run whatever checks you wish against either the single file that is about to be added or all files currently selected / uploaded, and `onBeforeUpload(files)`, where you are able to check stuff before proceeding with the upload.

Basically, use the first option for the simple stuff such as limiting uploads to images or a maximum of three files. Use the second option for things like “we need users to upload 5 photos and an audio file, so we can make a short clip out of it”. Let us know if this suits your needs, we are all 👂ears👂!

Also, a new `note` option has been added to the Dashboard, as a quick and easy way to inform users about the restrictions you choose to set up:

```js
uppy.use(Dashboard, {
  note: 'Images and video only, 300kb or less'
})
```

<img class="border" src="/images/blog/0.17/restrictions-note.jpg">

## 📸 Instagram plugin and UI overhaul

Yes, Instagram is now supported in Uppy, so you can easily import all of your cat, dog and food pictures!

<figure class="wide">
  <img class="border" src="/images/blog/0.17/instagram-ui.jpg">
</figure>

You can try it live in the [Dashboard example](https://uppy.io/examples/dashboard/).

The UI for all “provider” plugins, which is the way we call Google Drive, Dropbox and other external services, have been revamped to make better use of the space.

Files are now selected, or added, on click/tap, rather than double click, which is easier and also works on mobile. 🙀

<img class="border" src="/images/blog/0.17/provider-search.jpg">

## StatusBar

The Dashboard’s StatusBar has been improved. First of all, even though it still comes bundled with the Dashboard like before, it is now a separate plugin that can be used anywhere, like with the Drag and Drop plugin or your own custom thing. Furthermore, it now shows fatal upload errors in addition to the upload / processing / transcoding progress. 💪

In the Dashboard, you can now disable the StatusBar and/or Informer if you don’t need them or want something custom, by setting `disableStatusBar: true` and `disableInformer: true`.

Details: [#217](https://github.com/transloadit/uppy/pull/217)

## Better file type detection

We’ve added a [`file-type`](https://github.com/sindresorhus/file-type) module that helps with figuring out the file type by reading the first magic bytes of the file. If that doesn’t work, we try to use the mime-type provided by the system/browser, and if that is still a dead end, we attempt to figure it out by extension. All in all, this leads to a more robust file type detecting experience. Personally, I’m just happy my Sex and the City 🍸 `.avi` files are now recognized as `video` on a Mac! 

Further details can be found here: [#219](https://github.com/transloadit/uppy/pull/219)

## Extracting metadata from `<form>` inputs

If a plugin’s `target` is a `form` element, we are going to try to extract all the data from that form’s inputs and add it as `meta` to Uppy’s state. That `meta` is then merged with file’s meta when it is being added.

Uppy’s core options have received a new `meta` property, where you can define some metadata from the start, as well as a new `setMeta` method that can be called at any time.

See here for more details: [#238](https://github.com/transloadit/uppy/pull/238) 

## More

- Added a `reset()` method that stops uploads, clears files and totalProgress, and restores things to the way they were on initialization, before user interactions [#226](https://github.com/transloadit/uppy/pull/226)
- Support for headers in Multipart plugin [#224](https://github.com/transloadit/uppy/pull/224)
- Set bytesUploaded/bytesTotal as soon as the file is added, fixes a `NaN` issue [#232](https://github.com/transloadit/uppy/pull/232)

## Release Notes

Here is the full list of changes for version 0.17:

- core: added restrictions — by file type, size, number of files (@arturi)
- provider: improved UI: improve overall look, breadcrumbs, more responsive (@arturi)
- core: css-in-js demos, try template-css (@arturi @goto-bus-stop #239)
- core: added `uppy.reset()` as discussed in #179 (@arturi)
- core: added nanoraf https://github.com/yoshuawuyts/choo/pull/135/files?diff=unified (@goto-bus-stop, @arturi)
- core: file type detection: archives, markdown (possible modules: file-type, identify-filetype) example: http://requirebin.com/?gist=f9bea9602030f1320a227cf7f140c45f, http://stackoverflow.com/a/29672957 (@arturi)
- dashboard: made file icons prettier: https://uppy.io/images/blog/0.16/service-logos.png (@arturi, @nqst / #215)
- fileinput: allow retrieving fields/options from form (@arturi #153)
- server: configurable server port (@ifedapoolarewaju)
- server: added support for custom providers (@ifedapoolarewaju)
- statusbar: also show major errors, add “error” state (@goto-bus-stop)
- statusbar: pre/postprocessing status updates in the StatusBar (@goto-bus-stop, #202)
- statusbar: show status “Upload started...” when the remote upload has begun, but no progress events received yet (@arturi)
- statusbar: work towards extracting StatusBar to a separate plugin, still bundle it with Dashboard (@goto-bus-stop, @arturi)
- tus/uppy-server: support metadata in remote tus uploads (@ifedapoolarewaju, @goto-bus-stop / #210)
- uploaders: added direct-to-s3 upload plugin and test it with the flow to then upload to transloadit, stage 1, WIP (@goto-bus-stop)
- uppy/uppy-server: Made a barely working Instagram Plugin (@ifedapoolarewaju / #21)
- uppy/uppy-server: allow google drive/dropbox non-tus (i.e multipart) remote uploads (@arturi, @ifedapoolarewaju / #205)
- uppy/uppy-server: do not show files that cannot be downloaded from Google Drive (@ifedapoolarewaju)
- uppy: fixed Google Drive uploads on mobile (double click issue) (@arturi)
- core: updated prettier-bytes to fix the IE support issue https://github.com/Flet/prettier-bytes/issues/3 (@arturi)
- core: use URL.createObjectURL instead of resizing thumbnails (@arturi, @goto-bus-stop / #199)
- dashboard: fixed ETA when multiple files are being uploaded (@goto-bus-stop, #197)
- transloadit: fixed receiving assembly results that are not related to an input file (@arturi, @goto-bus-stop / #201)
- transloadit: use the `tus_upload_url` to reliably link assembly results with their input files (@goto-bus-stop / #207)
- transloadit: moved user-facing strings into locale option (@goto-bus-stop / https://github.com/transloadit/uppy/commit/87a22e7ee37b6fa3754fa34868516a6700306b60)
- webcam: mute audio in realtime playback (@goto-bus-stop / #196)
- temporarily downgrade yo-yoify, until shama/yo-yoify#45 is resolved (@arturi / https://github.com/transloadit/uppy/commit/6292b96)

Enjoy!

The Uppy Team
